/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.widgets;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;

import com.smartgwt.logicalstructure.core.*;
import com.smartgwt.logicalstructure.widgets.*;
import com.smartgwt.logicalstructure.widgets.drawing.*;
import com.smartgwt.logicalstructure.widgets.plugins.*;
import com.smartgwt.logicalstructure.widgets.form.*;
import com.smartgwt.logicalstructure.widgets.tile.*;
import com.smartgwt.logicalstructure.widgets.grid.*;
import com.smartgwt.logicalstructure.widgets.chart.*;
import com.smartgwt.logicalstructure.widgets.layout.*;
import com.smartgwt.logicalstructure.widgets.menu.*;
import com.smartgwt.logicalstructure.widgets.rte.*;
import com.smartgwt.logicalstructure.widgets.ace.*;
import com.smartgwt.logicalstructure.widgets.tab.*;
import com.smartgwt.logicalstructure.widgets.tableview.*;
import com.smartgwt.logicalstructure.widgets.toolbar.*;
import com.smartgwt.logicalstructure.widgets.tree.*;
import com.smartgwt.logicalstructure.widgets.viewer.*;
import com.smartgwt.logicalstructure.widgets.calendar.*;
import com.smartgwt.logicalstructure.widgets.cube.*;
import com.smartgwt.logicalstructure.widgets.tools.*;
import com.smartgwt.logicalstructure.widgets.tour.*;
import com.smartgwt.logicalstructure.widgets.ai.*;

/**
 * Base class for drop zones that accept HTML5 drag-and-drop of files and/or content. <P> DropZone extends Label
 * (StatefulCanvas), providing standard state-based styling for drag interactions. Subclasses can accept file drops ({@link
 * com.smartgwt.client.widgets.DropZone#getCanDropFiles canDropFiles}), content drops ({@link
 * com.smartgwt.client.widgets.DropZone#getCanDropContent canDropContent}), or both. <P> For file-specific features like
 * thumbnails, progress bars, and rich validation, see {@link com.smartgwt.client.widgets.FileDropZone}. For skin snapshot
 * import, see SkinSnapshotDropZone.
 */
@BeanFactory.FrameworkClass
@BeanFactory.ScClassName("DropZone")
public class DropZone extends Label {

    public static DropZone getOrCreateRef(JavaScriptObject jsObj) {
        if (jsObj == null) return null;
        final BaseWidget refInstance = BaseWidget.getRef(jsObj);
        if (refInstance == null) {
            return new DropZone(jsObj);
        } else {
            assert refInstance instanceof DropZone;
            return (DropZone)refInstance;
        }
    }
        


    /**
     * Changes the defaults for Canvas AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults Canvas defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.  For usage tips on this
     * param, see {@link com.smartgwt.client.docs.SGWTProperties}.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, Canvas defaults) /*-{
        if (defaults.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(DropZone.@java.lang.Object::getClass()(), "changeAutoChildDefaults", "Canvas");
        }
        defaults.@com.smartgwt.client.widgets.BaseWidget::setConfigOnly(Z)(true);
        var cleanDefaultsJS = @com.smartgwt.client.util.JSOHelper::cleanProperties(Lcom/google/gwt/core/client/JavaScriptObject;Z)(defaults.@com.smartgwt.client.widgets.BaseWidget::getConfig()(), true);
        $wnd.isc.DropZone.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    /**
     * Changes the defaults for FormItem AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults FormItem defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.  For usage tips on this
     * param, see {@link com.smartgwt.client.docs.SGWTProperties}.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, FormItem defaults) /*-{
        if (defaults.@com.smartgwt.client.widgets.form.fields.FormItem::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(DropZone.@java.lang.Object::getClass()(), "changeAutoChildDefaults", "FormItem");
        }
        defaults.@com.smartgwt.client.widgets.form.fields.FormItem::setConfigOnly(Z)(true);
    	var cleanDefaultsJS = defaults.@com.smartgwt.client.widgets.form.fields.FormItem::getEditorTypeConfig()();
        $wnd.isc.DropZone.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    public DropZone(){
        scClassName = "DropZone";
    }

    public DropZone(JavaScriptObject jsObj){
        scClassName = "DropZone";
        setJavaScriptObject(jsObj);
    }

    protected native JavaScriptObject create()/*-{
        var config = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
        var widget = $wnd.isc[scClassName].create(config);
        if ($wnd.isc.keepGlobals) this.@com.smartgwt.client.widgets.BaseWidget::internalSetID(Lcom/google/gwt/core/client/JavaScriptObject;)(widget);
        this.@com.smartgwt.client.widgets.BaseWidget::doInit()();
        return widget;
    }-*/;

    // ********************* Static Attributes ***********************

    // ********************* Properties / Attributes ***********************

    /**
     * Array of accepted MIME types (e.g., ["image/*", "application/pdf"]). If null, all file types are accepted when {@link
     * com.smartgwt.client.widgets.DropZone#getCanDropFiles canDropFiles} is true.
     *
     * @param acceptedFileTypes New acceptedFileTypes value. Default value is null
     * @return {@link com.smartgwt.client.widgets.DropZone DropZone} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public DropZone setAcceptedFileTypes(String... acceptedFileTypes)  throws IllegalStateException {
        return (DropZone)setAttribute("acceptedFileTypes", acceptedFileTypes, false);
    }

    /**
     * Array of accepted MIME types (e.g., ["image/*", "application/pdf"]). If null, all file types are accepted when {@link
     * com.smartgwt.client.widgets.DropZone#getCanDropFiles canDropFiles} is true.
     *
     * @return Current acceptedFileTypes value. Default value is null
     */
    public String[] getAcceptedFileTypes()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfString(getAttributeAsJavaScriptObject("acceptedFileTypes"));
    }
    

    /**
     * Horizontal alignment for drop zone content.
     *
     * @param align New align value. Default value is "center"
     * @return {@link com.smartgwt.client.widgets.DropZone DropZone} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public DropZone setAlign(Alignment align)  throws IllegalStateException {
        return (DropZone)setAttribute("align", align == null ? null : align.getValue(), false);
    }

    /**
     * Horizontal alignment for drop zone content.
     *
     * @return Current align value. Default value is "center"
     */
    public Alignment getAlign()  {
        return EnumUtil.getEnum(Alignment.values(), getAttribute("align"));
    }
    

    /**
     * Base CSS class for the drop zone. Supports state suffixes: Over, Disabled.
     *
     * @param baseStyle New baseStyle value. Default value is "dropZone"
     * @return {@link com.smartgwt.client.widgets.DropZone DropZone} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public DropZone setBaseStyle(String baseStyle)  throws IllegalStateException {
        return (DropZone)setAttribute("baseStyle", baseStyle, false);
    }

    /**
     * Base CSS class for the drop zone. Supports state suffixes: Over, Disabled.
     *
     * @return Current baseStyle value. Default value is "dropZone"
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public String getBaseStyle()  {
        return getAttributeAsString("baseStyle");
    }
    

    /**
     * Whether this drop zone accepts content drops (text, HTML) from other applications. When true, the {@link
     * com.smartgwt.client.widgets.DropZone#contentDrop contentDrop()} notification fires when content is dropped.
     *
     * @param canDropContent New canDropContent value. Default value is false
     * @return {@link com.smartgwt.client.widgets.DropZone DropZone} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public DropZone setCanDropContent(Boolean canDropContent)  throws IllegalStateException {
        return (DropZone)setAttribute("canDropContent", canDropContent, false);
    }

    /**
     * Whether this drop zone accepts content drops (text, HTML) from other applications. When true, the {@link
     * com.smartgwt.client.widgets.DropZone#contentDrop contentDrop()} notification fires when content is dropped.
     *
     * @return Current canDropContent value. Default value is false
     */
    public Boolean getCanDropContent()  {
        Boolean result = getAttributeAsBoolean("canDropContent");
        return result == null ? false : result;
    }
    

    /**
     * Whether this drop zone accepts file drops from the desktop. When true, the {@link
     * com.smartgwt.client.widgets.DropZone#fileDrop fileDrop()} notification fires when files are dropped.
     *
     * @param canDropFiles New canDropFiles value. Default value is true
     * @return {@link com.smartgwt.client.widgets.DropZone DropZone} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public DropZone setCanDropFiles(Boolean canDropFiles)  throws IllegalStateException {
        return (DropZone)setAttribute("canDropFiles", canDropFiles, false);
    }

    /**
     * Whether this drop zone accepts file drops from the desktop. When true, the {@link
     * com.smartgwt.client.widgets.DropZone#fileDrop fileDrop()} notification fires when files are dropped.
     *
     * @return Current canDropFiles value. Default value is true
     */
    public Boolean getCanDropFiles()  {
        Boolean result = getAttributeAsBoolean("canDropFiles");
        return result == null ? true : result;
    }
    

    /**
     * Vertical alignment for drop zone content.
     *
     * @param valign New valign value. Default value is "center"
     * @return {@link com.smartgwt.client.widgets.DropZone DropZone} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public DropZone setValign(VerticalAlignment valign)  throws IllegalStateException {
        return (DropZone)setAttribute("valign", valign == null ? null : valign.getValue(), false);
    }

    /**
     * Vertical alignment for drop zone content.
     *
     * @return Current valign value. Default value is "center"
     */
    public VerticalAlignment getValign()  {
        return EnumUtil.getEnum(VerticalAlignment.values(), getAttribute("valign"));
    }
    

    // ********************* Methods ***********************
	/**
     * Notification fired when content (text, HTML) is dropped from another application. Only fires when {@link
     * com.smartgwt.client.widgets.DropZone#getCanDropContent canDropContent} is true.
     * @param content The dropped content
     */
    public native void contentDrop(String content) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "contentDrop", "String");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.contentDrop(content);
    }-*/;

	/**
     * Notification fired when files are dropped onto the drop zone. Only fires when {@link
     * com.smartgwt.client.widgets.DropZone#getCanDropFiles canDropFiles} is true.
     * @param files JavaScript File objects that were dropped
     */
    public native void fileDrop(com.google.gwt.core.client.JavaScriptObject[] files) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "fileDrop", "com.google.gwt.core.client.JavaScriptObject[]");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.fileDrop(@com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([Ljava/lang/Object;)(files));
    }-*/;


    // ********************* Static Methods ***********************

    /** 
     * Class level method to set the default properties of this class.  If set, then all
     * existing and subsequently created instances of this class will automatically have
     * default properties corresponding to
     * the properties set on the SmartGWT class instance passed to this function before its
     * underlying SmartClient JS object was created.
     * This is a powerful feature that eliminates the need for users to create a separate
     * hierarchy of subclasses that only alter the default properties of this class. Can also
     * be used for skinning / styling purposes.  <P> <b>Note:</b> This method is intended for
     * setting default attributes only and will affect all instances of the underlying class
     * (including those automatically generated in JavaScript).  This method should not be used
     * to apply standard EventHandlers or override methods for a class - use a custom subclass
     * instead.  Calling this method after instances have been created can result in undefined
     * behavior, since it bypasses any setters and a class instance may have already examined 
     * a particular property and not be expecting any changes through this route.
     *
     * @param dropZoneProperties properties that should be used as new defaults when instances of this class are created
     * @see com.smartgwt.client.docs.SGWTProperties
     */
    public static native void setDefaultProperties(DropZone dropZoneProperties) /*-{
        if (dropZoneProperties.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Class;)(DropZone.@java.lang.Object::getClass()(), "setDefaultProperties", dropZoneProperties.@java.lang.Object::getClass()());
        }
        dropZoneProperties.@com.smartgwt.client.widgets.BaseWidget::setConfigOnly(Z)(true);
    	var properties = dropZoneProperties.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        properties = @com.smartgwt.client.util.JSOHelper::cleanProperties(Lcom/google/gwt/core/client/JavaScriptObject;Z)(properties,true);
        $wnd.isc.DropZone.addProperties(properties);
    }-*/;

    // ***********************************************************

    /**
     * Setter implementing the {@link com.smartgwt.client.core.LogicalStructure} interface,
     * which supports Eclipse's logical structure debugging facility.
     */
    public LogicalStructureObject setLogicalStructure(DropZoneLogicalStructure s) {
        super.setLogicalStructure(s);
        try {
            s.acceptedFileTypes = getAttributeAsStringArray("acceptedFileTypes");
        } catch (Throwable t) {
            s.logicalStructureErrors += "DropZone.acceptedFileTypesArray:" + t.getMessage() + "\n";
        }
        try {
            s.align = getAttributeAsString("align");
        } catch (Throwable t) {
            s.logicalStructureErrors += "DropZone.align:" + t.getMessage() + "\n";
        }
        try {
            s.baseStyle = getAttributeAsString("baseStyle");
        } catch (Throwable t) {
            s.logicalStructureErrors += "DropZone.baseStyle:" + t.getMessage() + "\n";
        }
        try {
            s.canDropContent = getAttributeAsString("canDropContent");
        } catch (Throwable t) {
            s.logicalStructureErrors += "DropZone.canDropContent:" + t.getMessage() + "\n";
        }
        try {
            s.canDropFiles = getAttributeAsString("canDropFiles");
        } catch (Throwable t) {
            s.logicalStructureErrors += "DropZone.canDropFiles:" + t.getMessage() + "\n";
        }
        try {
            s.valign = getAttributeAsString("valign");
        } catch (Throwable t) {
            s.logicalStructureErrors += "DropZone.valign:" + t.getMessage() + "\n";
        }
        return s;
    }

    /**
     * Getter implementing the {@link com.smartgwt.client.core.LogicalStructure} interface,
     * which supports Eclipse's logical structure debugging facility.
     */
    public LogicalStructureObject getLogicalStructure() {
        DropZoneLogicalStructure s = new DropZoneLogicalStructure();
        setLogicalStructure(s);
        return s;
    }
}
