/*

  SmartClient Ajax RIA system
  Version SNAPSHOT_v15.0d_2026-02-19/LGPL Deployment (2026-02-19)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
//> @class Base64ImageDataItem
// A +link{FormItem} for editing base64-encoded image data.
// @inheritsFrom FormItem
// @treeLocation Client Reference/Forms/Form Items
//<
isc.defineClass("Base64ImageDataItem", isc.CanvasItem).addProperties({
    width: "100%",

    shouldSaveValue: true,

    //> @attr Base64ImageDataItem.accept (String : "image/*" : IRW)
    // Comma-separated list of acceptable MIME types, which may include wildcards like "image/*"
    // for all 'image' MIME types. This must include "image/png", either directly or via "image/*",
    // and even if it does not, the +link{mimeType} may be set to "image/png" regardless.
    // @see FileItem.accept
    //<
    accept: "image/*",

    //> @attr Base64ImageDataItem.mimeType (String : null : IRW)
    // The mime type of the base64-encoded image. When setting or initializing this item's value,
    // you must also set this <code>mimeType</code> property to the MIME type of the image data.
    //<
    mimeType: null,

    autoSelectTimeout: 1000,

    //> @attr Base64ImageDataItem.showPreview (Boolean : true : IR)
    // Whether to show a preview of the base64-encoded image data.
    //<
    showPreview: true,

    previewFieldDefaults: {
        name: "_preview",
        width: "*", height: 100,
        type: "FormItem",
        canEdit: false,
        shouldSaveValue: false,
        showTitle: false,

        mapValueToDisplay : function (value) {
            var displayValue = this.form.creator.getDisplayValue(value);
            if (!displayValue || !this.form.creator.mimeType) return isc.emptyString;

            var inferredMIMEType = this.form.creator.mimeType;
            if (displayValue.startsWith("iVBORw0KGgo")) {
                inferredMIMEType = "image/png";
            } else if (displayValue.startsWith("/9j/") && displayValue.endsWith("/Z")) {
                inferredMIMEType = "image/jpeg";
            } else if (inferredMIMEType) {
                inferredMIMEType = inferredMIMEType.trim();
            }

            if (!inferredMIMEType) return isc.emptyString;

            var width = this.getInnerWidth(),
                height = this.getInnerHeight();
            if (!isc.isA.Number(width) || width < 0 ||
                !isc.isA.Number(height) || height < 0)
            {
                return isc.emptyString;
            }

            return "<div style='height:" + height + "px;overflow:hidden'>" +
                "<img src='data:" + inferredMIMEType + ";base64," + displayValue + "' " +
                        "style='max-width:" + width + "px;max-height:" + height + "px'>" +
                "</div>";
        }
    },

    imageFieldDefaults: {
        type: "imageFile",
        titleOrientation: "top",
        showTitle: false,
        changed : function (form, item, value) {
            form.creator._scheduleAutoSelect();
        }
    },

    canvasDefaults: {
        _constructor: "DynamicForm",
        width: "100%",
        numCols: 1
    },

    createCanvas : function (form, item) {
        var previewField = isc.addProperties({}, this.previewFieldDefaults, this.previewFieldProperties),
            imageField = isc.addProperties({}, this.imageFieldDefaults, this.imageFieldProperties, {
                name: this.imageFieldName || this.name,
                accept: this.accept,
                multiple: false
            }),
            browserSupportsDataURLs = !(isc.Browser.isIE && isc.Browser.version < 8),
            
            showPreview = this.showPreview && browserSupportsDataURLs,
            fields = showPreview ? [previewField, imageField] : [imageField];
        var canvas = this.createAutoChild("canvas", {
            dataSource: this.dataSource || this.form.dataSource,
            fields: fields
        });
        if (!canvas.getDataSource()) {
            this.logWarn("Without a DataSource, there is no fallback if the browser is unable " +
                    "to locally access a user-selected image file.");
        }
        this.previewField = showPreview ? canvas.fields[0] : null;
        this.imageField = canvas.fields[canvas.fields.length - 1];
        return canvas;
    },

    //> @method Base64ImageDataItem.setAccept()
    // Setter for +link{accept}.
    // <p>
    // If a value for this item is set, and under the new <code>accept</code> the MIME type
    // is no longer accepted, then the value will be cleared.
    // @param accept (String) new value for <code>accept</code>
    //<
    setAccept : function (accept) {
        this.accept = accept;
        var uploadItem = this.getUploadItem();
        if (uploadItem) uploadItem.setProperty("accept", accept);
        if (!this._acceptsMIMEType(this.mimeType)) {
            this._setValidatedBase64Data(null, null);
        }
    },

    getPreviewItem : function () {
        if (!this.canvas || this.canvas.destroyed || !this.previewField) return null;
        return this.canvas.getItem(this.previewField.name);
    },

    getUploadItem : function () {
        if (!this.canvas || this.canvas.destroyed) return null;
        var imageItem = this.canvas.getItem(this.imageField.name);
        return imageItem.uploadItem;
    },

    showValue : function (displayValue, dataValue, form, item) {
        var previewItem = this.getPreviewItem();
        if (!previewItem) return;
        previewItem.setValue(dataValue);
    },

    _scheduleAutoSelect : function () {
        if (this._autoSelectTimerEvent) isc.Timer.clear(this._autoSelectTimerEvent);
        this._autoSelectTimerEvent = this.delayCall("_autoSelect", null, this.autoSelectTimeout);
    },

    _acceptsMIMEType : function (mimeType) {
        if (!mimeType) return false;

        if (mimeType == "image/png") return true;

        var accept = this.accept;
        if (!accept) return false;

        var fslashPos = mimeType.indexOf("/");
        if (fslashPos <= 0) {
            return false;
        }

        var typeStr = mimeType.substring(0, fslashPos);
        // Check for a type wildcard
        if (new RegExp(",?\\s*" + RegExp._escape(typeStr) + "/\\*\\s*,?").test(accept)) return true;
        // Otherwise, check for the full MIME type
        return new RegExp(",?\\s*" + RegExp._escape(mimeType) + "\\s*,?").test(accept);
    },

    _autoSelect : function () {
        delete this._autoSelectTimerEvent;
        var uploadItem = this.getUploadItem();
        if (!uploadItem) return;
        if (!window.FileReader || !window.Uint8Array || !window.btoa) {
            this._autoSelectFallback();
            return;
        }
        try {
            var fileInput = uploadItem.getDataElement(),
                file = fileInput.files[0],
                inferredMIMEType = file.type;

            
            var fileReader = new window.FileReader;
            fileReader.onload = (function () {
                var byteArr = new window.Uint8Array(fileReader.result),
                    len = byteArr.length;

                // "The first eight bytes of a PNG datastream always contain the following
                // hexadecimal values:
                //     89 50 4E 47 0D 0A 1A 0A"
                // https://www.w3.org/TR/png/#3PNGsignature
                if (len >= 8 &&
                    byteArr[0] == 0x89 && byteArr[1] == 0x50 && byteArr[2] == 0x4e &&
                    byteArr[3] == 0x47 && byteArr[4] == 0x0d && byteArr[5] == 0x0a &&
                    byteArr[6] == 0x1a && byteArr[7] == 0x0a)
                {
                    
                    inferredMIMEType = "image/png";

                // SOI / Start Of Image is 0xff, 0xd8
                // EOI / End Of Image is 0xff, 0xd9
                // https://en.wikipedia.org/wiki/JPEG#Syntax_and_structure
                } else if (len >= 4 &&
                    byteArr[0] == 0xff && byteArr[1] == 0xd8 && byteArr[2] == 0xff &&
                    byteArr[len - 2] == 0xff && byteArr[len - 1] == 0xd9)
                {
                    inferredMIMEType = "image/jpeg";

                } else if (inferredMIMEType) {
                    inferredMIMEType = inferredMIMEType.trim();
                }

                if (!inferredMIMEType) {
                    this.logError("No MIME type was inferred.");
                    return;
                }
                if (!this._acceptsMIMEType(inferredMIMEType)) {
                    this.logError("This item does not accept MIME type '" + inferredMIMEType + "'.");
                    return;
                }

                var binaryStr = "";
                for (var i = 0; i < len; ++i) {
                    binaryStr += String.fromCharCode(byteArr[i]);
                }
                var base64Data = window.btoa(binaryStr);

                this.setBase64Data(inferredMIMEType, base64Data);
            }).bind(this);
            fileReader.onerror = (function () {
                this._autoSelectFallback();
            }).bind(this);
            fileReader.readAsArrayBuffer(file);
        } catch (e) {
            this._autoSelectFallback();
        }
    },

    _autoSelectFallback : function (error) {
        if (!this.canvas || this.canvas.destroyed) return;
        this.logInfo("Unable to locally access the image file data. Falling back on image upload...");
        this.canvas.submit({target: this, methodName: "_formSubmitCallback"});
    },

    _formSubmitCallback : function (dsResponse, data) {
        if (!this.canvas || this.canvas.destroyed || !data) return;
        var dataSource = this.canvas.getDataSource();
        if (!dataSource) return;

        
        var img = new Image;
        img.onload = (function () {
            this._accessBase64Data(img);
        }).bind(this);
        img.src = dataSource.getFileURL(data);
        if (img.complete) this._accessBase64Data(img);
    },

    _accessBase64Data : function (img) {
        if (img._processed) return;
        var naturalWidth = img.naturalWidth,
            naturalHeight = img.naturalHeight;
        if (!naturalWidth || !naturalHeight || !isc.DrawPane) {
            this._setValidatedBase64Data(null, null);
            return;
        }

        var drawPane = isc.DrawPane.create({
            top: -naturalHeight - 100,
            width: naturalWidth,
            height: naturalHeight
        });
        drawPane.addDrawItem(isc.DrawImage.create({
            src: img.src,
            top: 0,
            left: 0,
            width: naturalWidth,
            height: naturalHeight
        }), true);
        drawPane.getDataURL((function (dataURL) {
            drawPane.destroy();

            if (!dataURL) {
                this._setValidatedBase64Data(null, null);
                return;
            }

            var prelimStr = "data:image/png;base64,";
            if (!dataURL.startsWith(prelimStr)) {
                this.logError("The data URL does not appear to be base64-encoded PNG: " + dataURL);
                return;
            }

            var base64Data = dataURL.substring(prelimStr.length);
            this._setValidatedBase64Data("image/png", base64Data);
        }).bind(this), "png");

        img._processed = true;
    },

    setBase64Data : function (mimeType, base64Data) {
        if (!mimeType || !base64Data) return this._setValidatedBase64Data(null, null);

        
        var img = new Image;
        img.onload = (function () {
            this._handleImgLoaded(img, mimeType, base64Data);
        }).bind(this);
        img.src = "data:" + mimeType + ";base64," + base64Data;
        if (img.complete) this._handleImgLoaded(img, mimeType, base64Data);
    },

    _handleImgLoaded : function (img, mimeType, base64Data) {
        if (img._processed) return;
        this._assert(mimeType && base64Data);
        var naturalWidth = img.naturalWidth,
            naturalHeight = img.naturalHeight;
        if (!naturalWidth || !naturalHeight) {
            mimeType = null;
            base64Data = null;
        }
        this._setValidatedBase64Data(mimeType, base64Data);

        img._processed = true;
    },

    _setValidatedBase64Data : function (mimeType, base64Data) {
        this.mimeType = mimeType;
        this.storeValue(base64Data, true);
    }
});
