
package com.smartgwt.client.docs;

/**
 * <h3>Adding Custom Workflow Tasks</h3>
 * You can define custom Workflow tasks and add them to the {@link
 * com.smartgwt.client.tools.WorkflowEditor}.  This applies whether you are using the Workflow
 * Editor embedded in Reify or as a {@link com.smartgwt.client.tools.WorkflowEditor standalone
 * component} (see the @see <a
 * href="http://www.smartclient.com/smartgwtee/showcase/#workflowEditor"
 * target="examples">Workflow Editor</a> and @see <a
 * href="http://www.smartclient.com/smartgwtee/showcase/#customTaskEditor"
 * target="examples">Custom Task Editor</a> samples).  Custom tasks let designers cover additional
 * use cases within the visual editor without writing code. <P> The overall steps are: <ol>
 * <li>Create a {@link com.smartgwt.client.util.workflow.ProcessElement} subclass that performs
 * the desired task.</li> <li>Build a task editor so users can configure task properties (or skip
 * this step for tasks with no configurable properties).</li> <li>Register the task with the
 * Workflow Editor via {@link com.smartgwt.client.tools.WorkflowEditor#registerTaskDescriptor
 * WorkflowEditor.registerTaskDescriptor()} (or, in Reify, via
 * <code>workflowTasks.xml</code>).</li> </ol> For Reify deployments, a {@link
 * com.smartgwt.client.docs.ComponentSchema component schema} is also needed so the task can be
 * serialized; see <b>Task Schema (Reify)</b> below. <P> <b>Do I need a custom Workflow task?</b>
 * <p> Before building a custom task and editor, consider whether other approaches might work: <p>
 * 1. <i>Custom services</i> &ndash; if you are connecting to an enterprise web service, a custom
 * DataSource may suffice; see {@link com.smartgwt.client.docs.ReifyCustomDataSources Adding
 * Custom DataSources to Reify}. DataSources can model any network service, not just databases. 
 * For example, a proprietary messaging system with inputs like <i>recipient, subject, message</i>
 * can be modelled as a DataSource where those are simply fields and sending is an "add"
 * operation.  A custom task may still be worthwhile if you want a specialized editing interface.
 * <p> 2. <i>Actions on UI components</i> &ndash; if your custom components support actions, you
 * can expose them as setter methods (e.g. <code>setMode(<i>newMode</i>)</code>), add the setter
 * to the Component Schema, and let designers invoke it via the built-in <i>Set Properties</i>
 * workflow task. <p> <b>Workflow Task</b> <p> A new task must inherit from {@link
 * com.smartgwt.client.util.workflow.ProcessElement} or a subclass like {@link
 * com.smartgwt.client.util.workflow.ScriptTask} or {@link
 * com.smartgwt.client.util.workflow.ComponentTask}, and override {@link
 * com.smartgwt.client.util.workflow.ProcessElement#executeElement
 * ProcessElement.executeElement()} (or a subclass-specific method like {@link
 * com.smartgwt.client.util.workflow.ScriptTask#execute ScriptTask.execute()}).  Return
 * <code>true</code> for synchronous completion or <code>null</code> for asynchronous (then call
 * <code>process.start()</code> when done). <p> Setting {@link
 * com.smartgwt.client.util.workflow.ProcessElement#getTypeTitle ProcessElement.typeTitle} and
 * {@link com.smartgwt.client.util.workflow.ProcessElement#getClassDescription
 * ProcessElement.classDescription} on the class provides default {@link
 * com.smartgwt.client.tools.WorkflowTaskDescriptor#getTitle title} and {@link
 * com.smartgwt.client.tools.WorkflowTaskDescriptor#getDescription description} values, so they
 * don't need to be repeated in the {@link com.smartgwt.client.tools.WorkflowTaskDescriptor}. <p>
 * For Reify, load the task implementation via <code>globalDependencies.xml</code> (see {@link
 * com.smartgwt.client.docs.ReifyCustomComponents "Adding Custom Components to Reify"}) or via
 * {@link com.smartgwt.client.docs.ReifyOnSite "Runtime Customization"}. <p> <b>Task Schema
 * (Reify)</b> <p> In Reify, a {@link com.smartgwt.client.docs.ComponentSchema component schema}
 * is needed so the task configuration can be serialized.  The schema can be XML or JavaScript and
 * requires: <ul>   <li>{@link com.smartgwt.client.data.DataSource#getID ID} = <em>same as      
 * your task class name</em>   <li>{@link com.smartgwt.client.docs.serverds.DataSource#serverType
 * serverType}       = "component"   <li>{@link
 * com.smartgwt.client.data.DataSource#getInheritsFrom inheritsFrom} = <em>superclass name</em>  
 * <li>instanceConstructor = <em>same as your       task class name</em> </ul> For standalone
 * WorkflowEditor usage without Reify, no schema is needed &mdash; tasks are serialized via {@link
 * com.smartgwt.client.tools.WorkflowEditor#getProcessJS getProcessJS()} which uses JavaScript
 * reflection. <p> <b>Workflow Task Editor</b> <p> A task editor lets users configure task
 * properties.  If a task has no configurable properties (e.g. a logout task), no editor is needed
 * &mdash; simply omit the {@link com.smartgwt.client.tools.WorkflowTaskDescriptor#editTask
 * editTask()} callback and {@link com.smartgwt.client.util.workflow.ProcessElement#getEditorType
 * editorType}. <p> There are two approaches to building editors: <p> <i>Approach 1: Subclass
 * {@link com.smartgwt.client.tools.WorkflowTaskEditor}</i> (or {@link
 * com.smartgwt.client.tools.WorkflowComponentTaskEditor} for {@link
 * com.smartgwt.client.util.workflow.ComponentTask}-based tasks).  Override {@link
 * com.smartgwt.client.tools.WorkflowTaskEditor#getEditorComponents getEditorComponents()}, {@link
 * com.smartgwt.client.tools.WorkflowTaskEditor#setEditorValuesFromDefaults
 * setEditorValuesFromDefaults()}, {@link
 * com.smartgwt.client.tools.WorkflowTaskEditor#getEditorValuesAsDefaults
 * getEditorValuesAsDefaults()}, and {@link com.smartgwt.client.tools.WorkflowTaskEditor#validate
 * validate()}. Set {@link com.smartgwt.client.util.workflow.ProcessElement#getEditorType
 * editorType} on the task class to your editor class name.  See the @see <a
 * href="http://www.smartclient.com/smartgwtee/showcase/#customTaskEditor"
 * target="examples">Custom Task Editor</a> sample for a working example. <p> <i>Approach 2:
 * Provide an {@link com.smartgwt.client.tools.WorkflowTaskDescriptor#editTask editTask()}
 * callback</i> on the {@link com.smartgwt.client.tools.WorkflowTaskDescriptor}.  This gives
 * complete control &mdash; build any UI you like, then call <code>callback(editNode)</code> to
 * save or <code>callback(null)</code> to cancel. <p> Several helper classes are available for
 * building advanced property editors: {@link
 * com.smartgwt.client.tools.WorkflowValuesBindingEditor}, {@link
 * com.smartgwt.client.tools.WorkflowCriteriaBuilder}, {@link
 * com.smartgwt.client.tools.WorkflowDynamicValueItem}, and {@link
 * com.smartgwt.client.tools.WorkflowTemplatedTextItem}. <p> <b>Registering the Task</b> <p> For
 * the {@link com.smartgwt.client.tools.WorkflowEditor} to show the new task in its task picker,
 * register a {@link com.smartgwt.client.tools.WorkflowTaskDescriptor} via {@link
 * com.smartgwt.client.tools.WorkflowEditor#registerTaskDescriptor
 * WorkflowEditor.registerTaskDescriptor()}. To place the task under a custom folder, first call
 * {@link com.smartgwt.client.tools.WorkflowEditor#registerFolderDescriptor
 * WorkflowEditor.registerFolderDescriptor()} to create the folder, then set {@link
 * com.smartgwt.client.tools.WorkflowTaskDescriptor#getTaskPath taskPath} to the folder's {@link
 * com.smartgwt.client.tools.WorkflowTaskDescriptor#getID ID}. Descriptors can be removed at
 * runtime via {@link com.smartgwt.client.tools.WorkflowEditor#removeTaskDescriptor
 * WorkflowEditor.removeTaskDescriptor()}. <p> In Reify, the easiest approach is to add the
 * descriptor to the default task tree in <code>[webroot]/tools/visualBuilder/
 * workflowTasks.xml</code>, which uses a tree structure similar to the <a
 * href="http://www.smartclient.com/smartgwtee/showcase/#treeLoadXML" target="examples">tree XML
 * loading example</a>.  The properties on each node are documented on {@link
 * com.smartgwt.client.tools.WorkflowTaskDescriptor}. <p> A descriptor can also be registered at
 * runtime via {@link com.smartgwt.client.tools.Reify#registerWorkflowTaskDescriptor
 * Reify.registerWorkflowTaskDescriptor()}, which is useful for {@link
 * com.smartgwt.client.docs.ReifyOnSite "Runtime Customization"}.
 */
public interface ReifyAddWorkflowTask {
}
