
package com.smartgwt.client.docs;

/**
 * <h3>Reify Overview</h3>
 * Reify is a web-based visual application builder that enables non-developers to build  Smart GWT
 * screens, and even build complete applications. This is sometimes called  a "<code>Low Code / No
 * Code</code>" system. <P> You can use Reify at <a href='https://www.reify.com'
 * target='_blank'>Reify.com</a> (<a href='https://create.reify.com/users/register.jsp'
 * target='_blank'>get a free trial account</a>),  or you can use {@link
 * com.smartgwt.client.docs.ReifyOnSite Reify OnSite}, which is a version of Reify that can be 
 * installed on your own network, behind your firewall, so that your confidential data and 
 * designs never leave your network. <P> Reify can be used to build complete applications, and
 * features push-button managed deployment.   Reify applications can also be exported from Reify,
 * and deployed on the standard Smart GWT  platform (including Smart GWT LGPL). <P> Reify can also
 * be used to build just <i>parts</i> of an application, using a process  called <i>Hybrid
 * Development</i>, where screens created in Reify can be added to an existing  application. To
 * learn more about Hybrid Development, read {@link com.smartgwt.client.docs.ReifyForDevelopers
 * Reify for Developers}. <P> When using Hybrid Development, Reify screens can be easily added to
 * existing applications,  even if those applications aren't based on Smart GWT. The loaded
 * screens simply connect  to the data services your application already has.  <P> <b>Low Code
 * Everywhere</b> <P> Because Reify is so flexible, you can use it on any kind of project: unlike
 * other Low Code tools,  Reify isn't limited to just simpler applications.   <P> For example, you
 * might build the first version of your application completely within Reify,  and use push-button
 * managed deployment. Then later, you could export it to deploy it on your own.   And, as
 * requirements change, you can switch to Hybrid Development if you need to add screens, 
 * functions or data connections that can't be built visually. <P> At the same time, you can use
 * Reify to incrementally upgrade existing web applications, by  adding new screens and replacing
 * existing ones. <P> Because Reify applications are just Smart GWT applications, you can be
 * confident that you  will be able to build any kind of application or feature you need - you can
 * never "get stuck"  and have to start over with a different technology. <P> Because Reify lets
 * you deploy on your own if you want to, you will never be trapped by unfair pricing. <P> The
 * power &amp; flexibility of Reify enables you to get the benefits of the Low Code approach on 
 * every project.  <P> <b>Reify for Mockups &amp; Functional Design</b> <P> Reify has several
 * advantages over other tools typically used for mockups or functional design: <ol>
 * <li><i>richer, testable mockups</i>: you can create much richer, more complete, more
 * interactive  mockups. You can even use push-button deployment to create a UAT ("User Acceptance
 * Test") environment,  without ever having to involve a developer or IT.</li> <li><i>no
 * waste</i>: Reify "mockups" are actually real screens, ready to use. With all other mockup 
 * tools, when it comes to implementation time, you simply throw the mockup away and start
 * over.</li> <li><i>same components for mockup and deployment</i>: with other mockup tools, the
 * components  available in the mockup tool may be different from those available in the real
 * technology.   Often, designers create awkward designs because the mockup tool lacks a key
 * component.</li> <li><i>add skins for WYSIWYG design</i>: you can install custom skins in Reify,
 * so that the  mockups created will look exactly the same when deployed.</li> </ol> <P> <b>Next
 * Steps:</b> <P> o Get a <a href='https://create.reify.com/users/register.jsp'
 * target='_blank'>free trial account</a> at  <a href='https://www.reify.com'
 * target='_blank'>Reify.com</a> and start building <P> ... or ... <P> o Read {@link
 * com.smartgwt.client.docs.ReifyForDevelopers Reify for Developers} to learn more about Hybrid
 * Development <P> ... or ... <P> o Read more about {@link com.smartgwt.client.docs.ReifyOnSite
 * Reify OnSite} and how to customize it.
     * @see com.smartgwt.client.docs.ToolsDeployment
     * @see com.smartgwt.client.docs.ReifyCustomComponents
     * @see com.smartgwt.client.docs.ReifyCustomDataSources
 * @see com.smartgwt.client.tools.stream.EventStream
 * @see com.smartgwt.client.tools.Reify
 * @see com.smartgwt.client.tools.Reify#getProjectDataSource
 */
public interface Reify {
}
