/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.widgets;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;

import com.smartgwt.logicalstructure.core.*;
import com.smartgwt.logicalstructure.widgets.*;
import com.smartgwt.logicalstructure.widgets.drawing.*;
import com.smartgwt.logicalstructure.widgets.plugins.*;
import com.smartgwt.logicalstructure.widgets.form.*;
import com.smartgwt.logicalstructure.widgets.tile.*;
import com.smartgwt.logicalstructure.widgets.grid.*;
import com.smartgwt.logicalstructure.widgets.chart.*;
import com.smartgwt.logicalstructure.widgets.layout.*;
import com.smartgwt.logicalstructure.widgets.menu.*;
import com.smartgwt.logicalstructure.widgets.rte.*;
import com.smartgwt.logicalstructure.widgets.ace.*;
import com.smartgwt.logicalstructure.widgets.tab.*;
import com.smartgwt.logicalstructure.widgets.tableview.*;
import com.smartgwt.logicalstructure.widgets.toolbar.*;
import com.smartgwt.logicalstructure.widgets.tree.*;
import com.smartgwt.logicalstructure.widgets.viewer.*;
import com.smartgwt.logicalstructure.widgets.calendar.*;
import com.smartgwt.logicalstructure.widgets.cube.*;
import com.smartgwt.logicalstructure.widgets.tools.*;
import com.smartgwt.logicalstructure.widgets.tour.*;
import com.smartgwt.logicalstructure.widgets.ai.*;

/**
 * The FileDropZone class provides a straightforward way to upload files from a user's desktop using HTML5 file drop
 * capabilities. <P> A FileDropZone does not itself upload files - it provides the UI for file collection and progress
 * indication. Upload is typically handled by a surrounding form or application code. <P> Users can add files by dragging
 * them onto the drop zone, or by clicking the drop zone to open a standard file browser dialog (when {@link
 * com.smartgwt.client.widgets.FileDropZone#getCanAddFilesOnClick canAddFilesOnClick} is true). <P> When used with a form,
 * uploads include per-file progress indication and error handling. <P> For use within a DynamicForm, see {@link
 * com.smartgwt.client.widgets.form.fields.FileUploadItem}. <P> FileDropZone extends {@link
 * com.smartgwt.client.widgets.DropZone} (and therefore StatefulCanvas), so CSS styling uses standard state suffixes: Over
 * (during drag), Disabled, and custom states Populated (files present) and Processing (upload in progress).
 */
@BeanFactory.FrameworkClass
@BeanFactory.ScClassName("FileDropZone")
public class FileDropZone extends DropZone {

    public static FileDropZone getOrCreateRef(JavaScriptObject jsObj) {
        if (jsObj == null) return null;
        final BaseWidget refInstance = BaseWidget.getRef(jsObj);
        if (refInstance == null) {
            return new FileDropZone(jsObj);
        } else {
            assert refInstance instanceof FileDropZone;
            return (FileDropZone)refInstance;
        }
    }
        


    /**
     * Changes the defaults for Canvas AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults Canvas defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.  For usage tips on this
     * param, see {@link com.smartgwt.client.docs.SGWTProperties}.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, Canvas defaults) /*-{
        if (defaults.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(FileDropZone.@java.lang.Object::getClass()(), "changeAutoChildDefaults", "Canvas");
        }
        defaults.@com.smartgwt.client.widgets.BaseWidget::setConfigOnly(Z)(true);
        var cleanDefaultsJS = @com.smartgwt.client.util.JSOHelper::cleanProperties(Lcom/google/gwt/core/client/JavaScriptObject;Z)(defaults.@com.smartgwt.client.widgets.BaseWidget::getConfig()(), true);
        $wnd.isc.FileDropZone.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    /**
     * Changes the defaults for FormItem AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults FormItem defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.  For usage tips on this
     * param, see {@link com.smartgwt.client.docs.SGWTProperties}.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, FormItem defaults) /*-{
        if (defaults.@com.smartgwt.client.widgets.form.fields.FormItem::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(FileDropZone.@java.lang.Object::getClass()(), "changeAutoChildDefaults", "FormItem");
        }
        defaults.@com.smartgwt.client.widgets.form.fields.FormItem::setConfigOnly(Z)(true);
    	var cleanDefaultsJS = defaults.@com.smartgwt.client.widgets.form.fields.FormItem::getEditorTypeConfig()();
        $wnd.isc.FileDropZone.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    public FileDropZone(){
        scClassName = "FileDropZone";
    }

    public FileDropZone(JavaScriptObject jsObj){
        scClassName = "FileDropZone";
        setJavaScriptObject(jsObj);
    }

    protected native JavaScriptObject create()/*-{
        var config = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
        var widget = $wnd.isc[scClassName].create(config);
        if ($wnd.isc.keepGlobals) this.@com.smartgwt.client.widgets.BaseWidget::internalSetID(Lcom/google/gwt/core/client/JavaScriptObject;)(widget);
        this.@com.smartgwt.client.widgets.BaseWidget::doInit()();
        return widget;
    }-*/;

    // ********************* Static Attributes ***********************

    // ********************* Properties / Attributes ***********************

    /**
     * Array of accepted MIME types (e.g., ["image/*", "application/pdf"]). If null, all file types are accepted.
     *
     * @param acceptedFileTypes New acceptedFileTypes value. Default value is null
     * @return {@link com.smartgwt.client.widgets.FileDropZone FileDropZone} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public FileDropZone setAcceptedFileTypes(String... acceptedFileTypes)  throws IllegalStateException {
        return (FileDropZone)setAttribute("acceptedFileTypes", acceptedFileTypes, false);
    }

    /**
     * Array of accepted MIME types (e.g., ["image/*", "application/pdf"]). If null, all file types are accepted.
     *
     * @return Current acceptedFileTypes value. Default value is null
     */
    public String[] getAcceptedFileTypes()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfString(getAttributeAsJavaScriptObject("acceptedFileTypes"));
    }
    

    /**
     * Horizontal alignment for drop zone content.
     *
     * @param align New align value. Default value is "center"
     * @return {@link com.smartgwt.client.widgets.FileDropZone FileDropZone} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public FileDropZone setAlign(Alignment align)  throws IllegalStateException {
        return (FileDropZone)setAttribute("align", align == null ? null : align.getValue(), false);
    }

    /**
     * Horizontal alignment for drop zone content.
     *
     * @return Current align value. Default value is "center"
     */
    public Alignment getAlign()  {
        return EnumUtil.getEnum(Alignment.values(), getAttribute("align"));
    }
    

    /**
     * Icon for archive files (ZIP, TAR, etc.).
     *
     * @param archiveFileIcon New archiveFileIcon value. Default value is "[SKINIMG]FileDropZone/archive.png"
     * @return {@link com.smartgwt.client.widgets.FileDropZone FileDropZone} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public FileDropZone setArchiveFileIcon(String archiveFileIcon)  throws IllegalStateException {
        return (FileDropZone)setAttribute("archiveFileIcon", archiveFileIcon, false);
    }

    /**
     * Icon for archive files (ZIP, TAR, etc.).
     *
     * @return Current archiveFileIcon value. Default value is "[SKINIMG]FileDropZone/archive.png"
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public String getArchiveFileIcon()  {
        return getAttributeAsString("archiveFileIcon");
    }
    

    /**
     * Icon for audio files.
     *
     * @param audioFileIcon New audioFileIcon value. Default value is "[SKINIMG]FileDropZone/audio.png"
     * @return {@link com.smartgwt.client.widgets.FileDropZone FileDropZone} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public FileDropZone setAudioFileIcon(String audioFileIcon)  throws IllegalStateException {
        return (FileDropZone)setAttribute("audioFileIcon", audioFileIcon, false);
    }

    /**
     * Icon for audio files.
     *
     * @return Current audioFileIcon value. Default value is "[SKINIMG]FileDropZone/audio.png"
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public String getAudioFileIcon()  {
        return getAttributeAsString("audioFileIcon");
    }
    

    /**
     * Base CSS class for the drop zone. Supports state suffixes: Over, Populated, Processing, Disabled.
     *
     * @param baseStyle New baseStyle value. Default value is "fileDropZone"
     * @return {@link com.smartgwt.client.widgets.FileDropZone FileDropZone} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public FileDropZone setBaseStyle(String baseStyle)  throws IllegalStateException {
        return (FileDropZone)setAttribute("baseStyle", baseStyle, false);
    }

    /**
     * Base CSS class for the drop zone. Supports state suffixes: Over, Populated, Processing, Disabled.
     *
     * @return Current baseStyle value. Default value is "fileDropZone"
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public String getBaseStyle()  {
        return getAttributeAsString("baseStyle");
    }
    

    /**
     * If true, clicking the drop zone opens a file browser dialog.
     *
     * @param canAddFilesOnClick New canAddFilesOnClick value. Default value is true
     * @return {@link com.smartgwt.client.widgets.FileDropZone FileDropZone} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public FileDropZone setCanAddFilesOnClick(Boolean canAddFilesOnClick)  throws IllegalStateException {
        return (FileDropZone)setAttribute("canAddFilesOnClick", canAddFilesOnClick, false);
    }

    /**
     * If true, clicking the drop zone opens a file browser dialog.
     *
     * @return Current canAddFilesOnClick value. Default value is true
     */
    public Boolean getCanAddFilesOnClick()  {
        Boolean result = getAttributeAsBoolean("canAddFilesOnClick");
        return result == null ? true : result;
    }
    

    /**
     * AutoChild Button allowing users to cancel an in-progress upload. Only shown if {@link
     * com.smartgwt.client.widgets.FileDropZone#getShowCancelButton showCancelButton} is true.
     * <p>
     * This component is an AutoChild named "cancelButton".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current cancelButton value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public Button getCancelButton() throws IllegalStateException {
        errorIfNotCreated("cancelButton");
        return (Button)Button.getByJSObject(getAttributeAsJavaScriptObject("cancelButton"));
    }
    

    /**
     * Icon for code/script files.
     *
     * @param codeFileIcon New codeFileIcon value. Default value is "[SKINIMG]FileDropZone/code.png"
     * @return {@link com.smartgwt.client.widgets.FileDropZone FileDropZone} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public FileDropZone setCodeFileIcon(String codeFileIcon)  throws IllegalStateException {
        return (FileDropZone)setAttribute("codeFileIcon", codeFileIcon, false);
    }

    /**
     * Icon for code/script files.
     *
     * @return Current codeFileIcon value. Default value is "[SKINIMG]FileDropZone/code.png"
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public String getCodeFileIcon()  {
        return getAttributeAsString("codeFileIcon");
    }
    

    /**
     * Default icon for files when no specific type icon is available.
     *
     * @param defaultFileIcon New defaultFileIcon value. Default value is "[SKINIMG]FileDropZone/file.png"
     * @return {@link com.smartgwt.client.widgets.FileDropZone FileDropZone} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public FileDropZone setDefaultFileIcon(String defaultFileIcon)  throws IllegalStateException {
        return (FileDropZone)setAttribute("defaultFileIcon", defaultFileIcon, false);
    }

    /**
     * Default icon for files when no specific type icon is available.
     *
     * @return Current defaultFileIcon value. Default value is "[SKINIMG]FileDropZone/file.png"
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public String getDefaultFileIcon()  {
        return getAttributeAsString("defaultFileIcon");
    }
    

    /**
     * Icon for document files (Word, text, etc.).
     *
     * @param documentFileIcon New documentFileIcon value. Default value is "[SKINIMG]FileDropZone/document.png"
     * @return {@link com.smartgwt.client.widgets.FileDropZone FileDropZone} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public FileDropZone setDocumentFileIcon(String documentFileIcon)  throws IllegalStateException {
        return (FileDropZone)setAttribute("documentFileIcon", documentFileIcon, false);
    }

    /**
     * Icon for document files (Word, text, etc.).
     *
     * @return Current documentFileIcon value. Default value is "[SKINIMG]FileDropZone/document.png"
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public String getDocumentFileIcon()  {
        return getAttributeAsString("documentFileIcon");
    }
    

    /**
     * Icon for image files (when showImagePreviews is false).
     *
     * @param imageFileIcon New imageFileIcon value. Default value is "[SKINIMG]FileDropZone/image.png"
     * @return {@link com.smartgwt.client.widgets.FileDropZone FileDropZone} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public FileDropZone setImageFileIcon(String imageFileIcon)  throws IllegalStateException {
        return (FileDropZone)setAttribute("imageFileIcon", imageFileIcon, false);
    }

    /**
     * Icon for image files (when showImagePreviews is false).
     *
     * @return Current imageFileIcon value. Default value is "[SKINIMG]FileDropZone/image.png"
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public String getImageFileIcon()  {
        return getAttributeAsString("imageFileIcon");
    }
    

    /**
     * Maximum number of files allowed when {@link com.smartgwt.client.widgets.FileDropZone#getMultiple multiple} is true.
     *
     * @param maxFiles New maxFiles value. Default value is null
     * @return {@link com.smartgwt.client.widgets.FileDropZone FileDropZone} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public FileDropZone setMaxFiles(Integer maxFiles)  throws IllegalStateException {
        return (FileDropZone)setAttribute("maxFiles", maxFiles, false);
    }

    /**
     * Maximum number of files allowed when {@link com.smartgwt.client.widgets.FileDropZone#getMultiple multiple} is true.
     *
     * @return Current maxFiles value. Default value is null
     */
    public Integer getMaxFiles()  {
        return getAttributeAsInt("maxFiles");
    }
    

    /**
     * Maximum size in bytes for any individual file.
     *
     * @param maxFileSize New maxFileSize value. Default value is null
     * @return {@link com.smartgwt.client.widgets.FileDropZone FileDropZone} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public FileDropZone setMaxFileSize(Integer maxFileSize)  throws IllegalStateException {
        return (FileDropZone)setAttribute("maxFileSize", maxFileSize, false);
    }

    /**
     * Maximum size in bytes for any individual file.
     *
     * @return Current maxFileSize value. Default value is null
     */
    public Integer getMaxFileSize()  {
        return getAttributeAsInt("maxFileSize");
    }
    

    /**
     * Maximum total size in bytes for all files combined.
     *
     * @param maxSize New maxSize value. Default value is null
     * @return {@link com.smartgwt.client.widgets.FileDropZone FileDropZone} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public FileDropZone setMaxSize(Integer maxSize)  throws IllegalStateException {
        return (FileDropZone)setAttribute("maxSize", maxSize, false);
    }

    /**
     * Maximum total size in bytes for all files combined.
     *
     * @return Current maxSize value. Default value is null
     */
    public Integer getMaxSize()  {
        return getAttributeAsInt("maxSize");
    }
    

    /**
     * Minimum total size in bytes for all files combined.
     *
     * @param minSize New minSize value. Default value is null
     * @return {@link com.smartgwt.client.widgets.FileDropZone FileDropZone} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public FileDropZone setMinSize(Integer minSize)  throws IllegalStateException {
        return (FileDropZone)setAttribute("minSize", minSize, false);
    }

    /**
     * Minimum total size in bytes for all files combined.
     *
     * @return Current minSize value. Default value is null
     */
    public Integer getMinSize()  {
        return getAttributeAsInt("minSize");
    }
    

    /**
     * Does this FileDropZone support multiple files?
     *
     * @param multiple New multiple value. Default value is false
     * @return {@link com.smartgwt.client.widgets.FileDropZone FileDropZone} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public FileDropZone setMultiple(Boolean multiple)  throws IllegalStateException {
        return (FileDropZone)setAttribute("multiple", multiple, false);
    }

    /**
     * Does this FileDropZone support multiple files?
     *
     * @return Current multiple value. Default value is false
     */
    public Boolean getMultiple()  {
        Boolean result = getAttributeAsBoolean("multiple");
        return result == null ? false : result;
    }
    

    /**
     * Icon for PDF files.
     *
     * @param pdfFileIcon New pdfFileIcon value. Default value is "[SKINIMG]FileDropZone/pdf.png"
     * @return {@link com.smartgwt.client.widgets.FileDropZone FileDropZone} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public FileDropZone setPdfFileIcon(String pdfFileIcon)  throws IllegalStateException {
        return (FileDropZone)setAttribute("pdfFileIcon", pdfFileIcon, false);
    }

    /**
     * Icon for PDF files.
     *
     * @return Current pdfFileIcon value. Default value is "[SKINIMG]FileDropZone/pdf.png"
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public String getPdfFileIcon()  {
        return getAttributeAsString("pdfFileIcon");
    }
    

    /**
     * AutoChild Progressbar showing upload progress.
     * <p>
     * This component is an AutoChild named "progressBar".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current progressBar value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public Progressbar getProgressBar() throws IllegalStateException {
        errorIfNotCreated("progressBar");
        return (Progressbar)Progressbar.getByJSObject(getAttributeAsJavaScriptObject("progressBar"));
    }
    

    /**
     * AutoChild Label showing the processing message during uploads.
     * <p>
     * This component is an AutoChild named "progressLabel".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current progressLabel value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public Label getProgressLabel() throws IllegalStateException {
        errorIfNotCreated("progressLabel");
        return (Label)Label.getByJSObject(getAttributeAsJavaScriptObject("progressLabel"));
    }
    

    /**
     * AutoChild Label showing the percentage complete text.
     * <p>
     * This component is an AutoChild named "progressText".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current progressText value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public Label getProgressText() throws IllegalStateException {
        errorIfNotCreated("progressText");
        return (Label)Label.getByJSObject(getAttributeAsJavaScriptObject("progressText"));
    }
    

    /**
     * Icon for the remove button on file tiles.
     *
     * @param removeIcon New removeIcon value. Default value is "[SKINIMG]FileDropZone/remove.png"
     * @return {@link com.smartgwt.client.widgets.FileDropZone FileDropZone} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public FileDropZone setRemoveIcon(String removeIcon)  throws IllegalStateException {
        return (FileDropZone)setAttribute("removeIcon", removeIcon, false);
    }

    /**
     * Icon for the remove button on file tiles.
     *
     * @return Current removeIcon value. Default value is "[SKINIMG]FileDropZone/remove.png"
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public String getRemoveIcon()  {
        return getAttributeAsString("removeIcon");
    }
    

    /**
     * If true, dropping new files replaces existing files. If false, new files are added to the existing list.
     *
     * @param replaceFilesOnDrop New replaceFilesOnDrop value. Default value is true
     * @return {@link com.smartgwt.client.widgets.FileDropZone FileDropZone} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public FileDropZone setReplaceFilesOnDrop(Boolean replaceFilesOnDrop)  throws IllegalStateException {
        return (FileDropZone)setAttribute("replaceFilesOnDrop", replaceFilesOnDrop, false);
    }

    /**
     * If true, dropping new files replaces existing files. If false, new files are added to the existing list.
     *
     * @return Current replaceFilesOnDrop value. Default value is true
     */
    public Boolean getReplaceFilesOnDrop()  {
        Boolean result = getAttributeAsBoolean("replaceFilesOnDrop");
        return result == null ? true : result;
    }
    

    /**
     * Whether to show a cancel button during processing that allows the user to abort the upload.
     *
     * @param showCancelButton New showCancelButton value. Default value is true
     * @return {@link com.smartgwt.client.widgets.FileDropZone FileDropZone} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public FileDropZone setShowCancelButton(Boolean showCancelButton)  throws IllegalStateException {
        return (FileDropZone)setAttribute("showCancelButton", showCancelButton, false);
    }

    /**
     * Whether to show a cancel button during processing that allows the user to abort the upload.
     *
     * @return Current showCancelButton value. Default value is true
     */
    public Boolean getShowCancelButton()  {
        Boolean result = getAttributeAsBoolean("showCancelButton");
        return result == null ? true : result;
    }
    

    /**
     * If true, display thumbnails/icons for added files. If false, show only file names.
     *
     * @param showFileThumbnails New showFileThumbnails value. Default value is true
     * @return {@link com.smartgwt.client.widgets.FileDropZone FileDropZone} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public FileDropZone setShowFileThumbnails(Boolean showFileThumbnails)  throws IllegalStateException {
        return (FileDropZone)setAttribute("showFileThumbnails", showFileThumbnails, false);
    }

    /**
     * If true, display thumbnails/icons for added files. If false, show only file names.
     *
     * @return Current showFileThumbnails value. Default value is true
     */
    public Boolean getShowFileThumbnails()  {
        Boolean result = getAttributeAsBoolean("showFileThumbnails");
        return result == null ? true : result;
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.FileDropZone#getShowFileThumbnails showFileThumbnails} is true, should actual
     * image previews be generated for image files? If false, image files will show a generic image icon instead. Image
     * previews are generated using the FileReader API.
     *
     * @param showImagePreviews New showImagePreviews value. Default value is true
     * @return {@link com.smartgwt.client.widgets.FileDropZone FileDropZone} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public FileDropZone setShowImagePreviews(Boolean showImagePreviews)  throws IllegalStateException {
        return (FileDropZone)setAttribute("showImagePreviews", showImagePreviews, false);
    }

    /**
     * When {@link com.smartgwt.client.widgets.FileDropZone#getShowFileThumbnails showFileThumbnails} is true, should actual
     * image previews be generated for image files? If false, image files will show a generic image icon instead. Image
     * previews are generated using the FileReader API.
     *
     * @return Current showImagePreviews value. Default value is true
     */
    public Boolean getShowImagePreviews()  {
        Boolean result = getAttributeAsBoolean("showImagePreviews");
        return result == null ? true : result;
    }
    

    /**
     * Icon for spreadsheet files (Excel, CSV, etc.).
     *
     * @param spreadsheetFileIcon New spreadsheetFileIcon value. Default value is "[SKINIMG]FileDropZone/spreadsheet.png"
     * @return {@link com.smartgwt.client.widgets.FileDropZone FileDropZone} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public FileDropZone setSpreadsheetFileIcon(String spreadsheetFileIcon)  throws IllegalStateException {
        return (FileDropZone)setAttribute("spreadsheetFileIcon", spreadsheetFileIcon, false);
    }

    /**
     * Icon for spreadsheet files (Excel, CSV, etc.).
     *
     * @return Current spreadsheetFileIcon value. Default value is "[SKINIMG]FileDropZone/spreadsheet.png"
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public String getSpreadsheetFileIcon()  {
        return getAttributeAsString("spreadsheetFileIcon");
    }
    

    /**
     * Height in pixels for file thumbnails/icons.
     *
     * @param thumbnailHeight New thumbnailHeight value. Default value is 64
     * @return {@link com.smartgwt.client.widgets.FileDropZone FileDropZone} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public FileDropZone setThumbnailHeight(Integer thumbnailHeight)  throws IllegalStateException {
        return (FileDropZone)setAttribute("thumbnailHeight", thumbnailHeight, false);
    }

    /**
     * Height in pixels for file thumbnails/icons.
     *
     * @return Current thumbnailHeight value. Default value is 64
     */
    public Integer getThumbnailHeight()  {
        return getAttributeAsInt("thumbnailHeight");
    }
    

    /**
     * Width in pixels for file thumbnails/icons.
     *
     * @param thumbnailWidth New thumbnailWidth value. Default value is 64
     * @return {@link com.smartgwt.client.widgets.FileDropZone FileDropZone} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public FileDropZone setThumbnailWidth(Integer thumbnailWidth)  throws IllegalStateException {
        return (FileDropZone)setAttribute("thumbnailWidth", thumbnailWidth, false);
    }

    /**
     * Width in pixels for file thumbnails/icons.
     *
     * @return Current thumbnailWidth value. Default value is 64
     */
    public Integer getThumbnailWidth()  {
        return getAttributeAsInt("thumbnailWidth");
    }
    

    /**
     * Vertical alignment for drop zone content.
     *
     * @param valign New valign value. Default value is "center"
     * @return {@link com.smartgwt.client.widgets.FileDropZone FileDropZone} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public FileDropZone setValign(VerticalAlignment valign)  throws IllegalStateException {
        return (FileDropZone)setAttribute("valign", valign == null ? null : valign.getValue(), false);
    }

    /**
     * Vertical alignment for drop zone content.
     *
     * @return Current valign value. Default value is "center"
     */
    public VerticalAlignment getValign()  {
        return EnumUtil.getEnum(VerticalAlignment.values(), getAttribute("valign"));
    }
    

    /**
     * Icon for video files.
     *
     * @param videoFileIcon New videoFileIcon value. Default value is "[SKINIMG]FileDropZone/video.png"
     * @return {@link com.smartgwt.client.widgets.FileDropZone FileDropZone} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public FileDropZone setVideoFileIcon(String videoFileIcon)  throws IllegalStateException {
        return (FileDropZone)setAttribute("videoFileIcon", videoFileIcon, false);
    }

    /**
     * Icon for video files.
     *
     * @return Current videoFileIcon value. Default value is "[SKINIMG]FileDropZone/video.png"
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public String getVideoFileIcon()  {
        return getAttributeAsString("videoFileIcon");
    }
    

    // ********************* Methods ***********************
	/**
     * Cancel an in-progress upload/processing operation. <P> This will abort the active XHR request (if any), hide the
     * processing UI, and fire the {@link com.smartgwt.client.widgets.FileDropZone#processingCancelled processingCancelled()}
     * notification.
     */
    public native void cancelProcessing() /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "cancelProcessing", "");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.cancelProcessing();
    }-*/;

	/**
     * Clear all files from this fileDropZone.
     */
    public native void clearFiles() /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "clearFiles", "");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.clearFiles();
    }-*/;

	/**
     * Hide processing UI. Called when upload/processing completes.
     */
    public native void endProcessing() /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "endProcessing", "");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.endProcessing();
    }-*/;

	/**
     * Notification fired when files are successfully added (via drag or click).
     * @param files Files that were added
     */
    public native void filesAdded(com.google.gwt.core.client.JavaScriptObject[] files) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "filesAdded", "com.google.gwt.core.client.JavaScriptObject[]");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.filesAdded(@com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([Ljava/lang/Object;)(files));
    }-*/;

	/**
     * Notification fired when files are removed.
     * @param files Files that were removed
     */
    public native void filesRemoved(com.google.gwt.core.client.JavaScriptObject[] files) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "filesRemoved", "com.google.gwt.core.client.JavaScriptObject[]");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.filesRemoved(@com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([Ljava/lang/Object;)(files));
    }-*/;

	/**
     * Notification fired when an individual file upload completes (in concurrent mode).
     * @param file The file that completed
     * @param success Whether the upload succeeded
     * @param response The server response for this file
     */
    public native void fileUploadComplete(com.google.gwt.core.client.JavaScriptObject file, Boolean success, DSResponse response) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "fileUploadComplete", "com.google.gwt.core.client.JavaScriptObject,Boolean,DSResponse");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.fileUploadComplete(file, success == null ? null : success.@java.lang.Boolean::booleanValue()(), response.@com.smartgwt.client.core.DataClass::getJsObj()());
    }-*/;

	/**
     * Notification fired when an individual file upload fails (in concurrent mode).
     * @param file The file that failed
     * @param error Error message describing the failure
     */
    public native void fileUploadFailed(com.google.gwt.core.client.JavaScriptObject file, String error) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "fileUploadFailed", "com.google.gwt.core.client.JavaScriptObject,String");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.fileUploadFailed(file, error);
    }-*/;

	/**
     * Retrieves the files that have been added to this fileDropZone.
     *
     * @return JavaScript File objects added to this fileDropZone
     */
    public native com.google.gwt.core.client.JavaScriptObject[] getFiles() /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "getFiles", "");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getFiles();
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toArray(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

	/**
     * Get current progress percentage.
     *
     * @return Current percentage, or null if not processing
     */
    public native Integer getProcessingPercentDone() /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "getProcessingPercentDone", "");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getProcessingPercentDone();
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toInteger(I)(ret);
    }-*/;

	/**
     * Get the total size in bytes of all selected files.
     *
     * @return Total size in bytes, or 0 if no files
     */
    public native Integer getSize() /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "getSize", "");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getSize();
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toInteger(I)(ret);
    }-*/;

	/**
     * Notification fired when processing is cancelled via {@link com.smartgwt.client.widgets.FileDropZone#cancelProcessing
     * cancelProcessing()}. <P> This is a notification method intended for override. The FileDropZone itself does not perform
     * any network abort logic - it only manages local UI state (hiding progress, preserving files). When used as the canvas of
     * a {@link com.smartgwt.client.widgets.form.fields.FileUploadItem}, the item's default configuration overrides this method
     * to propagate the cancel to the containing {@link com.smartgwt.client.widgets.form.DynamicForm}, which handles aborting
     * any in-flight XHR upload request via {@link com.smartgwt.client.rpc.RPCManager#cancelQueue RPCManager.cancelQueue()}.
     * <P> For standalone FileDropZone usage (outside of FileUploadItem), implement this method to abort any custom upload
     * logic you have initiated.
     */
    public native void processingCancelled() /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "processingCancelled", "");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.processingCancelled();
    }-*/;

	/**
     * Remove a specific file from this fileDropZone.
     * @param file The file to remove, or its index
     */
    public native void removeFile(com.google.gwt.core.client.JavaScriptObject file) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "removeFile", "com.google.gwt.core.client.JavaScriptObject");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.removeFile(file);
    }-*/;

	/**
     * Remove a specific file from this fileDropZone.
     * @param file The file to remove, or its index
     */
    public native void removeFile(Integer file) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "removeFile", "Integer");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.removeFile(file == null ? null : file.@java.lang.Integer::intValue()());
    }-*/;


	/**
     * Update progress indication for a specific file during concurrent uploads.
     * @param file The file being uploaded
     * @param percentDone Progress percentage (0-100) for this file
     * @param processed Bytes processed so far for this file
     * @param total Total bytes for this file
     */
    public native void setFileProgress(com.google.gwt.core.client.JavaScriptObject file, double percentDone, Integer processed, Integer total) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "setFileProgress", "com.google.gwt.core.client.JavaScriptObject,double,Integer,Integer");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.setFileProgress(file, percentDone, processed == null ? null : processed.@java.lang.Integer::intValue()(), total == null ? null : total.@java.lang.Integer::intValue()());
    }-*/;

	/**
     * Programmatically populate a fileDropZone with files.
     * @param files JavaScript File object(s) to attach
     */
    public native void setFiles(com.google.gwt.core.client.JavaScriptObject files) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "setFiles", "com.google.gwt.core.client.JavaScriptObject");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.setFiles(files);
    }-*/;

	/**
     * Programmatically populate a fileDropZone with files.
     * @param files JavaScript File object(s) to attach
     */
    public native void setFiles(com.google.gwt.core.client.JavaScriptObject... files) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "setFiles", "com.google.gwt.core.client.JavaScriptObject...");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.setFiles(@com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([Ljava/lang/Object;)(files));
    }-*/;


	/**
     * Update progress indication during upload/processing.
     * @param percentDone Progress percentage (0-100)
     * @param processed Bytes processed so far
     * @param total Total bytes being processed
     *
     * @return false if no files selected, true otherwise
     */
    public native Boolean setProcessingProgress(double percentDone, Integer processed, Integer total) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "setProcessingProgress", "double,Integer,Integer");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.setProcessingProgress(percentDone, processed == null ? null : processed.@java.lang.Integer::intValue()(), total == null ? null : total.@java.lang.Integer::intValue()());
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(ret);
    }-*/;

	/**
     * Display an error when a drop fails validation. Default implementation calls isc.warn(). Override for custom handling.
     * @param errorMessage Error message to display
     */
    public native void showDropError(String errorMessage) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "showDropError", "String");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.showDropError(errorMessage);
    }-*/;

	/**
     * Show UI indicating processing has started. Masks the component and shows progressIndicator.
     *
     * @return false if no files selected, true otherwise
     */
    public native Boolean startProcessing() /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "startProcessing", "");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.startProcessing();
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(ret);
    }-*/;


    // ********************* Static Methods ***********************

    /** 
     * Class level method to set the default properties of this class.  If set, then all
     * existing and subsequently created instances of this class will automatically have
     * default properties corresponding to
     * the properties set on the SmartGWT class instance passed to this function before its
     * underlying SmartClient JS object was created.
     * This is a powerful feature that eliminates the need for users to create a separate
     * hierarchy of subclasses that only alter the default properties of this class. Can also
     * be used for skinning / styling purposes.  <P> <b>Note:</b> This method is intended for
     * setting default attributes only and will affect all instances of the underlying class
     * (including those automatically generated in JavaScript).  This method should not be used
     * to apply standard EventHandlers or override methods for a class - use a custom subclass
     * instead.  Calling this method after instances have been created can result in undefined
     * behavior, since it bypasses any setters and a class instance may have already examined 
     * a particular property and not be expecting any changes through this route.
     *
     * @param fileDropZoneProperties properties that should be used as new defaults when instances of this class are created
     * @see com.smartgwt.client.docs.SGWTProperties
     */
    public static native void setDefaultProperties(FileDropZone fileDropZoneProperties) /*-{
        if (fileDropZoneProperties.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Class;)(FileDropZone.@java.lang.Object::getClass()(), "setDefaultProperties", fileDropZoneProperties.@java.lang.Object::getClass()());
        }
        fileDropZoneProperties.@com.smartgwt.client.widgets.BaseWidget::setConfigOnly(Z)(true);
    	var properties = fileDropZoneProperties.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        properties = @com.smartgwt.client.util.JSOHelper::cleanProperties(Lcom/google/gwt/core/client/JavaScriptObject;Z)(properties,true);
        $wnd.isc.FileDropZone.addProperties(properties);
    }-*/;

    // ***********************************************************

    /**
     * Setter implementing the {@link com.smartgwt.client.core.LogicalStructure} interface,
     * which supports Eclipse's logical structure debugging facility.
     */
    public LogicalStructureObject setLogicalStructure(FileDropZoneLogicalStructure s) {
        super.setLogicalStructure(s);
        try {
            s.acceptedFileTypes = getAttributeAsStringArray("acceptedFileTypes");
        } catch (Throwable t) {
            s.logicalStructureErrors += "FileDropZone.acceptedFileTypesArray:" + t.getMessage() + "\n";
        }
        try {
            s.align = getAttributeAsString("align");
        } catch (Throwable t) {
            s.logicalStructureErrors += "FileDropZone.align:" + t.getMessage() + "\n";
        }
        try {
            s.archiveFileIcon = getAttributeAsString("archiveFileIcon");
        } catch (Throwable t) {
            s.logicalStructureErrors += "FileDropZone.archiveFileIcon:" + t.getMessage() + "\n";
        }
        try {
            s.audioFileIcon = getAttributeAsString("audioFileIcon");
        } catch (Throwable t) {
            s.logicalStructureErrors += "FileDropZone.audioFileIcon:" + t.getMessage() + "\n";
        }
        try {
            s.baseStyle = getAttributeAsString("baseStyle");
        } catch (Throwable t) {
            s.logicalStructureErrors += "FileDropZone.baseStyle:" + t.getMessage() + "\n";
        }
        try {
            s.canAddFilesOnClick = getAttributeAsString("canAddFilesOnClick");
        } catch (Throwable t) {
            s.logicalStructureErrors += "FileDropZone.canAddFilesOnClick:" + t.getMessage() + "\n";
        }
        try {
            s.codeFileIcon = getAttributeAsString("codeFileIcon");
        } catch (Throwable t) {
            s.logicalStructureErrors += "FileDropZone.codeFileIcon:" + t.getMessage() + "\n";
        }
        try {
            s.defaultFileIcon = getAttributeAsString("defaultFileIcon");
        } catch (Throwable t) {
            s.logicalStructureErrors += "FileDropZone.defaultFileIcon:" + t.getMessage() + "\n";
        }
        try {
            s.documentFileIcon = getAttributeAsString("documentFileIcon");
        } catch (Throwable t) {
            s.logicalStructureErrors += "FileDropZone.documentFileIcon:" + t.getMessage() + "\n";
        }
        try {
            s.imageFileIcon = getAttributeAsString("imageFileIcon");
        } catch (Throwable t) {
            s.logicalStructureErrors += "FileDropZone.imageFileIcon:" + t.getMessage() + "\n";
        }
        try {
            s.maxFiles = getAttributeAsString("maxFiles");
        } catch (Throwable t) {
            s.logicalStructureErrors += "FileDropZone.maxFiles:" + t.getMessage() + "\n";
        }
        try {
            s.maxFileSize = getAttributeAsString("maxFileSize");
        } catch (Throwable t) {
            s.logicalStructureErrors += "FileDropZone.maxFileSize:" + t.getMessage() + "\n";
        }
        try {
            s.maxSize = getAttributeAsString("maxSize");
        } catch (Throwable t) {
            s.logicalStructureErrors += "FileDropZone.maxSize:" + t.getMessage() + "\n";
        }
        try {
            s.minSize = getAttributeAsString("minSize");
        } catch (Throwable t) {
            s.logicalStructureErrors += "FileDropZone.minSize:" + t.getMessage() + "\n";
        }
        try {
            s.multiple = getAttributeAsString("multiple");
        } catch (Throwable t) {
            s.logicalStructureErrors += "FileDropZone.multiple:" + t.getMessage() + "\n";
        }
        try {
            s.pdfFileIcon = getAttributeAsString("pdfFileIcon");
        } catch (Throwable t) {
            s.logicalStructureErrors += "FileDropZone.pdfFileIcon:" + t.getMessage() + "\n";
        }
        try {
            s.removeIcon = getAttributeAsString("removeIcon");
        } catch (Throwable t) {
            s.logicalStructureErrors += "FileDropZone.removeIcon:" + t.getMessage() + "\n";
        }
        try {
            s.replaceFilesOnDrop = getAttributeAsString("replaceFilesOnDrop");
        } catch (Throwable t) {
            s.logicalStructureErrors += "FileDropZone.replaceFilesOnDrop:" + t.getMessage() + "\n";
        }
        try {
            s.showCancelButton = getAttributeAsString("showCancelButton");
        } catch (Throwable t) {
            s.logicalStructureErrors += "FileDropZone.showCancelButton:" + t.getMessage() + "\n";
        }
        try {
            s.showFileThumbnails = getAttributeAsString("showFileThumbnails");
        } catch (Throwable t) {
            s.logicalStructureErrors += "FileDropZone.showFileThumbnails:" + t.getMessage() + "\n";
        }
        try {
            s.showImagePreviews = getAttributeAsString("showImagePreviews");
        } catch (Throwable t) {
            s.logicalStructureErrors += "FileDropZone.showImagePreviews:" + t.getMessage() + "\n";
        }
        try {
            s.spreadsheetFileIcon = getAttributeAsString("spreadsheetFileIcon");
        } catch (Throwable t) {
            s.logicalStructureErrors += "FileDropZone.spreadsheetFileIcon:" + t.getMessage() + "\n";
        }
        try {
            s.thumbnailHeight = getAttributeAsString("thumbnailHeight");
        } catch (Throwable t) {
            s.logicalStructureErrors += "FileDropZone.thumbnailHeight:" + t.getMessage() + "\n";
        }
        try {
            s.thumbnailWidth = getAttributeAsString("thumbnailWidth");
        } catch (Throwable t) {
            s.logicalStructureErrors += "FileDropZone.thumbnailWidth:" + t.getMessage() + "\n";
        }
        try {
            s.valign = getAttributeAsString("valign");
        } catch (Throwable t) {
            s.logicalStructureErrors += "FileDropZone.valign:" + t.getMessage() + "\n";
        }
        try {
            s.videoFileIcon = getAttributeAsString("videoFileIcon");
        } catch (Throwable t) {
            s.logicalStructureErrors += "FileDropZone.videoFileIcon:" + t.getMessage() + "\n";
        }
        return s;
    }

    /**
     * Getter implementing the {@link com.smartgwt.client.core.LogicalStructure} interface,
     * which supports Eclipse's logical structure debugging facility.
     */
    public LogicalStructureObject getLogicalStructure() {
        FileDropZoneLogicalStructure s = new FileDropZoneLogicalStructure();
        setLogicalStructure(s);
        return s;
    }
}
