package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * For <code>SQLDataSource</code> only, the strategy to use to insert multiple records when  {@link
 * com.smartgwt.client.data.DataSource#addData addData()} is called with a list of records.
 */
public enum MultiInsertStrategy implements ValueEnum {
    /**
     * Iterate over the supplied list of records and issue a single-record add for each of them
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "simple".
     */
    SIMPLE("simple"),
    /**
     * Generate a single SQL statement that inserts multiple rows, using a database-specific strategy (usually specifying
     * multiple  <code>VALUES</code> clauses, but Oracle does not support that  approach so we implement the same behavior
     * using subselects).  Actually, depending on the number of records to insert and the  {@link
     * com.smartgwt.client.docs.serverds.DataSource#multiInsertBatchSize batch size}, this strategy  may generate more than one
     * SQL statement
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "multipleValues".
     */
    MULTIPLEVALUES("multipleValues");
    private String value;

    MultiInsertStrategy(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
