
package com.smartgwt.client.docs;

/**
 * <h3>Relations</h3>
 * Smart GWT allows relations to be declared between dataSources using the 
 * {@link com.smartgwt.client.data.DataSourceField#getForeignKey foreignKey} property.  Declaring
 * foreign key relations
 *  between dataSources enables multiple sophisticated and automatic behaviors.
 *  <h4>Relation types</h4>
 *  There are three types of dataSource relation:<ul>
 *  <li><b>Many-to-one</b>, where the dataSource at the "child" end of a relationship declares
 *  a foreignKey to the dataSource at the "parent" end.  The classic example is an OrderItem
 *  dataSource declaring a foreignKey relation to the Order dataSource.  Another example might
 *  be a City dataSource declaring a foreignKey to the Country dataSource
 *  <P>
 * The default editor for Many-to-one relation fields is a {@link
 * com.smartgwt.client.widgets.form.fields.SelectItem}, allowing the user to
 *  select a new value for the field from the options available in the related dataSource.
 *  </li>
 *  <li><b>One-to-many</b>, which is the opposite of many-to-one - the foreignKey is declared
 *  at the "parent" end.  Examples of this kind of relation are simply the opposite of the 
 *  many-to-one examples.
 *  <P>
 * The default editor for one-to-many relation fields is a {@link
 * com.smartgwt.client.widgets.form.fields.MultiPickerItem},
 *  allowing the user to select a new set of values for the field from the
 *  options available in the related dataSource.
 *  </li>
 *  <li><b>Many-to-many</b>, where the dataSources at both ends of the relation declare a 
 *  foreignKey to a third "middle" or "join" dataSource.  In a true many-to-many relation, the
 *  only information held in the "join" dataSource is the keys of the two related dataSources; 
 *  if any other information is stored in the "join" dataSource, it is no longer a many-to-many
 *  relation but two separate many-to-one relations.  An example of a true many-to-many 
 *  relation would be Employees to Teams: an Employee can be in multiple Teams, and a Team 
 *  consists of multiple Emloyees
 *  <P>
 * As with one-to-many relation fields, many-to-many fields will show a {@link
 * com.smartgwt.client.widgets.form.fields.MultiPickerItem}
 *  as the default editing interface.
 *  </li>
 *  </ul>
 *  For completeness, you could add <b>one-to-one</b> relations to this list, but in fact they
 *  are not particularly interesting.  Conceptually, a one-to-one relation is just a 
 *  many-to-one relation that happens to have only one record at the many end; there are no
 *  other special considerations, like there are with the other relation types.
 *  <h4>Many-to-one relations</h4>
 *  Many-to-one relations, where the "child" dataSource declares a foreignKey to the 
 *  "parent" dataSource, are the simplest type of relation, because they do not involve any
 *  requirement to handle multiple related records.  For these relations, Smart GWT supports 
 *  simple, code-free inclusion of fields from the parent into the child, with the 
 * {@link com.smartgwt.client.docs.serverds.DataSourceField#includeFrom includeFrom} mechanism. 
 * <code>includeFrom</code> fields
 *  will be automatically included from the parent dataSource whenever data is fetched from the
 *  child dataSource
 *  <p>
 *  Smart GWT does not support updating the "parent" dataSource fields across a many-to-one
 *  relation.  You can update the relation itself (by updating the <code>foreignKey</code>),
 *  but any fields that are included from the parent dataSource must be updated with a separate
 *  update operation on the parent dataSource
 *  <p>
 *  Many-to-one relations are supported for all dataSource types, both the built-in server 
 * dataSource types and {@link com.smartgwt.client.data.DataSource#getClientOnly clientOnly}
 * dataSources.  They are also
 *  supported without any extra effort with your own custom dataSource implementations on the
 *  server
 *  <h4>One-to-many relations</h4>
 *  One-to-many relations, where the "parent" dataSource declares a foreignKey to the 
 *  "child" dataSource, are more complicated than many-to-one relations because they involve a
 *  requirement to handle multiple related records.  You designate a one-to-many relation by 
 *  declaring both the <code>foreignKey</code> to the other dataSource and the 
 *  {@link com.smartgwt.client.data.DataSourceField#getMultiple multiple} property on the field.
 *  <p>
 *  The way this idea of multiple related records is handled varies according  to the 
 *  dataSource type:<ul>
 * <li>{@link com.smartgwt.client.docs.JpaIntegration JPA} and {@link
 * com.smartgwt.client.docs.HibernateIntegration Hibernate} dataSources, in 
 *  keeping with the underlying ORM ethos, take an <i>object-based</i> approach: the 
 *  related records are returned as a list of full-formed record objects, and it is possible 
 *  to update across the relation simply by modifying the properties of the related record(s) 
 *  and then updating the base record.  See the
 * {@link com.smartgwt.client.docs.JpaHibernateRelations JPA and Hibernate Relations} article for
 * more detail of
 *  JPA/Hibernate and relations</li>
 * <li>{@link com.smartgwt.client.docs.SqlDataSource SQL} dataSources take a <i>relational</i>
 * approach: the related 
 *  records are not returned directly, but rather a list of the key values required to fetch
 *  the related records from the related dataSource.  Therefore, an additional fetch is needed
 *  to fetch the actual related data.  Updates are likewise relational: your code provides the
 *  "new" list of related keys, and Smart GWT modifies the foreignKey values accordingly; no
 *  "child" records are created, updated or deleted in this process, the child records are 
 *  assumed to exist, and here we are just updating the relational information to link to them.
 *  Updating the actual data on the child record(s) is done with separate update operation(s)
 *  on the child dataSource</li>
 *  <li>One-to-many relations are not supported by other dataSource types</li>
 *  </ul>
 *  <h4>Many-to-many relations</h4>
 *  Many-to-many relations have the same complexities as one-to-many relations - they both 
 *  involve a requirement to handle multiple related records.  In addition, many-to-many 
 *  relations must manage the existence of an entry in a "join" dataSource.  You designate a
 *  many-to-many relation by declaring the <code>foreignKey</code> to the related dataSource, 
 * via the "join" dataSource, and the {@link com.smartgwt.client.data.DataSourceField#getMultiple
 * multiple} property, on 
 *  the foreignKey field of one of the dataSources in the many-to-many relation.  For example,
 *  declaring the <code>foreignKey</code> to Teams on the Employee dataSource (note the dots 
 *  indicating that the relation path to use is EmployeeTeams-&gt;Teams):<pre>
 *     &lt;field name="teams" multiple="true" foreignKey="EmployeeTeams.Teams.teamId" /&gt;
 *  </pre>
 *  The way this idea of multiple related records is handled is different according to 
 *  dataSource type, similar to one-to-many relations:<ul>
 *  <li>JPA and Hibernate dataSources take the same object-based approach: the related records
 *  are returned as a list of full-formed record objects, and it is possible to update across
 *  the relation simply by modifying the properties of the related record(s) and then updating
 *  the base record</li>
 *  <li>SQL dataSources again take a relational approach: instead of the related records, a 
 *  list of the key values required to fetch the related records from the related dataSource
 *  is returned.  Updates are also similar to one-to-many relations: your code provides the
 *  "new" list of related keys, and Smart GWT creates and deletes record in the "join" 
 *  dataSource as required.  No records are created, updated or deleted on the related 
 *  dataSource in this process.  As with one-to-mny relations, updating the actual data on the 
 *  related record(s) is done with separate update operation(s) on the related dataSource</li>
 *  <li>Many-to-many relations are not supported by other dataSource types</li>
 *  </ul>
     * @see com.smartgwt.client.docs.serverds.DataSourceField#foreignKey
     * @see com.smartgwt.client.docs.serverds.DataSourceField#multiple
     * @see com.smartgwt.client.docs.JpaHibernateRelations
 * @see com.smartgwt.client.types.JoinType
 * @see com.smartgwt.client.data.DBCField#getDisplayField
 * @see com.smartgwt.client.docs.serverds.DataSource#relatedTableAlias
 * @see com.smartgwt.client.data.DataSourceField#getPrimaryKey
 * @see com.smartgwt.client.data.DataSourceField#getForeignKey
 * @see com.smartgwt.client.data.DataSourceField#getChildrenProperty
 * @see com.smartgwt.client.data.DataSourceField#getRootValue
 * @see com.smartgwt.client.docs.serverds.DataSourceField#includeFrom
 * @see com.smartgwt.client.docs.serverds.DataSourceField#includeVia
 * @see com.smartgwt.client.docs.serverds.DataSourceField#relatedTableAlias
 * @see com.smartgwt.client.docs.serverds.DataSourceField#otherFKs
 * @see com.smartgwt.client.data.DataSourceField#getDisplayField
 * @see com.smartgwt.client.data.DataSourceField#getForeignDisplayField
 * @see com.smartgwt.client.docs.serverds.DataSourceField#joinType
 * @see com.smartgwt.client.data.DataSource#getChildrenField
 */
public interface DataSourceRelations {
}
