/*

  SmartClient Ajax RIA system
  Version SNAPSHOT_v15.0d_2026-01-27/LGPL Deployment (2026-01-27)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
//> @class LocatorEditor
// The LocatorEditor is a tool for displaying and editing AutoTest locators.
// <P>
// It consists of an expanded and a collapsed view.
// <P>
// In the collapsed view this component displays the locator in a read-only text box
// with an icon to copy to clipboard. It also shows the locator in pretty-printed 
// format on hover.
// <P>
// In the expanded view, the locator editor also shows a selector allowing the
// user to toggle between default and full-path format locators [with and without 
// search segments] and it creates a tile-layout to represent the segments
// of the locator.
// <ul><li>Hover over the segment-tiles to hilight the element for
//         the segment on the page and show a pretty printed hover prompt</li>
//     <li>Click the segment tile to truncate the locator as far as the segment</li>
// </ul>
// @visibility internal
//<

isc.defineClass("LocatorEditor", "VLayout");

isc.LocatorEditor.addProperties({
   
    width:500,

    membersMargin:5,

    defaultLayoutAlign:"center",
    canDragReposition:true,
    canDragResize:true,
    showEdges:true,

    backgroundColor:"lightgray",

    initWidget : function () {

        if (!this.expanded) this.setHeight(this.collapsedHeight);
        this.setResizeFrom(this.expanded ? null : ["L","R"]);
        
        this.stylePicker = this.createAutoChild(
            "stylePicker", 
            {
                visibility:this.expanded?"visible":"hidden",
                values:{style:this.locatorStyle}
            }
        );
        this.pathViewer = this.createAutoChild(
            "pathViewer", 
            {   
                visibility:this.expanded?"visible":"hidden"
            }
        );
        this.locatorDisplay = this.createAutoChild("locatorDisplay");

        this.setMembers([
            this.stylePicker,
            this.pathViewer,
            this.locatorDisplay
        ]);


        return this.Super("initWidget", arguments);
    },

    canExpand:true,
    expandUp:true, // by default expand by holding the bottom still and pushing upwards on the page.
    expanded:true,

    collapsedHeight:40,
    
    setExpanded:function (expanded) {
        if (this.expanded == expanded) return;
        if (expanded) {
            this.stylePicker.show();
            this.pathViewer.show();
        } else {
            this.stylePicker.hide();
            this.pathViewer.hide();
        }
        this.expanded = expanded;
        this.setResizeFrom(expanded ? null : ["L","R"]);
        var bottom = this.getBottom();
        if (!expanded) this.setHeight(this.collapsedHeight);
        this.reflowNow();
        if (this.expandUp) {
            this.setTop(Math.max(0,bottom-this.getVisibleHeight()));
        }
        this.locatorDisplay.markForRedraw();
    },

    stylePickerConstructor:"DynamicForm",
    stylePickerDefaults:{
        border:"1px solid black",
        numCols:1,
        height:30,
        width:"100%",
        defaultItems:[
            {name:"header", editorType:"StaticTextItem", wrap:false, clipValue:true,
                showTitle:false,
                width:"100%",
                height:22,
                value:"Roll over segments to highlight",
                // valueMap:{"default":"Show Locator", "full":"Show Full Path Locator"},
                
                icons:[
                    {
                        src:"[SKIN]/headerIcons/minimize.png",
                        prompt:"Collapse",
                        showIf : function (form,item) {
                            return form.creator.canExpand;
                        },
                        click : function (form, item, icon) {
                            form.creator.setExpanded(false);
                        }
                    }
                ]
            }           
            
        ],
        itemChange : function (item, newValue, oldValue) {
            return this.creator.updateLocatorStyle(newValue);
        }
    },

    // locatorStyle: Is this a default or full-path locator?
    
    locatorStyle:"full",
    updateLocatorStyle : function (style) {
        this.locatorStyle = style;
        this._updatingLocatorStyle = true;
        if (this.locator != null) {
            var element = isc.AutoTest.getElement(this.locator);
            if (element == null) return false;
            var roundTrip = style == "full" ? isc.AutoTest.getFullPathLocator(element) : this.getLocatorForElement(element);
            if (roundTrip == null) return false;

            this.setLocator(roundTrip);
        }
        delete this._updatingLocatorStyle;
    },
    
    getLocatorForElement : function (element) {
        return isc.AutoTest.getLocator(element);
    },

    setLocatorStyle : function (style, suppressUpdate) {
        if (style == this.locatorStyle) return;
        this.stylePicker.setValue("style", style);
        if (suppressUpdate) {
            this.locatorStyle = style;
        } else {
            this.updateLocatorStyle(style);
        }
    },    

    // pathViewer - horizontally scrollable widget showing all the path segments
    pathViewerConstructor:"HLayout",
    pathViewerDefaults:{

        border:"1px solid black",
        height:"*", minHeight:70,
        width:"100%",
        align:"right", 
        membersMargin:5,
        defaultLayoutAlign:"center", // center tiles vertically
        overflow:"auto"
    },

    // pathTiles - multi-auto child for each segment of the path
    // This is interactive in various ways
    // - rollOver to show full segment text in hover
    // - rollOver to highlight element on page
    pathTileConstructor:"Button",
    pathTileDefaults:{
        height:50,
        width:150,
        
        getTitle : function () {
            return this.segment;
        },
        setSegment : function (index, segment) {
            this.segmentIndex = index;
            this.segment = segment;
            this.markForRedraw();
        },

        // When a segment is skipped over due to a downstream search,
        // apply a disabled styling
        getStateSuffix : function () {
            if (this.excluded) {
                return "Disabled"
            }
            return this.Super("getStateSuffix", arguments);

        },
        excluded:false,
        setExcluded : function (excluded) {
            this.excluded = excluded;
            this.markForRedraw();
        },
        click : function () {
            if (this.excluded) return;
            this.customizeSegment();
        },
        // Show a menu to allow customization
        customizeSegment : function () {
            this.creator.showCustomizeMenu(this);
        },

        showHover:true, canHover:true,
        hoverWrap:false,
        getHoverHTML : function () {
            if (this.creator.customizeMenu && this.creator.customizeMenu.isVisible()) return;
            if (this.excluded) {
                return "Explicit locator segment not required";
            }
            var formattedLocator = this.creator.getFormattedLocator(this.cumulativeDisplayLocator);
            var displayValue = "<b>Hilighting on page:</b><br>" + formattedLocator;
            
            if (this.isSearchSegment) {
                displayValue += "<br><b>This segment uses search-syntax to find the target element</b>";
            }
            return displayValue;
        },
        mouseOver : function () {
            this.creator.hilightSegment(this.cumulativeLocator, this.segment, this.segmentIndex);
            
        }
    },

    customizeMenuConstructor:"Menu",
    showCustomizeMenu : function (target) {
        if (this.customizeMenu == null) {
            var locatorEditor = this;
            this.customizeMenu = this.createAutoChild("customizeMenu", {
                items:[
                    {
                        title:"Truncate to here",
                        enableIf:function(target,menu,item) {
                            return locatorEditor.pathViewer.members.length > (target.segmentIndex+1);
                        },
                        click:function (target,item,menu) {
                            locatorEditor.setLocator(target.cumulativeDisplayLocator);
                        }
                    }
                    

                ]
            });
        }
        this.customizeMenu.target = target;
        this.customizeMenu.showContextMenu();
    },

    hilightSegment : function (locator, segment, segmentIndex) {
        var canvas = isc.AutoTest.getObject(locator),
            element = isc.AutoTest.getElement(locator);
        
        // hiliteCanvas is preferable for widget-handles as reported element rects will not 
        // include space for childNodes necessarily so will appear too small
        if (isc.isA.Canvas(canvas) && 
            ((element == canvas.getHandle()) || (element == canvas.getHandle())))    
        {
            isc.Log.hiliteCanvas(canvas);
        } else {
            isc.Log.hiliteElement(element);
        }
        this.bringToFront();
        if (this.customizeMenu && this.customizeMenu.isVisible()) this.customizeMenu.bringToFront();
    },

    // locatorDisplay: Dynamic form showing the current locator with option to copy
    locatorDisplayConstructor:"DynamicForm",
    locatorDisplayDefaults:{

        border:"1px solid black",
        width:"100%", height:30,
        numCols:1,
        defaultItems:[{
            name:"locator",
            width:"*", height:"*",
            vAlign:"center",
            editorType:"TextItem",
            showTitle:false,
            canEdit:false,
            readOnlyDisplay:"readOnly",
            icons:[
                {
                    prompt:"Copy to clipboard",
                    disableOnReadOnly:false,
                    click : function (form, item, icon) {
                        form.creator.copyCurrentLocator();
                    }
                },
                {
                    src:"[SKIN]/headerIcons/maximize.png",
                    prompt:"Expand",
                    disableOnReadOnly:false,
                    showIf:function (form, item) {
                        return form.creator.canExpand && !form.creator.expanded;
                    },
                    click : function (form, item, icon) {
                        form.creator.setExpanded(true);
                    }
                }
            ]
        }],
        canHover:true,
        showHover:true,
        itemHoverWrap:false,
        itemHoverHTML : function (item) {
            return this.creator.getFormattedLocator(item.getValue());
        }
    },

    copyCurrentLocator : function () {
        var item = this.locatorDisplay.getItem("locator");
        var dataElement = item && item.getDataElement();
        if (dataElement) {
            dataElement.select();
            document.execCommand("copy");
            isc.notify("Locator copied to clipboard")
        }
    },

    // Helper to pretty-print the locator for display in hovers
    getFormattedLocator : function (locator) {

        if (locator == null || locator.length == 0) return null;

        var splitLocator = locator.split("/");
        var formattedLocator = "";
        var indent = "";
        // Crude tree structure for now
        for (var i = 0; i < splitLocator.length; i++) {
            
            if (i == 0 && splitLocator[i] == "") continue;

            formattedLocator += "/";
            // If splitLocator is "" we're dealing with double or triple slashes - just
            // load them up!
            if (splitLocator[i] != "") {
                formattedLocator += splitLocator[i]
                indent += "&nbsp;&nbsp;&nbsp;&nbsp;"
                formattedLocator += "<br>" + indent;
            }
        }
        return formattedLocator;
    },

    setLocator : function (locator) {
        var element = isc.AutoTest.getElement(locator);
        this.setLocatorForElement(element, locator);
    },

    setLocatorForElement : function (element, locator) {

        var fullLocator = isc.AutoTest.getFullPathLocator(element);
        
        var unresolvedExplicitLocator = false;
        if (locator == null && element != null) {
            
            if (this.locatorStyle == "full") locator = fullLocator;
            else locator = this.getLocatorForElement(element);
            

        } else if (locator != null) {

            

            // If an explicit locator was passed to us detect whether it is a full-path locator
            // If it includes search segements it is not.
            // This allows the user to toggle back to the other style.
            // Skip this if we're being invoked from updateLocator style, where we already know the
            // style we want to show
            // Note: search segments are not always available so there may be no difference between
            // the locators
            
            if (!this._updatingLocatorStyle) {
                var containsSearchSegments = (locator.startsWith("//:") || locator.substring(3,locator.length).contains("//"));
                var locatorStyle = containsSearchSegments ? "default" : "full";
                if (!this._updatingLocatorStyle && locatorStyle != this.locatorStyle) {
                    this.setLocatorStyle(locatorStyle, true);
                }
            }

        }

        this.targetElement = element;
        this.locator = locator;

        this.locatorDisplay.setValue("locator", locator);

        // pathViewer / pathTiles
        // Destroy all previous path tiles
        this.pathViewer.members.callMethod("markForDestroy");
        this.pathViewer.setMembers([]);

        // Anything less than 3 chars is not a valid locator that we can represent in tiles
        if (fullLocator == null || fullLocator.length < 3) return;

        // create new tiles for each segment of the full locator
        // We'll potentially disable/skip some of them if the locator we were
        // passed has search segments in it
        
        // prefix is either "//" or "///" - grab the first 3 chars regardless
        var fullLocatorPrefix = fullLocator.substring(0,3);
        fullLocator = fullLocator.substring(3, fullLocator.length);

        // Full Locator should have no search segments in it
        var splitFullLocator = fullLocator.split("/");
        splitFullLocator[0] = fullLocatorPrefix + splitFullLocator[0];

        var tiles = [];
        
        var cumulativeFullLocator = "";

        

        

        
        // These variables handle the case where we're remapping from a 
        // sparse locator with searches to a full locator in the UI
        var remapLocator = locator != fullLocator;
        var splitTargetLocator;
        if (remapLocator) {
            var locatorPrefix = locator.substring(0,3);
            locator = locator.substring(3, locator.length);
            var splitTargetLocator = locator.split("/"); // we're interested in 
            splitTargetLocator[0] = locatorPrefix + splitTargetLocator[0];
        }
        var remappedLocatorIndex = 0;
        var nextTargetLocatorSegment = remapLocator ? splitTargetLocator[0] : null; 
        var cumulativeTargetLocator = nextTargetLocatorSegment;
        var targetLocatorSegmentElement = remapLocator ? isc.AutoTest.getElement(cumulativeTargetLocator) : null;

        for (var i = 0; i < splitFullLocator.length; i++) {

            var fullLocatorSegment = splitFullLocator[i];
            if (i != 0) fullLocatorSegment = "/" + fullLocatorSegment;
            cumulativeFullLocator += fullLocatorSegment;

            var tileSegment = fullLocatorSegment;
            // Ignore trailing slash
            if (tileSegment == "/" && i == splitFullLocator.length-1) break;
            
            var locatorSegmentMatch = false;
            var cumulativeDisplayLocator = cumulativeFullLocator;
            if (remapLocator) {

                var fullLocatorSegmentElement = isc.AutoTest.getElement(cumulativeFullLocator);
                if (targetLocatorSegmentElement == fullLocatorSegmentElement) {
                    locatorSegmentMatch = true;
                    tileSegment = nextTargetLocatorSegment;

                    // set things up for the next loop
                    remappedLocatorIndex++;

                    nextTargetLocatorSegment = "/" + splitTargetLocator[remappedLocatorIndex];
                    // Handle double-slashes [splitTargetLocator[n] is empty string]
                    if (nextTargetLocatorSegment == "/") {
                        remappedLocatorIndex++;
                        nextTargetLocatorSegment += "/" + splitTargetLocator[remappedLocatorIndex];
                    }
                    cumulativeDisplayLocator = cumulativeTargetLocator;
                    cumulativeTargetLocator += nextTargetLocatorSegment;                
                    targetLocatorSegmentElement = isc.AutoTest.getElement(cumulativeTargetLocator);
                }
                
            }
            var excluded = locator != fullLocator && !locatorSegmentMatch;
            var isSearchSegment = false;
            if (!excluded && locator != fullLocator) {
                if (tileSegment == splitTargetLocator[0]) isSearchSegment = tileSegment.startsWith("//:");
                else isSearchSegment = tileSegment.startsWith("//");
            }

            var tile = this.createAutoChild("pathTile", {
                // cumulativeLocator is from the full locator - may not match the 
                // displayed tileSegment from a non-full-path locator with search elements.
                cumulativeLocator:cumulativeFullLocator, 
                cumulativeDisplayLocator:cumulativeDisplayLocator,
                segmentIndex:i,
                segment:tileSegment,
                excluded:excluded,
                isSearchSegment: isSearchSegment
            });
            tiles.push(tile);
        }

        this.pathViewer.setMembers(tiles);
        this.pathViewer.delayCall("scrollToRight", null, 100);

    }
    
});