/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.tools.stream;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
* <b><i><span style='color:red'>Note: this is currently an experimental feature and not
* covered by normal support guarantees. See {@link com.smartgwt.client.docs.Experimental
* Experimental Features} for more information.</span></i></b><br><br>
 * A JavaScript object representing an event captured by a {@link com.smartgwt.client.tools.stream.EventStream}.
 *  <code>EventStreamEvent</code>s may represent DOM events (wrapped by the {@link com.smartgwt.client.util.EventHandler}),
 *  or other operations such as {@link com.smartgwt.client.docs.Relogin relogins} or
 *  {@link com.smartgwt.client.docs.Reify Reify} file operations on screens and projects.
 *  <P>
 * An {@link com.smartgwt.client.tools.stream.EventStreamEvent#getEventType eventType} should always be present, but not
 * all properties
 *  will be present for a given <code>EventStreamEvent</code>, since their relevance depends on the
 *  <code>eventType</code>.
 *  <P>
 *  In addition to the instance attributes documented for <code>EventStreamEvent</code>, if
 *  we're capturing {@link com.smartgwt.client.tools.stream.EventStream#getCaptureMoveEvents move events} but not
 * {@link com.smartgwt.client.tools.stream.EventStream#getCaptureDragEvents drag events}, the move event starting a drag
 * will
 *  be tagged with the drag start <code>eventType</code> as a boolean attribute.  So for
 *  example,<pre>
 *      dragResizeStart: true</pre>
 *  might appear in the <code>EventStreamEvent</code> for a <code>mouseMove</code>, if it started
 *  a drag but we weren't capturing {@link com.smartgwt.client.tools.stream.EventStream#getCaptureDragEvents drag events}.
 * @see com.smartgwt.client.docs.Experimental Experimental Features
 */
@BeanFactory.FrameworkClass
public class EventStreamEvent extends DataClass {

    public static EventStreamEvent getOrCreateRef(JavaScriptObject jsObj) {
        if(jsObj == null) return null;
        return new EventStreamEvent(jsObj);
    }
        


    public EventStreamEvent(){
        
    }

    public EventStreamEvent(JavaScriptObject jsObj){
        
        setJavaScriptObject(jsObj);
    }



    // ********************* Properties / Attributes ***********************

    /**
     * Contains a count of the number of events (if any) collapsed into this event if collapsing is active, which includes:<ul>
     * <li>{@link com.smartgwt.client.tools.stream.EventStream#getCollapseMoveEvents move events} <li>{@link
     * com.smartgwt.client.tools.stream.EventStream#getCollapseKeyEvents key events} <li>{@link
     * com.smartgwt.client.tools.stream.EventStream#getCollapseWheelEvents wheel events} <li>{@link
     * com.smartgwt.client.tools.stream.EventStream#getCollapsePageEvents page events}</ul> The count, if present, includes the
     * event itself so it will always be a number greater than or equal to two.
     *
     * @return Current count value. Default value is null
     */
    public Integer getCount()  {
        return getAttributeAsInt("count");
    }
    

    /**
     * Present for {@link com.smartgwt.client.tools.stream.EventStream#getCaptureKeyEvents key events} if the control key was
     * down when the event got triggered.  Otherwise, not present.
     *
     * @return Current ctrlKey value. Default value is null
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getKeyName
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getShiftKey
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getMetaKey
     */
    public Boolean getCtrlKey()  {
        return getAttributeAsBoolean("ctrlKey", true);
    }
    

    /**
     * The {@link com.smartgwt.client.util.EventHandler#getWheelDeltaX horizontal scroll delta}, present for {@link
     * com.smartgwt.client.tools.stream.EventStream#getCaptureWheelEvents wheel events}.
     *
     * @return Current deltaX value. Default value is null
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getDeltaY
     */
    public Double getDeltaX()  {
        return getAttributeAsDouble("deltaX");
    }
    

    /**
     * The {@link com.smartgwt.client.util.EventHandler#getWheelDeltaX vertiacl scroll delta}, present for {@link
     * com.smartgwt.client.tools.stream.EventStream#getCaptureWheelEvents wheel events}.
     *
     * @return Current deltaY value. Default value is null
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getDeltaX
     */
    public Double getDeltaY()  {
        return getAttributeAsDouble("deltaY");
    }
    

    /**
     * Set on the event captured at the end of a drag if the drag is canceled.  This is normally an event such as
     * <code>dragStop</code>, <code>dragRepositionStop</code>, <code>dragResizeStop</code>, or <code>dragSelectStop</code>, but
     * if {@link com.smartgwt.client.tools.stream.EventStream#getCaptureDragEvents drag events} aren't being captured, this
     * property may be set on the <code>mouseUp</code> ending the drag.
     *
     * @return Current dragCanceled value. Default value is null
     */
    public Boolean getDragCanceled()  {
        return getAttributeAsBoolean("dragCanceled", true);
    }
    

    /**
     * The  class name of the {@link com.smartgwt.client.util.EventHandler#getDragTarget drag target}, present for most {@link
     * com.smartgwt.client.tools.stream.EventStream#getCaptureDragEvents drag events}. <P> Note that if drag events are not
     * being captured, it will be populated for the <code>mouseUp</code> event terminating the drag.
     *
     * @return Current dragTargetClass value. Default value is null
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getDragTargetID
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getDropTargetID
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getDropTargetClass
     */
    public String getDragTargetClass()  {
        return getAttributeAsString("dragTargetClass");
    }
    

    /**
     * The {@link com.smartgwt.client.widgets.Canvas#getID widget ID} of the {@link
     * com.smartgwt.client.util.EventHandler#getDragTarget drag target}, present for most {@link
     * com.smartgwt.client.tools.stream.EventStream#getCaptureDragEvents drag events}. <P> Note that if drag events are not
     * being captured, it will be populated for the <code>mouseUp</code> event terminating the drag.
     *
     * @return Current dragTargetID value. Default value is null
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getDropTargetID
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getDropTargetClass
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getDragTargetClass
     * @see com.smartgwt.client.docs.GlobalId GlobalId 
     */
    public String getDragTargetID()  {
        return getAttributeAsString("dragTargetID");
    }
    

    /**
     * The  class name of the {@link com.smartgwt.client.widgets.Canvas#drop drop target}, present for some {@link
     * com.smartgwt.client.tools.stream.EventStream#getCaptureDragEvents drag events}. <P> Note that if drag events are not
     * being captured, it will be populated for the <code>mouseUp</code> event terminating the drag.
     *
     * @return Current dropTargetClass value. Default value is null
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getDropTargetID
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getDragTargetID
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getDragTargetClass
     */
    public String getDropTargetClass()  {
        return getAttributeAsString("dropTargetClass");
    }
    

    /**
     * The {@link com.smartgwt.client.widgets.Canvas#getID widget ID} of the {@link com.smartgwt.client.widgets.Canvas#drop
     * drop target}, present for some {@link com.smartgwt.client.tools.stream.EventStream#getCaptureDragEvents drag events}.
     * <P> Note that if drag events are not being captured, it will be populated for the <code>mouseUp</code> event terminating
     * the drag.
     *
     * @return Current dropTargetID value. Default value is null
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getDragTargetID
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getDragTargetClass
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getDropTargetClass
     * @see com.smartgwt.client.docs.GlobalId GlobalId 
     */
    public String getDropTargetID()  {
        return getAttributeAsString("dropTargetID");
    }
    

    /**
     * Present along with {@link com.smartgwt.client.tools.stream.EventStreamEvent#getErrorTrace errorTrace} and {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getThreadCode threadCode} if the event triggering the error wasn't
     * already captured, and required adding a new event.  If a stream is configured to {@link
     * com.smartgwt.client.tools.stream.EventStream#getCaptureEventErrors capture event errors}, then through error reporting
     * it may capture {@link com.smartgwt.client.tools.stream.EventStreamEvent#getEventType eventType}s not specified by the
     * filters.
     *
     * @return Current errorEvent value. Default value is null
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getEventType
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getErrorTrace
     */
    public Boolean getErrorEvent()  {
        return getAttributeAsBoolean("errorEvent", true);
    }
    

    /**
     * The stack reported when a JavaScript error is hit processing an event.  The <code>errorTrace</code> contains an initial
     * description of the error, and formatting whitespace and newlines to make the trace readable.
     *
     * @return Current errorTrace value. Default value is null
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getThreadCode
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getErrorEvent
     */
    public String getErrorTrace()  {
        return getAttributeAsString("errorTrace");
    }
    

    /**
     * The type of the {@link com.smartgwt.client.tools.stream.EventStreamEvent}.  For DOM events, this is just the official
     * {@link com.smartgwt.client.util.EventHandler} name for the event, such as <code>mouseDown</code>.  Otherwise, it's
     * unique to {@link com.smartgwt.client.tools.stream.EventStream}, but should reflect what event was captured, such as
     * <code>fileLoad</code> or <code>relogin</code>.
     *
     * @return Current eventType value. Default value is null
     */
    public String getEventType()  {
        return getAttributeAsString("eventType");
    }
    

    /**
     * The {@link com.smartgwt.client.util.Page#getHeight page height}, present for page-level {@link
     * com.smartgwt.client.tools.stream.EventStream#getCapturePageEvents resize events}.
     *
     * @return Current height value. Default value is null
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getWidth
     */
    public Integer getHeight()  {
        return getAttributeAsInt("height");
    }
    

    /**
     * The name of the key that triggered this event, present for {@link
     * com.smartgwt.client.tools.stream.EventStream#getCaptureKeyEvents key events}.  For flexibility and ease of conversion to
     * formats such as Selenese, the <code>keyName</code> for self-inserting keys (e.g. alphanumerics, "!", "@", etc.) reflects
     * the actual character typed, factoring in the shift key.  This aligns with {@link
     * com.smartgwt.client.util.EventHandler#getKeyEventKey EventHandler.getKeyEventKey()} rather than {@link
     * com.smartgwt.client.util.EventHandler#getKey EventHandler.getKey()}, but refer to String for special keys. <p> Note that
     * the <code>keyName</code> for special keys may be more than one character, such as "Enter", or "Down".  For improved
     * {@link com.smartgwt.client.tools.stream.EventStream#getCollapseKeyEvents collapsing}, the space key is always reported
     * as the self-inserting key " ", rather than the special key "Space", since we can't collapse special and self-inserting
     * keys into one event.
     *
     * @return Current keyName value. Default value is null
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getShiftKey
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getCtrlKey
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getMetaKey
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getKeyNames
     */
    public String getKeyName()  {
        return getAttributeAsString("keyName");
    }
    

    /**
     * When {@link com.smartgwt.client.tools.stream.EventStream#getCollapseKeyEvents key event collapsing} is active and other
     * events have been collapsed into this one, contains a string representing the concatenated {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getKeyName keyNames} from the collapsed events.  The length of this
     * string should match {@link com.smartgwt.client.tools.stream.EventStreamEvent#getCount count}, and the first character in
     * the string should be {@link com.smartgwt.client.tools.stream.EventStreamEvent#getKeyName keyName}. <p> Note that only
     * self-inserting keys can be concentated by collapsing, not special keys.
     *
     * @return Current keyNames value. Default value is null
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getKeyName
     */
    public String getKeyNames()  {
        return getAttributeAsString("keyNames");
    }
    

    /**
     * The locator representing the event target, if one exists.  Designed to be robust, the the locator provides a
     * future-proof way to specify a {@link com.smartgwt.client.widgets.Canvas}, {@link
     * com.smartgwt.client.widgets.form.fields.FormItem}, or widget part such as a row of a {@link
     * com.smartgwt.client.widgets.grid.ListGrid}.
     *
     * @return Current locator value. Default value is null
     * @see com.smartgwt.client.util.AutoTest#getObject
     * @see com.smartgwt.client.docs.AutoTestLocator AutoTestLocator 
     */
    public String getLocator()  {
        return getAttributeAsString("locator");
    }
    

    /**
     * Present for {@link com.smartgwt.client.tools.stream.EventStream#getCaptureKeyEvents key events} if the meta key was down
     * when the event got triggered.  Otherwise, not present.
     *
     * @return Current metaKey value. Default value is null
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getKeyName
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getShiftKey
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getCtrlKey
     */
    public Boolean getMetaKey()  {
        return getAttributeAsBoolean("metaKey", true);
    }
    

    /**
     * For synthetic events (where the {@link com.smartgwt.client.util.EventHandler} has (re)dispatched a DOM event as a new
     * type), the original <code>eventType</code>.
     *
     * @return Current originalType value. Default value is null
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getSynthetic
     */
    public String getOriginalType()  {
        return getAttributeAsString("originalType");
    }
    

    /**
     * Present for {@link com.smartgwt.client.tools.stream.EventStream#getCaptureKeyEvents key events} if the shift key was
     * down when the event got triggered.  Otherwise, not present.
     *
     * @return Current shiftKey value. Default value is null
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getKeyName
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getCtrlKey
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getMetaKey
     */
    public Boolean getShiftKey()  {
        return getAttributeAsBoolean("shiftKey", true);
    }
    

    /**
     * True For synthetic events.  Otherwise, not present at all.  When true, {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getOriginalType originalType} should be set indicating the original
     * <code>eventType</code>.
     *
     * @return Current synthetic value. Default value is null
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getOriginalType
     */
    public Boolean getSynthetic()  {
        return getAttributeAsBoolean("synthetic", true);
    }
    

    /**
     * The  class name of the event target, if one exists. Page-level and non-DOM events may not have any target.
     *
     * @return Current targetClass value. Default value is null
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getTargetID
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getTargetX
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getTargetY
     */
    public String getTargetClass()  {
        return getAttributeAsString("targetClass");
    }
    

    /**
     * The {@link com.smartgwt.client.widgets.Canvas#getID widget ID} of the event target, if one exists.  Page-level and
     * non-DOM events may not have any target.
     *
     * @return Current targetID value. Default value is null
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getTargetClass
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getTargetX
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getTargetY
     * @see com.smartgwt.client.docs.GlobalId GlobalId 
     */
    public String getTargetID()  {
        return getAttributeAsString("targetID");
    }
    

    /**
     * The horizontal offset of the event from the {@link com.smartgwt.client.widgets.Canvas#getLeft left edge} of the event
     * target, if one exists.  Keyboard, page-level, and non-DOM events may not have any target.
     *
     * @return Current targetX value. Default value is null
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getTargetID
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getTargetClass
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getTargetY
     */
    public Integer getTargetX()  {
        return getAttributeAsInt("targetX");
    }
    

    /**
     * The vertical offset of the event from the {@link com.smartgwt.client.widgets.Canvas#getTop top edge} of the event
     * target, if one exists.  Keyboard, page-level, and non-DOM events may not have any target.
     *
     * @return Current targetY value. Default value is null
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getTargetID
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getTargetClass
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getTargetY
     */
    public Integer getTargetY()  {
        return getAttributeAsInt("targetY");
    }
    

    /**
     * A symbolic thead ID useful for debugging, present when a JavaScript error is hit processing an event.
     *
     * @return Current threadCode value. Default value is null
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getErrorTrace
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getErrorEvent
     */
    public String getThreadCode()  {
        return getAttributeAsString("threadCode");
    }
    

    /**
     * The time offset of this event from {@link com.smartgwt.client.tools.stream.EventStreamData#getStartTime
     * EventStreamData.startTime}, when capturing started, in milliseconds.
     *
     * @return Current timeOffset value. Default value is null
     */
    public Integer getTimeOffset()  {
        return getAttributeAsInt("timeOffset");
    }
    

    /**
     * The transaction <code>URL</code> associated wtih the successful {@link com.smartgwt.client.docs.Relogin relogin}.  Only
     * present for {@link com.smartgwt.client.tools.stream.EventStream#getCaptureLoginEvents login events}.
     *
     * @return Current URL value. Default value is null
     * @see com.smartgwt.client.docs.URL URL 
     */
    public String getURL()  {
        return getAttributeAsString("URL");
    }
    

    /**
     * The {@link com.smartgwt.client.util.Page#getWidth page width}, present for page-level {@link
     * com.smartgwt.client.tools.stream.EventStream#getCapturePageEvents resize events}.
     *
     * @return Current width value. Default value is null
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getHeight
     */
    public Integer getWidth()  {
        return getAttributeAsInt("width");
    }
    

    /**
     * The left offset of the event on the page.  This property typically won't be set unless no {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getTargetID target} is present and the event has an {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getErrorTrace errorTrace}.
     *
     * @return Current X value. Default value is null
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getY
     */
    public Integer getX()  {
        return getAttributeAsInt("X");
    }
    

    /**
     * The top offset of the event on the page.  This property typically won't be set unless no {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getTargetID target} is present and the event has an {@link
     * com.smartgwt.client.tools.stream.EventStreamEvent#getErrorTrace errorTrace}.
     *
     * @return Current Y value. Default value is null
     * @see com.smartgwt.client.tools.stream.EventStreamEvent#getX
     */
    public Integer getY()  {
        return getAttributeAsInt("Y");
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    // ***********************************************************

}
