package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * Indicates the response format to be used for a REST operation.  Is only applicable to  {@link
 * com.smartgwt.client.docs.ServerRestConnector RestConnector DataSources}.
 */
public enum RESTResponseFormat implements ValueEnum {
    /**
     * Indicates that the REST service response is a valid <a href=https://www.json.org/json-en.html>JSON</a> message. We will
     * parse the response text as JSON, and the resulting object structure can be further processed with {@link
     * com.smartgwt.client.data.DataSource#getRecordXPath XPaths},  {@link
     * com.smartgwt.client.docs.serverds.DataSource#responseTemplate templates} and  {@link
     * com.smartgwt.client.docs.serverds.DataSource#transformResponseScript scripting}
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "json".
     */
    JSON("json"),
    /**
     * Indicates that the REST service response is an XML message. We will parse the response text as XML, and the resulting
     * object structure can be further processed with  XPaths, templates and scripting
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "xml".
     */
    XML("xml"),
    /**
     * Indicates that the the REST service response is in delimited text format in the  body of the HTTP response. We will
     * parse the response text as delimited flat text data,  and the resulting object structure can be further processed with
     * scripting. Note, we do  not support XPaths because they do not make sense with flat data, and we also do not  support
     * templating of CSV responses. Record-level and field-level transformation scripts,  however, are applicable, and field
     * {@link com.smartgwt.client.data.DataSourceField#getNativeName nativeName}s are honored if the CSV text includes a header
     * row  <p> <code>RestConnector</code> only supports a couple options for CSV-based REST services - see  {@link
     * com.smartgwt.client.docs.serverds.DataSource#csvDelimiter DataSource.csvDelimiter} and {@link
     * com.smartgwt.client.docs.serverds.DataSource#csvQuoteCharacter DataSource.csvQuoteCharacter}
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "csv".
     */
    CSV("csv"),
    /**
     * Indicates that REST service response is to be treated simply as a piece of text, with no parsing or other processing
     * attempted. Use this format for services that return simple  strings or messages in some non-standard format; you can
     * provide your own parsing logic in a {@link com.smartgwt.client.docs.serverds.DataSource#transformResponseScript
     * transformResponseScript}
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "text".
     */
    TEXT("text");
    private String value;

    RESTResponseFormat(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
