package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * The mode for how AI should respond to AI-powered component view requests, such as filering, sorting, and hiliting via
 * AI. <p> The amount of interaction with AI is lowest in AI Assist mode. AIDE requires more interaction with AI, and
 * Hybrid mode requires the most amount of interaction. More interaction with AI generally requires more time to process
 * the component view request.
 */
public enum AIServiceMode implements ValueEnum {
    /**
     * AI Assist - AI is driving existing UI on the user's behalf. An example of this is: AI converts the user's description of
     * what records they would like to see into {@link com.smartgwt.client.data.AdvancedCriteria}.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "aiAssist".
     */
    AIASSIST("aiAssist"),
    /**
     * AI Data Enhance - Per-record augmentation or enhancements provided via AI. Examples of this are AI-generated fields,
     * where the field values are not in the records, but rather, supplied via AI.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "AIDE".
     */
    AIDE("AIDE"),
    /**
     * AI decides whether AI Assist, AIDE, or some combination of both approaches should be used to best respond to the
     * component view request.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "hybrid".
     */
    HYBRID("hybrid");
    private String value;

    AIServiceMode(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
