
package com.smartgwt.client.docs;

/**
 * <h3>String Methods Overview</h3>
 * A method flagged as a {@link com.smartgwt.client.docs.StringMethod} can be specified as a
 * String containing a valid
 *  JavaScript expression.  This expression will automatically be converted to a function
 *  with a return value matching the value of the last statement.  Providing a String is not
 *  required - you may use a real function instead.
 *  <p>
 *  For example - suppose you wanted to override the <code>leafClick()</code> method on
 *  the TreeGrid.  Normally you would do so as follows:<br>
 * 
 *  <pre>
 *  TreeGrid.create({
 *      ...
 *      leafClick : function(viewer, leaf, recordNum) { 
 *          if(leaf.name == 'zoo') { 
 *              alert(1); 
 *          } else {
 *              alert(2);
 *          }
 *      }
 *  });
 *  </pre>
 * 
 * Since leafClick is a {@link com.smartgwt.client.docs.StringMethod}, however, you can shorten
 * this to:<br>
 *  <pre>
 *  TreeGrid.create({
 *      ...
 *      leafClick : "if(leaf.name == 'zoo') { alert(1); } else { alert(2); }";
 *  });
 *  </pre>
 *  <P>
 *  <b>TypeScript Limitation</b>
 *  <P>
 *  When using Smart GWT with TypeScript, string methods cannot be used because TypeScript's
 *  type system cannot express that a property accepts either a function OR a string in
 *  configuration objects, while still being callable as a function on component instances.
 *  <P>
 *  In TypeScript code, always use arrow functions instead of string methods:
 *  <pre>
 *  isc.TreeGrid.create({
 *      ...
 *      leafClick: (viewer, leaf, recordNum) => {
 *          if (leaf.name == 'zoo') { alert(1); } else { alert(2); }
 *      }
 *  });
 *  </pre>
 *  Note that arrow functions capture the lexical <code>this</code>, so if your string method
 *  used <code>this</code> to reference the component, you should instead reference the
 *  component by its ID or via a variable.
 */
public interface StringMethods {
}
