/*

  SmartClient Ajax RIA system
  Version SNAPSHOT_v15.0d_2026-01-07/LGPL Deployment (2026-01-07)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
// A container that stores unique values.
// Note: This Set type does not have the same semantics as the proposed Set type of Harmony
// (ECMAScript 6). In particular, two Date objects are treated as the same if they represent
// the same time.
isc.defineClass("Set", isc.Map, null, true).addProperties({

    //> @method Set.has()
    // Returns <code>true</code> if this set contains the given value.
    // @param value (Any) the value to look for.
    // @return (boolean) <code>true</code> if this set contains <code>value</code>; <code>false</code>
    // otherwise.
    //<
    has : function (value) {
        return this.hasKey(value);
    },

    hasAll : function (values) {
        for (var i = 0, numValues = values.getLength(); i < numValues; ++i) {
            if (!this.has(values.get(i))) return false;
        }
        return true;
    },

    //> @method Set.add()
    // Adds a value to this set.
    // @param value (Any) the value to add.
    // @return (Set) this set.
    //<
    add : function (value) {
        this.put(value);
        return this;
    },

    addAll : function (values) {
        for (var i = 0, numValues = values.getLength(); i < numValues; ++i) {
            this.add(values.get(i));
        }
        return this;
    },

    //> @method Set.getContents()
    // Returns the contents of this set as an array, in no particular order.
    // @return (Array of Any) the contents of this set.
    //<
    getContents : function () {
        return this.getKeys();
    },

    equals : function (other) {
        if (this === other) return true;
        if (!isc.isA.Set(other)) return false;
        if (this.size != other.size) return false;

        var contents = this.getContents();
        this._assert(this.size == contents.length);
        for (var i = 0; i < contents.length; ++i) {
            if (!other.has(contents[i])) {
                return false;
            }
        }

        return true;
    }
});

isc.defineClass("TupleSet", null, null, true).addProperties({

    init : function () {
        this.Super("init", arguments);

        if (this._cloning) return;

        // verify that `N' (the dimension of tuples that this set contains) is an integer greater than or equal to 1
        this._assert(typeof this.N === "number" && !isNaN(this.N) && this.N === (this.N << 0) && this.N >= 1);
        this._map = isc.Map.create();
        this.size = 0;
        
    },

    has : function (tuple) {
        var map = this._map;
        for (var i = 0; i < this.N - 1; ++i) {
            var nestedMap = map.get(tuple[i]);
            if (nestedMap == null) return false;
            map = nestedMap;
        }
        return map.hasKey(tuple[this.N - 1]);
    },

    add : function (tuple) {
        var map = this._map;
        for (var i = 0; i < this.N - 1; ++i) {
            var nestedMap = map.get(tuple[i]);
            if (nestedMap == null) {
                nestedMap = isc.Map.create();
                map.put(tuple[i], nestedMap);
            }
            map = nestedMap;
        }
        if (map.hasKey(tuple[this.N - 1])) return this;
        map.put(tuple[this.N - 1]);
        ++this.size;
        
        return this;
    },

    remove : function (tuple) {
        var maps = [this._map];
        for (var i = 0; i < this.N - 1; ++i) {
            var nestedMap = maps[i].get(tuple[i]);
            if (nestedMap == null) return false;
            maps.add(nestedMap);
        }
        var result = maps[this.N - 1].remove(tuple[this.N - 1]);
        if (result) {
            --this.size;
            // If we removed something, clean up (remove) empty maps.
            for (var ri = this.N; ri > 1; --ri) {
                if (maps[ri - 1].isEmpty()) {
                    maps[ri - 2].remove(tuple[ri - 2]);
                } else {
                    break;
                }
            }
            
        }
        return result;
    },

    clear : function () {
        if (this.N == 1) {
            this._map.clear();
        } else {
            this._clear(0, this._map, this._map.getKeys());
            this._map.clear();
        }
        this.size = 0;
        
    },

    _clear : function (i, map, keys) {
        if (i >= this.N - 1) {
            map.clear();
            return;
        }
        for (var keyIndex = 0; keyIndex < keys.length; ++keyIndex) {
            var key = keys[keyIndex],
                nestedMap = map.get(key);
            this._clear(i + 1, nestedMap, i + 1 >= this.N - 1 ? null : nestedMap.getKeys());
        }
    },

    isEmpty : function () {
        return this.size == 0;
    },

    forEach : function (callback) {
        this._forEach(0, this._map, this._map.getKeys(), [], callback);
    },

    _forEach : function (i, map, keys, tuple, callback) {
        for (var keyIndex = 0; keyIndex < keys.length; ++keyIndex) {
            var key = keys[keyIndex];
            tuple[i] = key;
            if (i >= this.N - 1) {
                this.fireCallback(callback, "tuple", [tuple]);
            } else {
                var nestedMap = map.get(key);
                this._assert(isc.isA.Map(nestedMap));
                this._forEach(i + 1, nestedMap, nestedMap.getKeys(), tuple, callback);
            }
        }
    },

    map : function (callback) {
        var results = [];
        this.forEach(function (tuple) {
            results.add(this.fireCallback(callback, "tuple", [tuple]));
        });
        return results;
    },

    getContents : function () {
        return this.map(function (tuple) {
            return tuple.duplicate();
        });
    },

    _clonable: true,
    clone : function () {
        var clone = this.getClass().create({
            N: this.N,
            size: this.size,
            _cloning: true
        });
        delete clone._cloning;
        clone._map = this._map.clone();
        
        return clone;
    },

    equals : function (other) {
        if (this === other) return true;
        if (!isc.isA.TupleSet(other)) return false;
        if (this.N != other.N) return false;
        if (this.size != other.size) return false;

        return this._equals(0, this._map, other._map, this._map.getKeys());
    },

    _equals : function (i, map, otherMap, keys) {
        if (i >= this.N - 1) {
            if (otherMap.size != keys.length) return false;
            for (var keyIndex = 0; keyIndex < keys.length; ++keyIndex) {
                if (!otherMap.hasKey(keys[keyIndex])) return false;
            }
            return true;
        }

        for (var keyIndex = 0; keyIndex < keys.length; ++keyIndex) {
            var key = keys[keyIndex],
                nestedMap = map.get(key),
                // as a slight performance optimization, rather than checking whether `otherMap'
                // has the key, just use `nestedMap' as the default value. If otherMap.get()
                // returns `nestedMap', then we know that `otherMap' does not have this key.
                otherNestedMap = otherMap.get(key, nestedMap);
            // if `otherNestedMap' is identically `nestedMap', then `otherMap' does not have
            // a nested map for the key; thus, this TupleSet and the other TupleSet are not the same.
            if (nestedMap === otherNestedMap) {
                this._assert(!otherMap.hasKey(key));
                return false;
            }
            
            if (!this._equals(i + 1, nestedMap, otherNestedMap, nestedMap.getKeys())) return false;
        }

        return true;
    }

    
});
