package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} is true, whether  {@link
 * com.smartgwt.client.widgets.grid.ListGrid#getSelection getSelection()} on a {@link
 * com.smartgwt.client.widgets.DataBoundComponent} or individual  {@link com.smartgwt.client.widgets.grid.CellSelection}
 * should return one record per selected cell, as with {@link com.smartgwt.client.widgets.cube.CubeGrid},  or one record
 * per row that has any selected cells, as with {@link com.smartgwt.client.widgets.grid.ListGrid}.
 */
public enum CellRecordMode implements ValueEnum {
    /**
     * getSelection returns one record for each selected cell via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCellRecord getCellRecord()}
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "cell".
     */
    CELL("cell"),
    /**
     * getSelection returns distinct records for each row with one or more selected cells
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "row".
     */
    ROW("row");
    private String value;

    CellRecordMode(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
