
package com.smartgwt.client.docs;

/**
 * A CoT (Chain of Thought) is an AI workflow in which an LLM is repeatedly called and asked to
 * perform a series of small tasks as part of a larger goal. <p> In Smart GWT, CoTTask and
 * CoTProcess add declarative AI-based workflow features on top of core declarative workflow
 * features of {@link com.smartgwt.client.util.workflow.Process} and {@link
 * com.smartgwt.client.util.workflow.Task}. <p> Specifically, <code>CoTTask</code> implements a
 * default approach to prompt assembly within a CoT, has the logic to contact an AI (LLM),
 * automatically manages AI-driven  transitions between states of the workflow, and has features
 * for declaratively updating the shared {@link com.smartgwt.client.util.workflow.Process#getState
 * Process.state}, including a {@link com.smartgwt.client.docs.CoTHistory history mechanism} to
 * help the AI maintain context as it moves through the workflow (see {@link
 * com.smartgwt.client.docs.CoTExecutionModels}). <p> <code>CoTProcess</code> extends the existing
 * <code>Process</code> class with some features to coordinate with <code>CoTTask</code>, such as
 * providing  prompt pieces that are common to all tasks as well as centrally defining 
 * CoTProcess.optionalPrompts prompt parts that might be used by multiple tasks. <p> <h4>Debugging
 * with Partial Prompts</h4> When troubleshooting CoT workflows, {@link
 * com.smartgwt.client.docs.CoTPartialPrompt partial prompts} allow omitting irrelevant fragments
 * (boilerplate, large data) to focus on specific logic. Use  CoTProcess.getPartialPrompt() with
 * built-in modes like <code>"taskPromptOnly"</code> or <code>"transitionDebug"</code>.
 */
public interface CoT {
}
