/*

  SmartClient Ajax RIA system
  Version SNAPSHOT_v15.0d_2026-01-07/LGPL Deployment (2026-01-07)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
var libs =
	[
        // Event handling infrastructure (required by Canvas)
        "event/EventRegistry",          // Global event trapping mechanism
        "event/EventHandler",           // Cross-browser event handling framework

        // Core UI classes from ISC_Core
        "widgets/Element",              // DOM element manipulation helpers
        "widgets/Canvas",               // Base class for all visual components
        "widgets/Media",                // Static class for managing icons and fonts
        "widgets/PrintCanvas",          // Printing support
        "widgets/NotifyCore",           // Notification infrastructure
        "application/DataBoundComponent", // DataBoundComponent interface on Canvas
        "application/RuleScopeDBC",     // RuleScope DBC methods
        "widgets/EdgedCanvas",          // Rounded corners/edges support
        "widgets/Hover",                // Hover/tooltip management

        // Foundation widgets
        "widgets/Animation",            // Animation subsystem
        "widgets/StatefulCanvas",       // Canvas with visual states
        "widgets/Layout",               // Automatic child arrangement
        "widgets/Button",               // Button with up/down/disabled states
        "widgets/Img",                  // Positionable image
        "widgets/StretchImg",           // Composite stretched image
        "widgets/Label",                // Text label
        "widgets/Progressbar",          // Progress indicator
        "widgets/Rangebar",             // Range indicator
        "widgets/Toolbar",              // Collection of buttons
        "widgets/ImgButton",            // Image with button behavior
        "widgets/StretchImgButton",     // Stretch image with button behavior
        "widgets/Notify",               // Auto-dismissed notifications
        "widgets/ToolStrip",            // Narrow strip with mixed controls
        "widgets/RibbonBar",            // Toolstrip for RibbonButtons
        "widgets/SectionStack",         // Collapsible sections (Outlook-style)
        "widgets/Scrollbar",            // Image-based scrollbars
        "widgets/MinimalScrollbar",     // CSS-based scrollbars
        "widgets/NativeScrollbar",      // Native scrollbar wrapper
        "widgets/Splitbar",             // Layout resizer
        "widgets/StretchResizePolicy",  // Stretch resize calculations
        "widgets/NavigationBar",        // iOS-like navigation bar
        "widgets/SplitPane",            // Two-pane adaptive layout
        "widgets/NavStack",             // Navigation stack
        "widgets/Deck",                 // Card deck layout
        "widgets/NavPanel",             // Navigation panel
        "widgets/IconImgButton"         // Icon button
	];

//<STOP PARSING

// The following code handles dynamic loading in browser environments.
// For server-side JavaScript (Node.js, GraalJS), modules will be loaded via require() instead.
if (typeof window !== 'undefined') {
    // Browser environment - use dynamic script loading
    if (!window.isomorphicDir) window.isomorphicDir = "../isomorphic/";

    (function () {
        function loadLib(lib, hash) {
            if (hash == null) hash = "";
            document.write("<"+"script src='" + window.isomorphicDir + "client/" + lib + ".js" + hash + "' type='text/javascript' charset='UTF-8'><"+"/script>");
        }

        loadLib("language/startDefiningFramework", "#module=ServerUI");
        for (var i = 0, l = libs.length; i < l; ++i) {
            if (!libs[i]) continue;
            loadLib(libs[i]);
        }
        loadLib("language/stopDefiningFramework", "#module=ServerUI");
    })();
}
