package com.smartgwt.sample.showcase.client.reifyIntegration;

import java.util.Map;

import com.google.gwt.core.client.EntryPoint;
import com.smartgwt.client.callbacks.LoadProjectCallback;
import com.smartgwt.client.rpc.LoadProjectSettings;
import com.smartgwt.client.rpc.Project;
import com.smartgwt.client.rpc.RPCResponse;
import com.smartgwt.client.tools.Reify;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.ButtonItem;
import com.smartgwt.client.widgets.form.fields.events.ClickEvent;
import com.smartgwt.client.widgets.form.fields.events.ClickHandler;
import com.smartgwt.sample.showcase.client.data.ItemSupplyXmlDS;  
import com.smartgwt.sample.showcase.client.data.SupplyCategoryXmlDS; 
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;

public class ExtendingScreensReifySample extends ShowcasePanel {
    private static final String DESCRIPTION = "You can keep the official version of a screen design on a Reify "+
        "server, even as you extend it with custom event handlers in a standard SmartClient project."+
        "<p>"+
        "Here, the sample \"Simple Form\" project has been loaded from Reify.com, but a click handler has "+
        "been dynamically added, which performs some specialized validation before saving. Click the \"Save\" "+
        "button to see a warning message generated by the click handler, then check the \"In Stock\" button and "+
        "hit \"Save\" again to allow saving to proceed."+
        "<p>"+
        "This approach has a couple of uses:"+
        "<ul>"+
        "<li> developers who are working with screens in Reify have a \"just reload\" development cycle: change "+
        "the screen in Reify, reload the page in your SmartClient project, that's it!</li>"+
        "<li> production applications can be changed on the fly by editing screens within Reify. Very powerful, "+
        "so be careful with this!</li>"+
        "</ul>"+
        "Note that the custom logic shown here could be easily built with Reify! This sample is just meant to "+
        "show the principle of adding custom logic.";

    public static class Factory implements PanelFactory {
        private String id;

        public ShowcasePanel create() {
            ExtendingScreensReifySample panel = new ExtendingScreensReifySample();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    public Canvas getViewPanel() {
        final DataSource supplyCategoryDS = SupplyCategoryXmlDS.getInstance("supplyCategory");  
        final DataSource supplyItemDS = ItemSupplyXmlDS.getInstance("supplyItem", "supplyCategory"); 
        DataSource.get("supplyItem");
        DataSource.get("supplyCategory");

        final Canvas container = new Canvas();
		container.setWidth(600);
		container.setHeight(300);
		
		LoadProjectSettings settings = new LoadProjectSettings();
        settings.setUserName("reifySample");
        settings.setPassword("tryReify");
        settings.setServerURL("https://create.reify.com");
        
        Reify.loadProject("Simple Form", new LoadProjectCallback() {
            @Override
            public void execute(Project project, Project[] projects, RPCResponse rpcResponse) {
                Canvas screen = project.createScreen((project.getScreenNames()[0]));
                final DynamicForm saveForm = (DynamicForm)screen.getByLocalId("simpleForm");
                ButtonItem saveButton = (ButtonItem)saveForm.getField("saveDataButton");
                saveButton.addClickHandler(new ClickHandler() {
					@Override
					public void onClick(ClickEvent event) {
                        Map values = saveForm.getValues();
                        if (!Boolean.TRUE.equals((Boolean)values.get("inStock")) && values.get("nextShipment") == null) {  
                            SC.warn("New stock items which are not already stocked must have a Stock Date");  
                        }
					}
                });
				container.addChild(screen);
            }
        }, settings);

        return container;
    }

    public String getIntro() {
        return DESCRIPTION;
    }

    @Override  
    protected boolean isTopIntro() {  
        return true;  
    }

}
