/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.util;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * Standalone class providing a general interface for integration with Automated Testing Tools <p> <i>For an overview of
 * Automated Testing in Smart GWT, see the documentation {@link com.smartgwt.client.docs.AutomatedTesting here}.</i> <p>
 * <h2>AutoTestLocators</h2> The AutoTest class is responsible for creating and resolving {@link
 * com.smartgwt.client.docs.AutoTestLocator autoTestLocators} -  identifier strings which can reliably identify an
 * interactive element in a Smart GWT application. <P> These locators are designed to work across browsers, Smart GWT
 * versions, and even major changes to your application's UI. They do not rely on the DOM structure, and are intended to be
 * able to identify the target element reliably without requiring pervasive explicitly specified {@link
 * com.smartgwt.client.widgets.Canvas#getID component IDs}. <P> Note that AutoTest locators are the only supported way to
 * identify Smart GWT generated DOM elements when  recording tests for automated testing tools.  Using XPath DOM locators
 * to identify elements is not a supported approach. The DOM structure and DOM element attributes generated by Smart GWT
 * components are not guaranteed to be identical for functionally  equivalent elements across different Smart GWT builds,
 * different browsers, and for dynamically generated components, could even change across page reloads. <P> The primary
 * APIs for working with AutoTest locators are as follows: <ul><li>{@link com.smartgwt.client.util.AutoTest#getLocator
 * getLocator()} to retrieve a locator for an element</li>     <li>{@link com.smartgwt.client.util.AutoTest#getElement
 * getElement()} to resolve a stored locator back to an element</li> </ul> Developers should also be aware of the {@link
 * com.smartgwt.client.util.AutoTest#installLocatorShortcut installLocatorShortcut()} method  which allows you to retreive
 * locators via a simple key combo + mouseDown event on the target element. <p> See the {@link
 * com.smartgwt.client.docs.AutoTestLocator AutoTestLocator overview} documentation for details on how locators are
 * structured. <p> See the {@link com.smartgwt.client.docs.ReliableLocators Reliable AutoTestLocators overview}
 * documentation for best practices for generating high quality locators. <p> <h3>AutoTest locator variables</h3> AutoTest
 * locators may be written to include dynamic variables to be resolved at runtime. See the following APIs for details:
 * <ul><li>{@link com.smartgwt.client.util.AutoTest#setVariable setVariable()}: Set up a named variable for later use</li> 
 * <li>{@link com.smartgwt.client.util.AutoTest#storeLocatorResult storeLocatorResult()}: Resolve a locator against the
 * current environment          and store it as a variable</li>     <li>{@link
 * com.smartgwt.client.util.AutoTest#getVariable getVariable()}: Retrieves the value of a previously defined variable</li>
 * </ul> <h3>Locator testRoot</h3>  For tests that target a standard widget hierarchy such as a {@link
 * com.smartgwt.client.rpc.RPCManager#loadScreen screen}, the {@link com.smartgwt.client.util.AutoTest#testRoot testRoot}
 * may be used to reliably identify the widget hierarchy in question  wherever it is rendered inside a larger application.
 * <h2>Waiting for asynchronous operations</h2> The AutoTest class provides utilities to wait for asynchronous actions,
 * including both system delays (such as {@link com.smartgwt.client.widgets.Canvas#markForRedraw redraws that fire on
 * system idle}, for example), and  asynchronous {@link com.smartgwt.client.rpc.RPCManager RPC operations}. <ul><li>{@link
 * com.smartgwt.client.util.AutoTest#waitForElement waitForElement()}: this method will wait for asynchronous operations   
 * to complete before resolving an {@link com.smartgwt.client.docs.AutoTestLocator} to an element and firing a        
 * callback function. This allows recorded tests to reference elements that are blocked         or unavailable until some
 * asynchronous action(s) complete.</li>     <li>{@link com.smartgwt.client.util.AutoTest#waitForSystemDone
 * waitForSystemDone()}: this method will wait for any outstanding          asynchronous system operations to complete and
 * then fire the specified callback.</li>     <li>{@link com.smartgwt.client.util.AutoTest#isSystemDone isSystemDone()}:
 * this method may be called to check whether there         are currently any outstanding asynchronous system
 * operations.</li> </ul> Note that Smart GWT's support for integrating with high level tools such as {@link
 * com.smartgwt.client.docs.SmartClientPlaywright Playwright}, {@link com.smartgwt.client.docs.SmartClientCypress Cypress} 
 * and {@link com.smartgwt.client.docs.UsingSelenium Selenium} automatically makes use of these APIs.
 * @see com.smartgwt.client.docs.AutoTest AutoTest overview and related methods
 */
@BeanFactory.FrameworkClass
public class AutoTest {


    // ********************* Static Attributes ***********************

    // ********************* Properties / Attributes ***********************

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************


	/**
     * Convenience method to generate a {@link com.smartgwt.client.docs.AutoTestLocator} with no search segments and an
     * explicit path from the locator root to the target. <P> This method sets {@link
     * com.smartgwt.client.util.AutoTest#getLocator getLocator()} with the following   configuration settings: <ul> 
     * <li>useSearchSegments:false</li>  <li>useMinimalFallbackAttributes:false</li>  <li>useCompactFallbackSyntax:false</li>
     * </ul>
     *
     * @return full-path locator string to identify the target.
     * See {@link com.smartgwt.client.docs.AutoTestLocator AutoTestLocator}
     */
    public static native String getFullPathLocator() /*-{
        var ret = $wnd.isc.AutoTest.getFullPathLocator();
        return ret;
    }-*/;

    /**
     * See {@link AutoTest#getFullPathLocator(Element, boolean, java.lang.String[]) getFullPathLocator()}
     */
    public static String getFullPathLocator(Element target){
        return getFullPathLocator(target, false, null);
    }

    /**
     * See {@link AutoTest#getFullPathLocator(Element, boolean, java.lang.String[]) getFullPathLocator()}
     */
    public static String getFullPathLocator(Element target, boolean checkForNativeHandling){
        return getFullPathLocator(target, checkForNativeHandling, null);
    }

	/**
     * Convenience method to generate a {@link com.smartgwt.client.docs.AutoTestLocator} with no search segments and an
     * explicit path from the locator root to the target. <P> This method sets {@link
     * com.smartgwt.client.util.AutoTest#getLocator getLocator()} with the following   configuration settings: <ul> 
     * <li>useSearchSegments:false</li>  <li>useMinimalFallbackAttributes:false</li>  <li>useCompactFallbackSyntax:false</li>
     * </ul>
     * @param target Target within the page. This may be  a DOM element, a {@link com.smartgwt.client.widgets.Canvas} or a {@link
     * com.smartgwt.client.widgets.form.fields.FormItem}. If null, a locator for  the last mouse event target DOM element will
     * be generated.
     * @param checkForNativeHandling If this parameter is passed in, check whether  the target element responds to native browser events directly rather than
     * going through  the Smart GWT widget/event handling model. If we detect this case, return null rather  than a live
     * locator.  This allows us to differentiate between (for example) an event on  a Canvas handle, and an event occurring
     * directly on a simple   <code>&lt;a href=...&gt;</code> tag written inside a Canvas handle.
     * @param coords X, Y page position
     *
     * @return full-path locator string to identify the target.
     * See {@link com.smartgwt.client.docs.AutoTestLocator AutoTestLocator}
     */
    public static native String getFullPathLocator(Element target, boolean checkForNativeHandling, String[] coords) /*-{
        var ret = $wnd.isc.AutoTest.getFullPathLocator(target, checkForNativeHandling, coords);
        return ret;
    }-*/;
	


	/**
     * Returns the {@link com.smartgwt.client.util.QualityIndicatedLocator} associated with some DOM element in a Smart GWT
     * application page.  If coords, representing the page position, is passed in, the locator may be generated with a specific
     * trailing "target area" identifer that will map back to the appropriate, potentially different, physical coordinates,
     * even if the widget is moved.  The coords argument will only have an effect in cases where the mouse position over the
     * target could potentially change behavior.
     * @param DOMElement DOM element within in the page. If null the locator for  the last mouse event target will be generated
     *
     * @return Locator details allowing the AutoTest subsystem to find   an equivalent DOM element on subsequent page loads.
     */
    public static native QualityIndicatedLocator getLocatorWithIndicators(Element DOMElement) /*-{
        var ret = $wnd.isc.AutoTest.getLocatorWithIndicators(DOMElement);
        if(ret == null) return null;
        return @com.smartgwt.client.util.QualityIndicatedLocator::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

    /**
     * See {@link AutoTest#getLocatorWithIndicators(Element, boolean, java.lang.String[]) getLocatorWithIndicators()}
     */
    public static QualityIndicatedLocator getLocatorWithIndicators(Element DOMElement, boolean checkForNativeHandling){
        return getLocatorWithIndicators(DOMElement, checkForNativeHandling, null);
    }

	/**
     * Returns the {@link com.smartgwt.client.util.QualityIndicatedLocator} associated with some DOM element in a Smart GWT
     * application page.  If coords, representing the page position, is passed in, the locator may be generated with a specific
     * trailing "target area" identifer that will map back to the appropriate, potentially different, physical coordinates,
     * even if the widget is moved.  The coords argument will only have an effect in cases where the mouse position over the
     * target could potentially change behavior.
     * @param DOMElement DOM element within in the page. If null the locator for  the last mouse event target will be generated
     * @param checkForNativeHandling If this parameter is passed in, check whether  the target element responds to native browser events directly rather than
     * going through  the Smart GWT widget/event handling model. If we detect this case, return null rather  than a live
     * locator.  This allows us to differentiate between (for example) an event on  a Canvas handle, and an event occurring
     * directly on a simple   <code>&lt;a href=...&gt;</code> tag written inside a Canvas handle.
     * @param coords X, Y page position
     *
     * @return Locator details allowing the AutoTest subsystem to find   an equivalent DOM element on subsequent page loads.
     */
    public static native QualityIndicatedLocator getLocatorWithIndicators(Element DOMElement, boolean checkForNativeHandling, String[] coords) /*-{
        var ret = $wnd.isc.AutoTest.getLocatorWithIndicators(DOMElement, checkForNativeHandling, coords);
        if(ret == null) return null;
        return @com.smartgwt.client.util.QualityIndicatedLocator::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;
	

	/**
     * Convenience method to generate a {@link com.smartgwt.client.docs.AutoTestLocator} that is as compact as possible. <P>
     * This method sets {@link com.smartgwt.client.util.AutoTest#getLocator getLocator()} with the following   configuration
     * settings: <ul>  <li>useSearchSegments:true</li>  <li>searchSegmentsIncludeHidden:false</li> 
     * <li>useMinimalFallbackAttributes:true</li>  <li>useCompactFallbackSyntax:true</li> </ul>
     *
     * @return minimal locator string to identify the target.
     * See {@link com.smartgwt.client.docs.AutoTestLocator AutoTestLocator}
     */
    public static native String getMinimalLocator() /*-{
        var ret = $wnd.isc.AutoTest.getMinimalLocator();
        return ret;
    }-*/;

    /**
     * See {@link AutoTest#getMinimalLocator(Element, boolean, java.lang.String[]) getMinimalLocator()}
     */
    public static String getMinimalLocator(Element target){
        return getMinimalLocator(target, false, null);
    }

    /**
     * See {@link AutoTest#getMinimalLocator(Element, boolean, java.lang.String[]) getMinimalLocator()}
     */
    public static String getMinimalLocator(Element target, boolean checkForNativeHandling){
        return getMinimalLocator(target, checkForNativeHandling, null);
    }

	/**
     * Convenience method to generate a {@link com.smartgwt.client.docs.AutoTestLocator} that is as compact as possible. <P>
     * This method sets {@link com.smartgwt.client.util.AutoTest#getLocator getLocator()} with the following   configuration
     * settings: <ul>  <li>useSearchSegments:true</li>  <li>searchSegmentsIncludeHidden:false</li> 
     * <li>useMinimalFallbackAttributes:true</li>  <li>useCompactFallbackSyntax:true</li> </ul>
     * @param target Target within the page. This may be  a DOM element, a {@link com.smartgwt.client.widgets.Canvas} or a {@link
     * com.smartgwt.client.widgets.form.fields.FormItem}. If null, a locator for  the last mouse event target DOM element will
     * be generated.
     * @param checkForNativeHandling If this parameter is passed in, check whether  the target element responds to native browser events directly rather than
     * going through  the Smart GWT widget/event handling model. If we detect this case, return null rather  than a live
     * locator.  This allows us to differentiate between (for example) an event on  a Canvas handle, and an event occurring
     * directly on a simple   <code>&lt;a href=...&gt;</code> tag written inside a Canvas handle.
     * @param coords X, Y page position
     *
     * @return minimal locator string to identify the target.
     * See {@link com.smartgwt.client.docs.AutoTestLocator AutoTestLocator}
     */
    public static native String getMinimalLocator(Element target, boolean checkForNativeHandling, String[] coords) /*-{
        var ret = $wnd.isc.AutoTest.getMinimalLocator(target, checkForNativeHandling, coords);
        return ret;
    }-*/;
	




	/**
     * This method allows developers to retrieve locators for elements on the page via a key-combo plus mouseDown on the
     * element in question.<br> It may be invoked from a bookmarklet stored in the browser, giving developers a one-click way
     * to retrieve locators for any Smart GWT application <P> When installLocatorShortcut() is invoked, it will register a
     * Page-level <code>mouseDown</code> handler which, if the Shift+Ctrl or Shift+Meta key-combo are being held down will
     * display the locator for the element under the mouse in a text-box and also copy it to clipboard. <P> As with the {@link
     * com.smartgwt.client.docs.Debugging isc.showConsole()} method, developers may wish to create a  bookmark in their browser
     * to quickly enable this functionality on any Smart GWT  application, without any changes to the application code: <ol>
     * <li>Create a new bookmark in your browser.</li> <li>Enter url "javascript:isc.AutoTest.installLocatorShortcut()".</li>
     * <li>Label the bookmark as "Locator Shortcut"</li> <li>Consider adding this to the Bookmarks Toolbar. This allows you to
     * enable the  feature with a single click from any Smart GWT application.</li> </ol> <P> To uninstall the locator
     * shortcut, call {@link com.smartgwt.client.util.AutoTest#uninstallLocatorShortcut uninstallLocatorShortcut()}
     */
    public static native void installLocatorShortcut() /*-{
        $wnd.isc.AutoTest.installLocatorShortcut();
    }-*/;


	/**
     * Returns whether the canvas is in a consistent state with no pending operations.  Returns null if the supplied argument
     * is not a valid canvas. Otherwise, returns true or false according as the conditions below are all satisfied: <ul>    
     * <li> page has finished loading     <li> canvas is drawn     <li> canvas isn't dirty     <li> canvas has no queued
     * overflow operations     <li> canvas is not animating </ul>
     * @param canvas canvas to test
     *
     * @return whether  canvas is 'done' as described above
     */
    public static native Boolean isCanvasDone(Canvas canvas) /*-{
        var ret = $wnd.isc.AutoTest.isCanvasDone(canvas == null ? null : canvas.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()());
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(ret);
    }-*/;


	/**
     * Returns whether the instance is ready to be clicked on by a Selenium test.  Returns null if the  supplied instance is
     * not a valid canvas or form item. Otherwise, returns true or false according as the conditions below are all satisfied:
     * <ul>     <li> page has finished loading     <li> no network operations are outstanding (configurable,           see
     * {@link com.smartgwt.client.util.AutoTest#implicitNetworkWait implicitNetworkWait})     <li> canvas is visible, enabled,
     * and not masked,     <li> canvas satisfies {@link com.smartgwt.client.util.AutoTest#isCanvasDone isCanvasDone()}     <li>
     * if canvas is a TileGrid, it satisfies {@link com.smartgwt.client.util.AutoTest#isTileGridDone isTileGridDone()}     <li>
     * if canvas is a TileLayout, it satisfies {@link com.smartgwt.client.util.AutoTest#isTileLayoutDone isTileLayoutDone()}   
     * <li> if canvas is a ListGrid or body of a ListGrid, it satisfies {@link com.smartgwt.client.util.AutoTest#isGridDone
     * isGridDone()}     <li> if canvas is a DynamicForm, it satisfies {@link com.smartgwt.client.util.AutoTest#isFormDone
     * isFormDone()} </ul> Note that for a form item in a DynamicForm, the DynamicForm must satisfy the third condition above,
     * while the container widget of the element must satisfy the remaining conditions.
     * @param canvas instance to test
     *
     * @return whether  instance is 'clickable' as described above
     */
    public static native Boolean isElementClickable(Canvas canvas) /*-{
        var ret = $wnd.isc.AutoTest.isElementClickable(canvas == null ? null : canvas.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()());
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(ret);
    }-*/;

	/**
     * Returns whether the instance is ready to be clicked on by a Selenium test.  Returns null if the  supplied instance is
     * not a valid canvas or form item. Otherwise, returns true or false according as the conditions below are all satisfied:
     * <ul>     <li> page has finished loading     <li> no network operations are outstanding (configurable,           see
     * {@link com.smartgwt.client.util.AutoTest#implicitNetworkWait implicitNetworkWait})     <li> canvas is visible, enabled,
     * and not masked,     <li> canvas satisfies {@link com.smartgwt.client.util.AutoTest#isCanvasDone isCanvasDone()}     <li>
     * if canvas is a TileGrid, it satisfies {@link com.smartgwt.client.util.AutoTest#isTileGridDone isTileGridDone()}     <li>
     * if canvas is a TileLayout, it satisfies {@link com.smartgwt.client.util.AutoTest#isTileLayoutDone isTileLayoutDone()}   
     * <li> if canvas is a ListGrid or body of a ListGrid, it satisfies {@link com.smartgwt.client.util.AutoTest#isGridDone
     * isGridDone()}     <li> if canvas is a DynamicForm, it satisfies {@link com.smartgwt.client.util.AutoTest#isFormDone
     * isFormDone()} </ul> Note that for a form item in a DynamicForm, the DynamicForm must satisfy the third condition above,
     * while the container widget of the element must satisfy the remaining conditions.
     * @param item instance to test
     *
     * @return whether  instance is 'clickable' as described above
     */
    public static native Boolean isElementClickable(FormItem item) /*-{
        var ret = $wnd.isc.AutoTest.isElementClickable(item.@com.smartgwt.client.core.DataClass::getJsObj()());
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(ret);
    }-*/;


	/**
     * Given a DOM element, returns whether the associated Smart GWT Canvas or FormItem is ready to receive keyPress events
     * from a Selenium test.  Returns null if the locator is not valid or doesn't represent a valid Canvas or FormItem. 
     * Otherwise, returns true or false  according as the conditions below are all satisfied: <ul>     <li> page has finished
     * loading     <li> if a {@link com.smartgwt.client.widgets.form.fields.TextItem}, {@link
     * com.smartgwt.client.widgets.form.fields.FileItem}, or {@link com.smartgwt.client.widgets.form.fields.TextAreaItem},     
     * it has native focus,     <li> the element satisfies {@link com.smartgwt.client.util.AutoTest#isElementClickable
     * isElementClickable()} </ul>
     * @param canvas DOM element to test     (element obtained from canvas, form item, or Smart GWT locator if provided)
     *
     * @return whether element is 'ready' as described above
     */
    public static native Boolean isElementReadyForKeyPresses(Canvas canvas) /*-{
        var ret = $wnd.isc.AutoTest.isElementReadyForKeyPresses(canvas == null ? null : canvas.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()());
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(ret);
    }-*/;

	/**
     * Given a DOM element, returns whether the associated Smart GWT Canvas or FormItem is ready to receive keyPress events
     * from a Selenium test.  Returns null if the locator is not valid or doesn't represent a valid Canvas or FormItem. 
     * Otherwise, returns true or false  according as the conditions below are all satisfied: <ul>     <li> page has finished
     * loading     <li> if a {@link com.smartgwt.client.widgets.form.fields.TextItem}, {@link
     * com.smartgwt.client.widgets.form.fields.FileItem}, or {@link com.smartgwt.client.widgets.form.fields.TextAreaItem},     
     * it has native focus,     <li> the element satisfies {@link com.smartgwt.client.util.AutoTest#isElementClickable
     * isElementClickable()} </ul>
     * @param item DOM element to test     (element obtained from canvas, form item, or Smart GWT locator if provided)
     *
     * @return whether element is 'ready' as described above
     */
    public static native Boolean isElementReadyForKeyPresses(FormItem item) /*-{
        var ret = $wnd.isc.AutoTest.isElementReadyForKeyPresses(item.@com.smartgwt.client.core.DataClass::getJsObj()());
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(ret);
    }-*/;


	/**
     * Returns whether the DynamicForm is in a consistent state with no pending operations.  Returns null if the supplied
     * argument is not a valid {@link com.smartgwt.client.widgets.form.DynamicForm}.  Otherwise, returns true or false
     * according as the conditions below are all satisfied: <ul>     <li> page has finished loading     <li> form has no
     * pending delayed "set values" or "set values focus" operations     <li> all contained items satisfy {@link
     * com.smartgwt.client.util.AutoTest#isItemDone isItemDone()} </ul>
     * @param canvas canvas to test
     *
     * @return whether  canvas is 'done' as described above
     */
    public static native Boolean isFormDone(Canvas canvas) /*-{
        var ret = $wnd.isc.AutoTest.isFormDone(canvas == null ? null : canvas.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()());
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(ret);
    }-*/;


	/**
     * Returns whether the ListGrid supplied or containing the supplied canvas is in a consistent state with no pending
     * operations.  Returns null if the supplied canvas is not a ListGrid or contained in a ListGrid.  Otherwise, returns true
     * or false according as the conditions below are all satisfied: <ul>     <li> page has finished loading     <li> no
     * pending scroll operations     <li> no pending filter editor operations     <li> no unsaved edits to the grid records    
     * <li> no asynchronous regrouping operations are in progress     <li> no outstanding fetch/filter operations are present
     * for the ResultSet     <li> no outstanding sort operations are present that will update the ListGrid </ul>
     * @param canvas canvas to test
     *
     * @return whether  canvas is 'done' as described above
     */
    public static native Boolean isGridDone(Canvas canvas) /*-{
        var ret = $wnd.isc.AutoTest.isGridDone(canvas == null ? null : canvas.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()());
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(ret);
    }-*/;


	/**
     * Returns whether the FormItem is in a consistent state with no pending operations.  Returns null if the supplied argument
     * is not a valid {@link com.smartgwt.client.widgets.form.fields.FormItem}.  Otherwise, returns true or false according as
     * the conditions below are all satisfied: <ul>     <li> page has finished loading     <li> if the container widget of the
     * item isn't the parent DynamicForm, then the          container widget must satisfy {@link
     * com.smartgwt.client.util.AutoTest#isCanvasDone isCanvasDone()} (or {@link com.smartgwt.client.util.AutoTest#isGridDone
     * isGridDone()},          etc., as appropriate)     <li> the item cannot have any fetches in progress for missing
     * display/value field          values     <li> picklists ({@link com.smartgwt.client.widgets.form.fields.SelectItem} or
     * {@link com.smartgwt.client.widgets.form.fields.ComboBoxItem}) cannot have any pending row          fetches     <li> any
     * contained {@link com.smartgwt.client.widgets.form.fields.FormItem}s must satisfy <code>isItemDone()</code> themselves   
     * <li> any contained {@link com.smartgwt.client.widgets.Canvas} must satisfy {@link
     * com.smartgwt.client.util.AutoTest#isCanvasDone isCanvasDone()} (or           {@link
     * com.smartgwt.client.util.AutoTest#isGridDone isGridDone()}, etc., as appropriate) </ul>
     * @param item canvas to test
     *
     * @return whether  item is 'done' as described above
     */
    public static native Boolean isItemDone(FormItem item) /*-{
        var ret = $wnd.isc.AutoTest.isItemDone(item.@com.smartgwt.client.core.DataClass::getJsObj()());
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(ret);
    }-*/;


	/**
     * Returns a boolean to indicate whether the current application is fully loaded with no pending  operations, and is ready
     * for user interaction. This includes the following checks: <ul>     <li> page has finished loading     <li> all ListGrids
     * (as defined by isc.isA.ListGrid) satisfy {@link com.smartgwt.client.util.AutoTest#isGridDone isGridDone()}     <li> all
     * TileGrids that are drawn satisfy {@link com.smartgwt.client.util.AutoTest#isTileGridDone isTileGridDone()}     <li> all
     * TileLayouts that are drawn satisfy {@link com.smartgwt.client.util.AutoTest#isTileLayoutDone isTileLayoutDone()}    
     * <li> all DynamicForms that are drawn satisfy {@link com.smartgwt.client.util.AutoTest#isFormDone isFormDone()}     <li>
     * all Canvii that are drawn satisfy {@link com.smartgwt.client.util.AutoTest#isCanvasDone isCanvasDone()} </ul> In
     * addition to this the <code>options</code> parameter allows developers to check additional criteria as documented under
     * {@link com.smartgwt.client.util.SystemDoneConfig}. <P> Note: {@link com.smartgwt.client.util.AutoTest#waitForSystemDone
     * waitForSystemDone()} will poll this method repeatedly to check for all pending  actions being complete. The {@link
     * com.smartgwt.client.util.SystemWaitConfig} parameter of that method  allow the user to speciofy which actions to wait
     * for. By default {@link com.smartgwt.client.util.AutoTest#waitForSystemDone waitForSystemDone()} will wait for <i>all</i>
     * actions to complete, including queued redraws, timers, network requests, as well as page load and comopnent level
     * <code>is<i>Component</i>Done</code> checks. <P> Depending on your application configuration, it is possible that this
     * method will not be able to determine whether it is truly in a busy state. Some examples include: <ul>  <li>If {@link
     * com.smartgwt.client.util.SystemDoneConfig#getIncludeTimers SystemDoneConfig.includeTimers} is true and the application
     * has      a constantly running background timer to perform some      ongoing polling action or similar, this method may
     * return <code>false</code>      even though the application is ready for interaction  </li>  <li>Similarly if {@link
     * com.smartgwt.client.util.SystemDoneConfig#getIncludeRedraws SystemDoneConfig.includeRedraws} is true, and the
     * application is      using messaging, or some other mechanism to periodically refresh component(s)      such that they
     * are repeatedly marked as dirty, this method may return      <code>false</code> even though the application is ready for
     * interaction  </li>  <li>If this application makes use of some third-party library to perform      asynchronous actions,
     * this method may return <code>true</code> even when      the application is waiting on a response from this third-party
     * tool.  </li> </ul>
     *
     * @return whether loaded page is 'done' as described above
     */
    public static native boolean isSystemDone() /*-{
        var ret = $wnd.isc.AutoTest.isSystemDone();
        return ret == null ? false : ret;
    }-*/;

	/**
     * Returns a boolean to indicate whether the current application is fully loaded with no pending  operations, and is ready
     * for user interaction. This includes the following checks: <ul>     <li> page has finished loading     <li> all ListGrids
     * (as defined by isc.isA.ListGrid) satisfy {@link com.smartgwt.client.util.AutoTest#isGridDone isGridDone()}     <li> all
     * TileGrids that are drawn satisfy {@link com.smartgwt.client.util.AutoTest#isTileGridDone isTileGridDone()}     <li> all
     * TileLayouts that are drawn satisfy {@link com.smartgwt.client.util.AutoTest#isTileLayoutDone isTileLayoutDone()}    
     * <li> all DynamicForms that are drawn satisfy {@link com.smartgwt.client.util.AutoTest#isFormDone isFormDone()}     <li>
     * all Canvii that are drawn satisfy {@link com.smartgwt.client.util.AutoTest#isCanvasDone isCanvasDone()} </ul> In
     * addition to this the <code>options</code> parameter allows developers to check additional criteria as documented under
     * {@link com.smartgwt.client.util.SystemDoneConfig}. <P> Note: {@link com.smartgwt.client.util.AutoTest#waitForSystemDone
     * waitForSystemDone()} will poll this method repeatedly to check for all pending  actions being complete. The {@link
     * com.smartgwt.client.util.SystemWaitConfig} parameter of that method  allow the user to speciofy which actions to wait
     * for. By default {@link com.smartgwt.client.util.AutoTest#waitForSystemDone waitForSystemDone()} will wait for <i>all</i>
     * actions to complete, including queued redraws, timers, network requests, as well as page load and comopnent level
     * <code>is<i>Component</i>Done</code> checks. <P> Depending on your application configuration, it is possible that this
     * method will not be able to determine whether it is truly in a busy state. Some examples include: <ul>  <li>If {@link
     * com.smartgwt.client.util.SystemDoneConfig#getIncludeTimers SystemDoneConfig.includeTimers} is true and the application
     * has      a constantly running background timer to perform some      ongoing polling action or similar, this method may
     * return <code>false</code>      even though the application is ready for interaction  </li>  <li>Similarly if {@link
     * com.smartgwt.client.util.SystemDoneConfig#getIncludeRedraws SystemDoneConfig.includeRedraws} is true, and the
     * application is      using messaging, or some other mechanism to periodically refresh component(s)      such that they
     * are repeatedly marked as dirty, this method may return      <code>false</code> even though the application is ready for
     * interaction  </li>  <li>If this application makes use of some third-party library to perform      asynchronous actions,
     * this method may return <code>true</code> even when      the application is waiting on a response from this third-party
     * tool.  </li> </ul>
     * @param options This parameter determines what specific  outstanding actions are required to be completed before the system is
     * considered  "done" with current processing. If passed as a boolean rather than a SystemDoneConfig  object, this
     * determines whether the system should wait for  {@link com.smartgwt.client.widgets.Canvas#markForRedraw pending redraws}.
     *
     * @return whether loaded page is 'done' as described above
     */
    public static native boolean isSystemDone(SystemDoneConfig options) /*-{
        var ret = $wnd.isc.AutoTest.isSystemDone(options.@com.smartgwt.client.core.DataClass::getJsObj()());
        return ret == null ? false : ret;
    }-*/;

	/**
     * Returns a boolean to indicate whether the current application is fully loaded with no pending  operations, and is ready
     * for user interaction. This includes the following checks: <ul>     <li> page has finished loading     <li> all ListGrids
     * (as defined by isc.isA.ListGrid) satisfy {@link com.smartgwt.client.util.AutoTest#isGridDone isGridDone()}     <li> all
     * TileGrids that are drawn satisfy {@link com.smartgwt.client.util.AutoTest#isTileGridDone isTileGridDone()}     <li> all
     * TileLayouts that are drawn satisfy {@link com.smartgwt.client.util.AutoTest#isTileLayoutDone isTileLayoutDone()}    
     * <li> all DynamicForms that are drawn satisfy {@link com.smartgwt.client.util.AutoTest#isFormDone isFormDone()}     <li>
     * all Canvii that are drawn satisfy {@link com.smartgwt.client.util.AutoTest#isCanvasDone isCanvasDone()} </ul> In
     * addition to this the <code>options</code> parameter allows developers to check additional criteria as documented under
     * {@link com.smartgwt.client.util.SystemDoneConfig}. <P> Note: {@link com.smartgwt.client.util.AutoTest#waitForSystemDone
     * waitForSystemDone()} will poll this method repeatedly to check for all pending  actions being complete. The {@link
     * com.smartgwt.client.util.SystemWaitConfig} parameter of that method  allow the user to speciofy which actions to wait
     * for. By default {@link com.smartgwt.client.util.AutoTest#waitForSystemDone waitForSystemDone()} will wait for <i>all</i>
     * actions to complete, including queued redraws, timers, network requests, as well as page load and comopnent level
     * <code>is<i>Component</i>Done</code> checks. <P> Depending on your application configuration, it is possible that this
     * method will not be able to determine whether it is truly in a busy state. Some examples include: <ul>  <li>If {@link
     * com.smartgwt.client.util.SystemDoneConfig#getIncludeTimers SystemDoneConfig.includeTimers} is true and the application
     * has      a constantly running background timer to perform some      ongoing polling action or similar, this method may
     * return <code>false</code>      even though the application is ready for interaction  </li>  <li>Similarly if {@link
     * com.smartgwt.client.util.SystemDoneConfig#getIncludeRedraws SystemDoneConfig.includeRedraws} is true, and the
     * application is      using messaging, or some other mechanism to periodically refresh component(s)      such that they
     * are repeatedly marked as dirty, this method may return      <code>false</code> even though the application is ready for
     * interaction  </li>  <li>If this application makes use of some third-party library to perform      asynchronous actions,
     * this method may return <code>true</code> even when      the application is waiting on a response from this third-party
     * tool.  </li> </ul>
     * @param options This parameter determines what specific  outstanding actions are required to be completed before the system is
     * considered  "done" with current processing. If passed as a boolean rather than a SystemDoneConfig  object, this
     * determines whether the system should wait for  {@link com.smartgwt.client.widgets.Canvas#markForRedraw pending redraws}.
     *
     * @return whether loaded page is 'done' as described above
     */
    public static native boolean isSystemDone(boolean options) /*-{
        var ret = $wnd.isc.AutoTest.isSystemDone(options);
        return ret == null ? false : ret;
    }-*/;


	/**
     * Returns whether the TileGrid is in a consistent state with no pending operations.  Returns null if the supplied canvas
     * is not a valid TileGrid. Otherwise, returns true or false according as the conditions below are all satisfied: <ul>    
     * <li> page has finished loading     <li> the TileGrid (as a tileLayout) satisfies {@link
     * com.smartgwt.client.util.AutoTest#isTileLayoutDone isTileLayoutDone()}     <li> the TileGrid has no pending layout
     * animation operations queued </ul>
     * @param canvas TileGrid to test
     *
     * @return whether  TileGrid is 'done' as described above
     */
    public static native Boolean isTileGridDone(Canvas canvas) /*-{
        var ret = $wnd.isc.AutoTest.isTileGridDone(canvas == null ? null : canvas.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()());
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(ret);
    }-*/;


	/**
     * Returns whether the TileLayout is in a consistent state with no pending operations.  Returns null if the supplied canvas
     * is not a valid TileLayout. Otherwise, returns true or false according as the conditions below are all satisfied: <ul>   
     * <li> page has finished loading     <li> the TileLayout (as a canvas) satisfies {@link
     * com.smartgwt.client.util.AutoTest#isCanvasDone isCanvasDone()}     <li> the TileLayout is not currently animating any
     * layout operations </ul>
     * @param canvas TileLayout to test
     *
     * @return whether  TileLayout is 'done' as described above
     */
    public static native Boolean isTileLayoutDone(Canvas canvas) /*-{
        var ret = $wnd.isc.AutoTest.isTileLayoutDone(canvas == null ? null : canvas.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()());
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(ret);
    }-*/;


	/**
     * Given an element in the DOM, returns the canvas containing this element, or null if the element is not contained in any
     * canvas handle.
     * @param element DOM element within in the page
     *
     * @return canvas containing the element, or null if none apply
     */
    public static native Canvas locateCanvasFromDOMElement(Element element) /*-{
        var ret = $wnd.isc.AutoTest.locateCanvasFromDOMElement(element);
        return @com.smartgwt.client.widgets.Canvas::getByJSObject(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;


	/**
     * Given an element in the DOM, returns the FormItem containing this element, or null if the element is not contained in
     * any FormItem.
     * @param element DOM element within in the page
     *
     * @return formItem containing the element, or null if none apply
     */
    public static native FormItem locateFormItemFromDOMElement(Element element) /*-{
        var ret = $wnd.isc.AutoTest.locateFormItemFromDOMElement(element);
        if(ret == null) return null;
        return @com.smartgwt.client.widgets.form.fields.FormItem::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;


	/**
     * Sets the implicit root canvas available in scLocators starting "//testRoot[]". Setting this property may enable one to
     * use the same script to test identical widget hierarchies that are rooted under different base widgets.
     * @param canvas the implicit root
     */
    public static native void setTestRoot(Canvas canvas) /*-{
        $wnd.isc.AutoTest.setTestRoot(canvas == null ? null : canvas.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()());
    }-*/;


	/**
     * Uninstalls the locator shortcut installed by {@link com.smartgwt.client.util.AutoTest#installLocatorShortcut
     * installLocatorShortcut()}
     */
    public static native void uninstallLocatorShortcut() /*-{
        $wnd.isc.AutoTest.uninstallLocatorShortcut();
    }-*/;


	/**
     * Waits for any in-progress actions to complete and then returns the element for the specified locator. <P> By default
     * this method will wait for the  {@link com.smartgwt.client.util.AutoTest#isSystemDone system to be done}  before calling
     * {@link com.smartgwt.client.util.AutoTest#getElement getElement()} with the specified locator. The {@link
     * com.smartgwt.client.util.ElementWaitConfig#getWaitStyle waitStyle} attribute of the options  parameter may be used to
     * instead wait for the locator to resolve to a {@link com.smartgwt.client.util.AutoTest#isElementClickable clickable
     * element}.
     * @param locator locator for the element to retrieve.
     * See {@link com.smartgwt.client.docs.AutoTestLocator AutoTestLocator}
     * @param callback callback to fire when the element has been retrieved - takes two parameters:   <ul><li>"element" (DOMElement) - the
     * clickable element the locator resolved to (or null)</li>       <li>"done" (boolean) - this will be false if the method
     * timed out</li></ul>.
     * See {@link com.smartgwt.client.docs.Callback Callback}
     */
    public static native void waitForElement(String locator, String callback) /*-{
        $wnd.isc.AutoTest.waitForElement(locator, callback);
    }-*/;

	/**
     * Waits for any in-progress actions to complete and then returns the element for the specified locator. <P> By default
     * this method will wait for the  {@link com.smartgwt.client.util.AutoTest#isSystemDone system to be done}  before calling
     * {@link com.smartgwt.client.util.AutoTest#getElement getElement()} with the specified locator. The {@link
     * com.smartgwt.client.util.ElementWaitConfig#getWaitStyle waitStyle} attribute of the options  parameter may be used to
     * instead wait for the locator to resolve to a {@link com.smartgwt.client.util.AutoTest#isElementClickable clickable
     * element}.
     * @param locator locator for the element to retrieve.
     * See {@link com.smartgwt.client.docs.AutoTestLocator AutoTestLocator}
     * @param callback callback to fire when the element has been retrieved - takes two parameters:   <ul><li>"element" (DOMElement) - the
     * clickable element the locator resolved to (or null)</li>       <li>"done" (boolean) - this will be false if the method
     * timed out</li></ul>.
     * See {@link com.smartgwt.client.docs.Callback Callback}
     * @param options Options to configure the wait
     */
    public static native void waitForElement(String locator, String callback, ElementWaitConfig options) /*-{
        $wnd.isc.AutoTest.waitForElement(locator, callback, options == null ? null : options.@com.smartgwt.client.core.DataClass::getJsObj()());
    }-*/;
	

	/**
     * Fires the provided callback when {@link com.smartgwt.client.util.AutoTest#isSystemDone isSystemDone()} returns true. <P>
     * By default this will wait for the following system actions to complete: <ul> <li>All outstanding Smart GWT {@link
     * com.smartgwt.client.rpc.RPCManager RPC and DataSource requests}</li> <li>All outstanding  FileLoader requests</li>
     * <li>Any {@link com.smartgwt.client.widgets.Canvas#markForRedraw queued redraws}</li> <li>Any non-recurring  delayed
     * actions</li> </ul> Note that this behavior may differ from the default settings for {@link
     * com.smartgwt.client.util.AutoTest#isSystemDone isSystemDone()} <P> The <code>options</code> parameter gives developers
     * finer grained control over what to wait for.
     * @param callback Action to fire. This will take a single parameter "done"  which will be set to false if the method timed out waiting for
     * isSystemDone() to  return true;.
     * See {@link com.smartgwt.client.docs.Callback Callback}
     * @see com.smartgwt.client.docs.Callback Callback
     */
    public static native void waitForSystemDone(String callback) /*-{
        $wnd.isc.AutoTest.waitForSystemDone(callback);
    }-*/;

	/**
     * Fires the provided callback when {@link com.smartgwt.client.util.AutoTest#isSystemDone isSystemDone()} returns true. <P>
     * By default this will wait for the following system actions to complete: <ul> <li>All outstanding Smart GWT {@link
     * com.smartgwt.client.rpc.RPCManager RPC and DataSource requests}</li> <li>All outstanding  FileLoader requests</li>
     * <li>Any {@link com.smartgwt.client.widgets.Canvas#markForRedraw queued redraws}</li> <li>Any non-recurring  delayed
     * actions</li> </ul> Note that this behavior may differ from the default settings for {@link
     * com.smartgwt.client.util.AutoTest#isSystemDone isSystemDone()} <P> The <code>options</code> parameter gives developers
     * finer grained control over what to wait for.
     * @param callback Action to fire. This will take a single parameter "done"  which will be set to false if the method timed out waiting for
     * isSystemDone() to  return true;.
     * See {@link com.smartgwt.client.docs.Callback Callback}
     * @param options options to configure the wait
     */
    public static native void waitForSystemDone(String callback, SystemWaitConfig options) /*-{
        $wnd.isc.AutoTest.waitForSystemDone(callback, options == null ? null : options.@com.smartgwt.client.core.DataClass::getJsObj()());
    }-*/;
	

    // ***********************************************************


	/**
     * Gets the implicit root canvas available in scLocators starting "//testRoot[]". Setting this property may enable one to
     * use the same script to test identical widget hierarchies that are rooted under different base widgets.
     *
     * @return the canvas currently set as the test root
     */
    public static native Canvas getTestRoot() /*-{
        var ret = $wnd.isc.AutoTest.testRoot;
        if(ret == null) return null;
        return @com.smartgwt.client.widgets.Canvas::getByJSObject(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

}
