package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * Policy for choosing between admin searches fetched from the DataSource vs. those declared locally on a component.
 */
public enum AdminSearches implements ValueEnum {
    /**
     * Combine both sets of records, but report the search record from the DataSource if two records have the same search name.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "preferSaved".
     */
    PREFERSAVED("preferSaved"),
    /**
     * Combine both sets of records, but report the search record from {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getAdminSavedSearches adminSavedSearches} if two records have the same
     * search name.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "preferLocal".
     */
    PREFERLOCAL("preferLocal"),
    /**
     * Only report the records from {@link com.smartgwt.client.widgets.DataBoundComponent#getAdminSavedSearches
     * adminSavedSearches}.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "localOnly".
     */
    LOCALONLY("localOnly");
    private String value;

    AdminSearches(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
