/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.callbacks;

import com.smartgwt.client.tools.stream.EventStreamData;

public interface EventErrorCallback {

    /** 
     * A {@link com.smartgwt.client.docs.Callback} called to report {@link
     * com.smartgwt.client.tools.stream.EventStream#getCaptureEventErrors event errors} from an {@link
     * com.smartgwt.client.tools.stream.EventStream#start active} {@link com.smartgwt.client.tools.stream.EventStream} to a
     * listener.
     *
     * @param data A JavaScript object representing the current state of the                               stream; {@link
     * com.smartgwt.client.tools.stream.EventStreamData#getEvents events} will be an                               array of all
     * retained {@link com.smartgwt.client.tools.stream.EventStreamEvent}s captured by                               the stream
     * since the last time the callback was invoked,                               oldest first.  The last array element should
     * be the                               <code>EventStreamEvent</code> that triggered this call and                         
     *      have an {@link com.smartgwt.client.tools.stream.EventStreamEvent#getErrorTrace errorTrace}.
     * @param nEvents The number of events captured by the stream since the last time the                      callback was invoked.  Compare
     * with {@link com.smartgwt.client.tools.stream.EventStreamData#getNEvents EventStreamData.nEvents}.
     * @see com.smartgwt.client.tools.stream.EventStream#setMaxSize
     * @see com.smartgwt.client.tools.stream.EventStream#setEventErrorListener
     */
	public void execute(EventStreamData data, int nEvents);
} 
