package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * Governs how the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem} "Select All" and "Deselect All" buttons
 * should act when the user has filtered the set of visible options in the list.
 */
public enum FilteredSelectAllAction implements ValueEnum {
    /**
     * The buttons auto-disable when the list of options is filtered.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "disable".
     */
    DISABLE("disable"),
    /**
     * Ignore filtering: Always select or deselect the entire set of options including those not currently visible in the
     * filtered list. This option is only available if the entire set of data has been loaded in the client.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "all".
     */
    ALL("all"),
    /**
     * If the entire (filtered) list is loaded, both Select All and Clear are functional and will update the selection for all
     * items in the filtered list. If a partial list is loaded, these buttons will be disabled.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "whenLoaded".
     */
    WHENLOADED("whenLoaded");
    private String value;

    FilteredSelectAllAction(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
