package com.smartgwt.client.i18n;

/**
 * Interface to represent the messages contained in resource bundle:
 * 	/Users/sjivan/java/smartgwt-svn/trunk/main/src/com/smartgwt/client/i18n/SmartGwtMessages.properties'.
 */
public interface SmartGwtMessages extends com.google.gwt.i18n.client.Messages {

  /**
   * Translated "Upload".
   * 
   * @return translated "Upload"
   */
  @DefaultMessage("Upload")
  @Key("batchUploader_uploadButtonTitle")
  String batchUploader_uploadButtonTitle();

  /**
   * Translated "Commit".
   * 
   * @return translated "Commit"
   */
  @DefaultMessage("Commit")
  @Key("batchUploader_commitButtonTitle")
  String batchUploader_commitButtonTitle();

    /**
   * Translated "Cancel".
   * 
   * @return translated "Cancel"
   */
  @DefaultMessage("Cancel")
  @Key("batchUploader_cancelButtonTitle")
  String batchUploader_cancelButtonTitle();

  /* batchUploader_previousButtonTitle value changed on Wed Jan  5 07:19:28 2022
   Old value was 'Previous'.
   See definition later in this file for new value.
  */

  /* batchUploader_nextButtonTitle value changed on Wed Jan  5 07:19:28 2022
   Old value was 'Next'.
   See definition later in this file for new value.
  */

  /**
   * Translated "Upload File".
   * 
   * @return translated "Upload File"
   */
  @DefaultMessage("Upload File")
  @Key("batchUploader_uploadFileLabel")
  String batchUploader_uploadFileLabel();

  /**
   * Translated "Records added".
   * 
   * @return translated "Records added"
   */
  @DefaultMessage("Records added")
  @Key("batchUploader_commitConfirmationMessage")
  String batchUploader_commitConfirmationMessage();
  
  /**
   * Translated "All records have errors; nothing to commit".
   * 
   * @return translated "All records have errors; nothing to commit"
   */
  @DefaultMessage("All records have errors; nothing to commit")
  @Key("batchUploader_allRecordsInErrorMessage")
  String batchUploader_allRecordsInErrorMessage();
  
  /**
   * Translated "Valid records added; some records remain in error".
   * 
   * @return translated "Valid records added; some records remain in error"
   */
  @DefaultMessage("Valid records added; some records remain in error")
  @Key("batchUploader_partialCommitConfirmationMessage")
  String batchUploader_partialCommitConfirmationMessage();
  
  /**
   * Translated "One or more updates were rolled-back due to errors on other rows".
   * 
   * @return translated "One or more updates were rolled-back due to errors on other rows"
   */
  @DefaultMessage("One or more updates were rolled-back due to errors on other rows")
  @Key("batchUploader_updatesRolledBackMessage")
  String batchUploader_updatesRolledBackMessage();

  /**
   * Translated "There are errors in your data so it cannot all be saved.  If you proceed, you will lose the records with errors.  Click ''OK'' to proceed anyway, or ''Cancel'' to return to your data".
   * 
   * @return translated "There are errors in your data so it cannot all be saved.  If you proceed, you will lose the records with errors.  Click ''OK'' to proceed anyway, or ''Cancel'' to return to your data"
   */
  @DefaultMessage("There are errors in your data so it cannot all be saved.  If you proceed, you will lose the records with errors.  Click ''OK'' to proceed anyway, or ''Cancel'' to return to your data")
  @Key("batchUploader_partialCommitPrompt")
  String batchUploader_partialCommitPrompt();  

  /**
   * Translated "There are errors in your data.  Please correct all errors before clicking ''Commit''".
   * 
   * @return translated "There are errors in your data.  Please correct all errors before clicking ''Commit''"
   */
  @DefaultMessage("There are errors in your data.  Please correct all errors before clicking ''Commit''")
  @Key("batchUploader_partialCommitError")
  String batchUploader_partialCommitError();  

  /**
   * Translated "Cancelling will lose any changes you have made.  Proceed anyway?".
   * 
   * @return translated "Cancelling will lose any changes you have made.  Proceed anyway?"
   */
  @DefaultMessage("Cancelling will lose any changes you have made.  Proceed anyway?")
  @Key("batchUploader_cancelConfirmMessage")
  String batchUploader_cancelConfirmMessage();  

  /**
   * Translated "The following columns in your imported data were ignored because they did not match any of the expected column names: $discardedColumns".
   * 
   * @return translated "The following columns in your imported data were ignored because they did not match any of the expected column names: $discardedColumns"
   */
  @DefaultMessage("The following columns in your imported data were ignored because they did not match any of the expected column names: $discardedColumns")
  @Key("batchUploader_discardedColumnsMessage")
  String batchUploader_discardedColumnsMessage();

  /**
   * Translated "The provided file is blank. Please, provide a file with data.".
   * 
   * @return translated "The provided file is blank. Please, provide a file with data."
   */
  @DefaultMessage("The provided file is blank. Please, provide a file with data.")
  @Key("batchUploader_errorMessageFileIsBlank")
  String batchUploader_errorMessageFileIsBlank();  


  /**
   * Translated "Unterminated quote string - problem found in the first line at character position: $errorOffset.".
   * 
   * @return translated "Unterminated quote string - problem found in the first line at character position: $errorOffset."
   */
  @DefaultMessage("Unterminated quote string - problem found in the first line at character position: $errorOffset.")
  @Key("batchUploader_errorMessageUnterminatedQuote")
  String batchUploader_errorMessageUnterminatedQuote();

  /* batchUploader_errorMessageRowsNotParsed value changed on Wed Jan  5 07:19:28 2022
   Old value was 'Some rows could not be parsed; the grid below shows $goodRowCount of $totalRows. Row number $firstBadRow was the first row to fail to be parsed.'.
   See definition later in this file for new value.
  */

  /**
   * Translated "Delimiter or end of line expected after quoted value - problem found in the first line at character position: $errorOffset.".
   * 
   * @return translated "Delimiter or end of line expected after quoted value - problem found in the first line at character position: $errorOffset."
   */
  @DefaultMessage("Delimiter or end of line expected after quoted value - problem found in the first line at character position: $errorOffset.")
  @Key("batchUploader_errorMessageDelimiterOrEndOfLine")
  String batchUploader_errorMessageDelimiterOrEndOfLine();

  /**
   * Translated "Invalid inputType value was set!".
   * 
   * @return translated "Invalid inputType value was set!"
   */
  @DefaultMessage("Invalid inputType value was set!")
  @Key("batchUploader_errorMessageInputType")
  String batchUploader_errorMessageInputType();

  /**
   * Translated "We were unable to guess the delimiter.".
   * 
   * @return translated "We were unable to guess the delimiter."
   */
  @DefaultMessage("We were unable to guess the delimiter.")
  @Key("batchUploader_errorMessageUndeterminedDelimiter")
  String batchUploader_errorMessageUndeterminedDelimiter();

  /**
   * Translated "You uploaded an Excel file. Please save your data as a csv file and re-upload".
   * 
   * @return translated "You uploaded an Excel file. Please save your data as a csv file and re-upload"
   */
  @DefaultMessage("You uploaded an Excel file. Please save your data as a csv file and re-upload")
  @Key("batchUploader_errorMessageExcelFileDetected")
  String batchUploader_errorMessageExcelFileDetected();

  /**
   * Translated "Either enter valid criteria or hit ''Cancel'' to abandon changes.".
   * 
   * @return translated "Either enter valid criteria or hit ''Cancel'' to abandon changes."
   */
  @DefaultMessage("Either enter valid criteria or hit ''Cancel'' to abandon changes.")
  @Key("advancedHiliteEditor_invalidCriteriaPrompt")
  String advancedHiliteEditor_invalidCriteriaPrompt();

  /**
   * Translated "Untitled Button".
   * 
   * @return translated "Untitled Button"
   */
  @DefaultMessage("Untitled Button")
  @Key("button_title")
  String button_title();

  /**
   * Translated "Add an event".
   * 
   * @return translated "Add an event"
   */
  @DefaultMessage("Add an event")
  @Key("calendar_addEventButtonHoverText")
  String calendar_addEventButtonHoverText();

  /**
   * Translated "Cancel".
   * 
   * @return translated "Cancel"
   */
  @DefaultMessage("Cancel")
  @Key("calendar_cancelButtonTitle")
  String calendar_cancelButtonTitle();

  /**
   * Translated "Choose a date".
   * 
   * @return translated "Choose a date"
   */
  @DefaultMessage("Choose a date")
  @Key("calendar_datePickerHoverText")
  String calendar_datePickerHoverText();

  /**
   * Translated "Day".
   * 
   * @return translated "Day"
   */
  @DefaultMessage("Day")
  @Key("calendar_dayViewTitle")
  String calendar_dayViewTitle();

  /**
   * Translated "Edit Details".
   * 
   * @return translated "Edit Details"
   */
  @DefaultMessage("Edit Details")
  @Key("calendar_detailsButtonTitle")
  String calendar_detailsButtonTitle();

  /**
   * Translated "Remove Event".
   * 
   * @return translated "Remove Event"
   */
  @DefaultMessage("Remove Event")
  @Key("calendar_removeButtonTitle")
  String calendar_removeButtonTitle();

  /**
   * Translated "Event Name".
   * 
   * @return translated "Event Name"
   */
  @DefaultMessage("Event Name")
  @Key("calendar_eventNameFieldTitle")
  String calendar_eventNameFieldTitle();

  /**
   * Translated "Description".
   * 
   * @return translated "Description"
   */
  @DefaultMessage("Description")
  @Key("calendar_eventDescriptionFieldTitle")
  String calendar_eventDescriptionFieldTitle();

  /**
   * Translated "From".
   * 
   * @return translated "From"
   */
  @DefaultMessage("From")
  @Key("calendar_eventStartDateFieldTitle")
  String calendar_eventStartDateFieldTitle();

  /**
   * Translated "To".
   * 
   * @return translated "To"
   */
  @DefaultMessage("To")
  @Key("calendar_eventEndDateFieldTitle")
  String calendar_eventEndDateFieldTitle();

  /**
   * Translated "Lane".
   * 
   * @return translated "Lane"
   */
  @DefaultMessage("Lane")
  @Key("calendar_eventLaneFieldTitle")
  String calendar_eventLaneFieldTitle();

  /**
   * Translated "From must be before To".
   * 
   * @return translated "From must be before To"
   */
  @DefaultMessage("From must be before To")
  @Key("calendar_invalidDateMessage")
  String calendar_invalidDateMessage();

  /**
   * Translated "Month".
   * 
   * @return translated "Month"
   */
  @DefaultMessage("Month")
  @Key("calendar_monthViewTitle")
  String calendar_monthViewTitle();

  /**
   * Translated "Next".
   * 
   * @return translated "Next"
   */
  @DefaultMessage("Next")
  @Key("calendar_nextButtonHoverText")
  String calendar_nextButtonHoverText();

  /**
   * Translated "Previous".
   * 
   * @return translated "Previous"
   */
  @DefaultMessage("Previous")
  @Key("calendar_previousButtonHoverText")
  String calendar_previousButtonHoverText();

  /**
   * Translated "Save Event".
   * 
   * @return translated "Save Event"
   */
  @DefaultMessage("Save Event")
  @Key("calendar_saveButtonTitle")
  String calendar_saveButtonTitle();

  /**
   * Translated "Timeline".
   * 
   * @return translated "Timeline"
   */
  @DefaultMessage("Timeline")
  @Key("calendar_timelineViewTitle")
  String calendar_timelineViewTitle();

  /**
   * Translated "Week".
   * 
   * @return translated "Week"
   */
  @DefaultMessage("Week")
  @Key("calendar_weekViewTitle")
  String calendar_weekViewTitle();


  /**
   * Translated "Week".
   * 
   * @return translated "Week"
   */
  @DefaultMessage("Week")
  @Key("calendar_weekPrefix")
  String calendar_weekPrefix();


  /* calendar_monthButtonTitle value modified on Fri Aug  9 01:15:21 2024
   Old value was '&lt; $monthName'.
   See definition later in this file for new value.
  */

  
  /**
   * Translated "Back".
   * 
   * @return translated "Back"
   */
  @DefaultMessage("Back")
  @Key("calendar_backButtonTitle")
  String calendar_backButtonTitle();

  /**
   * Translated "Sublane".
   * 
   * @return translated "Sublane"
   */
  @DefaultMessage("Sublane")
  @Key("calendar_eventSublaneFieldTitle")
  String calendar_eventSublaneFieldTitle();
  
  /**
   * Translated "Duration".
   * 
   * @return translated "Duration"
   */
  @DefaultMessage("Duration")
  @Key("calendar_eventDurationFieldTitle")
  String calendar_eventDurationFieldTitle();

  /**
   * Translated "&nbsp;".
   * 
   * @return translated "&nbsp;"
   */
  @DefaultMessage("&nbsp;")
  @Key("calendar_eventDurationUnitFieldTitle")
  String calendar_eventDurationUnitFieldTitle();

  /**
   * Translated "+ $eventCount more...".
   * 
   * @return translated "+ $eventCount more..."
   */
  @DefaultMessage("+ $eventCount more...")
  @Key("calendar_monthMoreEventsLinkTitle")
  String calendar_monthMoreEventsLinkTitle();

  /**
   * Translated "Loading...".
   * 
   * @return translated "Loading"
   */
  @DefaultMessage("Loading...")
  @Key("formItem_loadingDisplayValue")
  String formItem_loadingDisplayValue();

  /**
   * Translated "None".
   * 
   * @return translated "None"
   */
  @DefaultMessage("None")
  @Key("formItem_nullOriginalValueText")
  String formItem_nullOriginalValueText();

  /**
   * Translated "Click to select a new color".
   * 
   * @return translated "Click to select a new color"
   */
  @DefaultMessage("Click to select a new color")
  @Key("colorItem_pickerIconPrompt")
  String colorItem_pickerIconPrompt();

  /**
   * Translated "Basic Colors:".
   * 
   * @return translated "Basic Colors:"
   */
  @DefaultMessage("Basic Colors:")
  @Key("colorPicker_basicColorLabel")
  String colorPicker_basicColorLabel();

  /**
   * Translated "The Blue component of the selected color".
   * 
   * @return translated "The Blue component of the selected color"
   */
  @DefaultMessage("The Blue component of the selected color")
  @Key("colorPicker_blueFieldPrompt")
  String colorPicker_blueFieldPrompt();

  /**
   * Translated "Blue".
   * 
   * @return translated "Blue"
   */
  @DefaultMessage("Blue")
  @Key("colorPicker_blueFieldTitle")
  String colorPicker_blueFieldTitle();

  /**
   * Translated "Cancel".
   * 
   * @return translated "Cancel"
   */
  @DefaultMessage("Cancel")
  @Key("colorPicker_cancelButtonTitle")
  String colorPicker_cancelButtonTitle();

  /**
   * Translated "The Green component of the selected color".
   * 
   * @return translated "The Green component of the selected color"
   */
  @DefaultMessage("The Green component of the selected color")
  @Key("colorPicker_greenFieldPrompt")
  String colorPicker_greenFieldPrompt();

  /**
   * Translated "Green".
   * 
   * @return translated "Green"
   */
  @DefaultMessage("Green")
  @Key("colorPicker_greenFieldTitle")
  String colorPicker_greenFieldTitle();

  /**
   * Translated "The selected color''s HTML coding".
   * 
   * @return translated "The selected color''s HTML coding"
   */
  @DefaultMessage("The selected color''s HTML coding")
  @Key("colorPicker_htmlFieldPrompt")
  String colorPicker_htmlFieldPrompt();

  /**
   * Translated "HTML".
   * 
   * @return translated "HTML"
   */
  @DefaultMessage("HTML")
  @Key("colorPicker_htmlFieldTitle")
  String colorPicker_htmlFieldTitle();

  /**
   * Translated "The Hue (base tone) of the selected color".
   * 
   * @return translated "The Hue (base tone) of the selected color"
   */
  @DefaultMessage("The Hue (base tone) of the selected color")
  @Key("colorPicker_hueFieldPrompt")
  String colorPicker_hueFieldPrompt();

  /**
   * Translated "Hue".
   * 
   * @return translated "Hue"
   */
  @DefaultMessage("Hue")
  @Key("colorPicker_hueFieldTitle")
  String colorPicker_hueFieldTitle();

  /**
   * Translated "<< Less".
   * 
   * @return translated "<< Less"
   */
  @DefaultMessage("<< Less")
  @Key("colorPicker_lessButtonTitle")
  String colorPicker_lessButtonTitle();

  /**
   * Translated "The Luminosity (brightness) of the selected color".
   * 
   * @return translated "The Luminosity (brightness) of the selected color"
   */
  @DefaultMessage("The Luminosity (brightness) of the selected color")
  @Key("colorPicker_lumFieldPrompt")
  String colorPicker_lumFieldPrompt();

  /**
   * Translated "Lum".
   * 
   * @return translated "Lum"
   */
  @DefaultMessage("Lum")
  @Key("colorPicker_lumFieldTitle")
  String colorPicker_lumFieldTitle();

  /**
   * Translated "More >>".
   * 
   * @return translated "More >>"
   */
  @DefaultMessage("More >>")
  @Key("colorPicker_moreButtonTitle")
  String colorPicker_moreButtonTitle();

  /**
   * Translated "OK".
   * 
   * @return translated "OK"
   */
  @DefaultMessage("OK")
  @Key("colorPicker_okButtonTitle")
  String colorPicker_okButtonTitle();

  /**
   * Translated "Opacity:".
   * 
   * @return translated "Opacity:"
   */
  @DefaultMessage("Opacity:")
  @Key("colorPicker_opacitySliderLabel")
  String colorPicker_opacitySliderLabel();

  /**
   * Translated "The Red component of the selected color".
   * 
   * @return translated "The Red component of the selected color"
   */
  @DefaultMessage("The Red component of the selected color")
  @Key("colorPicker_redFieldPrompt")
  String colorPicker_redFieldPrompt();

  /**
   * Translated "Red".
   * 
   * @return translated "Red"
   */
  @DefaultMessage("Red")
  @Key("colorPicker_redFieldTitle")
  String colorPicker_redFieldTitle();

  /**
   * Translated "The Saturation (color purity) of the selected color".
   * 
   * @return translated "The Saturation (color purity) of the selected color"
   */
  @DefaultMessage("The Saturation (color purity) of the selected color")
  @Key("colorPicker_satFieldPrompt")
  String colorPicker_satFieldPrompt();

  /**
   * Translated "Sat".
   * 
   * @return translated "Sat"
   */
  @DefaultMessage("Sat")
  @Key("colorPicker_satFieldTitle")
  String colorPicker_satFieldTitle();

  /**
   * Translated "Select a Color".
   * 
   * @return translated "Select a Color"
   */
  @DefaultMessage("Select a Color")
  @Key("colorPicker_selectTitle")
  String colorPicker_selectTitle();

  /**
   * Translated "Selected Color:".
   * 
   * @return translated "Selected Color:"
   */
  @DefaultMessage("Selected Color:")
  @Key("colorPicker_selectedColorLabel")
  String colorPicker_selectedColorLabel();

  /**
   * Translated "Add formula column...".
   * 
   * @return translated "Add formula column..."
   */
  @DefaultMessage("Add formula column...")
  @Key("dataBoundComponent_addFormulaFieldText")
  String dataBoundComponent_addFormulaFieldText();

  /**
   * Translated "$builderType Editor [$fieldTitle]".
   * 
   * @return translated "$builderType Editor [$fieldTitle]"
   */
  @DefaultMessage("$builderType Editor [$fieldTitle]")
  @Key("dataBoundComponent_fieldEditorWindowTitle")
  String dataBoundComponent_fieldEditorWindowTitle();

  /**
   * Translated "Add summary column...".
   * 
   * @return translated "Add summary column..."
   */
  @DefaultMessage("Add summary column...")
  @Key("dataBoundComponent_addSummaryFieldText")
  String dataBoundComponent_addSummaryFieldText();

  /**
   * Translated "Error during validation; no error details were provided".
   * 
   * @return translated "Error during validation; no error details were provided"
   */
  @DefaultMessage("Error during validation; no error details were provided")
  @Key("dataBoundComponent_noErrorDetailsMessage")
  String dataBoundComponent_noErrorDetailsMessage();

  /**
   * Translated "Duplicates not allowed".
   * 
   * @return translated "Duplicates not allowed"
   */
  @DefaultMessage("Duplicates not allowed")
  @Key("dataBoundComponent_duplicateDragMessage")
  String dataBoundComponent_duplicateDragMessage();

  /**
   * Translated "Edit formula...".
   * 
   * @return translated "Edit formula..."
   */
  @DefaultMessage("Edit formula...")
  @Key("dataBoundComponent_editFormulaFieldText")
  String dataBoundComponent_editFormulaFieldText();

  /**
   * Translated "Edit summary format...".
   * 
   * @return translated "Edit summary format..."
   */
  @DefaultMessage("Edit summary format...")
  @Key("dataBoundComponent_editSummaryFieldText")
  String dataBoundComponent_editSummaryFieldText();

  /**
   * Translated "This data not available while offline.".
   * 
   * @return translated "This data not available while offline."
   */
  @DefaultMessage("This data not available while offline.")
  @Key("dataBoundComponent_offlineMessage")
  String dataBoundComponent_offlineMessage();

  /**
   * Translated "Remove formula".
   * 
   * @return translated "Remove formula"
   */
  @DefaultMessage("Remove formula")
  @Key("dataBoundComponent_removeFormulaFieldText")
  String dataBoundComponent_removeFormulaFieldText();

  

/* dataBoundComponent_removeSummaryFieldText value changed on Wed Jan  5 06:58:57 2022
   Old value was 'Remove summary column..'.
   See definition later in this file for new value.
*/


  /**
   * Translated "Field is required".
   * 
   * @return translated "Field is required"
   */
  @DefaultMessage("Field is required")
  @Key("dataBoundComponent_requiredFieldMessage")
  String dataBoundComponent_requiredFieldMessage();

  /**
   * Translated "Invalid value".
   * 
   * @return translated "Invalid value"
   */
  @DefaultMessage("Invalid value")
  @Key("dataBoundComponent_unknownErrorMessage")
  String dataBoundComponent_unknownErrorMessage();

  /**
   * Translated "Edit Highlights".
   * 
   * @return translated "Edit Highlights"
   */
  @DefaultMessage("Edit Highlights")
  @Key("dataBoundComponent_editHilitesDialogTitle")
  String dataBoundComponent_editHilitesDialogTitle();

  /**
   * Translated "Data cannot be saved because you are not online".
   * 
   * @return translated "Data cannot be saved because you are not online"
   */
  @DefaultMessage("Data cannot be saved because you are not online")
  @Key("dataBoundComponent_offlineSaveMessage")
  String dataBoundComponent_offlineSaveMessage();

  /**
   * Translated "You are attempting to export an empty dataset".
   * 
   * @return translated "You are attempting to export an empty dataset"
   */
  @DefaultMessage("You are attempting to export an empty dataset")
  @Key("dataBoundComponent_emptyExportMessage")
  String dataBoundComponent_emptyExportMessage();
  
  
  /**
   * Translated "Edit Highlights...".
   * 
   * @return translated "Edit Highlights..."
   */
  @DefaultMessage("Edit Highlights...")
  @Key("dataBoundComponent_editHilitesText")
  String dataBoundComponent_editHilitesText();

  /**
   * Translated "This data not available while offline".
   * 
   * @return translated "This data not available while offline"
   */
  @DefaultMessage("This data not available while offline")
  @Key("dataSource_offlineMessage")
  String dataSource_offlineMessage();

  /**
   * Translated "Size of ''$uploadedFileName'' ($uploadedFileSize) exceeded maximum allowed file size of $maxFileSize".
   * 
   * @return translated "Size of ''$uploadedFileName'' ($uploadedFileSize) exceeded maximum allowed file size of $maxFileSize"
   */
  @DefaultMessage("Size of ''$uploadedFileName'' ($uploadedFileSize) exceeded maximum allowed file size of $maxFileSize")
  @Key("dataSource_maxFileSizeExceededMessage")
  String dataSource_maxFileSizeExceededMessage();

  /* dataSource_requiredFileMessage value changed on Wed Jan  5 07:19:28 2022
   Old value was '''$uploadedFileName'' was empty, but empty files are not allowed'.
   See definition later in this file for new value.
  */

  /**
   * Operation requires criteria for the following field(s): [$requiredCriterion]".
   * 
   * @return translated "Operation requires criteria for the following field(s): [$requiredCriterion]"
   */
  @DefaultMessage("Operation requires criteria for the following field(s): [$requiredCriterion]")
  @Key("dataSource_requiredCriterionMessage")
  String dataSource_requiredCriterionMessage();

  /**
   * Translated "Configure Fields...".
   * 
   * @return translated "Configure Fields..."
   */
  @DefaultMessage("Configure Fields...")
  @Key("detailViewer_configureFieldsText")
  String detailViewer_configureFieldsText();

  /**
   * Translated "Regression Lines".
   * 
   * @return translated "Regression Lines"
   */
  @DefaultMessage("Regression Lines")
  @Key("facetChart_regressionLinesContextMenuItemTitle")
  String facetChart_regressionLinesContextMenuItemTitle();

  /**
   * Translated "None".
   * 
   * @return translated "None"
   */
  @DefaultMessage("None")
  @Key("facetChart_hideRegressionLinesContextMenuItemTitle")
  String facetChart_hideRegressionLinesContextMenuItemTitle();

  /**
   * Translated "Straight Line".
   * 
   * @return translated "Straight Line"
   */
  @DefaultMessage("Straight Line")
  @Key("facetChart_linearRegressionLinesContextMenuItemTitle")
  String facetChart_linearRegressionLinesContextMenuItemTitle();

  /**
   * Translated "Polynomial Curve".
   * 
   * @return translated "Polynomial Curve"
   */
  @DefaultMessage("Polynomial Curve")
  @Key("facetChart_polynomialRegressionLinesContextMenuItemTitle")
  String facetChart_polynomialRegressionLinesContextMenuItemTitle();

  /**
   * Translated "Polynomial Degree...".
   * 
   * @return translated "Polynomial Degree..."
   */
  @DefaultMessage("Polynomial Degree...")
  @Key("facetChart_polynomialDegreeRegressionLinesContextMenuItemTitle")
  String facetChart_polynomialDegreeRegressionLinesContextMenuItemTitle();

  /**
   * Translated "Enter a degree for the polynomial regression curve (must be a positive integer):".
   * 
   * @return translated "Enter a degree for the polynomial regression curve (must be a positive integer):"
   */
  @DefaultMessage("Enter a degree for the polynomial regression curve (must be a positive integer):")
  @Key("facetChart_polynomialDegreePrompt")
  String facetChart_polynomialDegreePrompt();

  /**
   * Translated "The regression polynomial degree must be a positive integer.".
   * 
   * @return translated "The regression polynomial degree must be a positive integer."
   */
  @DefaultMessage("The regression polynomial degree must be a positive integer.")
  @Key("facetChart_invalidPolynomialDegreeMessage")
  String facetChart_invalidPolynomialDegreeMessage();

  /**
   * Translated "Chart Type".
   * 
   * @return translated "Chart Type"
   */
  @DefaultMessage("Chart Type")
  @Key("facetChart_chartTypeContextMenuItemTitle")
  String facetChart_chartTypeContextMenuItemTitle();

  /**
   * Translated "Fill".
   * 
   * @return translated "Fill"
   */
  @DefaultMessage("Fill")
  @Key("facetChart_fillContextMenuItemTitle")
  String facetChart_fillContextMenuItemTitle();

  /**
   * Translated "Filled".
   * 
   * @return translated "Filled"
   */
  @DefaultMessage("Filled")
  @Key("facetChart_fillFilledContextMenuItemTitle")
  String facetChart_fillFilledContextMenuItemTitle();
  
   /**
   * Translated "Unfilled".
   * 
   * @return translated "Unfilled"
   */
  @DefaultMessage("Unfilled")
  @Key("facetChart_fillUnilledContextMenuItemTitle")
  String facetChart_fillUnfilledContextMenuItemTitle();
 
  /**
   * Translated "Auto".
   * 
   * @return translated "Auto"
   */
  @DefaultMessage("Auto")
  @Key("facetChart_fillAutoContextMenuItemTitle")
  String facetChart_fillAutoContextMenuItemTitle();

  /**
   * Translated "Stack".
   * 
   * @return translated "Stack"
   */
  @DefaultMessage("Stack")
  @Key("facetChart_stackContextMenuItemTitle")
  String facetChart_stackContextMenuItemTitle();

  /**
   * Translated "Stacked".
   * 
   * @return translated "Stacked"
   */
  @DefaultMessage("Stacked")
  @Key("facetChart_stackStackedContextMenuItemTitle")
  String facetChart_stackStackedContextMenuItemTitle();

  /**
   * Translated "Unstacked".
   * 
   * @return translated "Unstacked"
   */
  @DefaultMessage("Unstacked")
  @Key("facetChart_stackUnstackedContextMenuItemTitle")
  String facetChart_stackUnstackedContextMenuItemTitle();
  
  /**
   * Translated "Auto".
   * 
   * @return translated "Auto"
   */
  @DefaultMessage("Auto")
  @Key("facetChart_stackAutoContextMenuItemTitle")
  String facetChart_stackAutoContextMenuItemTitle();
  
  /**
   * Translated "Swap Facets".
   * 
   * @return translated "Swap Facets"
   */
  @DefaultMessage("Swap Facets")
  @Key("facetChart_swapFacetsContextMenuItemTitle")
  String facetChart_swapFacetsContextMenuItemTitle();
  
  /**
   * Translated "Proportional".
   * 
   * @return translated "Proportional"
   */
  @DefaultMessage("Proportional")
  @Key("facetChart_proportionalContextMenuItemTitle")
  String facetChart_proportionalContextMenuItemTitle();

  /**
   * Translated "Area".
   * 
   * @return translated "Area"
   */
  @DefaultMessage("Area")
  @Key("facetChart_chartTypeAreaTitle")
  String facetChart_chartTypeAreaTitle();
  
  /**
   * Translated "Column".
   * 
   * @return translated "Column"
   */
  @DefaultMessage("Column")
  @Key("facetChart_chartTypeColumnTitle")
  String facetChart_chartTypeColumnTitle();
  
  /**
   * Translated "Bar".
   * 
   * @return translated "Bar"
   */
  @DefaultMessage("Bar")
  @Key("facetChart_chartTypeBarTitle")
  String facetChart_chartTypeBarTitle();
  
  /**
   * Translated "Line".
   * 
   * @return translated "Line"
   */
  @DefaultMessage("Line")
  @Key("facetChart_chartTypeLineTitle")
  String facetChart_chartTypeLineTitle();
  
  /**
   * Translated "Radar".
   * 
   * @return translated "Radar"
   */
  @DefaultMessage("Radar")
  @Key("facetChart_chartTypeRadarTitle")
  String facetChart_chartTypeRadarTitle();
  
  /**
   * Translated "Pie".
   * 
   * @return translated "Pie"
   */
  @DefaultMessage("Pie")
  @Key("facetChart_chartTypePieTitle")
  String facetChart_chartTypePieTitle();
  
  /**
   * Translated "Doughnut".
   * 
   * @return translated "Doughnut"
   */
  @DefaultMessage("Doughnut")
  @Key("facetChart_chartTypeDoughnutTitle")
  String facetChart_chartTypeDoughnutTitle();
  
  /**
   * Translated "Scatter".
   * 
   * @return translated "Scatter"
   */
  @DefaultMessage("Scatter")
  @Key("facetChart_chartTypeScatterTitle")
  String facetChart_chartTypeScatterTitle();
  
  /**
   * Translated "Bubble".
   * 
   * @return translated "Bubble"
   */
  @DefaultMessage("Bubble")
  @Key("facetChart_chartTypeBubbleTitle")
  String facetChart_chartTypeBubbleTitle();
  
  /**
   * Translated "Histogram".
   * 
   * @return translated "Histogram"
   */
  @DefaultMessage("Histogram")
  @Key("facetChart_chartTypeHistogramTitle")
  String facetChart_chartTypeHistogramTitle();
  
  /**
   * Translated "No tiles to show.".
   * 
   * @return translated "No tiles to show."
   */
  @DefaultMessage("No tiles to show.")
  @Key("tileGrid_emptyMessage")
  String tileGrid_emptyMessage();

  /**
   * Translated "checked".
   * 
   * @return translated "checked"
   */
  @DefaultMessage("checked")
  @Key("checkboxItem_checkedDescription")
  String checkboxItem_checkedDescription();

  /**
   * Translated "unchecked".
   * 
   * @return translated "unchecked"
   */
  @DefaultMessage("unchecked")
  @Key("checkboxItem_uncheckedDescription")
  String checkboxItem_uncheckedDescription();

  /**
   * Translated "partially selected".
   * 
   * @return translated "partially selected"
   */
  @DefaultMessage("partially selected")
  @Key("checkboxItem_partialSelectedDescription")
  String checkboxItem_partialSelectedDescription();

  /**
   * Translated "unset".
   * 
   * @return translated "unset"
   */
  @DefaultMessage("unset")
  @Key("checkboxItem_unsetDescription")
  String checkboxItem_unsetDescription();

  /**
   * Translated "Cancel".
   * 
   * @return translated "Cancel"
   */
  @DefaultMessage("Cancel")
  @Key("dateChooser_cancelButtonTitle")
  String dateChooser_cancelButtonTitle();

  /**
   * Translated "Apply".
   * 
   * @return translated "Apply"
   */
  @DefaultMessage("Apply")
  @Key("dateChooser_applyButtonTitle")
  String dateChooser_applyButtonTitle();

  /**
   * Translated "0".
   * 
   * @return translated "0"
   */
  @DefaultMessage("0")
  @Key("dateChooser_firstDayOfWeek")
  String dateChooser_firstDayOfWeek();

  /**
   * Translated "Today".
   * 
   * @return translated "Today"
   */
  @DefaultMessage("Today")
  @Key("dateChooser_todayButtonTitle")
  String dateChooser_todayButtonTitle();

  /**
   * Translated "Year".
   * 
   * @return translated "Year"
   */
  @DefaultMessage("Year")
  @Key("dateChooser_fiscalYearFieldTitle")
  String dateChooser_fiscalYearFieldTitle();
  
  /**
   * Translated "Wk".
   * 
   * @return translated "Wk"
   */
  @DefaultMessage("Wk")
  @Key("dateChooser_weekFieldTitle")
  String dateChooser_weekFieldTitle();

  /**
   * Translated "Time".
   * 
   * @return translated "Time"
   */
  @DefaultMessage("Time")
  @Key("dateChooser_timeItemTitle")
  String dateChooser_timeItemTitle();

  /**
   * Translated "Choose a day".
   * 
   * @return translated "Choose a day"
   */
  @DefaultMessage("Choose a day")
  @Key("dateItem_daySelectorPrompt")
  String dateItem_daySelectorPrompt();

  /**
   * Translated "Invalid date".
   * 
   * @return translated "Invalid date"
   */
  @DefaultMessage("Invalid date")
  @Key("dateItem_invalidDateStringMessage")
  String dateItem_invalidDateStringMessage();

  /**
   * Translated "Choose a month".
   * 
   * @return translated "Choose a month"
   */
  @DefaultMessage("Choose a month")
  @Key("dateItem_monthSelectorPrompt")
  String dateItem_monthSelectorPrompt();

  /**
   * Translated "Show Date Chooser".
   * 
   * @return translated "Show Date Chooser"
   */
  @DefaultMessage("Show Date Chooser")
  @Key("dateItem_pickerIconPrompt")
  String dateItem_pickerIconPrompt();

  /**
   * Translated "MDY".
   * 
   * @return translated "MDY"
   */
  @DefaultMessage("MDY")
  @Key("dateItem_selectorFormat")
  String dateItem_selectorFormat();

  /**
   * Translated "Choose a year".
   * 
   * @return translated "Choose a year"
   */
  @DefaultMessage("Choose a year")
  @Key("dateItem_yearSelectorPrompt")
  String dateItem_yearSelectorPrompt();

  /**
   * Translated "Hour".
   * 
   * @return translated "Hour"
   */
  @DefaultMessage("Hour")
  @Key("timeItem_hourItemTitle")
  String timeItem_hourItemTitle();

  /**
   * Translated "Choose hours".
   * 
   * @return translated "Choose hours"
   */
  @DefaultMessage("Choose hours")
  @Key("timeItem_hourItemPrompt")
  String timeItem_hourItemPrompt();

  /**
   * Translated "Min".
   * 
   * @return translated "Min"
   */
  @DefaultMessage("Min")
  @Key("timeItem_minuteItemTitle")
  String timeItem_minuteItemTitle();

  /**
   * Translated "Choose minutes".
   * 
   * @return translated "Choose minutes"
   */
  @DefaultMessage("Choose minutes")
  @Key("timeItem_minuteItemPrompt")
  String timeItem_minuteItemPrompt();

  /**
   * Translated "Sec".
   * 
   * @return translated "Sec"
   */
  @DefaultMessage("Sec")
  @Key("timeItem_secondItemTitle")
  String timeItem_secondItemTitle();

  /**
   * Translated "Choose seconds".
   * 
   * @return translated "Choose seconds"
   */
  @DefaultMessage("Choose seconds")
  @Key("timeItem_secondItemPrompt")
  String timeItem_secondItemPrompt();

  /**
   * Translated "Ms".
   * 
   * @return translated "Ms"
   */
  @DefaultMessage("Ms")
  @Key("timeItem_millisecondItemTitle")
  String timeItem_millisecondItemTitle();

  /**
   * Translated "Choose milliseconds".
   * 
   * @return translated "Choose milliseconds"
   */
  @DefaultMessage("Choose milliseconds")
  @Key("timeItem_millisecondItemPrompt")
  String timeItem_millisecondItemPrompt();

  /**
   * Translated "AM/PM".
   * 
   * @return translated "AM/PM"
   */
  @DefaultMessage("AM/PM")
  @Key("timeItem_ampmItemTitle")
  String timeItem_ampmItemTitle();

  /**
   * Translated "AM/PM".
   * 
   * @return translated "AM/PM"
   */
  @DefaultMessage("AM/PM")
  @Key("timeItem_ampmItemPrompt")
  String timeItem_ampmItemPrompt();

  /**
   * Translated "Invalid time".
   * 
   * @return translated "Invalid time"
   */
  @DefaultMessage("Invalid time")
  @Key("timeItem_invalidTimeStringMessage")
  String timeItem_invalidTimeStringMessage();

  /**
   * Translated "Cancel".
   * 
   * @return translated "Cancel"
   */
  @DefaultMessage("Cancel")
  @Key("dateRangeDialog_cancelButtonTitle")
  String dateRangeDialog_cancelButtonTitle();

  /**
   * Translated "Clear".
   * 
   * @return translated "Clear"
   */
  @DefaultMessage("Clear")
  @Key("dateRangeDialog_clearButtonTitle")
  String dateRangeDialog_clearButtonTitle();

  /**
   * Translated "Select Date Range".
   * 
   * @return translated "Select Date Range"
   */
  @DefaultMessage("Select Date Range")
  @Key("dateRangeDialog_headerTitle")
  String dateRangeDialog_headerTitle();

  /**
   * Translated "OK".
   * 
   * @return translated "OK"
   */
  @DefaultMessage("OK")
  @Key("dateRangeDialog_okButtonTitle")
  String dateRangeDialog_okButtonTitle();

  /**
   * Translated "From".
   * 
   * @return translated "From"
   */
  @DefaultMessage("From")
  @Key("dateRangeItem_fromTitle")
  String dateRangeItem_fromTitle();

  /**
   * Translated "To".
   * 
   * @return translated "To"
   */
  @DefaultMessage("To")
  @Key("dateRangeItem_toTitle")
  String dateRangeItem_toTitle();

  /**
   * Translated "''To'' field value cannot be earlier than ''From'' field value.".
   * 
   * @return translated "''To'' field value cannot be earlier than ''From'' field value."
   */
  @DefaultMessage("''To'' field value cannot be earlier than ''From'' field value.")
  @Key("dateRangeItem_invalidRangeErrorMessage")
  String dateRangeItem_invalidRangeErrorMessage();

  /**
   * Translated "$".
   * 
   * @return translated "$"
   */
  @DefaultMessage("$")
  @Key("numberUtil_currencySymbol")
  String numberUtil_currencySymbol();

  /**
   * Translated ",".
   * 
   * @return translated ","
   */
  @DefaultMessage(",")
  @Key("numberUtil_groupingSymbol")
  String numberUtil_groupingSymbol();
  
  /**
   * Translated ".".
   * 
   * @return translated "."
   */
  @DefaultMessage(".")
  @Key("numberUtil_decimalSymbol")
  String numberUtil_decimalSymbol();
  
  /**
   * Translated "-".
   * 
   * @return translated "-"
   */
  @DefaultMessage("-")
  @Key("numberUtil_negativeSymbol")
  String numberUtil_negativeSymbol();

  /**
   * Translated "/".
   * 
   * @return translated "/"
   */
  @DefaultMessage("/")
  @Key("date_dateSeparator")
  String date_dateSeparator();

  /**
   * Translated "toUSShortDate".
   * 
   * @return translated "toUSShortDate"
   */
  @DefaultMessage("toUSShortDate")
  @Key("date_shortDateFormat")
  String date_shortDateFormat();

  /**
   * Translated "toUSShortDatetime".
   * 
   * @return translated "toUSShortDatetime"
   */
  @DefaultMessage("toUSShortDatetime")
  @Key("date_shortDatetimeFormat")
  String date_shortDatetimeFormat();

  /**
   * Translated "toLocaleString".
   * 
   * @return translated "toLocaleString"
   */
  @DefaultMessage("toLocaleString")
  @Key("date_normalDateFormat")
  String date_normalDateFormat();

  /**
   * Translated "toLocaleString".
   * 
   * @return translated "toLocaleString"
   */
  @DefaultMessage("toLocaleString")
  @Key("date_normalDatetimeFormat")
  String date_normalDatetimeFormat();

  /**
   * Translated "MDY".
   * 
   * @return translated "MDY"
   */
  // NOTE: Return an empty string because locales do not normally override this. Thus, for
  // any locale that does not specify a date_inputFormat value (e.g. ru_RU), this default
  // value is inherited.
  //
  // Use an empty string for the default value so that I18nUtil.initMessages() will not set
  // the Date.inputFormat to something inconsistent with the short date format, which many
  // locales do specify.
  @DefaultMessage("MDY")
  @Key("date_inputFormat")
  String date_inputFormat();

  /**
   * Translated "Sunday".
   * 
   * @return translated "Sunday"
   */
  @DefaultMessage("Sunday")
  @Key("date_dayNames_1")
  String date_dayNames_1();

  /**
   * Translated "Monday".
   * 
   * @return translated "Monday"
   */
  @DefaultMessage("Monday")
  @Key("date_dayNames_2")
  String date_dayNames_2();

  /**
   * Translated "Tuesday".
   * 
   * @return translated "Tuesday"
   */
  @DefaultMessage("Tuesday")
  @Key("date_dayNames_3")
  String date_dayNames_3();

  /**
   * Translated "Wednesday".
   * 
   * @return translated "Wednesday"
   */
  @DefaultMessage("Wednesday")
  @Key("date_dayNames_4")
  String date_dayNames_4();

  /**
   * Translated "Thursday".
   * 
   * @return translated "Thursday"
   */
  @DefaultMessage("Thursday")
  @Key("date_dayNames_5")
  String date_dayNames_5();

  /**
   * Translated "Friday".
   * 
   * @return translated "Friday"
   */
  @DefaultMessage("Friday")
  @Key("date_dayNames_6")
  String date_dayNames_6();

  /**
   * Translated "Saturday".
   * 
   * @return translated "Saturday"
   */
  @DefaultMessage("Saturday")
  @Key("date_dayNames_7")
  String date_dayNames_7();

  /**
   * Translated "Sun".
   * 
   * @return translated "Sun"
   */
  @DefaultMessage("Sun")
  @Key("date_shortDayNames_1")
  String date_shortDayNames_1();

  /**
   * Translated "Mon".
   * 
   * @return translated "Mon"
   */
  @DefaultMessage("Mon")
  @Key("date_shortDayNames_2")
  String date_shortDayNames_2();

  /**
   * Translated "Tue".
   * 
   * @return translated "Tue"
   */
  @DefaultMessage("Tue")
  @Key("date_shortDayNames_3")
  String date_shortDayNames_3();

  /**
   * Translated "Wed".
   * 
   * @return translated "Wed"
   */
  @DefaultMessage("Wed")
  @Key("date_shortDayNames_4")
  String date_shortDayNames_4();

  /**
   * Translated "Thu".
   * 
   * @return translated "Thu"
   */
  @DefaultMessage("Thu")
  @Key("date_shortDayNames_5")
  String date_shortDayNames_5();

  /**
   * Translated "Fri".
   * 
   * @return translated "Fri"
   */
  @DefaultMessage("Fri")
  @Key("date_shortDayNames_6")
  String date_shortDayNames_6();

  /**
   * Translated "Sat".
   * 
   * @return translated "Sat"
   */
  @DefaultMessage("Sat")
  @Key("date_shortDayNames_7")
  String date_shortDayNames_7();

  /**
   * Translated "January".
   * 
   * @return translated "January"
   */
  @DefaultMessage("January")
  @Key("date_monthNames_1")
  String date_monthNames_1();

  /**
   * Translated "February".
   * 
   * @return translated "February"
   */
  @DefaultMessage("February")
  @Key("date_monthNames_2")
  String date_monthNames_2();

  /**
   * Translated "March".
   * 
   * @return translated "March"
   */
  @DefaultMessage("March")
  @Key("date_monthNames_3")
  String date_monthNames_3();

  /**
   * Translated "April".
   * 
   * @return translated "April"
   */
  @DefaultMessage("April")
  @Key("date_monthNames_4")
  String date_monthNames_4();

  /**
   * Translated "May".
   * 
   * @return translated "May"
   */
  @DefaultMessage("May")
  @Key("date_monthNames_5")
  String date_monthNames_5();

  /**
   * Translated "June".
   * 
   * @return translated "June"
   */
  @DefaultMessage("June")
  @Key("date_monthNames_6")
  String date_monthNames_6();

  /**
   * Translated "July".
   * 
   * @return translated "July"
   */
  @DefaultMessage("July")
  @Key("date_monthNames_7")
  String date_monthNames_7();

  /**
   * Translated "August".
   * 
   * @return translated "August"
   */
  @DefaultMessage("August")
  @Key("date_monthNames_8")
  String date_monthNames_8();

  /**
   * Translated "September".
   * 
   * @return translated "September"
   */
  @DefaultMessage("September")
  @Key("date_monthNames_9")
  String date_monthNames_9();

  /**
   * Translated "October".
   * 
   * @return translated "October"
   */
  @DefaultMessage("October")
  @Key("date_monthNames_10")
  String date_monthNames_10();

  /**
   * Translated "November".
   * 
   * @return translated "November"
   */
  @DefaultMessage("November")
  @Key("date_monthNames_11")
  String date_monthNames_11();

  /**
   * Translated "December".
   * 
   * @return translated "December"
   */
  @DefaultMessage("December")
  @Key("date_monthNames_12")
  String date_monthNames_12();

  /**
   * Translated "Jan".
   * 
   * @return translated "Jan"
   */
  @DefaultMessage("Jan")
  @Key("date_shortMonthNames_1")
  String date_shortMonthNames_1();

  /**
   * Translated "Feb".
   * 
   * @return translated "Feb"
   */
  @DefaultMessage("Feb")
  @Key("date_shortMonthNames_2")
  String date_shortMonthNames_2();

  /**
   * Translated "Mar".
   * 
   * @return translated "Mar"
   */
  @DefaultMessage("Mar")
  @Key("date_shortMonthNames_3")
  String date_shortMonthNames_3();

  /**
   * Translated "Apr".
   * 
   * @return translated "Apr"
   */
  @DefaultMessage("Apr")
  @Key("date_shortMonthNames_4")
  String date_shortMonthNames_4();

  /**
   * Translated "May".
   * 
   * @return translated "May"
   */
  @DefaultMessage("May")
  @Key("date_shortMonthNames_5")
  String date_shortMonthNames_5();

  /**
   * Translated "Jun".
   * 
   * @return translated "Jun"
   */
  @DefaultMessage("Jun")
  @Key("date_shortMonthNames_6")
  String date_shortMonthNames_6();

  /**
   * Translated "Jul".
   * 
   * @return translated "Jul"
   */
  @DefaultMessage("Jul")
  @Key("date_shortMonthNames_7")
  String date_shortMonthNames_7();

  /**
   * Translated "Aug".
   * 
   * @return translated "Aug"
   */
  @DefaultMessage("Aug")
  @Key("date_shortMonthNames_8")
  String date_shortMonthNames_8();

  /**
   * Translated "Sep".
   * 
   * @return translated "Sep"
   */
  @DefaultMessage("Sep")
  @Key("date_shortMonthNames_9")
  String date_shortMonthNames_9();

  /**
   * Translated "Oct".
   * 
   * @return translated "Oct"
   */
  @DefaultMessage("Oct")
  @Key("date_shortMonthNames_10")
  String date_shortMonthNames_10();

  /**
   * Translated "Nov".
   * 
   * @return translated "Nov"
   */
  @DefaultMessage("Nov")
  @Key("date_shortMonthNames_11")
  String date_shortMonthNames_11();

  /**
   * Translated "Dec".
   * 
   * @return translated "Dec"
   */
  @DefaultMessage("Dec")
  @Key("date_shortMonthNames_12")
  String date_shortMonthNames_12();

  /**
   * Translated "Apply".
   * 
   * @return translated "Apply"
   */
  @DefaultMessage("Apply")
  @Key("dialog_ApplyButtonTitle")
  String dialog_ApplyButtonTitle();

  /**
   * Translated "Please enter a value".
   * 
   * @return translated "Please enter a value"
   */
  @DefaultMessage("Please enter a value")
  @Key("dialog_AskForValueTitle")
  String dialog_AskForValueTitle();

  /**
   * Translated "Question".
   * 
   * @return translated "Question"
   */
  @DefaultMessage("Question")
  @Key("dialog_AskTitle")
  String dialog_AskTitle();

  /**
   * Translated "Cancel".
   * 
   * @return translated "Cancel"
   */
  @DefaultMessage("Cancel")
  @Key("dialog_CancelButtonTitle")
  String dialog_CancelButtonTitle();

  /**
   * Translated "Confirm".
   * 
   * @return translated "Confirm"
   */
  @DefaultMessage("Confirm")
  @Key("dialog_ConfirmTitle")
  String dialog_ConfirmTitle();

  /**
   * Translated "Done".
   * 
   * @return translated "Done"
   */
  @DefaultMessage("Done")
  @Key("dialog_DoneButtonTitle")
  String dialog_DoneButtonTitle();

  /**
   * Translated "Log in".
   * 
   * @return translated "Log in"
   */
  @DefaultMessage("Log in")
  @Key("dialog_LoginButtonTitle")
  String dialog_LoginButtonTitle();

  /**
   * Translated "Invalid username or password".
   * 
   * @return translated "Invalid username or password"
   */
  @DefaultMessage("Invalid username or password")
  @Key("dialog_LoginErrorMessage")
  String dialog_LoginErrorMessage();

  /**
   * Translated "Please log in".
   * 
   * @return translated "Please log in"
   */
  @DefaultMessage("Please log in")
  @Key("dialog_LoginTitle")
  String dialog_LoginTitle();

  /**
   * Translated "No".
   * 
   * @return translated "No"
   */
  @DefaultMessage("No")
  @Key("dialog_NoButtonTitle")
  String dialog_NoButtonTitle();

  /**
   * Translated "OK".
   * 
   * @return translated "OK"
   */
  @DefaultMessage("OK")
  @Key("dialog_OkButtonTitle")
  String dialog_OkButtonTitle();

  /**
   * Translated "Password".
   * 
   * @return translated "Password"
   */
  @DefaultMessage("Password")
  @Key("dialog_PasswordTitle")
  String dialog_PasswordTitle();

  /**
   * Translated "Note".
   * 
   * @return translated "Note"
   */
  @DefaultMessage("Note")
  @Key("dialog_SayTitle")
  String dialog_SayTitle();

  /**
   * Translated "Username".
   * 
   * @return translated "Username"
   */
  @DefaultMessage("Username")
  @Key("dialog_UserNameTitle")
  String dialog_UserNameTitle();

  /**
   * Translated "Warning".
   * 
   * @return translated "Warning"
   */
  @DefaultMessage("Warning")
  @Key("dialog_WarnTitle")
  String dialog_WarnTitle();

  /**
   * Translated "Yes".
   * 
   * @return translated "Yes"
   */
  @DefaultMessage("Yes")
  @Key("dialog_YesButtonTitle")
  String dialog_YesButtonTitle();

  /**
   * Translated "The following errors were found".
   * 
   * @return translated "The following errors were found"
   */
  @DefaultMessage("The following errors were found")
  @Key("dynamicForm_errorsPreamble")
  String dynamicForm_errorsPreamble();

  /**
   * Translated "Form was unable to be submitted. The most likely cause for this is an invalid value in an upload field.".
   * 
   * @return translated "Form was unable to be submitted. The most likely cause for this is an invalid value in an upload field."
   */
  @DefaultMessage("Form was unable to be submitted. The most likely cause for this is an invalid value in an upload field.")
  @Key("dynamicForm_formSubmitFailedWarning")
  String dynamicForm_formSubmitFailedWarning();

  /**
   * Translated "Original value: $value".
   * 
   * @return translated "Original value: $value"
   */
  @DefaultMessage("Original value: $value")
  @Key("dynamicForm_originalValueMessage")
  String dynamicForm_originalValueMessage();

  /**
   * Translated "Add".
   * 
   * @return translated "Add"
   */
  @DefaultMessage("Add")
  @Key("filterBuilder_addButtonPrompt")
  String filterBuilder_addButtonPrompt();

  /**
   * Translated "Match All".
   * 
   * @return translated "Match All"
   */
  @DefaultMessage("Match All")
  @Key("filterBuilder_matchAllTitle")
  String filterBuilder_matchAllTitle();

  /**
   * Translated "Match Any".
   * 
   * @return translated "Match Any"
   */
  @DefaultMessage("Match Any")
  @Key("filterBuilder_matchAnyTitle")
  String filterBuilder_matchAnyTitle();

  /**
   * Translated "Match None".
   * 
   * @return translated "Match None"
   */
  @DefaultMessage("Match None")
  @Key("filterBuilder_matchNoneTitle")
  String filterBuilder_matchNoneTitle();

  /**
   * Translated "[missing field definition]".
   * 
   * @return translated "[missing field definition]"
   */
  @DefaultMessage("[missing field definition]")
  @Key("filterBuilder_missingFieldPrompt")
  String filterBuilder_missingFieldPrompt();

  /**
   * Translated "and".
   * 
   * @return translated "and"
   */
  @DefaultMessage("and")
  @Key("filterBuilder_radioOptions_and")
  String filterBuilder_radioOptions_and();

  /**
   * Translated "not".
   * 
   * @return translated "not"
   */
  @DefaultMessage("not")
  @Key("filterBuilder_radioOptions_not")
  String filterBuilder_radioOptions_not();

  /**
   * Translated "or".
   * 
   * @return translated "or"
   */
  @DefaultMessage("or")
  @Key("filterBuilder_radioOptions_or")
  String filterBuilder_radioOptions_or();

  /**
   * Translated "and".
   * 
   * @return translated "and"
   */
  @DefaultMessage("and")
  @Key("filterBuilder_rangeSeparator")
  String filterBuilder_rangeSeparator();

  /**
   * Translated "Remove".
   * 
   * @return translated "Remove"
   */
  @DefaultMessage("Remove")
  @Key("filterBuilder_removeButtonPrompt")
  String filterBuilder_removeButtonPrompt();

  /**
   * Translated "The last clause cannot be removed".
   * 
   * @return translated "The last clause cannot be removed"
   */
  @DefaultMessage("The last clause cannot be removed")
  @Key("filterBuilder_lastClausePrompt")
  String filterBuilder_lastClausePrompt();

  /**
   * Translated "Add Subclause".
   * 
   * @return translated "Add Subclause"
   */
  @DefaultMessage("Add Subclause")
  @Key("filterBuilder_subClauseButtonPrompt")
  String filterBuilder_subClauseButtonPrompt();

  /**
   * Translated "+()".
   * 
   * @return translated "+()"
   */
  @DefaultMessage("+()")
  @Key("filterBuilder_subClauseButtonTitle")
  String filterBuilder_subClauseButtonTitle();

  /**
   * Translated "and".
   * 
   * @return translated "and"
   */
  @DefaultMessage("and")
  @Key("filterBuilder_topOperator")
  String filterBuilder_topOperator();

  /**
   * Translated "Operator".
   * 
   * @return translated "Operator"
   */
  @DefaultMessage("Operator")
  @Key("filterBuilder_operatorPickerTitle")
  String filterBuilder_operatorPickerTitle();
  
  /**
   * Translated "Field Name".
   * 
   * @return translated "Field Name"
   */
  @DefaultMessage("Field Name")
  @Key("filterBuilder_fieldPickerTitle")
  String filterBuilder_fieldPickerTitle();
  
  /**
   * Translated "Overall Operator".
   * 
   * @return translated "Overall Operator"
   */
  @DefaultMessage("Overall Operator")
  @Key("filterBuilder_radioOperatorTitle")
  String filterBuilder_radioOperatorTitle();
  
  /**
   * Translated "Clause Operator".
   * 
   * @return translated "Clause Operator"
   */
  @DefaultMessage("Clause Operator")
  @Key("filterBuilder_topOperatorTitle")
  String filterBuilder_topOperatorTitle();
  
  /**
   * Translated "and".
   * 
   * @return translated "and"
   */
  @DefaultMessage("and")
  @Key("FilterBuilder_inlineAndTitle")
  String FilterBuilder_inlineAndTitle();

  /**
   * Translated "or".
   * 
   * @return translated "or"
   */
  @DefaultMessage("or")
  @Key("FilterBuilder_inlineOrTitle")
  String FilterBuilder_inlineOrTitle();

  /**
   * Translated "and not".
   * 
   * @return translated "and not"
   */
  @DefaultMessage("and not")
  @Key("FilterBuilder_inlineAndNotTitle")
  String FilterBuilder_inlineAndNotTitle();
  
  /**
   * Translated "Advanced..".
   * 
   * @return translated "Advanced.."
   */
  @DefaultMessage("Advanced..")
  @Key("FilterBuilder_modeSwitcherAdvancedMessage")
  String FilterBuilder_modeSwitcherAdvancedMessage();
    
  /**
   * Translated "Simple Mode..".
   * 
   * @return translated "Simple Mode.."
   */
  @DefaultMessage("Simple Mode..")
  @Key("FilterBuilder_modeSwitcherSimpleMessage")
  String FilterBuilder_modeSwitcherSimpleMessage();
    
  /**
   * Translated "Criteria will be modified to fit in simpler editing interface".
   * 
   * @return translated "Criteria will be modified to fit in simpler editing interface"
   */
  @DefaultMessage("Criteria will be modified to fit in simpler editing interface")
  @Key("FilterBuilder_modeSwitcherFlattenWarningMessage")
  String FilterBuilder_modeSwitcherFlattenWarningMessage();
    
  /**
   * Translated "Remove".
   * 
   * @return translated "Remove"
   */
  @DefaultMessage("Remove")
  @Key("filterClause_removeButtonPrompt")
  String filterClause_removeButtonPrompt();


  /**
   * Translated "Field Name".
   * 
   * @return translated "Field Name"
   */
  @DefaultMessage("Field Name")
  @Key("filterClause_fieldPickerTitle")
  String filterClause_fieldPickerTitle();

  /**
   * Translated "Value".
   * 
   * @return translated "Value"
   */
  @DefaultMessage("Value")
  @Key("filterClause_valueItemTitle")
  String filterClause_valueItemTitle();
  
  /**
   * Translated "Operator".
   * 
   * @return translated "Operator"
   */
  @DefaultMessage("Operator")
  @Key("filterClause_operatorPickerTitle")
  String filterClause_operatorPickerTitle();

  /**
   * Translated "Comma-separated values".
   * 
   * @return translated "Comma-separated values"
   */
  @DefaultMessage("Comma-separated values")
  @Key("filterClause_valueSetHint")
  String filterClause_valueSetHint();

  /**
   * Translated "Enter a value".
   * 
   * @return translated "Enter a value"
   */
  @DefaultMessage("Enter a value")
  @Key("filterClause_valueItemTextHint")
  String filterClause_valueItemTextHint();
  
  
    /* filterClause_valueItemListHint value changed on Wed Jan  5 07:19:28 2022
   Old value was 'Choose a value'.
   See definition later in this file for new value.
  */

    /* filterClause_valueItemFieldHint value changed on Wed Jan  5 07:19:28 2022
   Old value was 'Choose a field'.
   See definition later in this file for new value.
  */

  /**
   * Translated "Is Frozen".
   * 
   * @return translated "Is Frozen"
   */
  @DefaultMessage("Is Frozen")
  @Key("fieldPickerField_frozenTitle")
  String fieldPickerField_frozenTitle();

  /**
   * Translated "Precision".
   * 
   * @return translated "Precision"
   */
  @DefaultMessage("Precision")
  @Key("fieldPickerField_precisionTitle")
  String fieldPickerField_precisionTitle();

  /**
   * Translated "Decimal Precision".
   * 
   * @return translated "Decimal Precision"
   */
  @DefaultMessage("Decimal Precision")
  @Key("fieldPickerField_decimalPrecisionTitle")
  String fieldPickerField_decimalPrecisionTitle();

  /**
   * Translated "Decimal Pad".
   * 
   * @return translated "Decimal Pad"
   */
  @DefaultMessage("Decimal Pad")
  @Key("fieldPickerField_decimalPadTitle")
  String fieldPickerField_decimalPadTitle();

  /**
   * Translated "Header Text Alignment".
   * 
   * @return translated "Header Text Alignment"
   */
  @DefaultMessage("Header Text Alignment")
  @Key("fieldPickerField_alignTitle")
  String fieldPickerField_alignTitle();

  /**
   * Translated "Data Alignment".
   * 
   * @return translated "Data Alignment"
   */
  @DefaultMessage("Data Alignment")
  @Key("fieldPickerField_cellAlignTitle")  
  String fieldPickerField_cellAlignTitle();

  /**
   * Translated "Highlights...".
   * 
   * @return translated "Highlights..."
   */
  @DefaultMessage("Highlights...")
  @Key("fieldPicker_hilitesText")
  String fieldPicker_hilitesText();

  /**
   * Translated "Available Fields".
   * 
   * @return translated "Available Fields"
   */
  @DefaultMessage("Available Fields")
  @Key("fieldPicker_availableFieldsTitle")
  String fieldPicker_availableFieldsTitle();

  /**
   * Translated "Visible Fields".
   * 
   * @return translated "Visible Fields"
   */
  @DefaultMessage("Visible Fields")
  @Key("fieldPicker_currentFieldsTitle")
  String fieldPicker_currentFieldsTitle();

  /**
   * Translated "Must save pending changes to proceed. OK?".
   * 
   * @return translated "Must save pending changes to proceed. OK?"
   */
  @DefaultMessage("Must save pending changes to proceed. OK?")
  @Key("fieldPicker_confirmText")
  String fieldPicker_confirmText();

  /**
   * Translated "You are about to remove the field. Are you sure?".
   * 
   * @return translated "You are about to remove the field. Are you sure?"
   */
  @DefaultMessage("You are about to remove the field. Are you sure?")
  @Key("fieldPicker_removeText")
  String fieldPicker_removeText();

  /**
   * Translated "Drag and drop or use arrows to move fields.  Drag reorder to change field order.".
   * 
   * @return translated "Drag and drop or use arrows to move fields.  Drag reorder to change field order."
   */
  @DefaultMessage("Drag and drop or use arrows to move fields.  Drag reorder to change field order.")
  @Key("fieldPicker_instructions")
  String fieldPicker_instructions();

  /**
   * Translated "Apply".
   * 
   * @return translated "Apply"
   */
  @DefaultMessage("Apply")
  @Key("fieldPicker_saveAndExitButtonTitle")
  String fieldPicker_saveAndExitButtonTitle();

  /**
   * Translated "Cancel".
   * 
   * @return translated "Cancel"
   */
  @DefaultMessage("Cancel")
  @Key("fieldPicker_cancelButtonTitle")
  String fieldPicker_cancelButtonTitle();

  /**
   * Translated "Add Custom Fields".
   * 
   * @return translated "Add Custom Fields"
   */
  @DefaultMessage("Add Custom Fields")
  @Key("fieldPicker_addCustomFieldsButtonTitle")
  String fieldPicker_addCustomFieldsButtonTitle();

  /**
   * Translated "Name".
   * 
   * @return translated "Name"
   */
  @DefaultMessage("Name")
  @Key("fieldPicker_availableTitleTitle")
  String fieldPicker_availableTitleTitle();

  /**
   * Translated "Field Title".
   * 
   * @return translated "Field Title"
   */
  @DefaultMessage("Field Title")
  @Key("fieldPicker_currentTitleTitle")
  String fieldPicker_currentTitleTitle();
  
  /**
   * Translated "Sample Value".
   * 
   * @return translated "Sample Value"
   */
  @DefaultMessage("Sample Value")
  @Key("fieldPicker_sampleValueTitle")
  String fieldPicker_sampleValueTitle();
  
  /**
   * Translated "Field Picker".
   * 
   * @return translated "Field Picker"
   */
  @DefaultMessage("Field Picker")
  @Key("fieldPickerWindow_title")
  String fieldPickerWindow_title();

  /**
   * Translated "Remove".
   * 
   * @return translated "Remove"
   */
  @DefaultMessage("Remove")
  @Key("fieldPicker_removeItemTitle")
  String fieldPicker_removeItemTitle();

    /**
   * Translated "[No title specified]".
   * 
   * @return translated "[No title specified]"
   */
  @DefaultMessage("[No title specified]")
  @Key("fieldPicker_emptyTitleHint")
  String fieldPicker_emptyTitleHint();

  /**
   * Translated "null".
   * 
   * @return translated "null"
   */
  @DefaultMessage("null")
  @Key("formItem_pickerIconPrompt")
  String formItem_pickerIconPrompt();

  /**
   * Translated "Auto hide fields used in formula".
   * 
   * @return translated "Auto hide fields used in formula"
   */
  @DefaultMessage("Auto hide fields used in formula")
  @Key("formulaBuilder_autoHideCheckBoxLabel")
  String formulaBuilder_autoHideCheckBoxLabel();

  /**
   * Translated "Formula".
   * 
   * @return translated "Formula"
   */
  @DefaultMessage("Formula")
  @Key("formulaBuilder_builderTypeText")
  String formulaBuilder_builderTypeText();

  /**
   * Translated "Cancel".
   * 
   * @return translated "Cancel"
   */
  @DefaultMessage("Cancel")
  @Key("formulaBuilder_cancelButtonTitle")
  String formulaBuilder_cancelButtonTitle();

  /**
   * Translated "New Field".
   * 
   * @return translated "New Field"
   */
  @DefaultMessage("New Field")
  @Key("formulaBuilder_defaultNewFieldTitle")
  String formulaBuilder_defaultNewFieldTitle();

  /* formulaBuilder_helpTextIntro value changed on Wed Jan  5 07:19:28 2022
   Old value was 'Building Formula Columns<p>For basic arithmetic, type in symbols (+, -, *, /, %, //) directly.<p>The following functions are available:'.
   See definition later in this file for new value.
  */

  /**
   * Translated "$builderType Help".
   * 
   * @return translated "$builderType Help"
   */
  @DefaultMessage("$builderType Help")
  @Key("formulaBuilder_helpWindowTitle")
  String formulaBuilder_helpWindowTitle();

  /**
   * Translated "The following fields are available for use in this $builderType.  Click any field to have it added to the $builderType.".
   * 
   * @return translated "The following fields are available for use in this $builderType.  Click any field to have it added to the $builderType."
   */
  @DefaultMessage("The following fields are available for use in this $builderType.  Click any field to have it added to the $builderType.")
  @Key("formulaBuilder_instructionsTextStart")
  String formulaBuilder_instructionsTextStart();

  /**
   * Translated "Invalid blank $builderType".
   * 
   * @return translated "Invalid blank $builderType"
   */
  @DefaultMessage("Invalid blank $builderType")
  @Key("formulaBuilder_invalidBlankPrompt")
  String formulaBuilder_invalidBlankPrompt();

  /**
   * Translated "Invalid $builderType: $errorText".
   * 
   * @return translated "Invalid $builderType: $errorText"
   */
  @DefaultMessage("Invalid $builderType: $errorText")
  @Key("formulaBuilder_invalidBuilderPrompt")
  String formulaBuilder_invalidBuilderPrompt();

  /**
   * Translated "The generated function is invalid - Check your $builderType and retry.".
   * 
   * @return translated "The generated function is invalid - Check your $builderType and retry."
   */
  @DefaultMessage("The generated function is invalid - Check your $builderType and retry.")
  @Key("formulaBuilder_invalidGeneratedFunctionPrompt")
  String formulaBuilder_invalidGeneratedFunctionPrompt();

  /**
   * Translated "Key".
   * 
   * @return translated "Key"
   */
  @DefaultMessage("Key")
  @Key("formulaBuilder_keyColumnTitle")
  String formulaBuilder_keyColumnTitle();

  /**
   * Translated "Sample:".
   * 
   * @return translated "Sample:"
   */
  @DefaultMessage("Sample:")
  @Key("formulaBuilder_sampleHeaderTitle")
  String formulaBuilder_sampleHeaderTitle();

  /**
   * Translated "For record:".
   * 
   * @return translated "For record:"
   */
  @DefaultMessage("For record:")
  @Key("formulaBuilder_samplePromptForRecord")
  String formulaBuilder_samplePromptForRecord();

  /**
   * Translated "Output:".
   * 
   * @return translated "Output:"
   */
  @DefaultMessage("Output:")
  @Key("formulaBuilder_samplePromptOutput")
  String formulaBuilder_samplePromptOutput();

  /**
   * Translated "Save".
   * 
   * @return translated "Save"
   */
  @DefaultMessage("Save")
  @Key("formulaBuilder_saveButtonTitle")
  String formulaBuilder_saveButtonTitle();

  /**
   * Translated "Save changes to this $builderType?".
   * 
   * @return translated "Save changes to this $builderType?"
   */
  @DefaultMessage("Save changes to this $builderType?")
  @Key("formulaBuilder_saveConfirmationPrompt")
  String formulaBuilder_saveConfirmationPrompt();

  /**
   * Translated "Source Field".
   * 
   * @return translated "Source Field"
   */
  @DefaultMessage("Source Field")
  @Key("formulaBuilder_sourceFieldColumnTitle")
  String formulaBuilder_sourceFieldColumnTitle();

  /**
   * Translated "Test".
   * 
   * @return translated "Test"
   */
  @DefaultMessage("Test")
  @Key("formulaBuilder_testButtonTitle")
  String formulaBuilder_testButtonTitle();

  /**
   * Translated "Title".
   * 
   * @return translated "Title"
   */
  @DefaultMessage("Title")
  @Key("formulaBuilder_titleFieldTitle")
  String formulaBuilder_titleFieldTitle();

  /**
   * Translated "Valid $builderType".
   * 
   * @return translated "Valid $builderType"
   */
  @DefaultMessage("Valid $builderType")
  @Key("formulaBuilder_validBuilderPrompt")
  String formulaBuilder_validBuilderPrompt();

  /**
   * Translated "[No Explicit Error]".
   * 
   * @return translated "[No Explicit Error]"
   */
  @DefaultMessage("[No Explicit Error]")
  @Key("formulaBuilder_defaultErrorText")
  String formulaBuilder_defaultErrorText();
  
  /* formulaBuilder_saveAddAnotherButtonTitle value changed on Wed Jan  5 07:19:28 2022
   Old value was 'Save & Add Another'.
   See definition later in this file for new value.
  */
  
  /**
   * Translated "Another field already has the title ''$fieldTitle''.  Continue anyway?".
   * 
   * @return translated "Another field already has the title ''$fieldTitle''.  Continue anyway?"
   */
  @DefaultMessage("Another field already has the title ''$fieldTitle''.  Continue anyway?")
  @Key("formulaBuilder_warnDuplicateTitlesMessage")
  String formulaBuilder_warnDuplicateTitlesMessage();

  /**
   * Translated "Source DataSource".
   * 
   * @return translated "Source DataSource"
   */
  @DefaultMessage("Source DataSource")
  @Key("formulaBuilder_sourceDSColumnTitle")
  String formulaBuilder_sourceDSColumnTitle();

  /**
   * Translated "by Day of Month".
   * 
   * @return translated "by Day of Month"
   */
  @DefaultMessage("by Day of Month")
  @Key("grouping_byDayOfMonthTitle")
  String grouping_byDayOfMonthTitle();

  /**
   * Translated "by Day".
   * 
   * @return translated "by Day"
   */
  @DefaultMessage("by Day")
  @Key("grouping_byDayTitle")
  String grouping_byDayTitle();

  /**
   * Translated "by Date".
   * 
   * @return translated "by Date"
   */
  @DefaultMessage("by Date")
  @Key("grouping_byDateTitle")
  String grouping_byDateTitle();

  /**
   * Translated "by Week and Year".
   * 
   * @return translated "by Week and Year"
   */
  @DefaultMessage("by Week and Year")
  @Key("grouping_byWeekAndYearTitle")
  String grouping_byWeekAndYearTitle();

  /**
   * Translated "by Month and Year".
   * 
   * @return translated "by Month and Year"
   */
  @DefaultMessage("by Month and Year")
  @Key("grouping_byMonthAndYearTitle")
  String grouping_byMonthAndYearTitle();

  /**
   * Translated "by Quarter and Year".
   * 
   * @return translated "by Quarter and Year"
   */
  @DefaultMessage("by Quarter and Year")
  @Key("grouping_byQuarterAndYearTitle")
  String grouping_byQuarterAndYearTitle();

  /**
   * Translated "by Day of specific Week".
   * 
   * @return translated "by Day of specific Week"
   */
  @DefaultMessage("by Day of specific Week")
  @Key("grouping_byDayOfWeekAndYearTitle")
  String grouping_byDayOfWeekAndYearTitle();

  /**
   * Translated "by Day of specific Month".
   * 
   * @return translated "by Day of specific Month"
   */
  @DefaultMessage("by Day of specific Month")
  @Key("grouping_byDayOfMonthAndYearTitle")
  String grouping_byDayOfMonthAndYearTitle();

  /**
   * Translated "by Hours".
   * 
   * @return translated "by Hours"
   */
  @DefaultMessage("by Hours")
  @Key("grouping_byHoursTitle")
  String grouping_byHoursTitle();

  /**
   * Translated "by Milliseconds".
   * 
   * @return translated "by Milliseconds"
   */
  @DefaultMessage("by Milliseconds")
  @Key("grouping_byMillisecondsTitle")
  String grouping_byMillisecondsTitle();

  /**
   * Translated "by Minutes".
   * 
   * @return translated "by Minutes"
   */
  @DefaultMessage("by Minutes")
  @Key("grouping_byMinutesTitle")
  String grouping_byMinutesTitle();

  /**
   * Translated "by Month".
   * 
   * @return translated "by Month"
   */
  @DefaultMessage("by Month")
  @Key("grouping_byMonthTitle")
  String grouping_byMonthTitle();

  /**
   * Translated "by Quarter".
   * 
   * @return translated "by Quarter"
   */
  @DefaultMessage("by Quarter")
  @Key("grouping_byQuarterTitle")
  String grouping_byQuarterTitle();

  /**
   * Translated "by Seconds".
   * 
   * @return translated "by Seconds"
   */
  @DefaultMessage("by Seconds")
  @Key("grouping_bySecondsTitle")
  String grouping_bySecondsTitle();

  /**
   * Translated "by Upcoming".
   * 
   * @return translated "by Upcoming"
   */
  @DefaultMessage("by Upcoming")
  @Key("grouping_byUpcomingTitle")
  String grouping_byUpcomingTitle();

  /**
   * Translated "by Week".
   * 
   * @return translated "by Week"
   */
  @DefaultMessage("by Week")
  @Key("grouping_byWeekTitle")
  String grouping_byWeekTitle();

  /**
   * Translated "by Year".
   * 
   * @return translated "by Year"
   */
  @DefaultMessage("by Year")
  @Key("grouping_byYearTitle")
  String grouping_byYearTitle();

  /**
   * Translated "Before".
   * 
   * @return translated "Before"
   */
  @DefaultMessage("Before")
  @Key("grouping_upcomingBeforeTitle")
  String grouping_upcomingBeforeTitle();

  /**
   * Translated "Today".
   * 
   * @return translated "Today"
   */
  @DefaultMessage("Today")
  @Key("grouping_upcomingTodayTitle")
  String grouping_upcomingTodayTitle();

  /**
   * Translated "Tomorrow".
   * 
   * @return translated "Tomorrow"
   */
  @DefaultMessage("Tomorrow")
  @Key("grouping_upcomingTomorrowTitle")
  String grouping_upcomingTomorrowTitle();

  /**
   * Translated "This Week".
   * 
   * @return translated "This Week"
   */
  @DefaultMessage("This Week")
  @Key("grouping_upcomingThisWeekTitle")
  String grouping_upcomingThisWeekTitle();

  /**
   * Translated "Next Week".
   * 
   * @return translated "Next Week"
   */
  @DefaultMessage("Next Week")
  @Key("grouping_upcomingNextWeekTitle")
  String grouping_upcomingNextWeekTitle();

  /**
   * Translated "This Month".
   * 
   * @return translated "This Month"
   */
  @DefaultMessage("This Month")
  @Key("grouping_upcomingThisMonthTitle")
  String grouping_upcomingThisMonthTitle();

  /**
   * Translated "Next Month".
   * 
   * @return translated "Next Month"
   */
  @DefaultMessage("Next Month")
  @Key("grouping_upcomingNextMonthTitle")
  String grouping_upcomingNextMonthTitle();

  /**
   * Translated "This Year".
   * 
   * @return translated "This Year"
   */
  @DefaultMessage("This Year")
  @Key("grouping_upcomingThisYearTitle")
  String grouping_upcomingThisYearTitle();

  /**
   * Translated "Next Year".
   * 
   * @return translated "Next Year"
   */
  @DefaultMessage("Next Year")
  @Key("grouping_upcomingNextYearTitle")
  String grouping_upcomingNextYearTitle();

  /**
   * Translated "Later".
   * 
   * @return translated "Later"
   */
  @DefaultMessage("Later")
  @Key("grouping_upcomingLaterTitle")
  String grouping_upcomingLaterTitle();

  /**
   * Translated "Week #".
   * 
   * @return translated "Week #"
   */
  @DefaultMessage("Week #")
  @Key("grouping_weekNumberTitle")
  String grouping_weekNumberTitle();

  /**
   * Translated "minutes".
   * 
   * @return translated "minutes"
   */
  @DefaultMessage("minutes")
  @Key("grouping_timezoneMinutesSuffix")
  String grouping_timezoneMinutesSuffix();

  /**
   * Translated "seconds".
   * 
   * @return translated "seconds"
   */
  @DefaultMessage("seconds")
  @Key("grouping_timezoneSecondsSuffix")
  String grouping_timezoneSecondsSuffix();

  /**
   * Translated "Remove".
   * 
   * @return translated "Remove"
   */
  @DefaultMessage("Remove")
  @Key("hiliteRule_removeButtonPrompt")
  String hiliteRule_removeButtonPrompt();

  /**
   * Translated "Color".
   * 
   * @return translated "Color"
   */
  @DefaultMessage("Color")
  @Key("hiliteRule_colorFieldTitle")
  String hiliteRule_colorFieldTitle();
  
  /**
   * Translated "Icon".
   * 
   * @return translated "Icon"
   */
  @DefaultMessage("Icon")
  @Key("hiliteRule_iconFieldTitle")
  String hiliteRule_iconFieldTitle();

  /**
   * Translated "Text".
   * 
   * @return translated "Text"
   */
  @DefaultMessage("Text")
  @Key("hiliteRule_foregroundColorTitle")
  String hiliteRule_foregroundColorTitle();
  

  /**
   * Translated "Background".
   * 
   * @return translated "Background"
   */
  @DefaultMessage("Background")
  @Key("hiliteRule_backgroundColorTitle")
  String hiliteRule_backgroundColorTitle();
  
  /**
   * Translated "Add Advanced Rule".
   * 
   * @return translated "Add Advanced Rule"
   */
  @DefaultMessage("Add Advanced Rule")
  @Key("hiliteEditor_addAdvancedRuleButtonTitle")
  String hiliteEditor_addAdvancedRuleButtonTitle();

  /**
   * Translated "Save".
   * 
   * @return translated "Save"
   */
  @DefaultMessage("Save")
  @Key("hiliteEditor_saveButtonTitle")
  String hiliteEditor_saveButtonTitle();

  /**
   * Translated "Cancel".
   * 
   * @return translated "Cancel"
   */
  @DefaultMessage("Cancel")
  @Key("hiliteEditor_cancelButtonTitle")
  String hiliteEditor_cancelButtonTitle();

  /**
   * Translated "Available Fields".
   * 
   * @return translated "Available Fields"
   */
  @DefaultMessage("Available Fields")
  @Key("hiliteEditor_availableFieldsColumnTitle")
  String hiliteEditor_availableFieldsColumnTitle();

  /**
   * Translated "Advanced Highlight Editor".
   * 
   * @return translated "Advanced Highlight Editor"
   */
  @DefaultMessage("Advanced Highlight Editor")
  @Key("advancedHiliteEditor_title")
  String advancedHiliteEditor_title();

  /**
   * Translated "Save".
   * 
   * @return translated "Save"
   */
  @DefaultMessage("Save")
  @Key("advancedHiliteEditor_saveButtonTitle")
  String advancedHiliteEditor_saveButtonTitle();

  /**
   * Translated "Cancel".
   * 
   * @return translated "Cancel"
   */
  @DefaultMessage("Cancel")
  @Key("advancedHiliteEditor_cancelButtonTitle")
  String advancedHiliteEditor_cancelButtonTitle();

  /**
   * Translated "Enter at least one rule, a color or icon, and a target field, or press ''Cancel'' to abandon changes.".
   * 
   * @return translated "Enter at least one rule, a color or icon, and a target field, or press ''Cancel'' to abandon changes."
   */
  @DefaultMessage("Enter at least one rule, a color or icon, and a target field, or press ''Cancel'' to abandon changes.")
  @Key("advancedHiliteEditor_invalidHilitePrompt")
  String advancedHiliteEditor_invalidHilitePrompt();

  /**
   * Translated "Filter".
   * 
   * @return translated "Filter"
   */
  @DefaultMessage("Filter")
  @Key("advancedHiliteEditor_filterGroupTitle")
  String advancedHiliteEditor_filterGroupTitle();
  
  /**
   * Translated "Appearance".
   * 
   * @return translated "Appearance"
   */
  @DefaultMessage("Appearance")
  @Key("advancedHiliteEditor_appearanceGroupTitle")
  String advancedHiliteEditor_appearanceGroupTitle();
  
  /**
   * Translated "Target Field(s)".
   * 
   * @return translated "Target Field(s)"
   */
  @DefaultMessage("Target Field(s)")
  @Key("advancedHiliteEditor_targetFieldsItemTitle")
  String advancedHiliteEditor_targetFieldsItemTitle();
  
  /**
   * Translated "Click icon to add...".
   * 
   * @return translated "Click icon to add..."
   */
  @DefaultMessage("Click icon to add...")
  @Key("multiFilePicker_emptyMessage")
  String multiFilePicker_emptyMessage();

  /**
   * Translated "Add files".
   * 
   * @return translated "Add files"
   */
  @DefaultMessage("Add files")
  @Key("multiFilePicker_title")
  String multiFilePicker_title();
  
  /**
   * Translated "Show Menu".
   * 
   * @return translated "Show Menu"
   */
  @DefaultMessage("Show Menu")
  @Key("iMenuButton_title")
  String iMenuButton_title();

  /**
   * Translated "Start at".
   * 
   * @return translated "Start at"
   */
  @DefaultMessage("Start at")
  @Key("listPropertiesPane_startNumberFieldTitle")
  String listPropertiesPane_startNumberFieldTitle();

  /**
   * Translated "List Properties".
   * 
   * @return translated "List Properties"
   */
  @DefaultMessage("List Properties")
  @Key("listPropertiesDialog_title")
  String listPropertiesDialog_title();

  /**
   * Translated "Apply".
   * 
   * @return translated "Apply"
   */
  @DefaultMessage("Apply")
  @Key("listPropertiesDialog_applyButtonTitle")
  String listPropertiesDialog_applyButtonTitle();

  /**
   * Translated "Cancel".
   * 
   * @return translated "Cancel"
   */
  @DefaultMessage("Cancel")
  @Key("listPropertiesDialog_cancelButtonTitle")
  String listPropertiesDialog_cancelButtonTitle();

  /**
   * Translated "Close portlet?".
   * 
   * @return translated "Close portlet?"
   */
  @DefaultMessage("Close portlet?")
  @Key("portlet_closeConfirmationMessage")
  String portlet_closeConfirmationMessage();

  /**
   * Translated "Auto Fit All Columns".
   * 
   * @return translated "Auto Fit All Columns"
   */
  @DefaultMessage("Auto Fit All Columns")
  @Key("listGrid_autoFitAllText")
  String listGrid_autoFitAllText();

  /**
   * Translated "Auto Fit".
   * 
   * @return translated "Auto Fit"
   */
  @DefaultMessage("Auto Fit")
  @Key("listGrid_autoFitFieldText")
  String listGrid_autoFitFieldText();

  /* listGrid_cancelEditingConfirmationMessage value changed on Wed Jan  5 07:19:28 2022
   Old value was 'Cancelling this edit will clear unsaved edit values for this record. Continue?'.
   See definition later in this file for new value.
  */

  /**
   * Translated "Clear All Sorting".
   * 
   * @return translated "Clear All Sorting"
   */
  @DefaultMessage("Clear All Sorting")
  @Key("listGrid_clearAllSortingText")
  String listGrid_clearAllSortingText();

  /**
   * Translated "Clear Filter".
   * 
   * @return translated "Clear Filter"
   */
  @DefaultMessage("Clear Filter")
  @Key("listGrid_clearFilterText")
  String listGrid_clearFilterText();

  /**
   * Translated "Filter using".
   * 
   * @return translated "Filter using"
   */
  @DefaultMessage("Filter using")
  @Key("listGrid_filterUsingText")
  String listGrid_filterUsingText();

  /**
   * Translated "(default)".
   * 
   * @return translated "(default)"
   */
  @DefaultMessage("(default)")
  @Key("listGrid_defaultFilterOperatorSuffix")
  String listGrid_defaultFilterOperatorSuffix();

  /**
   * Translated "Clear Sort".
   * 
   * @return translated "Clear Sort"
   */
  @DefaultMessage("Clear Sort")
  @Key("listGrid_clearSortFieldText")
  String listGrid_clearSortFieldText();

  /**
   * Translated "Configure Sort...".
   * 
   * @return translated "Configure Sort..."
   */
  @DefaultMessage("Configure Sort...")
  @Key("listGrid_configureSortText")
  String listGrid_configureSortText();

  /**
   * Translated "Configure Grouping...".
   * 
   * @return translated "Configure Grouping..."
   */
  @DefaultMessage("Configure Grouping...")
  @Key("listGrid_configureGroupingText")
  String listGrid_configureGroupingText();

  /* listGrid_confirmDiscardEditsMessage value changed on Wed Jan  5 07:19:28 2022
   Old value was 'This action will discard all unsaved edited values for this list.'.
   See definition later in this file for new value.
  */

  /**
   * Translated "Delete".
   * 
   * @return translated "Delete"
   */
  @DefaultMessage("Delete")
  @Key("listGrid_deleteRecordContextMenuItemTitle")
  String listGrid_deleteRecordContextMenuItemTitle();

  /**
   * Translated "Save".
   * 
   * @return translated "Save"
   */
  @DefaultMessage("Save")
  @Key("listGrid_discardEditsSaveButtonTitle")
  String listGrid_discardEditsSaveButtonTitle();

  /**
   * Translated "Dismiss".
   * 
   * @return translated "Dismiss"
   */
  @DefaultMessage("Dismiss")
  @Key("listGrid_dismissEmbeddedComponentContextMenuItemTitle")
  String listGrid_dismissEmbeddedComponentContextMenuItemTitle();

  /**
   * Translated "No items to show.".
   * 
   * @return translated "No items to show."
   */
  @DefaultMessage("No items to show.")
  @Key("listGrid_emptyMessage")
  String listGrid_emptyMessage();

  /**
   * Translated "Columns".
   * 
   * @return translated "Columns"
   */
  @DefaultMessage("Columns")
  @Key("listGrid_fieldVisibilitySubmenuTitle")
  String listGrid_fieldVisibilitySubmenuTitle();

  /**
   * Translated "Freeze $title".
   * 
   * @return translated "Freeze $title"
   */
  @DefaultMessage("Freeze $title")
  @Key("listGrid_freezeFieldText")
  String listGrid_freezeFieldText();

  /**
   * Translated "Freeze on left".
   * 
   * @return translated "Freeze on left"
   */
  @DefaultMessage("Freeze on left")
  @Key("listGrid_freezeOnLeftText")
  String listGrid_freezeOnLeftText();

  /**
   * Translated "Freeze on right".
   * 
   * @return translated "Freeze on right"
   */
  @DefaultMessage("Freeze on right")
  @Key("listGrid_freezeOnRightText")
  String listGrid_freezeOnRightText();

  /**
   * Translated "Group by $title".
   * 
   * @return translated "Group by $title"
   */
  @DefaultMessage("Group by $title")
  @Key("listGrid_groupByText")
  String listGrid_groupByText();

  /**
   * Translated "This grid is limited to $count simultaneously expanded records.  Please collapse some expanded records and retry.".
   * 
   * @return translated "This grid is limited to $count simultaneously expanded records.  Please collapse some expanded records and retry."
   */
  @DefaultMessage("This grid is limited to $count simultaneously expanded records.  Please collapse some expanded records and retry.")
  @Key("listGrid_maxExpandedRecordsPrompt")
  String listGrid_maxExpandedRecordsPrompt();

  /**
   * Translated "-- Add New Row --".
   * 
   * @return translated "-- Add New Row --"
   */
  @DefaultMessage("-- Add New Row --")
  @Key("listGrid_newRecordRowMessage")
  String listGrid_newRecordRowMessage();

  /**
   * Translated "Edit".
   * 
   * @return translated "Edit"
   */
  @DefaultMessage("Edit")
  @Key("listGrid_openRecordEditorContextMenuItemTitle")
  String listGrid_openRecordEditorContextMenuItemTitle();

  /**
   * Translated "Cancel".
   * 
   * @return translated "Cancel"
   */
  @DefaultMessage("Cancel")
  @Key("listGrid_recordEditorCancelButtonTitle")
  String listGrid_recordEditorCancelButtonTitle();

  /**
   * Translated "Save".
   * 
   * @return translated "Save"
   */
  @DefaultMessage("Save")
  @Key("listGrid_recordEditorSaveButtonTitle")
  String listGrid_recordEditorSaveButtonTitle();

  /**
   * Translated "[Remove record]".
   * 
   * @return translated "[Remove record]"
   */
  @DefaultMessage("[Remove record]")
  @Key("listGrid_removeFieldTitle")
  String listGrid_removeFieldTitle();

  /**
   * Translated "Sort Ascending".
   * 
   * @return translated "Sort Ascending"
   */
  @DefaultMessage("Sort Ascending")
  @Key("listGrid_sortFieldAscendingText")
  String listGrid_sortFieldAscendingText();

  /**
   * Translated "Sort Descending".
   * 
   * @return translated "Sort Descending"
   */
  @DefaultMessage("Sort Descending")
  @Key("listGrid_sortFieldDescendingText")
  String listGrid_sortFieldDescendingText();

  /**
   * Translated "Unfreeze $title".
   * 
   * @return translated "Unfreeze $title"
   */
  @DefaultMessage("Unfreeze $title")
  @Key("listGrid_unfreezeFieldText")
  String listGrid_unfreezeFieldText();

  /**
   * Translated "Ungroup".
   * 
   * @return translated "Ungroup"
   */
  @DefaultMessage("Ungroup")
  @Key("listGrid_ungroupText")
  String listGrid_ungroupText();

  /* listGrid_asynchGroupingPrompt value changed on Wed Jan  5 07:19:28 2022
   Old value was 'Grouping data...'.
   See definition later in this file for new value.
  */

  /**
   * Translated "Replace value with".
   * 
   * @return translated "Replace value with"
   */
  @DefaultMessage("Replace value with")
  @Key("listGrid_hiliteReplaceValueFieldTitle")
  String listGrid_hiliteReplaceValueFieldTitle();

  /**
   * Translated "Filter".
   * 
   * @return translated "Filter"
   */
  @DefaultMessage("Filter")
  @Key("listGrid_filterButtonPrompt")
  String listGrid_filterButtonPrompt();

  /**
   * Translated "Are you sure you want to delete this record?".
   * 
   * @return translated "Are you sure you want to delete this record?"
   */
  @DefaultMessage("Are you sure you want to delete this record?")
  @Key("listGrid_warnOnRemovalMessage")
  String listGrid_warnOnRemovalMessage();

  /**
   * Translated "corner button".
   * 
   * @return translated "corner button"
   */
  @DefaultMessage("corner button")
  @Key("listGrid_sorterButtonTitle")
  String listGrid_sorterButtonTitle();

  /**
   * Translated "You have unsaved changes - do you want to save them now?".
   * 
   * @return translated "You have unsaved changes - do you want to save them now?"
   */
  @DefaultMessage("You have unsaved changes - do you want to save them now?")
  @Key("listGrid_expansionEditorSaveDialogPrompt")
  String listGrid_expansionEditorSaveDialogPrompt();

  /**
   * Translated "Save".
   * 
   * @return translated "Save"
   */
  @DefaultMessage("Save")
  @Key("listGrid_expansionEditorSaveButtonTitle")
  String listGrid_expansionEditorSaveButtonTitle();

  /**
   * Translated " - ".
   * 
   * @return translated " - "
   */
  @DefaultMessage(" - ")
  @Key("listGrid_formulaBuilderSpanTitleSeparator")
  String listGrid_formulaBuilderSpanTitleSeparator();

  /**
   * Translated " - ".
   * 
   * @return translated " - "
   */
  @DefaultMessage(" - ")
  @Key("listGrid_sortEditorSpanTitleSeparator")
  String listGrid_sortEditorSpanTitleSeparator();

  /**
   * Translated " - ".
   * 
   * @return translated " - "
   */
  @DefaultMessage(" - ")
  @Key("listGrid_hiliteEditorSpanTitleSeparator")
  String listGrid_hiliteEditorSpanTitleSeparator();

  /**
   * Translated "Custom...".
   * 
   * @return translated "Custom..."
   */
  @DefaultMessage("Custom...")
  @Key("presetCriteriaItem_customOptionTitle")
  String presetCriteriaItem_customOptionTitle();

  /**
   * Translated "Show Menu".
   * 
   * @return translated "Show Menu"
   */
  @DefaultMessage("Show Menu")
  @Key("menuButton_title")
  String menuButton_title();

  /**
   * Translated "Choose a value".
   * 
   * @return translated "Choose a value"
   */
  @DefaultMessage("Choose a value")
  @Key("treeMenuButton_unselectedTitle")
  String treeMenuButton_unselectedTitle();

  /**
   * Translated "Since".
   * 
   * @return translated "Since"
   */
  @DefaultMessage("Since")
  @Key("miniDateRangeItem_fromDateOnlyPrefix")
  String miniDateRangeItem_fromDateOnlyPrefix();

  /**
   * Translated "Show Date Chooser".
   * 
   * @return translated "Show Date Chooser"
   */
  @DefaultMessage("Show Date Chooser")
  @Key("miniDateRangeItem_pickerIconPrompt")
  String miniDateRangeItem_pickerIconPrompt();

  /**
   * Translated "Before".
   * 
   * @return translated "Before"
   */
  @DefaultMessage("Before")
  @Key("miniDateRangeItem_toDateOnlyPrefix")
  String miniDateRangeItem_toDateOnlyPrefix();

  /**
   * Translated "Enter values".
   * 
   * @return translated "Enter values"
   */
  @DefaultMessage("Enter values")
  @Key("multiComboBoxItem_defaultHint")
  String multiComboBoxItem_defaultHint();

  /**
   * Translated "Click icon to add...".
   * 
   * @return translated "Click icon to add..."
   */
  @DefaultMessage("Click icon to add...")
  @Key("multiFileItem_emptyMessage")
  String multiFileItem_emptyMessage();

  /**
   * Translated "Add files".
   * 
   * @return translated "Add files"
   */
  @DefaultMessage("Add files")
  @Key("multiFileItem_editButtonPrompt")
  String multiFileItem_editButtonPrompt();

  /**
   * Translated "Remove selected files".
   * 
   * @return translated "Remove selected files"
   */
  @DefaultMessage("Remove selected files")
  @Key("multiFileItem_removeButtonPrompt")
  String multiFileItem_removeButtonPrompt();

  /**
   * Translated "OK".
   * 
   * @return translated "OK"
   */
  @DefaultMessage("OK")
  @Key("multiFileItem_pickerUploadButtonInitialTitle")
  String multiFileItem_pickerUploadButtonInitialTitle();

  /**
   * Translated "Save".
   * 
   * @return translated "Save"
   */
  @DefaultMessage("Save")
  @Key("multiFileItem_pickerUploadButtonTitle")
  String multiFileItem_pickerUploadButtonTitle();

  /**
   * Translated "Cancel".
   * 
   * @return translated "Cancel"
   */
  @DefaultMessage("Cancel")
  @Key("multiFileItem_pickerCancelButtonTitle")
  String multiFileItem_pickerCancelButtonTitle();

  /**
   * Translated "<u>Add&nbsp;another</u>".
   * 
   * @return translated "<u>Add&nbsp;another</u>"
   */
  @DefaultMessage("<u>Add&nbsp;another</u>")
  @Key("multiFileItem_pickerAddAnotherFileButtonTitle")
  String multiFileItem_pickerAddAnotherFileButtonTitle();

  /**
   * Translated "Saving $fileName $formattedFileSize".
   * 
   * @return translated "Saving fileName $formattedFileSize"
   */
  @DefaultMessage("Saving $fileName $formattedFileSize")
  @Key("multiFileItem_pickerUploadProgressLabel")
  String multiFileItem_pickerUploadProgressLabel();

  /**
   * Translated "Add Level".
   * 
   * @return translated "Add Level"
   */
  @DefaultMessage("Add Level")
  @Key("multiSortDialog_addLevelButtonTitle")
  String multiSortDialog_addLevelButtonTitle();

  /**
   * Translated "Apply".
   * 
   * @return translated "Apply"
   */
  @DefaultMessage("Apply")
  @Key("multiSortDialog_applyButtonTitle")
  String multiSortDialog_applyButtonTitle();

  /**
   * Translated "Ascending".
   * 
   * @return translated "Ascending"
   */
  @DefaultMessage("Ascending")
  @Key("multiSortDialog_ascendingTitle")
  String multiSortDialog_ascendingTitle();

  /**
   * Translated "Cancel".
   * 
   * @return translated "Cancel"
   */
  @DefaultMessage("Cancel")
  @Key("multiSortDialog_cancelButtonTitle")
  String multiSortDialog_cancelButtonTitle();

  /**
   * Translated "Copy Level".
   * 
   * @return translated "Copy Level"
   */
  @DefaultMessage("Copy Level")
  @Key("multiSortDialog_copyLevelButtonTitle")
  String multiSortDialog_copyLevelButtonTitle();

  /**
   * Translated "Delete Level".
   * 
   * @return translated "Delete Level"
   */
  @DefaultMessage("Delete Level")
  @Key("multiSortDialog_deleteLevelButtonTitle")
  String multiSortDialog_deleteLevelButtonTitle();

  /**
   * Translated "Descending".
   * 
   * @return translated "Descending"
   */
  @DefaultMessage("Descending")
  @Key("multiSortDialog_descendingTitle")
  String multiSortDialog_descendingTitle();

  /**
   * Translated "Order".
   * 
   * @return translated "Order"
   */
  @DefaultMessage("Order")
  @Key("multiSortDialog_directionFieldTitle")
  String multiSortDialog_directionFieldTitle();

  /**
   * Translated "Sort by".
   * 
   * @return translated "Sort by"
   */
  @DefaultMessage("Sort by")
  @Key("multiSortDialog_firstSortLevelTitle")
  String multiSortDialog_firstSortLevelTitle();

  /**
   * Translated "Columns may only be used once: ''$title'' is used multiple times.".
   * 
   * @return translated "Columns may only be used once: ''$title'' is used multiple times."
   */
  @DefaultMessage("Columns may only be used once: ''$title'' is used multiple times.")
  @Key("multiSortDialog_invalidListPrompt")
  String multiSortDialog_invalidListPrompt();

  /**
   * Translated "Move Level Down".
   * 
   * @return translated "Move Level Down"
   */
  @DefaultMessage("Move Level Down")
  @Key("multiSortDialog_levelDownPrompt")
  String multiSortDialog_levelDownPrompt();

  /**
   * Translated "Move Level Up".
   * 
   * @return translated "Move Level Up"
   */
  @DefaultMessage("Move Level Up")
  @Key("multiSortDialog_levelUpPrompt")
  String multiSortDialog_levelUpPrompt();

  /**
   * Translated "Then by".
   * 
   * @return translated "Then by"
   */
  @DefaultMessage("Then by")
  @Key("multiSortDialog_otherSortLevelTitle")
  String multiSortDialog_otherSortLevelTitle();

  /**
   * Translated "Column".
   * 
   * @return translated "Column"
   */
  @DefaultMessage("Column")
  @Key("multiSortDialog_propertyFieldTitle")
  String multiSortDialog_propertyFieldTitle();

  /**
   * Translated "Sort".
   * 
   * @return translated "Sort"
   */
  @DefaultMessage("Sort")
  @Key("multiSortDialog_title")
  String multiSortDialog_title();

  /**
   * Translated "Add Level".
   * 
   * @return translated "Add Level"
   */
  @DefaultMessage("Add Level")
  @Key("multiGroupDialog_addLevelButtonTitle")
  String multiGroupDialog_addLevelButtonTitle();

  /**
   * Translated "Apply".
   * 
   * @return translated "Apply"
   */
  @DefaultMessage("Apply")
  @Key("multiGroupDialog_applyButtonTitle")
  String multiGroupDialog_applyButtonTitle();

  /**
   * Translated "Cancel".
   * 
   * @return translated "Cancel"
   */
  @DefaultMessage("Cancel")
  @Key("multiGroupDialog_cancelButtonTitle")
  String multiGroupDialog_cancelButtonTitle();

  /**
   * Translated "Copy Level".
   * 
   * @return translated "Copy Level"
   */
  @DefaultMessage("Copy Level")
  @Key("multiGroupDialog_copyLevelButtonTitle")
  String multiGroupDialog_copyLevelButtonTitle();

  /**
   * Translated "Delete Level".
   * 
   * @return translated "Delete Level"
   */
  @DefaultMessage("Delete Level")
  @Key("multiGroupDialog_deleteLevelButtonTitle")
  String multiGroupDialog_deleteLevelButtonTitle();

  /**
   * Translated "Grouping".
   * 
   * @return translated "Grouping"
   */
  @DefaultMessage("Grouping")
  @Key("multiGroupDialog_groupingFieldTitle")
  String multiGroupDialog_groupingFieldTitle();

  /**
   * Translated "Columns may only be used once: ''$title'' is used multiple times.".
   * 
   * @return translated "Columns may only be used once: ''$title'' is used multiple times."
   */
  @DefaultMessage("Columns may only be used once: ''$title'' is used multiple times.")
  @Key("multiGroupDialog_invalidListPrompt")
  String multiGroupDialog_invalidListPrompt();

  /**
   * Translated "Move Level Down".
   * 
   * @return translated "Move Level Down"
   */
  @DefaultMessage("Move Level Down")
  @Key("multiGroupDialog_levelDownPrompt")
  String multiGroupDialog_levelDownPrompt();

  /**
   * Translated "Move Level Up".
   * 
   * @return translated "Move Level Up"
   */
  @DefaultMessage("Move Level Up")
  @Key("multiGroupDialog_levelUpPrompt")
  String multiGroupDialog_levelUpPrompt();

  /**
   * Translated "Column".
   * 
   * @return translated "Column"
   */
  @DefaultMessage("Column")
  @Key("multiGroupDialog_propertyFieldTitle")
  String multiGroupDialog_propertyFieldTitle();

  /**
   * Translated "Group".
   * 
   * @return translated "Group"
   */
  @DefaultMessage("Group")
  @Key("multiGroupDialog_title")
  String multiGroupDialog_title();

  /**
   * Translated "Group by".
   * 
   * @return translated "Group by"
   */
  @DefaultMessage("Group by")
  @Key("multiGroupDialog_firstGroupLevelTitle")
  String multiGroupDialog_firstGroupLevelTitle();

  /**
   * Translated "Then by".
   * 
   * @return translated "Then by"
   */
  @DefaultMessage("Then by")
  @Key("multiGroupDialog_otherGroupLevelTitle")
  String multiGroupDialog_otherGroupLevelTitle();
  
  /**
   * Translated "Match All".
   * 
   * @return translated "Match All"
   */
  @DefaultMessage("Match All")
  @Key("operators_andTitle")
  String operators_andTitle();

  /**
   * Translated "between (inclusive, match case)".
   * 
   * @return translated "between (inclusive, match case)"
   */
  @DefaultMessage("between (inclusive, match case)")
  @Key("operators_betweenInclusiveTitle")
  String operators_betweenInclusiveTitle();

  /**
   * Translated "between (match case)".
   * 
   * @return translated "between (match case)"
   */
  @DefaultMessage("between (match case)")
  @Key("operators_betweenTitle")
  String operators_betweenTitle();

  /**
   * Translated "between (inclusive)".
   * 
   * @return translated "between (inclusive)"
   */
  @DefaultMessage("between (inclusive)")
  @Key("operators_iBetweenInclusiveTitle")
  String operators_iBetweenInclusiveTitle();

  /**
   * Translated "between".
   * 
   * @return translated "between"
   */
  @DefaultMessage("between")
  @Key("operators_iBetweenTitle")
  String operators_iBetweenTitle();

  /**
   * Translated "contains another field value (match case)".
   * 
   * @return translated "contains another field value (match case)"
   */
  @DefaultMessage("contains another field value (match case)")
  @Key("operators_containsFieldTitle")
  String operators_containsFieldTitle();

  /**
   * Translated "contains (match case)".
   * 
   * @return translated "contains (match case)"
   */
  @DefaultMessage("contains (match case)")
  @Key("operators_containsTitle")
  String operators_containsTitle();

  /**
   * Translated "ends with another field value (match case)".
   * 
   * @return translated "ends with another field value (match case)"
   */
  @DefaultMessage("ends with another field value (match case)")
  @Key("operators_endsWithFieldTitle")
  String operators_endsWithFieldTitle();

  /**
   * Translated "ends with (match case)".
   * 
   * @return translated "ends with (match case)"
   */
  @DefaultMessage("ends with (match case)")
  @Key("operators_endsWithTitle")
  String operators_endsWithTitle();

  /**
   * Translated "matches other field".
   * 
   * @return translated "matches other field"
   */
  @DefaultMessage("matches other field")
  @Key("operators_equalsFieldTitle")
  String operators_equalsFieldTitle();

  /**
   * Translated "equals".
   * 
   * @return translated "equals"
   */
  @DefaultMessage("equals")
  @Key("operators_equalsTitle")
  String operators_equalsTitle();

  /**
   * Translated "greater than or equal to field".
   * 
   * @return translated "greater than or equal to field"
   */
  @DefaultMessage("greater than or equal to field")
  @Key("operators_greaterOrEqualFieldTitle")
  String operators_greaterOrEqualFieldTitle();

  /**
   * Translated "greater than or equal to".
   * 
   * @return translated "greater than or equal to"
   */
  @DefaultMessage("greater than or equal to")
  @Key("operators_greaterOrEqualTitle")
  String operators_greaterOrEqualTitle();

  /**
   * Translated "greater than field".
   * 
   * @return translated "greater than field"
   */
  @DefaultMessage("greater than field")
  @Key("operators_greaterThanFieldTitle")
  String operators_greaterThanFieldTitle();

  /**
   * Translated "greater than".
   * 
   * @return translated "greater than"
   */
  @DefaultMessage("greater than")
  @Key("operators_greaterThanTitle")
  String operators_greaterThanTitle();

  /**
   * Translated "contains".
   * 
   * @return translated "contains"
   */
  @DefaultMessage("contains")
  @Key("operators_iContainsTitle")
  String operators_iContainsTitle();

  /**
   * Translated "ends with".
   * 
   * @return translated "ends with"
   */
  @DefaultMessage("ends with")
  @Key("operators_iEndsWithTitle")
  String operators_iEndsWithTitle();

  /**
   * Translated "equals (disregard case)".
   * 
   * @return translated "equals (disregard case)"
   */
  @DefaultMessage("equals (disregard case)")
  @Key("operators_iEqualsTitle")
  String operators_iEqualsTitle();

  /**
   * Translated "matches pattern".
   *
   * @return translated "matches pattern"
   */
  @DefaultMessage("matches pattern")
  @Key("operators_iMatchesPatternTitle")
  String operators_iMatchesPatternTitle();

  /**
   * Translated "does not contain".
   * 
   * @return translated "does not contain"
   */
  @DefaultMessage("does not contain")
  @Key("operators_iNotContainsTitle")
  String operators_iNotContainsTitle();

  /**
   * Translated "does not end with".
   * 
   * @return translated "does not end with"
   */
  @DefaultMessage("does not end with")
  @Key("operators_iNotEndsWithTitle")
  String operators_iNotEndsWithTitle();

  /**
   * Translated "not equal (disregard case)".
   * 
   * @return translated "not equal (disregard case)"
   */
  @DefaultMessage("not equal (disregard case)")
  @Key("operators_iNotEqualTitle")
  String operators_iNotEqualTitle();

  /**
   * Translated "does not start with".
   * 
   * @return translated "does not start with"
   */
  @DefaultMessage("does not start with")
  @Key("operators_iNotStartsWithTitle")
  String operators_iNotStartsWithTitle();

  /**
   * Translated "starts with".
   * 
   * @return translated "starts with"
   */
  @DefaultMessage("starts with")
  @Key("operators_iStartsWithTitle")
  String operators_iStartsWithTitle();

  /**
   * Translated "is one of".
   * 
   * @return translated "is one of"
   */
  @DefaultMessage("is one of")
  @Key("operators_inSetTitle")
  String operators_inSetTitle();

  /**
   * Translated "matches expression".
   *
   * @return translated "matches expression"
   */
  @DefaultMessage("matches expression")
  @Key("operators_iregexpTitle")
  String operators_iregexpTitle();

  /**
   * Translated "is null".
   * 
   * @return translated "is null"
   */
  @DefaultMessage("is null")
  @Key("operators_isNullTitle")
  String operators_isNullTitle();

  /**
   * Translated "is blank".
   * 
   * @return translated "is blank"
   */
  @DefaultMessage("is blank")
  @Key("operators_isBlankTitle")
  String operators_isBlankTitle();
  
  /**
   * Translated "less than or equal to field".
   * 
   * @return translated "less than or equal to field"
   */
  @DefaultMessage("less than or equal to field")
  @Key("operators_lessOrEqualFieldTitle")
  String operators_lessOrEqualFieldTitle();

  /**
   * Translated "less than or equal to".
   * 
   * @return translated "less than or equal to"
   */
  @DefaultMessage("less than or equal to")
  @Key("operators_lessOrEqualTitle")
  String operators_lessOrEqualTitle();

  /**
   * Translated "less than field".
   * 
   * @return translated "less than field"
   */
  @DefaultMessage("less than field")
  @Key("operators_lessThanFieldTitle")
  String operators_lessThanFieldTitle();

  /**
   * Translated "less than".
   * 
   * @return translated "less than"
   */
  @DefaultMessage("less than")
  @Key("operators_lessThanTitle")
  String operators_lessThanTitle();

  /**
   * Translated "matches pattern (match case)".
   *
   * @return translated "matches pattern (match case)"
   */
  @DefaultMessage("matches pattern (match case)")
  @Key("operators_matchesPatternTitle")
  String operators_matchesPatternTitle();

  /**
   * Translated "does not contain (match case)".
   * 
   * @return translated "does not contain (match case)"
   */
  @DefaultMessage("does not contain (match case)")
  @Key("operators_notContainsTitle")
  String operators_notContainsTitle();

  /**
   * Translated "does not end with (match case)".
   * 
   * @return translated "does not end with (match case)"
   */
  @DefaultMessage("does not end with (match case)")
  @Key("operators_notEndsWithTitle")
  String operators_notEndsWithTitle();

  /**
   * Translated "differs from field".
   * 
   * @return translated "differs from field"
   */
  @DefaultMessage("differs from field")
  @Key("operators_notEqualFieldTitle")
  String operators_notEqualFieldTitle();

  /**
   * Translated "not equal".
   * 
   * @return translated "not equal"
   */
  @DefaultMessage("not equal")
  @Key("operators_notEqualTitle")
  String operators_notEqualTitle();

  /**
   * Translated "is not one of".
   * 
   * @return translated "is not one of"
   */
  @DefaultMessage("is not one of")
  @Key("operators_notInSetTitle")
  String operators_notInSetTitle();

  /**
   * Translated "is not null".
   * 
   * @return translated "is not null"
   */
  @DefaultMessage("is not null")
  @Key("operators_notNullTitle")
  String operators_notNullTitle();

  /**
   * Translated "is not blank".
   * 
   * @return translated "is not blank"
   */
  @DefaultMessage("is not blank")
  @Key("operators_notBlankTitle")
  String operators_notBlankTitle();

  /**
   * Translated "does not start with (match case)".
   * 
   * @return translated "does not start with (match case)"
   */
  @DefaultMessage("does not start with (match case)")
  @Key("operators_notStartsWithTitle")
  String operators_notStartsWithTitle();

  /**
   * Translated "Match None".
   * 
   * @return translated "Match None"
   */
  @DefaultMessage("Match None")
  @Key("operators_notTitle")
  String operators_notTitle();

  /**
   * Translated "Match Any".
   * 
   * @return translated "Match Any"
   */
  @DefaultMessage("Match Any")
  @Key("operators_orTitle")
  String operators_orTitle();

  /**
   * Translated "matches expression (match case)".
   * 
   * @return translated "matches expression (match case)"
   */
  @DefaultMessage("matches expression (match case)")
  @Key("operators_regexpTitle")
  String operators_regexpTitle();

  /**
   * Translated "starts with another field value (match case)".
   * 
   * @return translated "starts with another field value (match case)"
   */
  @DefaultMessage("starts with another field value (match case)")
  @Key("operators_startsWithFieldTitle")
  String operators_startsWithFieldTitle();

  /**
   * Translated "starts with (match case)".
   * 
   * @return translated "starts with (match case)"
   */
  @DefaultMessage("starts with (match case)")
  @Key("operators_startsWithTitle")
  String operators_startsWithTitle();

  

  /**
   * Translated "matches other field".
   * 
   * @return translated "matches other field"
   */
  @DefaultMessage("matches other field")
  @Key("operators_iEqualsFieldTitle")
  String operators_iEqualsFieldTitle();
  
  /**
   * Translated "differs from field".
   * 
   * @return translated "differs from field"
   */
  @DefaultMessage("differs from field")
  @Key("operators_iNotEqualFieldTitle")
  String operators_iNotEqualFieldTitle();
  
  /**
   * Translated "contains another field value".
   * 
   * @return translated "contains another field value"
   */
  @DefaultMessage("contains another field value")
  @Key("operators_iContainsFieldTitle")
  String operators_iContainsFieldTitle();
  
  /**
   * Translated "starts with another field value".
   * 
   * @return translated "starts with another field value"
   */
  @DefaultMessage("starts with another field value")
  @Key("operators_iStartsWithFieldTitle")
  String operators_iStartsWithFieldTitle();

  /**
   * Translated "ends with another field value".
   * 
   * @return translated "ends with another field value"
   */
  @DefaultMessage("ends with another field value")
  @Key("operators_iEndsWithFieldTitle")
  String operators_iEndsWithFieldTitle();

  /**
   * Translated "does not contain another field value".
   * 
   * @return translated "does not contain another field value"
   */
  @DefaultMessage("does not contain another field value (match case)")
  @Key("operators_notContainsFieldTitle")
  String operators_notContainsFieldTitle();

  /**
   * Translated "does not start with another field value (match case)".
   * 
   * @return translated "does not start with another field value (match case)"
   */
  @DefaultMessage("does not start with another field value (match case)")
  @Key("operators_notStartsWithFieldTitle")
  String operators_notStartsWithFieldTitle();

  /**
   * Translated "does not end with another field value (match case)".
   * 
   * @return translated "does not end with another field value (match case)"
   */
  @DefaultMessage("does not end with another field value (match case)")
  @Key("operators_notEndsWithFieldTitle")
  String operators_notEndsWithFieldTitle();

  /**
   * Translated "does not contain another field value".
   * 
   * @return translated "does not contain another field value"
   */
  @DefaultMessage("does not contain another field value")
  @Key("operators_iNotContainsFieldTitle")
  String operators_iNotContainsFieldTitle();

  /**
   * Translated "does not start with another field value".
   * 
   * @return translated "does not start with another field value"
   */
  @DefaultMessage("does not start with another field value")
  @Key("operators_iNotStartsWithFieldTitle")
  String operators_iNotStartsWithFieldTitle();

  /**
   * Translated "does not end with another field value".
   * 
   * @return translated "does not end with another field value"
   */
  @DefaultMessage("does not end with another field value")
  @Key("operators_iNotEndsWithFieldTitle")
  String operators_iNotEndsWithFieldTitle();

  /**
   * Translated "contains pattern (match case)".
   * 
   * @return translated "contains pattern (match case)"
   */
  @DefaultMessage("contains pattern (match case)")
  @Key("operators_containsPatternTitle")
  String operators_containsPatternTitle();
  
  /**
   * Translated "contains pattern".
   * 
   * @return translated "contains pattern"
   */
  @DefaultMessage("contains pattern")
  @Key("operators_iContainsPatternTitle")
  String operators_iContainsPatternTitle();
  
  /**
   * Translated "starts with pattern (match case)".
   * 
   * @return translated "starts with pattern (match case)"
   */
  @DefaultMessage("starts with pattern (match case)")
  @Key("operators_startsWithPatternTitle")
  String operators_startsWithPatternTitle();
  
  /**
   * Translated "starts with pattern".
   * 
   * @return translated "starts with pattern"
   */
  @DefaultMessage("starts with pattern")
  @Key("operators_iStartsWithPatternTitle")
  String operators_iStartsWithPatternTitle();

   /**
   * Translated "ends with pattern (match case)".
   * 
   * @return translated "ends with pattern (match case)"
   */
  @DefaultMessage("ends with pattern (match case)")
  @Key("operators_endsWithPatternTitle")
  String operators_endsWithPatternTitle();
  
  /**
   * Translated "ends with pattern".
   * 
   * @return translated "ends with pattern"
   */
  @DefaultMessage("ends with pattern")
  @Key("operators_iEndsWithPatternTitle")
  String operators_iEndsWithPatternTitle();
  
  /* operators_valueRangeUsageHint value changed on Wed Jan  5 07:08:46 2022
   Old value was 'Range-operators require distinct start and end values, separated by the range (between) symbol, \'...\'.'.
   See definition later in this file for new value.
*/  
  /* operators_valueSetUsageHint value changed on Wed Jan  5 07:08:46 2022
   Old value was 'Multiple values must be separated by the valueSeparator, \'|\'.'.
   See definition later in this file for new value.
*/  
  /**
   * Translated "No Items To Show".
   * 
   * @return translated "No Items To Show"
   */
  @DefaultMessage("No Items To Show")
  @Key("pickListMenu_emptyMessage")
  String pickListMenu_emptyMessage();
  
  /**
   * Translated "No items to show".
   * 
   * @return translated "No items to show"
   */
  @DefaultMessage("No items to show")
  @Key("pickList_emptyPickListMessage")
  String pickList_emptyPickListMessage();

  /**
   * Translated "No items to show".
   * 
   * @return translated "No items to show"
   */
  @DefaultMessage("No items to show")
  @Key("selectItem_emptyPickListMessage")
  String selectItem_emptyPickListMessage();

  /**
   * Translated "Done".
   * 
   * @return translated "Done"
   */
  @DefaultMessage("Done")
  @Key("selectItem_pickerExitButtonTitle")
  String selectItem_pickerExitButtonTitle();

  /**
   * Translated "Clear".
   * 
   * @return translated "Clear"
   */
  @DefaultMessage("Clear")
  @Key("selectItem_pickerClearButtonTitle")
  String selectItem_pickerClearButtonTitle();

  /**
   * Translated "No items to show".
   * 
   * @return translated "No items to show"
   */
  @DefaultMessage("No items to show")
  @Key("comboBoxItem_emptyPickListMessage")
  String comboBoxItem_emptyPickListMessage();

  /**
   * Translated "Search or enter new value".
   * 
   * @return translated "Search or enter new value"
   */
  @DefaultMessage("Search or enter new value")
  @Key("comboBoxItem_pickerSearchOrNewValueFieldHint")
  String comboBoxItem_pickerSearchOrNewValueFieldHint();
  
  /**
   * Translated "Search".
   * 
   * @return translated "Search"
   */
  @DefaultMessage("Search")
  @Key("comboBoxItem_pickerSearchFieldHint")
  String comboBoxItem_pickerSearchFieldHint();

  /**
   * Translated "Cancel".
   * 
   * @return translated "Cancel"
   */
  @DefaultMessage("Cancel")
  @Key("comboBoxItem_pickerExitButtonTitle")
  String comboBoxItem_pickerExitButtonTitle();

  /**
   * Translated "Accept".
   * 
   * @return translated "Accept"
   */
  @DefaultMessage("Accept")
  @Key("comboBoxItem_pickerSaveButtonTitle")
  String comboBoxItem_pickerSaveButtonTitle();

  /**
   * Translated "Clear".
   * 
   * @return translated "Clear"
   */
  @DefaultMessage("Clear")
  @Key("comboBoxItem_pickerClearButtonTitle")
  String comboBoxItem_pickerClearButtonTitle();

  /**
   * Translated "Enter a longer search string to search".
   * 
   * @return translated "Enter a longer search string to search"
   */
  @DefaultMessage("Enter a longer search string to search")
  @Key("comboBoxItem_searchStringTooShortMessage")
  String comboBoxItem_searchStringTooShortMessage();
  
  /**
   * Translated "[Empty menu]".
   * 
   * @return translated "[Empty menu]"
   */
  @DefaultMessage("[Empty menu]")
  @Key("menu_emptyMessage")
  String menu_emptyMessage();

  /**
   * Translated "Done".
   * 
   * @return translated "Done"
   */
  @DefaultMessage("Done")
  @Key("menu_cancelButtonTitle")
  String menu_cancelButtonTitle();

  /**
   * Translated "No items to display".
   * 
   * @return translated "No items to display"
   */
  @DefaultMessage("No items to display")
  @Key("pickTreeItem_emptyMenuMessage")
  String pickTreeItem_emptyMenuMessage();

  /**
   * Translated "Print".
   * 
   * @return translated "Print"
   */
  @DefaultMessage("Print")
  @Key("printWindow_printButtonTitle")
  String printWindow_printButtonTitle();

  /**
   * Translated "Print Preview".
   * 
   * @return translated "Print Preview"
   */
  @DefaultMessage("Print Preview")
  @Key("printWindow_title")
  String printWindow_title();

  /**
   * Translated "N days ago".
   * 
   * @return translated "N days ago"
   */
  @DefaultMessage("N days ago")
  @Key("relativeDateItem_daysAgoTitle")
  String relativeDateItem_daysAgoTitle();

  /**
   * Translated "N days from now".
   * 
   * @return translated "N days from now"
   */
  @DefaultMessage("N days from now")
  @Key("relativeDateItem_daysFromNowTitle")
  String relativeDateItem_daysFromNowTitle();

  /**
   * Translated "N hours ago".
   * 
   * @return translated "N hours ago"
   */
  @DefaultMessage("N hours ago")
  @Key("relativeDateItem_hoursAgoTitle")
  String relativeDateItem_hoursAgoTitle();

  /**
   * Translated "N hours from now".
   * 
   * @return translated "N hours from now"
   */
  @DefaultMessage("N hours from now")
  @Key("relativeDateItem_hoursFromNowTitle")
  String relativeDateItem_hoursFromNowTitle();

  /**
   * Translated "N milliseconds ago".
   * 
   * @return translated "N milliseconds ago"
   */
  @DefaultMessage("N milliseconds ago")
  @Key("relativeDateItem_millisecondsAgoTitle")
  String relativeDateItem_millisecondsAgoTitle();

  /**
   * Translated "N milliseconds from now".
   * 
   * @return translated "N milliseconds from now"
   */
  @DefaultMessage("N milliseconds from now")
  @Key("relativeDateItem_millisecondsFromNowTitle")
  String relativeDateItem_millisecondsFromNowTitle();

  /**
   * Translated "N minutes ago".
   * 
   * @return translated "N minutes ago"
   */
  @DefaultMessage("N minutes ago")
  @Key("relativeDateItem_minutesAgoTitle")
  String relativeDateItem_minutesAgoTitle();

  /**
   * Translated "N minutes from now".
   * 
   * @return translated "N minutes from now"
   */
  @DefaultMessage("N minutes from now")
  @Key("relativeDateItem_minutesFromNowTitle")
  String relativeDateItem_minutesFromNowTitle();

  /**
   * Translated "N months ago".
   * 
   * @return translated "N months ago"
   */
  @DefaultMessage("N months ago")
  @Key("relativeDateItem_monthsAgoTitle")
  String relativeDateItem_monthsAgoTitle();

  /**
   * Translated "N months from now".
   * 
   * @return translated "N months from now"
   */
  @DefaultMessage("N months from now")
  @Key("relativeDateItem_monthsFromNowTitle")
  String relativeDateItem_monthsFromNowTitle();

  /**
   * Translated "N quarters ago".
   * 
   * @return translated "N quarters ago"
   */
  @DefaultMessage("N quarters ago")
  @Key("relativeDateItem_quartersAgoTitle")
  String relativeDateItem_quartersAgoTitle();

  /**
   * Translated "N quarters from now".
   * 
   * @return translated "N quarters from now"
   */
  @DefaultMessage("N quarters from now")
  @Key("relativeDateItem_quartersFromNowTitle")
  String relativeDateItem_quartersFromNowTitle();

  /**
   * Translated "Show Date Chooser".
   * 
   * @return translated "Show Date Chooser"
   */
  @DefaultMessage("Show Date Chooser")
  @Key("relativeDateItem_pickerIconPrompt")
  String relativeDateItem_pickerIconPrompt();

  /**
   * Translated "Current day of last month".
   * 
   * @return translated "Current day of last month"
   */
  @DefaultMessage("Current day of last month")
  @Key("relativeDateItem_presetOptions_minus_1m")
  String relativeDateItem_presetOptions_minus_1m();

  /**
   * Translated "Current day of last week".
   * 
   * @return translated "Current day of last week"
   */
  @DefaultMessage("Current day of last week")
  @Key("relativeDateItem_presetOptions_minus_1w")
  String relativeDateItem_presetOptions_minus_1w();

  /**
   * Translated "Current day of next month".
   * 
   * @return translated "Current day of next month"
   */
  @DefaultMessage("Current day of next month")
  @Key("relativeDateItem_presetOptions_plus_1m")
  String relativeDateItem_presetOptions_plus_1m();

  /**
   * Translated "Current day of next week".
   * 
   * @return translated "Current day of next week"
   */
  @DefaultMessage("Current day of next week")
  @Key("relativeDateItem_presetOptions_plus_1w")
  String relativeDateItem_presetOptions_plus_1w();

  /**
   * Translated "Today".
   * 
   * @return translated "Today"
   */
  @DefaultMessage("Today")
  @Key("relativeDateItem_presetOptions_today")
  String relativeDateItem_presetOptions_today();

  /**
   * Translated "Tomorrow".
   * 
   * @return translated "Tomorrow"
   */
  @DefaultMessage("Tomorrow")
  @Key("relativeDateItem_presetOptions_tomorrow")
  String relativeDateItem_presetOptions_tomorrow();

  /**
   * Translated "Yesterday".
   * 
   * @return translated "Yesterday"
   */
  @DefaultMessage("Yesterday")
  @Key("relativeDateItem_presetOptions_yesterday")
  String relativeDateItem_presetOptions_yesterday();

  /**
   * Translated "N seconds ago".
   * 
   * @return translated "N seconds ago"
   */
  @DefaultMessage("N seconds ago")
  @Key("relativeDateItem_secondsAgoTitle")
  String relativeDateItem_secondsAgoTitle();

  /**
   * Translated "N seconds from now".
   * 
   * @return translated "N seconds from now"
   */
  @DefaultMessage("N seconds from now")
  @Key("relativeDateItem_secondsFromNowTitle")
  String relativeDateItem_secondsFromNowTitle();

  /**
   * Translated "Today".
   * 
   * @return translated "Today"
   */
  @DefaultMessage("Today")
  @Key("relativeDateItem_todayTitle")
  String relativeDateItem_todayTitle();

  /**
   * Translated "N weeks ago".
   * 
   * @return translated "N weeks ago"
   */
  @DefaultMessage("N weeks ago")
  @Key("relativeDateItem_weeksAgoTitle")
  String relativeDateItem_weeksAgoTitle();

  /**
   * Translated "N weeks from now".
   * 
   * @return translated "N weeks from now"
   */
  @DefaultMessage("N weeks from now")
  @Key("relativeDateItem_weeksFromNowTitle")
  String relativeDateItem_weeksFromNowTitle();

  /**
   * Translated "N years ago".
   * 
   * @return translated "N years ago"
   */
  @DefaultMessage("N years ago")
  @Key("relativeDateItem_yearsAgoTitle")
  String relativeDateItem_yearsAgoTitle();

  /**
   * Translated "N years from now".
   * 
   * @return translated "N years from now"
   */
  @DefaultMessage("N years from now")
  @Key("relativeDateItem_yearsFromNowTitle")
  String relativeDateItem_yearsFromNowTitle();

  /**
   * Translated "Center selection".
   * 
   * @return translated "Center selection"
   */
  @DefaultMessage("Center selection")
  @Key("richTextEditor_alignCenterPrompt")
  String richTextEditor_alignCenterPrompt();

  /**
   * Translated "Left align selection".
   * 
   * @return translated "Left align selection"
   */
  @DefaultMessage("Left align selection")
  @Key("richTextEditor_alignLeftPrompt")
  String richTextEditor_alignLeftPrompt();

  /**
   * Translated "Right align selection".
   * 
   * @return translated "Right align selection"
   */
  @DefaultMessage("Right align selection")
  @Key("richTextEditor_alignRightPrompt")
  String richTextEditor_alignRightPrompt();

  /**
   * Translated "Set selection background color".
   * 
   * @return translated "Set selection background color"
   */
  @DefaultMessage("Set selection background color")
  @Key("richTextEditor_backgroundColorPrompt")
  String richTextEditor_backgroundColorPrompt();

  /**
   * Translated "Make selection bold".
   * 
   * @return translated "Make selection bold"
   */
  @DefaultMessage("Make selection bold")
  @Key("richTextEditor_boldSelectionPrompt")
  String richTextEditor_boldSelectionPrompt();

  

/* richTextEditor_colorPrompt value changed on Wed Jan  5 06:52:25 2022
   Old value was 'Set selection color'.
   See definition later in this file for new value.
*/


  /**
   * Translated "Copy Selection".
   * 
   * @return translated "Copy Selection"
   */
  @DefaultMessage("Copy Selection")
  @Key("richTextEditor_copySelectionPrompt")
  String richTextEditor_copySelectionPrompt();

  /**
   * Translated "Cut Selection".
   * 
   * @return translated "Cut Selection"
   */
  @DefaultMessage("Cut Selection")
  @Key("richTextEditor_cutSelectionPrompt")
  String richTextEditor_cutSelectionPrompt();

  /**
   * Translated "Set Font...".
   * 
   * @return translated "Set Font..."
   */
  @DefaultMessage("Set Font...")
  @Key("richTextEditor_fontSelectorPrompt")
  String richTextEditor_fontSelectorPrompt();

  /**
   * Translated "Set Font Size...".
   * 
   * @return translated "Set Font Size..."
   */
  @DefaultMessage("Set Font Size...")
  @Key("richTextEditor_fontSizeSelectorPrompt")
  String richTextEditor_fontSizeSelectorPrompt();

  /**
   * Translated "Indent selection".
   * 
   * @return translated "Indent selection"
   */
  @DefaultMessage("Indent selection")
  @Key("richTextEditor_indentPrompt")
  String richTextEditor_indentPrompt();

  /**
   * Translated "Make selection italic".
   * 
   * @return translated "Make selection italic"
   */
  @DefaultMessage("Make selection italic")
  @Key("richTextEditor_italicSelectionPrompt")
  String richTextEditor_italicSelectionPrompt();

  /**
   * Translated "Full justify selection".
   * 
   * @return translated "Full justify selection"
   */
  @DefaultMessage("Full justify selection")
  @Key("richTextEditor_justifyPrompt")
  String richTextEditor_justifyPrompt();

  /**
   * Translated "Strike through selection".
   * 
   * @return translated "Strike through selection"
   */
  @DefaultMessage("Strike through selection")
  @Key("richTextEditor_strikethroughSelectionPrompt")
  String richTextEditor_strikethroughSelectionPrompt();

  /**
   * Translated "Convert to a numbered list".
   * 
   * @return translated "Convert to a numbered list"
   */
  @DefaultMessage("Convert to a numbered list")
  @Key("richTextEditor_orderedListPrompt")
  String richTextEditor_orderedListPrompt();

  /**
   * Translated "Convert to a bullet list".
   * 
   * @return translated "Convert to a bullet list"
   */
  @DefaultMessage("Convert to a bullet list")
  @Key("richTextEditor_unorderedListPrompt")
  String richTextEditor_unorderedListPrompt();

  /**
   * Translated "Configure the list".
   * 
   * @return translated "Configure the list"
   */
  @DefaultMessage("Configure the list")
  @Key("richTextEditor_listPropertiesPrompt")
  String richTextEditor_listPropertiesPrompt();

  /**
   * Translated "Place the cursor within a list to configure it".
   * 
   * @return translated "Place the cursor within a list to configure it"
   */
  @DefaultMessage("Place the cursor within a list to configure it")
  @Key("richTextEditor_listPropertiesWarningText")
  String richTextEditor_listPropertiesWarningText();

  

/* richTextEditor_linkPrompt value changed on Wed Jan  5 06:52:25 2022
   Old value was 'Edit hyperlink'.
   See definition later in this file for new value.
*/


  /**
   * Translated "Hyperlink URL:".
   * 
   * @return translated "Hyperlink URL:"
   */
  @DefaultMessage("Hyperlink URL:")
  @Key("richTextEditor_linkUrlTitle")
  String richTextEditor_linkUrlTitle();

  /**
   * Translated "Decrease indent".
   * 
   * @return translated "Decrease indent"
   */
  @DefaultMessage("Decrease indent")
  @Key("richTextEditor_outdentPrompt")
  String richTextEditor_outdentPrompt();

  /**
   * Translated "Paste Selection".
   * 
   * @return translated "Paste Selection"
   */
  @DefaultMessage("Paste Selection")
  @Key("richTextEditor_pasteSelectionPrompt")
  String richTextEditor_pasteSelectionPrompt();

  /**
   * Translated "Make selection underlined".
   * 
   * @return translated "Make selection underlined"
   */
  @DefaultMessage("Make selection underlined")
  @Key("richTextEditor_underlineSelectionPrompt")
  String richTextEditor_underlineSelectionPrompt();

  /**
   * Translated "Contacting Server...".
   * 
   * @return translated "Contacting Server..."
   */
  @DefaultMessage("Contacting Server...")
  @Key("rpcManager_defaultPrompt")
  String rpcManager_defaultPrompt();

  /**
   * Translated "Finding Records that match your criteria...".
   * 
   * @return translated "Finding Records that match your criteria..."
   */
  @DefaultMessage("Finding Records that match your criteria...")
  @Key("rpcManager_fetchDataPrompt")
  String rpcManager_fetchDataPrompt();

  /**
   * Translated "Deleting Record(s)...".
   * 
   * @return translated "Deleting Record(s)..."
   */
  @DefaultMessage("Deleting Record(s)...")
  @Key("rpcManager_removeDataPrompt")
  String rpcManager_removeDataPrompt();

  /**
   * Translated "Saving form...".
   * 
   * @return translated "Saving form..."
   */
  @DefaultMessage("Saving form...")
  @Key("rpcManager_saveDataPrompt")
  String rpcManager_saveDataPrompt();

  /**
   * Translated "Operation timed out".
   * 
   * @return translated "Operation timed out"
   */
  @DefaultMessage("Operation timed out")
  @Key("rpcManager_timeoutErrorMessage")
  String rpcManager_timeoutErrorMessage();

  /**
   * Translated "Validating...".
   * 
   * @return translated "Validating..."
   */
  @DefaultMessage("Validating...")
  @Key("rpcManager_validateDataPrompt")
  String rpcManager_validateDataPrompt();


  /**
   * Translated "$titleField".
   * 
   * @return translated "$titleField"
   */
  @DefaultMessage("$titleField")
  @Key("splitPane_listPaneTitleTemplate")
  String splitPane_listPaneTitleTemplate();

  /**
   * Translated "$titleField".
   * 
   * @return translated "$titleField"
   */
  @DefaultMessage("$titleField")
  @Key("splitPane_detailPaneTitleTemplate")
  String splitPane_detailPaneTitleTemplate();

  /**
   * Translated "Other...".
   * 
   * @return translated "Other..."
   */
  @DefaultMessage("Other...")
  @Key("selectOtherItem_otherTitle")
  String selectOtherItem_otherTitle();

  /**
   * Translated "Other value for".
   * 
   * @return translated "Other value for"
   */
  @DefaultMessage("Other value for")
  @Key("selectOtherItem_selectOtherPrompt")
  String selectOtherItem_selectOtherPrompt();

  /**
   * Translated "Some records in the range you selected are not loaded.  Scroll through the entire range before selecting it.".
   * 
   * @return translated "Some records in the range you selected are not loaded.  Scroll through the entire range before selecting it."
   */
  @DefaultMessage("Some records in the range you selected are not loaded.  Scroll through the entire range before selecting it.")
  @Key("selection_selectionRangeNotLoadedMessage")
  String selection_selectionRangeNotLoadedMessage();

  /**
   * Translated "Auto hide fields used in summary".
   * 
   * @return translated "Auto hide fields used in summary"
   */
  @DefaultMessage("Auto hide fields used in summary")
  @Key("summaryBuilder_autoHideCheckBoxLabel")
  String summaryBuilder_autoHideCheckBoxLabel();

  /**
   * Translated "Summary".
   * 
   * @return translated "Summary"
   */
  @DefaultMessage("Summary")
  @Key("summaryBuilder_builderTypeText")
  String summaryBuilder_builderTypeText();

  /**
   * Translated "Building Summary Columns".
   * 
   * @return translated "Building Summary Columns"
   */
  @DefaultMessage("Building Summary Columns")
  @Key("summaryBuilder_helpTextIntro")
  String summaryBuilder_helpTextIntro();

  /**
   * Translated ", closeable".
   * 
   * @return translated ", closeable"
   */
  @DefaultMessage(", closeable")
  @Key("tabSet_ariaCloseableSuffix")
  String tabSet_ariaCloseableSuffix();

  /**
   * Translated "am".
   * 
   * @return translated "am"
   */
  @DefaultMessage("am")
  @Key("time_AMIndicator")
  String time_AMIndicator();

  /**
   * Translated "pm".
   * 
   * @return translated "pm"
   */
  @DefaultMessage("pm")
  @Key("time_PMIndicator")
  String time_PMIndicator();

  /**
   * Translated ":".
   * 
   * @return translated ":"
   */
  @DefaultMessage(":")
  @Key("time_defaultTimeSeparator")
  String time_defaultTimeSeparator();
  
  /**
   * Translated ".".
   * 
   * @return translated "."
   */
  @DefaultMessage(".")
  @Key("time_defaultMillisecondSeparator")
  String time_defaultMillisecondSeparator();


  /* treeGrid_cantDragIntoChildMessage value modified on Wed May 29 18:15:36 2024
   Old value was 'You can''t drag an item into one of it''s children.'.
   See definition later in this file for new value.
  */

  /**
   * Translated "You can''t drag an item into itself.".
   * 
   * @return translated "You can''t drag an item into itself."
   */
  @DefaultMessage("You can''t drag an item into itself.")
  @Key("treeGrid_cantDragIntoSelfMessage")
  String treeGrid_cantDragIntoSelfMessage();

  /**
   * Translated "This item already contains a child item with that name.".
   * 
   * @return translated "This item already contains a child item with that name."
   */
  @DefaultMessage("This item already contains a child item with that name.")
  @Key("treeGrid_parentAlreadyContainsChildMessage")
  String treeGrid_parentAlreadyContainsChildMessage();

  /**
   * Translated "This data not available while offline.".
   * 
   * @return translated "This data not available while offline."
   */
  @DefaultMessage("This data not available while offline.")
  @Key("treeGrid_offlineNodeMessage")
  String treeGrid_offlineNodeMessage();

  /**
   * Translated "Back".
   * 
   * @return translated "Back."
   */
  @DefaultMessage("Back.")
  @Key("columnTree_backButtonTitle")
  String columnTree_backButtonTitle();

  
  /**
   * Translated "Apply When".
   * 
   * @return translated "Apply When"
   */
  @DefaultMessage("Apply When")
  @Key("validatorEditor_applyWhenTitle")
  String validatorEditor_applyWhenTitle();

  /**
   * Translated "[always applied]".
   * 
   * @return translated "[always applied]"
   */
  @DefaultMessage("[always applied]")
  @Key("validatorEditor_applyWhenPlaceholder")
  String validatorEditor_applyWhenPlaceholder();

  /**
   * Translated "Validator Type".
   * 
   * @return translated "Validator Type"
   */
  @DefaultMessage("Validator Type")
  @Key("validatorEditor_validatorTitle")
  String validatorEditor_validatorTitle();

  /**
   * Translated "Error Message".
   * 
   * @return translated "Error Message"
   */
  @DefaultMessage("Error Message")
  @Key("validatorEditor_errorMessageTitle")
  String validatorEditor_errorMessageTitle();

  /**
   * Translated "[leave blank to use default error message]".
   * 
   * @return translated "[leave blank to use default error message]"
   */
  @DefaultMessage("[leave blank to use default error message]")
  @Key("validatorEditor_errorMessageHint")
  String validatorEditor_errorMessageHint();

  /**
   * Translated "Value".
   * 
   * @return translated "Value"
   */
  @DefaultMessage("Value")
  @Key("validatorEditor_defaultEditorTitle")
  String validatorEditor_defaultEditorTitle();

  /**
   * Translated "Must be $max or earlier".
   * 
   * @return translated "Must be $max or earlier"
   */
  @DefaultMessage("Must be $max or earlier")
  @Key("validator_mustBeEarlierThan")
  String validator_mustBeEarlierThan();

  /**
   * Translated "Must be exactly $max characters".
   * 
   * @return translated "Must be exactly $max characters"
   */
  @DefaultMessage("Must be exactly $max characters")
  @Key("validator_mustBeExactLength")
  String validator_mustBeExactLength();

  /**
   * Translated "Must be at least $min".
   * 
   * @return translated "Must be at least $min"
   */
  @DefaultMessage("Must be at least $min")
  @Key("validator_mustBeGreaterThan")
  String validator_mustBeGreaterThan();

  /**
   * Translated "Must be $min or later".
   * 
   * @return translated "Must be $min or later"
   */
  @DefaultMessage("Must be $min or later")
  @Key("validator_mustBeLaterThan")
  String validator_mustBeLaterThan();

  /**
   * Translated "Must be no more than $max".
   * 
   * @return translated "Must be no more than $max"
   */
  @DefaultMessage("Must be no more than $max")
  @Key("validator_mustBeLessThan")
  String validator_mustBeLessThan();

  /**
   * Translated "Must be at least $min characters".
   * 
   * @return translated "Must be at least $min characters"
   */
  @DefaultMessage("Must be at least $min characters")
  @Key("validator_mustBeLongerThan")
  String validator_mustBeLongerThan();

  /**
   * Translated "Must be less than $max characters".
   * 
   * @return translated "Must be less than $max characters"
   */
  @DefaultMessage("Must be less than $max characters")
  @Key("validator_mustBeShorterThan")
  String validator_mustBeShorterThan();

  /**
   * Translated "Must be a true/false value.".
   * 
   * @return translated "Must be a true/false value."
   */
  @DefaultMessage("Must be a true/false value.")
  @Key("validator_notABoolean")
  String validator_notABoolean();

  /**
   * Translated "Must be a CSS color identifier.".
   * 
   * @return translated "Must be a CSS color identifier."
   */
  @DefaultMessage("Must be a CSS color identifier.")
  @Key("validator_notAColor")
  String validator_notAColor();

  /**
   * Translated "Must be a date.".
   * 
   * @return translated "Must be a date."
   */
  @DefaultMessage("Must be a date.")
  @Key("validator_notADate")
  String validator_notADate();

  /**
   * Translated "Must be a valid decimal.".
   * 
   * @return translated "Must be a valid decimal."
   */
  @DefaultMessage("Must be a valid decimal.")
  @Key("validator_notADecimal")
  String validator_notADecimal();

  /**
   * Translated "Must be a function.".
   * 
   * @return translated "Must be a function."
   */
  @DefaultMessage("Must be a function.")
  @Key("validator_notAFunction")
  String validator_notAFunction();

  /**
   * Translated "Must be a valid regular expression.".
   * 
   * @return translated "Must be a valid regular expression."
   */
  @DefaultMessage("Must be a valid regular expression.")
  @Key("validator_notARegex")
  String validator_notARegex();

  /* validator_notAString value changed on Wed Jan  5 07:19:28 2022
   Old value was 'Must be a String.'.
   See definition later in this file for new value.
  */

  /**
   * Translated "Must be a time.".
   * 
   * @return translated "Must be a time."
   */
  @DefaultMessage("Must be a time.")
  @Key("validator_notATime")
  String validator_notATime();

  /**
   * Translated "Identifiers must start with a letter, underscore or $ character, and may contain only letters, numbers, underscores or $ characters.".
   * 
   * @return translated "Identifiers must start with a letter, underscore or $ character, and may contain only letters, numbers, underscores or $ characters."
   */
  @DefaultMessage("Identifiers must start with a letter, underscore or $ character, and may contain only letters, numbers, underscores or $ characters.")
  @Key("validator_notAnIdentifier")
  String validator_notAnIdentifier();

  /**
   * Translated "Must be a whole number.".
   * 
   * @return translated "Must be a whole number."
   */
  @DefaultMessage("Must be a whole number.")
  @Key("validator_notAnInteger")
  String validator_notAnInteger();

  /**
   * Translated "Not a valid option".
   * 
   * @return translated "Not a valid option"
   */
  @DefaultMessage("Not a valid option")
  @Key("validator_notOneOf")
  String validator_notOneOf();

  /**
   * Translated "Field is required".
   * 
   * @return translated "Field is required"
   */
  @DefaultMessage("Field is required")
  @Key("validator_requiredField")
  String validator_requiredField();

  /**
   * Translated "Value must be unique".
   * 
   * @return translated "Value must be unique"
   */
  @DefaultMessage("Value must be unique")
  @Key("validator_mustBeUnique")
  String validator_mustBeUnique();

  /**
   * Translated "Non-empty file required".
   * 
   * @return translated "Non-empty file required"
   */
  @DefaultMessage("Non-empty file required")
  @Key("validator_requiredFile")
  String validator_requiredFile();

  /**
   * Translated "Must be $min or later".
   * 
   * @return translated "Must be $min or later"
   */
  @DefaultMessage("Must be $min or later")
  @Key("validator_mustBeLaterThanTime")
  String validator_mustBeLaterThanTime();

  /**
   * Translated "Must be $max or earlier".
   * 
   * @return translated "Must be $max or earlier"
   */
  @DefaultMessage("Must be $max or earlier")
  @Key("validator_mustBeEarlierThanTime")
  String validator_mustBeEarlierThanTime();

  /**
   * Translated "Size of ''$uploadedFileName'' ($uploadedFileSize) exceeds maximum allowed file size of $maxFileSize.".
   * 
   * @return translated "Size of ''$uploadedFileName'' ($uploadedFileSize) exceeds maximum allowed file size of $maxFileSize."
   */
  @DefaultMessage("Size of ''$uploadedFileName'' ($uploadedFileSize) exceeds maximum allowed file size of $maxFileSize.")
  @Key("validator_maxFileSizeExceeded")
  String validator_maxFileSizeExceeded();

  /**
   * Translated "Untitled Window".
   * 
   * @return translated "Untitled Window"
   */
  @DefaultMessage("Untitled Window")
  @Key("window_title")
  String window_title();
  


  /*  Generated on Mon May 24 00:54:06 2021 */

  /**
   * Translated "Deployment name"
   *
   * @return translated "Deployment name"
   */
   @DefaultMessage("Deployment name")
   @Key("deploymentEditor_deploymentNameTitle")
   String deploymentEditor_deploymentNameTitle();





  /*  Generated on Mon May 24 01:48:08 2021 */

  /**
   * Translated "Deployment type"
   *
   * @return translated "Deployment type"
   */
   @DefaultMessage("Deployment type")
   @Key("deploymentEditor_deploymentTypeTitle")
   String deploymentEditor_deploymentTypeTitle();

  /**
   * Translated "Deployment URL"
   *
   * @return translated "Deployment URL"
   */
   @DefaultMessage("Deployment URL")
   @Key("deploymentEditor_deploymentURLTitle")
   String deploymentEditor_deploymentURLTitle();

  /**
   * Translated "New $type deployment ''$name'' succeeded"
   *
   * @return translated "New $type deployment ''$name'' succeeded"
   */
   @DefaultMessage("New $type deployment ''$name'' succeeded")
   @Key("deploymentEditor_newDeploymentSuccess")
   String deploymentEditor_newDeploymentSuccess();

  /**
   * Translated "Redeployment of ''$name'' ($type) succeeded"
   *
   * @return translated "Redeployment of ''$name'' ($type) succeeded"
   */
   @DefaultMessage("Redeployment of ''$name'' ($type) succeeded")
   @Key("deploymentEditor_redeploymentSuccess")
   String deploymentEditor_redeploymentSuccess();

  /**
   * Translated "Choose DataSources to import"
   *
   * @return translated "Choose DataSources to import"
   */
   @DefaultMessage("Choose DataSources to import")
   @Key("deploymentEditor_dsImportSelectTitle")
   String deploymentEditor_dsImportSelectTitle();

  /**
   * Translated "Note: all DataSources will exist and have storage.  Above, you are only choosing whether the sample data you have been using should be present in the deployment."
   *
   * @return translated "Note: all DataSources will exist and have storage.  Above, you are only choosing whether the sample data you have been using should be present in the deployment."
   */
   @DefaultMessage("Note: all DataSources will exist and have storage.  Above, you are only choosing whether the sample data you have been using should be present in the deployment.")
   @Key("deploymentEditor_dsImportSelectInfo")
   String deploymentEditor_dsImportSelectInfo();

  /**
   * Translated "Authentication"
   *
   * @return translated "Authentication"
   */
   @DefaultMessage("Authentication")
   @Key("deploymentEditor_authenticationTitle")
   String deploymentEditor_authenticationTitle();

  /**
   * Translated "Users & roles you used for testing inside the Reify visual environment. Enter a single password for all test users below:"
   *
   * @return translated "Users & roles you used for testing inside the Reify visual environment. Enter a single password for all test users below:"
   */
   @DefaultMessage("Users & roles you used for testing inside the Reify visual environment. Enter a single password for all test users below:")
   @Key("deploymentEditor_sampleUsersTitle")
   String deploymentEditor_sampleUsersTitle();

  /**
   * Translated "Note: you will be able to use the Deployment Console to add or remove users after deployment"
   *
   * @return translated "Note: you will be able to use the Deployment Console to add or remove users after deployment"
   */
   @DefaultMessage("Note: you will be able to use the Deployment Console to add or remove users after deployment")
   @Key("deploymentEditor_sampleUsersInfo")
   String deploymentEditor_sampleUsersInfo();

  /**
   * Translated "Password"
   *
   * @return translated "Password"
   */
   @DefaultMessage("Password")
   @Key("deploymentEditor_passwordTitle")
   String deploymentEditor_passwordTitle();

  /**
   * Translated "Password confirm"
   *
   * @return translated "Password confirm"
   */
   @DefaultMessage("Password confirm")
   @Key("deploymentEditor_passwordConfirmTitle")
   String deploymentEditor_passwordConfirmTitle();

  /**
   * Translated "Share users with existing deployment?"
   *
   * @return translated "Share users with existing deployment?"
   */
   @DefaultMessage("Share users with existing deployment?")
   @Key("deploymentEditor_authShareUsersTitle")
   String deploymentEditor_authShareUsersTitle();

  /**
   * Translated "If users are not shared, a copy of the user database is created at deployment"
   *
   * @return translated "If users are not shared, a copy of the user database is created at deployment"
   */
   @DefaultMessage("If users are not shared, a copy of the user database is created at deployment")
   @Key("deploymentEditor_authShareUsersHint")
   String deploymentEditor_authShareUsersHint();

  /**
   * Translated "Deployment"
   *
   * @return translated "Deployment"
   */
   @DefaultMessage("Deployment")
   @Key("deploymentEditor_authDeploymentTitle")
   String deploymentEditor_authDeploymentTitle();

  /**
   * Translated "[pick deployment]"
   *
   * @return translated "[pick deployment]"
   */
   @DefaultMessage("[pick deployment]")
   @Key("deploymentEditor_authDeploymentHint")
   String deploymentEditor_authDeploymentHint();

  /**
   * Translated "Apply"
   *
   * @return translated "Apply"
   */
   @DefaultMessage("Apply")
   @Key("deploymentEditor_applyButtonTitle")
   String deploymentEditor_applyButtonTitle();

  /**
   * Translated "Cancel"
   *
   * @return translated "Cancel"
   */
   @DefaultMessage("Cancel")
   @Key("deploymentEditor_cancelButtonTitle")
   String deploymentEditor_cancelButtonTitle();

  /**
   * Translated "Manage"
   *
   * @return translated "Manage"
   */
   @DefaultMessage("Manage")
   @Key("deploymentManagerLauncher_manageButtonTitle")
   String deploymentManagerLauncher_manageButtonTitle();

  /**
   * Translated "Cancel"
   *
   * @return translated "Cancel"
   */
   @DefaultMessage("Cancel")
   @Key("deploymentManagerLauncher_cancelButtonTitle")
   String deploymentManagerLauncher_cancelButtonTitle();





  /*  Generated on Mon May 24 05:18:46 2021 */

  /**
   * Translated "[long description]"
   *
   * @return translated "[long description]"
   */
   @DefaultMessage("[long description]")
   @Key("sampleDataDSWizard_formatHelpText")
   String sampleDataDSWizard_formatHelpText();





  /*  Generated on Mon May 24 05:20:26 2021 */

  /**
   * Translated "Add a step"
   *
   * @return translated "Add a step"
   */
   @DefaultMessage("Add a step")
   @Key("workflowEditor_addElementTitle")
   String workflowEditor_addElementTitle();

  /**
   * Translated "Pick a task..."
   *
   * @return translated "Pick a task..."
   */
   @DefaultMessage("Pick a task...")
   @Key("workflowEditor_addElementHint")
   String workflowEditor_addElementHint();

  /**
   * Translated "canceled"
   *
   * @return translated "canceled"
   */
   @DefaultMessage("canceled")
   @Key("workflowEditor_canceledLinkPrompt")
   String workflowEditor_canceledLinkPrompt();

  /**
   * Translated "failed"
   *
   * @return translated "failed"
   */
   @DefaultMessage("failed")
   @Key("workflowEditor_failedLinkPrompt")
   String workflowEditor_failedLinkPrompt();

  /**
   * Translated "continuation"
   *
   * @return translated "continuation"
   */
   @DefaultMessage("continuation")
   @Key("workflowEditor_continuationLinkPrompt")
   String workflowEditor_continuationLinkPrompt();

  /**
   * Translated "Initial task to be executed"
   *
   * @return translated "Initial task to be executed"
   */
   @DefaultMessage("Initial task to be executed")
   @Key("workflowEditor_startTaskLinkPrompt")
   String workflowEditor_startTaskLinkPrompt();

  /**
   * Translated "No other tasks currently lead to this task so it will never be executed"
   *
   * @return translated "No other tasks currently lead to this task so it will never be executed"
   */
   @DefaultMessage("No other tasks currently lead to this task so it will never be executed")
   @Key("workflowEditor_unreferencedTaskLinkPrompt")
   String workflowEditor_unreferencedTaskLinkPrompt();

  /**
   * Translated "Last task output: $description"
   *
   * @return translated "Last task output: $description"
   */
   @DefaultMessage("Last task output: $description")
   @Key("workflowEditor_taskScopeLastTaskOutputNodeTitle")
   String workflowEditor_taskScopeLastTaskOutputNodeTitle();

  /**
   * Translated "Are you sure you want to delete this element?"
   *
   * @return translated "Are you sure you want to delete this element?"
   */
   @DefaultMessage("Are you sure you want to delete this element?")
   @Key("workflowEditor_warnOnRemovalMessage")
   String workflowEditor_warnOnRemovalMessage();

  /**
   * Translated "Edit Task"
   *
   * @return translated "Edit Task"
   */
   @DefaultMessage("Edit Task")
   @Key("workflowEditor_editIconPrompt")
   String workflowEditor_editIconPrompt();

  /**
   * Translated "Overwrite all existing bindings? Otherwise, new bindings will be merged."
   *
   * @return translated "Overwrite all existing bindings? Otherwise, new bindings will be merged."
   */
   @DefaultMessage("Overwrite all existing bindings? Otherwise, new bindings will be merged.")
   @Key("workflowValuesBindingEditor_overwriteBindingsMessage")
   String workflowValuesBindingEditor_overwriteBindingsMessage();

  /**
   * Translated "Fixed value for field ''$fieldName''"
   *
   * @return translated "Fixed value for field ''$fieldName''"
   */
   @DefaultMessage("Fixed value for field ''$fieldName''")
   @Key("workflowValuesBindingEditor_fixedValueWindowTitle")
   String workflowValuesBindingEditor_fixedValueWindowTitle();

  /**
   * Translated "Dynamic value for field ''$fieldName''"
   *
   * @return translated "Dynamic value for field ''$fieldName''"
   */
   @DefaultMessage("Dynamic value for field ''$fieldName''")
   @Key("workflowValuesBindingEditor_dynamicValueWindowTitle")
   String workflowValuesBindingEditor_dynamicValueWindowTitle();

  /**
   * Translated "Enter a fixed value"
   *
   * @return translated "Enter a fixed value"
   */
   @DefaultMessage("Enter a fixed value")
   @Key("workflowValuesBindingEditor_bindingFixedValuePrompt")
   String workflowValuesBindingEditor_bindingFixedValuePrompt();

  /**
   * Translated "Define a dynamic value"
   *
   * @return translated "Define a dynamic value"
   */
   @DefaultMessage("Define a dynamic value")
   @Key("workflowValuesBindingEditor_bindingDynamicValuePrompt")
   String workflowValuesBindingEditor_bindingDynamicValuePrompt();

  /**
   * Translated "Dynamic: "
   *
   * @return translated "Dynamic: "
   */
   @DefaultMessage("Dynamic: ")
   @Key("workflowDynamicValueItem_dynamicValuePrefix")
   String workflowDynamicValueItem_dynamicValuePrefix();

  /**
   * Translated "Select dynamic value"
   *
   * @return translated "Select dynamic value"
   */
   @DefaultMessage("Select dynamic value")
   @Key("workflowDynamicValueItem_dynamicValueButtonPrompt")
   String workflowDynamicValueItem_dynamicValueButtonPrompt();

  /**
   * Translated "Choose dynamic value for field $fieldTitle"
   *
   * @return translated "Choose dynamic value for field $fieldTitle"
   */
   @DefaultMessage("Choose dynamic value for field $fieldTitle")
   @Key("workflowDynamicValueItem_dynamicValueWindowTitle")
   String workflowDynamicValueItem_dynamicValueWindowTitle();





  /*  Generated on Mon May 24 05:30:31 2021 */

  /**
   * Translated "Name"
   *
   * @return translated "Name"
   */
   @DefaultMessage("Name")
   @Key("ruleEditor_nameItemTitle")
   String ruleEditor_nameItemTitle();

  /**
   * Translated "Description"
   *
   * @return translated "Description"
   */
   @DefaultMessage("Description")
   @Key("ruleEditor_descriptionItemTitle")
   String ruleEditor_descriptionItemTitle();

  /**
   * Translated "On event"
   *
   * @return translated "On event"
   */
   @DefaultMessage("On event")
   @Key("ruleEditor_triggerEventTitle")
   String ruleEditor_triggerEventTitle();

  /**
   * Translated "For fields"
   *
   * @return translated "For fields"
   */
   @DefaultMessage("For fields")
   @Key("ruleEditor_fieldPickerTitle")
   String ruleEditor_fieldPickerTitle();

  /**
   * Translated "If"
   *
   * @return translated "If"
   */
   @DefaultMessage("If")
   @Key("ruleEditor_applyWhenTitle")
   String ruleEditor_applyWhenTitle();

  /**
   * Translated ".. conditional .."
   *
   * @return translated ".. conditional .."
   */
   @DefaultMessage(".. conditional ..")
   @Key("ruleEditor_applyWhenPlaceholder")
   String ruleEditor_applyWhenPlaceholder();

  /**
   * Translated "Do"
   *
   * @return translated "Do"
   */
   @DefaultMessage("Do")
   @Key("ruleEditor_validatorTitle")
   String ruleEditor_validatorTitle();

  /**
   * Translated "Message"
   *
   * @return translated "Message"
   */
   @DefaultMessage("Message")
   @Key("ruleEditor_errorMessageTitle")
   String ruleEditor_errorMessageTitle();

  /**
   * Translated "None of the available validators can be applied to the selected set of fields."
   *
   * @return translated "None of the available validators can be applied to the selected set of fields."
   */
   @DefaultMessage("None of the available validators can be applied to the selected set of fields.")
   @Key("ruleEditor_invalidFieldSelectionWarning")
   String ruleEditor_invalidFieldSelectionWarning();

  /**
   * Translated "Edit start"
   *
   * @return translated "Edit start"
   */
   @DefaultMessage("Edit start")
   @Key("ruleEditor_editStartEventTitle")
   String ruleEditor_editStartEventTitle();

  /**
   * Translated "Edit start/changed"
   *
   * @return translated "Edit start/changed"
   */
   @DefaultMessage("Edit start/changed")
   @Key("ruleEditor_editStartAndChangedEventTitle")
   String ruleEditor_editStartAndChangedEventTitle();

  /**
   * Translated "Editor enter"
   *
   * @return translated "Editor enter"
   */
   @DefaultMessage("Editor enter")
   @Key("ruleEditor_editorEnterEventTitle")
   String ruleEditor_editorEnterEventTitle();

  /**
   * Translated "Editor exit"
   *
   * @return translated "Editor exit"
   */
   @DefaultMessage("Editor exit")
   @Key("ruleEditor_editorExitEventTitle")
   String ruleEditor_editorExitEventTitle();

  /**
   * Translated "Changed"
   *
   * @return translated "Changed"
   */
   @DefaultMessage("Changed")
   @Key("ruleEditor_changedEventTitle")
   String ruleEditor_changedEventTitle();

  /**
   * Translated "Submit"
   *
   * @return translated "Submit"
   */
   @DefaultMessage("Submit")
   @Key("ruleEditor_submitEventTitle")
   String ruleEditor_submitEventTitle();

  /**
   * Translated "Manual"
   *
   * @return translated "Manual"
   */
   @DefaultMessage("Manual")
   @Key("ruleEditor_manualEventTitle")
   String ruleEditor_manualEventTitle();





  /*  Generated on Mon May 24 05:32:32 2021 */

  /**
   * Translated "Users & Roles"
   *
   * @return translated "Users & Roles"
   */
   @DefaultMessage("Users & Roles")
   @Key("deploymentManager_usersTitle")
   String deploymentManager_usersTitle();

  /**
   * Translated "Data"
   *
   * @return translated "Data"
   */
   @DefaultMessage("Data")
   @Key("deploymentManager_dataTitle")
   String deploymentManager_dataTitle();

  /**
   * Translated "Usage"
   *
   * @return translated "Usage"
   */
   @DefaultMessage("Usage")
   @Key("deploymentManager_usageTitle")
   String deploymentManager_usageTitle();

  /**
   * Translated "DataSource List"
   *
   * @return translated "DataSource List"
   */
   @DefaultMessage("DataSource List")
   @Key("deploymentDSNavigator_dsEnumerationSectionTitle")
   String deploymentDSNavigator_dsEnumerationSectionTitle();

  /**
   * Translated "DataSource: $dsId"
   *
   * @return translated "DataSource: $dsId"
   */
   @DefaultMessage("DataSource: $dsId")
   @Key("deploymentDSNavigator_dsContentSectionTitle")
   String deploymentDSNavigator_dsContentSectionTitle();

  /**
   * Translated "Audit trail for DataSource $dsId"
   *
   * @return translated "Audit trail for DataSource $dsId"
   */
   @DefaultMessage("Audit trail for DataSource $dsId")
   @Key("deploymentDSNavigator_dsContentAuditedSectionTitle")
   String deploymentDSNavigator_dsContentAuditedSectionTitle();

  /**
   * Translated "Audit trail for record $pkCrit from DataSource $dsId"
   *
   * @return translated "Audit trail for record $pkCrit from DataSource $dsId"
   */
   @DefaultMessage("Audit trail for record $pkCrit from DataSource $dsId")
   @Key("deploymentDSNavigator_dsContentRecordAuditSectionTitle")
   String deploymentDSNavigator_dsContentRecordAuditSectionTitle();

  /**
   * Translated "Deployment Sessions"
   *
   * @return translated "Deployment Sessions"
   */
   @DefaultMessage("Deployment Sessions")
   @Key("deploymentUsageViewer_sessionsOverviewGridTitle")
   String deploymentUsageViewer_sessionsOverviewGridTitle();

  /* deploymentUsageViewer_sessionAuditPickerTitle value modified on Wed May 29 18:15:36 2024
   Old value was 'Changes by user $userId during session: '.
   See definition later in this file for new value.
  */

  /**
   * Translated "Click to see related audit data"
   *
   * @return translated "Click to see related audit data"
   */
   @DefaultMessage("Click to see related audit data")
   @Key("deploymentSessionAuditGrid_relatedDataFieldPrompt")
   String deploymentSessionAuditGrid_relatedDataFieldPrompt();

  /**
   * Translated "Jump to <b>Data</b> tab and view..."
   *
   * @return translated "Jump to <b>Data</b> tab and view..."
   */
   @DefaultMessage("Jump to <b>Data</b> tab and view...")
   @Key("deploymentSessionAuditGrid_relatedDataMenuInfoText")
   String deploymentSessionAuditGrid_relatedDataMenuInfoText();

  /**
   * Translated "Changes to this <b>record</b> by <b>any user</b>"
   *
   * @return translated "Changes to this <b>record</b> by <b>any user</b>"
   */
   @DefaultMessage("Changes to this <b>record</b> by <b>any user</b>")
   @Key("deploymentSessionAuditGrid_relatedDataMenuRecordText")
   String deploymentSessionAuditGrid_relatedDataMenuRecordText();

  /**
   * Translated "Changes to DataSource <b>$dsId</b> by <b>any user</b>"
   *
   * @return translated "Changes to DataSource <b>$dsId</b> by <b>any user</b>"
   */
   @DefaultMessage("Changes to DataSource <b>$dsId</b> by <b>any user</b>")
   @Key("deploymentSessionAuditGrid_relatedDataMenuDataSourceText")
   String deploymentSessionAuditGrid_relatedDataMenuDataSourceText();





  /*  Generated on Mon May 24 05:35:28 2021 */

  /**
   * Translated "Edit detected fields and observe results for imported data"
   *
   * @return translated "Edit detected fields and observe results for imported data"
   */
   @DefaultMessage("Edit detected fields and observe results for imported data")
   @Key("parsedDataDSEditor_instructions")
   String parsedDataDSEditor_instructions();

  /**
   * Translated "Please complete existing validator definitions before adding more"
   *
   * @return translated "Please complete existing validator definitions before adding more"
   */
   @DefaultMessage("Please complete existing validator definitions before adding more")
   @Key("validatorsEditor_addButtonDisabledHoverText")
   String validatorsEditor_addButtonDisabledHoverText();

  /**
   * Translated "Show Filter Row"
   *
   * @return translated "Show Filter Row"
   */
   @DefaultMessage("Show Filter Row")
   @Key("listGrid_showFilterEditorTitle")
   String listGrid_showFilterEditorTitle();

  /**
   * Translated "Hide Filter Row"
   *
   * @return translated "Hide Filter Row"
   */
   @DefaultMessage("Hide Filter Row")
   @Key("listGrid_hideFilterEditorTitle")
   String listGrid_hideFilterEditorTitle();

  /**
   * Translated "Last task output: $description"
   *
   * @return translated "Last task output: $description"
   */
   @DefaultMessage("Last task output: $description")
   @Key("processElementEditor_taskScopeLastTaskOutputNodeTitle")
   String processElementEditor_taskScopeLastTaskOutputNodeTitle();

  /**
   * Translated "DataSource $operationType Task"
   *
   * @return translated "DataSource $operationType Task"
   */
   @DefaultMessage("DataSource $operationType Task")
   @Key("serviceTaskEditor_editorTitleFixedOperationType")
   String serviceTaskEditor_editorTitleFixedOperationType();

  /**
   * Translated "Drag available fields from the tree on the left to the grid on the right to specify what data should be stored. Or click the pencil icon to enter a fixed value."
   *
   * @return translated "Drag available fields from the tree on the left to the grid on the right to specify what data should be stored. Or click the pencil icon to enter a fixed value."
   */
   @DefaultMessage("Drag available fields from the tree on the left to the grid on the right to specify what data should be stored. Or click the pencil icon to enter a fixed value.")
   @Key("serviceTaskEditor_addInstructions")
   String serviceTaskEditor_addInstructions();

  /**
   * Translated "Select a source for the unique ID of the record to be deleted."
   *
   * @return translated "Select a source for the unique ID of the record to be deleted."
   */
   @DefaultMessage("Select a source for the unique ID of the record to be deleted.")
   @Key("serviceTaskEditor_removeInstructions")
   String serviceTaskEditor_removeInstructions();

  /**
   * Translated "Define criteria for the DataSource fetch."
   *
   * @return translated "Define criteria for the DataSource fetch."
   */
   @DefaultMessage("Define criteria for the DataSource fetch.")
   @Key("serviceTaskEditor_fetchInstructions")
   String serviceTaskEditor_fetchInstructions();

  /**
   * Translated "Define criteria for the DataSource export."
   *
   * @return translated "Define criteria for the DataSource export."
   */
   @DefaultMessage("Define criteria for the DataSource export.")
   @Key("serviceTaskEditor_exportInstructions")
   String serviceTaskEditor_exportInstructions();

  /**
   * Translated "Overwrite all existing bindings? Otherwise, new bindings will be merged."
   *
   * @return translated "Overwrite all existing bindings? Otherwise, new bindings will be merged."
   */
   @DefaultMessage("Overwrite all existing bindings? Otherwise, new bindings will be merged.")
   @Key("serviceTaskEditor_overwriteBindingsMessage")
   String serviceTaskEditor_overwriteBindingsMessage();

  /**
   * Translated "The field $fieldName must have a binding because it is used to determine which record to udpate."
   *
   * @return translated "The field $fieldName must have a binding because it is used to determine which record to udpate."
   */
   @DefaultMessage("The field $fieldName must have a binding because it is used to determine which record to udpate.")
   @Key("serviceTaskEditor_missingPrimaryKeyMessage")
   String serviceTaskEditor_missingPrimaryKeyMessage();

  /**
   * Translated "An ID source must be selected to identify the record to remove."
   *
   * @return translated "An ID source must be selected to identify the record to remove."
   */
   @DefaultMessage("An ID source must be selected to identify the record to remove.")
   @Key("serviceTaskEditor_missingIdSourceMessage")
   String serviceTaskEditor_missingIdSourceMessage();

  /**
   * Translated "Fixed value for field ''$fieldName''"
   *
   * @return translated "Fixed value for field ''$fieldName''"
   */
   @DefaultMessage("Fixed value for field ''$fieldName''")
   @Key("serviceTaskEditor_fixedValueWindowTitle")
   String serviceTaskEditor_fixedValueWindowTitle();

  /**
   * Translated "Dynamic value for field ''$fieldName''"
   *
   * @return translated "Dynamic value for field ''$fieldName''"
   */
   @DefaultMessage("Dynamic value for field ''$fieldName''")
   @Key("serviceTaskEditor_dynamicValueWindowTitle")
   String serviceTaskEditor_dynamicValueWindowTitle();

  /**
   * Translated "Enter a fixed value"
   *
   * @return translated "Enter a fixed value"
   */
   @DefaultMessage("Enter a fixed value")
   @Key("serviceTaskEditor_bindingFixedValuePrompt")
   String serviceTaskEditor_bindingFixedValuePrompt();

  /**
   * Translated "Define a dynamic value"
   *
   * @return translated "Define a dynamic value"
   */
   @DefaultMessage("Define a dynamic value")
   @Key("serviceTaskEditor_bindingDynamicValuePrompt")
   String serviceTaskEditor_bindingDynamicValuePrompt();

  /**
   * Translated "Define criteria to choose between two possible next tasks."
   *
   * @return translated "Define criteria to choose between two possible next tasks."
   */
   @DefaultMessage("Define criteria to choose between two possible next tasks.")
   @Key("decisionTaskEditor_instructions")
   String decisionTaskEditor_instructions();

  /**
   * Translated "Criteria must be selected."
   *
   * @return translated "Criteria must be selected."
   */
   @DefaultMessage("Criteria must be selected.")
   @Key("decisionTaskEditor_missingCriteriaMessage")
   String decisionTaskEditor_missingCriteriaMessage();

  /**
   * Translated "Pick tasks and the criteria that should cause that task to be done next. Pick a fallback task at the bottom, used if no criteria match."
   *
   * @return translated "Pick tasks and the criteria that should cause that task to be done next. Pick a fallback task at the bottom, used if no criteria match."
   */
   @DefaultMessage("Pick tasks and the criteria that should cause that task to be done next. Pick a fallback task at the bottom, used if no criteria match.")
   @Key("multiDecisionTaskEditor_instructions")
   String multiDecisionTaskEditor_instructions();

  /**
   * Translated "Enter criteria to find the record to edit.  The record will automatically be scrolled into view.  If the criteria match more than one record, the first matching record will be edited."
   *
   * @return translated "Enter criteria to find the record to edit.  The record will automatically be scrolled into view.  If the criteria match more than one record, the first matching record will be edited."
   */
   @DefaultMessage("Enter criteria to find the record to edit.  The record will automatically be scrolled into view.  If the criteria match more than one record, the first matching record will be edited.")
   @Key("gridEditRecordTaskEditor_criteriaInstructions")
   String gridEditRecordTaskEditor_criteriaInstructions();

  /**
   * Translated "Drag available fields from the tree on the left to the grid on the right to specify what data should be stored. Or click the pencil icon to enter a fixed value."
   *
   * @return translated "Drag available fields from the tree on the left to the grid on the right to specify what data should be stored. Or click the pencil icon to enter a fixed value."
   */
   @DefaultMessage("Drag available fields from the tree on the left to the grid on the right to specify what data should be stored. Or click the pencil icon to enter a fixed value.")
   @Key("gridEditRecordTaskEditor_valuesInstructions")
   String gridEditRecordTaskEditor_valuesInstructions();

  /**
   * Translated "Overwrite all existing bindings? Otherwise, new bindings will be merged."
   *
   * @return translated "Overwrite all existing bindings? Otherwise, new bindings will be merged."
   */
   @DefaultMessage("Overwrite all existing bindings? Otherwise, new bindings will be merged.")
   @Key("gridEditRecordTaskEditor_overwriteBindingsMessage")
   String gridEditRecordTaskEditor_overwriteBindingsMessage();

  /**
   * Translated "Fixed value for field ''$fieldName''"
   *
   * @return translated "Fixed value for field ''$fieldName''"
   */
   @DefaultMessage("Fixed value for field ''$fieldName''")
   @Key("gridEditRecordTaskEditor_fixedValueWindowTitle")
   String gridEditRecordTaskEditor_fixedValueWindowTitle();

  /**
   * Translated "Dynamic value for field ''$fieldName''"
   *
   * @return translated "Dynamic value for field ''$fieldName''"
   */
   @DefaultMessage("Dynamic value for field ''$fieldName''")
   @Key("gridEditRecordTaskEditor_dynamicValueWindowTitle")
   String gridEditRecordTaskEditor_dynamicValueWindowTitle();

  /**
   * Translated "Enter a fixed value"
   *
   * @return translated "Enter a fixed value"
   */
   @DefaultMessage("Enter a fixed value")
   @Key("gridEditRecordTaskEditor_bindingFixedValuePrompt")
   String gridEditRecordTaskEditor_bindingFixedValuePrompt();

  /**
   * Translated "Define a dynamic value"
   *
   * @return translated "Define a dynamic value"
   */
   @DefaultMessage("Define a dynamic value")
   @Key("gridEditRecordTaskEditor_bindingDynamicValuePrompt")
   String gridEditRecordTaskEditor_bindingDynamicValuePrompt();

  /**
   * Translated "To edit an existing record Criteria must be selected."
   *
   * @return translated "To edit an existing record Criteria must be selected."
   */
   @DefaultMessage("To edit an existing record Criteria must be selected.")
   @Key("gridEditRecordTaskEditor_missingCriteriaMessage")
   String gridEditRecordTaskEditor_missingCriteriaMessage();

  /**
   * Translated "Drag available fields from the tree on the left to the grid on the right to specify what data should be stored. Or click the pencil icon to enter a fixed value."
   *
   * @return translated "Drag available fields from the tree on the left to the grid on the right to specify what data should be stored. Or click the pencil icon to enter a fixed value."
   */
   @DefaultMessage("Drag available fields from the tree on the left to the grid on the right to specify what data should be stored. Or click the pencil icon to enter a fixed value.")
   @Key("formEditNewRecordTaskEditor_valuesInstructions")
   String formEditNewRecordTaskEditor_valuesInstructions();

  /**
   * Translated "Overwrite all existing bindings? Otherwise, new bindings will be merged."
   *
   * @return translated "Overwrite all existing bindings? Otherwise, new bindings will be merged."
   */
   @DefaultMessage("Overwrite all existing bindings? Otherwise, new bindings will be merged.")
   @Key("formEditNewRecordTaskEditor_overwriteBindingsMessage")
   String formEditNewRecordTaskEditor_overwriteBindingsMessage();

  /**
   * Translated "Fixed value for field ''$fieldName''"
   *
   * @return translated "Fixed value for field ''$fieldName''"
   */
   @DefaultMessage("Fixed value for field ''$fieldName''")
   @Key("formEditNewRecordTaskEditor_fixedValueWindowTitle")
   String formEditNewRecordTaskEditor_fixedValueWindowTitle();

  /**
   * Translated "Dynamic value for field ''$fieldName''"
   *
   * @return translated "Dynamic value for field ''$fieldName''"
   */
   @DefaultMessage("Dynamic value for field ''$fieldName''")
   @Key("formEditNewRecordTaskEditor_dynamicValueWindowTitle")
   String formEditNewRecordTaskEditor_dynamicValueWindowTitle();

  /**
   * Translated "Enter a fixed value"
   *
   * @return translated "Enter a fixed value"
   */
   @DefaultMessage("Enter a fixed value")
   @Key("formEditNewRecordTaskEditor_bindingFixedValuePrompt")
   String formEditNewRecordTaskEditor_bindingFixedValuePrompt();

  /**
   * Translated "Define a dynamic value"
   *
   * @return translated "Define a dynamic value"
   */
   @DefaultMessage("Define a dynamic value")
   @Key("formEditNewRecordTaskEditor_bindingDynamicValuePrompt")
   String formEditNewRecordTaskEditor_bindingDynamicValuePrompt();

  /**
   * Translated "Drag available fields from the tree on the left to the grid on the right to specify what data should be stored. Or click the pencil icon to enter a fixed value."
   *
   * @return translated "Drag available fields from the tree on the left to the grid on the right to specify what data should be stored. Or click the pencil icon to enter a fixed value."
   */
   @DefaultMessage("Drag available fields from the tree on the left to the grid on the right to specify what data should be stored. Or click the pencil icon to enter a fixed value.")
   @Key("formSetValuesTaskEditor_valuesInstructions")
   String formSetValuesTaskEditor_valuesInstructions();

  /**
   * Translated "Overwrite all existing bindings? Otherwise, new bindings will be merged."
   *
   * @return translated "Overwrite all existing bindings? Otherwise, new bindings will be merged."
   */
   @DefaultMessage("Overwrite all existing bindings? Otherwise, new bindings will be merged.")
   @Key("formSetValuesTaskEditor_overwriteBindingsMessage")
   String formSetValuesTaskEditor_overwriteBindingsMessage();

  /**
   * Translated "Fixed value for field ''$fieldName''"
   *
   * @return translated "Fixed value for field ''$fieldName''"
   */
   @DefaultMessage("Fixed value for field ''$fieldName''")
   @Key("formSetValuesTaskEditor_fixedValueWindowTitle")
   String formSetValuesTaskEditor_fixedValueWindowTitle();

  /**
   * Translated "Dynamic value for field ''$fieldName''"
   *
   * @return translated "Dynamic value for field ''$fieldName''"
   */
   @DefaultMessage("Dynamic value for field ''$fieldName''")
   @Key("formSetValuesTaskEditor_dynamicValueWindowTitle")
   String formSetValuesTaskEditor_dynamicValueWindowTitle();

  /**
   * Translated "Enter a fixed value"
   *
   * @return translated "Enter a fixed value"
   */
   @DefaultMessage("Enter a fixed value")
   @Key("formSetValuesTaskEditor_bindingFixedValuePrompt")
   String formSetValuesTaskEditor_bindingFixedValuePrompt();

  /**
   * Translated "Define a dynamic value"
   *
   * @return translated "Define a dynamic value"
   */
   @DefaultMessage("Define a dynamic value")
   @Key("formSetValuesTaskEditor_bindingDynamicValuePrompt")
   String formSetValuesTaskEditor_bindingDynamicValuePrompt();

  /**
   * Translated "Criteria is not complete"
   *
   * @return translated "Criteria is not complete"
   */
   @DefaultMessage("Criteria is not complete")
   @Key("decisionBranchEditor_criteriaNotComplete")
   String decisionBranchEditor_criteriaNotComplete();

  /**
   * Translated "Target is selected but no criteria is defined"
   *
   * @return translated "Target is selected but no criteria is defined"
   */
   @DefaultMessage("Target is selected but no criteria is defined")
   @Key("decisionBranchEditor_criteriaMissingMessage")
   String decisionBranchEditor_criteriaMissingMessage();

  /**
   * Translated "DataSource Fields"
   *
   * @return translated "DataSource Fields"
   */
   @DefaultMessage("DataSource Fields")
   @Key("dsBindingEditor_availableFieldsTitle")
   String dsBindingEditor_availableFieldsTitle();

  /**
   * Translated "Component Fields"
   *
   * @return translated "Component Fields"
   */
   @DefaultMessage("Component Fields")
   @Key("dsBindingEditor_currentFieldsTitle")
   String dsBindingEditor_currentFieldsTitle();

  /**
   * Translated "Name"
   *
   * @return translated "Name"
   */
   @DefaultMessage("Name")
   @Key("dsBindingEditor_availableTitleTitle")
   String dsBindingEditor_availableTitleTitle();

  /**
   * Translated "Field Title"
   *
   * @return translated "Field Title"
   */
   @DefaultMessage("Field Title")
   @Key("dsBindingEditor_currentTitleTitle")
   String dsBindingEditor_currentTitleTitle();

  /**
   * Translated "Bind"
   *
   * @return translated "Bind"
   */
   @DefaultMessage("Bind")
   @Key("dsBindingEditor_saveAndExitButtonTitle")
   String dsBindingEditor_saveAndExitButtonTitle();

  /**
   * Translated "Cancel"
   *
   * @return translated "Cancel"
   */
   @DefaultMessage("Cancel")
   @Key("dsBindingEditor_cancelButtonTitle")
   String dsBindingEditor_cancelButtonTitle();

  /**
   * Translated "Remove"
   *
   * @return translated "Remove"
   */
   @DefaultMessage("Remove")
   @Key("dsBindingEditor_removeItemTitle")
   String dsBindingEditor_removeItemTitle();

  /**
   * Translated "Customize binding for $componentInfo to $dsId DataSource"
   *
   * @return translated "Customize binding for $componentInfo to $dsId DataSource"
   */
   @DefaultMessage("Customize binding for $componentInfo to $dsId DataSource")
   @Key("dsBindingEditorWindow_title")
   String dsBindingEditorWindow_title();

  /**
   * Translated "Cancel"
   *
   * @return translated "Cancel"
   */
   @DefaultMessage("Cancel")
   @Key("dynamicPropertyEditorItem_cancelButtonTitle")
   String dynamicPropertyEditorItem_cancelButtonTitle();

  /**
   * Translated "Save"
   *
   * @return translated "Save"
   */
   @DefaultMessage("Save")
   @Key("dynamicPropertyEditorItem_saveButtonTitle")
   String dynamicPropertyEditorItem_saveButtonTitle();





  /*  Generated on Mon May 24 06:02:38 2021 */

  /**
   * Translated "Sample value to format"
   *
   * @return translated "Sample value to format"
   */
   @DefaultMessage("Sample value to format")
   @Key("datetimeFormatEditor_sampleValueTitle")
   String datetimeFormatEditor_sampleValueTitle();

  /**
   * Translated "Formatted sample output"
   *
   * @return translated "Formatted sample output"
   */
   @DefaultMessage("Formatted sample output")
   @Key("datetimeFormatEditor_sampleOutputTitle")
   String datetimeFormatEditor_sampleOutputTitle();

  /**
   * Translated "Format Code"
   *
   * @return translated "Format Code"
   */
   @DefaultMessage("Format Code")
   @Key("datetimeFormatEditor_formatCodeTitle")
   String datetimeFormatEditor_formatCodeTitle();

  /**
   * Translated "Not a valid date/time format code"
   *
   * @return translated "Not a valid date/time format code"
   */
   @DefaultMessage("Not a valid date/time format code")
   @Key("datetimeFormatEditor_generalFormatErrorMessage")
   String datetimeFormatEditor_generalFormatErrorMessage();

  /**
   * Translated "This does not appear to be a valid format code.  Are you sure you want to save it?"
   *
   * @return translated "This does not appear to be a valid format code.  Are you sure you want to save it?"
   */
   @DefaultMessage("This does not appear to be a valid format code.  Are you sure you want to save it?")
   @Key("datetimeFormatEditor_formatLooksInvalidConfirmationMessage")
   String datetimeFormatEditor_formatLooksInvalidConfirmationMessage();

  /**
   * Translated "Sample value to format"
   *
   * @return translated "Sample value to format"
   */
   @DefaultMessage("Sample value to format")
   @Key("numberFormatEditor_sampleValueTitle")
   String numberFormatEditor_sampleValueTitle();

  /**
   * Translated "Formatted sample output"
   *
   * @return translated "Formatted sample output"
   */
   @DefaultMessage("Formatted sample output")
   @Key("numberFormatEditor_sampleOutputTitle")
   String numberFormatEditor_sampleOutputTitle();

  /**
   * Translated "Decimal places"
   *
   * @return translated "Decimal places"
   */
   @DefaultMessage("Decimal places")
   @Key("numberFormatEditor_decimalPlacesTitle")
   String numberFormatEditor_decimalPlacesTitle();

  /**
   * Translated "Show 1000 Separator"
   *
   * @return translated "Show 1000 Separator"
   */
   @DefaultMessage("Show 1000 Separator")
   @Key("numberFormatEditor_showSeparatorsTitle")
   String numberFormatEditor_showSeparatorsTitle();

  /**
   * Translated "Format for negative values"
   *
   * @return translated "Format for negative values"
   */
   @DefaultMessage("Format for negative values")
   @Key("numberFormatEditor_negativeValuesTitle")
   String numberFormatEditor_negativeValuesTitle();

  /**
   * Translated "Currency symbol"
   *
   * @return translated "Currency symbol"
   */
   @DefaultMessage("Currency symbol")
   @Key("numberFormatEditor_currencySymbolTitle")
   String numberFormatEditor_currencySymbolTitle();

  /**
   * Translated "Show currency symbol last"
   *
   * @return translated "Show currency symbol last"
   */
   @DefaultMessage("Show currency symbol last")
   @Key("numberFormatEditor_currencySymbolLastTitle")
   String numberFormatEditor_currencySymbolLastTitle();

  /**
   * Translated "Percentage"
   *
   * @return translated "Percentage"
   */
   @DefaultMessage("Percentage")
   @Key("numberFormatEditor_percentageTitle")
   String numberFormatEditor_percentageTitle();

  /**
   * Translated "Format Code"
   *
   * @return translated "Format Code"
   */
   @DefaultMessage("Format Code")
   @Key("numberFormatEditor_formatCodeTitle")
   String numberFormatEditor_formatCodeTitle();

  /**
   * Translated "Open format editor"
   *
   * @return translated "Open format editor"
   */
   @DefaultMessage("Open format editor")
   @Key("numberFormatEditor_formatCodeHover")
   String numberFormatEditor_formatCodeHover();


  /*  Generated on Mon May 24 06:05:58 2021 */

  /**
   * Translated "US short date"
   *
   * @return translated "US short date"
   */
   @DefaultMessage("US short date")
   @Key("baseDatetimeFormats_usShortDateTitle")
   String baseDatetimeFormats_usShortDateTitle();

  /**
   * Translated "US short date/time"
   *
   * @return translated "US short date/time"
   */
   @DefaultMessage("US short date/time")
   @Key("baseDatetimeFormats_usShortDatetimeTitle")
   String baseDatetimeFormats_usShortDatetimeTitle();

  /**
   * Translated "Europe short date"
   *
   * @return translated "Europe short date"
   */
   @DefaultMessage("Europe short date")
   @Key("baseDatetimeFormats_europeShortDateTitle")
   String baseDatetimeFormats_europeShortDateTitle();

  /**
   * Translated "Europe short date/time"
   *
   * @return translated "Europe short date/time"
   */
   @DefaultMessage("Europe short date/time")
   @Key("baseDatetimeFormats_europeShortDatetimeTitle")
   String baseDatetimeFormats_europeShortDatetimeTitle();

  /**
   * Translated "China/Japan/Korea date"
   *
   * @return translated "China/Japan/Korea date"
   */
   @DefaultMessage("China/Japan/Korea date")
   @Key("baseDatetimeFormats_asiaDateTitle")
   String baseDatetimeFormats_asiaDateTitle();

  /**
   * Translated "China/Japan/Korea date/time"
   *
   * @return translated "China/Japan/Korea date/time"
   */
   @DefaultMessage("China/Japan/Korea date/time")
   @Key("baseDatetimeFormats_asiaDatetimeTitle")
   String baseDatetimeFormats_asiaDatetimeTitle();

  /**
   * Translated "Hours and minutes"
   *
   * @return translated "Hours and minutes"
   */
   @DefaultMessage("Hours and minutes")
   @Key("baseDatetimeFormats_hoursMinutesTitle")
   String baseDatetimeFormats_hoursMinutesTitle();

  /**
   * Translated "Hours, minutes and seconds"
   *
   * @return translated "Hours, minutes and seconds"
   */
   @DefaultMessage("Hours, minutes and seconds")
   @Key("baseDatetimeFormats_hoursMinutesSecondsTitle")
   String baseDatetimeFormats_hoursMinutesSecondsTitle();

  /**
   * Translated "Full time including milliseconds"
   *
   * @return translated "Full time including milliseconds"
   */
   @DefaultMessage("Full time including milliseconds")
   @Key("baseDatetimeFormats_fullTimeTitle")
   String baseDatetimeFormats_fullTimeTitle();

  /**
   * Translated "Date in words (short)"
   *
   * @return translated "Date in words (short)"
   */
   @DefaultMessage("Date in words (short)")
   @Key("baseDatetimeFormats_dateShortWordsTitle")
   String baseDatetimeFormats_dateShortWordsTitle();

  /**
   * Translated "Date in words (long)"
   *
   * @return translated "Date in words (long)"
   */
   @DefaultMessage("Date in words (long)")
   @Key("baseDatetimeFormats_dateLongWordsTitle")
   String baseDatetimeFormats_dateLongWordsTitle();

  /**
   * Translated "Full long-form date/time"
   *
   * @return translated "Full long-form date/time"
   */
   @DefaultMessage("Full long-form date/time")
   @Key("baseDatetimeFormats_fullDatetimeTitle")
   String baseDatetimeFormats_fullDatetimeTitle();

  /**
   * Translated "Custom format"
   *
   * @return translated "Custom format"
   */
   @DefaultMessage("Custom format")
   @Key("baseDatetimeFormats_customTitle")
   String baseDatetimeFormats_customTitle();

  /**
   * Translated "Whole number"
   *
   * @return translated "Whole number"
   */
   @DefaultMessage("Whole number")
   @Key("baseNumberFormats_wholeNumberTitle")
   String baseNumberFormats_wholeNumberTitle();

  /**
   * Translated "Decimal number"
   *
   * @return translated "Decimal number"
   */
   @DefaultMessage("Decimal number")
   @Key("baseNumberFormats_decimalNumberTitle")
   String baseNumberFormats_decimalNumberTitle();

  /**
   * Translated "Currency amount"
   *
   * @return translated "Currency amount"
   */
   @DefaultMessage("Currency amount")
   @Key("baseNumberFormats_currencyTitle")
   String baseNumberFormats_currencyTitle();

  /**
   * Translated "Percentage"
   *
   * @return translated "Percentage"
   */
   @DefaultMessage("Percentage")
   @Key("baseNumberFormats_percentageTitle")
   String baseNumberFormats_percentageTitle();

  /**
   * Translated "Custom"
   *
   * @return translated "Custom"
   */
   @DefaultMessage("Custom")
   @Key("baseNumberFormats_customTitle")
   String baseNumberFormats_customTitle();





  /*  Generated on Mon May 24 06:31:07 2021 */

  /**
   * Translated "Action Icons"
   *
   * @return translated "Action Icons"
   */
   @DefaultMessage("Action Icons")
   @Key("imagePicker_actionIconsTitle")
   String imagePicker_actionIconsTitle();

  /**
   * Translated "Header Icons"
   *
   * @return translated "Header Icons"
   */
   @DefaultMessage("Header Icons")
   @Key("imagePicker_headerIconsTitle")
   String imagePicker_headerIconsTitle();

  /**
   * Translated "Custom Images"
   *
   * @return translated "Custom Images"
   */
   @DefaultMessage("Custom Images")
   @Key("imagePicker_customImagesTitle")
   String imagePicker_customImagesTitle();

  /**
   * Translated "Upload images to DropBox or a similar service and enter the public URL below"
   *
   * @return translated "Upload images to DropBox or a similar service and enter the public URL below"
   */
   @DefaultMessage("Upload images to DropBox or a similar service and enter the public URL below")
   @Key("imagePicker_tipText")
   String imagePicker_tipText();

  /**
   * Translated "Ok"
   *
   * @return translated "Ok"
   */
   @DefaultMessage("Ok")
   @Key("imagePicker_okButtonTitle")
   String imagePicker_okButtonTitle();

  /**
   * Translated "Cancel"
   *
   * @return translated "Cancel"
   */
   @DefaultMessage("Cancel")
   @Key("imagePicker_cancelButtonTitle")
   String imagePicker_cancelButtonTitle();





  /*  Generated on Mon May 24 06:37:03 2021 */

  

  /**
   * Translated "Advanced filtering..."
   *
   * @return translated "Advanced filtering..."
   */
   @DefaultMessage("Advanced filtering...")
   @Key("listGrid_advancedFilteringText")
   String listGrid_advancedFilteringText();

  /**
   * Translated "Enter criteria below. These criteria are <i>in addition to</i> any criteria entered in the filter immediately above column headers."
   *
   * @return translated "Enter criteria below. These criteria are <i>in addition to</i> any criteria entered in the filter immediately above column headers."
   */
   @DefaultMessage("Enter criteria below. These criteria are <i>in addition to</i> any criteria entered in the filter immediately above column headers.")
   @Key("listGrid_filterWindowInstructions")
   String listGrid_filterWindowInstructions();

  /* listGrid_fieldCriteriaText value modified on Wed May 29 18:15:36 2024
   Old value was 'Field criteria: '.
   See definition later in this file for new value.
  */

  /**
   * Translated "Grid additional criteria:"
   *
   * @return translated "Grid additional criteria:"
   */
   @DefaultMessage("Grid additional criteria:")
   @Key("listGrid_gridAdditionalCriteriaText")
   String listGrid_gridAdditionalCriteriaText();

  /**
   * Translated "&nbsp;"
   *
   * @return translated "&nbsp;"
   */
   @DefaultMessage("&nbsp;")
   @Key("gridRenderer_emptyCellValue")
   String gridRenderer_emptyCellValue();


  /*  Generated on Mon May 24 06:49:00 2021 */

  /* filterBuilder_dynamicValuePrefix value modified on Wed May 29 18:15:36 2024
   Old value was 'Dynamic: '.
   See definition later in this file for new value.
  */

  /**
   * Translated "Select dynamic value"
   *
   * @return translated "Select dynamic value"
   */
   @DefaultMessage("Select dynamic value")
   @Key("filterBuilder_dynamicValueButtonPrompt")
   String filterBuilder_dynamicValueButtonPrompt();

  /**
   * Translated "Choose dynamic value for field $fieldTitle"
   *
   * @return translated "Choose dynamic value for field $fieldTitle"
   */
   @DefaultMessage("Choose dynamic value for field $fieldTitle")
   @Key("filterBuilder_dynamicValueWindowTitle")
   String filterBuilder_dynamicValueWindowTitle();

  /**
   * Translated "&lt;Use static value instead&gt;"
   *
   * @return translated "&lt;Use static value instead&gt;"
   */
   @DefaultMessage("&lt;Use static value instead&gt;")
   @Key("filterBuilder_dynamicValueClearValueText")
   String filterBuilder_dynamicValueClearValueText();





  /*  Generated on Mon May 24 07:10:33 2021 */

  /**
   * Translated "The server is unavailable right now, please try again in a while"
   *
   * @return translated "The server is unavailable right now, please try again in a while"
   */
   @DefaultMessage("The server is unavailable right now, please try again in a while")
   @Key("rPCManager_reloginCommFailureMessage")
   String rPCManager_reloginCommFailureMessage();

  /**
   * Translated "Recent changes for DataSource $dsId"
   *
   * @return translated "Recent changes for DataSource $dsId"
   */
   @DefaultMessage("Recent changes for DataSource $dsId")
   @Key("dSRecordAuditPreview_recordAuditHeaderTitle")
   String dSRecordAuditPreview_recordAuditHeaderTitle();

  /**
   * Translated "Click to add audit information as a new section"
   *
   * @return translated "Click to add audit information as a new section"
   */
   @DefaultMessage("Click to add audit information as a new section")
   @Key("dSRecordAuditPreview_recordAuditInfoTitle")
   String dSRecordAuditPreview_recordAuditInfoTitle();

  /**
   * Translated "Please provide a smaller sample data set. Deployed applications do not have such limits on data sets."
   *
   * @return translated "Please provide a smaller sample data set. Deployed applications do not have such limits on data sets."
   */
   @DefaultMessage("Please provide a smaller sample data set. Deployed applications do not have such limits on data sets.")
   @Key("sampleDataDSWizard_importFileTooLargeMessage")
   String sampleDataDSWizard_importFileTooLargeMessage();

  /**
   * Translated "Please provide a smaller DataSource definition. Deployed applications do not have such limits on definition size."
   *
   * @return translated "Please provide a smaller DataSource definition. Deployed applications do not have such limits on definition size."
   */
   @DefaultMessage("Please provide a smaller DataSource definition. Deployed applications do not have such limits on definition size.")
   @Key("xmlCodeDSWizard_importFileTooLargeMessage")
   String xmlCodeDSWizard_importFileTooLargeMessage();

  /**
   * Translated "Percent"
   *
   * @return translated "Percent"
   */
   @DefaultMessage("Percent")
   @Key("facetChart_proportionalAxisLabel")
   String facetChart_proportionalAxisLabel();

  /**
   * Translated "&lt;Use static value instead&gt;"
   *
   * @return translated "&lt;Use static value instead&gt;"
   */
   @DefaultMessage("&lt;Use static value instead&gt;")
   @Key("dynamicValuePicker_clearValueText")
   String dynamicValuePicker_clearValueText();

  /**
   * Translated "Image Picker"
   *
   * @return translated "Image Picker"
   */
   @DefaultMessage("Image Picker")
   @Key("imageChooserItem_pickerTitle")
   String imageChooserItem_pickerTitle();

  /**
   * Translated "Select an Image for each state you would like to represent"
   *
   * @return translated "Select an Image for each state you would like to represent"
   */
   @DefaultMessage("Select an Image for each state you would like to represent")
   @Key("statefulImageChooser_instructionText")
   String statefulImageChooser_instructionText();



  /*  Generated on Tue May 25 00:11:23 2021 */

  /**
   * Translated "Please enter ''$expectedValue''"
   *
   * @return translated "Please enter ''$expectedValue''"
   */
   @DefaultMessage("Please enter ''$expectedValue''")
   @Key("tourStep_inputValidationNotifyMessage")
   String tourStep_inputValidationNotifyMessage();

  /**
   * Translated "This value comes from the ''$fieldName'' field in the nearby component [$componentName]"
   *
   * @return translated "This value comes from the ''$fieldName'' field in the nearby component [$componentName]"
   */
   @DefaultMessage("This value comes from the ''$fieldName'' field in the nearby component [$componentName]")
   @Key("formulaBuilder_nearbyComponentFieldPrompt")
   String formulaBuilder_nearbyComponentFieldPrompt();

  /**
   * Translated "This value comes from the ''$fieldName'' field in the current component [$componentName]"
   *
   * @return translated "This value comes from the ''$fieldName'' field in the current component [$componentName]"
   */
   @DefaultMessage("This value comes from the ''$fieldName'' field in the current component [$componentName]")
   @Key("formulaBuilder_currentComponentFieldPrompt")
   String formulaBuilder_currentComponentFieldPrompt();

  /**
   * Translated "This value comes from the ''$fieldName'' field in any nearby component that uses DataSource ''$dataSource''. Values that are edited by end users are preferred."
   *
   * @return translated "This value comes from the ''$fieldName'' field in any nearby component that uses DataSource ''$dataSource''. Values that are edited by end users are preferred."
   */
   @DefaultMessage("This value comes from the ''$fieldName'' field in any nearby component that uses DataSource ''$dataSource''. Values that are edited by end users are preferred.")
   @Key("formulaBuilder_dataSourceFieldPrompt")
   String formulaBuilder_dataSourceFieldPrompt();

  /**
   * Translated "Format code contains date formatting, but this is a time field.  If you want to show both date and time elements, change the field type to ''datetime''"
   *
   * @return translated "Format code contains date formatting, but this is a time field.  If you want to show both date and time elements, change the field type to ''datetime''"
   */
   @DefaultMessage("Format code contains date formatting, but this is a time field.  If you want to show both date and time elements, change the field type to ''datetime''")
   @Key("datetimeFormatEditor_timeContainsDateFormattingErrorMessage")
   String datetimeFormatEditor_timeContainsDateFormattingErrorMessage();

  /**
   * Translated "Format code contains time formatting, but this is a date field.  If you want to show both date and time elements, change the field type to ''datetime''"
   *
   * @return translated "Format code contains time formatting, but this is a date field.  If you want to show both date and time elements, change the field type to ''datetime''"
   */
   @DefaultMessage("Format code contains time formatting, but this is a date field.  If you want to show both date and time elements, change the field type to ''datetime''")
   @Key("datetimeFormatEditor_dateContainsTimeFormattingErrorMessage")
   String datetimeFormatEditor_dateContainsTimeFormattingErrorMessage();

  /**
   * Translated "Symbol for user''s locale (currently $)"
   *
   * @return translated "Symbol for user''s locale (currently $)"
   */
   @DefaultMessage("Symbol for user''s locale (currently $)")
   @Key("numberFormatEditor_userLocaleCurrencySymbolDescription")
   String numberFormatEditor_userLocaleCurrencySymbolDescription();

  /**
   * Translated "''format'' property is not applicable to this field type"
   *
   * @return translated "''format'' property is not applicable to this field type"
   */
   @DefaultMessage("''format'' property is not applicable to this field type")
   @Key("numberFormatEditor_formatCodeNotApplicableMessage")
   String numberFormatEditor_formatCodeNotApplicableMessage();



  /*  Generated on Tue May 25 00:47:23 2021 */

  /**
   * Translated "Must be a whole number, percentage, ''*'' or ''auto''"
   *
   * @return translated "Must be a whole number, percentage, ''*'' or ''auto''"
   */
   @DefaultMessage("Must be a whole number, percentage, ''*'' or ''auto''")
   @Key("validator_notAMeasure")
   String validator_notAMeasure();





  /*  Generated on Wed May 26 10:29:25 2021 */

  /**
   * Translated "Values"
   *
   * @return translated "Values"
   */
   @DefaultMessage("Values")
   @Key("cubeGrid_fieldVisibilitySubmenuTitle")
   String cubeGrid_fieldVisibilitySubmenuTitle();

  /**
   * Translated "Highlight Selection"
   *
   * @return translated "Highlight Selection"
   */
   @DefaultMessage("Highlight Selection")
   @Key("cubeGrid_highlightSelectionTitle")
   String cubeGrid_highlightSelectionTitle();

  /**
   * Translated "Highlight Cell"
   *
   * @return translated "Highlight Cell"
   */
   @DefaultMessage("Highlight Cell")
   @Key("cubeGrid_highlightCellTitle")
   String cubeGrid_highlightCellTitle();

  /**
   * Translated "Highlight"
   *
   * @return translated "Highlight"
   */
   @DefaultMessage("Highlight")
   @Key("cubeGrid_highlightTitle")
   String cubeGrid_highlightTitle();

  /**
   * Translated "None"
   *
   * @return translated "None"
   */
   @DefaultMessage("None")
   @Key("cubeGrid_noHighlightsTitle")
   String cubeGrid_noHighlightsTitle();

  /**
   * Translated "Show Highlights"
   *
   * @return translated "Show Highlights"
   */
   @DefaultMessage("Show Highlights")
   @Key("cubeGrid_showHighlightsTitle")
   String cubeGrid_showHighlightsTitle();

  /**
   * Translated "Show all"
   *
   * @return translated "Show all"
   */
   @DefaultMessage("Show all")
   @Key("cubeGrid_showAllHighlightsTitle")
   String cubeGrid_showAllHighlightsTitle();

  /**
   * Translated "Hide all"
   *
   * @return translated "Hide all"
   */
   @DefaultMessage("Hide all")
   @Key("cubeGrid_hideAllHighlightsTitle")
   String cubeGrid_hideAllHighlightsTitle();

  /**
   * Translated "Show Hover Tips"
   *
   * @return translated "Show Hover Tips"
   */
   @DefaultMessage("Show Hover Tips")
   @Key("cubeGrid_showHoverTipsTitle")
   String cubeGrid_showHoverTipsTitle();

  /**
   * Translated "Chart"
   *
   * @return translated "Chart"
   */
   @DefaultMessage("Chart")
   @Key("cubeGrid_chartItemTitle")
   String cubeGrid_chartItemTitle();

  /**
   * Translated "Chart"
   *
   * @return translated "Chart"
   */
   @DefaultMessage("Chart")
   @Key("cubeGrid_chartDialogTitle")
   String cubeGrid_chartDialogTitle();

  /**
   * Translated "AutoFit Column"
   *
   * @return translated "AutoFit Column"
   */
   @DefaultMessage("AutoFit Column")
   @Key("cubeGrid_autoFitColumnTitle")
   String cubeGrid_autoFitColumnTitle();

  /**
   * Translated "Maximize Column"
   *
   * @return translated "Maximize Column"
   */
   @DefaultMessage("Maximize Column")
   @Key("cubeGrid_maximizeColumnTitle")
   String cubeGrid_maximizeColumnTitle();

  /**
   * Translated "Minimize Column"
   *
   * @return translated "Minimize Column"
   */
   @DefaultMessage("Minimize Column")
   @Key("cubeGrid_minimizeColumnTitle")
   String cubeGrid_minimizeColumnTitle();

  /**
   * Translated "Rename..."
   *
   * @return translated "Rename..."
   */
   @DefaultMessage("Rename...")
   @Key("cubeGrid_renameFacetValueTitle")
   String cubeGrid_renameFacetValueTitle();

  /**
   * Translated "Move"
   *
   * @return translated "Move"
   */
   @DefaultMessage("Move")
   @Key("cubeGrid_controlReorderHandleTitle")
   String cubeGrid_controlReorderHandleTitle();

  /**
   * Translated "Minimize"
   *
   * @return translated "Minimize"
   */
   @DefaultMessage("Minimize")
   @Key("cubeGrid_controlMinimizeTitle")
   String cubeGrid_controlMinimizeTitle();

  /**
   * Translated "Maximize"
   *
   * @return translated "Maximize"
   */
   @DefaultMessage("Maximize")
   @Key("cubeGrid_controlMaximizeTitle")
   String cubeGrid_controlMaximizeTitle();

  /**
   * Translated "Sort Up"
   *
   * @return translated "Sort Up"
   */
   @DefaultMessage("Sort Up")
   @Key("cubeGrid_controlSortUpTitle")
   String cubeGrid_controlSortUpTitle();

  /**
   * Translated "Close"
   *
   * @return translated "Close"
   */
   @DefaultMessage("Close")
   @Key("cubeGrid_controlCloseTitle")
   String cubeGrid_controlCloseTitle();

  /**
   * Translated "Chart Type"
   *
   * @return translated "Chart Type"
   */
   @DefaultMessage("Chart Type")
   @Key("cubeGrid_chartTypeTitle")
   String cubeGrid_chartTypeTitle();

  /**
   * Translated "Stacked"
   *
   * @return translated "Stacked"
   */
   @DefaultMessage("Stacked")
   @Key("cubeGrid_chartStackedTitle")
   String cubeGrid_chartStackedTitle();





  /*  Generated on Wed May 26 10:48:48 2021 */

  /**
   * Translated "Sort Down"
   *
   * @return translated "Sort Down"
   */
   @DefaultMessage("Sort Down")
   @Key("cubeGrid_controlSortDownTitle")
   String cubeGrid_controlSortDownTitle();





  /*  Generated on Thu May 27 08:25:37 2021 */

  /**
   * Translated "Access the Learning Center"
   *
   * @return translated "Access the Learning Center"
   */
   @DefaultMessage("Access the Learning Center")
   @Key("learningCenterDock_buttonPromptToShow")
   String learningCenterDock_buttonPromptToShow();

  /**
   * Translated "Hide the Learning Center"
   *
   * @return translated "Hide the Learning Center"
   */
   @DefaultMessage("Hide the Learning Center")
   @Key("learningCenterDock_buttonPromptToHide")
   String learningCenterDock_buttonPromptToHide();

  /* cubeGrid_renameFacetValueMessage value modified on Wed May 29 18:15:36 2024
   Old value was 'Enter the new name for this facet value: '.
   See definition later in this file for new value.
  */





  /*  Generated on Wed Jun  2 12:45:10 2021 */

  /**
   * Translated "Previous year"
   *
   * @return translated "Previous year"
   */
   @DefaultMessage("Previous year")
   @Key("dateChooser_previousYearButtonAriaLabel")
   String dateChooser_previousYearButtonAriaLabel();

  /**
   * Translated "Previous month"
   *
   * @return translated "Previous month"
   */
   @DefaultMessage("Previous month")
   @Key("dateChooser_previousMonthButtonAriaLabel")
   String dateChooser_previousMonthButtonAriaLabel();

  /**
   * Translated "Next month"
   *
   * @return translated "Next month"
   */
   @DefaultMessage("Next month")
   @Key("dateChooser_nextMonthButtonAriaLabel")
   String dateChooser_nextMonthButtonAriaLabel();





  /*  Generated on Wed Jun  2 22:32:46 2021 */

  /**
   * Translated "Next year"
   *
   * @return translated "Next year"
   */
   @DefaultMessage("Next year")
   @Key("dateChooser_nextYearButtonAriaLabel")
   String dateChooser_nextYearButtonAriaLabel();





  /*  Generated on Fri Jun 18 04:54:14 2021 */

  /**
   * Translated "New Event"
   *
   * @return translated "New Event"
   */
   @DefaultMessage("New Event")
   @Key("calendar_newEventWindowTitle")
   String calendar_newEventWindowTitle();

  /**
   * Translated "You can''t drag two occurrences of the same node into a parent."
   *
   * @return translated "You can''t drag two occurrences of the same node into a parent."
   */
   @DefaultMessage("You can''t drag two occurrences of the same node into a parent.")
   @Key("treeGrid_cantDragMultipleNodeOccurencesMessage")
   String treeGrid_cantDragMultipleNodeOccurencesMessage();





  /*  Generated on Tue Sep 14 04:47:13 2021 */

  /**
   * Translated "Clear binding"
   *
   * @return translated "Clear binding"
   */
   @DefaultMessage("Clear binding")
   @Key("workflowValuesBindingEditor_clearBindingPrompt")
   String workflowValuesBindingEditor_clearBindingPrompt();





  /*  Generated on Thu Oct 14 21:50:37 2021 */

  /**
   * Translated "Saved successfully"
   *
   * @return translated "Saved successfully"
   */
   @DefaultMessage("Saved successfully")
   @Key("formSaveDataTask_unboundNotifyMessage")
   String formSaveDataTask_unboundNotifyMessage();

  /**
   * Translated "Only one record may be removed at a time"
   *
   * @return translated "Only one record may be removed at a time"
   */
   @DefaultMessage("Only one record may be removed at a time")
   @Key("gridRemoveSelectedDataTask_refuseMultiRemoveMessage")
   String gridRemoveSelectedDataTask_refuseMultiRemoveMessage();

  /**
   * Translated "Delete $dsTitle $recordTitle"
   *
   * @return translated "Delete $dsTitle $recordTitle"
   */
   @DefaultMessage("Delete $dsTitle $recordTitle")
   @Key("gridRemoveSelectedDataTask_confirmationMessage")
   String gridRemoveSelectedDataTask_confirmationMessage();

  /**
   * Translated "Delete record?"
   *
   * @return translated "Delete record?"
   */
   @DefaultMessage("Delete record?")
   @Key("gridRemoveSelectedDataTask_unboundConfirmationMessage")
   String gridRemoveSelectedDataTask_unboundConfirmationMessage();

  /**
   * Translated "Delete multiple $dsPluralTitle?"
   *
   * @return translated "Delete multiple $dsPluralTitle?"
   */
   @DefaultMessage("Delete multiple $dsPluralTitle?")
   @Key("gridRemoveSelectedDataTask_multipleConfirmationMessage")
   String gridRemoveSelectedDataTask_multipleConfirmationMessage();

  /**
   * Translated "Delete multiple records?"
   *
   * @return translated "Delete multiple records?"
   */
   @DefaultMessage("Delete multiple records?")
   @Key("gridRemoveSelectedDataTask_unboundMultipleConfirmationMessage")
   String gridRemoveSelectedDataTask_unboundMultipleConfirmationMessage();

  /* savedSearchEditor_sharedSearchTitle value modified on Mon Mar 14 11:41:51 2022
   Old value was 'Mark as shared search (all users will see it)'.
   See definition later in this file for new value.
  */

  /* savedSearchEditor_defaultSearchTitle value modified on Mon Mar 14 11:41:51 2022
   Old value was 'Mark as default search'.
   See definition later in this file for new value.
  */

  /* savedSearchEditor_addSearchText value modified on Mon Jul 29 14:45:19 2024
   Old value was 'Enter a name for your search, then enter criteria below.'.
   See definition later in this file for new value.
  */

  /* savedSearchEditor_gridAddSearchText value modified on Mon Jul 29 14:45:19 2024
   Old value was 'Enter a name for your search.  The current configuration of the grid will be saved.'.
   See definition later in this file for new value.
  */

  /* savedSearchEditor_editSearchText value modified on Mon Jul 29 14:45:19 2024
   Old value was 'Enter a new name for your search, and edit criteria below.'.
   See definition later in this file for new value.
  */

  /* editSearchWindow_title value modified on Mon Jul 29 14:45:19 2024
   Old value was 'Edit Search'.
   See definition later in this file for new value.
  */

  /**
   * Translated "[None]"
   *
   * @return translated "[None]"
   */
   @DefaultMessage("[None]")
   @Key("listGrid_noSavedSearchesText")
   String listGrid_noSavedSearchesText();

  /* savedSearchItem_editSearchHoverText value modified on Mon Jul 29 14:45:19 2024
   Old value was 'Edit search'.
   See definition later in this file for new value.
  */

  /* savedSearchItem_removeSearchHoverText value modified on Mon Jul 29 14:45:19 2024
   Old value was 'Remove search'.
   See definition later in this file for new value.
  */

  /* savedSearchItem_copySearchHoverText value modified on Mon Jul 29 14:45:19 2024
   Old value was 'Copy search'.
   See definition later in this file for new value.
  */

  /* savedSearchItem_markAsDefaultHoverText value modified on Mon Jul 29 14:45:19 2024
   Old value was 'Set as default search'.
   See definition later in this file for new value.
  */

  /* savedSearchItem_confirmRemovalMessage value changed on Wed Jan  5 07:19:28 2022
   Old value was 'Remove saved search \"$title?\'.
   See definition later in this file for new value.
  */

  /* savedSearchItem_title value modified on Mon Jul 29 14:45:19 2024
   Old value was 'Searches'.
   See definition later in this file for new value.
  */

  /* savedSearchItem_hint value modified on Mon Jul 29 14:45:19 2024
   Old value was 'Saved searches...'.
   See definition later in this file for new value.
  */





  /*  Generated on Mon Dec  6 11:32:22 2021 */

  /**
   * Translated "Workflow Mock Mode - in live mode, would send Email<p>To: $to<br>Subject: $subject<br>Message: $message"
   *
   * @return translated "Workflow Mock Mode - in live mode, would send Email<p>To: $to<br>Subject: $subject<br>Message: $message"
   */
   @DefaultMessage("Workflow Mock Mode - in live mode, would send Email<p>To: $to<br>Subject: $subject<br>Message: $message")
   @Key("sendEmailTask_mockModeNotifyMessage")
   String sendEmailTask_mockModeNotifyMessage();

  /**
   * Translated "Workflow Mock Mode - in live mode, would send Email<p>To: $to<br>Subject: $subject<br>Message: $message"
   *
   * @return translated "Workflow Mock Mode - in live mode, would send Email<p>To: $to<br>Subject: $subject<br>Message: $message"
   */
   @DefaultMessage("Workflow Mock Mode - in live mode, would send Email<p>To: $to<br>Subject: $subject<br>Message: $message")
   @Key("sendSMSTask_mockModeNotifyMessage")
   String sendSMSTask_mockModeNotifyMessage();

  /**
   * Translated "Saved views"
   *
   * @return translated "Saved views"
   */
   @DefaultMessage("Saved views")
   @Key("listGrid_savedSearchText")
   String listGrid_savedSearchText();

  /* listGrid_newSearchText value changed on Fri Jan  7 03:06:27 2022
   Old value was 'Save New'.
   See definition later in this file for new value.
  */

  /**
   * Translated "Cancel"
   *
   * @return translated "Cancel"
   */
   @DefaultMessage("Cancel")
   @Key("fieldValidatorsItem_cancelButtonTitle")
   String fieldValidatorsItem_cancelButtonTitle();

  /**
   * Translated "Save"
   *
   * @return translated "Save"
   */
   @DefaultMessage("Save")
   @Key("fieldValidatorsItem_saveButtonTitle")
   String fieldValidatorsItem_saveButtonTitle();





  /*  Generated on Wed Jan  5 06:38:48 2022 */


  /*  Generated on Wed Jan  5 06:52:25 2022 */

  /**
   * Translated "Set selection text color"
   *
   * @return translated "Set selection text color"
   */
   @DefaultMessage("Set selection text color")
   @Key("richTextEditor_colorPrompt")
   String richTextEditor_colorPrompt();

  /**
   * Translated "Edit Hyperlink"
   *
   * @return translated "Edit Hyperlink"
   */
   @DefaultMessage("Edit Hyperlink")
   @Key("richTextEditor_linkPrompt")
   String richTextEditor_linkPrompt();





  /*  Generated on Wed Jan  5 06:58:57 2022 */

  /* dataBoundComponent_removeSummaryFieldText value changed on Fri Jan  7 03:06:27 2022
   Old value was 'Remove summary format...'.
   See definition later in this file for new value.
  */





  /*  Generated on Wed Jan  5 07:08:46 2022 */

  /**
   * Translated "Multiple values must be separated by the valueSeparator, ''|''."
   *
   * @return translated "Multiple values must be separated by the valueSeparator, ''|''."
   */
   @DefaultMessage("Multiple values must be separated by the valueSeparator, ''|''.")
   @Key("operators_valueSetUsageHint")
   String operators_valueSetUsageHint();

  /* operators_valueRangeUsageHint value changed on Fri Jan  7 03:06:27 2022
   Old value was 'Range-values require distinct start and end values, separated by the range (between) symbol, ''...''.'.
   See definition later in this file for new value.
  */





  /*  Generated on Wed Jan  5 07:19:28 2022 */

  /**
   * Translated "''$uploadedFileName'' was empty, but empty files are not allowed."
   *
   * @return translated "''$uploadedFileName'' was empty, but empty files are not allowed."
   */
   @DefaultMessage("''$uploadedFileName'' was empty, but empty files are not allowed.")
   @Key("dataSource_requiredFileMessage")
   String dataSource_requiredFileMessage();

  /**
   * Translated "Some rows could not be parsed; the grid below shows $goodRowCount of $totalRows data rows. Row number $firstBadRow was the first row to fail to be parsed."
   *
   * @return translated "Some rows could not be parsed; the grid below shows $goodRowCount of $totalRows data rows. Row number $firstBadRow was the first row to fail to be parsed."
   */
   @DefaultMessage("Some rows could not be parsed; the grid below shows $goodRowCount of $totalRows data rows. Row number $firstBadRow was the first row to fail to be parsed.")
   @Key("batchUploader_errorMessageRowsNotParsed")
   String batchUploader_errorMessageRowsNotParsed();

  /**
   * Translated "Previous error"
   *
   * @return translated "Previous error"
   */
   @DefaultMessage("Previous error")
   @Key("batchUploader_previousButtonTitle")
   String batchUploader_previousButtonTitle();

  /**
   * Translated "Next error"
   *
   * @return translated "Next error"
   */
   @DefaultMessage("Next error")
   @Key("batchUploader_nextButtonTitle")
   String batchUploader_nextButtonTitle();

  /**
   * Translated "Building Formula Columns<P>For basic arithmetic, type in symbols (+, -, *, /, %, //) directly.<P>The following functions are also available:"
   *
   * @return translated "Building Formula Columns<P>For basic arithmetic, type in symbols (+, -, *, /, %, //) directly.<P>The following functions are also available:"
   */
   @DefaultMessage("Building Formula Columns<P>For basic arithmetic, type in symbols (+, -, *, /, %, //) directly.<P>The following functions are also available:")
   @Key("formulaBuilder_helpTextIntro")
   String formulaBuilder_helpTextIntro();

  /* formulaBuilder_saveAddAnotherButtonTitle value modified on Fri Jul 19 09:14:45 2024
   Old value was 'Save /& Add Another'.
   See definition later in this file for new value.
  */

  /**
   * Translated "Cancelling this edit will discard unsaved changes for this record. Continue?"
   *
   * @return translated "Cancelling this edit will discard unsaved changes for this record. Continue?"
   */
   @DefaultMessage("Cancelling this edit will discard unsaved changes for this record. Continue?")
   @Key("listGrid_cancelEditingConfirmationMessage")
   String listGrid_cancelEditingConfirmationMessage();

  /**
   * Translated "This action will discard unsaved changes for this list."
   *
   * @return translated "This action will discard unsaved changes for this list."
   */
   @DefaultMessage("This action will discard unsaved changes for this list.")
   @Key("listGrid_confirmDiscardEditsMessage")
   String listGrid_confirmDiscardEditsMessage();

  /* savedSearchItem_confirmRemovalMessage value changed on Fri Jan  7 03:06:27 2022
   Old value was 'Remove saved search \"$title?\'.
   See definition later in this file for new value.
  */

  /**
   * Translated "Select a value"
   *
   * @return translated "Select a value"
   */
   @DefaultMessage("Select a value")
   @Key("filterClause_valueItemListHint")
   String filterClause_valueItemListHint();

  /**
   * Translated "Select a field"
   *
   * @return translated "Select a field"
   */
   @DefaultMessage("Select a field")
   @Key("filterClause_valueItemFieldHint")
   String filterClause_valueItemFieldHint();

  /**
   * Translated "Must be a string."
   *
   * @return translated "Must be a string."
   */
   @DefaultMessage("Must be a string.")
   @Key("validator_notAString")
   String validator_notAString();





  /*  Generated on Fri Jan  7 03:06:27 2022 */

  /**
   * Translated "Range-operators require distinct start and end values, separated by the range (between) symbol, ''...''."
   *
   * @return translated "Range-operators require distinct start and end values, separated by the range (between) symbol, ''...''."
   */
   @DefaultMessage("Range-operators require distinct start and end values, separated by the range (between) symbol, ''...''.")
   @Key("operators_valueRangeUsageHint")
   String operators_valueRangeUsageHint();

  /**
   * Translated "Remove summary column..."
   *
   * @return translated "Remove summary column..."
   */
   @DefaultMessage("Remove summary column...")
   @Key("dataBoundComponent_removeSummaryFieldText")
   String dataBoundComponent_removeSummaryFieldText();

  /**
   * Translated "Save View..."
   *
   * @return translated "Save View..."
   */
   @DefaultMessage("Save View...")
   @Key("listGrid_newSearchText")
   String listGrid_newSearchText();

  /* savedSearchItem_confirmRemovalMessage value changed on Fri Jan  7 03:38:56 2022
   Old value was 'Remove saved search \"$title?\'.
   See definition later in this file for new value.
  */





  /*  Generated on Fri Jan  7 03:38:56 2022 */

  /* savedSearchItem_confirmRemovalMessage value modified on Mon Jul 29 14:45:19 2024
   Old value was 'Remove saved search ''$title''?'.
   See definition later in this file for new value.
  */





  /*  Generated on Wed Jan 26 14:03:35 2022 */

  /* savedSearchEditor_overwriteSharedSearchConfirmationMessage value modified on Mon Jul 29 14:45:19 2024
   Old value was 'There is already a shared Saved Search with this name - Overwrite?'.
   See definition later in this file for new value.
  */

  /* savedSearchEditor_overwriteSearchConfirmationMessage value modified on Mon Mar 27 15:24:48 2023
   Old value was 'You already have a Saved Search with this name - Overwrite?'.
   See definition later in this file for new value.
  */

  /**
   * Translated "A validation failure occurred:<br>"
   *
   * @return translated "A validation failure occurred:<br>"
   */
   @DefaultMessage("A validation failure occurred:<br>")
   @Key("savedSearchEditor_validationFailedMessage")
   String savedSearchEditor_validationFailedMessage();

  /**
   * Translated "Advanced.."
   *
   * @return translated "Advanced.."
   */
   @DefaultMessage("Advanced..")
   @Key("bindingCriteriaPane_advancedSortMessage")
   String bindingCriteriaPane_advancedSortMessage();

  /**
   * Translated "<i>[default]</i>"
   *
   * @return translated "<i>[default]</i>"
   */
   @DefaultMessage("<i>[default]</i>")
   @Key("savedSearchItem_defaultSearchNameSuffix")
   String savedSearchItem_defaultSearchNameSuffix();

  /**
   * Translated "Cancel"
   *
   * @return translated "Cancel"
   */
   @DefaultMessage("Cancel")
   @Key("enumDynamicPropertyItem_cancelButtonTitle")
   String enumDynamicPropertyItem_cancelButtonTitle();

  /**
   * Translated "Save"
   *
   * @return translated "Save"
   */
   @DefaultMessage("Save")
   @Key("enumDynamicPropertyItem_saveButtonTitle")
   String enumDynamicPropertyItem_saveButtonTitle();

  /**
   * Translated "Enter values and the criteria that should cause that value to be assigned. Enter a default value at the bottom to be used if no criteria match."
   *
   * @return translated "Enter values and the criteria that should cause that value to be assigned. Enter a default value at the bottom to be used if no criteria match."
   */
   @DefaultMessage("Enter values and the criteria that should cause that value to be assigned. Enter a default value at the bottom to be used if no criteria match.")
   @Key("enumDynamicPropertyEditor_instructions")
   String enumDynamicPropertyEditor_instructions();




  /*  Generated on Thu Jan 27 00:13:53 2022 */

  /**
   * Translated "$dsTitle saved successfully"
   *
   * @return translated "$dsTitle saved successfully"
   */
   @DefaultMessage("$dsTitle saved successfully")
   @Key("formSaveDataTask_boundNotifyMessage")
   String formSaveDataTask_boundNotifyMessage();

  /**
   * Translated "$loadingImage&nbsp;Grouping data..."
   *
   * @return translated "$loadingImage&nbsp;Grouping data..."
   */
   @DefaultMessage("$loadingImage&nbsp;Grouping data...")
   @Key("listGrid_asynchGroupingPrompt")
   String listGrid_asynchGroupingPrompt();

  /**
   * Translated "$loadingImage&nbsp;Loading data..."
   *
   * @return translated "$loadingImage&nbsp;Loading data..."
   */
   @DefaultMessage("$loadingImage&nbsp;Loading data...")
   @Key("listGrid_loadingDataMessage")
   String listGrid_loadingDataMessage();

  /**
   * Translated "&nbsp;"
   *
   * @return translated "&nbsp;"
   */
   @DefaultMessage("&nbsp;")
   @Key("listGrid_loadingMessage")
   String listGrid_loadingMessage();





  /*  Generated on Thu Jan 27 00:23:33 2022 */

  /**
   * Translated "$loadingImage&nbsp;Loading data..."
   *
   * @return translated "$loadingImage&nbsp;Loading data..."
   */
   @DefaultMessage("$loadingImage&nbsp;Loading data...")
   @Key("tileGrid_loadingDataMessage")
   String tileGrid_loadingDataMessage();





  /*  Generated on Wed Feb 16 00:42:07 2022 */

  /* savedSearchItem_markAsAdminDefaultHoverText value modified on Mon Jul 29 14:45:19 2024
   Old value was 'Set as default search for all users<br><br><i>[May be overridden by users'' own preferences.]</i>'.
   See definition later in this file for new value.
  */





  /*  Generated on Mon Mar  7 10:36:45 2022 */

  /* dynamicForm_fileAccessFailedWarning value modified on Mon Mar  7 11:01:52 2022
   Old value was 'Unable to access to the selected file(s) for upload. Please re-select the file and try again.'.
   See definition later in this file for new value.
  */





  /*  Generated on Mon Mar  7 11:01:52 2022 */

  /**
   * Translated "Unable to access the selected file(s) for upload. Please re-select the file and try again."
   *
   * @return translated "Unable to access the selected file(s) for upload. Please re-select the file and try again."
   */
   @DefaultMessage("Unable to access the selected file(s) for upload. Please re-select the file and try again.")
   @Key("dynamicForm_fileAccessFailedWarning")
   String dynamicForm_fileAccessFailedWarning();





  /*  Generated on Mon Mar 14 11:41:51 2022 */

  /* savedSearchEditor_sharedSearchTitle value modified on Mon Jul 29 14:45:19 2024
   Old value was 'Shared search (all users will see it)'.
   See definition later in this file for new value.
  */

  /**
   * Translated "Mark as default"
   *
   * @return translated "Mark as default"
   */
   @DefaultMessage("Mark as default")
   @Key("savedSearchEditor_defaultSearchTitle")
   String savedSearchEditor_defaultSearchTitle();

  /**
   * Translated "Date"
   *
   * @return translated "Date"
   */
   @DefaultMessage("Date")
   @Key("calendar_eventEditorDateFieldTitle")
   String calendar_eventEditorDateFieldTitle();





  /*  Generated on Tue Aug 16 11:51:57 2022 */

  /**
   * Translated "$propertyName is not defined"
   *
   * @return translated "$propertyName is not defined"
   */
   @DefaultMessage("$propertyName is not defined")
   @Key("processElement_undefinedComponentMessage")
   String processElement_undefinedComponentMessage();

  /**
   * Translated "$propertyName ''$id'' could not be resolved"
   *
   * @return translated "$propertyName ''$id'' could not be resolved"
   */
   @DefaultMessage("$propertyName ''$id'' could not be resolved")
   @Key("processElement_unresolvedComponentMessage")
   String processElement_unresolvedComponentMessage();

  /**
   * Translated "outputFieldList should have same number of parameters as inputFieldList"
   *
   * @return translated "outputFieldList should have same number of parameters as inputFieldList"
   */
   @DefaultMessage("outputFieldList should have same number of parameters as inputFieldList")
   @Key("stateTask_fieldListsLengthMismatchMessage")
   String stateTask_fieldListsLengthMismatchMessage();

  /**
   * Translated "$propertyName ''$id'' is not a supported type for this task"
   *
   * @return translated "$propertyName ''$id'' is not a supported type for this task"
   */
   @DefaultMessage("$propertyName ''$id'' is not a supported type for this task")
   @Key("componentTask_unsupportedComponentMessage")
   String componentTask_unsupportedComponentMessage();

  /**
   * Translated "maximum value in any matching records"
   *
   * @return translated "maximum value in any matching records"
   */
   @DefaultMessage("maximum value in any matching records")
   @Key("summaryFunctionItem_maxFunctionTitle")
   String summaryFunctionItem_maxFunctionTitle();

  /**
   * Translated "minimum value in any matching records"
   *
   * @return translated "minimum value in any matching records"
   */
   @DefaultMessage("minimum value in any matching records")
   @Key("summaryFunctionItem_minFunctionTitle")
   String summaryFunctionItem_minFunctionTitle();

  /**
   * Translated "average of all values in matching records"
   *
   * @return translated "average of all values in matching records"
   */
   @DefaultMessage("average of all values in matching records")
   @Key("summaryFunctionItem_avgFunctionTitle")
   String summaryFunctionItem_avgFunctionTitle();

  /**
   * Translated "total of all values in all matching records"
   *
   * @return translated "total of all values in all matching records"
   */
   @DefaultMessage("total of all values in all matching records")
   @Key("summaryFunctionItem_sumFunctionTitle")
   String summaryFunctionItem_sumFunctionTitle();

  /**
   * Translated "count of all matching records"
   *
   * @return translated "count of all matching records"
   */
   @DefaultMessage("count of all matching records")
   @Key("summaryFunctionItem_countFunctionTitle")
   String summaryFunctionItem_countFunctionTitle();

  /**
   * Translated "combined text values in all matching records"
   *
   * @return translated "combined text values in all matching records"
   */
   @DefaultMessage("combined text values in all matching records")
   @Key("summaryFunctionItem_concatFunctionTitle")
   String summaryFunctionItem_concatFunctionTitle();

  /**
   * Translated "Remove"
   *
   * @return translated "Remove"
   */
   @DefaultMessage("Remove")
   @Key("aggregationEditor_removeButtonPrompt")
   String aggregationEditor_removeButtonPrompt();

  /**
   * Translated "Add"
   *
   * @return translated "Add"
   */
   @DefaultMessage("Add")
   @Key("aggregationEditor_addButtonPrompt")
   String aggregationEditor_addButtonPrompt();

  /**
   * Translated "Combine records that have the same value for"
   *
   * @return translated "Combine records that have the same value for"
   */
   @DefaultMessage("Combine records that have the same value for")
   @Key("aggregationEditor_groupByTitle")
   String aggregationEditor_groupByTitle();

  /* aggregationEditor_groupByPickerHint value modified on Mon Jun 17 16:13:27 2024
   Old value was 'Select field'.
   See definition later in this file for new value.
  */

  /**
   * Translated "Return all unique combinations of combined fields"
   *
   * @return translated "Return all unique combinations of combined fields"
   */
   @DefaultMessage("Return all unique combinations of combined fields")
   @Key("aggregationEditor_emptyClausesMessage")
   String aggregationEditor_emptyClausesMessage();

  /**
   * Translated "Add summary functions"
   *
   * @return translated "Add summary functions"
   */
   @DefaultMessage("Add summary functions")
   @Key("aggregationEditor_emptyClausesAddButtonPrompt")
   String aggregationEditor_emptyClausesAddButtonPrompt();

  /**
   * Translated "If you remove all aggregation functions, the returned data will be all unique combinations of the combined fields"
   *
   * @return translated "If you remove all aggregation functions, the returned data will be all unique combinations of the combined fields"
   */
   @DefaultMessage("If you remove all aggregation functions, the returned data will be all unique combinations of the combined fields")
   @Key("aggregationEditor_lastClauseRemoveButtonPrompt")
   String aggregationEditor_lastClauseRemoveButtonPrompt();

  /**
   * Translated "Then calculate the value for"
   *
   * @return translated "Then calculate the value for"
   */
   @DefaultMessage("Then calculate the value for")
   @Key("aggregationClause_firstClausePrefixMessage")
   String aggregationClause_firstClausePrefixMessage();

  /**
   * Translated "and the value for"
   *
   * @return translated "and the value for"
   */
   @DefaultMessage("and the value for")
   @Key("aggregationClause_clausePrefixMessage")
   String aggregationClause_clausePrefixMessage();

  /**
   * Translated "as the"
   *
   * @return translated "as the"
   */
   @DefaultMessage("as the")
   @Key("aggregationClause_clauseSummaryMessage")
   String aggregationClause_clauseSummaryMessage();

  /**
   * Translated "Remove"
   *
   * @return translated "Remove"
   */
   @DefaultMessage("Remove")
   @Key("aggregationClause_removeButtonPrompt")
   String aggregationClause_removeButtonPrompt();

  /**
   * Translated "Add"
   *
   * @return translated "Add"
   */
   @DefaultMessage("Add")
   @Key("aggregationClause_addButtonPrompt")
   String aggregationClause_addButtonPrompt();

  /**
   * Translated "Use aggregation"
   *
   * @return translated "Use aggregation"
   */
   @DefaultMessage("Use aggregation")
   @Key("optionalAggregationEditor_useAggregationTitle")
   String optionalAggregationEditor_useAggregationTitle();

  /**
   * Translated "Aggregation combines records from your DataSource together, so that you can compute sums (like the total value of an Order), or find the record with the largest or smallest value for a field, or compute other quantities."
   *
   * @return translated "Aggregation combines records from your DataSource together, so that you can compute sums (like the total value of an Order), or find the record with the largest or smallest value for a field, or compute other quantities."
   */
   @DefaultMessage("Aggregation combines records from your DataSource together, so that you can compute sums (like the total value of an Order), or find the record with the largest or smallest value for a field, or compute other quantities.")
   @Key("optionalAggregationEditor_useAggregationPrompt")
   String optionalAggregationEditor_useAggregationPrompt();

  /**
   * Translated "This will remove aggregation. Proceed?"
   *
   * @return translated "This will remove aggregation. Proceed?"
   */
   @DefaultMessage("This will remove aggregation. Proceed?")
   @Key("optionalAggregationEditor_removeAggregationConfirmationText")
   String optionalAggregationEditor_removeAggregationConfirmationText();

  /**
   * Translated "Must be a whole number, percentage, ''*'' or ''auto'', or a valid JS identifier"
   *
   * @return translated "Must be a whole number, percentage, ''*'' or ''auto'', or a valid JS identifier"
   */
   @DefaultMessage("Must be a whole number, percentage, ''*'' or ''auto'', or a valid JS identifier")
   @Key("validator_notAMeasureOrIdentifier")
   String validator_notAMeasureOrIdentifier();

  /**
   * Translated "Must be a whole number or a valid JS identifier"
   *
   * @return translated "Must be a whole number or a valid JS identifier"
   */
   @DefaultMessage("Must be a whole number or a valid JS identifier")
   @Key("validator_notIntegerOrIdentifier")
   String validator_notIntegerOrIdentifier();

  /**
   * Translated "Must be a positive whole number or ''*''"
   *
   * @return translated "Must be a positive whole number or ''*''"
   */
   @DefaultMessage("Must be a positive whole number or ''*''")
   @Key("validator_notIntegerOrAsterisk")
   String validator_notIntegerOrAsterisk();





  /*  Generated on Wed Mar  8 08:37:40 2023 */

  /**
   * Translated "Unselected Values"
   *
   * @return translated "Unselected Values"
   */
   @DefaultMessage("Unselected Values")
   @Key("shuttle_sourceGridTitle")
   String shuttle_sourceGridTitle();

  /**
   * Translated "Selected Values"
   *
   * @return translated "Selected Values"
   */
   @DefaultMessage("Selected Values")
   @Key("shuttle_targetGridTitle")
   String shuttle_targetGridTitle();

  /**
   * Translated "Unable to select all - the data set does not have all matching records loaded from the dataSource."
   *
   * @return translated "Unable to select all - the data set does not have all matching records loaded from the dataSource."
   */
   @DefaultMessage("Unable to select all - the data set does not have all matching records loaded from the dataSource.")
   @Key("shuttle_incompleteDataWarning")
   String shuttle_incompleteDataWarning();

  /**
   * Translated "Default/none"
   *
   * @return translated "Default/none"
   */
   @DefaultMessage("Default/none")
   @Key("baseNumberFormats_defaultNumberTitle")
   String baseNumberFormats_defaultNumberTitle();

  /**
   * Translated "Value in other field"
   *
   * @return translated "Value in other field"
   */
   @DefaultMessage("Value in other field")
   @Key("dynamicValueEditor_dataPathOptionTitle")
   String dynamicValueEditor_dataPathOptionTitle();

  /**
   * Translated "Text format based on other fields"
   *
   * @return translated "Text format based on other fields"
   */
   @DefaultMessage("Text format based on other fields")
   @Key("dynamicValueEditor_textFormulaOptionTitle")
   String dynamicValueEditor_textFormulaOptionTitle();

  /**
   * Translated "Math formula using other fields"
   *
   * @return translated "Math formula using other fields"
   */
   @DefaultMessage("Math formula using other fields")
   @Key("dynamicValueEditor_formulaOptionTitle")
   String dynamicValueEditor_formulaOptionTitle();

  /**
   * Translated "Conditiona value"
   *
   * @return translated "Conditiona value"
   */
   @DefaultMessage("Conditiona value")
   @Key("dynamicValueEditor_conditionalOptionTitle")
   String dynamicValueEditor_conditionalOptionTitle();

  /**
   * Translated "Cancel"
   *
   * @return translated "Cancel"
   */
   @DefaultMessage("Cancel")
   @Key("dynamicValueEditor_cancelButtonTitle")
   String dynamicValueEditor_cancelButtonTitle();

  /**
   * Translated "Save"
   *
   * @return translated "Save"
   */
   @DefaultMessage("Save")
   @Key("dynamicValueEditor_saveButtonTitle")
   String dynamicValueEditor_saveButtonTitle();

  /**
   * Translated "Enter values and the criteria that should cause that value to be assigned. Enter a default value at the bottom to be used if no criteria match."
   *
   * @return translated "Enter values and the criteria that should cause that value to be assigned. Enter a default value at the bottom to be used if no criteria match."
   */
   @DefaultMessage("Enter values and the criteria that should cause that value to be assigned. Enter a default value at the bottom to be used if no criteria match.")
   @Key("dynamicValueMappingEditor_instructions")
   String dynamicValueMappingEditor_instructions();

  /* dynamicValueMappingValueItem_dynamicValuePrefix value modified on Wed May 29 18:15:36 2024
   Old value was 'Dynamic: '.
   See definition later in this file for new value.
  */

  /**
   * Translated "Select dynamic value"
   *
   * @return translated "Select dynamic value"
   */
   @DefaultMessage("Select dynamic value")
   @Key("dynamicValueMappingValueItem_dynamicValueButtonPrompt")
   String dynamicValueMappingValueItem_dynamicValueButtonPrompt();

  /**
   * Translated "Choose dynamic value for field $fieldTitle"
   *
   * @return translated "Choose dynamic value for field $fieldTitle"
   */
   @DefaultMessage("Choose dynamic value for field $fieldTitle")
   @Key("dynamicValueMappingValueItem_dynamicValueWindowTitle")
   String dynamicValueMappingValueItem_dynamicValueWindowTitle();

  /* multiPickerItem_useSelectedValuesPrefix value modified on Wed May 29 18:15:36 2024
   Old value was 'None Except: '.
   See definition later in this file for new value.
  */

  /* multiPickerItem_useUnselectedValuesPrefix value modified on Wed May 29 18:15:36 2024
   Old value was 'All Except: '.
   See definition later in this file for new value.
  */

  /**
   * Translated "Select All"
   *
   * @return translated "Select All"
   */
   @DefaultMessage("Select All")
   @Key("multiPickerItem_selectAllButtonTitle")
   String multiPickerItem_selectAllButtonTitle();

  /**
   * Translated "Select All disabled while filtered"
   *
   * @return translated "Select All disabled while filtered"
   */
   @DefaultMessage("Select All disabled while filtered")
   @Key("multiPickerItem_selectAllWhileFiltered_disabledPrompt")
   String multiPickerItem_selectAllWhileFiltered_disabledPrompt();

  /**
   * Translated "Unable to Select All as the full set of options has not been fetched from the server."
   *
   * @return translated "Unable to Select All as the full set of options has not been fetched from the server."
   */
   @DefaultMessage("Unable to Select All as the full set of options has not been fetched from the server.")
   @Key("multiPickerItem_selectAllWhileFiltered_partialCachePrompt")
   String multiPickerItem_selectAllWhileFiltered_partialCachePrompt();

  /**
   * Translated "Clear All"
   *
   * @return translated "Clear All"
   */
   @DefaultMessage("Clear All")
   @Key("multiPickerItem_deselectAllButtonTitle")
   String multiPickerItem_deselectAllButtonTitle();

  /**
   * Translated "Clear All disabled while filtered"
   *
   * @return translated "Clear All disabled while filtered"
   */
   @DefaultMessage("Clear All disabled while filtered")
   @Key("multiPickerItem_deselectAllWhileFiltered_disabledPrompt")
   String multiPickerItem_deselectAllWhileFiltered_disabledPrompt();

  /**
   * Translated "Unable to Clear All as the full set of options has not been fetched from the server."
   *
   * @return translated "Unable to Clear All as the full set of options has not been fetched from the server."
   */
   @DefaultMessage("Unable to Clear All as the full set of options has not been fetched from the server.")
   @Key("multiPickerItem_deselectAllWhileFiltered_partialCachePrompt")
   String multiPickerItem_deselectAllWhileFiltered_partialCachePrompt();

  /**
   * Translated "Filter"
   *
   * @return translated "Filter"
   */
   @DefaultMessage("Filter")
   @Key("multiPickerItem_filterHint")
   String multiPickerItem_filterHint();

  /**
   * Translated "Excluded Items"
   *
   * @return translated "Excluded Items"
   */
   @DefaultMessage("Excluded Items")
   @Key("multiPickerItem_unselectedSelectionListTitle")
   String multiPickerItem_unselectedSelectionListTitle();

  /* multiPickerItem_selectedSelectionListTitle value modified on Mon Mar 27 15:24:48 2023
   Old value was 'Inclued Items'.
   See definition later in this file for new value.
  */

  /**
   * Translated "Dynamic Property Editor"
   *
   * @return translated "Dynamic Property Editor"
   */
   @DefaultMessage("Dynamic Property Editor")
   @Key("dynamicPropertyEditorItem_editorWindowTitle")
   String dynamicPropertyEditorItem_editorWindowTitle();





  /*  Generated on Mon Mar 27 15:24:48 2023 */

  /* savedSearchEditor_overwriteSearchConfirmationMessage value modified on Mon Jul 29 14:45:19 2024
   Old value was 'There is already a Saved Search with this name - Overwrite?'.
   See definition later in this file for new value.
  */

  /**
   * Translated "Included Items"
   *
   * @return translated "Included Items"
   */
   @DefaultMessage("Included Items")
   @Key("multiPickerItem_selectedSelectionListTitle")
   String multiPickerItem_selectedSelectionListTitle();





  /*  Generated on Thu Jun 15 05:36:51 2023 */

  /**
   * Translated "AI-Generated Summary Field"
   *
   * @return translated "AI-Generated Summary Field"
   */
   @DefaultMessage("AI-Generated Summary Field")
   @Key("dataBoundComponent_aiSummaryBuilderWindowTitle")
   String dataBoundComponent_aiSummaryBuilderWindowTitle();

  /**
   * Translated "Add AI column..."
   *
   * @return translated "Add AI column..."
   */
   @DefaultMessage("Add AI column...")
   @Key("dataBoundComponent_addAISummaryFieldText")
   String dataBoundComponent_addAISummaryFieldText();

  /**
   * Translated "Edit AI prompt..."
   *
   * @return translated "Edit AI prompt..."
   */
   @DefaultMessage("Edit AI prompt...")
   @Key("dataBoundComponent_editAISummaryFieldText")
   String dataBoundComponent_editAISummaryFieldText();

  /**
   * Translated "Remove AI column..."
   *
   * @return translated "Remove AI column..."
   */
   @DefaultMessage("Remove AI column...")
   @Key("dataBoundComponent_removeAISummaryFieldText")
   String dataBoundComponent_removeAISummaryFieldText();

  /**
   * Translated "<b><i>[Retrieving summary from AI...]</i></b>"
   *
   * @return translated "<b><i>[Retrieving summary from AI...]</i></b>"
   */
   @DefaultMessage("<b><i>[Retrieving summary from AI...]</i></b>")
   @Key("listGrid_retrievingAICellHoverMessage")
   String listGrid_retrievingAICellHoverMessage();

  /**
   * Translated "<b>AI-generated summary:</b><br>"
   *
   * @return translated "<b>AI-generated summary:</b><br>"
   */
   @DefaultMessage("<b>AI-generated summary:</b><br>")
   @Key("listGrid_aiCellHoverPrefix")
   String listGrid_aiCellHoverPrefix();

  /**
   * Translated "Filter by AI..."
   *
   * @return translated "Filter by AI..."
   */
   @DefaultMessage("Filter by AI...")
   @Key("listGrid_filterByAIText")
   String listGrid_filterByAIText();

  /**
   * Translated "Clear AI Filter"
   *
   * @return translated "Clear AI Filter"
   */
   @DefaultMessage("Clear AI Filter")
   @Key("listGrid_clearFilterByAIText")
   String listGrid_clearFilterByAIText();

  /**
   * Translated "AI-based filtering can only be performed with less than $aiFilterMaxRecords records"
   *
   * @return translated "AI-based filtering can only be performed with less than $aiFilterMaxRecords records"
   */
   @DefaultMessage("AI-based filtering can only be performed with less than $aiFilterMaxRecords records")
   @Key("listGrid_aiFilterMaxRecordsMessage")
   String listGrid_aiFilterMaxRecordsMessage();

  /**
   * Translated "AI Filtering"
   *
   * @return translated "AI Filtering"
   */
   @DefaultMessage("AI Filtering")
   @Key("listGrid_aiFilterWindowTitle")
   String listGrid_aiFilterWindowTitle();

  /**
   * Translated "Show records that match this description..."
   *
   * @return translated "Show records that match this description..."
   */
   @DefaultMessage("Show records that match this description...")
   @Key("listGrid_aiFilterWindowInstructions")
   String listGrid_aiFilterWindowInstructions();

  /**
   * Translated "Explain which records should be shown"
   *
   * @return translated "Explain which records should be shown"
   */
   @DefaultMessage("Explain which records should be shown")
   @Key("listGrid_aiFilterWindowHint")
   String listGrid_aiFilterWindowHint();

  /**
   * Translated "Advanced Filtering"
   *
   * @return translated "Advanced Filtering"
   */
   @DefaultMessage("Advanced Filtering")
   @Key("listGrid_filterWindowTitle")
   String listGrid_filterWindowTitle();

  /**
   * Translated "Cannot add an AI summary field to a grid with more than $maxRecords records"
   *
   * @return translated "Cannot add an AI summary field to a grid with more than $maxRecords records"
   */
   @DefaultMessage("Cannot add an AI summary field to a grid with more than $maxRecords records")
   @Key("listGrid_aiSummaryFieldMaxRecordsMessage")
   String listGrid_aiSummaryFieldMaxRecordsMessage();

  /**
   * Translated "AI Sort"
   *
   * @return translated "AI Sort"
   */
   @DefaultMessage("AI Sort")
   @Key("listGrid_aiSortBuilderWindowTitle")
   String listGrid_aiSortBuilderWindowTitle();

  /**
   * Translated "Add AI column"
   *
   * @return translated "Add AI column"
   */
   @DefaultMessage("Add AI column")
   @Key("listGrid_addAIFieldSubmenuTitle")
   String listGrid_addAIFieldSubmenuTitle();

  /**
   * Translated "Sort..."
   *
   * @return translated "Sort..."
   */
   @DefaultMessage("Sort...")
   @Key("listGrid_addAISortFieldText")
   String listGrid_addAISortFieldText();

  /**
   * Translated "Edit prompt..."
   *
   * @return translated "Edit prompt..."
   */
   @DefaultMessage("Edit prompt...")
   @Key("listGrid_editAISortFieldText")
   String listGrid_editAISortFieldText();

  /**
   * Translated "Remove AI column..."
   *
   * @return translated "Remove AI column..."
   */
   @DefaultMessage("Remove AI column...")
   @Key("listGrid_removeAISortFieldText")
   String listGrid_removeAISortFieldText();

  /* listGrid_aiSortFieldMaxRecordsMessage value modified on Fri Jul 26 11:31:30 2024
   Old value was 'AI-based sorting can only be performed with less than $aiSortMaxRecords records'.
   See definition later in this file for new value.
  */

  /**
   * Translated "Please wait - Computing record sort values"
   *
   * @return translated "Please wait - Computing record sort values"
   */
   @DefaultMessage("Please wait - Computing record sort values")
   @Key("aISortProgressDialog_title")
   String aISortProgressDialog_title();

  /**
   * Translated "Dismiss"
   *
   * @return translated "Dismiss"
   */
   @DefaultMessage("Dismiss")
   @Key("aISortProgressDialog_dismissButtonTitle")
   String aISortProgressDialog_dismissButtonTitle();

  /* aIFieldBuilder_instructionsTextStart value modified on Tue Jul 30 11:18:52 2024
   Old value was 'see below'.
   See definition later in this file for new value.
  */

  /**
   * Translated "see below"
   *
   * @return translated "see below"
   */
   @DefaultMessage("see below")
   @Key("aISortBuilder_instructionsTextStart")
   String aISortBuilder_instructionsTextStart();





  /*  Generated on Wed May 29 18:15:36 2024 */

  /**
   * Translated "An error occurred during an asynchronous operation."
   *
   * @return translated "An error occurred during an asynchronous operation."
   */
   @DefaultMessage("An error occurred during an asynchronous operation.")
   @Key("asyncUtil_asyncErrorMessageGeneric")
   String asyncUtil_asyncErrorMessageGeneric();

  /* asyncUtil_asyncErrorMessage value modified on Sat Jun  1 20:52:21 2024
   Old value was 'An error occurred during an asynchronous operation.'.
   See definition later in this file for new value.
  */

  /**
   * Translated "An asynchronous operation was canceled."
   *
   * @return translated "An asynchronous operation was canceled."
   */
   @DefaultMessage("An asynchronous operation was canceled.")
   @Key("asyncUtil_asyncCanceledMessageGeneric")
   String asyncUtil_asyncCanceledMessageGeneric();

  /* asyncUtil_asyncCanceledMessage value modified on Sat Jun  1 20:52:21 2024
   Old value was 'An asynchronous operation was canceled.'.
   See definition later in this file for new value.
  */

  /**
   * Translated "An asynchronous operation resulted in an unspecified type of result."
   *
   * @return translated "An asynchronous operation resulted in an unspecified type of result."
   */
   @DefaultMessage("An asynchronous operation resulted in an unspecified type of result.")
   @Key("asyncUtil_asyncOtherTypeMessageGeneric")
   String asyncUtil_asyncOtherTypeMessageGeneric();

  /* asyncUtil_asyncOtherTypeMessage value modified on Sat Jun  1 20:52:21 2024
   Old value was 'An asynchronous operation resulted in an unspecified type of result.'.
   See definition later in this file for new value.
  */

  /**
   * Translated "Next"
   *
   * @return translated "Next"
   */
   @DefaultMessage("Next")
   @Key("tour_stepActionButtonTitle")
   String tour_stepActionButtonTitle();

  /**
   * Translated "Let''s go!"
   *
   * @return translated "Let''s go!"
   */
   @DefaultMessage("Let''s go!")
   @Key("tour_firstStepActionButtonTitle")
   String tour_firstStepActionButtonTitle();

  /**
   * Translated "Done"
   *
   * @return translated "Done"
   */
   @DefaultMessage("Done")
   @Key("tour_lastStepActionButtonTitle")
   String tour_lastStepActionButtonTitle();

  /**
   * Translated "Skip this tour"
   *
   * @return translated "Skip this tour"
   */
   @DefaultMessage("Skip this tour")
   @Key("tour_stepCancelButtonTitle")
   String tour_stepCancelButtonTitle();

  /**
   * Translated "Skip this tour"
   *
   * @return translated "Skip this tour"
   */
   @DefaultMessage("Skip this tour")
   @Key("tour_firstStepCancelButtonTitle")
   String tour_firstStepCancelButtonTitle();

  /**
   * Translated "Cancel"
   *
   * @return translated "Cancel"
   */
   @DefaultMessage("Cancel")
   @Key("tourConfirmStep_cancelButtonTitle")
   String tourConfirmStep_cancelButtonTitle();

  /**
   * Translated "OK"
   *
   * @return translated "OK"
   */
   @DefaultMessage("OK")
   @Key("tourConfirmStep_actionButtonTitle")
   String tourConfirmStep_actionButtonTitle();

  /**
   * Translated "New Tour Configuration"
   *
   * @return translated "New Tour Configuration"
   */
   @DefaultMessage("New Tour Configuration")
   @Key("tour_tourWizardTitle")
   String tour_tourWizardTitle();

  /**
   * Translated "Tour Type"
   *
   * @return translated "Tour Type"
   */
   @DefaultMessage("Tour Type")
   @Key("tour_tourWizardTourTypeTitle")
   String tour_tourWizardTourTypeTitle();

  /**
   * Translated "Reify Tutorial"
   *
   * @return translated "Reify Tutorial"
   */
   @DefaultMessage("Reify Tutorial")
   @Key("tour_tourWizardReifyTourTitle")
   String tour_tourWizardReifyTourTitle();

  /**
   * Translated "UI Tour (Non Interactive)"
   *
   * @return translated "UI Tour (Non Interactive)"
   */
   @DefaultMessage("UI Tour (Non Interactive)")
   @Key("tour_tourWizardUITourTitle")
   String tour_tourWizardUITourTitle();

  /**
   * Translated "Interactive Tutorial"
   *
   * @return translated "Interactive Tutorial"
   */
   @DefaultMessage("Interactive Tutorial")
   @Key("tour_tourWizardInteractiveTourTitle")
   String tour_tourWizardInteractiveTourTitle();

  /**
   * Translated "Show Progress"
   *
   * @return translated "Show Progress"
   */
   @DefaultMessage("Show Progress")
   @Key("tour_tourWizardShowProgressTitle")
   String tour_tourWizardShowProgressTitle();

  /**
   * Translated "Start With New Screen"
   *
   * @return translated "Start With New Screen"
   */
   @DefaultMessage("Start With New Screen")
   @Key("tour_tourWizardNewScreenPickerTitle")
   String tour_tourWizardNewScreenPickerTitle();

  /**
   * Translated "Required DataSources"
   *
   * @return translated "Required DataSources"
   */
   @DefaultMessage("Required DataSources")
   @Key("tour_tourWizardRequiredDataSourcesTitle")
   String tour_tourWizardRequiredDataSourcesTitle();

  /**
   * Translated "Comma separated list of required DS''s"
   *
   * @return translated "Comma separated list of required DS''s"
   */
   @DefaultMessage("Comma separated list of required DS''s")
   @Key("tour_tourWizardRequiredDataSourcesHint")
   String tour_tourWizardRequiredDataSourcesHint();

  /**
   * Translated "Record Tour"
   *
   * @return translated "Record Tour"
   */
   @DefaultMessage("Record Tour")
   @Key("tour_tourWizardRecordButtonTitle")
   String tour_tourWizardRecordButtonTitle();

  /**
   * Translated "No Tour Steps Recorded"
   *
   * @return translated "No Tour Steps Recorded"
   */
   @DefaultMessage("No Tour Steps Recorded")
   @Key("tour_tourStepWizardNoStepsMessage")
   String tour_tourStepWizardNoStepsMessage();

  /**
   * Translated "Title"
   *
   * @return translated "Title"
   */
   @DefaultMessage("Title")
   @Key("tour_tourStepWizardTitle")
   String tour_tourStepWizardTitle();

  /**
   * Translated "Instructions"
   *
   * @return translated "Instructions"
   */
   @DefaultMessage("Instructions")
   @Key("tour_tourStepWizardInstructionsTitle")
   String tour_tourStepWizardInstructionsTitle();

  /**
   * Translated "Target"
   *
   * @return translated "Target"
   */
   @DefaultMessage("Target")
   @Key("tour_tourStepWizardTargetTitle")
   String tour_tourStepWizardTargetTitle();

  /**
   * Translated "Click icon, then Shift+Click within the application to add a target"
   *
   * @return translated "Click icon, then Shift+Click within the application to add a target"
   */
   @DefaultMessage("Click icon, then Shift+Click within the application to add a target")
   @Key("tour_tourStepWizardTargePrompt")
   String tour_tourStepWizardTargePrompt();

  /**
   * Translated "Shift+Click on the app to record a target locator"
   *
   * @return translated "Shift+Click on the app to record a target locator"
   */
   @DefaultMessage("Shift+Click on the app to record a target locator")
   @Key("tour_tourStepWizardTargeNotifyText")
   String tour_tourStepWizardTargeNotifyText();

  /**
   * Translated "Action Type"
   *
   * @return translated "Action Type"
   */
   @DefaultMessage("Action Type")
   @Key("tour_tourStepWizardActionTypeTitle")
   String tour_tourStepWizardActionTypeTitle();

  /**
   * Translated "Auto Complete"
   *
   * @return translated "Auto Complete"
   */
   @DefaultMessage("Auto Complete")
   @Key("tour_tourStepWizardAutoCompleteTitle")
   String tour_tourStepWizardAutoCompleteTitle();

  /**
   * Translated "Should the tour move forward when the user completes the chosen action?"
   *
   * @return translated "Should the tour move forward when the user completes the chosen action?"
   */
   @DefaultMessage("Should the tour move forward when the user completes the chosen action?")
   @Key("tour_tourStepWizardAutoCompletePrompt")
   String tour_tourStepWizardAutoCompletePrompt();

  /**
   * Translated "Drop Target"
   *
   * @return translated "Drop Target"
   */
   @DefaultMessage("Drop Target")
   @Key("tour_tourStepWizardDropTargetTitle")
   String tour_tourStepWizardDropTargetTitle();

  /**
   * Translated "No drop target"
   *
   * @return translated "No drop target"
   */
   @DefaultMessage("No drop target")
   @Key("tour_tourStepWizardDropTargetHint")
   String tour_tourStepWizardDropTargetHint();

  /**
   * Translated "Click icon, then Shift+Click within the application to add a drop target"
   *
   * @return translated "Click icon, then Shift+Click within the application to add a drop target"
   */
   @DefaultMessage("Click icon, then Shift+Click within the application to add a drop target")
   @Key("tour_tourStepWizardDropTargetPrompt")
   String tour_tourStepWizardDropTargetPrompt();

  /**
   * Translated "Shift+Click on the app to record a drop target locator"
   *
   * @return translated "Shift+Click on the app to record a drop target locator"
   */
   @DefaultMessage("Shift+Click on the app to record a drop target locator")
   @Key("tour_tourStepWizardDropTargetNotifyText")
   String tour_tourStepWizardDropTargetNotifyText();

  /**
   * Translated "Expected Value"
   *
   * @return translated "Expected Value"
   */
   @DefaultMessage("Expected Value")
   @Key("tour_tourStepWizardExpectedValueTitle")
   String tour_tourStepWizardExpectedValueTitle();

  /**
   * Translated "Value for the user to enter"
   *
   * @return translated "Value for the user to enter"
   */
   @DefaultMessage("Value for the user to enter")
   @Key("tour_tourStepWizardExpectedValueHint")
   String tour_tourStepWizardExpectedValueHint();

  /**
   * Translated "Case Sensitive"
   *
   * @return translated "Case Sensitive"
   */
   @DefaultMessage("Case Sensitive")
   @Key("tour_tourStepWizardCaseSensitiveTitle")
   String tour_tourStepWizardCaseSensitiveTitle();

  /**
   * Translated "Bind Output"
   *
   * @return translated "Bind Output"
   */
   @DefaultMessage("Bind Output")
   @Key("tour_tourStepWizardBindOutputTitle")
   String tour_tourStepWizardBindOutputTitle();

  /**
   * Translated "Bind to variable for later use"
   *
   * @return translated "Bind to variable for later use"
   */
   @DefaultMessage("Bind to variable for later use")
   @Key("tour_tourStepWizardBindOutputHint")
   String tour_tourStepWizardBindOutputHint();

  /**
   * Translated "Record Tour Step"
   *
   * @return translated "Record Tour Step"
   */
   @DefaultMessage("Record Tour Step")
   @Key("tour_tourStepWizardRecordStepTitle")
   String tour_tourStepWizardRecordStepTitle();

  /**
   * Translated "Drag this window out of the way to get at UI within the application"
   *
   * @return translated "Drag this window out of the way to get at UI within the application"
   */
   @DefaultMessage("Drag this window out of the way to get at UI within the application")
   @Key("tour_tourStepWizardRecordStepHeaderPrompt")
   String tour_tourStepWizardRecordStepHeaderPrompt();

  /**
   * Translated "Next Step"
   *
   * @return translated "Next Step"
   */
   @DefaultMessage("Next Step")
   @Key("tour_tourStepWizardNextStepButtonTitle")
   String tour_tourStepWizardNextStepButtonTitle();

  /**
   * Translated "Done"
   *
   * @return translated "Done"
   */
   @DefaultMessage("Done")
   @Key("tour_tourStepWizardDoneButtonTitle")
   String tour_tourStepWizardDoneButtonTitle();

  /**
   * Translated "New Tour Recording Complete"
   *
   * @return translated "New Tour Recording Complete"
   */
   @DefaultMessage("New Tour Recording Complete")
   @Key("tour_tourCompleteTitle")
   String tour_tourCompleteTitle();

  /**
   * Translated "Tour ID"
   *
   * @return translated "Tour ID"
   */
   @DefaultMessage("Tour ID")
   @Key("tour_tourCompleteTourIdTitle")
   String tour_tourCompleteTourIdTitle();

  /**
   * Translated "Make Changes..."
   *
   * @return translated "Make Changes..."
   */
   @DefaultMessage("Make Changes...")
   @Key("tour_tourCompleteMakeChangesButtonTitle")
   String tour_tourCompleteMakeChangesButtonTitle();

  /**
   * Translated "View XML"
   *
   * @return translated "View XML"
   */
   @DefaultMessage("View XML")
   @Key("tour_tourCompleteViewXMLButtonTitle")
   String tour_tourCompleteViewXMLButtonTitle();

  /**
   * Translated "Run Tour"
   *
   * @return translated "Run Tour"
   */
   @DefaultMessage("Run Tour")
   @Key("tour_tourCompleteRunTourButtonTitle")
   String tour_tourCompleteRunTourButtonTitle();

  /**
   * Translated "(No DataSource)"
   *
   * @return translated "(No DataSource)"
   */
   @DefaultMessage("(No DataSource)")
   @Key("operators_noDataSourceDescription")
   String operators_noDataSourceDescription();

  /**
   * Translated "AI is disabled."
   *
   * @return translated "AI is disabled."
   */
   @DefaultMessage("AI is disabled.")
   @Key("aI_aiIsDisabledErrorMessage")
   String aI_aiIsDisabledErrorMessage();

  /**
   * Translated "The default AI engine ''$defaultEngineId'' is not registered."
   *
   * @return translated "The default AI engine ''$defaultEngineId'' is not registered."
   */
   @DefaultMessage("The default AI engine ''$defaultEngineId'' is not registered.")
   @Key("aI_defaultAIEngineNotRegisteredErrorMessage")
   String aI_defaultAIEngineNotRegisteredErrorMessage();

  /**
   * Translated "No AI engine is registered which supports vision requests."
   *
   * @return translated "No AI engine is registered which supports vision requests."
   */
   @DefaultMessage("No AI engine is registered which supports vision requests.")
   @Key("aI_noAIEngineSupportingVisionRequestsIsRegisteredErrorMessage")
   String aI_noAIEngineSupportingVisionRequestsIsRegisteredErrorMessage();

  /**
   * Translated "There were no data sources available or found."
   *
   * @return translated "There were no data sources available or found."
   */
   @DefaultMessage("There were no data sources available or found.")
   @Key("aI_noDataSourcesAvailableOrFoundErrorMessage")
   String aI_noDataSourcesAvailableOrFoundErrorMessage();

  /**
   * Translated "Starting your request\u2026"
   *
   * @return translated "Starting your request\u2026"
   */
   @DefaultMessage("Starting your request\u2026")
   @Key("aI_startingYourRequestDetailMessage")
   String aI_startingYourRequestDetailMessage();

  /**
   * Translated "Since the data source has a large number of fields, AI will be asked to select which ones are likely to be relevant to your request."
   *
   * @return translated "Since the data source has a large number of fields, AI will be asked to select which ones are likely to be relevant to your request."
   */
   @DefaultMessage("Since the data source has a large number of fields, AI will be asked to select which ones are likely to be relevant to your request.")
   @Key("aI_willSubsetFieldsDetailMessage")
   String aI_willSubsetFieldsDetailMessage();

  /**
   * Translated "Finished the request to select the relevant fields."
   *
   * @return translated "Finished the request to select the relevant fields."
   */
   @DefaultMessage("Finished the request to select the relevant fields.")
   @Key("aI_finishedSubsettingFieldsDetailMessage")
   String aI_finishedSubsettingFieldsDetailMessage();

  /**
   * Translated "A globally-installed DataSource with a non-composite primary key is required."
   *
   * @return translated "A globally-installed DataSource with a non-composite primary key is required."
   */
   @DefaultMessage("A globally-installed DataSource with a non-composite primary key is required.")
   @Key("aI_dataSourceIsRequiredErrorMessage")
   String aI_dataSourceIsRequiredErrorMessage();

  /**
   * Translated "matches a natural language description of a filter, as determined by AI"
   *
   * @return translated "matches a natural language description of a filter, as determined by AI"
   */
   @DefaultMessage("matches a natural language description of a filter, as determined by AI")
   @Key("operators_aiFilterTitle")
   String operators_aiFilterTitle();

  /**
   * Translated "Filter via AI: "
   *
   * @return translated "Filter via AI: "
   */
   @DefaultMessage("Filter via AI: ")
   @Key("operators_aiFilterDescriptionPrefix")
   String operators_aiFilterDescriptionPrefix();

  /**
   * Translated "$animatedLoadingImage Applying $numCriteria filter(s) on $numRecords record(s)&hellip;"
   *
   * @return translated "$animatedLoadingImage Applying $numCriteria filter(s) on $numRecords record(s)&hellip;"
   */
   @DefaultMessage("$animatedLoadingImage Applying $numCriteria filter(s) on $numRecords record(s)&hellip;")
   @Key("dataBoundComponent_applyingAsyncCriteriaMessage")
   String dataBoundComponent_applyingAsyncCriteriaMessage();

  /**
   * Translated "$animatedLoadingImage Re-applying $numCriteria filter(s) on $numRecords record(s)&hellip;"
   *
   * @return translated "$animatedLoadingImage Re-applying $numCriteria filter(s) on $numRecords record(s)&hellip;"
   */
   @DefaultMessage("$animatedLoadingImage Re-applying $numCriteria filter(s) on $numRecords record(s)&hellip;")
   @Key("dataBoundComponent_reapplyingAsyncCriteriaMessage")
   String dataBoundComponent_reapplyingAsyncCriteriaMessage();

  /* dataBoundComponent_aiMaxRecordsMessage value modified on Mon Jul  8 09:56:08 2024
   Old value was 'AI-based processes can only be performed with less than $aiMaxRecords records'.
   See definition later in this file for new value.
  */

  /**
   * Translated "This value is being computed."
   *
   * @return translated "This value is being computed."
   */
   @DefaultMessage("This value is being computed.")
   @Key("dataBoundComponent_asyncValueHover")
   String dataBoundComponent_asyncValueHover();

  /**
   * Translated "An error occurred during computation of this value."
   *
   * @return translated "An error occurred during computation of this value."
   */
   @DefaultMessage("An error occurred during computation of this value.")
   @Key("dataBoundComponent_defaultAsyncErrorHover")
   String dataBoundComponent_defaultAsyncErrorHover();

  /**
   * Translated "!"
   *
   * @return translated "!"
   */
   @DefaultMessage("!")
   @Key("dataBoundComponent_asyncErrorValue")
   String dataBoundComponent_asyncErrorValue();

  /**
   * Translated "The $ancestorGenerationAdjective operation was canceled."
   *
   * @return translated "The $ancestorGenerationAdjective operation was canceled."
   */
   @DefaultMessage("The $ancestorGenerationAdjective operation was canceled.")
   @Key("cancellationController_ancestorCanceledReasonGeneric")
   String cancellationController_ancestorCanceledReasonGeneric();

  /* cancellationController_ancestorCanceledReason value modified on Sat Jun  1 20:52:21 2024
   Old value was 'The $ancestorGenerationAdjective operation was canceled.'.
   See definition later in this file for new value.
  */

  /**
   * Translated "The user requested cancellation."
   *
   * @return translated "The user requested cancellation."
   */
   @DefaultMessage("The user requested cancellation.")
   @Key("cancellationController_canceledByUserReason")
   String cancellationController_canceledByUserReason();

  /**
   * Translated "Changes by user $userId during session:"
   *
   * @return translated "Changes by user $userId during session:"
   */
   @DefaultMessage("Changes by user $userId during session:")
   @Key("deploymentUsageViewer_sessionAuditPickerTitle")
   String deploymentUsageViewer_sessionAuditPickerTitle();

  /**
   * Translated "Building via AI\u2026"
   *
   * @return translated "Building via AI\u2026"
   */
   @DefaultMessage("Building via AI\u2026")
   @Key("buildViaAIProgressDialog_title")
   String buildViaAIProgressDialog_title();

  /**
   * Translated "Building UI via AI&hellip;"
   *
   * @return translated "Building UI via AI&hellip;"
   */
   @DefaultMessage("Building UI via AI&hellip;")
   @Key("buildUIViaAIProgressDialog_title")
   String buildUIViaAIProgressDialog_title();

  /**
   * Translated "Filtering via AI&hellip;"
   *
   * @return translated "Filtering via AI&hellip;"
   */
   @DefaultMessage("Filtering via AI&hellip;")
   @Key("filterViaAIProgressDialog_title")
   String filterViaAIProgressDialog_title();

  /**
   * Translated "Hiliting via AI&hellip;"
   *
   * @return translated "Hiliting via AI&hellip;"
   */
   @DefaultMessage("Hiliting via AI&hellip;")
   @Key("hiliteViaAIProgressDialog_title")
   String hiliteViaAIProgressDialog_title();

  /**
   * Translated "Dynamic:"
   *
   * @return translated "Dynamic:"
   */
   @DefaultMessage("Dynamic:")
   @Key("dynamicValueMappingValueItem_dynamicValuePrefix")
   String dynamicValueMappingValueItem_dynamicValuePrefix();

  /**
   * Translated "You can''t drag an item into one of its children"
   *
   * @return translated "You can''t drag an item into one of its children"
   */
   @DefaultMessage("You can''t drag an item into one of its children")
   @Key("treeGrid_cantDragIntoChildMessage")
   String treeGrid_cantDragIntoChildMessage();

  /**
   * Translated "This drag operation would mean an item is a descendant of an existing item with the same ID"
   *
   * @return translated "This drag operation would mean an item is a descendant of an existing item with the same ID"
   */
   @DefaultMessage("This drag operation would mean an item is a descendant of an existing item with the same ID")
   @Key("treeGrid_childCannotBeItsOwnAncestorMessage")
   String treeGrid_childCannotBeItsOwnAncestorMessage();

  /**
   * Translated "Enter the new name for this facet value:"
   *
   * @return translated "Enter the new name for this facet value:"
   */
   @DefaultMessage("Enter the new name for this facet value:")
   @Key("cubeGrid_renameFacetValueMessage")
   String cubeGrid_renameFacetValueMessage();

  /**
   * Translated "Grouping is not supported for datasets of this size"
   *
   * @return translated "Grouping is not supported for datasets of this size"
   */
   @DefaultMessage("Grouping is not supported for datasets of this size")
   @Key("listGrid_disabledGroupByPrompt")
   String listGrid_disabledGroupByPrompt();

  /**
   * Translated "Grouping has been disabled. This data set is too large to apply grouping efficiently."
   *
   * @return translated "Grouping has been disabled. This data set is too large to apply grouping efficiently."
   */
   @DefaultMessage("Grouping has been disabled. This data set is too large to apply grouping efficiently.")
   @Key("listGrid_groupByMaxRecordsExceededMessage")
   String listGrid_groupByMaxRecordsExceededMessage();

  /**
   * Translated "Showing $rowRange of $rowCount rows"
   *
   * @return translated "Showing $rowRange of $rowCount rows"
   */
   @DefaultMessage("Showing $rowRange of $rowCount rows")
   @Key("listGrid_fullRowRangeDisplayValue")
   String listGrid_fullRowRangeDisplayValue();

  /**
   * Translated "$rowRange of $rowCount"
   *
   * @return translated "$rowRange of $rowCount"
   */
   @DefaultMessage("$rowRange of $rowCount")
   @Key("listGrid_briefRowRangeDisplayValue")
   String listGrid_briefRowRangeDisplayValue();

  /**
   * Translated "&nbsp;"
   *
   * @return translated "&nbsp;"
   */
   @DefaultMessage("&nbsp;")
   @Key("listGrid_emptyRowRangeDisplayValue")
   String listGrid_emptyRowRangeDisplayValue();

  /**
   * Translated "$startRow-$endRow"
   *
   * @return translated "$startRow-$endRow"
   */
   @DefaultMessage("$startRow-$endRow")
   @Key("listGrid_rowRangeFormat")
   String listGrid_rowRangeFormat();

  /**
   * Translated "many"
   *
   * @return translated "many"
   */
   @DefaultMessage("many")
   @Key("listGrid_unknownRowCountDisplayValue")
   String listGrid_unknownRowCountDisplayValue();

  /**
   * Translated "Filter via AI..."
   *
   * @return translated "Filter via AI..."
   */
   @DefaultMessage("Filter via AI...")
   @Key("listGrid_filterViaAIText")
   String listGrid_filterViaAIText();

  /**
   * Translated "Clear AI Filter"
   *
   * @return translated "Clear AI Filter"
   */
   @DefaultMessage("Clear AI Filter")
   @Key("listGrid_clearFilterViaAIText")
   String listGrid_clearFilterViaAIText();

  /**
   * Translated "Hilite via AI..."
   *
   * @return translated "Hilite via AI..."
   */
   @DefaultMessage("Hilite via AI...")
   @Key("listGrid_hiliteViaAIText")
   String listGrid_hiliteViaAIText();

  /**
   * Translated "Alternatively, you can use AI to help create a filter for you, by describing the criteria using natural language."
   *
   * @return translated "Alternatively, you can use AI to help create a filter for you, by describing the criteria using natural language."
   */
   @DefaultMessage("Alternatively, you can use AI to help create a filter for you, by describing the criteria using natural language.")
   @Key("listGrid_filterViaAIPanelInstructions")
   String listGrid_filterViaAIPanelInstructions();

  /**
   * Translated "Field criteria:"
   *
   * @return translated "Field criteria:"
   */
   @DefaultMessage("Field criteria:")
   @Key("listGrid_fieldCriteriaText")
   String listGrid_fieldCriteriaText();

  /**
   * Translated "Click to calculate row count"
   *
   * @return translated "Click to calculate row count"
   */
   @DefaultMessage("Click to calculate row count")
   @Key("rowRangeDisplay_requestRowCountPrompt")
   String rowRangeDisplay_requestRowCountPrompt();

  /**
   * Translated "Dynamic:"
   *
   * @return translated "Dynamic:"
   */
   @DefaultMessage("Dynamic:")
   @Key("filterBuilder_dynamicValuePrefix")
   String filterBuilder_dynamicValuePrefix();

  /**
   * Translated "Define field query"
   *
   * @return translated "Define field query"
   */
   @DefaultMessage("Define field query")
   @Key("filterBuilder_fieldQueryWindowTitle")
   String filterBuilder_fieldQueryWindowTitle();

  /**
   * Translated "Aggregation:"
   *
   * @return translated "Aggregation:"
   */
   @DefaultMessage("Aggregation:")
   @Key("filterBuilder_valueQueryPrefix")
   String filterBuilder_valueQueryPrefix();

  /**
   * Translated "Select dynamic value"
   *
   * @return translated "Select dynamic value"
   */
   @DefaultMessage("Select dynamic value")
   @Key("filterBuilder_valueQueryButtonPrompt")
   String filterBuilder_valueQueryButtonPrompt();

  /**
   * Translated "Define value query for field $fieldTitle"
   *
   * @return translated "Define value query for field $fieldTitle"
   */
   @DefaultMessage("Define value query for field $fieldTitle")
   @Key("filterBuilder_valueQueryWindowTitle")
   String filterBuilder_valueQueryWindowTitle();

  /**
   * Translated "None Except:"
   *
   * @return translated "None Except:"
   */
   @DefaultMessage("None Except:")
   @Key("multiPickerItem_useSelectedValuesPrefix")
   String multiPickerItem_useSelectedValuesPrefix();

  /**
   * Translated "All Except:"
   *
   * @return translated "All Except:"
   */
   @DefaultMessage("All Except:")
   @Key("multiPickerItem_useUnselectedValuesPrefix")
   String multiPickerItem_useUnselectedValuesPrefix();





  /*  Generated on Sat Jun  1 20:52:21 2024 */

  /**
   * Translated "An error occurred during an asynchronous operation: $errorMessage"
   *
   * @return translated "An error occurred during an asynchronous operation: $errorMessage"
   */
   @DefaultMessage("An error occurred during an asynchronous operation: $errorMessage")
   @Key("asyncUtil_asyncErrorMessage")
   String asyncUtil_asyncErrorMessage();

  /**
   * Translated "An asynchronous operation was canceled with reason: $cancellationReason"
   *
   * @return translated "An asynchronous operation was canceled with reason: $cancellationReason"
   */
   @DefaultMessage("An asynchronous operation was canceled with reason: $cancellationReason")
   @Key("asyncUtil_asyncCanceledMessage")
   String asyncUtil_asyncCanceledMessage();

  /**
   * Translated "An asynchronous operation resulted in type ''$type''."
   *
   * @return translated "An asynchronous operation resulted in type ''$type''."
   */
   @DefaultMessage("An asynchronous operation resulted in type ''$type''.")
   @Key("asyncUtil_asyncOtherTypeMessage")
   String asyncUtil_asyncOtherTypeMessage();

  /**
   * Translated "The $ancestorGenerationAdjective operation was canceled: $ancestorCancellationReason"
   *
   * @return translated "The $ancestorGenerationAdjective operation was canceled: $ancestorCancellationReason"
   */
   @DefaultMessage("The $ancestorGenerationAdjective operation was canceled: $ancestorCancellationReason")
   @Key("cancellationController_ancestorCanceledReason")
   String cancellationController_ancestorCanceledReason();





  /*  Generated on Mon Jun  3 16:01:35 2024 */

  /**
   * Translated "AI is not able to process your request."
   *
   * @return translated "AI is not able to process your request."
   */
   @DefaultMessage("AI is not able to process your request.")
   @Key("aI_aiNotAbleToProcessRequestErrorMessage")
   String aI_aiNotAbleToProcessRequestErrorMessage();





  /*  Generated on Wed Jun 12 14:23:33 2024 */

  /**
   * Translated "The filter includes too many tree nodes; please specify a more restrictive filter"
   *
   * @return translated "The filter includes too many tree nodes; please specify a more restrictive filter"
   */
   @DefaultMessage("The filter includes too many tree nodes; please specify a more restrictive filter")
   @Key("rPCManager_keepParentsOnFilterMaxNodesExceededMessage")
   String rPCManager_keepParentsOnFilterMaxNodesExceededMessage();

  /* dataBoundComponent_asyncValueHoverContents value modified on Wed Sep 11 18:05:44 2024
   Old value was 'This value is being computed.'.
   See definition later in this file for new value.
  */

  /* dataBoundComponent_defaultAsyncErrorHoverContents value modified on Wed Sep 11 18:05:44 2024
   Old value was 'An error occurred during computation of this value.'.
   See definition later in this file for new value.
  */

  /**
   * Translated "<b><i>Retrieving summary from AI...</i></b>"
   *
   * @return translated "<b><i>Retrieving summary from AI...</i></b>"
   */
   @DefaultMessage("<b><i>Retrieving summary from AI...</i></b>")
   @Key("listGrid_placeholderAIHoverContents")
   String listGrid_placeholderAIHoverContents();

  /**
   * Translated "<b>AI-generated summary:</b><br>"
   *
   * @return translated "<b>AI-generated summary:</b><br>"
   */
   @DefaultMessage("<b>AI-generated summary:</b><br>")
   @Key("listGrid_aiHoverContentsPrefix")
   String listGrid_aiHoverContentsPrefix();

  /**
   * Translated "(Empty)"
   *
   * @return translated "(Empty)"
   */
   @DefaultMessage("(Empty)")
   @Key("listGrid_emptyAIHoverContents")
   String listGrid_emptyAIHoverContents();





  /*  Generated on Mon Jun 17 16:13:27 2024 */

  /* aggregationEditor_groupByPickerHint value modified on Mon Jun 17 16:24:24 2024
   Old value was 'Select field...'.
   See definition later in this file for new value.
  */





  /*  Generated on Mon Jun 17 16:24:25 2024 */

  /**
   * Translated "Select fields..."
   *
   * @return translated "Select fields..."
   */
   @DefaultMessage("Select fields...")
   @Key("aggregationEditor_groupByPickerHint")
   String aggregationEditor_groupByPickerHint();





  /*  Generated on Mon Jul  8 09:56:08 2024 */

  /**
   * Translated "`$paramName` is required."
   *
   * @return translated "`$paramName` is required."
   */
   @DefaultMessage("`$paramName` is required.")
   @Key("aI_missingRequiredParameterErrorMessage")
   String aI_missingRequiredParameterErrorMessage();

  /* dataBoundComponent_aiMaxRecordsMessage value modified on Tue Oct 15 09:42:38 2024
   Old value was 'AI-based processes can only be performed with less than $aiMaxRecords records.'.
   See definition later in this file for new value.
  */

  /**
   * Translated "Pick the value of the"
   *
   * @return translated "Pick the value of the"
   */
   @DefaultMessage("Pick the value of the")
   @Key("aggregationEditor_outputFieldPrefixMessage")
   String aggregationEditor_outputFieldPrefixMessage();

  /**
   * Translated "field from the first record"
   *
   * @return translated "field from the first record"
   */
   @DefaultMessage("field from the first record")
   @Key("aggregationEditor_outputFieldSuffixMessage")
   String aggregationEditor_outputFieldSuffixMessage();

  /**
   * Translated "Advanced.."
   *
   * @return translated "Advanced.."
   */
   @DefaultMessage("Advanced..")
   @Key("sortByEditor_advancedSortMessage")
   String sortByEditor_advancedSortMessage();





  /*  Generated on Wed Jul 17 13:56:39 2024 */

  /**
   * Translated "[Rule Context values]"
   *
   * @return translated "[Rule Context values]"
   */
   @DefaultMessage("[Rule Context values]")
   @Key("formulaBuilder_ruleContextTitle")
   String formulaBuilder_ruleContextTitle();





  /*  Generated on Fri Jul 19 09:14:45 2024 */

  /**
   * Translated "Component $componentID''s dataSource was changed."
   *
   * @return translated "Component $componentID''s dataSource was changed."
   */
   @DefaultMessage("Component $componentID''s dataSource was changed.")
   @Key("cancellationController_componentDataSourceWasChangedReason")
   String cancellationController_componentDataSourceWasChangedReason();

  /* cancellationController_componentFieldsWereChangedReason value modified on Tue Jul 30 11:18:52 2024
   Old value was 'Component $componentID''s fields were changed.'.
   See definition later in this file for new value.
  */

  /**
   * Translated "Save &amp; Add Another"
   *
   * @return translated "Save &amp; Add Another"
   */
   @DefaultMessage("Save &amp; Add Another")
   @Key("formulaBuilder_saveAddAnotherButtonTitle")
   String formulaBuilder_saveAddAnotherButtonTitle();

  /**
   * Translated "Another test was requested."
   *
   * @return translated "Another test was requested."
   */
   @DefaultMessage("Another test was requested.")
   @Key("formulaBuilder_anotherTestRequestedCancellationReason")
   String formulaBuilder_anotherTestRequestedCancellationReason();

  /**
   * Translated "The user has saved."
   *
   * @return translated "The user has saved."
   */
   @DefaultMessage("The user has saved.")
   @Key("formulaBuilder_userSavedCancellationReason")
   String formulaBuilder_userSavedCancellationReason();





  /*  Generated on Fri Jul 19 14:20:36 2024 */

  /**
   * Translated "An asynchronous operation resulted in an unspecified type of result."
   *
   * @return translated "An asynchronous operation resulted in an unspecified type of result."
   */
   @DefaultMessage("An asynchronous operation resulted in an unspecified type of result.")
   @Key("asyncUtil_asyncNonSuccessMessageGeneric")
   String asyncUtil_asyncNonSuccessMessageGeneric();

  /**
   * Translated "An asynchronous operation resulted in type ''$type''."
   *
   * @return translated "An asynchronous operation resulted in type ''$type''."
   */
   @DefaultMessage("An asynchronous operation resulted in type ''$type''.")
   @Key("asyncUtil_asyncNonSuccessMessage")
   String asyncUtil_asyncNonSuccessMessage();

  /**
   * Translated "!"
   *
   * @return translated "!"
   */
   @DefaultMessage("!")
   @Key("listGrid_asyncErrorCellValue")
   String listGrid_asyncErrorCellValue();

  /**
   * Translated "-"
   *
   * @return translated "-"
   */
   @DefaultMessage("-")
   @Key("listGrid_asyncMissingCellValue")
   String listGrid_asyncMissingCellValue();





  /*  Generated on Fri Jul 26 11:31:30 2024 */

  /**
   * Translated "$animatedLoadingImage Filtering and sorting $numRecords record(s)&hellip;"
   *
   * @return translated "$animatedLoadingImage Filtering and sorting $numRecords record(s)&hellip;"
   */
   @DefaultMessage("$animatedLoadingImage Filtering and sorting $numRecords record(s)&hellip;")
   @Key("dataBoundComponent_applyingAsyncFilterAndSortMessage")
   String dataBoundComponent_applyingAsyncFilterAndSortMessage();

  /* dataBoundComponent_reapplyingAsyncFilterAndSortMessage value modified on Mon Aug 19 19:30:07 2024
   Old value was '$animatedLoadingImage Re-applying filtering and sorting $numRecords record(s)&hellip;'.
   See definition later in this file for new value.
  */

  /* listGrid_aiSortFieldMaxRecordsMessage value modified on Tue Oct 15 09:42:38 2024
   Old value was 'AI-based sorting can only be performed with less than $aiSortMaxRecords records.'.
   See definition later in this file for new value.
  */





  /*  Generated on Mon Jul 29 14:45:19 2024 */

  /**
   * Translated "Remove view"
   *
   * @return translated "Remove view"
   */
   @DefaultMessage("Remove view")
   @Key("savedSearchItem_removeSearchHoverText")
   String savedSearchItem_removeSearchHoverText();

  /**
   * Translated "Copy view"
   *
   * @return translated "Copy view"
   */
   @DefaultMessage("Copy view")
   @Key("savedSearchItem_copySearchHoverText")
   String savedSearchItem_copySearchHoverText();

  /**
   * Translated "Set as default view"
   *
   * @return translated "Set as default view"
   */
   @DefaultMessage("Set as default view")
   @Key("savedSearchItem_markAsDefaultHoverText")
   String savedSearchItem_markAsDefaultHoverText();

  /**
   * Translated "Set as default view for all users<br><br><i>[May be overridden by users'' own preferences.]</i>"
   *
   * @return translated "Set as default view for all users<br><br><i>[May be overridden by users'' own preferences.]</i>"
   */
   @DefaultMessage("Set as default view for all users<br><br><i>[May be overridden by users'' own preferences.]</i>")
   @Key("savedSearchItem_markAsAdminDefaultHoverText")
   String savedSearchItem_markAsAdminDefaultHoverText();

  /**
   * Translated "Remove saved view ''$title''?"
   *
   * @return translated "Remove saved view ''$title''?"
   */
   @DefaultMessage("Remove saved view ''$title''?")
   @Key("savedSearchItem_confirmRemovalMessage")
   String savedSearchItem_confirmRemovalMessage();

  /**
   * Translated "Shared view (all users will see it)"
   *
   * @return translated "Shared view (all users will see it)"
   */
   @DefaultMessage("Shared view (all users will see it)")
   @Key("savedSearchEditor_sharedSearchTitle")
   String savedSearchEditor_sharedSearchTitle();

  /**
   * Translated "Enter a name for your Saved View, then enter criteria below."
   *
   * @return translated "Enter a name for your Saved View, then enter criteria below."
   */
   @DefaultMessage("Enter a name for your Saved View, then enter criteria below.")
   @Key("savedSearchEditor_addSearchText")
   String savedSearchEditor_addSearchText();

  /**
   * Translated "Enter a name for your Saved View. The current configuration and filter criteria of the grid will be saved."
   *
   * @return translated "Enter a name for your Saved View. The current configuration and filter criteria of the grid will be saved."
   */
   @DefaultMessage("Enter a name for your Saved View. The current configuration and filter criteria of the grid will be saved.")
   @Key("savedSearchEditor_gridAddSearchText")
   String savedSearchEditor_gridAddSearchText();

  /**
   * Translated "Enter a new name for your Saved View, and edit criteria below."
   *
   * @return translated "Enter a new name for your Saved View, and edit criteria below."
   */
   @DefaultMessage("Enter a new name for your Saved View, and edit criteria below.")
   @Key("savedSearchEditor_editSearchText")
   String savedSearchEditor_editSearchText();

  /**
   * Translated "There is already a shared Saved View with this name - Overwrite?"
   *
   * @return translated "There is already a shared Saved View with this name - Overwrite?"
   */
   @DefaultMessage("There is already a shared Saved View with this name - Overwrite?")
   @Key("savedSearchEditor_overwriteSharedSearchConfirmationMessage")
   String savedSearchEditor_overwriteSharedSearchConfirmationMessage();

  /**
   * Translated "There is already a Saved View with this name - Overwrite?"
   *
   * @return translated "There is already a Saved View with this name - Overwrite?"
   */
   @DefaultMessage("There is already a Saved View with this name - Overwrite?")
   @Key("savedSearchEditor_overwriteSearchConfirmationMessage")
   String savedSearchEditor_overwriteSearchConfirmationMessage();

  /**
   * Translated "Save View Configuration"
   *
   * @return translated "Save View Configuration"
   */
   @DefaultMessage("Save View Configuration")
   @Key("editSearchWindow_title")
   String editSearchWindow_title();

  /**
   * Translated "Save View Configuration"
   *
   * @return translated "Save View Configuration"
   */
   @DefaultMessage("Save View Configuration")
   @Key("savedSearchItem_editSearchHoverText")
   String savedSearchItem_editSearchHoverText();

  /**
   * Translated "Views"
   *
   * @return translated "Views"
   */
   @DefaultMessage("Views")
   @Key("savedSearchItem_title")
   String savedSearchItem_title();

  /**
   * Translated "Saved views..."
   *
   * @return translated "Saved views..."
   */
   @DefaultMessage("Saved views...")
   @Key("savedSearchItem_hint")
   String savedSearchItem_hint();





  /*  Generated on Tue Jul 30 11:18:52 2024 */

  /**
   * Translated "Fields were added or removed from component $componentID."
   *
   * @return translated "Fields were added or removed from component $componentID."
   */
   @DefaultMessage("Fields were added or removed from component $componentID.")
   @Key("cancellationController_componentFieldsWereChangedReason")
   String cancellationController_componentFieldsWereChangedReason();

  /* aIFieldBuilder_instructionsTextStart value modified on Tue Jul 30 14:33:53 2024
   Old value was 'Enter a description of what information you want to see in the field.  AI will receive the complete record and be asked to generate a value for the record in the field.<p>AI can do things like:<ul><li>text summarization (&quot;give a two line summary of the abstract&quot; or &quot;list the applicant''s top 3 skills&quot; or &quot;extract any urgent request within the message&quot;)<li>sentiment analysis (&quot;rate the customer''s satisfaction on a scale of 1 (least satisfied) to 10 (most satisfied) based on their review&quot;)<li>use common knowledge (&quot;guess the contact''s time zone&quot;)</ul>'.
   See definition later in this file for new value.
  */

  /* aISortFieldBuilder_instructionsTextStart value modified on Tue Jul 30 14:33:53 2024
   Old value was 'Enter a description of what information you want to sort by.  AI will receive the complete record and be asked to generate a value for the record.<p>Some examples:<ul><li>&quot;guess how heavy the item is in pounds: ''Less than 1'', ''1-4'', ''5-10'', ''More than 10''&quot;<li>&quot;rate the customer''s satisfaction on a scale of 1 (least satisfied) to 10 (most satisfied) based on their review&quot;<li>&quot;rate the item''s usefulness in running a small bakery&quot;</ul>'.
   See definition later in this file for new value.
  */

  /**
   * Translated "AI-Generated Sort Field"
   *
   * @return translated "AI-Generated Sort Field"
   */
   @DefaultMessage("AI-Generated Sort Field")
   @Key("listGrid_aiSortFieldBuilderWindowTitle")
   String listGrid_aiSortFieldBuilderWindowTitle();





  /*  Generated on Tue Jul 30 14:33:53 2024 */

  /**
   * Translated "Enter a description of what information you want to see in the field.  AI will receive the complete record and be asked to generate a value for the record in the field.<p>AI can do things like:<ul><li>text summarization (<q>give a two line summary of the abstract</q> or <q>list the applicant''s top 3 skills</q> or <q>extract any urgent request within the message</q>)<li>sentiment analysis (<q>rate the customer''s satisfaction on a scale of 1 (least satisfied) to 10 (most satisfied) based on their review</q>)<li>use common knowledge (<q>guess the contact''s time zone</q>)</ul>"
   *
   * @return translated "Enter a description of what information you want to see in the field.  AI will receive the complete record and be asked to generate a value for the record in the field.<p>AI can do things like:<ul><li>text summarization (<q>give a two line summary of the abstract</q> or <q>list the applicant''s top 3 skills</q> or <q>extract any urgent request within the message</q>)<li>sentiment analysis (<q>rate the customer''s satisfaction on a scale of 1 (least satisfied) to 10 (most satisfied) based on their review</q>)<li>use common knowledge (<q>guess the contact''s time zone</q>)</ul>"
   */
   @DefaultMessage("Enter a description of what information you want to see in the field.  AI will receive the complete record and be asked to generate a value for the record in the field.<p>AI can do things like:<ul><li>text summarization (<q>give a two line summary of the abstract</q> or <q>list the applicant''s top 3 skills</q> or <q>extract any urgent request within the message</q>)<li>sentiment analysis (<q>rate the customer''s satisfaction on a scale of 1 (least satisfied) to 10 (most satisfied) based on their review</q>)<li>use common knowledge (<q>guess the contact''s time zone</q>)</ul>")
   @Key("aIFieldBuilder_instructionsTextStart")
   String aIFieldBuilder_instructionsTextStart();

  /* aISortFieldBuilder_instructionsTextStart value modified on Tue Jul 30 14:39:10 2024
   Old value was 'Enter a description of what information you want to sort by.  AI will receive the complete record and be asked to generate a value for the record.<p>Some examples:<ul><li><q>guess how heavy the item is in pounds: ''Less than 1'', ''1-4'', ''5-10'', ''More than 10''</q><li><q>rate the customer''s satisfaction on a scale of 1 (least satisfied) to 10 (most satisfied) based on their review</q><li><q>rate the item''s usefulness in running a small bakery</q></ul>'.
   See definition later in this file for new value.
  */





  /*  Generated on Tue Jul 30 14:39:10 2024 */

  /* aISortFieldBuilder_instructionsTextStart value modified on Tue Jul 30 14:45:33 2024
   Old value was 'Enter a description of what information you want to sort by.  AI will receive the complete record and be asked to generate a value for the record.<p>Some examples:<ul><li><q>guess how heavy the item is in pounds: ''Less than 1'', ''1-4'', ''5-10'', ''More than 10''&nbsp;</q><li><q>rate the customer''s satisfaction on a scale of 1 (least satisfied) to 10 (most satisfied) based on their review</q><li><q>rate the item''s usefulness in running a small bakery</q></ul>'.
   See definition later in this file for new value.
  */





  /*  Generated on Tue Jul 30 14:45:33 2024 */

  /**
   * Translated "Enter a description of what information you want to sort by.  AI will receive the complete record and be asked to generate a value for the record.<p>Some examples:<ul><li><q>guess how heavy the item is in pounds: ''Less than 1'', ''1-4'', ''5-10'', ''More than 10''&#8201;</q><li><q>rate the customer''s satisfaction on a scale of 1 (least satisfied) to 10 (most satisfied) based on their review</q><li><q>rate the item''s usefulness in running a small bakery</q></ul>"
   *
   * @return translated "Enter a description of what information you want to sort by.  AI will receive the complete record and be asked to generate a value for the record.<p>Some examples:<ul><li><q>guess how heavy the item is in pounds: ''Less than 1'', ''1-4'', ''5-10'', ''More than 10''&#8201;</q><li><q>rate the customer''s satisfaction on a scale of 1 (least satisfied) to 10 (most satisfied) based on their review</q><li><q>rate the item''s usefulness in running a small bakery</q></ul>"
   */
   @DefaultMessage("Enter a description of what information you want to sort by.  AI will receive the complete record and be asked to generate a value for the record.<p>Some examples:<ul><li><q>guess how heavy the item is in pounds: ''Less than 1'', ''1-4'', ''5-10'', ''More than 10''&#8201;</q><li><q>rate the customer''s satisfaction on a scale of 1 (least satisfied) to 10 (most satisfied) based on their review</q><li><q>rate the item''s usefulness in running a small bakery</q></ul>")
   @Key("aISortFieldBuilder_instructionsTextStart")
   String aISortFieldBuilder_instructionsTextStart();





  /*  Generated on Wed Jul 31 17:59:52 2024 */

  /**
   * Translated "[use AI-generated title]"
   *
   * @return translated "[use AI-generated title]"
   */
   @DefaultMessage("[use AI-generated title]")
   @Key("aIFieldBuilder_initialAutoSuggestTitleHint")
   String aIFieldBuilder_initialAutoSuggestTitleHint();

  /**
   * Translated "[generating a title…]"
   *
   * @return translated "[generating a title…]"
   */
   @DefaultMessage("[generating a title…]")
   @Key("aIFieldBuilder_pendingSuggestTitleHint")
   String aIFieldBuilder_pendingSuggestTitleHint();

  /* aIFieldBuilder_nonSuccessfulSuggestTitleHint value modified on Wed Aug  7 11:17:24 2024
   Old value was '[failed to generate a title: $asyncMessage]'.
   See definition later in this file for new value.
  */

  /**
   * Translated "[AI-generated: $suggestedTitle]"
   *
   * @return translated "[AI-generated: $suggestedTitle]"
   */
   @DefaultMessage("[AI-generated: $suggestedTitle]")
   @Key("aIFieldBuilder_suggestedTitleHint")
   String aIFieldBuilder_suggestedTitleHint();

  /**
   * Translated "Another suggested title was requested."
   *
   * @return translated "Another suggested title was requested."
   */
   @DefaultMessage("Another suggested title was requested.")
   @Key("aIFieldBuilder_anotherSuggestedTitleRequestedCancellationReason")
   String aIFieldBuilder_anotherSuggestedTitleRequestedCancellationReason();





  /*  Generated on Wed Aug  7 11:17:24 2024 */

  /**
   * Translated "[failed to generate a title: $message]"
   *
   * @return translated "[failed to generate a title: $message]"
   */
   @DefaultMessage("[failed to generate a title: $message]")
   @Key("aIFieldBuilder_nonSuccessfulSuggestTitleHint")
   String aIFieldBuilder_nonSuccessfulSuggestTitleHint();

  /**
   * Translated "Click to have AI generate a value from your description"
   *
   * @return translated "Click to have AI generate a value from your description"
   */
   @DefaultMessage("Click to have AI generate a value from your description")
   @Key("aIFieldBuilder_testButtonHoverContents")
   String aIFieldBuilder_testButtonHoverContents();

  /**
   * Translated "You cannot try having AI generate a value at this time."
   *
   * @return translated "You cannot try having AI generate a value at this time."
   */
   @DefaultMessage("You cannot try having AI generate a value at this time.")
   @Key("aIFieldBuilder_testButtonHoverContents_cantTest")
   String aIFieldBuilder_testButtonHoverContents_cantTest();

  /**
   * Translated "Without data, you cannot try having AI generate a value."
   *
   * @return translated "Without data, you cannot try having AI generate a value."
   */
   @DefaultMessage("Without data, you cannot try having AI generate a value.")
   @Key("aIFieldBuilder_testButtonHoverContents_cantTestWithoutData")
   String aIFieldBuilder_testButtonHoverContents_cantTestWithoutData();

  /**
   * Translated "Click to test the formula"
   *
   * @return translated "Click to test the formula"
   */
   @DefaultMessage("Click to test the formula")
   @Key("formulaBuilder_testButtonHoverContents")
   String formulaBuilder_testButtonHoverContents();

  /**
   * Translated "You cannot test the formula at this time."
   *
   * @return translated "You cannot test the formula at this time."
   */
   @DefaultMessage("You cannot test the formula at this time.")
   @Key("formulaBuilder_testButtonHoverContents_cantTest")
   String formulaBuilder_testButtonHoverContents_cantTest();

  /**
   * Translated "Click to test the summary"
   *
   * @return translated "Click to test the summary"
   */
   @DefaultMessage("Click to test the summary")
   @Key("summaryBuilder_testButtonHoverContents")
   String summaryBuilder_testButtonHoverContents();

  /**
   * Translated "You cannot test the summary at this time."
   *
   * @return translated "You cannot test the summary at this time."
   */
   @DefaultMessage("You cannot test the summary at this time.")
   @Key("summaryBuilder_testButtonHoverContents_cantTest")
   String summaryBuilder_testButtonHoverContents_cantTest();





  /*  Generated on Fri Aug  9 01:15:21 2024 */

  /**
   * Translated "$monthName"
   *
   * @return translated "$monthName"
   */
   @DefaultMessage("$monthName")
   @Key("calendar_monthButtonTitle")
   String calendar_monthButtonTitle();





  /*  Generated on Mon Aug 19 19:30:07 2024 */

  /* asyncUtil_missingRequiredParameterErrorMessage value modified on Tue Oct 15 09:42:38 2024
   Old value was '`$paramName` is required.'.
   See definition later in this file for new value.
  */

  /**
   * Translated "$animatedLoadingImage Re-filtering and sorting $numRecords record(s)&hellip;"
   *
   * @return translated "$animatedLoadingImage Re-filtering and sorting $numRecords record(s)&hellip;"
   */
   @DefaultMessage("$animatedLoadingImage Re-filtering and sorting $numRecords record(s)&hellip;")
   @Key("dataBoundComponent_reapplyingAsyncFilterAndSortMessage")
   String dataBoundComponent_reapplyingAsyncFilterAndSortMessage();





  /*  Generated on Tue Sep 10 10:48:49 2024 */

  /**
   * Translated "[Unspecified non-successful result type]"
   *
   * @return translated "[Unspecified non-successful result type]"
   */
   @DefaultMessage("[Unspecified non-successful result type]")
   @Key("asyncUtil_unspecifiedTypeRawMessage")
   String asyncUtil_unspecifiedTypeRawMessage();

  /**
   * Translated "[Unhandled non-successful result type ''$resultType'']"
   *
   * @return translated "[Unhandled non-successful result type ''$resultType'']"
   */
   @DefaultMessage("[Unhandled non-successful result type ''$resultType'']")
   @Key("asyncUtil_unhandledTypeRawMessage")
   String asyncUtil_unhandledTypeRawMessage();

  /**
   * Translated "Pick the value of the"
   *
   * @return translated "Pick the value of the"
   */
   @DefaultMessage("Pick the value of the")
   @Key("aggregationEditor_emptyClauseOutputPrefixMessage")
   String aggregationEditor_emptyClauseOutputPrefixMessage();

  /**
   * Translated "field from the first record"
   *
   * @return translated "field from the first record"
   */
   @DefaultMessage("field from the first record")
   @Key("aggregationEditor_emptyClauseOutputSuffixMessage")
   String aggregationEditor_emptyClauseOutputSuffixMessage();

  /**
   * Translated "Pick the value of the"
   *
   * @return translated "Pick the value of the"
   */
   @DefaultMessage("Pick the value of the")
   @Key("aggregationEditor_queryOutputPrefixMessage")
   String aggregationEditor_queryOutputPrefixMessage();

  /**
   * Translated "field from the first record"
   *
   * @return translated "field from the first record"
   */
   @DefaultMessage("field from the first record")
   @Key("aggregationEditor_queryOutputSuffixMessage")
   String aggregationEditor_queryOutputSuffixMessage();

  /**
   * Translated "Related field:"
   *
   * @return translated "Related field:"
   */
   @DefaultMessage("Related field:")
   @Key("filterBuilder_valueQueryRelatedFieldPrefix")
   String filterBuilder_valueQueryRelatedFieldPrefix();

  /**
   * Translated "Aggregation:"
   *
   * @return translated "Aggregation:"
   */
   @DefaultMessage("Aggregation:")
   @Key("filterBuilder_valueQueryAggregatePrefix")
   String filterBuilder_valueQueryAggregatePrefix();

  /**
   * Translated "Define related field value query"
   *
   * @return translated "Define related field value query"
   */
   @DefaultMessage("Define related field value query")
   @Key("filterBuilder_valueQueryRelatedFieldButtonPrompt")
   String filterBuilder_valueQueryRelatedFieldButtonPrompt();

  /**
   * Translated "Define aggregate value query"
   *
   * @return translated "Define aggregate value query"
   */
   @DefaultMessage("Define aggregate value query")
   @Key("filterBuilder_valueQueryAggregateButtonPrompt")
   String filterBuilder_valueQueryAggregateButtonPrompt();





  /*  Generated on Wed Sep 11 18:05:44 2024 */

  /**
   * Translated "<b><i>Generating the content of this hover&hellip;</i></b>"
   *
   * @return translated "<b><i>Generating the content of this hover&hellip;</i></b>"
   */
   @DefaultMessage("<b><i>Generating the content of this hover&hellip;</i></b>")
   @Key("dataBoundComponent_placeholderGeneratedHoverContents")
   String dataBoundComponent_placeholderGeneratedHoverContents();

  /**
   * Translated "(Empty)"
   *
   * @return translated "(Empty)"
   */
   @DefaultMessage("(Empty)")
   @Key("dataBoundComponent_emptyGeneratedHoverContents")
   String dataBoundComponent_emptyGeneratedHoverContents();

  /**
   * Translated "An error occurred while generating the content of this hover."
   *
   * @return translated "An error occurred while generating the content of this hover."
   */
   @DefaultMessage("An error occurred while generating the content of this hover.")
   @Key("dataBoundComponent_defaultGeneratedHoverAsyncErrorContents")
   String dataBoundComponent_defaultGeneratedHoverAsyncErrorContents();

  /**
   * Translated "This value is being generated."
   *
   * @return translated "This value is being generated."
   */
   @DefaultMessage("This value is being generated.")
   @Key("dataBoundComponent_asyncValueHoverContents")
   String dataBoundComponent_asyncValueHoverContents();

  /**
   * Translated "An error occurred during generation of this value."
   *
   * @return translated "An error occurred during generation of this value."
   */
   @DefaultMessage("An error occurred during generation of this value.")
   @Key("dataBoundComponent_defaultAsyncErrorHoverContents")
   String dataBoundComponent_defaultAsyncErrorHoverContents();





  /*  Generated on Thu Sep 12 01:16:29 2024 */

  /* calendar_eventAllDayFieldTitle value modified on Thu Sep 12 02:34:04 2024
   Old value was 'All Day'.
   See definition later in this file for new value.
  */





  /*  Generated on Thu Sep 12 02:34:04 2024 */

  /* calendar_eventAllDayFieldTitle value modified on Thu Sep 12 03:18:19 2024
   Old value was 'All Day event'.
   See definition later in this file for new value.
  */





  /*  Generated on Thu Sep 12 03:18:20 2024 */

  /* calendar_eventAllDayFieldTitle value modified on Thu Sep 12 03:35:08 2024
   Old value was 'All Day events'.
   See definition later in this file for new value.
  */





  /*  Generated on Thu Sep 12 03:35:08 2024 */

  /**
   * Translated "All Day"
   *
   * @return translated "All Day"
   */
   @DefaultMessage("All Day")
   @Key("calendar_eventAllDayFieldTitle")
   String calendar_eventAllDayFieldTitle();





  /*  Generated on Sat Sep 21 12:15:48 2024 */

  /**
   * Translated "AI is disabled."
   *
   * @return translated "AI is disabled."
   */
   @DefaultMessage("AI is disabled.")
   @Key("aI_aiIsDisabledMessage")
   String aI_aiIsDisabledMessage();

  /**
   * Translated "List style"
   *
   * @return translated "List style"
   */
   @DefaultMessage("List style")
   @Key("listPropertiesPane_sampleTileLayoutAriaLabel")
   String listPropertiesPane_sampleTileLayoutAriaLabel();





  /*  Generated on Sat Sep 21 12:47:44 2024 */

  /* asyncUtil_asyncDisabledMessageGeneric value modified on Fri Oct 11 19:21:15 2024
   Old value was 'An asynchronous operation is disabled.'.
   See definition later in this file for new value.
  */





  /*  Generated on Fri Oct 11 19:21:15 2024 */

  /**
   * Translated "Data were being fetched."
   *
   * @return translated "Data were being fetched."
   */
   @DefaultMessage("Data were being fetched.")
   @Key("asyncUtil_dataBeingFetchedDisabledMessage")
   String asyncUtil_dataBeingFetchedDisabledMessage();

  /**
   * Translated "An asynchronous operation was disabled."
   *
   * @return translated "An asynchronous operation was disabled."
   */
   @DefaultMessage("An asynchronous operation was disabled.")
   @Key("asyncUtil_asyncDisabledMessageGeneric")
   String asyncUtil_asyncDisabledMessageGeneric();

  /**
   * Translated "valueMap normalization"
   *
   * @return translated "valueMap normalization"
   */
   @DefaultMessage("valueMap normalization")
   @Key("sortSpecifierUtil_valueMapNormalizationDescription")
   String sortSpecifierUtil_valueMapNormalizationDescription();

  /**
   * Translated "custom normalization"
   *
   * @return translated "custom normalization"
   */
   @DefaultMessage("custom normalization")
   @Key("sortSpecifierUtil_customNormalizationDescription")
   String sortSpecifierUtil_customNormalizationDescription();

  /**
   * Translated ", with $normalizationDescription"
   *
   * @return translated ", with $normalizationDescription"
   */
   @DefaultMessage(", with $normalizationDescription")
   @Key("sortSpecifierUtil_normalizationDescriptionSuffix")
   String sortSpecifierUtil_normalizationDescriptionSuffix();

  /**
   * Translated "$propertyTitle in ascending order"
   *
   * @return translated "$propertyTitle in ascending order"
   */
   @DefaultMessage("$propertyTitle in ascending order")
   @Key("sortSpecifierUtil_ascendingSortDescription")
   String sortSpecifierUtil_ascendingSortDescription();

  /**
   * Translated "$propertyTitle in descending order"
   *
   * @return translated "$propertyTitle in descending order"
   */
   @DefaultMessage("$propertyTitle in descending order")
   @Key("sortSpecifierUtil_descendingSortDescription")
   String sortSpecifierUtil_descendingSortDescription();

  /**
   * Translated "AI was disabled."
   *
   * @return translated "AI was disabled."
   */
   @DefaultMessage("AI was disabled.")
   @Key("aI_aiWasDisabledMessage")
   String aI_aiWasDisabledMessage();

  /**
   * Translated "[Unknown field]"
   *
   * @return translated "[Unknown field]"
   */
   @DefaultMessage("[Unknown field]")
   @Key("dataBoundComponent_unknownFieldTitle")
   String dataBoundComponent_unknownFieldTitle();





  /*  Generated on Tue Oct 15 09:42:38 2024 */

  /**
   * Translated "<code>$paramName</code> is required."
   *
   * @return translated "<code>$paramName</code> is required."
   */
   @DefaultMessage("<code>$paramName</code> is required.")
   @Key("asyncUtil_missingRequiredParameterErrorMessage")
   String asyncUtil_missingRequiredParameterErrorMessage();

  /**
   * Translated "Data were being fetched."
   *
   * @return translated "Data were being fetched."
   */
   @DefaultMessage("Data were being fetched.")
   @Key("asyncUtil_dataBeingFetchedMessage")
   String asyncUtil_dataBeingFetchedMessage();

  /**
   * Translated "The following filter(s) have been disabled:<ul>"
   *
   * @return translated "The following filter(s) have been disabled:<ul>"
   */
   @DefaultMessage("The following filter(s) have been disabled:<ul>")
   @Key("dataBoundComponent_asyncFiltersDisabledNotifyContents_begin")
   String dataBoundComponent_asyncFiltersDisabledNotifyContents_begin();

  /**
   * Translated "There were too many records for AI to process; the number of records exceeded the limit of $aiMaxRecords records."
   *
   * @return translated "There were too many records for AI to process; the number of records exceeded the limit of $aiMaxRecords records."
   */
   @DefaultMessage("There were too many records for AI to process; the number of records exceeded the limit of $aiMaxRecords records.")
   @Key("dataBoundComponent_aiMaxRecordsMessage")
   String dataBoundComponent_aiMaxRecordsMessage();

  /**
   * Translated "There were too many records to sort using AI; the number of records exceeded the limit of $aiSortFieldMaxRecords records."
   *
   * @return translated "There were too many records to sort using AI; the number of records exceeded the limit of $aiSortFieldMaxRecords records."
   */
   @DefaultMessage("There were too many records to sort using AI; the number of records exceeded the limit of $aiSortFieldMaxRecords records.")
   @Key("listGrid_aiSortFieldMaxRecordsMessage")
   String listGrid_aiSortFieldMaxRecordsMessage();





  /*  Generated on Tue Oct 15 10:21:48 2024 */

  /**
   * Translated "The generation of missing values for the $fieldTitle field was not successful: $errorMessage"
   *
   * @return translated "The generation of missing values for the $fieldTitle field was not successful: $errorMessage"
   */
   @DefaultMessage("The generation of missing values for the $fieldTitle field was not successful: $errorMessage")
   @Key("resultSet_prerequisiteFieldGenerationNotSuccessfulErrorMessage")
   String resultSet_prerequisiteFieldGenerationNotSuccessfulErrorMessage();





  /*  Generated on Tue Oct 22 12:54:55 2024 */

  /**
   * Translated "[Unknown field]"
   *
   * @return translated "[Unknown field]"
   */
   @DefaultMessage("[Unknown field]")
   @Key("class_unknownFieldTitle")
   String class_unknownFieldTitle();





  /*  Generated on Tue Oct 22 12:58:29 2024 */

  /* class_unnamedFieldTitle value modified on Tue Oct 22 13:08:22 2024
   Old value was '[Unnamed field]'.
   See definition later in this file for new value.
  */





  /*  Generated on Tue Oct 22 13:08:22 2024 */

  /* class_unnamedFieldTitle value modified on Tue Oct 22 13:10:46 2024
   Old value was '[Un-named field]'.
   See definition later in this file for new value.
  */





  /*  Generated on Tue Oct 22 13:10:46 2024 */

  /**
   * Translated "[Unnamed field]"
   *
   * @return translated "[Unnamed field]"
   */
   @DefaultMessage("[Unnamed field]")
   @Key("class_unnamedFieldTitle")
   String class_unnamedFieldTitle();





  /*  Generated on Mon Feb 24 03:31:27 2025 */

  /**
   * Translated "Must be a relative-date."
   *
   * @return translated "Must be a relative-date."
   */
   @DefaultMessage("Must be a relative-date.")
   @Key("validator_notARelativeDate")
   String validator_notARelativeDate();

  /**
   * Translated "Must be a date or relative-date."
   *
   * @return translated "Must be a date or relative-date."
   */
   @DefaultMessage("Must be a date or relative-date.")
   @Key("validator_notADateOrRelativeDate")
   String validator_notADateOrRelativeDate();





  /*  Generated on Thu Aug 21 08:53:33 2025 */

  /**
   * Translated "New Event"
   *
   * @return translated "New Event"
   */
   @DefaultMessage("New Event")
   @Key("calendar_newLongEventName")
   String calendar_newLongEventName();

  /**
   * Translated "Configure via AI..."
   *
   * @return translated "Configure via AI..."
   */
   @DefaultMessage("Configure via AI...")
   @Key("listGrid_configureViaAIText")
   String listGrid_configureViaAIText();



}
