package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * Indicates the mode to use for resolving templated references in a DataSource's configuration file.  See {@link
 * com.smartgwt.client.docs.serverds.DataSource#allowTemplateReferences DataSource.allowTemplateReferences} for an overview
 * of configuration  templating.
 */
public enum DataSourceTemplateReferenceMode implements ValueEnum {
    /**
     * Indicates that no resolution of templated references should be done
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "none".
     */
    NONE("none"),
    /**
     * Indicates that a simple find-and-replace process should resolve templated references. In
     *  this mode, the system looks for references strictly like the one below, and replaces them
     *  with the referenced property from your <code>server.properties</code> file. So if your 
     *  <code>server.properties</code> file contained an entry like this:<pre>
     *  database.name: MyDatabase
     *  </pre>
     *  the below example would cause <code>dbName</code> to be resolved as <code>MyDatabase</code><pre>
     *  dbName="$config['database.name']"
     *  </pre>
     *  (Note, you can use a different token than "<code>$config</code>" if you need to - see 
     *  {@link com.smartgwt.client.docs.serverds.DataSource#templateConfigToken templateConfigToken})
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "configOnly".
     */
    CONFIGONLY("configOnly"),
    /**
     * Indicates that full Velocity processing will be used to resolve templated references. This allows you to use all of
     * Velocity's template-handling features - for example, conditional  blocks and iteration - and so is more powerful than
     * the simple "configOnly" option above. Note, however, that this templating is necessarily limited by the fact that it
     * takes place  during DataSource initialization, when there is not a lot of context available for  templating purposes -
     * you have the "<code>$config</code>" object, as with "configOnly", and some of the other variables listed in the {@link
     * com.smartgwt.client.docs.VelocitySupport Velocity overview},  but nothing relating to {@link
     * com.smartgwt.client.data.DSRequest}s
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "all".
     */
    ALL("all");
    private String value;

    DataSourceTemplateReferenceMode(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
