
/*
 * Isomorphic Smart GWT web presentation layer
 * Copyright 2000 and beyond Isomorphic Software, Inc.
 *
 * OWNERSHIP NOTICE
 * Isomorphic Software owns and reserves all rights not expressly granted in this source code,
 * including all intellectual property rights to the structure, sequence, and format of this code
 * and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.
 *
 *  If you have any questions, please email <sourcecode@isomorphic.com>.
 *
 *  This entire comment must accompany any portion of Isomorphic Software source code that is
 *  copied or moved from this file.
 */
/* sgwtgen */
package com.smartgwt.client.docs.serverds;

import com.smartgwt.client.types.*;
import com.smartgwt.client.data.DSRequest;
import com.smartgwt.client.data.DSResponse;
import com.smartgwt.client.docs.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.widgets.form.fields.FormItem;
import java.util.List;
import java.util.Map;

/**
 * Metadata about a DataSourceField, including its type and validators.<p>
 * <b>This class is not meant to be created and used, it is actually documentation of settings
 * allowed in a DataSource descriptor (.ds.xml file), for use with Smart GWT Pro Edition and
 * above.
 * See {@link com.smartgwt.client.docs.serverds} for how to use this documentation.</b>
 * <p>
 */
public class DataSourceField {

    /**
     * Indicates that values for this field are automatically generated by the database or ORM 
     * provider.  Setting this flag makes the field behave somewhat like a  {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#sequenceName sequence field}, in that
     * server-side logic does not expect client code to provide values for the field on "add"
     * operations.  However, it is not entirely the same as a sequence:<ul> <li>Sequences must be
     * integers, whereas autoGenerated fields can be of any type</li> <li>Smart GWT Server's
     * DataSource implementations are capable of discovering the value      that was generated by the
     * database for sequence fields, which may not be possible      with an autoGenerated field.  See
     * the docs for      {@link com.smartgwt.client.data.DataSourceField#getCustomInsertExpression
     * customInsertExpression} for a discussion     of this</li> </ul> Unrelated to the
     * <code>autoGenerated</code> flag, you have a general ability for field  values to be generated
     * by application code (as opposed to being generated by the database or ORM provider).  For
     * example, you can use {@link com.smartgwt.client.docs.DmiOverview DMI methods},  {@link
     * com.smartgwt.client.docs.ServerScript server scripts}, or {@link
     * com.smartgwt.client.docs.CustomQuerying custom SQL}.  (Note,  if you want to have application
     * code generate values for primaryKey fields, you may need to use an {@link
     * com.smartgwt.client.docs.serverds.OperationBinding operationBinding} that specifies  {@link
     * com.smartgwt.client.docs.serverds.OperationBinding#providesMissingKeys providesMissingKeys}).
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.serverds.DataSourceField#sequenceName
     * @see com.smartgwt.client.types.FieldType
     * @see com.smartgwt.client.types.SequenceMode
     */
    public Boolean autoGenerated;

    /**
     * When true, this field can only be used for sorting if the data is entirely client-side.
     *
     * <p>Default value is false
     */
    public boolean canSortClientOnly;

    /**
     * See {@link com.smartgwt.client.docs.serverds.DataSource#tableCode DataSource.tableCode}.
     *
     * <p>Default value is null
     */
    public String columnCode;

    /**
     * A {@link com.smartgwt.client.types.ValueMap} is a set of legal values for a field.
     *  <p>
     *  The valueMap can be specified as either an Array of legal values, or as an
     *  {@link java.lang.Object} where each property maps a stored value to a user-displayable value.
     *  <p>
     *  To enforce that a field should be constrained to only the values in the valueMap, either
     * declare {@link com.smartgwt.client.docs.serverds.DataSourceField#type field.type} as "enum", or
     * use a
     * {@link com.smartgwt.client.types.ValidatorType} of "isOneOf" with explicitly listed values. 
     * Otherwise,
     * although a normal {@link com.smartgwt.client.widgets.form.fields.SelectItem} control will only
     * allow values from the valueMap to be
     * entered, other controls such as a {@link com.smartgwt.client.widgets.form.fields.ComboBoxItem
     * ComboBox} will allow other values 
     *  to be entered.
     *  <p>
     *  In XML, a valueMap that specifies only a list of legal values is specified as follows:
     *  <pre>
     *    &lt;valueMap&gt;
     *     &lt;value&gt;Pens &amp; Pencils&lt;/value&gt;
     *     &lt;value&gt;Stationery&lt;/value&gt;
     *     &lt;value&gt;Computer Products&lt;/value&gt;
     *     &lt;value&gt;Furniture&lt;/value&gt;
     *     &lt;value&gt;Misc&lt;/value&gt;
     *    &lt;/valueMap&gt;
     *  </pre>
     *  A ValueMap that specifies stored values mapped to user-visible values is specified as
     *  follows:
     *  <pre>
     *    &lt;valueMap&gt;
     *     &lt;value ID="1"&gt;Pens &amp; Pencils&lt;/value&gt;
     *     &lt;value ID="2"&gt;Stationery&lt;/value&gt;
     *     &lt;value ID="3"&gt;Computer Products&lt;/value&gt;
     *     &lt;value ID="4"&gt;Furniture&lt;/value&gt;
     *     &lt;value ID="5"&gt;Misc&lt;/value&gt;
     *    &lt;/valueMap&gt;
     *  </pre>
     *
     * <p>Default value is null
     */
    public Map valueMap;

    /**
     * Whether a user must be authenticated in order to initialize to this field.  If this property is
     * set and the user is not authenticated, the Smart GWT Server will not allow this field to be
     * initialized.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.serverds.DataSourceField#editRequiresAuthentication
     * @see com.smartgwt.client.docs.FieldLevelAuth Field-Level Security
     */
    public Boolean initRequiresAuthentication;

    /**
     * Indicates that this field should be fetched from another, related DataSource.
     *  <P>
     *  The <code>includeFrom</code> attribute should be of the form
     *  "<i>dataSourceId</i>.<i>fieldName</i>", for example:
     *  <pre>
     *     &lt;field includeFrom="supplyItem.itemName"/&gt;
     *  </pre>
     *  <P>
     * A {@link com.smartgwt.client.docs.serverds.DataSourceField#foreignKey foreignKey} declaration
     * must exist between the two DataSources, establishing either
     *  a 1-to-1 relationship or a many-to-1 relationship from this DataSource to the related
     *  DataSource. The inclusion can be indirect (traverse multiple DataSources) so long as there
     *  is a chain of <code>foreignKey</code> declarations from the target DataSource to the
     *  DataSource where the <code>includeFrom</code> field is declared.  You may use dot-notation
     *  to provide an explicit path between DataSources, or provide the name of only the last
     *  DataSource in the chain to have the complete path calculated for you at runtime.
     *  i.e., either of the following are acceptable forms, where foreign keys
     *  are defined to link records in the current DataSource to Employee records and in turn to
     *  Office records:
     *  <pre>
     *    &lt;field includeFrom="Employee.Office.territory"/&gt;
     *    &lt;!-- OR --&gt;
     *    &lt;field includeFrom="Office.territory"/&gt;
     *  </pre>
     *  Note that when using the shorthand form, there is potential ambiguity: there could be
     *  multiple ways in which two DataSources are related via different intervening DataSources,
     *  so the auto-discovered relation may be different depending on which other DataSources are
     *  loaded in the page. For this reason, explicitly spelling out the inclusion path is
     *  preferred.
     *  <p>
     *  Nested inclusions, where an
     *  included field is itself an included field, are also supported - for details on this and
     * other complex scenarios see {@link com.smartgwt.client.docs.serverds.DataSourceField#includeVia
     * includeVia} docs.
     *  <P>
     * In all cases, {@link com.smartgwt.client.docs.serverds.DataSourceField#name name} will default
     * to the name of the included field,
     *  or you can specify a different name.
     *  <p>
     *  If both DataSources are SQLDataSources, HibernateDataSources or JPADataSources (with
     *  Hibernate as the provider) the related data will be retrieved via a SQL join and criteria
     *  and sort directions applied to the field work normally (they become part of the generated
     *  SQL query).
     *  <p>
     *  Note that includeFrom is also supported between two clientOnly or MockDataSources, but not
     *  for any other combination (for example, a RestDataSource cannot use includeFrom with a
     *  clientOnly DataSource).  Here, the related data (including any values derived via
     * {@link com.smartgwt.client.docs.serverds.DataSourceField#includeSummaryFunction
     * includeSummaryFunction}) will be retrieved from cacheData after the
     *  primary (fetch, add, or update) operation has returned its response.
     *  <P>
     *  Otherwise, the related data will be retrieved via performing a DSRequest against
     *  the related DataSource once the data from the primary DataSource has been retrieved.  In
     *  this case, criteria or sorting directions applied to the included field are only allowed if
     * data paging is not in use (for example {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataFetchMode ListGrid.dataFetchMode}:"basic");
     * otherwise,
     *  criteria and sort direction are ignored for the included field and a warning is logged on
     *  the server.
     *  <P>
     *  <b>Editing included fields</b>
     *  <p>
     * An included field is {@link com.smartgwt.client.docs.serverds.DataSourceField#canEdit
     * canEdit:false} by default.  Note that 
     *  included fields are not updatable, even if you set canEdit:true; the server will simply drop
     *  values for included fields if client code sends them. 
     *  <p>
     *  When thinking about editing an included field value, typically what is really intended is to
     *  edit the value of the <code>foreignKey</code> field.  For example, take the scenario of a
     *  system that tracks accounts and the employees assigned to manage them.  Given a DataSource
     *  "account" related one-to-one with DataSource "employee" by a "managerId" foreignKey field,
     *  we might declare an <code>includeFrom</code> so that the name of the account manager can
     *  be shown with each "account" record.  
     *  <p>
     *  Editing the manager's name while viewing the account would be intended to pick a new account
     *  manager, and <b>not</b> to change the legal name of the employee who happens to be the
     *  current account manager. 
     *  <p>
     *  To correctly set up this scenario, declare an <code>includeFrom</code> field that is hidden,
     * but is used as the {@link com.smartgwt.client.docs.serverds.DataSourceField#displayField
     * displayField} for the foreign key
     *  field:
     *  <pre>
     *  &lt;field name="managerId" foreignKey="employee.id" displayField="managerName" /&gt; 
     *  &lt;field name="managerName" includeFrom="employee.name" hidden="true"/&gt; 
     *  </pre>
     *  Now:
     *  <ul>
     *  <li> the "managerId" foreignKey field is shown in grids and forms, but takes its displayed
     *  value from the hidden <code>includeFrom</code> field. Note that when the
     *  <code>foreignKey</code> and <code>displayField</code> are specified, the 
     * framework automatically defaults {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#useLocalDisplayFieldValue
     * useLocalDisplayFieldValue} to 
     *  true to ensure the displayed value is picked up from the record being edited.
     *  <li> the automatically chosen editor will be a SelectItem with
     * {@link com.smartgwt.client.widgets.form.fields.SelectItem#getOptionDataSource optionDataSource}
     * set to "employees": it will allow
     *  picking a different "employee" record from the "employee" DataSource.
     *  <li> saving will save the ID of a new "employee" record to the "managerId" foreign key
     *  field, as intended
     *  </ul>
     * 
     *  You can alternatively set <code>editorType="ComboBoxItem"</code> on the
     *  "managerId" field to allow typeahead search of the "employee" DataSource.
     * Note that the {@link com.smartgwt.client.docs.serverds.DataSourceField#foreignDisplayField
     * foreignDisplayField} attribute allows developers to have a different
     *  fieldName be used locally as a displayField from the field name for the display field
     *  in the foreign dataSource.
     *  <P>
     *  <b>Including fields that use summary functions</b>
     *  <p>
     * The {@link com.smartgwt.client.docs.serverds.DataSourceField#includeSummaryFunction Include
     * Summary Function} feature is used
     *  for including from a related DataSource where there are multiple related records. It applies
     * a {@link com.smartgwt.client.types.SummaryFunctionType} to the related records aggregating them
     * into single value.
     *  It is regularly used on directly included fields, but it supports indirect inclusions as well,
     * when entire <code>includeFrom</code>+<code>includeSummaryFunction</code> setup is included from
     * another DataSource. See {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#includeSummaryFunction
     * includeSummaryFunction} docs for more details.
     *  <p>
     *  For best results, ensure that the field with <code>includeFrom</code> has its
     * {@link com.smartgwt.client.docs.serverds.DataSourceField#type type} explicitly set to the
     * included field's <code>type</code>.
     *  <P>
     * <b><code>includeFrom</code> combined with <code>{@link
     * com.smartgwt.client.docs.serverds.DataSourceField#multiple multiple}:true</code></b>
     *  <p>
     * If you specify <code>{@link com.smartgwt.client.docs.serverds.DataSourceField#multiple
     * multiple}:true</code> on an 
     *  <code>includeFrom</code> field, it has one of two quite different meanings:<ol>
     *  <li>It is including a field which is itself marked <code>multiple:true</code>, across a 
     * regular many-to-one or one-to-one {@link com.smartgwt.client.docs.DataSourceRelations
     * relation}.  In this case,
     *  the value of the included field is likely to be a flattened list of text values stored in a
     * regular text field - see {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#multipleStorage multipleStorage}</li>
     *  <li>It is including multiple related values across a one-to-many or many-to-many relation</li>
     *  </ol>
     *  The first of these is exactly the same as any other regular <code>includeFrom</code>, except
     *  that it will have normal <code>multiple:true</code> processing applied to the included 
     *  value, so the client sees a true list of values rather than a flat string of text.
     *  <p>
     *  The second is more involved.  With this type of <code>includeFrom</code> we will actually 
     *  fetch multiple records from the included DataSource.  You should read the <b>One-to-many</b>
     * and <b>Many-to-many</b> sections of the {@link com.smartgwt.client.docs.DataSourceRelations
     * relations overview}
     *  to make sure you understand how these relation types work, but essentially you declare a 
     * {@link com.smartgwt.client.docs.serverds.DataSourceField#foreignKey foreignKey} on a field that
     * is also marked 
     *  <code>multiple:true</code>, and this causes Smart GWT to return a list of key values that
     *  your client-side code can use to obtain the related records (some Smart GWT UI components
     *  will do this automatically).
     *  <p>
     *  Once one of these relation types is in place, it is also possible to declare 
     *  <code>includeFrom</code> fields that make use of the relation to include fields other than 
     *  the identifying key field, for convenience.  For example, if a <b>Country</b> dataSource
     *  declared a one-to-many relation to a <b>City</b> dataSource, like this:<pre>
     *      &lt;field name="majorCities" multiple="true" foreignKey="City.cityId" /&gt;
     *  </pre>
     *  The same dataSource could make use of that relation to include the names of all related
     *  cities for convenience, so you can show a list of "Major Cities" against each country without
     *  having to go back to the server and fetch the actual City records.  The declaration would 
     *  look like this:<pre>
     *      &lt;field name="cityNames" multiple="true" includeFrom="City.cityName" /&gt;
     *  </pre>
     *  With <b>Many-to-many</b> related includeFroms - which require a "middle" dataSource, and thus
     * a three-part <code>foreignKey</code> declaration - you may specify either the entire inclusion 
     *  path, or just the endpoint.  For example, if your <b>Country</b> dataSource has a 
     *  many-to-many relation with a <b>River</b> dataSource - necessary, because most countries 
     *  contain more than one river, and many rivers flow through more than one country - via the 
     *  following <code>foreignKey</code> definition:<pre>
     *      &lt;field name="rivers" multiple="true" foreignKey="CountryRivers.Rivers.riverId" /&gt;
     *  </pre>
     *  you could <code>includeFrom</code> the list of related river names with either this:<pre>
     *      &lt;field name="riverNames" multiple="true" includeFrom="CountryRivers.Rivers.name" /&gt;
     *  </pre> or slightly simpler, this:<pre>
     *      &lt;field name="riverNames" multiple="true" includeFrom="Rivers.name" /&gt;
     *  </pre>
     *  If just the endpoint is specified, Smart GWT will figure out the remainder of the path 
     *  based on the available <code>foreignKey</code>s; if there is ambiguity that makes this 
     *  impossible - ie, two <code>foreignKey</code> fields that target the same endpoint via 
     * different paths - you can either specify the entire include path in the
     * <code>includeFrom</code>
     * definition, or declare an {@link com.smartgwt.client.docs.serverds.DataSourceField#includeVia
     * includeVia} setting on the field.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.DataSourceRelations Relations
     */
    public String includeFrom;

    /**
     * For a {@link com.smartgwt.client.docs.SqlDataSource SQL DataSource} field that specifies a
     * {@link com.smartgwt.client.docs.serverds.DataSourceField#foreignKey foreignKey}, this property
     * defines the table alias name to use in generated SQL. <p> Aliasing is necessary when the same
     * table appears more than once in a query.  This can  happen when using {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#includeVia Multiple <code>includeFrom</code>
     * \n fields referring to the same related DataSource}.  It can also happen when a {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#foreignKey foreignKey} definition references
     * the same dataSource that the field is defined in; this happens with hierarchical structures,
     * for example where every Employee reports to another Employee, a so-called "self join", and it
     * <em>always</em> requires <code>relatedTableAlias</code> to be specified; failure to do so will
     * result in invalid SQL. <p> In case of indirect relationship, when more than single join is
     * needed to join the target table, and {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#includeVia includeVia} is missing, generated
     * alias is a concatenation of <code>relatedTableAlias</code> and FK field names starting with the
     * first <code>relatedTableAlias</code>  met in chain of relations leading to the target table.
     * <p> See the "Automatically generated table aliases" section of the {@link
     * com.smartgwt.client.docs.CustomQuerying SQL Templating} for more details.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.serverds.DataSource#relatedTableAlias
     * @see com.smartgwt.client.docs.serverds.DataSourceField#includeVia
     * @see com.smartgwt.client.docs.DataSourceRelations Relations
     */
    public String relatedTableAlias;

    /**
     * Indicates this field must be non-null in order for a record to pass validation. Or, in the
     *  case of a "binary" field, a non-empty file must be uploaded.  Setting this property has the
     * same effect as giving the field a {@link com.smartgwt.client.types.ValidatorType "required"
     * validator}. 
     *  <P>
     *  Note that <code>required</code> should not be set for a server-generated field, such as a
     *  sequence, or validation will fail on the client.
     *  <h3>Conditionally required fields</h3>
     * Adding an {@link com.smartgwt.client.docs.serverds.Validator#applyWhen applyWhen} condition to
     * a <code>required</code> 
     *  validator introduces subtle complexities to the process of validating an existing record.  
     *  The client is not guaranteed to know the full and complete state of the record it is 
     * editing because it is common for a {@link com.smartgwt.client.widgets.form.DynamicForm} to be
     * editing a subset of
     *  fields.  When a field is <i>unconditionally</i> required, things are simple: if the 
     * DynamicForm has a {@link com.smartgwt.client.widgets.form.fields.FormItem} for that field, then
     * the <code>required</code> validation
     *  passes if that FormItem has a value, and fails if it does not.  If the form has no FormItem
     *  for the field, it can assume that the field has a value because otherwise it would have 
     *  failed validation when we attempted to add it (when we are adding a record, we of course do 
     *  know the full and complete state of the record - it is whatever we are about to add).
     *  <p>
     *  When a field is <i>conditionally</i> required, the client can no longer assume that all 
     *  required fields will have a value.  It may be the case that the condition of requirement 
     *  was not met when the record was added, but now it is.  For example, consider these field
     *  definitions:<pre>
     *     &lt;field name="yearsAtCurrentAddress" type="integer" /&gt;
     *     &lt;field name="previousAddress" type="text" &gt;
     *       &lt;validator type="required" errorMessage="Previous address is required if you have been at your current address less than three years"&gt;
     *         &lt;applyWhen operator="and"&gt;
     *           &lt;criteria&gt;
     *             &lt;criterion fieldName="yearsAtCurrentAddress" operator="lessThan" value="3" /&gt;
     *           &lt;/criteria&gt;
     *         &lt;/applyWhen&gt;
     *       &lt;/validator&gt;
     *     &lt;/field&gt;
     *  </pre>
     *  Imagine a record for this DataSource is added where the user has entered a value of "3" for 
     *  "yearsAtCurrentAddress", and no previous address.  Later, the value of that field is 
     *  changed to "2".  If this is done using a form that is also showing the "previousAddress" 
     *  field, we will know that "previousAddress" has not been provided, so we can fail the 
     *  validation and the user will get a helpful error message explaining what the problem is.
     *  <p>
     *  However, if the form does not also show the "previousAddress" field, we may choose to use an
     * {@link com.smartgwt.client.docs.serverds.OperationBinding} that uses {@link
     * com.smartgwt.client.docs.serverds.OperationBinding#outputs outputs} to trim the
     *  record down to just the fields the form does contain, in the interests of avoiding 
     *  information leakage.  Or perhaps that value is automatically culled from the record before
     * the client sees it by the application of a {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#viewRequires declarative security rule}.
     *  Whatever the reason, if the client does not have the complete record, it is not possible 
     *  for the client to sensibly apply this validation.  And because the client has no way of 
     *  knowing if a value is missing because it is genuinely null, or because it has been trimmed
     *  away by the server, we must treat any null value with suspicion (unless it has a matching 
     *  FormItem - the presence of the FormItem means that the user can edit the value, so it 
     *  would make no sense to pair it with a trimmed record that excludes that field value).
     *  <p>
     *  When this happens, we mark the validation as having passed on the client, but in need of 
     *  running on the server.  The server validation makes use of the "storedRecord" facility 
     *  (look for the description of <b>$storedRecord</b> in the 
     * {@link com.smartgwt.client.docs.VelocitySupport Velocity support overview}) to overlay the
     * changed record on
     *  top of the existing record as it currently exists in the database.  This gives the validator
     *  the complete record including both changed and unchanged values, so it is able to carry 
     *  out the required check in a meaningful way.  However, you should be aware that the 
     *  combination of conditional "required" validators and DynamicForms that edit partial 
     *  records can result in a validation that cannot run on the client and must do both a server 
     *  roundtrip and a database fetch.
     *
     * <p>Default value is false
     * @see com.smartgwt.client.docs.serverds.Validator#applyWhen
     */
    public boolean required;

    /**
     * For a DataSource with {@link com.smartgwt.client.docs.serverds.DataSource#serverType
     * serverType:"sql"} with a field of type
     *  "sequence", the name of the SQL sequence that should be used when inserting new records into
     *  this table.
     *  <P>
     *  Note that this is never required for SQL tables that are generated from Smart GWT
     *  DataSources (a default sequence name of tableName + "_" + columnName is chosen, but see the
     *  notes below regarding this), and is never required for databases where inserting null into a 
     *  sequence column is sufficient (MySQL, SQL Server, DB2 and others). 
     *  <P>
     *  You would only need to set sequenceName if you are integrating with a pre-existing table
     *  stored in a database where the sequence must be named for insertion to work (Oracle,
     *  Postgres, Firebird) OR you are trying to use the same sequence across multiple DataSources.
     *  <P>
     *  <b>Note:</b> If you specify the <code>sql.{database type}.sequence.name.prefix</code> and/or 
     *  <code>sql.{database type}.sequence.name.suffix</code> properties in your 
     * {@link com.smartgwt.client.docs.Server_properties server.properties} file,the generated
     * sequence name will include the prefix and/or
     *  suffix.  For example, with a prefix of "order_system_" and a suffix of "_seq", the sequence
     *  generated for column "orderNumber" on table "orders" would be:<pre>
     *      order_system_orders_orderNumber_seq
     *  </pre>
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.SqlDataSource SQL DataSources
     */
    public String sequenceName;

    /**
     * When data values are displayed in DataBound components, by default strings will be interpreted
     * as HTML by the browser in most cases. <P> If set, this property will be picked up by components
     * bound to this dataSource, notifying them that any HTML characters should be escaped when
     * displaying values for this field.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGridField#getEscapeHTML
     */
    public Boolean escapeHTML;

    /**
     * Whether a user must be authenticated in order to update to this field.  If this property is 
     * set and the user is not authenticated, the Smart GWT Server will not allow this field to be
     * updated.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.serverds.DataSourceField#editRequiresAuthentication
     * @see com.smartgwt.client.docs.FieldLevelAuth Field-Level Security
     */
    public Boolean updateRequiresAuthentication;

    /**
     * An optional {@link com.smartgwt.client.docs.FormatString} for this field, for use when  {@link
     * com.smartgwt.client.widgets.DataBoundComponent#exportData exporting} data to spreadsheet
     * formats (XLS and  OOXML/XLSX), XML, JSON or CSV.   You can use this property to override the
     * normal {@link com.smartgwt.client.docs.serverds.DataSourceField#format format} of this field,
     * if any, specifically for exports, for both server-based and client-driven exports.  <p> Note,
     * for server-driven exports you can specify default formats for date, time and  datetime fields
     * by specifying properties <code>export.format.default.date</code>, 
     * <code>export.format.default.time</code> and <code>export.format.default.datetime</code> in your
     * <code>server.properties</code> file.  Similarly, default formats for float and integer fields
     * can be specified with <code>export.format.default.float</code> and 
     * <code>export.format.default.integer</code>, respectively.  These formats will be used for
     * fields that do not have a "format" or "exportFormat" property specified in the 
     * <code>.ds.xml</code> file. <p> Specifically when exporting to spreadsheet formats, the
     * <code>FormatString</code> is translated to the type of format string used by spreadsheet
     * programs like Excel.  A handful of features are not present in Excel format strings, and some
     * features behave slightly differently.  These differences are explained below. <p> <h3>Excel
     * cannot handle dates prior to January 1st 1900</h3> This is a well-known limitation of Excel
     * dates; it is not a formatting issue as such. <p> <h3>Currency symbols become fixed to the
     * current locale at export time</h3> The placeholder currency symbol "&#x00A4" (\u00A4) in a
     * numeric format string is rendered as the    localized currency symbol returned by GWT's
     * built-in NumberFormat class.  When exporting, the format string provided to Excel contains the
     * currency symbol for the current locale of the Smart GWT application, and not a placeholder
     * currency symbol that would make Excel pick up a currency symbol based on the operating system
     * locale.  We do this to ensure that the spreadsheet reflects the <em>application's</em>
     * localization, rather than the localization of the current user's computer, because they may be
     * different. <p> <h3>Rounding differences</h3> The approach to rounding a positive number to a
     * set number of decimal places is fairly  universally agreed upon for non-specialized
     * requirements: add 0.5 (or 0.05, or 0.005, or  whatever) to the number and then truncate.  This
     * leads to the well understood convention  that numbers exactly halfway between two possible
     * rounding outcomes, go to the larger one.  So 7.5 becomes 8 and 7.15 becomes 7.2. <p> However,
     * there is no such universal agreement when it come to rounding negative numbers.   Some take the
     * view that you should round by taking the number to the larger absolute value, so -7.15 becomes
     * -7.2.  Others feel that you should round by taking the number to the larger value in the sense
     * of it being "less negative", so -7.15 becomes -7.1. <p> Smart GWT formatting takes the first
     * approach and rounds negative numbers away from zero. We do this simply because that is what
     * Java DecimalFormat does.  Unfortunately, Excel does the opposite.  Therefore, you will see
     * rounding differences on negative numbers on exact  50% boundaries: Smart GWT will format -7.15
     * as -7.2, while Excel will format the same  value as -7.1. <p> <h3>Different treatment of
     * '#'</h3> Both Smart GWT and Excel use '#' to mean "digit, do not show zeroes".  However, Excel
     * does not implement this strictly in the integer part when the number it is formatting has a
     * value of 0 in the integer part.  So, with a format of "#.##", the value 0.25 is formatted  as
     * "0.25".  Smart GWT (like Java DecimalFormat) is strict: with that format, 0.25 is  formatted as
     * ".25"; if you want to match Excel's output, you must use the format "0.##". <p>
     * <h3>Miscellaneous edge cases</h3> There is quite a lot of variation in behavior between Java
     * DecimalFormat and Excel around  the edges.  For actual error cases - for example, a format
     * string that just contains  nonsense - it is normal and expected that the Smart GWT behavior and
     * the Excel behavior do not match - this is just two systems producing different garbage out for
     * the same  garbage in, which is to be expected.  For valid but weird usages - for example, a
     * format  with multiple percent signs - Smart GWT's formatting is in line with what DecimalFormat
     * does, unless DecimalFormat throws an Exception, in which case we just do the thing that  seems
     * most sensible, or the thing that was easiest to implement. <p> Known differences in behavior in
     * edge cases include:<ul> <li>Smart GWT ignores formatting characters in the number part of the
     * format string,  whereas Excel rejects the format (this behavior may vary with different
     * releases of Excel and supposedly compatible libraries: POI, for example, will accept such
     * format strings).   If you attempt to format 5.175 with the format string "#b0.#a#", Smart GWT
     * will return "5.72", and Excel will reject the format</li> <li>Smart GWT ignores quoted
     * characters in the number part of the format string,  whereas Excel preserves them.  If you
     * attempt to format 5.175 with the format string  "#'b'0.#'a'#", Smart GWT will return "5.72",
     * and Excel will return "b5.7a2"</li> <li>If you specify the empty string as a format string,
     * Smart GWT returns the result of  calling toString() on the number; Excel uses the built-in
     * "General" format.  These two  approaches will generally give the same or very similar results,
     * but that is really a  coincidence: the correct way to obtain matching results in the browser
     * and the spreadsheet is to specify a valid format string</li> <li>If you specify a format string
     * that contains no number part (ie, no '#' or '0'  characters), Smart GWT does what DecimalFormat
     * does, which is to output the integer part of the number alongside the fixed part of the format.
     * Excel just outputs the fixed part. So, if you attempt to format -5.3 with the format string
     * "'Hello world'", Smart GWT will output "-Hello world5", whereas Excel will output just "Hello
     * world"</li> <li>If you specify multiple percent signs in the format, Smart GWT treats all but
     * the  first one as static text, so 0.5 formatted with "#%%%" is "50%%%" (ie, all the signs are 
     * preserved but there is only one multiplcation by 100).  Excel multiplies for  each percent
     * sign, so 0.5 formatted with "#%%%" is "500000%%%"</li> </ul> <p> <h3>Date format functionality
     * not supported by Excel</h3> The following date/time/datetime functionality is not supported by
     * Excel; if you use  formatters that use any of this functionality, your values will be exported
     * to Excel  incorrectly formatted.  In cases like this, we recommend that you use a separate 
     * <code>exportFormat</code>, with the intent of exporting your values in a way that is  similar
     * to your application formatting (which would be specified with the  {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#format format} property), but within the
     * confines of what Excel  supports. <ul> <li>Fiscal year, week and day (LL, LLLL, C, CC, c,
     * cc)</li> <li>Week in year (w, ww)</li> <li>Day in year (D, DD)</li> <li>Day number in week
     * (u)</li> <li>Explicit control over whether to use 12- or 24-hour notation.  In Excel, this is 
     * implied by the presence or absence of the AM/PM designator</li> <li>If the user's operating
     * system locale is different to the locale in use in the  Smart GWT application, day and month
     * names may be different in the spreadsheet</li> </ul> <h3>Number format functionality not
     * supported by Excel</h3> The only Smart GWT number-formatting functionality not supported for 
     * export to Excel is "multiply by 1000 and show as per mille". <p> <h3>Limit on number of custom
     * Excel formats</h3> Excel limits the number of custom format strings in a single spreadsheet to
     * somewhere between 200 and 250, depending on your locale and language.  Hitting this limit in an
     * export would require hundreds of field definitions, each defining unique
     * <code>FormatStrings</code>.  If you do hit the limit, the only workaround is to use fewer
     * unique <code>FormatStrings</code>. <p> <h3>Controlling number format</h3> If we give Excel a
     * formatted number like "500,000" it will not treat that value as a number, so sums and other
     * basic spreadsheet features won't work. So we use the heuristic that if your formatted value
     * parses as a number, you probably want it treated as a number in the spreadsheet, so we give
     * Excel the unformatted numeric value and tell Excel it's a numeric data value. <p> You might
     * expect that we would give Excel <i>both</i> the formatted value and the numeric value, but this
     * is only possible by creating what's called a "custom format" for that cell, which as the
     * section above mentions, is limited in that only a few hundred can be created. <p> With this
     * Excel limitation in mind, it makes sense to just go with the default behavior. If you decide
     * otherwise, one option is to use  {@link
     * com.smartgwt.client.data.DSRequest#getExportNumbersAsFormattedString
     * exportNumbersAsFormattedString}, but see the docs for that property for the drawbacks of doing
     * this.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.serverds.DataSourceField#format
     */
    public FormatString exportFormat;

    /**
     * An optional description of the DataSourceField's meaning.  Not automatically exposed on any
     * component, but useful for developer documentation, and as such is included on any {@link
     * com.smartgwt.client.docs.OpenapiSupport OpenAPI specification} generated by the framework. 
     * Markdown is a commonly used syntax, but you may also embed HTML content in a CDATA tag.
     *
     * <p>Default value is null
     */
    public String description;

    /**
     * Default user-visible title for this field. <p> This will be picked up by {@link
     * com.smartgwt.client.widgets.DataBoundComponent}s and other views over this data source. <p>
     * Note this property frequently does not need to be set since {@link
     * com.smartgwt.client.docs.serverds.DataSource#autoDeriveTitles DataSource.autoDeriveTitles} (on
     * by default) usually picks an appropriate user-visible title if you have a reasonable naming
     * convention for your field names. <P> Note that if this field is being displayed in a {@link
     * com.smartgwt.client.widgets.grid.ListGrid} bound to this data source, the {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getHeaderTitle ListGridField.headerTitle}
     * attribute may be used to specify a different string for display in the column header.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.data.Field#getExportTitle
     * @see com.smartgwt.client.docs.ComponentBinding Component Binding
     */
    public HTMLString title;

    /**
     * For fields that are {@link com.smartgwt.client.docs.serverds.DataSourceField#multiple
     * multiple:true} and use {@link com.smartgwt.client.docs.serverds.DataSourceField#multipleStorage
     * multipleStorage}, the separator used in the "simpleString" {@link
     * com.smartgwt.client.types.MultipleFieldStorage} mode. <p> Default value of null means the
     * {@link com.smartgwt.client.docs.serverds.DataSourceField#multipleValueSeparator
     * multipleValueSeparator} is used instead. <p> NOTE: "simpleString" storage concatenates the
     * stringified forms of each of the multiple  values together, delimited with the
     * <code>multipleStorageSeparator</code> character(s).  If you use this storage mode with String
     * values that themselves contain the  <code>multipleStorageSeparator</code>, they will not be
     * correctly retrieved.  To avoid this, use a multi-character delimiter that is not likely to
     * occur in regular text, or switch to "json" storage
     *
     * <p>Default value is null
     */
    public String multipleStorageSeparator;

    /**
     * See {@link com.smartgwt.client.docs.serverds.DataSourceField#javaClass javaClass} - when
     * auto-populating of Java Beans / POJOs based on  inbound DSRequest data, for a field of type
     * Collection or Map,  <code>javaCollectionClass</code> can  be used to specify a particular
     * concrete class to use.  If not specified, and a concrete Collection or Map class cannot be
     * discovered using Java Reflection, the following concrete classes are used: <ul> <li>
     * <code>java.util.ArrayList</code> is used for fields of type <code>List</code> <li>
     * <code>java.util.HashSet</code> is used for fields of type <code>Set</code> <li>
     * <code>java.util.LinkedList</code> is used for fields of type <code>Queue</code> <li>
     * <code>java.util.LinkedHashMap</code> is used for fields of type <code>Map</code> <li>
     * <code>java.util.ArrayList</code> is used for fields that are otherwise of type
     * <code>Collection</code> </ul> Note that this value is used even if the target Collection or Map
     * is declared as a concrete class.  So, for example, if you set <code>javaCollectionClass</code>
     * to  <code>java.util.LinkedList</code> but your setter method accepts a 
     * <code>java.util.ArrayList</code>, you will get a ClassCastException.
     *
     * <p>Default value is null
     */
    public String javaCollectionClass;

    /**
     * Indicates that normal declarative security rules specified on this field are waived for  rows
     * that were created by the current user, as described in the discussion of  {@link
     * com.smartgwt.client.docs.serverds.DataSource#creatorOverrides dataSource.creatorOverrides}. 
     * This setting overrides  <code>dataSource.creatorOverrides</code>, for this field only. <p> Note
     * that field-level <code>creatorOverrides</code> is conceptually slightly different to the
     * setting at DataSource and OperationBinding levels.  To give the example of a fetch  operation,
     * at the other two levels, it results in a limited set of rows being returned,  rather than a
     * security exception being thrown.  At the field-level, it results in values  for individual
     * fields being present in those rows, rather than them being stripped out on the server.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.serverds.DataSourceField#editRequires
     * @see com.smartgwt.client.docs.serverds.DataSourceField#viewRequires
     * @see com.smartgwt.client.docs.serverds.DataSource#creatorOverrides
     * @see com.smartgwt.client.docs.FieldLevelAuth Field-Level Security
     */
    public Boolean creatorOverrides;

    /**
     * Sets the default FormItem to be used for this field if it appears in a filter row, and {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#canFilter canFilter} is not false. <P> Note:
     * If this is not specified, the edit-formItem type may be derived from the {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#editorType editorType} property, or from the
     * field's {@link com.smartgwt.client.docs.serverds.DataSourceField#type type}.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.ComponentBinding Component Binding
     */
    public FormItem filterEditorType;

    /**
     * Comma-separated list of user roles that are allowed to write to this field. If the current user
     * does not have any of the roles listed, the system will not allow this field to be  initialized
     * or updated.  Please see {@link com.smartgwt.client.docs.serverds.OperationBinding#requiresRole
     * OperationBinding.requiresRole} for further  details of Smart GWT's declarative role-based
     * security. Please see  {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#editRequiresAuthentication
     * editRequiresAuthentication} [or  {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#viewRequiresAuthentication
     * viewRequiresAuthentication} for viewRequiresRole] for the UI consequences if the user does not
     * have the required roles, as well as for information  on customizing field-level security. <p>
     * <b>NOTE:</b> This property prevents both initialization and updates for a field.  If you  have
     * a need to prevent <em>just</em> initialization or <em>just</em> updates, you can use {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#initRequiresRole initRequiresRole} or {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#updateRequiresRole updateRequiresRole}.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.serverds.DataSourceField#editRequiresAuthentication
     * @see com.smartgwt.client.docs.serverds.DataSourceField#viewRequiresRole
     * @see com.smartgwt.client.docs.serverds.DataSourceField#initRequiresRole
     * @see com.smartgwt.client.docs.serverds.DataSourceField#updateRequiresRole
     * @see com.smartgwt.client.docs.FieldLevelAuth Field-Level Security
     */
    public String editRequiresRole;

    /**
     * Applies to the "fetch" operation that is used to look up key values for fields with {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#importStrategy importStrategy.display} while
     * importing data using {@link com.smartgwt.client.widgets.BatchUploader} or
     * <code>DataImport</code> server-side API. Controls whether look up for key values is case
     * sensitive or not. Default value is "false".
     *
     * <p>Default value is false
     */
    public Boolean batchUploadCaseSensitive;

    /**
     * Dictates whether the data in this field be exported.  Explicitly setting  <i>canExport</i> to
     * false overrides the setting on any component-fields, such as {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCanExport ListGrid fields}.
     *
     * <p>Default value is null
     */
    public Boolean canExport;

    /**
     * Width of the image-content of this field.  If set as a string, represents the name of  another
     * field in the record that holds the imageWidth.  Applicable only to fields of image  type or
     * fields that use a {@link com.smartgwt.client.widgets.form.fields.ViewFileItem ViewFileItem} as
     * an editor.
     *
     * <p>Default value is null
     */
    public Integer imageWidth;

    /**
     * Comma-separated list of user roles that are allowed to fetch this field. If the current user
     * has any of the roles listed, values for the field will be fetched.  Please see  {@link
     * com.smartgwt.client.docs.serverds.OperationBinding#requiresRole OperationBinding.requiresRole}
     * for further details of Smart GWT's declarative  role-based security. Please see  {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#editRequiresAuthentication
     * editRequiresAuthentication} [or  {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#viewRequiresAuthentication
     * viewRequiresAuthentication} for viewRequiresRole] for the UI consequences if the user does not
     * have the required roles, as well as for information  on customizing field-level security.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.serverds.DataSourceField#viewRequiresAuthentication
     * @see com.smartgwt.client.docs.serverds.DataSourceField#editRequiresRole
     * @see com.smartgwt.client.docs.FieldLevelAuth Field-Level Security
     */
    public String viewRequiresRole;

    /**
     * This property is only applicable to fields of SQL DataSources, it overrides default behavior of
     * {@link com.smartgwt.client.types.OperatorId iContains} case insensitive operator on the
     * server-side. Set to <code>true</code> to force case insensitivity by changing case of both
     * comparison expression sides or <code>false</code> to rely on database <code>LIKE</code>
     * operator directly.<br> See {@link com.smartgwt.client.docs.SqlSettings} for more details
     * including database specific defaults and other configuration options.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.SqlSettings SQL Database Settings in <code>server.properties</code>
     */
    public Boolean sqlForceInsensitive;

    /**
     * For a {@link com.smartgwt.client.docs.BinaryFields binary field}, sets a fixed mime type for
     * all files stored to this field.  Should be set to a standard mime type string, for example,
     * "text/plain" for a .txt file. <P> This is useful if a binary field only stored one type of file
     * and you chose not to store  filenames, since the extension of the file name is normally used to
     * determine the mime type.
     *
     * <p>Default value is null
     */
    public String mimeType;

    /**
     * XPath expression used to retrieve the field's value.
     *  <P>
     *  This XPath expression will be evaluated in the scope of the record objects selected by 
     * the {@link com.smartgwt.client.docs.serverds.DataSource#recordXPath DataSource.recordXPath}. 
     * For XML data 
     * ({@link com.smartgwt.client.docs.serverds.DataSource#dataFormat dataFormat:"xml"}) this means a
     * call to
     * {@link com.smartgwt.client.data.XMLTools#selectString XMLTools.selectString()} passing the
     * selected XML element.  For JSON data
     * ({@link com.smartgwt.client.docs.serverds.DataSource#dataFormat dataFormat:"json"}), this means
     * a call to 
     * {@link com.smartgwt.client.data.XMLTools#selectObjects XMLTools.selectObjects()} passing the
     * selected JSON object.
     *  <P>
     *  In the absence of a <code>valueXPath</code>, for JSON data the value for the field will
     *  be the value of the same-named property in the record object selected by
     *  {@link com.smartgwt.client.docs.serverds.DataSource#recordXPath recordXPath}.  
     *  <P>
     *  For XML data, the value will be the attribute or subelement named after the field name.
     *  For example, for a field "author" on a record element &lt;book&gt;, the following structures
     *  require no valueXPath:
     *  <pre>
     *     &lt;book author="Mark Jones"/&gt;
     * 
     *     &lt;book&gt;
     *         &lt;author&gt;Mark Jones&lt;/author&gt;
     *     &lt;/book&gt;
     *  </pre>
     *  <P>
     *  If <code>valueXPath</code> is not required for your field because of the default handling
     *  described above, don't specify it, as it's slightly slower.
     *  <p>
     *  To learn about XPath, try the following search:
     *  <a href="http://www.google.com/search?q=xpath+tutorial" target="_blank"
     *  >http://www.google.com/search?q=xpath+tutorial</a>
     *  <P>
     *  <B>Using valueXPath with the Smart GWT server</B>
     *  <p>
     *  If you're using the Smart GWT server to return data via the DSResponse object (or
     *  indirectly doing so using DataSource DMI), the valueXPath you specify on the DataSource
     *  fields will be applied to the data you return via the 
     *  <a href='http://commons.apache.org/jxpath/' target='_blank'>JXPath</a> library.<br>
     *  See also the server side Java APIs <code>DataSource.setProperties()</code> and 
     *  <code>DSResponse.setData()</code>.
     *  <P>
     *  If you are returning Java Beans as your DSResponse data, normally each dataSource field
     *  receives the value of the same-named Java Bean property, that is, a field "zipCode" is
     *  populated by looking for "getZipCode()" on the objects passed as DSResponse data.  You can
     *  use <code>valueXPath</code> to retrieve properties from subobjects, so long as a chain of
     *  getter methods exists that corresponds to the valueXPath.  For example, a valueXPath of
     *  "address/zipCode" expects to call "getAddress()" on the bean(s) passed to
     *  DSResponse.setData(), followed by "getZipCode()" on whatever object "getAddress()" returns.
     *  <P>
     *  When you are saving data, the inbound DSRequest values, available as a Java Map, will use 
     *  just dataSource field names as Map keys, not the valueXPath used to derive them.  However,
     *  to achieve bidirectional valueXPath binding, you can use the server-side method
     *  dataSource.setProperties() to use the valueXPath when setting properties on your server
     *  object model.  When applied as a setter, an XPath like "address/zipCode" attempts
     *  "getAddress()" followed by "setZipCode()" on the returned object.  JXPath also has some
     *  ability to auto-create intervening objects if they are missing, such as auto-creating an
     *  "address" subobject when applying "address/zipCode" as a valueXPath.
     *  <P>
     *  See the
     * <a href='http://jakarta.apache.org/commons/jxpath/' target='_blank'>JXPath</a> library
     * documentation for
     *  complete details, including other types of server object models supported, such as
     *  server-side XML.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.ClientDataIntegration Client-side Data Integration
     */
    public XPathExpression valueXPath;

    /**
     * Indicates that the specified {@link com.smartgwt.client.docs.VelocityExpression} must evaluate
     * to true if initializations of this field are to be allowed.  If the specified expression does
     * not  evaluate to true, the field will be removed from the request as described for  {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#editRequiresAuthentication
     * editRequiresAuthentication}. <p> In addition to the normal context variables available to
     * Velocity expressions in Smart GWT, expressions you write for field-level <code>requires</code>
     * clauses - <code>initRequires</code>,  {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#viewRequires viewRequires}, {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#editRequires editRequires} and  {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#updateRequires updateRequires} - can
     * reference two additional variables:  <code>$fieldName</code> and <code>$dsName</code>.  These
     * are the names of the dataSource and  field currently undergoing <code>requires</code> checks. 
     * They are helpful because they allow you to write a generic checker function that can be used to
     * handle <code>requires</code> checks for multiple fields and dataSources. <p> <b>NOTE:</b> This
     * property only prevents initialization of a field; updates will still be  allowed.  You should
     * only use this property if you have a special requirement; ordinarily, use {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#editRequires editRequires}, which applies
     * security for both types of write.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.serverds.DataSourceField#editRequiresAuthentication
     * @see com.smartgwt.client.docs.serverds.DataSourceField#editRequiresRole
     * @see com.smartgwt.client.docs.serverds.DataSourceField#viewRequires
     * @see com.smartgwt.client.docs.FieldLevelAuth Field-Level Security
     */
    public VelocityExpression initRequires;

    /**
     * Causes values for this field to be sorted according to values for another field, for both
     * client- and server-side sorting. <p> This can be used to establish a sort order for a field
     * that is not the normal sorting order indicated by the field value, typically by having the
     * <code>sortByField</code> as a {@link com.smartgwt.client.docs.serverds.DataSourceField#hidden
     * hidden field}.   <p> If using SQLDataSource, consider using a {@link
     * com.smartgwt.client.data.DataSourceField#getCustomSelectExpression customSelectExpression} as
     * an efficient way to populate the <code>sortByField</code> with the results of a SQL expression.
     *
     * <p>Default value is null
     */
    public String sortByField;

    /**
     * The fully-qualified name of a Java class that implements the 
     *  <code>com.isomorphic.datasource.DataTranslator</code> interface.  If a field declares this 
     *  attribute, Smart GWT Server will create an instance of the translator class and call its 
     *  <code>translate()</code> method for that field value on every record in the response data 
     *  during <code>DSResponse</code> creation.
     *  <p>
     *  Translators were originally provided as a mechanism for translating a plain text value of 
     *  a field - for example, as provided in a CSV file or CSV REST server response - into a 
     *  type-correct value.  Now, however, they are integrated into the general response flow and 
     *  are one of many ways in which you can modify response data; see also
     * Direct Method Invocation, {@link com.smartgwt.client.docs.serverds.DataSource#serverConstructor
     * custom dataSources},
     * {@link com.smartgwt.client.docs.serverds.OperationBinding#transformResponseScript
     * transformResponseScript} and 
     *  {@link com.smartgwt.client.docs.serverds.DataSourceField#fieldValueScript fieldValueScript}.
     *  <p>
     *  Because the orignal translator implementation was intended to derive type-correct values 
     *  from plain text CSV values, the <code>DataTranslator</code> interface only specifies a 
     *  single <code>translate()</code> method, that accepts a String and returns an Object.  For 
     *  reasons of backwards compatibility, this has been left in place, but we have implemented an
     *  additional subinterface, <code>com.isomorphic.datasource.FieldDataTranslator</code>.  If your 
     *  translator implements <code>FieldDataTranslator</code>, the framework will call that 
     *  interface's two-parameter <code>translate()</code> method, passing in both the raw text 
     *  value and a type-correct object coerced from the raw value by Smart GWT's type validation
     *  subsystem (though this automatic type coercion can be switched off with the 
     * {@link com.smartgwt.client.docs.serverds.DataSourceField#skipTypeCoercion skipTypeCoercion
     * flag}).  Hence, 
     *  <code>FieldDataTranslator</code>s are intended for more sophisticated value manipulations
     *  than simple type coercion.
     *  <p>
     *  The following example shows a simple translator that parses a datetime using a non-standard
     *  format into a Java Date object and then alters that date to represent the first day of the 
     *  month:<pre>
     *  package com.mycompany;
     * 
     *  import java.util.Date;
     *  import java.text.ParseException;
     *  import java.text.SimpleDateFormat;
     *  import com.isomorphic.datasource.FieldDataTranslator;
     *  import com.isomorphic.datasource.TranslaterException;
     * 
     *  public class FirstDayOfTheMonthTranslator implements FieldDataTranslator {
     *    static SimpleDateFormat sdf = new SimpleDateFormat("MM/d/yyyy hh:mm:ss a z");
     * 
     *    public Object translate(String raw, Object coerced) throws TranslaterException {
     *     if (object == null) return null;
     * 
     *           // Because the raw text is in a weird format, standard type coercion will not have
     *           // been able to derive a real datetime, so we need to do that first
     *     try {
     *      Date theDate = sdf.parse(raw);
     *               // This API was deprecated a long time ago, but is still the easiest way to do this!
     *               theDate.setDate(1);
     *               return theDate;
     *     } catch (ParseException e) {
     *      // Exception handling code goes here
     *      return null;
     *     }
     *    }
     *  }
     *  </pre>
     *  To make use of this translator, you would use a field definition like this:<pre>
     *      &lt;field name="myDateField" type="datetime" translatorClassName="com.mycompany.FirstDayOfTheMonthTranslator" /&gt;
     *  </pre>
     *
     * <p>Default value is null
     */
    public String translatorClassName;

    /**
     * For fields of type "datetime", indicates whether the framework should attempt to preserve
     *  the millisecond part when persisting to native SQL datetime-type columns.  Whether this 
     *  is possible depends on the type and version of the underlying database product; some 
     *  databases - for example SQL Server earlier than 2008 and MySQL versions earlier than 
     *  5.6 - do not provide fractional seconds support.  If you set this flag when your underlying 
     *  database cannot support fractional seconds, it will be ignored.
     *  <p>
     * Other than the two cases just mentioned which are known to fail, <code>storeMilliseconds</code>
     * 
     *  has been tested and is officially supported with the following products and minimum 
     *  versions:<ul>
     *  <li>Oracle 10g</li>
     *  <li>Microsoft SQL Server 2008</li>
     *  <li>MySQL 5.6</li>
     *  <li>MariaDB 5.3</li>
     *  <li>PostgreSQL 9.1</li>
     *  <li>HSQLDB 2.2</li>
     *  <li>DB2 for Unix/Linux 9.7</li>
     *  <li>Firebird 11.2</li>
     *  <li>Informix IDS 11.5</li>
     *  </ul>
     * Note that you can use {@link com.smartgwt.client.data.DataSourceField#getSqlStorageStrategy
     * sqlStorageStrategy} to store a datetime 
     *  value with sub-second precision in <em>any</em> database - see below.
     *  <p>
     *  When the system generates SQL to insert or update datetime values including a millisecond
     *  element, it does so using a database-specific format string specified in property 
     *  <code>defaultDateTimeFormatWithMilliseconds</code> in your <code>server.properties</code> 
     *  file.  These format strings should conform to the rules of the
     *  <a href=http://docs.oracle.com/javase/8/docs/api/java/text/SimpleDateFormat.html>
     *  Java SimpleDateFormat class</a>.  Suitable format strings are provided for all default 
     *  databases out of the box; if you need to override one or provide a new one, you do so as
     *  shown in this example:<pre>
     *    sql.MyNewDatabase.defaultDateTimeFormatWithMilliseconds: yy-MM-dd'T'hh.mm.ss.SSS</pre>
     *  <p>
     *  Note that this property only controls the persistence of milliseconds into the database;
     *  there is no built-in support for sub-second elements of datetimes in any Smart GWT visual
     * components.  See also the documentation for {@link
     * com.smartgwt.client.docs.serverds.DataSource#trimMilliseconds DataSource.trimMilliseconds} for
     * more 
     *  details of how sub-second datetime elements are handled in the client-server flow.
     *  <p>
     * This property is only applicable to DataSources of {@link
     * com.smartgwt.client.types.DSServerType serverType} 
     * "sql" and fields of {@link com.smartgwt.client.types.FieldType type} "datetime".  It is ignored
     * in all other 
     *  cases.  However, note that the built-in JPA and Hibernate dataSources will always persist
     *  millisecond values automatically if the underlying Java type, database and column support
     *  it.
     *  <p>
     *  Finally, note that this property only has an effect on <em>native</em> datetime-type fields.
     * When you use {@link com.smartgwt.client.data.DataSourceField#getSqlStorageStrategy
     * sqlStorageStrategy} to store a temporal value in a 
     * text or number column, it is the {@link
     * com.smartgwt.client.data.DataSourceField#getSqlDateFormat sqlDateFormat} you use that dictates 
     *  the precision.  For example, a field with <code>sqlStorageStrategy:"text"</code> and 
     *  <code>sqlDateFormat:"yyyy-MM-dd hh:mm:ss.SSS"</code> would store and retrieve with millisecond
     *  precsion; the same field with <code>sqlDateFormat:"yyyy-MM-dd hh:mm"</code> would store
     *  and retrieve with precision to the nearest minute only.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.serverds.DataSource#trimMilliseconds
     */
    public Boolean storeMilliseconds;

    /**
     * Controls whether, by default, DataBoundComponents consider this field editable.  Set to
     * <code>false</code> to draw this field read-only.   <p> For a field that should never be changed
     * from the UI, consider using {@link com.smartgwt.client.docs.serverds.DataSourceField#canSave
     * canSave} instead, which will both mark a field as non-editable and reject any attempt to
     * programmatically change the value on the server (when using the Smart GWT Server). <P> This
     * attribute may not effect all dataBoundComponents - the  {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getCanEditFieldAttribute
     * DataBoundComponent.canEditFieldAttribute} may be set at the component level to look for a
     * different attribute on the dataSourceField, and components allow developers to explicitly
     * override this default (see {@link com.smartgwt.client.widgets.grid.ListGridField#getCanEdit
     * ListGridField.canEdit}. {@link com.smartgwt.client.widgets.form.fields.FormItem#getCanEdit
     * FormItem.canEdit} for example).
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.serverds.DataSourceField#canFilter
     * @see com.smartgwt.client.docs.serverds.DataSourceField#canSave
     * @see com.smartgwt.client.docs.ComponentBinding Component Binding
     */
    public Boolean canEdit;

    /**
     * For a field of type:"imageFile", indicates whether to stream the image and display it inline or
     * to display the View and Download icons.
     *
     * <p>Default value is null
     */
    public Boolean showFileInline;

    /**
     * See {@link com.smartgwt.client.docs.serverds.DataSourceField#javaClass javaClass} - when
     * auto-populating of Java Beans / POJOs based on  inbound DSRequest data, for a field of Map
     * type, <code>javaKeyClass</code> can be used to specify a particular concrete class for the map
     * keys.  If not specified, and a concrete type cannot be discovered using Java Reflection,
     * <code>java.lang.Object</code> is used. Note that <code>javaKeyClass</code> take precedence over
     * generics if both are used.
     *
     * <p>Default value is null
     */
    public String javaKeyClass;

    /**
     * See {@link com.smartgwt.client.docs.serverds.DataSource#tableCode DataSource.tableCode}.
     *
     * <p>Default value is null
     */
    public String fkColumnCode;

    /**
     * For use in {@link com.smartgwt.client.docs.ComponentSchema} for fields that, when changed in
     * {@link com.smartgwt.client.docs.Reify}, should discard the current live component and recreate
     * it with the current configured properties. <P> This property is typically set when a custom
     * component is being used that doesn't have a setter for the field.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.tools.PaletteNode#getRecreateOnChange
     * @see com.smartgwt.client.docs.ComponentSchema Component Schema
     */
    public Boolean recreateOnChange;

    /**
     * For a field that is {@link com.smartgwt.client.docs.serverds.DataSourceField#multiple
     * multiple:"true"}, controls the name of the XML tag used for each subelement during {@link
     * com.smartgwt.client.data.DataSource#xmlSerialize DataSource.xmlSerialize()}. <P> If unset, the
     * default tag name is "value" for a field of simple type, and for a field of DataSource type, is
     * the tagName or ID of the DataSource (as though <code>xmlSerialize()</code> were called on the
     * child DataSource).
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.ComponentSchema Component Schema
     */
    public String childTagName;

    /**
     * If false, this property indicates that this field is considered "server only".  This means:
     * <ul> <li>Components cannot bind to the field; even if you explicitly add a field with the same 
     * name to your {@link com.smartgwt.client.widgets.DataBoundComponent dataBoundComponent}, it will
     * be dropped</li> <li>If you are using Smart GWT Server, the client will never be sent a value
     * for the      field</li> <li>If you are using Smart GWT Server, then similar to {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#canEdit canEdit}, no updates     to the field
     * are allowed from the client.  If you explicitly add a value for the field      to, eg, a record
     * you are passing to {@link com.smartgwt.client.data.DataSource#updateData
     * DataSource.updateData()}, the server will strip     the value out of the record before
     * processing the update request. </ul> <code>canView:false</code> is <b>not</b> the same thing as
     * {@link com.smartgwt.client.docs.serverds.DataSourceField#hidden hidden}.  Use 
     * <code>canView:false</code> when you want to prevent the client from ever seeing a field's 
     * definition or values; use <code>hidden:true</code> if it is fine from a security perspective
     * that a field's definition and values are sent to the browser, but the field should not by
     * default appear in user interface elements (but could do in some cases, like a special screen
     * for advanced users or administrators, for example). <p> Note that this property must be set
     * explicitly to false to have an effect; a null or  undefined setting is treated the same as
     * true. <P> This property is used to implement field-level view security: failing a  {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#viewRequiresAuthentication
     * viewRequiresAuthentication},  {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#viewRequiresRole viewRequiresRole} or {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#viewRequires viewRequires} test is 
     * equivalent to setting <code>canView:false</code> on the field (and, indeed, from the  client's
     * perspective, the field <em>has</em> had <code>canView:false</code> set).
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.ComponentBinding Component Binding
     */
    public Boolean canView;

    /**
     * Whether a user must be authenticated in order to fetch this field.  If this property is  set
     * and the user is not authenticated, Smart GWT Server will not return values for this field to
     * the client. <p> The way this behavior works is to remove the field from the expressed or
     * implied list of fields to return (note, this means the field is removed from the list of fields
     * returned  in <i>data records</i>; the actual field definition in the dataSource is still
     * returned, but in a stripped-down state, as described below).   A list of fields can be
     * expressed using {@link com.smartgwt.client.docs.serverds.OperationBinding#outputs
     * OperationBinding.outputs} or {@link com.smartgwt.client.data.DSRequest#getOutputs
     * DSRequest.outputs}; in the absence of those, the entire set of fields defined in  the
     * DataSource is implied.  You can override this behavior on a per-request basis by  providing a
     * DMI that just re-adds the names of the fields you want for that particular  request to the
     * "consolidated outputs".  See the server-side Javadoc for 
     * <code>DSRequest.getConsolidatedOutputs()</code>. <p> In addition to this behavior of trimming
     * off values in fetched records, a field that fails a field-level security check (either this one
     * or one of the two more specific checks,  {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#viewRequiresRole viewRequiresRole} and {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#viewRequires viewRequires}) will be  altered
     * in the version of the dataSource returned to the client by the  {@link loadDSTag &lt;loadDS&gt;
     * JSP tag} or  {@link com.smartgwt.client.docs.DataSourceDeclaration DataSourceLoader servlet}.
     * <ul> <li>If the field is also not editable (see the discussion of this below), it will be
     * marked  {@link com.smartgwt.client.docs.serverds.DataSourceField#canView canView}:false, and
     * thus effectively be inert and unusable on the client</li> <li>If the field is editable, it will
     * be marked {@link com.smartgwt.client.docs.serverds.DataSourceField#hidden hidden}.  By default,
     * this means that {@link com.smartgwt.client.widgets.DataBoundComponent}s will not show the
     * field, though this can be overridden for  individual components.  If you do choose to unhide
     * the field, bear in mind that it will  never actually show any data, because the underlying
     * security test has still failed</li> </ul> By default, view constraints automatically imply edit
     * constraints - almost all of the time, if a user is not allowed to view a field, he should not
     * be allowed to update it either.  If you specify a view constraint, the system behaves as if you
     * had also specified the  corresponding edit constraint - so
     * <code>viewRequiresAuthentication</code> on a field  implies <code>{@link
     * com.smartgwt.client.docs.serverds.DataSourceField#editRequiresAuthentication
     * editRequiresAuthentication}</code>. You override this behavior simply by specifying some kind
     * of edit constraint for the field, either a different one (eg, "users" can view a field, but
     * only "managers" can update it) or  a blank one (if you have some unusual requirement whereby
     * users are not allowed to view a  field, but they can update it).
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.serverds.DataSourceField#editRequiresAuthentication
     * @see com.smartgwt.client.docs.FieldLevelAuth Field-Level Security
     */
    public Boolean viewRequiresAuthentication;

    /**
     * Declares that this field holds values that can be matched to values from another DataSource
     *  field, to create a relationship between records from different DataSources or even records
     *  within the same DataSource.  
     * 
     *  Ordinarily, the relation to the other dataSource is a 
     *  many-to-one relation, where multiple records on this dataSource refer to a single record on 
     *  the other dataSource.  To declare a one-to-many or many-to-many relation, specify 
     * {@link com.smartgwt.client.docs.serverds.DataSourceField#multiple multiple}:true as well as
     * <code>foreignKey</code>.  See 
     *  {@link com.smartgwt.client.docs.DataSourceRelations the Relations overview} for more details
     * 
     *  <p>
     *  The format of <code>foreignKey</code> is
     *  <code><i>dataSourceId</i>.<i>fieldName</i></code>.
     *  <p>
     *  For a foreignKey within the same dataSource, you can omit the <code>dataSourceId</code>
     *  and just specify <code><i>fieldName</i></code>.  For example, to create a tree relationship
     *  within a DataSource:
     *  
     *  
     *  <pre>
     *       DataSource supplyItem = new DataSource();
     *       DataSourceField itemId = new DataSourceField();
     *       itemId.setType(FieldType.SEQUENCE);
     *       itemId.setPrimaryKey(true);
     *       DataSourceField parentId = new DataSourceField();
     *       parentId.setType(FieldType.INTEGER);
     *       parentId.setForeignKey("itemId");
     *       supplyItem.setFields(itemId, parentId);
     *  </pre>
     *  
     *  <P>
     *  <code>foreignKey</code> declarations also allow other automatic behaviors by
     * {@link com.smartgwt.client.widgets.DataBoundComponent DataBoundComponents}, such as {@link
     * com.smartgwt.client.widgets.grid.ListGrid#fetchRelatedData ListGrid.fetchRelatedData()}.
     *  <p>
     *  For SQLDataSources foreign keys can be automatically discovered from SQL tables if
     *  {@link com.smartgwt.client.docs.serverds.DataSource#autoDeriveSchema autoDeriveSchema} is set.
     *
     * <p>Default value is false
     * @see com.smartgwt.client.docs.serverds.DataSourceField#joinType
     * @see com.smartgwt.client.docs.DataSourceRelations Relations
     */
    public String foreignKey;

    /**
     * Set of search-operators valid for this field.   <P> If not specified, all operators that are
     * valid for the field type are allowed.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.AdvancedFilter Advanced Filtering
     */
    public OperatorId[] validOperators;

    /**
     * Whether this field should be hidden from users by default within a DataBound component. This is
     * generally used for internal IDs and other fields not meaningful to users. <P> See {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#detail detail} for fields that should be
     * hidden in a summary view such as a {@link com.smartgwt.client.widgets.grid.ListGrid}, but still
     * available to the user. <p> <b>NOTE:</b> This property is <b>not</b> a security setting - data
     * for hidden fields is  still delivered to the client, it just isn't shown to the user.  If you
     * wish to make sure  that only appropriate data reaches the client, use {@link
     * com.smartgwt.client.docs.serverds.OperationBinding#outputs OperationBinding.outputs}, {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#canView canView}:false on the field, or a
     * field-level declarative security setting like  {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#viewRequiresRole viewRequiresRole}.
     *
     * <p>Default value is false
     * @see com.smartgwt.client.docs.ComponentBinding Component Binding
     */
    public boolean hidden;

    /**
     * For use in {@link com.smartgwt.client.docs.ComponentSchema}, a field {@link
     * com.smartgwt.client.docs.serverds.DataSource#inheritsFrom inherited} from another schema can be
     * redeclared with this property set in order to indicate that the property should not be used.
     * <P> This is primarily used to influence {@link com.smartgwt.client.docs.Reify Reify}.  For
     * simple type properties, this avoids the property appearing in the Component Editor.   <P> For
     * fields that hold subcomponents, this prevents inappropriate drag and drop.  For example, a
     * custom class called <code>MyDialog</code> may automatically create a series of children, and
     * not allow arbitrary other children to be added.  In this case, the inherited property {@link
     * com.smartgwt.client.widgets.Canvas#getChildren Canvas.children} should be marked inapplicable
     * in order to prevent arbitrary components being dropped onto a <code>MyDialog</code> instance.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.ComponentSchema Component Schema
     */
    public Boolean inapplicable;

    /**
     * Applies only to fields of type "float" and affects how many significant digits are shown. <P>
     * For example, with decimalPrecision 3, if the field value is 343.672677, 343.673 is shown. <P>
     * If the value is 125.2, 125.2 is shown - decimalPrecision will not cause extra zeros to be
     * added.  Use {@link com.smartgwt.client.docs.serverds.DataSourceField#decimalPad decimalPad} for
     * this. <P> A number is always shown with its original precision when edited.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public Integer decimalPrecision;

    /**
     * If set to <code>true</code>, indicates <b>either</b> that this field holds a value unique
     * across all records in this data source, <b>or</b> that it is one of a number of fields marked
     * as primary keys, and the combination of the values held in all of those fields is unique across
     * all records in the data source.  Note that the latter usage - so-called "composite" or
     * "multipart" keys - is intended for support of legacy databases only: if you are able to choose
     * an approach, Isomorphic recommends the use of one <code>primaryKey</code> field per data
     * source, and ideally this field should be of {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#type type} SEQUENCE.  If you have control of
     * the underlying tables, there is nothing to stop you from adding a field like  this (a so-called
     * "synthetic" or "surrogate" key), even for tables that already have a set of columns that could
     * combine to make a composite key (a so-called "natural" key).  Also,   it is neither necessary
     * nor correct to use a composite primaryKey because you want to  enforce uniqueness across that
     * combination of fields.  You can achieve that by declaring a unique constraint in the table
     * schema, or use an {@link com.smartgwt.client.types.ValidatorType isUnique}  validator with
     * <code>validator.criteriaFields</code>, or both; there is no need to use a  composite key to
     * enforce uniqueness. <p> Note that composite primaryKeys are not supported in tree-structured
     * datasets  ({@link com.smartgwt.client.widgets.tree.Tree} and {@link
     * com.smartgwt.client.widgets.tree.ResultTree}) or components ({@link
     * com.smartgwt.client.widgets.tree.TreeGrid},  {@link
     * com.smartgwt.client.widgets.grid.ColumnTree}).  Tree-structured data requires that nodes have a
     * unique  {@link com.smartgwt.client.widgets.tree.Tree#getIdField idField}, with the parent/child
     * relationship expressed through the  {@link
     * com.smartgwt.client.widgets.tree.Tree#getParentIdField parentIdField}.  This implies that
     * binding a Tree to a DataSource requires that the DataSource have a singular primaryKey, and
     * that the primaryKey field is  also the idField, as described in the {@link
     * com.smartgwt.client.docs.TreeDataBinding tree databinding overview} <p> A DataSource that can
     * <i>only</i> perform the "fetch" operation does not require a primaryKey unless it contains
     * {@link com.smartgwt.client.docs.BinaryFields binary fields}.  If a DataSource  allows
     * modification of DataSource records through add, update and remove DataSource  operations, or it
     * contains one or more binary fields, one or more fields must be marked as  the primary key. <P>
     * Smart GWT requires a primary key value to uniquely identify records when communicating updates
     * or deletions to the server.  There is no requirement that the primaryKey field be mapped to an
     * actual "primary key" in your object model, web service, or database (though  this is the most
     * obvious and natural thing to do, of course).  The only requirement is  that the combined values
     * of the primaryKey fields be unique for a given browser instance for the lifetime of the page.  
     * <P> If using Smart GWT's {@link com.smartgwt.client.docs.SqlDataSource SQL engine} and
     * generating SQL tables using the {@link com.smartgwt.client.docs.DbConfigTool Database
     * Configuration Tool}, the table column generated from a primaryKey field will have a unique
     * constraint applied in the database table and, if the field is of type "sequence", the database
     * column will also be created as an "identity column" in those databases that implement
     * sequence-type handling with identity columns.
     *
     * <p>Default value is false
     * @see com.smartgwt.client.docs.DataSourceRelations Relations
     */
    public boolean primaryKey;

    /**
     * Affects whether client dsRequests can request summaries for this field. <p> Default setting of
     * null means that the DataSource-wide default setting {@link
     * com.smartgwt.client.docs.serverds.DataSource#allowClientRequestedSummaries
     * DataSource.allowClientRequestedSummaries} is used for this field.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.serverds.DataSource#allowClientRequestedSummaries
     * @see com.smartgwt.client.docs.ServerSummaries Server Summaries
     */
    public Boolean allowClientRequestedSummaries;

    /**
     * Indicates that the specified {@link com.smartgwt.client.docs.VelocityExpression} must evaluate
     * to true if updates to this field are to be allowed.  If the specified expression does not 
     * evaluate to true, the field will be removed from the request as described for  {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#editRequiresAuthentication
     * editRequiresAuthentication}. <p> In addition to the normal context variables available to
     * Velocity expressions in Smart GWT, expressions you write for field-level <code>requires</code>
     * clauses - <code>updateRequires</code>,  {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#viewRequires viewRequires}, {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#editRequires editRequires} and  {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#initRequires initRequires} - can reference
     * two additional variables:  <code>$fieldName</code> and <code>$dsName</code>.  These are the
     * names of the dataSource and  field currently undergoing <code>requires</code> checks.  They are
     * helpful because they allow you to write a generic checker function that can be used to handle
     * <code>requires</code> checks for multiple fields and dataSources. <p> <b>NOTE:</b> This
     * property only prevents update of a field; initialization will still be  allowed.  You should
     * only use this property if you have a special requirement; ordinarily, use {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#editRequires editRequires}, which applies
     * security for both types of write.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.serverds.DataSourceField#editRequiresAuthentication
     * @see com.smartgwt.client.docs.serverds.DataSourceField#editRequiresRole
     * @see com.smartgwt.client.docs.serverds.DataSourceField#viewRequires
     * @see com.smartgwt.client.docs.FieldLevelAuth Field-Level Security
     */
    public VelocityExpression updateRequires;

    /**
     * Validators to be applied to this field. <p> Validators are applied whenever there is an attempt
     * to save changes to a field. <p> For the available set of built-in validators, and how to define
     * a custom validator, see the {@link com.smartgwt.client.docs.serverds.Validator} class.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.widgets.form.validator.Validator
     * @see com.smartgwt.client.docs.Validation Validation overview and related methods
     */
    public Validator[] validators;

    /**
     * Sets the default FormItem to be used whenever this field is edited (whether in a grid, form, or
     * other component). <P> If unset, a FormItem will be automatically chosen based on the type of
     * the field, by the rules explained {@link com.smartgwt.client.types.FormItemType here}.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.ComponentBinding Component Binding
     */
    public FormItem editorType;

    /**
     * Indicates that {@link com.smartgwt.client.data.DataSource#xmlSerialize
     * DataSource.xmlSerialize()} should serialize this value as an XML attribute. <P> Note this does
     * not need to be declared in order for DataSource records to be derived from XML data: a field
     * will be populated with either an attribute or subelement with matching name.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.ComponentSchema Component Schema
     */
    public Boolean xmlAttribute;

    /**
     * A scriptlet to be executed on the server when deriving values for this field.  The script  will
     * run after the main operation (eg, SQL fetch) and after any  {@link
     * com.smartgwt.client.docs.serverds.DataSource#transformResponseScript transformResponseScript}. 
     * It is intended to be  used for fine-grained transformation at the field level, in cases where
     * declarative  approaches such as {@link
     * com.smartgwt.client.data.DataSourceField#getCustomSelectExpression customSelectExpression} are
     * insufficient. <P> The script will be provided with the following variables:<ul>
     * <li><b>dsRequest</b> The current {@link com.smartgwt.client.data.DSRequest DSRequest}</li>
     * <li><b>field</b> The current field, as an instance of
     * <code>com.isomorphic.datasource.DSField</code></li> <li><b>record</b> The record containing the
     * current field value, as either a Map or a  Javabean, depending on your data model.  See {@link
     * com.smartgwt.client.docs.serverds.DataSource#beanClassName beanClassName}</li> <li><b>value</b>
     * The untransformed field value.  Note, this will only be provided if the  containing record is a
     * Map; if it is a Javabean, your script is expected to derive the value itself, and to apply the
     * transformed value directly to the bean</li> </ul> Before the <code>fieldValueScript</code> is
     * called, Smart GWT will run type validations  on the untransformed field value, to either
     * confirm that the value is a valid one for the  {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#type declared field type}, or to attempt to
     * coerce it into such a valid value (for example, by parsing a number or date out of a string). 
     * Note, this  validation/coercion step can be disabled - see  {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#skipTypeCoercion skipTypeCoercion} - but
     * whether or not this step runs, and whether or not coercion was required, if the resulting value
     * is valid for the declared  field type, an additional variable of the appropriate type will be
     * made available to your  script<ul> <li><b>valueString</b>, an instance of String</li>
     * <li><b>valueInteger</b>, an instance of Long</li> <li><b>valueFloat</b>, an instance of
     * Double</li> <li><b>valueBoolean</b>, an instance of Boolean</li>
     * <li><b>valueDate/Time/Datetime</b>, an instance of java.util.Date</li> </ul> Your script can
     * either manipulate the value directly in the record (if your record is a  Javabean, this is the
     * only supported option), or it can return the transformed value and  Smart GWT will apply it to
     * the response data.  If you change the value in the record  directly, you should ensure that
     * your script explicitly returns null. <P> <b>PERFORMANCE NOTE:</b> JSR223 script calls can
     * involve an overhead, and since  <code>fieldValueScript</code> will be called for every field
     * that declares one, for every  record in a resultset, that overhead can easily multiply to
     * become a performance issue. For this reason, Smart GWT implements script caching for any JSR223
     * script language that support pre-compilation, and we also recommend the use of Groovy as a
     * scripting language  when you are creating <code>fieldValueScript</code>s.  See the "Caching"
     * and  "Relative Performance" sections of the  {@link com.smartgwt.client.docs.ServerScript
     * server scripting article} for more details.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.serverds.DataSource#script
     * @see com.smartgwt.client.docs.serverds.DataSource#transformRequestScript
     * @see com.smartgwt.client.docs.serverds.DataSource#transformResponseScript
     * @see com.smartgwt.client.docs.ServerScript Server Scripting
     */
    public String fieldValueScript;

    /**
     * Comma-separated list of user roles that are allowed to initialize this field. If the current
     * user does not have any of the roles listed, the system will not allow this field to be 
     * initialized. <p> <b>NOTE:</b> This property only prevents initialization of a field; updates
     * will still be  allowed.  You should only use this property if you have a special requirement;
     * ordinarily, use {@link com.smartgwt.client.docs.serverds.DataSourceField#editRequiresRole
     * editRequiresRole}, which applies security for both types of write.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.serverds.DataSourceField#editRequiresAuthentication
     * @see com.smartgwt.client.docs.serverds.DataSourceField#editRequiresRole
     * @see com.smartgwt.client.docs.serverds.DataSourceField#updateRequiresRole
     * @see com.smartgwt.client.docs.serverds.DataSourceField#initRequires
     * @see com.smartgwt.client.docs.FieldLevelAuth Field-Level Security
     */
    public String initRequiresRole;

    /**
     * Customizable and {@link com.smartgwt.client.docs.I18n localizable} error message to use when
     * "displayRequired" {@link com.smartgwt.client.docs.serverds.DataSourceField#importStrategy
     * importStrategy} fails to find corresponding key value. Default message: <i>Key mapping for
     * display value is required, but was not found</i>.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.serverds.DataSourceField#importStrategy
     */
    public String importStrategyFailedErrorMessage;

    /**
     * Maximum number of characters allowed.  Applicable only to fields of text type. For fields of
     * this type a {@link com.smartgwt.client.types.ValidatorType length range validator} will be
     * automatically generated on both the client and server side to enforce this maximum length
     * (unless such a validator is explicitly present for the field already). <P> The {@link
     * com.smartgwt.client.widgets.form.fields.TextItem#getEnforceLength TextItem.enforceLength}
     * attribute can also  explicitly limit user input for freeform text items editing fields with an
     * explicit length specified. <P> <b>NOTE:</b> For DataSources of type "sql", this property has a
     * bearing on the type of  column we use when the underlying table is created by a DataSource 
     * {@link com.smartgwt.client.docs.SqlDataSource import} in the {@link
     * com.smartgwt.client.docs.AdminConsole Admin Console}.  Below  a certain length (which is
     * database-specific, see below), we use standard <code>VARCHAR</code> columns; above that length,
     * we use an alternate strategy (again, database-specific).  For  these long fields, we sometimes
     * also generate different SQL for "update" and "add"  operations, using JDBC "?" replacement
     * parameters rather than embedding values directly in  the generated SQL; whether or not this is
     * done depends entirely on what the underlying  database product and/or JDBC driver will allow.
     * <P><br> <b>Table of field length limits for supported databases:</b><p> <table
     * style="font-size:10px;text-align:center;border:1px solid black;"> <tr><td
     * style="color:white;background-color:black;"><b>Database product</b></td>     <td
     * style="color:white;background-color:black;"><b>VARCHAR limit *</b></td>     <td
     * style="color:white;background-color:black;"><b>Type used above limit</b></td></tr>
     * <tr><td>HSQLDB</td><td>None</td><td>-</td></tr> <tr><td>IBM
     * DB2</td><td>4000</td><td>CLOB</td></tr> <tr><td>Firebird</td><td>32767</td><td>BLOB with
     * subtype 1</td></tr> <tr><td>Informix</td><td>255 / 32739</td><td>LVARCHAR / TEXT ** </td></tr>
     * <tr><td> Microsoft SQL Server </td><td>8000</td><td>TEXT</td></tr> <tr><td>MySQL</td><td> 255 /
     * 65535 / 16M </td><td> TEXT / MEDIUMTEXT / LONGTEXT *** </td></tr> <tr><td>MariaDB</td><td> 255
     * / 65535 / 16M </td><td> TEXT / MEDIUMTEXT / LONGTEXT *** </td></tr>
     * <tr><td>Oracle</td><td>4000</td><td>CLOB</td></tr>
     * <tr><td>PostgreSQL</td><td>4000</td><td>TEXT</td></tr> </table><br> <b>*</b> The "VARCHAR
     * limit" referred to here is a limit used by the Smart GWT Server; it is not necessarily imposed
     * by the database.  For example, DB2's VARCHAR limit is not 4000 characters; it actually varies
     * from about 4K to about 32K, depending on how the server has  been configured.<p> <b>**</b>
     * Informix has a limit of just 255 characters for VARCHAR, but has a native LVARCHAR type which
     * supports nearly 32K characters without needing to fall back on long datatypes.  Therefore, with
     * that one product, we have two thresholds for a change in storage type.<p> <b>***</b> MySQL has
     * a limit of 255 characters for VARCHAR, 65,535 characters for TEXT and  16,777,215 for
     * MEDIUMTEXT; therefore, with that one product, we have three thresholds for a  change in storage
     * type.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGridField#getWidth
     */
    public Integer length;

    /**
     * <b>Note:</b> Currently, this feature only works with {@link
     * com.smartgwt.client.docs.SqlDataSource SQL DataSources}
     *  <p>
     * This property allows you to name an {@link com.smartgwt.client.docs.serverds.OperationBinding
     * operationBinding} on a
     * {@link com.smartgwt.client.docs.DataSourceRelations related DataSource} that should be executed
     * to obtain a 
     *  value for this field.  The format of the property is<pre>
     *       dataSourceId.operationId.fieldName
     *  </pre>
     *  The <code>fieldName</code> is used to disambiguate in case the operation returns more than 
     *  one value 
     * 
     * 
     * 
     * 
     * 
     * 
     *  and it is required, even if the operation only returns a single field
     *  <p>
     *  Typically, <code>valueOperation</code> names an operation that uses a 
     * {@link com.smartgwt.client.docs.serverds.OperationBinding#summaryFunctions summaryFunction} to
     * produce a single aggregated
     *  value from a DataSource with a one-to-many or many-to-many relation with this DataSource.
     *  Some examples of when <code>valueOperation</code>
     *  is appropriate:<ul>
     *  <li>To obtain a total order value from the OrderLines on an Order</li>
     *  <li>To obtain the number of Employees reporting to a given manager</li>
     *  <li>To obtain the date of the most recent Order for a given Customer</li>
     *  <li>To obtain the average population of all Cities in a given Country</li>
     *  </ul>
     *  Note, 
     * 
     *  Smart GWT will convert the sub-operation into inline SQL, for maximum efficiency.
     * 
     * 
     *  <p>
     *  Because <code>valueOperations</code> are deriving a simple field value for a single field, 
     *  they should return a single scalar value of the same type as the field.  <b>Note that the 
     *  requirement to return a single record is a strict one</b>: with most databases, failing to 
     *  observe it will result in a SQL error, because most databases do not allow row limiting in
     *  the kind of subqueries we generate to implement <code>valueOperation</code> - so-called
     *  <i>correlated scalar subqueries</i>.  MySQL is an exception in this, and with that one 
     *  database we <b>do</b> limit the subquery to 1 row; but it is still better to ensure that
     * the subquery can only return a single row (note, all {@link
     * com.smartgwt.client.types.SummaryFunctionType}s 
     *  automatically return a single value)
     *  <p>
     *  However, we do tolerate data type discrepancies; in cases where the data types do not 
     *  match, we attempt the most obvious conversion.  For example, if the 
     *  <code>valueOperation</code> field is of type "boolean" but the operation returns a number,
     *  we will convert 0 to false and any other number to true; this allows you to create boolean
     *  "virtual fields" that answer questions like "Has this Employee booked any orders this 
     *  month?".  With other data types, we will stringify the response value (if the field type is
     *  <code>text</code>), or parse the result of calling <code>toString()</code> on the response
     *  object (if the field is of a numeric type).
     * 
     * 
     * 
     * 
     * 
     * 
     * 
     * 
     *  <p>
     *  NOTE: Although <code>valueOperation</code> can be used to derive any singular value from 
     *  any related dataSource, it is intended primarily as a mechanism for including summarized
     *  values across one-to-many or many-to-many relations.  In cases where you want to go 
     *  "the other way" and derive a value across a many-to-one or one-to-one relation, you would 
     * generally use {@link com.smartgwt.client.docs.serverds.DataSourceField#includeFrom
     * includeFrom}, which is conceptually simpler 
     *  and more direct.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.data.AdvancedCriterionSubquery
     * @see com.smartgwt.client.docs.serverds.DataSourceField#includeFrom
     * @see com.smartgwt.client.docs.serverds.OperationBinding#summaryFunctions
     */
    public String valueOperation;

    /**
     * Fully qualified Java className of an Enum that should be used to derive this field's {@link
     * com.smartgwt.client.types.ValueMap}. <P> This has the same behavior of auto-deriving a
     * <code>valueMap</code> from a Java Enum as {@link
     * com.smartgwt.client.docs.serverds.DataSource#autoDeriveSchema DataSource.autoDeriveSchema}
     * except it applies only to one field. <P> If you enable <code>autoDeriveSchema</code> there is
     * no need to set <code>valueMapEnum</code> for Enum fields unless you want to actually
     * <i>override</i> the behavior to use a different Enum for the field (eg, a superclass Enum that
     * is more restrictive).
     *
     * <p>Default value is null
     */
    public String valueMapEnum;

    /**
     * Sets the default FormItem to be used if this field is marked as  {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#canEdit canEdit false} and displayed in an
     * editor component such as a DynamicForm. <P> This property may also be specified at the type
     * level by specifying  {@link com.smartgwt.client.docs.serverds.SimpleType#readOnlyEditorType
     * SimpleType.readOnlyEditorType}.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.ComponentBinding Component Binding
     */
    public FormItem readOnlyEditorType;

    /**
     * Whether this field should be completely excluded from this dataSource, as if it had never been
     * defined. <P> If set to true, the field will be entirely omitted when serving a DataSource
     * derived  from a server-side definition (typically a .ds.xml file) to the client.
     *
     * <p>Default value is false
     * @see com.smartgwt.client.docs.ComponentBinding Component Binding
     */
    public boolean ignore;

    /**
     * Whether values in this field can be updated and saved to the dataSource. <P> If set to
     * <code>false</code>, this field will default to being non-editable in standard editing
     * components ({@link com.smartgwt.client.widgets.form.DynamicForm}, editable {@link
     * com.smartgwt.client.widgets.grid.ListGrid}), but will be editable when displayed for filtering
     * purposes only (in a {@link com.smartgwt.client.widgets.form.SearchForm} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor ListGrid\n filter editor}.  If
     * {@link com.smartgwt.client.docs.serverds.DataSourceField#canEdit canEdit} is explicitly
     * specified it will take  precedence over this client-side behavior, but the server will still
     * enforce the no-save policy (described below). <p> NOTE: If you are using Smart GWT Server and
     * have specified <code>canSave: false</code>  for a field in a DataSource definition
     * (<code>.ds.xml</code> file), this is enforced on  the server.  This means that we will strip
     * out any attempt to set the value of such a  field before trying to process any update or add
     * request, similar to what happens when  a {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#editRequiresAuthentication field-level
     * declarative security check} fails.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.ComponentBinding Component Binding
     */
    public Boolean canSave;

    /**
     * Whether a user must be authenticated in order to write to this field.  If this property is  set
     * and the user is not authenticated, the Smart GWT Server will not allow this field to be updated
     * or initialized. <p> This property affects two things.  Firstly, the server determines when the
     * DataSource is  first loaded if we have an authenticated user; if we don't, the field is marked 
     * <code>canEdit: false</code>.  Secondly, when an insert or update request is received from  the
     * client, the server removes the field from the <code>values</code> clause before the request is
     * processed. <p> Note that you can override this behavior.  The <code>canEdit</code> setting can
     * be overridden  on the client-side DataSource like any other client-side property.  The
     * value-removing  behavior can be overridden on a per-request basis by providing a DMI that
     * re-adds values for the fields you want for that particular request to the values object (the
     * values originally  sent up by the client are available on the DSRequest).  See the server-side
     * Javadocs for  <code>DSRequest.getValues()</code> and
     * <code>DSRequest.getClientSuppliedValues()</code>.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.serverds.DataSourceField#viewRequiresAuthentication
     * @see com.smartgwt.client.docs.FieldLevelAuth Field-Level Security
     */
    public Boolean editRequiresAuthentication;

    /**
     * Text to be used for display by client-side components when this field has a null or  undefined
     * value.  This value will be overridden by a component's emptyCellValue, if set.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.widgets.form.fields.FormItem#getEmptyDisplayValue
     * @see com.smartgwt.client.widgets.grid.ListGridField#getEmptyCellValue
     * @see com.smartgwt.client.widgets.viewer.DetailViewerField#getEmptyCellValue
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public HTMLString emptyDisplayValue;

    /**
     * For fields of a type that are represented by binary data initially uploaded from a file
     * (currently "binary" and "imageFile", see {@link com.smartgwt.client.types.FieldType}), this
     * sets the maximum  file size allowed, in bytes.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.data.DataSource#maxFileSizeExceededMessage
     */
    public Integer maxFileSize;

    /**
     * A {@link com.smartgwt.client.docs.Callback}, function, or JavaScript expression used to
     * retrieve the field's value from the XML element or JSON record returned from a web service. <P>
     * This is an advanced attribute for use when a {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#valueXPath valueXPath} setting is
     * insufficient to derive a field's value, yet an implementation of {@link
     * com.smartgwt.client.data.DataSource#transformResponse DataSource.transformResponse()} is
     * overkill. <P> For the required parameters, see the documentation for  GetFieldValueCallback.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.ClientDataIntegration Client-side Data Integration
     */
    public GetFieldValueCallback getFieldValue;

    /**
     * The {@link com.smartgwt.client.widgets.form.fields.FormItem#getUseLocalDisplayFieldValue
     * FormItem.useLocalDisplayFieldValue} attribute may be specified within a dataSource
     * configuration. <P> This property governs whether, when displaying a record in an editor
     * component, the <code>displayField</code> value for this field should be picked up directly from
     * the record value (as opposed to being retrieved via an explicit fetch operation against the
     * {@link com.smartgwt.client.widgets.form.fields.FormItem#getOptionDataSource
     * FormItem.optionDataSource}). See {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getUseLocalDisplayFieldValue
     * FormItem.useLocalDisplayFieldValue} for further details. <P> If not explicitly set, dataSources
     * backed by the  {@link com.smartgwt.client.docs.ServerDataIntegration Smart GWT server} will set
     * this property to true automatically for fields where the specified {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#displayField displayField} values are
     * retrieved from another dataSource using the {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#includeFrom includeFrom}  feature.
     *
     * <p>Default value is null
     */
    public Boolean useLocalDisplayFieldValue;

    /**
     * Ordinarily, Smart GWT server runs <code>DSResponse</code> values through type validation logic
     * in order to ensure that values are of the correct type.  Eg, for a field declared to be type
     * "date", type validation will ensure that the value is an instance of 
     * <code>java.util.Date</code>; if it isn't, the server will attempt to coerce it into an 
     * instance of that class - for a date, this coercion attempt would take the form of trying  to
     * parse the <code>toString()</code> form of the raw value. <p> If <code>skipTypeCoercion</code>
     * is true, the server skips this step.  You may wish to do  this if you have other value
     * manipulation logic in place - for example in a  {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#translatorClassName translator} or  {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#fieldValueScript fieldValueScript} - so you
     * do not need the automatic type coercion, or don't want it for some other reason, such as
     * performance.  It may also be that you know the data is already in a correctly-typed form, so
     * there is no point in running the type validation/coercion step.  For example, data fetched by
     * an <code>SQLDataSource</code> will have already been converted to the correct type in advance;
     * similarly, data values  coming out of Javabeans with strongly-typed accessor methods cannot
     * help but be the correct type.
     *
     * <p>Default value is null
     */
    public Boolean skipTypeCoercion;

    /**
     * Name for this field.   <P> Must be unique across all fields within the DataSource as well as a
     * valid JavaScript identifier - see {@link com.smartgwt.client.docs.FieldName} for details and
     * how to check for validity. <P> The field name is also the property in each DataSource record
     * which holds the value for this field. <P> Note: If this is a {@link
     * com.smartgwt.client.docs.serverds.DataSource#serverType SQL-backed} dataSource, the field name
     * should be a valid SQL colmn name, or the {@link
     * com.smartgwt.client.data.DataSourceField#getNativeName nativeName} property should be set to a
     * valid column name.
     *
     * <p>Default value is null
     */
    public FieldName name;

    /**
     * For a field that is a foreignKey establishing a tree relationship, what value indicates a
     * root-level node.  Defaults to null. <P> Note that the rootValue may be overridden on a specific
     * ResultTree instance by setting {@link com.smartgwt.client.widgets.tree.ResultTree#getRootNode
     * ResultTree.rootNode}, or if the ResultTree is auto-generated by a {@link
     * com.smartgwt.client.widgets.tree.TreeGrid}, by setting {@link
     * com.smartgwt.client.widgets.tree.TreeGrid#getTreeRootValue TreeGrid.treeRootValue}. This allows
     * a component to navigate a subtree of the hierarchical data from this dataSource starting at a
     * particular node.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.DataSourceRelations Relations
     */
    public Object rootValue;

    /**
     * If set, causes the field to be securely hashed before saving on an "add" or "update" 
     * operation. <p> The default is null except for fields of {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#type type}: "password", for which the default
     * is "bcrypt".  To disable hashing for password fields, you must set this property to "none".
     *
     * <p>Default value is varies
     */
    public HashAlgorithm storeWithHash;

    /**
     * Determines when the field value should be saved to the audit DataSource when {@link
     * com.smartgwt.client.docs.serverds.DataSource#audit auditing} is enabled.  Setting the property
     * to "change" will conserve storage by only saving out the value when it's changed, and setting
     * it to "never" will exclude the field values from ever being saved during auditing. <h4>Binary
     * fields</h4> Because binary data can be very large compared to other data types, and in many use
     * cases  does not typically change (for example, an application that stores scanned documents), 
     * binary fields are treated specially for auditing purposes:<ul> <li>The default
     * <code>audit</code> setting is "change"</li> <li>The implied <code>_filename</code>,
     * <code>_filesize</code> and <code>_date_created</code> metadata fields inherit their
     * <code>audit</code> setting from the associated binary field, if no explicit setting is provided
     * for the metadata field.  This includes inheriting the  the implicit "change" default.  See the
     * {@link com.smartgwt.client.docs.BinaryFields binary fields overview}  for more details about
     * the binary metadata fields, including how to provide explicit  properties for them</li> <li>By
     * default, we determine if the binary content has changed by comparing the 
     * <code>_filename</code> and <code>_filesize</code> metadata values.  If both those values are
     * unchanged, we assume the content is also unchanged.  If you want to compare the actual  binary
     * content instead, set <code>DataSource</code> property  {@link
     * com.smartgwt.client.docs.serverds.DataSource#compareMetadataForAuditChangeStatus
     * DataSource.compareMetadataForAuditChangeStatus} to false, but bear in mind this may have
     * performance implications, as described in the documentation for that property</li></ul>
     *
     * <p>Default value is "always"
     */
    public FieldAuditMode audit;

    /**
     * Alternative XPath expression used to set the field's value. <P> If is not set, then {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#valueXPath dataSourceField.valueXPath} is
     * used, see its description for details. <P> See also Smart GWT server java APIs
     * <code>DataSource.setProperties()</code> and <code>DSResponse.setData()</code>.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.ClientDataIntegration Client-side Data Integration
     */
    public XPathExpression valueWriteXPath;

    /**
     * For a field that uses {@link com.smartgwt.client.docs.serverds.DataSourceField#includeFrom
     * includeFrom}, specifies which
     * {@link com.smartgwt.client.docs.serverds.DataSourceField#foreignKey foreignKey} field should be
     * used to find records in the
     *  related DataSource.
     *  <p>
     *  <code>includeVia</code> only needs to be set when you have more than one
     *  <code>foreignKey</code> to the <i>same</i> related DataSource.  If you have multiple
     *  foreignKeys to multiple <i>different</i> DataSources, there is no need to set
     *  <code>includeVia</code>.
     *  <p>
     *  For example, perhaps you have a DataSource "moneyTransfer" where each record represents a
     *  money transfer, where the source and payment currencies are different, and the list of
     *  currencies is stored in a related DataSource "currency".  Each "moneyTransfer" record is
     *  linked to <b>2</b> "currency" records, through two different foreignKey fields,
     *  "sourceCurrencyId" and "paymentCurrencyId".
     *  <p>
     *  The following declarations would be required to use <code>includeFrom</code> to get a
     *  include the field "currencySymbol" from each of the two related "currency" records.
     *  <pre>
     *    &lt;field name="sourceCurrencyId" foreignKey="currency.id"/&gt;
     *    &lt;field name="paymentCurrencyId" foreignKey="currency.id"/&gt;
     *    &lt;field name="sourceCurrencySymbol" includeFrom="currency.currencySymbol" includeVia="sourceCurrencyId"/&gt;
     *    &lt;field name="paymentCurrencySymbol" includeFrom="currency.currencySymbol" includeVia="paymentCurrencyId"/&gt;
     *  </pre>
     *  <p>
     *  <h3>SQL Templating and <code>includeVia</code></h3>
     *  <p>
     * The <code>includeVia</code> feature uses SQL table aliases in the generated SQL when generating
     * multiple SQL joins
     * to the same SQL table.  When using {@link com.smartgwt.client.docs.CustomQuerying SQL
     * Templating}, it's sometimes necessary to know 
     *  the names of the aliases in the generated SQL.  The table alias used can be configured via
     * setting {@link com.smartgwt.client.docs.serverds.DataSourceField#relatedTableAlias
     * relatedTableAlias} on the <code>foreignKey</code> field, for
     *  example, using the declarations below, aliases "source" and "payment" would be used for the
     *  two "currency" tables.
     *  <pre>
     *    &lt;field name="sourceCurrencyId" foreignKey="currency.id" relatedTableAlias="source"/&gt;
     *    &lt;field name="paymentCurrencyId" foreignKey="currency.id" relatedTableAlias="payment"/&gt;
     *    &lt;field name="sourceCurrencySymbol" includeFrom="currency.currencySymbol" includeVia="sourceCurrencyId"/&gt;
     *    &lt;field name="paymentCurrencySymbol" includeFrom="currency.currencySymbol" includeVia="paymentCurrencyId"/&gt;
     *  </pre>
     *  <p>
     *  <h3>Multiple indirection and <code>relatedTableAlias</code></h3>
     *  <p>
     * General rule is that if <code>relatedTableAlias</code> is present it is used as alias or its
     * segment, otherwise
     * <code>foreignKey</code> field name linked by <code>includeVia</code> is used instead. See the
     * "Automatically
     * generated table aliases" section of the {@link com.smartgwt.client.docs.CustomQuerying SQL
     * Templating} for the complete set of
     *  general rules how aliases are generated. Also, see some samples below.
     *  <p>
     * Sometimes you may have two <code>includeFrom</code> fields that include a field which is itself
     * included from 
     *  another DataSource, for example:
     *  <pre>
     *    &lt;field name="sourceCurId" nativeName="sourceCurrencyId" foreignKey="currency.id" relatedTableAlias="source"/&gt;
     *    &lt;field name="sourceCurrencySymbol" includeFrom="currency.currencySymbol" includeVia="sourceCurId"/&gt;
     *    &lt;field name="sourceCurrencyGroup" includeFrom="currency.groupName" includeVia="sourceCurId"/&gt;
     *    &lt;field name="paymentCurId" nativeName="paymentCurrencyId" foreignKey="currency.id" relatedTableAlias="payment"/&gt;
     *    &lt;field name="paymentCurrencySymbol" includeFrom="currency.currencySymbol" includeVia="paymentCurId"/&gt;
     *    &lt;field name="paymentCurrencyGroup" includeFrom="currency.groupName" includeVia="paymentCurId"/&gt;
     *  </pre>
     * .. where the "currency" DataSource used above is related to the "currencyGroup" DataSource via
     * fields:
     *  <pre>
     *    &lt;field name="groupId" type="integer" foreignKey="currencyGroup.id" relatedTableAlias="group"/&gt;
     *    &lt;field name="groupName" type="text" includeFrom="currencyGroup.groupName"/&gt;
     *  </pre>
     * Fields "sourceCurrencyGroup" and "paymentCurrencyGroup" include a field that is itself an
     * included field.
     * In this case "currencyGroup" table will be referenced two times, and its
     * <code>relatedTableAlias</code> defined in 
     * "currency" DataSource will be prefixed with the referenced by <code>includeVia</code> field's
     * <code>relatedTableAlias</code>
     *  value to make aliases unique in generated SQL: "source_group" and "payment_group".
     *  <p>
     *  The same aliases would be used if "sourceCurrencyGroup" and "paymentCurrencyGroup" fields
     *  were to include "currencyGroup.groupName" <i>indirectly</i>:
     *  <pre>
     *    &lt;field name="sourceCurrencyGroup" includeFrom="currency.currencyGroup.groupName" includeVia="sourceCurId"/&gt;
     *    &lt;field name="paymentCurrencyGroup" includeFrom="currency.currencyGroup.groupName" includeVia="paymentCurId"/&gt;
     *  </pre>
     *  <p>
     *  This works the same for more complex relationships.  If we add a "moneyTransferDetail"
     *  DataSource to the sample above which has multiple references to "moneyTransfer" 
     *  DataSource and would include fields from "currency" and "currencyGroup" DataSources:
     *  <pre>
     *    &lt;field name="mtId" nativeName="moneyTransferId" type="integer" foreignKey="moneyTransfer.id" relatedTableAlias="main" /&gt;
     *    &lt;field name="mainTransferName" includeFrom="moneyTransfer.name" includeVia="mtId" /&gt;
     *    &lt;field name="mainSourceSymbol" includeFrom="moneyTransfer.sourceCurrencySymbol" includeVia="mtId" /&gt;
     *    &lt;field name="mainSourceGroup" includeFrom="moneyTransfer.sourceCurrencyGroup" includeVia="mtId" /&gt;
     *    &lt;field name="mainPaymentSymbol" includeFrom="moneyTransfer.paymentCurrencySymbol" includeVia="mtId" /&gt;
     *    &lt;field name="mainPaymentGroup" includeFrom="moneyTransfer.paymentCurrencyGroup" includeVia="mtId" /&gt;
     *    &lt;field name="mtPrevId" nativeName="moneyTransferPreviousId" type="integer" foreignKey="moneyTransfer.id" relatedTableAlias="prev" /&gt;
     *    &lt;field name="previousTransferName" includeFrom="moneyTransfer.name" includeVia="mtPrevId" /&gt;
     *    &lt;field name="previousSourceSymbol" includeFrom="moneyTransfer.sourceCurrencySymbol" includeVia="mtPrevId" /&gt;
     *    &lt;field name="previousSourceGroup" includeFrom="moneyTransfer.sourceCurrencyGroup" includeVia="mtPrevId" /&gt;
     *    &lt;field name="previousPaymentSymbol" includeFrom="moneyTransfer.paymentCurrencySymbol" includeVia="mtPrevId" /&gt;
     *    &lt;field name="previousPaymentGroup" includeFrom="moneyTransfer.paymentCurrencyGroup" includeVia="mtPrevId" /&gt;
     *  </pre>
     *  In this scenario the "currencyGroup" table will be joined 4 times - for all main/prev transfer
     *  and payment/source currency combinations.  So, aliases will be prefixed with both
     *  intermediate <code>relatedTableAlias</code> values: "main_source_group",
     *  "main_payment_group", "prev_source_group", "prev_payment_group".
     *  <p>
     *  It is also allowed to specify a series of FK fields in <code>includeVia</code>, for example
     *  "moneyTransferDetail" could declare:
     *  <pre>
     *    &lt;field name="mainSourceCurrencyGroup" includeFrom="moneyTransfer.currency.currencyGroup.groupName" includeVia="mtId.sourceCurId"/&gt;
     *    &lt;field name="mainPaymentCurrencyGroup" includeFrom="moneyTransfer.currency.currencyGroup.groupName" includeVia="mtId.paymentCurId"/&gt;
     *  </pre>
     * In this case the prefix used for table aliases will be the same, cause relations referenced in
     * <code>includeVia</code>
     *  are the same as in previous example: "main_source_group" and "main_payment_group".
     *  <p>
     * <b>Note</b> that if {@link com.smartgwt.client.docs.serverds.DataSourceField#relatedTableAlias
     * related table alias} are completely missing then, according to general rule,
     * <code>foreignKey</code> field names will be used in aliases: "mtId_sourceCurId_groupId" and
     * "mtId_paymentCurId_groupId".
     *  <p>
     *  <h3>Ambiguous <code>includeFrom</code> definitions and logging</h3>
     * Considering the flexibility and complexity of configuring relationships between Datasources, it
     * is important to be aware
     * of certain limitations. Specifically, when multiple fields attempt to include the same field
     * from the same related Datasource
     * via the same (default or specified) foreign key, such configurations are not permitted and may
     * result in unpredictable
     * behavior. This scenario is detected and reported as a warning in the server logs during both
     * DataSource loading and DSRequest
     *  execution.
     *  <p>
     * In example below, fields "sourceCurrencySymbol", "currency" and "currencySymbol" include the
     * same "currencySymbol" field
     * from the same "currency" DataSource via the same "currencyId" foreign key field. So, for the
     * fields "currency" and
     * "currencySymbol" warnings will be logged as they include the same value as does the
     * "sourceCurrencySymbol" field.
     *  <pre>
     *    &lt;field name="currencyId" foreignKey="currency.id"/&gt;
     *    &lt;field name="sourceCurrencySymbol" includeFrom="currency.currencySymbol" /&gt;
     *    &lt;field name="currency" includeFrom="currency.currencySymbol" /&gt;
     *    &lt;field includeFrom="currency.currencySymbol" /&gt;
     *  </pre>
     * Additionally there are two server logging categories that may be set to DEBUG level to log
     * details of the entire
     * <code>includeFrom</code> setup. Specifically
     * <code>com.isomorphic.sql.SQLDataSource.Alias</code> category enables
     * logging for all fields with <code>includeFrom</code>, exact direct or indirect include path to
     * the target field,
     * includeVia/aliases used and <code>com.isomorphic.sql.SQLDataSource.FK</code> category
     * additionally enables logging
     *  for the foreign key fields relations are based on.
     *  <p>
     *  <h3>Extended <code>includeVia</code> syntax</h3>
     * In complex cases involving composite foreign keys or indirect relation chains (multi-step paths
     * across multiple
     * DataSources), <code>includeVia</code> supports an extended syntax that allows explicit control
     * over how relationships
     *  are resolved. See {@link com.smartgwt.client.docs.IncludeViaSyntax} for more details.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.serverds.DataSourceField#relatedTableAlias
     * @see com.smartgwt.client.docs.DataSourceRelations Relations
     */
    public String includeVia;

    /**
     * Server-side setting that causes values for fields of type "integer" or "float" to be
     * represented  as Strings when delivered to a web browser, in order to avoid mangling values
     * which cannot be represented faithfully in JavaScript. <p> JavaScript has a single "Number" type
     * which internally stores numbers in a format equivalent to Java's "Double" - double-precision
     * floating point.  This means it cannot represent the full range of Java's Long type: Java Longs
     * can represent integral values between -2^63 to 2^63-1, whereas JavaScript Number can only
     * represent exact integer values between -2^53 and 2^53. Similarly, JavaScript's Number type
     * cannot represent Java's unlimited-size BigInteger or unlimited-precision BigDecimal objects at
     * all. <p> The <code>stringInBrowser</code> setting can be used to deliver numeric values as
     * Strings to the browser.  This is intended to allow read-only display and successful
     * round-tripping of the numeric value, however, it will not cause number-oriented features such
     * as {@link com.smartgwt.client.widgets.form.fields.SpinnerItem}, {@link
     * com.smartgwt.client.widgets.Slider}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary ListGrid summaries} or
     * range-checking {@link com.smartgwt.client.docs.serverds.Validator validators} or {@link
     * com.smartgwt.client.docs.serverds.AdvancedCriteria criteria} to actually work. <p> If
     * <code>stringInBrowser</code> is not set, the default behavior is configured by the 
     * <code>server.properties</code> setting <code>datasource.defaultStringInBrowser</code>.  If 
     * this flag is false, numeric values are delivered to the client as numbers, <i>even where  this
     * will lead  to a loss of precision</i>.  If the flag is true (which is the default), the
     * behavior is to prevent range overflow for numeric values: <ul> <li> Java values of type Long,
     * BigInteger and BigDecimal will be delivered as      String <i>only if</i> they exceed
     * JavaScript's number range.   <li> Client-side validation will allow inputs that are outside of
     * JavaScript's normal      integer range, and such numbers will remain as Strings after
     * validation, instead of being      converted to Numbers <li> Values submitted to the server will
     * be converted to BigInteger if they exceed the range      of Java's Long type.  This happens
     * during DSRequest validation, before any defined      {@link
     * com.smartgwt.client.docs.DmiOverview DMI methods} are called. </ul> <p> This default set of
     * behaviors is intended to automatically deal with cases like numeric {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#primaryKey primaryKey} or {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#foreignKey foreignKey} values that are never
     * used as numbers, but happen to use the full Java Long range.  To disable the above behaviors,
     * set <code>stringInBrowser="false"</code>. <p> If <code>stringInBrowser</code> is explicitly set
     * to true: <ul> <li> the value for the field will <i>always</i> be delivered to the browser as a
     * String (no      attempt is made to detect the value as out of range / too high precision) <li>
     * client-side validation will do a check for valid format only, and always leave the value     
     * as a String.  Numeric range validators are ignored client-side (always pass), but are     
     * still active server-side. <li> AdvancedCriteria {@link com.smartgwt.client.types.OperatorId
     * operators} that check if values are in a particular      range will always pass <li> the field
     * is treated as though {@link com.smartgwt.client.docs.serverds.DataSourceField#canFilter
     * canFilter:false} were set, to avoid showing      non-functional search interfaces to the user. 
     * Set <code>canFilter="true"</code> to avoid      this effect </ul> <p> This setting is
     * recommended for presenting out-of-range issues or precision loss on fields that represent
     * actual quantities (as opposed to primaryKey or foreignKey fields, which really represent IDs). 
     * To ensure unlimited-precision BigDecimal values are preserved, you should also set {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#javaClass javaClass}. <p> Note that responses
     * delivered as JSON or XML, such as responses from the {@link
     * com.smartgwt.client.docs.ServletDetails RESTHandler servlet}, are not affected.  This setting
     * applies only to responses delivered to a web browser. <p> The entirety of stringInBrowser
     * processing can be completely disabled by setting  <code>server.properties</code> flag
     * <code>datasource.disableStringInBrowser</code> to true. This will cause all numeric values to
     * be delivered as numbers without even attempting to  detect if this will lead to a loss of
     * precision.  This setting overrides both the  <code>stringInBrowser</code> field setting and the
     * <code>datasource.defaultStringInBrowser server.properties</code> flag. <p>
     * <b><code>stringInBrowser</code> and client-side DataSources</b> <p> For DataSources that are
     * not based on the Smart GWT Server, the client-side behaviors described above (such as leaving
     * user input in string form if precision would be lost) are active by default. <p> In addition,
     * if {@link com.smartgwt.client.docs.serverds.DataSource#dataFormat dataSource.dataFormat:"xml"}
     * is used, values that would lose precision remain as strings.  For JSON, if behavior similar to
     * <code>stringInBrowser</code> is desired, your server response must send the values as JSON
     * strings rather than JSON numeric literals. <p> You can use {@link
     * com.smartgwt.client.data.DataSource#defaultStringInBrowser defaultStringInBrowser} to disable
     * these behaviors.  <b>NOTE:</b> don't use this setting if you are using the Smart GWT Server,
     * use the server.properties approach described above instead.
     *
     * <p>Default value is null
     */
    public Boolean stringInBrowser;

    /**
     * This property is only applicable to fields of SQL DataSources that also specify a  {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#foreignKey foreignKey} property; it is
     * ignored for all other fields.  Indicates the  type of join to make between the tables
     * underlying this DataSource and the other DataSource referred to in the <code>foreignKey</code>
     * property, when resolving {@link com.smartgwt.client.docs.serverds.DataSourceField#includeFrom
     * includeFrom}  fields.  The default value of null is the same as specifying "inner". <P> Note,
     * outer joins are allowed for all supported database products only if you are using  {@link
     * com.smartgwt.client.docs.serverds.DataSource#useAnsiJoins ANSI-style joins}.  If you are using
     * the older strategy of additional join expressions in the WHERE clause, outer  joins are only
     * supported for database products that provide a proprietary native syntax for  expressing outer
     * joins.  Those products are:<ul> <li>Oracle</li> <li>Versions of Microsoft SQL Server earlier
     * than 2012, and running in compatibility mode 80</li> </ul>
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.DataSourceRelations Relations
     */
    public JoinType joinType;

    /**
     * For use in {@link com.smartgwt.client.docs.ComponentSchema}, indicates what group to place the
     * property in when editing in Reify.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.ComponentSchema Component Schema
     */
    public String group;

    /**
     * Should the user be able to filter data by this field? Affects whether this field will show up
     * in dataBoundComponents with UI for filtering data. <P> Note that setting
     * <code>canFilter:false</code> only affects UI and is not a security feature.  Enforcing that
     * filtering cannot be performed server side does not meaningfully increase security, since as
     * long as a field can be viewed by an end user, they can effectively search the field themselves
     * even if the UI doesn't offer a means to do so. If a field should be unable to be viewed
     * entirely by some users, use  {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#viewRequiresRole viewRequiresRole} and
     * related settings. <P> Rather than a security setting, <code>canFilter:false</code> is intended
     * for situations where it would be redundant or nonsensical to be able to search on a field, or
     * where searching isn't implemented for that field.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.widgets.form.SearchForm#getShowFilterFieldsOnly
     * @see com.smartgwt.client.widgets.form.SearchForm#getCanEditFieldAttribute
     */
    public Boolean canFilter;

    /**
     * <b>NOTE: </b>Only applicable to {@link com.smartgwt.client.docs.serverds.DataSource#clientOnly
     * clientOnly} DataSources and the built-in {@link com.smartgwt.client.docs.SqlDataSource SQL},
     * {@link com.smartgwt.client.docs.JpaIntegration JPA} and  {@link
     * com.smartgwt.client.docs.HibernateIntegration Hibernate} DataSources available in Pro, Power
     * and  Enterprise versions of Smart GWT. <p> Use this flag to inhibit the normal use of {@link
     * com.smartgwt.client.types.TextMatchStyle} for this field.  A  field with this flag set will
     * always be tested for exact equality in generated queries,  even for filter-style queries where
     * normal behavior would be to use a substring match or  similar. <p> Whether or not the exact
     * match is case-sensitive is determined by the DataSource's  {@link
     * com.smartgwt.client.docs.serverds.DataSource#ignoreTextMatchStyleCaseSensitive
     * ignoreTextMatchStyleCaseSensitive} setting.
     *
     * <p>Default value is null
     */
    public Boolean ignoreTextMatchStyle;

    /**
     * When {@link com.smartgwt.client.docs.serverds.DataSourceField#includeFrom field.includeFrom} is
     * specified and multiple records
     *  exist in the related DataSource per record in the including DataSource,
     * <code>includeSummaryFunction</code> indicates which {@link
     * com.smartgwt.client.types.SummaryFunctionType} is used to
     *  produce the field value.
     *  <p>
     *  <b>This feature is available with Power or better licenses only.</b> 
     *  See <a href="http://smartclient.com/product">smartclient.com/product</a> for details.
     *  <p>
     *  For example, given a DataSource "order" and related DataSource "orderItem", the "itemCount"
     *  field below will show the total number of items in each order.
     *  <pre>
     *   &lt;DataSource ID="order"&gt;
     *      &lt;fields&gt;
     *         &lt;field name="orderID" type="integer" primaryKey="true" foreignKey="orderItem.orderID" /&gt;
     *         &lt;field name="customerName" type="text" /&gt;
     *         &lt;field name="orderDate" type="date" /&gt;
     *         &lt;field name="itemsCount" includeFrom="orderItem.quantity" includeSummaryFunction="sum" /&gt;
     *      &lt;/fields&gt;
     *   &lt;/DataSource&gt;
     *  </pre>
     *  This is analogous to the following SQL statement: 
     *  <pre>
     *  SELECT
     *       order.orderID,
     *       order.customerName,
     *       order.orderDate,
     *       (select sum(_itemsCount.quantity)
     *           from orderItem _itemsCount
     *           where _itemsCount.orderID = order.orderID) as itemsCount
     *  FROM
     *       order
     *  </pre>
     * The <code>includeSummaryFunction</code> feature supports indirect inclusion as well, when the
     * field using
     * it is included from the other DataSource via regular <code>includeFrom</code>. For example,
     * given the
     * "order" DataSource above and related "orderItem" DataSource, the "orderItemsCount" field below
     * will show the
     *  total number of items in the order each order item record belongs to:
     *  <pre>
     *   &lt;DataSource ID="orderItem"&gt;
     *      &lt;fields&gt;
     *         &lt;field name="id" type="integer" primaryKey="true" /&gt;
     *         &lt;field name="orderID" type="integer" foreignKey="order.orderID"/&gt;
     *         &lt;field name="quantity" type="integer" /&gt;
     *         &lt;field name="unitPrice" type="float" /&gt;
     *         &lt;field name="orderItemsCount" includeFrom="order.itemsCount" /&gt;
     *      &lt;/fields&gt;
     *   &lt;/DataSource&gt;
     *  </pre>
     *  This is analogous to the following SQL statement:
     *  <pre>
     *  SELECT
     *       orderItem.id,
     *       orderItem.orderID,
     *       orderItem.quantity,
     *       orderItem.unitPrice,
     *       (select sum(_orderItemsCount_orderID.quantity) AS itemsCount
     *          from order _orderItemsCount
     *                   join orderItem _orderItemsCount_orderID
     *                       on _orderItemsCount.orderID = _orderItemsCount_orderID.orderID
     *          where orderItem.orderID = _orderItemsCount.orderID) as orderItemsCount
     *  FROM
     *       orderItem
     *  </pre>
     *  <p>
     * Note that tables in sub-select will always use {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#relatedTableAlias relatedTableAlias} if set
     * or automatically
     * generated aliases. Automatic aliases are generated according to the rule: first table in
     * possible chain of
     * relations being the name of the field sub-select is getting value for (with underscore "_" in
     * front) and the
     * rest aliases are built up using foreign key field names in the chained relations leading to the
     * target table.
     * This allows to avoid any conflicts with the tables/aliases from the main query. Like in the
     * second example
     *  table "orderItem" is used in both main query without alias and sub-select under
     *  <code>_orderItemsCount_orderID</code> alias.
     *  <p>
     *  Some other common uses:
     *  <ul>
     *  <li> using "max" to show the most recent "order" for a "customer"
     *  <li> using "avg" to show the average order size for a "customer"
     *  <li> using "concat" to show the names of all "salesReps" involved in an "order" (note:
     *      "concat" has limited support - see {@link com.smartgwt.client.types.SummaryFunctionType}).
     *  </ul>
     *  <p>
     *  <b>NOTE</b>: <code>includeSummaryFunction</code> and
     * {@link com.smartgwt.client.docs.ServerSummaries Server Summaries} cannot be used in the same
     * {@link com.smartgwt.client.data.DSRequest}.
     *  If both configurations are present, Server Summaries settings always take priority.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.ServerSummaries Server Summaries
     */
    public SummaryFunctionType includeSummaryFunction;

    /**
     * This property limits where criteria for this field can be applied.  By default, criteria can 
     * be applied either at the server, or at the {@link
     * com.smartgwt.client.data.ResultSet#getUseClientFiltering client} where  possible, to avoid
     * server round-trips. <P> When this property is set to <code>serverOnly</code>, any change to
     * criteria for this field  causes cache-invalidation and a trip to the server.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.AdvancedFilter Advanced Filtering
     */
    public FieldFilterMode filterOn;

    /**
     * Height of the image-content of this field.  If set as a string, represents the name of  another
     * field in the record that holds the imageHeight.  Applicable only to fields of image  type or
     * fields that use a {@link com.smartgwt.client.widgets.form.fields.ViewFileItem ViewFileItem} as
     * an editor.
     *
     * <p>Default value is null
     */
    public Integer imageHeight;

    /**
     * Explicitly declares the Java class that should be used when data from the client is validated
     * by the Smart GWT server and/or applied to Java Beans / POJOs via the server-side API
     * <code>com.isomorphic.datasource.DataSource.setProperties()</code>.  This includes 
     * auto-populating POJO arguments of a {@link com.smartgwt.client.docs.DmiOverview DMI} method, or
     * populating JPA/Hibernate beans with data when using the built-in JPA and Hibernate DataSources.
     * <p> For DataSources that do not use Java Beans, <code>javaClass</code> can be used to force a
     * particular representation for validated DSRequest data (e.g. data passed to a DMI): <ul>
     * <li>for fields declared to be of type "integer" or "float" valid settings include "BigInteger",
     * "Long", "Integer", "Short", "Byte", "AtomicInteger", "AtomicLong", "BigDecimal", "Double"and
     * "Float" (or rather, the fully-qualified versions of those classes, such as "java.lang.Integer"
     * and "java.math.BigDecimal")</li> <li>for fields declared to be of type "date" valid settings
     * include basic "java.util.Date", "java.sql.Date" and "java.sql.Time" types as well as Joda-Time
     * types "DateTime", "DateMidnight", "LocalDateTime", "LocalDate", "LocalTime" and Java 8
     * Date/Time API types "LocalDate", "LocalDateTime", "LocalTime".</li> </ul> When populating Java
     * Beans/ POJOs, <code>javaClass</code> does not normally have to be specified: Smart GWT will use
     * Java reflection to inspect the type of argument expected by a setter method and will attempt
     * conversion of inbound data to that type.  As described in the documentation for
     * <code>DataTools.setProperties()</code>, this works for almost all typical cases.  However
     * <code>field.javaClass</code> is useful for: <ul> <li> subobject of abstract or interface type:
     * in this case Java Reflection is not sufficient to discover the concrete type that should be
     * instantiated, and <code>javaClass</code> should be set instead.</li> <li> subobject of
     * Collection or Map type, when Java generics are not used or the Collection member type or Map
     * value type is abstract.  When Java generics are used (for example the setter takes an argument
     * is of type Collection&lt;SomePOJO&gt; or Map&lt;KeyType,SomePOJO&gt;, Smart GWT will
     * automatically attempt to convert inbound data to the type of the members of the Collection or
     * values of the Map.  Without generics, <code>javaClass</code> needs to be specified.  Note that
     * <code>javaClass</code> will take precedence over generics if both  are used. Also note that
     * {@link com.smartgwt.client.docs.serverds.DataSourceField#javaCollectionClass
     * javaCollectionClass} can be specified if a particular Collection or Map type is needed, and
     * {@link com.smartgwt.client.docs.serverds.DataSourceField#javaKeyClass javaKeyClass} can be
     * specified for a field of type <code>java.util.Map</code>.</li> </ul> <b>NOTE:</b> It is also
     * possible to make Smart GWT Server determine the javaClass to use  dynamically at runtime. See
     * the description of <code>DataSource.getPropertyJavaClass()</code>  in the server documentation
     * for details.
     *
     * <p>Default value is null
     */
    public String javaClass;

    /**
     * How values for a {@link com.smartgwt.client.docs.serverds.DataSourceField#multiple
     * multiple:true} field should be stored. <p> On the server, field values for
     * <code>multiple:true</code> fields are represented as Java Lists in DSRequest and DSResponse
     * objects, but when <code>multipleStorage</code> is used, are ultimately stored as Strings.   <p>
     * This storage mechanism is "denormalized" in the sense of <a
     * href='http://en.wikipedia.org/wiki/Database_normalization' target='_blank'>database
     * normalization</a> because the field contains a compound value rather than an atomic value. 
     * Specifically, this makes the field harder to use with database features like SQL joins, since
     * its value cannot be directly compared to other, singular fields.  For this reason, there's
     * really only a narrow set of cases where it makes sense to use this storage mechanism, consider
     * it if: <ul> <li> the values don't appear in any other tables or columns elsewhere in your
     * database (so      joins and other comparisons wouldn't be possible anyway) <li> there is no
     * authoritative list of all possible values, or even of popular values; it's      basically
     * freeform, like arbitrary, uncurated "tags" applied to photos or links </ul> <p> A
     * <code>multiple:true</code> field can be of any {@link
     * com.smartgwt.client.docs.serverds.SimpleType}, including "date", "time", "datetime", "float",
     * "int" etc.  Type will be preserved across a store and reload cycle, so for example a List of
     * values for a field of type "int" will arrive at the server in a DSRequest as a List of Integer,
     * be stored as a String, but appear again as a List of Integer inside a DSResponse.  When storing
     * "date", "time" or "datetime" values as Strings, XML schema formats are used - the same that are
     * used for transmission in XML or JSON (see {@link com.smartgwt.client.docs.DateFormatAndStorage
     * Date and Time Format and Storage overview} for details). <p> The <code>multipleStorage</code>
     * feature works by transforming from List to String and back inside the server-side
     * DataSource.execute() method.  Specifically, inbound DSRequests are transformed before methods
     * that perform actual storage are called (executeUpdate() et al), and DSResponses received from
     * these methods have <code>multiple:true</code> field values transformed back into Lists before
     * DataSource.execute() returns the DSResponse. <p> This transformation approach means that the
     * built-in SQL, JPA and Hibernate connectors all support <code>multipleStorage</code>, and
     * <code>multipleStorage</code> is also automatically available for any custom DataSource that is
     * capable of storing String values, and implements its storage methods via overrides of
     * executeUpdate(), executeAdd() et al as described in the {@link
     * com.smartgwt.client.docs.WriteCustomDataSource custom DataSource overview}. <p> Note that when
     * using the built-in SQL, JPA and Hibernate connectors, the underlying SQL column should be of
     * 'text' type.  The {@link com.smartgwt.client.docs.DbConfigTool Database Configuration Tool}
     * will automatically generate columns of the correct type for a SQLDataSource.  For JPA or
     * Hibernate DataSources, just ensure the type of the Java bean property on your Java object is
     * String. <p> The default <code>multipleStorage</code> setting of null means that the
     * "simpleString" {@link com.smartgwt.client.types.MultipleFieldStorage} approach will be used if:
     * <ul> <li> the field is of a known {@link com.smartgwt.client.docs.serverds.SimpleType} <li> the
     * field is not a {@link com.smartgwt.client.docs.serverds.DataSourceField#foreignKey foreignKey}
     * </ul> Otherwise, {@link com.smartgwt.client.types.MultipleFieldStorage} "none" will be used.
     * <p> <h4>Criteria and AdvancedCriteria handling</h4> <p> For the built-in SQL, JPA and Hibernate
     * connectors, when <code>multipleStorage</code>:"simpleString" or "json" is used, criteria are
     * transformed to replicate the client-side filtering behavior for multiple:true fields, where
     * possible. The following operators are supported with the same behavior as client-side
     * filtering: <ul> <li> all String-oriented operators including {@link
     * com.smartgwt.client.docs.PatternOperators pattern operators} <li> regexp / iRegexp (built-in
     * SQL only, JPA and Hibernate do not support these. Additionally, when using PostgreSQL, regexp
     * operators are supported only starting from PostgreSQL version 9.3) <li> isBlank / notBlank <li>
     * isNull / notNull <li> inSet / notInSet <li> equalsField / notEqualsField / iEqualsField /
     * iNotEqualsField </ul> The following operators, which are supported for client-side filtering of
     * multiple:true fields, are not supported for server filtering when using
     * <code>multipleStorage</code>: <ul> <li> greaterThan/lessThan(OrEqual) <li> "between" and all
     * other operators with {@link com.smartgwt.client.types.OperatorValueType} of "valueRange"  <li>
     * regexp / iRegexp as noted above </ul> Note that for string-based filtering operators such as
     * "equals", no characters which are part of the {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#multipleStorageSeparator
     * multipleStorageSeparator} may be used in the filter string.  If any characters from the
     * <code>multipleStorageSeparator</code> are present in the filter value, it will always fail to
     * match.  For "json" mode, the <code>multipleStorageSeparator</code> is effectively the String
     * '","'.
     *
     * <p>Default value is null
     */
    public MultipleFieldStorage multipleStorage;

    /**
     * In addition to regular {@link com.smartgwt.client.docs.serverds.DataSourceField#foreignKey
     * foreignKey} this property allows
     *  defining multiple foreign keys if the field is related to more than one DataSource.
     *  <p>
     *  The format of the <code>otherFKs</code> is coma separated foreign key sets, for example:
     *  <i><code>"&lt;firstDS&gt;.&lt;fieldName&gt;,&lt;secondDS&gt;.&lt;fieldName&gt;"</code></i>.
     *  Note that this property works only in addition to the regular FK, i.e. if
     * {@link com.smartgwt.client.docs.serverds.DataSourceField#foreignKey foreignKey} is not set,
     * then foreign keys defined in <code>otherFKs</code>
     * will be completely ignored. If <code>otherFKs</code> is specified, it can include the value of
     * the
     * <code>foreignKey</code> attribute or it can omit it, listing only additional foreignKeys. 
     * There
     *  is no impact on functionality from doing it either way.
     *  <p>
     * For example, perhaps you have a <code>moneyTransfer</code> DataSource where each record
     * represents
     * a money transfer, which has <code>receipt</code> and <code>invoice</code> information stored in
     * <code>receiptDS</code> and <code>receiverDS</code> DataSources. Each money transfer is linked
     * to a
     * receipt and an invoice records through the same <code>transferDS.id</code> field via the
     * foreign keys
     *  defined in <code>foreignKey</code> and <code>otherFKs</code> properties:
     *  <pre>
     *  &lt;DataSource ID="moneyTransfer" ... &gt;
     *       &lt;field name="id" primaryKey="true"
     *           foreignKey="receiptDS.id"
     *           otherFKs="invoiceDS.id"/&gt;
     *       &lt;field name="receiptInfo" includeFrom="receiptDS.info"/&gt;
     *       &lt;field name="invoiceInfo" includeFrom="invoiceDS.info"/&gt;
     *  &lt;/DataSource&gt;
     *  </pre>
     *  Here, we are including from two different related <code>DataSources</code> using the same
     *  <code>foreignKey</code> field.
     *  <p>
     * Note that <code>otherFKs</code> feature is meant to be used in more complex scenarios (see
     * below), so if the
     * example above is all that's needed, then there's no need to use <code>otherFKs</code> feature.
     * The result
     * would be the same as if foreign keys would be declared at the "other side", i.e. in
     * <code>receiptDS</code>
     * and <code>invoiceDS</code> DataSources via regular {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#foreignKey foreignKey} property.
     *  <p>
     * If we extend the sample above with a <code>parentId</code> joining the
     * <code>moneyTransfer</code> DataSource
     * (so called "self-join" relation) and include from <code>receiptDS</code> and
     * <code>invoiceDS</code> for
     * the "parent" money transfer as well, then <code>otherFKs</code> feature must be used. The
     * following
     * declarations would be required to get receipt and invoice information for both the original
     * money transfer
     *  and its "parent":
     *  <pre>
     *  &lt;field name="id" primaryKey="true" foreignKey="receiptDS.id" otherFKs="invoiceDS.id"/&gt;
     *  &lt;field name="receiptInfo" includeFrom="receiptDS.info"/&gt;
     *  &lt;field name="invoiceInfo" includeFrom="invoiceDS.info"/&gt;
     *  &lt;field name="parentId" foreignKey="moneyTransfer.id" relatedTableAlias="parent"/&gt;
     *  &lt;field name="parentReceiptInfo" includeFrom="moneyTransfer.receiptDS.info"/&gt;
     *  &lt;field name="parentInvoiceInfo" includeFrom="moneyTransfer.invoiceDS.info"/&gt;
     *  </pre>
     *  <p>
     *  <h3>SQL Templating and <code>otherFKs</code></h3>
     *  <p>
     * Similar to the <code>includeVia</code>, <code>otherFKs</code> feature uses SQL table aliases in
     * the
     *  generated SQL when generating multiple SQL joins to the same SQL table.  When using
     * <code>SQL Templating</code>, it's sometimes necessary to know the names of the aliases in the
     * generated
     * SQL. See the "Automatically generated table aliases" section of the {@link
     * com.smartgwt.client.docs.CustomQuerying SQL Templating}
     *  for the complete set of general rules how aliases are generated.
     *  <p>
     *  The <code>otherFKs</code> feature uses aliases constructed from two parts:<br>
     * - the {@link com.smartgwt.client.docs.serverds.DataSourceField#name field name}, which otherFKs
     * property is defined on;<br>
     * - the related {@link com.smartgwt.client.docs.serverds.DataSource#ID DataSource ID} or the
     * {@link com.smartgwt.client.docs.serverds.DataSource#relatedTableAlias
     * DataSource.relatedTableAlias} if set.<p>
     * So, in the extended sample above the aliases for the "parent" money transfer related tables
     * would be
     *  "<i>parent_id</i>" (regular FK) and "<i>parent_<b>id_invoiceDS</b></i>" (other FK).
     *  <p>
     * See below the same sample extended with the <code>detailDS</code> DataSource storing multiple
     * records per money
     * transfer, joined to <code>moneyTransfer</code> DataSource on a one-to-many basis, and include
     * receipt and
     * invoice information for money transfer and its "parent". Also, we'll add
     * <code>relatedTableAliases</code>
     *  to the invoice DataSource, see all related declarations below:
     *  <pre>
     *  &lt;DataSource ID="detailDS" ... &gt;
     *       &lt;field name="id" type="integer" primaryKey="true" &gt;
     *       &lt;field name="name"/&gt;
     *       &lt;field name="mtId" foreignKey="moneyTransfer.id" relatedTableAlias="main"/&gt;
     *       &lt;field name="mainReceipt" includeFrom="moneyTransfer.receiptInfo" includeVia="mtId"/&gt;
     *       &lt;field name="mainInvoice" includeFrom="moneyTransfer.invoiceInfo" includeVia="mtId"/&gt;
     *       &lt;field name="mainParentReceipt" includeFrom="moneyTransfer.parentReceiptInfo" includeVia="mtId"/&gt;
     *       &lt;field name="mainParentInvoice" includeFrom="moneyTransfer.parentInvoiceInfo" includeVia="mtId"/&gt;
     *  &lt;/DataSource&gt;
     * 
     *  &lt;DataSource ID="receiptDS" ... &gt;
     *       &lt;fields&gt;
     *           &lt;field name="id" primaryKey="true"/&gt;
     *           &lt;field name="info"/&gt;
     *       &lt;/fields&gt;
     *  &lt;/DataSource&gt;
     * 
     *  &lt;DataSource ID="invoiceDS" relatedTableAlias="invoice" ... &gt;
     *       &lt;fields&gt;
     *           &lt;field name="id" primaryKey="true"/&gt;
     *           &lt;field name="info"/&gt;
     *       &lt;/fields&gt;
     *  &lt;/DataSource&gt;
     *  </pre>
     * Generated aliases for the receipt/invoice tables will be <code>main_id</code>,
     * <code>main_<b>id_invoice</b></code>
     * for the money transfer and <code>main_parent_id</code>,
     * <code>main_parent_<b>id_invoice</b></code> for the "parent"
     *  money transfer.
     *  <p>
     *  <h3><code>otherFKs</code> + <code>includeVia</code></h3>
     *  <p>
     * The <code>otherFKs</code> and the {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#includeVia includeVia} features may be used
     * together in even
     * more complex scenarios. In the example below we extend <code>detailDS</code> DataSource with a
     * link to
     *  the "previous" money transfer and include all of its receipt/invoice information:
     *  <pre>
     *  &lt;field name="mtPrevId" foreignKey="moneyTransfer.id" relatedTableAlias="prev"/&gt;
     *  &lt;field name="prevReceipt" includeFrom="moneyTransfer.receiptInfo" includeVia="mtPrevId"/&gt;
     *  &lt;field name="prevInvoice" includeFrom="moneyTransfer.invoiceInfo" includeVia="mtPrevId"/&gt;
     *  &lt;field name="prevParentReceipt" includeFrom="moneyTransfer.parentReceiptInfo" includeVia="mtPrevId"/&gt;
     *  &lt;field name="prevParentInvoice" includeFrom="moneyTransfer.parentInvoiceInfo" includeVia="mtPrevId"/&gt;
     *  </pre>
     * Additionally generated aliases will be <code>prev_id</code>,
     * <code>prev_<b>id_invoice</b></code>
     * for the money transfer and <code>prev_parent_id</code>,
     * <code>prev_parent_<b>id_invoice</b></code>
     *  for the "parent" money transfer.
     *  <p>
     * The inclusions may as well be indirect like shown below and they would produce same chains of
     * relations,
     *  so the generated SQL and table aliases will be the same as above.
     *  <pre>
     *  &lt;field name="mtPrevId" foreignKey="moneyTransfer.id" relatedTableAlias="prev"/&gt;
     *  &lt;field name="prevReceipt" includeFrom="<i>moneyTransfer.receiptDS.info</i>" includeVia="mtPrevId"/&gt;
     *  &lt;field name="prevInvoice" includeFrom="<i>moneyTransfer.invoiceDS.info</i>" includeVia="mtPrevId"/&gt;
     *  &lt;field name="prevParentReceipt" includeFrom="<i>moneyTransfer.moneyTransfer.receiptDS.info</i>" includeVia="mtPrevId"/&gt;
     *  &lt;field name="prevParentInvoice" includeFrom="<i>moneyTransfer.moneyTransfer.invoiceDS.info</i>" includeVia="mtPrevId"/&gt;
     *  </pre>
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.serverds.DataSourceField#otherFKs
     * @see com.smartgwt.client.docs.serverds.DataSource#relatedTableAlias
     * @see com.smartgwt.client.docs.serverds.DataSourceField#includeVia
     * @see com.smartgwt.client.docs.DataSourceRelations Relations
     */
    public String otherFKs;

    /**
     * For a field of {@link com.smartgwt.client.types.FieldType type} "sequence" on a DataSource with
     * {@link com.smartgwt.client.docs.serverds.DataSource#serverType serverType:"sql"}, this flag
     * indicates that the field is  implicitly bound to a sequence.  This setting means that Smart GWT
     * does not expect to  find a value for the field in "add" operations, even if it is marked as a 
     * {@link com.smartgwt.client.docs.serverds.DataSourceField#primaryKey primaryKey}, as such fields
     * usually are.  It also means that Smart GWT does not attempt to retrieve the field value from an
     * actual database sequence, instead relying on the JDBC driver to return the generated value (see
     * the note on <code>sequenceMode</code> below). <P> Implicitly bound columns are a syntactic
     * convenience provided by some databases to simulate  the "auto-increment" or "identity" columns
     * available natively in other products, without  the underlying sequence having to be explicitly
     * referenced in SQL queries.  Currently, these database products support this idea:<ul>
     * <li>PostgreSQL has had a "serial" column type for a long time -  <a
     * href=http://www.postgresql.org/docs/9.3/static/datatype-numeric.html#DATATYPE-SERIAL>
     * http://www.postgresql.org/docs/9.3/static/datatype-numeric.html#DATATYPE-SERIAL</a></li>
     * <li>DB2 has long supported a "GENERATED AS IDENTITY" notation for numeric fields.  This may or
     * may not be implemented with a sequence - the documentation does not specify - but we  support
     * it via the implicitSequence mechanism because it is so similar to the implicit sequence
     * approach in Oracle.    <a
     * href="http://publib.boulder.ibm.com/infocenter/dzichelp/v2r2/index.jsp?topic=%2Fcom.ibm.db2z10.doc.apsg%2Fsrc%2Ftpc%2Fdb2z_identitycols.htm">
     * http://publib.boulder.ibm.com/infocenter/dzichelp/v2r2/index.jsp?topic=%2Fcom.ibm.db2z10.doc.apsg%2Fsrc%2Ftpc%2Fdb2z_identitycols.htm</a></li>
     * <li>Oracle introduced a "GENERATED AS IDENTITY" notation for numeric fields in version 12c - 
     * <a href=http://www.oracle-base.com/articles/12c/identity-columns-in-oracle-12cr1.php>
     * http://www.oracle-base.com/articles/12c/identity-columns-in-oracle-12cr1.php</a></li> </ul> If
     * you have columns like these in your database, declare them as type "sequence" and mark  them
     * with the <code>implicitSequence</code> flag. <P> <b>NOTE:</b> If you use this property, you
     * should also set the  {@link com.smartgwt.client.docs.serverds.DataSource#sequenceMode
     * DataSource sequenceMode} to "jdbcDriver".  This is necessary because Smart GWT cannot directly
     * query the implicit sequence that is being used behind the  scenes, so we must rely on the JDBC
     * driver to do that. <p> If you use {@link
     * com.smartgwt.client.docs.serverds.DataSource#autoDeriveSchema autoDeriveSchema} to
     * automatically derive a  dataSource from table metadata, Smart GWT attempts to identify these
     * special Oracle and Postgres columns by heuristic examination of the metadata.  When it
     * identifies such a  column, it marks the corresponding dataSourceField <code>implicitSequence:
     * true</code>,  and changes the sequenceMode on the DataSource to "jdbcDriver".  If your table
     * contains one of these columns and Smart GWT does not automatically identify it, bear in mind
     * that you can always set this flag manually, even if you are using
     * <code>autoDeriveSchema</code>. <P> This setting has no effect for non-SQL dataSources, or for
     * databases other than those  mentioned above.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.serverds.DataSource#sequenceMode
     * @see com.smartgwt.client.docs.SqlDataSource SQL DataSources
     */
    public Boolean implicitSequence;

    /**
     * Applies only to fields of type "float" and enforces a minimum number of digits shown after the
     * decimal point. <P> For example, a field value of 343.1, 343.104 and 343.09872677 would all be
     * shown as 343.10 if decimalPad is 2. <P> The original unpadded value is always shown when the
     * value is edited.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public Integer decimalPad;

    /**
     * For fields that are {@link com.smartgwt.client.docs.serverds.DataSourceField#multiple
     * multiple:true}, the separator used  between values when they are displayed.
     *
     * <p>Default value is ", "
     */
    public String multipleValueSeparator;

    /**
     * Comma-separated list of user roles that are allowed to update this field. If the current user
     * does not have any of the roles listed, the system will not allow this field to be  updated. <p>
     * <b>NOTE:</b> This property only prevents a field from being updated; initialization will  still
     * be allowed.  You should only use this property if you have a special requirement;  ordinarily,
     * use {@link com.smartgwt.client.docs.serverds.DataSourceField#editRequiresRole
     * editRequiresRole}, which applies security for both  types of write.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.serverds.DataSourceField#editRequiresAuthentication
     * @see com.smartgwt.client.docs.serverds.DataSourceField#editRequiresRole
     * @see com.smartgwt.client.docs.serverds.DataSourceField#initRequires
     * @see com.smartgwt.client.docs.FieldLevelAuth Field-Level Security
     */
    public String updateRequiresRole;

    /**
     * If <code>field.formula</code> is set, this field's value in records will be 
     *  calculated dynamically. 
     *  <P>
     *  <code>DataSourceField.formula</code> is supported for
     *  {@link com.smartgwt.client.types.DSServerType SQL DataSources} and for
     *  {@link com.smartgwt.client.docs.serverds.DataSource#clientOnly clientOnly dataSources} only.
     *  <P>
     *  Valid formula expressions may reference other field values directly by field name, or
     *  may reference the record object itself. Formula expressions may make use of standard
     *  {@link com.smartgwt.client.docs.FormulaFunction FormulaFunctions}.
     *  <P>
     *  For example, given a dataSource with two numeric fields "population" and "area"
     *  you could easily add a "populationDensity" field with the following formula:
     *  <pre>
     *  &lt;field name="populationDensity" type="float"&gt;
     *       &lt;formula&gt;round(population/area)&lt;/formula&gt;
     *  &lt;/field&gt;
     *  </pre>
     *  <P>
     *  For SQL DataSources, values are calculated on the server by modifying the
     *  generated SQL request as appropriate. For clientOnly dataSources, values are
     *  calculated as part of the 
     * {@link com.smartgwt.client.data.DataSource#getClientOnlyResponse standard fetch response flow}.
     * 
     *  Since the field values are calculated in the data source layer, standard 
     *  capbilities like server side sorting of paged data sets are supported for these
     *  fields. This would not be the case for formula field values calculated 
     *  {@link com.smartgwt.client.widgets.grid.ListGridField#getUserFormula at the component level}.
     *  <P>
     *  As with other
     *  {@link com.smartgwt.client.data.DataSource#isCalculated dynamically calculated}
     *  fields, fields with a specified formula are non editable.<br>
     *  When records are displayed in 
     * {@link com.smartgwt.client.widgets.DataBoundComponent dataBoundComponents that support
     * editing}, 
     *  formula field values will be re-calculated dynamically on the client as the user
     *  edits a record, so a user may preview the result of their changes.
     *  <P>
     *  Note that <code>formula</code> fields may not make use of
     * {@link com.smartgwt.client.docs.serverds.DataSourceField#includeFrom fields included from
     * related dataSources}.
     *  <b>DataSourceField.formula is available with Power or better licenses only.</b>  See
     *  <a href="http://smartclient.com/product">smartclient.com/product</a> for details.
     *
     * <p>Default value is null
     */
    public String formula;

    /**
     * Indicates that the specified {@link com.smartgwt.client.docs.VelocityExpression} must evaluate
     * to true if writes to this field are to be allowed.  If the specified expression does not
     * evaluate to true, the field will be removed from the request as described for  {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#editRequiresAuthentication
     * editRequiresAuthentication}. <p> In addition to the normal context variables available to
     * Velocity expressions in Smart GWT, expressions you write for field-level <code>requires</code>
     * clauses - <code>editRequires</code>,  {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#viewRequires viewRequires}, {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#initRequires initRequires} and  {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#updateRequires updateRequires} - can
     * reference two additional variables:  <code>$fieldName</code> and <code>$dsName</code>.  These
     * are the names of the dataSource and  field currently undergoing <code>requires</code> checks. 
     * They are helpful because they allow you to write a generic checker function that can be used to
     * handle <code>requires</code> checks for multiple fields and dataSources. <p> <b>NOTE:</b> This
     * property prevents both initialization and updates for a field.  If you  have a need to prevent
     * <em>just</em> initialization or <em>just</em> updates, you can use {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#initRequires initRequires} or {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#updateRequires updateRequires}.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.serverds.DataSourceField#editRequiresAuthentication
     * @see com.smartgwt.client.docs.serverds.DataSourceField#editRequiresRole
     * @see com.smartgwt.client.docs.serverds.DataSourceField#viewRequires
     * @see com.smartgwt.client.docs.FieldLevelAuth Field-Level Security
     */
    public VelocityExpression editRequires;

    /**
     * Name of another field in a separate dataSource that should be used as the display
     *  value for this field in the case where a <code>foreignKey</code> relationship
     *  exists.  Derived automatically when using the displayField / includeFrom pattern as
     *  illustrated in the following example.
     *  <P>
     *  For a general overview on picking up display values from a separate field,
     * see {@link com.smartgwt.client.docs.serverds.DataSourceField#displayField displayField}
     * property.
     *  <P>
     *  The <code>foreignDisplayField</code> property is useful for editable fields, where the 
     *  name of the display field within the record being edited differs from the display field 
     *  for related records in the option dataSource.<br>
     *  For example consider a "countryDS" dataSource with the following fields:
     *  <pre>
     *   &lt;field name="id"     type="sequence"   hidden="true"     primaryKey="true" /&gt;
     *   &lt;field name="name"   type="text"       title="Country"   required="true" /&gt;
     *  </pre>
     *  ...and a "city" dataSource which uses a foreignKey relationship identify associated
     *  country records:
     *  <pre>
     *   &lt;field name="id"        type="sequence" hidden="true"   primaryKey="true" /&gt;
     *   &lt;field name="name"      type="text"     title="City"    required="true" /&gt;
     *   &lt;field name="countryId" type="integer"  editorType="SelectItem" 
     *              foreignKey="countryDS.id" 
     *              displayField="countryName" foreignDisplayField="name" title="Country" /&gt;
     *   &lt;field name="countryName" includeFrom="countryDS.name"  hidden="true"   /&gt;
     *  </pre>
     *  A DynamicForm bound to this "city" dataSource would display a SelectItem editor by
     *  default for the country field. The initial display value would be the local value from
     *  the "countryName" field, populated from the related countryDS automatically via the
     *  {@link com.smartgwt.client.docs.serverds.DataSourceField#includeFrom includeFrom} feature.<br>
     *  If the user showed the drop-down list of options for this field, the display values
     *  within that list would be picked up from the "name" field values for the related
     *  "countryDS" records.  Again, note that the foreignDisplayField would have been derived in
     *  this case, and need not be specified explicitly.
     *  <P>
     *  Note that when specified, <code>foreignDisplayField</code> is always expected to be set to 
     *  the related dataSource field containing equivalent values to the <code>displayField</code>
     * in the local dataSource. This is important as, when editing the field, foreignDisplayField
     * values from 
     *  the related dataSource will be displayed to the user, and when a value is selected
     *  the local record's <code>displayField</code> value will be updated to match the selected
     *  <code>foreignDisplayField</code> value from the related dataSource's record. This behavior
     * is documented under {@link com.smartgwt.client.widgets.form.fields.FormItem#getDisplayField
     * FormItem.displayField}.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.DataSourceRelations Relations
     */
    public String foreignDisplayField;

    /**
     * Used to look up key values for fields with {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#importStrategy importStrategy.display} while
     * importing data using {@link com.smartgwt.client.widgets.BatchUploader} or
     * <code>DataImport</code> server-side API. <p> Normally key values are looked up performing
     * "fetch" operation on related data source, but setting <code>batchUploadOperationId</code>
     * allows to control which operation will be performed. This can be useful to avoid unnecessary
     * load when importing big data sets, if default "fetch" operation is too heavy. <p> By default
     * the look up is not case sensitive but this can be controlled through the {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#batchUploadCaseSensitive
     * batchUploadCaseSensitive} attribute.
     *
     * <p>Default value is null
     */
    public String batchUploadOperationId;

    /**
     * Optional different field-title used for exports.
     *
     * <p>Default value is null
     */
    public String exportTitle;

    /**
     * When records from this dataSource are displayed in a dataBoundComponent such as a {@link
     * com.smartgwt.client.widgets.grid.ListGrid}, the <code>displayField</code> attribute may be used
     * to cause some  field to display a value from another field in the record. <P> This is typically
     * used for editable {@link com.smartgwt.client.docs.serverds.DataSourceField#foreignKey
     * foreignKey} fields.  In this scenario, a dataSource field has a foreignKey field which stores
     * an ID value used to identify records in another, related dataSource. Rather than display this
     * ID to users, developers may wish to display another, user-friendly field from the related
     * record. This is easy to achieve by  having a second field on the dataSource which will be
     * populated with the "display value" from this related dataSource, and using
     * <code>dataSourceField.displayField</code>  to show this value.  The {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#includeFrom includeFrom} feature handles
     * populating this field automatically for dataSources backed by the {@link
     * com.smartgwt.client.docs.ServerDataIntegration Smart GWT Server}. See the "Editing included
     * fields" section of the {@link com.smartgwt.client.docs.serverds.DataSourceField#includeFrom
     * includeFrom} documentation for more on editing included foreignKey fields. <P> Editable
     * dataSourceFields with a specified <code>displayField</code> and  <code>foreignKey</code> will
     * typically be edited using a {@link com.smartgwt.client.widgets.form.fields.SelectItem}  or
     * {@link com.smartgwt.client.widgets.form.fields.ComboBoxItem}. In this case, in addition to
     * identifying the field to use as a static display value within the record being edited,
     * <code>displayField</code> will also identify which field on the related dataSource to use as a
     * display field when showing a set of options to the user. This behavior may be modified in a
     * couple of ways: <ul>  <li>The {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#foreignDisplayField foreignDisplayField}
     * attribute may be used to handle the      case where the name of the field used as a
     * displayField within the dataSource is      different from the name of the included/equivalent
     * field in the related dataSource.</li>  <li>The {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#useLocalDisplayFieldValue
     * useLocalDisplayFieldValue} attribute may be explicitly      set to false to avoid picking up a
     * display value from the local record altogether.      Instead the displayField will be used only
     * to derive the display value from      a related record from the optionDataSource</li> </ul> For
     * more on how FormItems use the displayField property, see {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getDisplayField FormItem.displayField}.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.DataSourceRelations Relations
     */
    public String displayField;

    /**
     * Controls whether an explicit null-valued Record attribute for this field
     *  should result in <code>xsi:nil</code> being used to transmit the value when serializing
     *  to XML, like so:
     *  <pre>
     *  &lt;book&gt;
     *      &lt;title&gt;Beowulf&lt;/title&gt;
     *      &lt;author xsi:nil="true"/&gt;
     *  &lt;/book&gt;
     *  </pre>
     *  If <code>nillable</code> is not set, no XML element will be generated for
     *  the explicit null value.
     *  <p>
     *  A DataSourceField that specifies a <code>foreignKey</code> is automatically nillable
     *  unless this property is explicitly set to <code>false</code>.
     *
     * <p>Default value is null
     */
    public Boolean nillable;

    /**
     * Used by the {@link com.smartgwt.client.widgets.BatchUploader} to map a field in an upload file
     * to this  dataSourceField.  This is only necessary if the dataSourceField's name and title
     * differ  from the name of the field in the upload file (Smart GWT will automatically map upload 
     * fields using the dataSourceField's title, if possible, if it does not get a direct match  on
     * field name).
     *
     * <p>Default value is null
     */
    public String uploadFieldName;

    /**
     * When set for a field with binary data, binary data will be delivered as a Base64 encoded
     * string.   <P> When <code>encodeInResponse</code> is not set normal responses will not contain
     * values for binary fields at all.  Instead, UI components, such as {@link
     * com.smartgwt.client.widgets.tile.TileGrid} issue a second binary fetch for binary data when
     * appropriate, and APIs such as {@link com.smartgwt.client.data.DataSource#downloadFile
     * downloadFile()} and {@link com.smartgwt.client.data.DataSource#viewFile viewFile()} can be used
     * to programmatically trigger downloads. <p> Only applicable to fields of a type that are
     * represented by binary data (currently "binary" and "imageFile", see {@link
     * com.smartgwt.client.types.FieldType}).
     *
     * <p>Default value is null
     */
    public Boolean encodeInResponse;

    /**
     * Width and height of the image-content of this field.  If set as a string, represents the  name
     * of another field in the record that holds the imageSize.  Applicable only to fields  of image
     * type or fields that use a {@link com.smartgwt.client.widgets.form.fields.ViewFileItem
     * ViewFileItem} as an editor.
     *
     * <p>Default value is null
     */
    public Integer imageSize;

    /**
     * The default search-operator for this field. <P> If not specified, falls back to the default
     * specified for the field's {@link com.smartgwt.client.docs.serverds.SimpleType#defaultOperator
     * data-type}.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.AdvancedFilter Advanced Filtering
     */
    public OperatorId defaultOperator;

    /**
     * Applies only to fields of type "float" or "integer" and affects how many significant digits are
     * shown. <P> For example, a field value of 343.1, 343.104 and 343.09872677 would all be shown as
     * 343.10 if precision is 5. <P> The original value is always shown when the value is edited.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public Integer precision;

    /**
     * Declares the <code>FieldImportStrategy</code> for this field.  The default setting of null  has
     * the same meaning as "auto".  Note, this attribute only has an effect if all of the  following
     * are true:<ul> <li>The field declares a {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#foreignKey foreignKey}</li> <li>The field
     * declares a {@link com.smartgwt.client.docs.serverds.DataSourceField#displayField
     * displayField}</li> <li>The displayField so declared is {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#includeFrom included from} the  same
     * DataSource that the <code>foreignKey</code> declaration refers to</li> </ul> In any other
     * circumstances, this attribute is ignored. <p> <code>importStrategy</code> is applied by the
     * server-side  <code>DataImport.importToRows()</code> method, which is in turn used by {@link
     * com.smartgwt.client.widgets.BatchUploader} and several other DataImport APIs such as 
     * <code>importToDataSource()</code>, <code>importDataSourceRecords()</code> and 
     * <code>importAndValidateDSRows()</code>.  See the server-side documentation for details of these
     * APIs.  The actual data transformation is carried out by the  server-side API
     * <code>DataSource.transformImportValue()</code>; this method can  be overridden to carry out any
     * other transformation you may require.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.serverds.DataSourceField#batchUploadOperationId
     */
    public FieldImportStrategy importStrategy;

    /**
     * If true, this property indicates that this field will hold an explicit array of child nodes 
     * for the current node. This has the same effect as specifying {@link
     * com.smartgwt.client.docs.serverds.DataSource#childrenField DataSource.childrenField} to this
     * field's  name.
     *
     * <p>Default value is false
     * @see com.smartgwt.client.docs.serverds.DataSource#childrenField
     * @see com.smartgwt.client.docs.DataSourceRelations Relations
     */
    public Boolean childrenProperty;

    /**
     * Indicates that this field should always be Array-valued.  If the value derived from
     * {@link com.smartgwt.client.docs.serverds.DataSource#dataFormat XML or JSON data} is singular,
     * it will be wrapped in an Array.
     *  <p>
     *  <release13>
     *  JPA and Hibernate DataSources use <code>multiple:true</code> as part of the declaration of
     * One-To-Many and Many-to-Many relations - see {@link
     * com.smartgwt.client.docs.JpaHibernateRelations} for details.
     *  </release13>
     *  <release14>
     * On fields that also declare a {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#foreignKey foreignKey} 
     *  <code>multiple:true</code> also indicates that this field is participating in a 
     * one-to-many or many-to-many relation - see {@link com.smartgwt.client.docs.DataSourceRelations}
     * for details.
     *  </release14>
     *  <p>
     *  <h4>Criteria on multiple:true fields: client-side filtering</h4>
     *  <p>
     *  For simple Criteria, the criteria value is compared to <i>each</i> field value in the
     *  <code>multiple:true</code> field, according to the
     * {@link com.smartgwt.client.data.DSRequest#getTextMatchStyle textMatchStyle}.  If <i>any</i>
     * field value matches the
     * j filter value, the field is considered to match the criteria.
     *  <p>
     * For {@link com.smartgwt.client.docs.serverds.AdvancedCriteria}, for normal {@link
     * com.smartgwt.client.types.OperatorId search operators} the field
     *  value is considered as matching the <code>Criterion</code> if <i>any</i> of the field values
     *  match the Criterion.  Specifically, this is true of all operators that have an 
     * {@link com.smartgwt.client.types.OperatorValueType operatorValueType} of "fieldType" or
     * "valueRange".
     *  <p>
     *  For operators that compare against other fields in same record, such as "equalsField", 
     *  if the other field is <i>not</i> <code>multiple:true</code>, matching works the same as for
     *  normal operators, that is, as if <code>criterion.value</code> directly contained the value
     *  rather than the name of another field.
     *  <p>
     *  If the other field is <i>also</i> multiple:true, only "equalsField", "notEqualsField",
     *  "iEqualsField" and "iNotEqualsField" are allowed (any other <code>operator</code> will
     *  cause a warning and be ignored) and the set of values in the field must be identical (aside
     *  from case, for operators prefixed with "i") and in identical order to match.
     *  <p>
     *  For the <code>inSet</code> operator, the field matches if there is any intersection between
     *  the field values and the array of values provided in <code>criterion.value</code>.
     *  <code>notInSet</code> is the reverse.
     *  <p>
     *  "Finally, for "isNull" and "notNull", an empty Array is considered non-null, however,
     *  for "isBlank" and "notBlank", an empty Array is considered blank, since a control such
     *  as a multiple:true SelectItem or MultiComboBoxItem would appear blank to the end user if
     *  it had an empty Array as its value.
     *  <p>
     *  <h4>Server-side Representation and Storage</h4>
     *  <p>
     *  Values for multiple:true fields appear as Java Lists when received in server code such as a
     * DMI.  The Smart GWT Server supports simple storage of values that are multiple:true, controlled
     * via the {@link com.smartgwt.client.docs.serverds.DataSourceField#multipleStorage
     * multipleStorage} setting.
     *  <p>
     *  For server-side behavior of relation fields that are multiple:true, see 
     *  +link{group:dataSourceRelations); for the specifics of JPA and Hibernate relation fields that
     *  are multiple:true, see {@link com.smartgwt.client.docs.JpaHibernateRelations}.
     *  <p>
     *  For non-relation fields, the Smart GWT Server supports simple storage of values that are
     * multiple:true, controlled via the {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#multipleStorage multipleStorage} setting,
     * with some limited support
     * for server-side filtering, as described in the {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#multipleStorage multipleStorage} docs.
     *  <p>
     *  For the built-in SQL, Hibernate and JPA connectors, if criteria are specified for a
     *  multiple:true field where <code>multipleStorage</code> is null or "none", the Smart GWT
     *  server knows nothing about how the multiple values are stored, so as a fallback the criteria
     *  will operate as though the field were a normal, non-multiple "text" field.  This will
     *  generally <b>not</b> match the client-side filtering behavior described above, so filtering
     *  should either be performed entirely on the client (for example, via
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getDataFetchMode dataFetchMode:"local"} or
     * entirely on the server (via
     * {@link com.smartgwt.client.data.ResultSet#getUseClientFiltering
     * ResultSet.useClientFiltering}:"false")
     *  <p>
     *  The server-side filtering is done through a criteria transform which happens with
     * {@link com.smartgwt.client.docs.serverds.DataSource#transformMultipleFields
     * transformMultipleFields}.
     *  <p>
     *  <h4>XML Serialization</h4>
     *  <P>
     *  Specifically for XML serialization and deserialization, <code>multiple:true</code> behaves
     *  similarly to the 
     * <a href='http://www.google.com/search?hl=en&q=soap+array' target='_blank'>SOAP array idiom</a>,
     * that is,
     *  there will be a "wrapper element" named after the field name, whose contents will be several
     * elements of the specified {@link com.smartgwt.client.docs.serverds.DataSourceField#type
     * field.type}.  
     *  <P>
     * For example, {@link com.smartgwt.client.widgets.layout.Layout#getMembers Layout.members} is
     * declared with <code>type:"Canvas",
     *  multiple:true</code>.  The correct XML format is thus:
     *  <pre>
     *  &lt;VLayout&gt;
     *      &lt;members&gt;
     *          &lt;Canvas ID="myCanvas" ... /&gt;
     *          &lt;ListGrid ID="myGrid" .../&gt;
     *          &lt;Toolstrip ID="myToolStrip" ... /&gt;
     *      &lt;/members&gt;
     *  &lt;/VLayout&gt;
     *  </pre>
     *  <P>
     * See {@link com.smartgwt.client.docs.serverds.DataSourceField#childTagName childTagName} for
     * customizing the tagName used for subelements.
     *
     * <p>Default value is false
     * @see com.smartgwt.client.docs.ComponentSchema Component Schema
     */
    public Boolean multiple;

    /**
     * Specifies, for this field only, the type of condition field must match to be fetched from 
     * underlying source of data and delivered to the client. <p> This setting overrides the {@link
     * com.smartgwt.client.data.DSRequest#getOutputs DSRequest.outputs}, meaning that if field is
     * included in  request.outputs, but does not match outputWhen condition, it won't be fetched and
     * delivered  to the client. <p> This setting does not affect {@link
     * com.smartgwt.client.docs.serverds.OperationBinding#outputs OperationBinding.outputs}, meaning
     * that if field is  explicitly listed in operationBinding.outputs, then it will be fetched and
     * delivered to the  client regardless of outputWhen condition.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.serverds.OperationBinding#outputs
     * @see com.smartgwt.client.data.DSRequest#getOutputs
     */
    public OutputWhen outputWhen;

    /**
     * Indicates that getting {@link com.smartgwt.client.docs.serverds.DataSourceField#valueXPath
     * valueXPath} for this field should not perform any validation at all and will return null for
     * non existing XPaths. Otherwise warning message will be logged for non-existing XPath or with
     * null objects in the middle of XPath. <P> NOTE: this applies to server-side processing of
     * valueXPath only.
     *
     * <p>Default value is null
     */
    public Boolean lenientXPath;

    /**
     * Type of this field.  Required for all DataSource fields. <P> Field type may imply automatic
     * validators (for example, an integer field cannot accept the value "foo").  Field type also
     * affects the default behaviors of DataBound components, for example, if a field is declared as
     * type "date", components that edit that field will automatically choose a date-editing interface
     * with pop-up date picker.
     *
     * <p>Default value is null
     */
    public FieldType type;

    /**
     * Indicates that the specified {@link com.smartgwt.client.docs.VelocityExpression} must evaluate
     * to true if values for the field are to be fetched.  If the specified expression does not
     * evaluate to true, the field will be dropped as described for  {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#viewRequiresAuthentication
     * viewRequiresAuthentication}. <p> In addition to the normal context variables available to
     * Velocity expressions in Smart GWT, expressions you write for field-level <code>requires</code>
     * clauses - <code>viewRequires</code>,  {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#editRequires editRequires}, {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#initRequires initRequires} and  {@link
     * com.smartgwt.client.docs.serverds.DataSourceField#updateRequires updateRequires} - can
     * reference two additional variables:  <code>$fieldName</code> and <code>$dsName</code>.  These
     * are the names of the dataSource and  field currently undergoing <code>requires</code> checks. 
     * They are helpful because they allow you to write a generic checker function that can be used to
     * handle <code>requires</code> checks for multiple fields and dataSources.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.serverds.DataSourceField#viewRequiresAuthentication
     * @see com.smartgwt.client.docs.serverds.DataSourceField#viewRequiresRole
     * @see com.smartgwt.client.docs.serverds.DataSourceField#editRequires
     * @see com.smartgwt.client.docs.FieldLevelAuth Field-Level Security
     */
    public VelocityExpression viewRequires;

    /**
     * Whether this field should be considered a "detail" field by a {@link
     * com.smartgwt.client.widgets.DataBoundComponent}. <P> Detail fields won't be shown by default in
     * a DataBoundComponent where  {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getShowDetailFields
     * DataBoundComponent.showDetailFields} is false.  This allows for some DataBound components, like
     * a {@link com.smartgwt.client.widgets.grid.ListGrid}, to show a summary view of records which
     * displays only  the most commonly viewed fields by default, while other DataBoundComponents,
     * like a {@link com.smartgwt.client.widgets.viewer.DetailViewer}, show all fields by default. <P>
     * In addition, the {@link com.smartgwt.client.widgets.form.fields.FormItem#showIf
     * formItem.showIf} property is supported in multiple components for conditional visibility - see
     * for example {@link com.smartgwt.client.widgets.grid.ListGridField#showIf
     * ListGridField.showIf()} and {@link com.smartgwt.client.widgets.form.fields.FormItem#showIf
     * FormItem.showIf()}).
     *
     * <p>Default value is false
     * @see com.smartgwt.client.docs.ComponentBinding Component Binding
     */
    public boolean detail;

    /**
     * See {@link com.smartgwt.client.docs.serverds.DataSource#tableCode DataSource.tableCode}.
     *
     * <p>Default value is null
     */
    public String fkTableCode;

    /**
     * For use in {@link com.smartgwt.client.docs.ComponentSchema} for fields that contain other
     * components, this flag
     *  suppresses auto-construction for subcomponents that appear under this field.
     *  <P>
     * For example, the {@link com.smartgwt.client.widgets.layout.VLayout} schema sets this for its
     * {@link com.smartgwt.client.widgets.layout.Layout#getMembers members}
     *  property, so that when a VLayout is constructed via XML as follows:
     *  <pre>
     *  &lt;VLayout&gt;
     *      &lt;members&gt;
     *          &lt;ListGrid ID="myGrid" .../&gt;
     *          &lt;Toolstrip ID="myToolStrip" ... /&gt;
     *      &lt;/members&gt;
     *  &lt;/VLayout&gt;
     *  </pre>
     *  The ListGrid and ToolStrip do not construct themselves automatically.  Instead, the VLayout
     *  receives the properties of the ListGrid and ToolStrip as ordinary JavaScript Objects, with
     *  the special property <code>_constructor</code> set to the name of the class that should be
     *  constructed.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.ComponentSchema Component Schema
     */
    public Boolean propertiesOnly;

    /**
     * Format string to use when rendering the value in any {@link
     * com.smartgwt.client.widgets.DataBoundComponent} or when exporting via {@link
     * com.smartgwt.client.data.DataSource#exportData DataSource.exportData()} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#exportData ListGrid.exportData()} or  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#exportClientData ListGrid.exportClientData()}. <P>
     * Supported for fields of type "date", "time", "datetime", "int", "float" or any derived {@link
     * com.smartgwt.client.docs.serverds.SimpleType}.  <p> To configure a different format for export,
     * use {@link com.smartgwt.client.docs.serverds.DataSourceField#exportFormat exportFormat}. <p>
     * This is a per-field setting; you can alternatively set a default format for all "date", "time"
     * or "datetime" fields via    {@link
     * com.smartgwt.client.util.DateUtil#setNormalDatetimeDisplayFormat
     * DateUtil.setNormalDatetimeDisplayFormat()} and related methods on {@link
     * com.smartgwt.client.util.Date}.  See also {@link
     * com.smartgwt.client.docs.LocalizedNumberFormatting} for built-in {@link
     * com.smartgwt.client.types.FieldType FieldTypes} that handle localized currency formatting. <p>
     * Also note, this property takes precedence over any specified  {@link
     * com.smartgwt.client.data.DataSourceField#getDateFormatter dateFormatter}, but can be overridden
     * on a per-component basis by providing a formatter directly on the component, for example, via
     * {@link com.smartgwt.client.widgets.grid.ListGrid#setCellFormatter ListGrid.setCellFormatter()}
     * or {@link com.smartgwt.client.widgets.form.fields.FormItem#formatValue FormItem.formatValue()}.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.serverds.DataSourceField#exportFormat
     */
    public FormatString format;

}
