/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.widgets.form.fields;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * Specialized {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem} used for generating search criteria in the
 * {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterEditor FilterEditor} and in SearchForms. <P>     
 * SetFilterItem generates {@link com.smartgwt.client.types.OperatorId inSet and notInSet} filter criteria  from a set of
 * possible values, which can be provided via an explicit {@link
 * com.smartgwt.client.widgets.form.fields.FormItem#getValueMap valueMap} or  {@link
 * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getOptionDataSource optionDataSource}, or can be derived  from
 * the {@link com.smartgwt.client.widgets.form.fields.SetFilterItem#getFilterTargetComponent target databound component} or
 * a {@link com.smartgwt.client.widgets.form.fields.SetFilterItem#getSourceList list of records}.   <P> In particular, when
 * attached to a databound component such as a ListGrid,  SetFilterItem can provide "Excel-style filtering", allowing the
 * user to pick  from amongst whatever values are present in the dataset.   <P> For large datasets, SetFilterItem will also
 * intelligently use locally cached  data when possible, deriving its set of options from loaded data without the  need for
 * an extra dataSource fetch. Specifically, when  {@link com.smartgwt.client.data.ResultSet#allMatchingRowsCached all
 * matching records} are loaded in the {@link
 * com.smartgwt.client.widgets.form.fields.SetFilterItem#getFilterTargetComponent filterTargetComponent}, the options are
 * derived from already  loaded data. If the set of data is incomplete (due to  {@link
 * com.smartgwt.client.data.ResultSet#getFetchMode data paging}), the SetFilterItem will derive options  from its
 * optionDataSource. <P> Note that {@link com.smartgwt.client.widgets.form.fields.SetFilterItem#getDeriveUniqueValues
 * deriveUniqueValues} defaults to <code>true</code> for setFilterItems. <P> When a SetFilterItem is used as a  {@link
 * com.smartgwt.client.widgets.grid.ListGridField#getFilterEditorType ListGrid filterEditor}, the filterTargetComponent
 * will automatically be set to the grid being filtered. <p> The item's picker-component can be customized via settings
 * such as  {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSortField sortField}, or by configuring 
 * {@link com.smartgwt.client.types.AutoChild auto-children} like the  {@link
 * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getFilterForm search-form}, the  {@link
 * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickList main pickList-grid} or the separate list of  {@link
 * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectionList selected values}.  You can use  {@link
 * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getOptionFilterContext MultiPickerItem.optionFilterContext} to
 * apply custom <code>requestProperties</code> to fetches from the main <code>pickList</code> grid.
 */
@BeanFactory.FrameworkClass
public class SetFilterItem extends MultiPickerItem {

    public static SetFilterItem getOrCreateRef(JavaScriptObject jsObj) {
        if (jsObj == null) return null;

        final RefDataClass existingObj = RefDataClass.getRef(jsObj);

        if (existingObj instanceof SetFilterItem) {
            existingObj.setJsObj(jsObj);
            return (SetFilterItem)existingObj;
        } else

        {
            return new SetFilterItem(jsObj);
        }
    }
        


    /**
     * Changes the defaults for Canvas AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults Canvas defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.  For usage tips on this
     * param, see {@link com.smartgwt.client.docs.SGWTProperties}.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, Canvas defaults) /*-{
        if (defaults.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(SetFilterItem.@java.lang.Object::getClass()(), "changeAutoChildDefaults", "Canvas");
        }
        defaults.@com.smartgwt.client.widgets.BaseWidget::setConfigOnly(Z)(true);
        var cleanDefaultsJS = @com.smartgwt.client.util.JSOHelper::cleanProperties(Lcom/google/gwt/core/client/JavaScriptObject;Z)(defaults.@com.smartgwt.client.widgets.BaseWidget::getConfig()(), true);
        $wnd.isc.SetFilterItem.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    /**
     * Changes the defaults for FormItem AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults FormItem defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.  For usage tips on this
     * param, see {@link com.smartgwt.client.docs.SGWTProperties}.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, FormItem defaults) /*-{
        if (defaults.@com.smartgwt.client.widgets.form.fields.FormItem::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(SetFilterItem.@java.lang.Object::getClass()(), "changeAutoChildDefaults", "FormItem");
        }
        defaults.@com.smartgwt.client.widgets.form.fields.FormItem::setConfigOnly(Z)(true);
    	var cleanDefaultsJS = defaults.@com.smartgwt.client.widgets.form.fields.FormItem::getEditorTypeConfig()();
        $wnd.isc.SetFilterItem.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    public static native void changePickerIconDefaults(FormItemIcon defaults) /*-{
        $wnd.isc.SetFilterItem.changeDefaults("pickerIconDefaults", defaults.@com.smartgwt.client.core.DataClass::getJsObj()());
    }-*/;

    public SetFilterItem(){
        setAttribute("editorType", "SetFilterItem");
    }

    public SetFilterItem(JavaScriptObject jsObj){
        super(jsObj);
    }


    public SetFilterItem(String name) {
        setName(name);
                setAttribute("editorType", "SetFilterItem");
    }



    // ********************* Properties / Attributes ***********************

    /**
     * Should we show an {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getExpansionIcon
     * MultiPickerItem.expansionIcon} expand button allowing the user to show an expanded view of the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickList MultiPickerItem.pickList} with multiple fields. <P>
     * <code>canExpand</code> only applies to MultiPickerItems with selectionStyle set to "pickList" or "pickTree" and an
     * explicitly specified set  of {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getExpandedPickListFields
     * MultiPickerItem.expandedPickListFields} to display within the expanded view.
     *
     * @param canExpand New canExpand value. Default value is false
     * @return {@link com.smartgwt.client.widgets.form.fields.SetFilterItem SetFilterItem} instance, for chaining setter calls
     */
    public SetFilterItem setCanExpand(Boolean canExpand) {
        return (SetFilterItem)setAttribute("canExpand", canExpand);
    }

    /**
     * Should we show an {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getExpansionIcon
     * MultiPickerItem.expansionIcon} expand button allowing the user to show an expanded view of the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickList MultiPickerItem.pickList} with multiple fields. <P>
     * <code>canExpand</code> only applies to MultiPickerItems with selectionStyle set to "pickList" or "pickTree" and an
     * explicitly specified set  of {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getExpandedPickListFields
     * MultiPickerItem.expandedPickListFields} to display within the expanded view.
     *
     * @return Current canExpand value. Default value is false
     */
    public Boolean getCanExpand()  {
        Boolean result = getAttributeAsBoolean("canExpand", true);
        return result == null ? false : result;
    }
    

    /**
     * Should this item track unselected or selected values by default? <P> If {@link
     * com.smartgwt.client.widgets.form.fields.SetFilterItem#getToggleUseUnselectedValuesOnSelectAll
     * toggleUseUnselectedValuesOnSelectAll}, for setFilterItems with no current criteria (I.E. no explicitly selected or 
     * unselected values), this property will be evaluated when the pickList is  shown and {@link
     * com.smartgwt.client.widgets.form.fields.SetFilterItem#getUseUnselectedValues useUnselectedValues} will be set to match
     * this value. This causes the options in the pickList to always show up checked (or unchecked) by default, matching user
     * expectations of what an "empty" filter represents. <P> May be set to null, in which case useUnselectedValues will not be
     * modified when the pickList is shown for an empty SetFilterItem
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param defaultUseUnselectedValues New defaultUseUnselectedValues value. Default value is true
     * @return {@link com.smartgwt.client.widgets.form.fields.SetFilterItem SetFilterItem} instance, for chaining setter calls
     */
    public SetFilterItem setDefaultUseUnselectedValues(Boolean defaultUseUnselectedValues) {
        return (SetFilterItem)setAttribute("defaultUseUnselectedValues", defaultUseUnselectedValues);
    }

    /**
     * Should this item track unselected or selected values by default? <P> If {@link
     * com.smartgwt.client.widgets.form.fields.SetFilterItem#getToggleUseUnselectedValuesOnSelectAll
     * toggleUseUnselectedValuesOnSelectAll}, for setFilterItems with no current criteria (I.E. no explicitly selected or 
     * unselected values), this property will be evaluated when the pickList is  shown and {@link
     * com.smartgwt.client.widgets.form.fields.SetFilterItem#getUseUnselectedValues useUnselectedValues} will be set to match
     * this value. This causes the options in the pickList to always show up checked (or unchecked) by default, matching user
     * expectations of what an "empty" filter represents. <P> May be set to null, in which case useUnselectedValues will not be
     * modified when the pickList is shown for an empty SetFilterItem
     *
     * @return Current defaultUseUnselectedValues value. Default value is true
     */
    public Boolean getDefaultUseUnselectedValues()  {
        Boolean result = getAttributeAsBoolean("defaultUseUnselectedValues", true);
        return result == null ? true : result;
    }
    

    /**
     * If this MultiPickerItem is deriving its options from a dataSource, should it ensure unique field values by {@link
     * com.smartgwt.client.data.DSRequest#getGroupBy grouping by} the value field for this item? This is not necessary if the
     * target dataSource value field is already unique - for example if this is the primaryKey field for a dataSource. <P> Note
     * that for MultiPickerItems with <code>deriveUniqueValues:true</code>, any {@link
     * com.smartgwt.client.widgets.form.fields.SetFilterItem#getExpandedPickListFields expandedPickListFields} to be displayed
     * in the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getCanExpand expanded view} will not be able to
     * display meaningful values unless a  {@link com.smartgwt.client.data.DSRequest#getSummaryFunctions summaryFunction} is
     * supplied to produce aggregated values from the grouped data. This may be achieved by specifying  summaryFunctions
     * directly on the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getOptionFilterContext
     * optionFilterContext}, or on the  {@link com.smartgwt.client.data.DataSource#getOperationBindings operationBinding} for
     * the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getOptionOperationId fetch operation}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param deriveUniqueValues New deriveUniqueValues value. Default value is true
     * @return {@link com.smartgwt.client.widgets.form.fields.SetFilterItem SetFilterItem} instance, for chaining setter calls
     */
    public SetFilterItem setDeriveUniqueValues(Boolean deriveUniqueValues) {
        return (SetFilterItem)setAttribute("deriveUniqueValues", deriveUniqueValues);
    }

    /**
     * If this MultiPickerItem is deriving its options from a dataSource, should it ensure unique field values by {@link
     * com.smartgwt.client.data.DSRequest#getGroupBy grouping by} the value field for this item? This is not necessary if the
     * target dataSource value field is already unique - for example if this is the primaryKey field for a dataSource. <P> Note
     * that for MultiPickerItems with <code>deriveUniqueValues:true</code>, any {@link
     * com.smartgwt.client.widgets.form.fields.SetFilterItem#getExpandedPickListFields expandedPickListFields} to be displayed
     * in the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getCanExpand expanded view} will not be able to
     * display meaningful values unless a  {@link com.smartgwt.client.data.DSRequest#getSummaryFunctions summaryFunction} is
     * supplied to produce aggregated values from the grouped data. This may be achieved by specifying  summaryFunctions
     * directly on the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getOptionFilterContext
     * optionFilterContext}, or on the  {@link com.smartgwt.client.data.DataSource#getOperationBindings operationBinding} for
     * the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getOptionOperationId fetch operation}.
     *
     * @return Current deriveUniqueValues value. Default value is true
     */
    public Boolean getDeriveUniqueValues()  {
        Boolean result = getAttributeAsBoolean("deriveUniqueValues", true);
        return result == null ? true : result;
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.form.fields.SetFilterItem#getCanExpand canExpand} is true, this is the list of
     * fields to display in the  PickList or {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickTree
     * pickTree} when the picker is expanded
     *
     * @param expandedPickListFields New expandedPickListFields value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.SetFilterItem SetFilterItem} instance, for chaining setter calls
     */
    public SetFilterItem setExpandedPickListFields(ListGridField... expandedPickListFields) {
        return (SetFilterItem)setAttribute("expandedPickListFields", expandedPickListFields);
    }

    /**
     * If {@link com.smartgwt.client.widgets.form.fields.SetFilterItem#getCanExpand canExpand} is true, this is the list of
     * fields to display in the  PickList or {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickTree
     * pickTree} when the picker is expanded
     *
     * @return Current expandedPickListFields value. Default value is null
     */
    public ListGridField[] getExpandedPickListFields()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfListGridField(getAttributeAsJavaScriptObject("expandedPickListFields"));
    }
    

    /**
     * Target component for which this SetFilterItem is generating criteria. By default the {@link
     * com.smartgwt.client.widgets.form.fields.SetFilterItem#getSourceList sourceList} will be the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getData data object} for the target component, and the option dataSource,
     * option criteria, option fetch operation and so on will be derived from the target component's configuration. <P> For a
     * setFilterItem embedded in a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filter editor}, this
     * will be the target listGrid.
     *
     * @param filterTargetComponent New filterTargetComponent value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.SetFilterItem SetFilterItem} instance, for chaining setter calls
     */
    public SetFilterItem setFilterTargetComponent(DataBoundComponent filterTargetComponent) {
        return (SetFilterItem)setAttribute("filterTargetComponent", filterTargetComponent == null ? null : ((Canvas)filterTargetComponent).getOrCreateJsObj());
    }

    /**
     * Target component for which this SetFilterItem is generating criteria. By default the {@link
     * com.smartgwt.client.widgets.form.fields.SetFilterItem#getSourceList sourceList} will be the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getData data object} for the target component, and the option dataSource,
     * option criteria, option fetch operation and so on will be derived from the target component's configuration. <P> For a
     * setFilterItem embedded in a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filter editor}, this
     * will be the target listGrid.
     *
     * @return Current filterTargetComponent value. Default value is null
     */
    public DataBoundComponent getFilterTargetComponent()  {
        return (DataBoundComponent)Canvas.getByJSObject(getAttributeAsJavaScriptObject("filterTargetComponent"));
    }
    

    /**
     * Optional list of fields for the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickList
     * MultiPickerItem.pickList}. This property may be used to customize the appearance of the field / fields in the pickList.
     * <P> If not explicitly specified, pick list fields will be generated automatically to show the  display field (or value
     * field if there is no display field) for each option. <P> Note that if {@link
     * com.smartgwt.client.widgets.form.fields.SetFilterItem#getCanExpand canExpand} is true, developers should use {@link
     * com.smartgwt.client.widgets.form.fields.SetFilterItem#getExpandedPickListFields expandedPickListFields} to specify the
     * set of fields to display in the expanded view.
     *
     * @param pickListFields New pickListFields value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.SetFilterItem SetFilterItem} instance, for chaining setter calls
     */
    public SetFilterItem setPickListFields(ListGridField... pickListFields) {
        return (SetFilterItem)setAttribute("pickListFields", pickListFields);
    }

    /**
     * Optional list of fields for the {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem#getPickList
     * MultiPickerItem.pickList}. This property may be used to customize the appearance of the field / fields in the pickList.
     * <P> If not explicitly specified, pick list fields will be generated automatically to show the  display field (or value
     * field if there is no display field) for each option. <P> Note that if {@link
     * com.smartgwt.client.widgets.form.fields.SetFilterItem#getCanExpand canExpand} is true, developers should use {@link
     * com.smartgwt.client.widgets.form.fields.SetFilterItem#getExpandedPickListFields expandedPickListFields} to specify the
     * set of fields to display in the expanded view.
     *
     * @return Current pickListFields value. Default value is null
     */
    public ListGridField[] getPickListFields()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfListGridField(getAttributeAsJavaScriptObject("pickListFields"));
    }
    

    /**
     * Operator for the criteria generated by this item when {@link
     * com.smartgwt.client.widgets.form.fields.SetFilterItem#getUseUnselectedValues useUnselectedValues} is  false.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param selectedOperator New selectedOperator value. Default value is "inSet"
     * @return {@link com.smartgwt.client.widgets.form.fields.SetFilterItem SetFilterItem} instance, for chaining setter calls
     */
    public SetFilterItem setSelectedOperator(OperatorId selectedOperator) {
        return (SetFilterItem)setAttribute("selectedOperator", selectedOperator == null ? null : selectedOperator.getValue());
    }

    /**
     * Operator for the criteria generated by this item when {@link
     * com.smartgwt.client.widgets.form.fields.SetFilterItem#getUseUnselectedValues useUnselectedValues} is  false.
     *
     * @return Current selectedOperator value. Default value is "inSet"
     */
    public OperatorId getSelectedOperator()  {
        return EnumUtil.getEnum(OperatorId.values(), getAttribute("selectedOperator"));
    }
    

    /**
     * selectionStyle:"shuttle" is not supported for SetFilterItem
     *
     * @param selectionStyle New selectionStyle value. Default value is "pickList"
     * @return {@link com.smartgwt.client.widgets.form.fields.SetFilterItem SetFilterItem} instance, for chaining setter calls
     */
    public SetFilterItem setSelectionStyle(MultiPickerSelectionStyle selectionStyle) {
        return (SetFilterItem)setAttribute("selectionStyle", selectionStyle == null ? null : selectionStyle.getValue());
    }

    /**
     * selectionStyle:"shuttle" is not supported for SetFilterItem
     *
     * @return Current selectionStyle value. Default value is "pickList"
     */
    public MultiPickerSelectionStyle getSelectionStyle()  {
        return EnumUtil.getEnum(MultiPickerSelectionStyle.values(), getAttribute("selectionStyle"));
    }
    
    

    /**
     * Should this item toggle between tracking selected options and using them to generate "inSet" criteria and unselected
     * options and using them to generate "notInSet" criteria when the user clicks the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectAllButton MultiPickerItem.selectAllButton} and {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getDeselectAllButton MultiPickerItem.deselectAllButton} on an
     * unfiltered list of options. <P> See {@link com.smartgwt.client.widgets.form.fields.SetFilterItem#getUseUnselectedValues
     * useUnselectedValues} for more detail
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param toggleUseUnselectedValuesOnSelectAll New toggleUseUnselectedValuesOnSelectAll value. Default value is true
     * @return {@link com.smartgwt.client.widgets.form.fields.SetFilterItem SetFilterItem} instance, for chaining setter calls
     */
    public SetFilterItem setToggleUseUnselectedValuesOnSelectAll(Boolean toggleUseUnselectedValuesOnSelectAll) {
        return (SetFilterItem)setAttribute("toggleUseUnselectedValuesOnSelectAll", toggleUseUnselectedValuesOnSelectAll);
    }

    /**
     * Should this item toggle between tracking selected options and using them to generate "inSet" criteria and unselected
     * options and using them to generate "notInSet" criteria when the user clicks the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectAllButton MultiPickerItem.selectAllButton} and {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getDeselectAllButton MultiPickerItem.deselectAllButton} on an
     * unfiltered list of options. <P> See {@link com.smartgwt.client.widgets.form.fields.SetFilterItem#getUseUnselectedValues
     * useUnselectedValues} for more detail
     *
     * @return Current toggleUseUnselectedValuesOnSelectAll value. Default value is true
     */
    public Boolean getToggleUseUnselectedValuesOnSelectAll()  {
        Boolean result = getAttributeAsBoolean("toggleUseUnselectedValuesOnSelectAll", true);
        return result == null ? true : result;
    }
    

    /**
     * Operator for the criteria generated by this item when {@link
     * com.smartgwt.client.widgets.form.fields.SetFilterItem#getUseUnselectedValues useUnselectedValues} is  true.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param unselectedOperator New unselectedOperator value. Default value is "notInSet"
     * @return {@link com.smartgwt.client.widgets.form.fields.SetFilterItem SetFilterItem} instance, for chaining setter calls
     */
    public SetFilterItem setUnselectedOperator(OperatorId unselectedOperator) {
        return (SetFilterItem)setAttribute("unselectedOperator", unselectedOperator == null ? null : unselectedOperator.getValue());
    }

    /**
     * Operator for the criteria generated by this item when {@link
     * com.smartgwt.client.widgets.form.fields.SetFilterItem#getUseUnselectedValues useUnselectedValues} is  true.
     *
     * @return Current unselectedOperator value. Default value is "notInSet"
     */
    public OperatorId getUnselectedOperator()  {
        return EnumUtil.getEnum(OperatorId.values(), getAttribute("unselectedOperator"));
    }
    

    /**
     * The SetFilterItem has the capability to treat its set of options as  selected by default, and explicitly track the
     * options a user has unselected, or treat them as unselected by default and explicitly track the user-selected objects.
     * This attribute denotes whether the item is currently tracking explicitly  selected or unselected values. <P> While
     * tracking selected values, this item will generate  {@link
     * com.smartgwt.client.widgets.form.fields.SetFilterItem#getSelectedOperator inSet} criteria. While tracking unselected
     * values, it will generate {@link com.smartgwt.client.widgets.form.fields.SetFilterItem#getUnselectedOperator notInSet}
     * criteria. <P> If {@link com.smartgwt.client.widgets.form.fields.SetFilterItem#getToggleUseUnselectedValuesOnSelectAll
     * toggleUseUnselectedValuesOnSelectAll} is true, if the current set of options is unfiltered, the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectAllButton MultiPickerItem.selectAllButton} and {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getDeselectAllButton MultiPickerItem.deselectAllButton} will
     * clear any current value and toggle useUnselectedValues - effectively switching between tracking inclusive (inSet) values
     * and exclusive (notInSet) values.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Clear any current value for this item and dynamically update {@link com.smartgwt.client.widgets.form.fields.SetFilterItem#getUseUnselectedValues useUnselectedValues}.
     *
     * @param useUnselectedValues new value for useUnselectedValues. Default value is true
     * @return {@link com.smartgwt.client.widgets.form.fields.SetFilterItem SetFilterItem} instance, for chaining setter calls
     */
    public SetFilterItem setUseUnselectedValues(Boolean useUnselectedValues) {
        return (SetFilterItem)setAttribute("useUnselectedValues", useUnselectedValues);
    }

    /**
     * The SetFilterItem has the capability to treat its set of options as  selected by default, and explicitly track the
     * options a user has unselected, or treat them as unselected by default and explicitly track the user-selected objects.
     * This attribute denotes whether the item is currently tracking explicitly  selected or unselected values. <P> While
     * tracking selected values, this item will generate  {@link
     * com.smartgwt.client.widgets.form.fields.SetFilterItem#getSelectedOperator inSet} criteria. While tracking unselected
     * values, it will generate {@link com.smartgwt.client.widgets.form.fields.SetFilterItem#getUnselectedOperator notInSet}
     * criteria. <P> If {@link com.smartgwt.client.widgets.form.fields.SetFilterItem#getToggleUseUnselectedValuesOnSelectAll
     * toggleUseUnselectedValuesOnSelectAll} is true, if the current set of options is unfiltered, the {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getSelectAllButton MultiPickerItem.selectAllButton} and {@link
     * com.smartgwt.client.widgets.form.fields.MultiPickerItem#getDeselectAllButton MultiPickerItem.deselectAllButton} will
     * clear any current value and toggle useUnselectedValues - effectively switching between tracking inclusive (inSet) values
     * and exclusive (notInSet) values.
     *
     * @return Current useUnselectedValues value. Default value is true
     */
    public Boolean getUseUnselectedValues()  {
        Boolean result = getAttributeAsBoolean("useUnselectedValues", true);
        return result == null ? true : result;
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    /** 
     * Class level method to set the default properties of this class.  If set, then all
     * existing and subsequently created instances of this class will automatically have
     * default properties corresponding to
     * the properties of the class instance passed to this function.
     * This is a powerful feature that eliminates the need for users to create a separate
     * hierarchy of subclasses that only alter the default properties of this class. Can also
     * be used for skinning / styling purposes.  <P> <b>Note:</b> This method is intended for
     * setting default attributes only and will affect all instances of the underlying class
     * (including those automatically generated in JavaScript).  This method should not be used
     * to apply standard EventHandlers or override methods for a class - use a custom subclass
     * instead.  Calling this method after instances have been created can result in undefined
     * behavior, since it bypasses any setters and a class instance may have already examined 
     * a particular property and not be expecting any changes through this route.
     *
     * @param setFilterItemProperties properties that should be used as new defaults when instances of this class are created
     * @see com.smartgwt.client.docs.SGWTProperties
     */
    public static native void setDefaultProperties(SetFilterItem setFilterItemProperties) /*-{
        if (setFilterItemProperties.@com.smartgwt.client.widgets.form.fields.FormItem::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Class;)(SetFilterItem.@java.lang.Object::getClass()(), "setDefaultProperties", setFilterItemProperties.@java.lang.Object::getClass()());
        }
        setFilterItemProperties.@com.smartgwt.client.widgets.form.fields.FormItem::setConfigOnly(Z)(true);
    	var properties = setFilterItemProperties.@com.smartgwt.client.widgets.form.fields.FormItem::getConfig()();
        $wnd.isc.SetFilterItem.addProperties(properties);
    }-*/;

    // ***********************************************************

}
