/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.attributeparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.uibinder.attributeparsers.FieldReferenceConverter;
import com.google.gwt.uibinder.attributeparsers.StrictAttributeParser;
import com.google.gwt.uibinder.attributeparsers.StringAttributeParser;
import com.google.gwt.uibinder.rebind.MortalLogger;
import com.google.gwt.uibinder.rebind.XMLElement;

public class SafeUriAttributeParser
extends StrictAttributeParser {
    private final boolean runtimeStringsAllowed;
    private final StringAttributeParser stringParser;

    public static String wrapUnsafeStringAndWarn(MortalLogger logger, XMLElement source, String expression) {
        logger.warn(source, "Escaping unsafe runtime String expression used for URI with UriUtils.fromString(). Use SafeUri instead", new Object[0]);
        return "UriUtils.fromString(" + expression + ")";
    }

    SafeUriAttributeParser(StringAttributeParser stringParser, FieldReferenceConverter converter, JType safeUriType, JType stringType, MortalLogger logger) {
        super(converter, logger, safeUriType, stringType);
        this.stringParser = stringParser;
        this.runtimeStringsAllowed = true;
    }

    SafeUriAttributeParser(StringAttributeParser stringParser, FieldReferenceConverter converter, JType safeUriType, MortalLogger logger) {
        super(converter, logger, safeUriType);
        this.stringParser = stringParser;
        this.runtimeStringsAllowed = false;
    }

    @Override
    public String parse(XMLElement source, String value) throws UnableToCompleteException {
        int howManyFieldRefs = FieldReferenceConverter.countFieldReferences(value);
        if (howManyFieldRefs == 0) {
            return "UriUtils.fromSafeConstant(" + this.stringParser.parse(source, value) + ")";
        }
        if (!this.runtimeStringsAllowed || howManyFieldRefs == 1 && value.substring(0, 1).equals("{") && value.substring(value.length() - 1, value.length()).equals("}")) {
            return super.parse(source, value);
        }
        return SafeUriAttributeParser.wrapUnsafeStringAndWarn(this.logger, source, this.stringParser.parse(source, value));
    }
}

