/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.tools;

import com.isomorphic.base.Base;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLConnectionManager;
import com.isomorphic.util.DataTools;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelDataImport
extends Base {
    private static Logger log = new Logger(ExcelDataImport.class.getName());
    private int firstColumnToImport = 0;
    private int lastColumnToImport = Integer.MAX_VALUE;
    private int ignoreLeadingRows = 0;
    private boolean firstRowMetadata = true;
    private boolean stopAtBlankHeader = true;
    private DataSource dataSource;
    private Map columnRemap;
    private InputStream in;
    private Row metadataRow;
    private List fields;
    private Workbook workbook;
    private DataFormat dataFormat;

    public static List importExcelStream(InputStream in, DataSource schema, Map columnRemap, int ignoreLeadingRows, int firstCol, int lastCol, boolean firstRowIsMetadata) throws Exception {
        ExcelDataImport edi = new ExcelDataImport();
        edi.setIgnoreLeadingRows(ignoreLeadingRows);
        edi.setFirstRowMetadata(firstRowIsMetadata);
        edi.setFirstColumnToImport(firstCol);
        edi.setLastColumnToImport(lastCol);
        edi.setColumnRemap(columnRemap);
        return edi.importStream(in);
    }

    public int getFirstColumnToImport() {
        return this.firstColumnToImport;
    }

    public void setFirstColumnToImport(int firstColumnToImport) {
        this.firstColumnToImport = firstColumnToImport;
    }

    public int getLastColumnToImport() {
        if (this.shouldStopAtBlankHeader() && this.isFirstRowMetadata()) {
            for (int i = this.getFirstColumnToImport(); i < this.metadataRow.getLastCellNum(); ++i) {
                if (this.metadataRow.getCell(i) != null) continue;
                if (i > this.lastColumnToImport) break;
                return i - 1;
            }
        }
        return this.lastColumnToImport;
    }

    public void setLastColumnToImport(int lastColumnToImport) {
        this.lastColumnToImport = lastColumnToImport;
    }

    public int getIgnoreLeadingRows() {
        return this.ignoreLeadingRows;
    }

    public void setIgnoreLeadingRows(int ignoreLeadingRows) {
        this.ignoreLeadingRows = ignoreLeadingRows;
    }

    public boolean isFirstRowMetadata() {
        return this.firstRowMetadata;
    }

    public void setFirstRowMetadata(boolean firstRowMetadata) {
        this.firstRowMetadata = firstRowMetadata;
    }

    public boolean shouldStopAtBlankHeader() {
        return this.stopAtBlankHeader;
    }

    public void setStopAtBlankHeader(boolean stopAtBlankHeader) {
        this.stopAtBlankHeader = stopAtBlankHeader;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Map getColumnRemap() {
        return this.columnRemap;
    }

    public void setColumnRemap(Map columnRemap) {
        this.columnRemap = columnRemap;
    }

    public ExcelDataImport() {
    }

    public ExcelDataImport(InputStream in) {
        this.in = in;
    }

    public List importStream(InputStream in) throws Exception {
        this.in = in;
        return this.importStream();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List importStream() throws Exception {
        InputStream input = null;
        try {
            input = DataTools.isEmptyStream((InputStream)this.in);
        }
        catch (IOException ex) {
            throw new IOException("No file provided");
        }
        this.workbook = WorkbookFactory.create((InputStream)input);
        this.dataFormat = this.workbook.createDataFormat();
        Sheet sheet = this.workbook.getSheetAt(0);
        if (this.dataSource != null) {
            this.fields = this.dataSource.getFieldNames();
        }
        int start = this.getIgnoreLeadingRows();
        if (this.isFirstRowMetadata()) {
            this.metadataRow = sheet.getRow(start);
            ++start;
        }
        ArrayList list = new ArrayList();
        int i = start;
        while (i <= sheet.getLastRowNum()) {
            Row row = sheet.getRow(i);
            if (row != null) {
                LinkedHashMap<String, Object> record = new LinkedHashMap<String, Object>();
                int lastCol = Math.min(this.getLastColumnToImport(), row.getLastCellNum());
                block11: for (int j = this.getFirstColumnToImport(); j < lastCol; ++j) {
                    Cell cell = row.getCell(j);
                    if (cell == null) continue;
                    CellType cellType = cell.getCellType();
                    if (cellType == CellType.FORMULA) {
                        cellType = cell.getCachedFormulaResultType();
                    }
                    Object value = null;
                    switch (cellType) {
                        case NUMERIC: {
                            if (this.isDateCell(cell)) {
                                value = cell.getDateCellValue();
                                break;
                            }
                            double workVal = cell.getNumericCellValue();
                            if (workVal == Math.floor(workVal)) {
                                value = Math.round(workVal);
                                break;
                            }
                            value = workVal;
                            break;
                        }
                        case STRING: {
                            value = cell.getStringCellValue();
                            if (value != null && !value.equals("")) break;
                            continue block11;
                        }
                        case FORMULA: {
                            log.warn((Object)("Found cell claiming to be CELL_TYPE_FORMULA at cell (" + i + ", " + j + ")"));
                            break;
                        }
                        case BLANK: {
                            continue block11;
                        }
                        case BOOLEAN: {
                            value = cell.getBooleanCellValue();
                            break;
                        }
                        case ERROR: {
                            log.warn((Object)("Found cell claiming to be CELL_TYPE_ERROR at cell (" + i + ", " + j + ")"));
                            continue block11;
                        }
                    }
                    if (value == null) continue;
                    record.put(this.getFieldName(cell), value);
                }
                if (record.size() != 0) {
                    list.add(record);
                }
            }
            ++i;
        }
        return list;
    }

    protected boolean isDateCell(Cell cell) {
        DSField field;
        if (this.dataSource != null && (field = this.getSchemaFieldForCell(cell)) != null) {
            return "date".equals(field.getType()) || "datetime".equals(field.getType()) || "time".equals(field.getType());
        }
        return this.isDateFormat(cell.getCellStyle().getDataFormat());
    }

    protected boolean isDateFormat(short format) {
        String fmtString = this.dataFormat.getFormat(format);
        if (fmtString == null) {
            return false;
        }
        return (fmtString = fmtString.toUpperCase()).contains("YY") || fmtString.contains("MM") || fmtString.contains("DD") || fmtString.contains("HH");
    }

    protected String getFieldName(Cell cell) {
        String title;
        DSField field = this.getSchemaFieldForCell(cell);
        if (field != null) {
            return field.getName();
        }
        int col = cell.getColumnIndex();
        if (this.columnRemap != null) {
            if (this.columnRemap.get(col) != null) {
                return (String)this.columnRemap.get(col);
            }
            if (this.metadataRow != null && this.columnRemap.get(title = this.metadataRow.getCell(col).getStringCellValue()) != null) {
                return (String)this.columnRemap.get(title);
            }
        }
        if (this.metadataRow != null && (title = this.metadataRow.getCell(col).getStringCellValue()) != null) {
            return this.toFieldName(title);
        }
        return this.toSpreadsheetColumnId(col);
    }

    protected String toFieldName(String title) {
        Object fieldName = "";
        if ((title = title.trim()).contains(" ")) {
            boolean nextCap = false;
            for (int i = 0; i < title.length(); ++i) {
                if (title.charAt(i) == ' ' || title.charAt(i) == '-') {
                    nextCap = true;
                    continue;
                }
                String charAt = title.substring(i, i + 1);
                fieldName = (String)fieldName + (nextCap ? charAt.toUpperCase() : charAt.toLowerCase());
                nextCap = false;
            }
        } else {
            fieldName = title;
        }
        if (this.fields != null) {
            for (String schemaFieldName : this.fields) {
                if (!schemaFieldName.toLowerCase().equals(((String)fieldName).toLowerCase())) continue;
                return schemaFieldName;
            }
        }
        return fieldName;
    }

    protected String toSpreadsheetColumnId(int index) {
        String letters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        int firstIndex = index / 26;
        int secondIndex = index % 26;
        if (firstIndex == 0) {
            return letters.substring(secondIndex, secondIndex + 1);
        }
        return letters.substring(firstIndex - 1, firstIndex) + letters.substring(secondIndex, secondIndex + 1);
    }

    protected DSField getSchemaFieldForCell(Cell cell) {
        if (this.dataSource == null) {
            return null;
        }
        int col = cell.getColumnIndex();
        String remap = null;
        if (this.columnRemap != null) {
            if (this.columnRemap.get("" + col) != null) {
                remap = (String)this.columnRemap.get("" + col);
            }
            if (this.metadataRow != null) {
                String title = this.metadataRow.getCell(col).getStringCellValue();
                if (this.columnRemap.get(title) != null) {
                    remap = (String)this.columnRemap.get(title);
                } else if (title != null) {
                    if (remap == null) {
                        remap = this.matchFieldTitle(title);
                    }
                    if (remap == null) {
                        remap = this.toFieldName(title);
                    }
                }
            }
        }
        if (remap == null && this.metadataRow != null) {
            remap = this.matchFieldTitle(this.metadataRow.getCell(col).getStringCellValue());
        }
        if (remap == null) {
            return null;
        }
        return this.dataSource.getField(remap);
    }

    protected String matchFieldTitle(String title) {
        if (title == null || this.dataSource == null) {
            return null;
        }
        for (String fieldName : this.dataSource.getFieldNames()) {
            if (!title.equals(this.dataSource.getField(fieldName).getTitle())) continue;
            return fieldName;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            DataSource ds;
            FileInputStream in;
            DefaultParser parser = new DefaultParser();
            String cmdLineSyntax = "excelImport [options]";
            Options options = new Options();
            options.addOption("f", "file", true, ".xls file to import (path is relative to cwd).  Required");
            options.addOption("d", "dataSource", true, "DataSource name.  Required");
            options.addOption("s", "skip", true, "Skip this many rows before starting to process data. Defaults to 0");
            options.addOption("c", "firstColumn", true, "Index of first column to import. Defaults to 0");
            options.addOption("l", "lastColumn", true, "Index of last column to import. Defaults to the last column in the spreadsheet");
            options.addOption("m", "firstRowIsntMetadata", false, "Treat first row as normal data. The normal behavior is to treat the first row as metadata (ie, as field names or titles rather than data)");
            options.addOption("b", "stopAtBlankHeader", false, "If the first row is metadata, indicates that we will consider the rightmost column for import purposes to be the one immediately to the left of the first blank cell in the first row. This allows for the common case where the original spreadsheet contains important information other than the actual data to be imported - just place the other data to the right of the import data, and leave a gap on the first row");
            options.addOption("x", "clearFirst", false, "Clear the database table before importing");
            options.addOption("h", "help", false, "Show usage message and exit");
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("h") || !line.hasOption("f") || !line.hasOption("d")) {
                ExcelDataImport.outputHelp(cmdLineSyntax, options);
                return;
            }
            try {
                in = new FileInputStream(line.getOptionValue("f"));
            }
            catch (FileNotFoundException e) {
                System.out.println("File " + line.getOptionValue("f") + " not found");
                return;
            }
            try {
                ds = DataSourceManager.getDataSource((String)line.getOptionValue("d"), null);
            }
            catch (Exception e) {
                System.out.println("Could not create DataSource " + line.getOptionValue("d"));
                System.out.println(e.getMessage());
                return;
            }
            ExcelDataImport edi = new ExcelDataImport(in);
            edi.setDataSource(ds);
            if (line.hasOption("s")) {
                edi.setIgnoreLeadingRows(Integer.parseInt(line.getOptionValue("s")));
            }
            if (line.hasOption("c")) {
                edi.setFirstColumnToImport(Integer.parseInt(line.getOptionValue("c")));
            }
            if (line.hasOption("l")) {
                edi.setLastColumnToImport(Integer.parseInt(line.getOptionValue("l")));
            }
            edi.setFirstRowMetadata(!line.hasOption("m"));
            edi.setStopAtBlankHeader(line.hasOption("b"));
            List data = edi.importStream();
            if (data == null || data.size() == 0) {
                System.out.println("File " + line.getOptionValue("f") + " contained no importable data");
                return;
            }
            if (line.hasOption("x")) {
                String tableName = (String)ds.getConfig().get((Object)"tableName");
                if (tableName == null) {
                    System.out.println("DataSource has invalid tableName property - perhaps it isn't a SQLDataSource?");
                    return;
                }
                String dbName = (String)ds.getConfig().get((Object)"dbName");
                Connection conn = SQLConnectionManager.getConnection((String)dbName);
                Statement stmt = conn.createStatement();
                try {
                    stmt.executeUpdate("TRUNCATE TABLE " + tableName);
                }
                finally {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Exception exception) {}
                    }
                    SQLConnectionManager.free((Connection)conn);
                }
            }
            for (Map record : data) {
                ds.add((Object)record);
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
    }

    public static void outputHelp(String cmdLineSyntax, Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(cmdLineSyntax, "", options, "\nUtility to import an Excel spreadsheet into a SmartClient SQL DataSource.  Note that the file and dataSource options are required.\n\nExample:\n> excelImport -f /home/iscdev/worldDS.xls -d worldDS -bx");
    }
}

