/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.base;

import com.isomorphic.base.ConfigLoader;
import com.isomorphic.base.IAutoConfigurable;
import com.isomorphic.base.Reflection;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.naming.JNDI;
import com.isomorphic.util.AtomicFileOutputStream;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import org.apache.commons.lang3.StringUtils;

public class Config
extends DataTypeMap {
    private static Logger log = new Logger(Config.class.getName());
    public static List loadedConfigFiles = new ArrayList();
    protected static Config globalConfig = null;
    protected boolean threadLocalEnabled;
    protected Map _savedMap = null;
    protected Map _savedCache = null;
    protected final ThreadLocal<Stack> threadLocalStackContainer = new ThreadLocal();
    private Set setPropertyKeys;
    public Config[] interpolateCascade = null;
    public Map cache = new ConcurrentHashMap();
    protected boolean doInterpolate = true;
    private static final Pattern ENV_VAR_PATTERN = Pattern.compile("(?<!\\\\)(?:(?:\\$ENV\\{)|(?:\\$\\{ENV:))([^}{]+)\\}");
    private static final Pattern SYS_PATTERN = Pattern.compile("(?<!\\\\)(?:(?:\\$SYS\\{))([^}{]+)\\}");
    private static final Pattern VAR_PATTERN = Pattern.compile("(?<!\\\\)\\$\\{([^}{]+)\\}");
    private static final Pattern BARE_VAR_PATTERN = Pattern.compile("(?<!\\\\)\\$(?!ENV)([\\w.]+)");
    private static final Pattern JNDI_PATTERN = Pattern.compile("(?<!\\\\)jndi\\:([^:]+):([^:]+)?:(\\S+)");
    private static final Pattern REF_ESCAPE_PATTERN = Pattern.compile("\\\\\\$");
    private static PathExpansionVariable[] pathExpansionVariables = null;
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    public static Config getGlobal(boolean initIfNull) {
        if (globalConfig == null && initIfNull) {
            try {
                Config.initGlobalConfig(false);
            }
            catch (Exception e) {
                log.error(e);
            }
        }
        return globalConfig;
    }

    public static Config getGlobal() {
        return Config.getGlobal(true);
    }

    public static Object getProperty(String propertyName) {
        return Config.getGlobal().get(propertyName);
    }

    protected Map getCache() {
        if (!this.threadLocalEnabled) {
            return this.cache;
        }
        Map stateContainer = this.getStateContainer();
        return stateContainer == null ? this.cache : (Map)stateContainer.get("cache");
    }

    protected Map getMap() {
        if (!this.threadLocalEnabled) {
            return this.map;
        }
        Map stateContainer = this.getStateContainer();
        return stateContainer == null ? this.map : (Map)stateContainer.get("map");
    }

    public void setGlobalOverrides(Map overrides) {
        this.clearGlobalOverrides();
        this._savedMap = this.map;
        this._savedCache = this.cache;
        Map map = this.cloneMap(this.getMap());
        map.putAll(overrides);
        this.map = map;
        this.cache = new ConcurrentHashMap();
    }

    public void clearGlobalOverrides() {
        if (this._savedMap != null) {
            this.map = this._savedMap;
            this._savedMap = null;
        }
        if (this._savedCache != null) {
            this.cache = this._savedCache;
            this._savedCache = null;
        }
    }

    public boolean globalOverridesInEffect() {
        return this._savedMap != null || this._savedCache != null;
    }

    public void pushThreadLocal(Map overrides) {
        Stack<DataTypeMap> threadLocalStack = this.threadLocalStackContainer.get();
        if (threadLocalStack == null) {
            threadLocalStack = new Stack<DataTypeMap>();
            this.threadLocalStackContainer.set(threadLocalStack);
        }
        Map map = this.cloneMap(this.getMap());
        map.putAll(overrides);
        DataTypeMap stateContainer = DataTools.buildMap("map", map, "cache", new ConcurrentHashMap());
        threadLocalStack.push(stateContainer);
    }

    public Map getStateContainer() {
        Stack threadLocalStack = this.threadLocalStackContainer.get();
        if (threadLocalStack != null && !threadLocalStack.isEmpty()) {
            return (Map)threadLocalStack.peek();
        }
        return null;
    }

    public void popThreadLocal() {
        Stack threadLocalStack = this.threadLocalStackContainer.get();
        if (this.threadLocalStackContainer != null) {
            try {
                threadLocalStack.pop();
            }
            catch (EmptyStackException ese) {
                log.warn((Object)"No stack in popThreadLocal()", ese);
            }
        }
    }

    public boolean threadLocalInEffect() {
        return this.threadLocalEnabled && this.getMap() != this.map;
    }

    public void purgeThreadLocal() {
        this.threadLocalStackContainer.remove();
    }

    protected Map decorated() {
        return this.getMap();
    }

    public static Config initGlobalConfig() throws Exception {
        return Config.initGlobalConfig(true);
    }

    public static synchronized Config initGlobalConfig(boolean reloadConfig) throws Exception {
        if (!reloadConfig && globalConfig != null) {
            return globalConfig;
        }
        globalConfig = new Config();
        new ConfigLoader().loadConfig(globalConfig);
        globalConfig.setPropertiesFromConfig(true);
        if (globalConfig.getBoolean((Object)"config.threadLocal.enable", true)) {
            Config.globalConfig.threadLocalEnabled = true;
            log.debug("ThreadLocal Config enabled");
        }
        return globalConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPropertiesFromConfig(boolean reloadConfig) {
        Class<Config> clazz = Config.class;
        synchronized (Config.class) {
            if (this.setPropertyKeys != null && reloadConfig) {
                for (Object property : this.setPropertyKeys) {
                    System.clearProperty((String)property);
                }
            }
            if (this.setPropertyKeys == null || reloadConfig) {
                this.setPropertyKeys = DataTools.getSubtreeKeysPrefixed("system.setProperty", (Map)((Object)this));
            }
            for (Object property : this.setPropertyKeys) {
                String value = (String)this.get("system.setProperty." + String.valueOf(property));
                log.info("Applying system property " + String.valueOf(property) + ": " + value);
                System.setProperty((String)property, value);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static Properties buildProperties(Map map) {
        return (Properties)DataTools.mapMerge(map, new Properties());
    }

    public void load(ISCFile iscFile) throws IOException {
        this.load(iscFile.getInputStream());
    }

    public void load(File file) throws IOException {
        this.load(new FileInputStream(file));
    }

    public void load(String fileName) throws IOException {
        this.load(ISCFile.newInstance(fileName));
    }

    public void load(InputStream is) throws IOException {
        this.putAll(ConfigLoader.load(is));
    }

    public void load(Reader reader) throws IOException {
        this.putAll(ConfigLoader.load(reader));
    }

    public void store(String fileName) throws IOException {
        AtomicFileOutputStream os = new AtomicFileOutputStream(fileName);
        this.store((OutputStream)((Object)os));
        ((OutputStream)((Object)os)).close();
    }

    public void store(OutputStream os) throws IOException {
        PrintStream ps = new PrintStream(os);
        for (String key : this.keySet()) {
            Object o;
            if (key == null || (o = this.get(key)) == null) continue;
            String keyValuePair = Config.encodeKeyValuePair(key, o);
            ps.println(keyValuePair);
        }
        ps.flush();
        ps.close();
        os.flush();
    }

    public static String encodeKeyValuePair(String key, Object o) {
        if (o == null) {
            return key + ":";
        }
        String value = o instanceof Collection ? DataTools.join((Collection)o, ", ") : o.toString();
        value = value.replaceAll("\"\"\"", "\\\\\"\\\\\"\\\\\"");
        String keyValuePair = value.matches("^\\s+") || value.matches("\\s+$") || value.contains("\n") || value.contains("\r") ? key + ":\"\"\"" + value + "\"\"\"" : key + ":" + value;
        return keyValuePair;
    }

    public static void persistProperty(String key, Object o, String propertyFile) throws Exception {
        HashMap<String, Object> overrides = new HashMap<String, Object>();
        overrides.put(key, o);
        Config.persistProperties(overrides, propertyFile);
    }

    public static void persistProperties(Map properties, String propertyFile) throws Exception {
        boolean created;
        if (properties == null) {
            return;
        }
        Config config = Config.getGlobal();
        if (DataTools.pathIsRelative((String)propertyFile)) {
            propertyFile = config.getBoolean((Object)"devenv", false) ? config.getPath("webRoot") + "/isomorphicConfig/" + (String)propertyFile : config.getPath("webRoot") + "/WEB-INF/classes/" + (String)propertyFile;
        }
        if (DataTools.isContainerIOPath((String)propertyFile)) {
            throw new Exception("Unable to persist " + (String)propertyFile + " because SmartClient is running in containerIO mode (WAR deployment, no direct filesystem access).  To fix this, set the webRoot variable in your server.properties if possible.");
        }
        File file = new File((String)propertyFile);
        if (!file.exists() && !(created = file.createNewFile())) {
            throw new Exception("Unable to persist " + (String)propertyFile + " because " + (String)propertyFile + " does not exist and creating new file at that location failed.");
        }
        StringWriter writer = new StringWriter();
        FileReader reader = new FileReader(file);
        ConfigLoader.load(reader, new ConcurrentHashMap(), writer, properties);
        reader.close();
        IOUtil.atomicWrite(writer.toString(), file);
    }

    public Config setInterpolation(boolean value) {
        this.doInterpolate = value;
        return this;
    }

    public Config clone() {
        return new Config(this.map);
    }

    public Config() {
        this(new HashMap(), null);
    }

    public Config(Map data) {
        this.map = this.cloneMap(data);
    }

    protected Map cloneMap(Map data) {
        return new ConcurrentHashMap(data){

            @Override
            public Object remove(Object key) {
                Object value = this.get(key);
                super.remove(key);
                Config.this.clearCache();
                return value;
            }

            @Override
            public Object put(Object key, Object value) {
                if (value == null) {
                    return this.remove(key);
                }
                Object oldValue = this.get(key);
                super.put(key, value);
                Config.this.clearCache();
                return oldValue;
            }

            @Override
            public void putAll(Map map) {
                super.putAll(map);
                Config.this.clearCache();
            }

            @Override
            public void clear() {
                super.clear();
                Config.this.clearCache();
            }
        };
    }

    public Config(Map data, Config ... interpolateCascade) {
        this(data);
        this.interpolateCascade = interpolateCascade;
    }

    public void clearCache() {
        this.getCache().clear();
    }

    public Object getUninterpolated(Object key) {
        return this.getMap().get(key);
    }

    public Object getProperty(Object key) {
        return this.get(key);
    }

    public Object get(Object key) {
        return this.get(key, true);
    }

    public Object get(Object key, boolean removeBackslashEscapeChars) {
        if (key == null) {
            return null;
        }
        Object value = null;
        if (removeBackslashEscapeChars && (value = this.getCache().get(key)) != null) {
            return value;
        }
        value = this.getUninterpolated(key);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            try {
                if (this.doInterpolate) {
                    value = this.interpolate(value.toString());
                }
                if (removeBackslashEscapeChars) {
                    value = REF_ESCAPE_PATTERN.matcher(value.toString()).replaceAll("\\$");
                }
            }
            catch (Exception e) {
                log.warn((Object)"Caught Exception in get()", e);
            }
        }
        if (value instanceof Map && !(value instanceof Config)) {
            value = new Config((Map)value, this.interpolateCascade);
        }
        if (value != null && removeBackslashEscapeChars) {
            this.getCache().put(key, value);
        }
        return value;
    }

    protected Object interpolate(Object value) throws Exception {
        if (value instanceof String) {
            return this.interpolate((String)value);
        }
        return value;
    }

    protected String interpolate(String value) throws Exception {
        boolean matched;
        if (value == null) {
            return null;
        }
        do {
            int commaIndex;
            Object defaultValue;
            matched = false;
            Matcher matcher = ENV_VAR_PATTERN.matcher(value);
            if (matcher.reset(value).find()) {
                matched = true;
                String envRef = matcher.group(1);
                String envVarName = null;
                defaultValue = null;
                commaIndex = envRef.indexOf(",");
                if (commaIndex != -1) {
                    envVarName = envRef.substring(0, commaIndex).trim();
                    defaultValue = envRef.substring(commaIndex + 1).trim();
                } else {
                    envVarName = envRef;
                }
                String envVarValue = System.getenv(envVarName);
                if (envVarValue == null && defaultValue != null) {
                    envVarValue = defaultValue;
                }
                if (envVarValue == null) {
                    throw new Exception("$ENV directive: " + value + " references undefined env var and does not specify a default");
                }
                value = matcher.replaceFirst(Matcher.quoteReplacement(envVarValue));
            }
            matcher.usePattern(SYS_PATTERN);
            if (matcher.reset(value).find()) {
                matched = true;
                String sysRef = matcher.group(1);
                String sysVarName = null;
                defaultValue = null;
                commaIndex = sysRef.indexOf(",");
                if (commaIndex != -1) {
                    sysVarName = sysRef.substring(0, commaIndex).trim();
                    defaultValue = sysRef.substring(commaIndex + 1).trim();
                } else {
                    sysVarName = sysRef;
                }
                String sysVarValue = System.getProperty(sysVarName);
                if (sysVarValue == null && defaultValue != null) {
                    sysVarValue = defaultValue;
                }
                if (sysVarValue == null) {
                    throw new Exception("$SYS directive: " + value + " references undefined System property and does not specify a default");
                }
                value = matcher.replaceFirst(Matcher.quoteReplacement(sysVarValue));
            }
            matcher.usePattern(VAR_PATTERN);
            if (matcher.reset(value).find()) {
                matched = true;
                String varRef = matcher.group(1);
                String varName = null;
                defaultValue = null;
                commaIndex = varRef.indexOf(",");
                if (commaIndex != -1) {
                    varName = varRef.substring(0, commaIndex).trim();
                    defaultValue = varRef.substring(commaIndex + 1).trim();
                } else {
                    varName = varRef;
                }
                Object interpolatedValueObj2 = this.get(varName, false);
                if (interpolatedValueObj2 == null && this.interpolateCascade != null) {
                    Config c;
                    Config[] configArray = this.interpolateCascade;
                    int n = configArray.length;
                    for (int i = 0; i < n && (interpolatedValueObj2 = (c = configArray[i]).get(varName, false)) == null; ++i) {
                    }
                }
                if (interpolatedValueObj2 == null && defaultValue != null) {
                    interpolatedValueObj2 = defaultValue;
                }
                if (interpolatedValueObj2 == null) {
                    throw new Exception("variable expansion failed for variable: " + varName);
                }
                String interpolatedValue = interpolatedValueObj2.toString();
                value = matcher.replaceFirst(Matcher.quoteReplacement(interpolatedValue));
            }
            matcher.usePattern(BARE_VAR_PATTERN);
            if (matcher.reset(value).find()) {
                matched = true;
                String varName = matcher.group(1);
                Object interpolatedValueObj = this.get(varName, false);
                if (interpolatedValueObj == null && this.interpolateCascade != null) {
                    Object c;
                    defaultValue = this.interpolateCascade;
                    commaIndex = ((Config[])defaultValue).length;
                    for (int interpolatedValueObj2 = 0; interpolatedValueObj2 < commaIndex && (interpolatedValueObj = ((Config)((Object)(c = defaultValue[interpolatedValueObj2]))).get(varName, false)) == null; ++interpolatedValueObj2) {
                    }
                }
                if (interpolatedValueObj == null) {
                    throw new Exception("variable expansion failed for variable: " + varName);
                }
                String interpolatedValue = interpolatedValueObj.toString();
                value = matcher.replaceFirst(Matcher.quoteReplacement(interpolatedValue));
            }
            matcher.usePattern(JNDI_PATTERN);
            if (!matcher.reset(value).find()) continue;
            matched = true;
            String contextName = this.interpolate(matcher.group(1));
            String jndiKey = this.interpolate(matcher.group(2));
            String keyContext = this.interpolate(matcher.group(3));
            Context ctx = JNDI.bindConfiguredContext(contextName);
            Object interpolatedValue = "";
            if (ctx instanceof DirContext) {
                Attributes attrs = ((DirContext)ctx).getAttributes(keyContext, new String[]{jndiKey});
                Attribute attr = null;
                if (attrs != null) {
                    attr = attrs.get(jndiKey);
                }
                if (attrs == null || attr == null) {
                    throw new Exception("unable to resolve jndi reference: " + value + " - lookup failed for key: " + jndiKey);
                }
                NamingEnumeration<?> ne = attr.getAll();
                while (ne.hasMore()) {
                    interpolatedValue = (String)interpolatedValue + ne.next().toString();
                    if (!ne.hasMore()) continue;
                    interpolatedValue = (String)interpolatedValue + ",";
                }
            } else {
                throw new Exception("Resolved context type: " + ctx.getClass().getName() + " is not supported.");
            }
            value = matcher.replaceFirst(Matcher.quoteReplacement((String)interpolatedValue));
        } while (matched);
        return value;
    }

    @Override
    public DataTypeMap getMap(Object key, Map defaultValue) {
        return this.getConfig(key, defaultValue);
    }

    public Config getConfig(Object key) {
        return this.getConfig(key, null);
    }

    public Config getConfig(Object key, Map defaultValue) {
        Object value = this.get(key);
        if (value instanceof Config) {
            return (Config)((Object)value);
        }
        if (value instanceof Map) {
            return new Config((Map)value, this.interpolateCascade);
        }
        if (value == null) {
            if (defaultValue != null) {
                if (defaultValue instanceof Config) {
                    return (Config)((Object)defaultValue);
                }
                return new Config(defaultValue, this.interpolateCascade);
            }
            return null;
        }
        return new Config((Map)value, this.interpolateCascade);
    }

    public Config getConfigBlock(String key) {
        return new Config(DataTools.getPrefixed(key, (Map)((Object)this)), this.interpolateCascade);
    }

    public Config getSubtree(String key) {
        return new Config(DataTools.getSubtreePrefixed(key, (Map)((Object)this)), this.interpolateCascade);
    }

    public void clearSubtree(String key) {
        DataTools.clearSubtreePrefixed(key, this);
    }

    public void putSubtree(String key, Map subTree) {
        for (String subKey : subTree.keySet()) {
            this.put(key + "." + subKey, subTree.get(subKey));
        }
    }

    public Map evaluatePropertiesAtPath(String configPath, Map variables) {
        try {
            Config template = this.getSubtree(configPath).setInterpolation(false);
            return DataTools.evaluateTemplateMap((Map)((Object)template), variables);
        }
        catch (Exception e) {
            log.error((Object)("unable to evaluate properties at path " + configPath), e);
            return null;
        }
    }

    public Config addSubtreeFromTemplate(String key, String configPath, Map variables) {
        Map subtree = this.evaluatePropertiesAtPath(configPath, variables);
        this.putSubtree(key, subtree);
        return this.getSubtree(key);
    }

    public Properties asProperties() {
        return Config.buildProperties((Map)((Object)this));
    }

    public void setIfNull(Object key, Object value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
        }
    }

    public Object getClassInstance() throws Exception {
        return this.getClassInstance(null);
    }

    public Object getClassInstance(String key) throws Exception {
        String value = key == null ? this.getString("implementer") : this.getString(key);
        if (value == null) {
            value = this.getString(key + ".implementer");
        }
        try {
            Reflection.classForName(value);
        }
        catch (Exception ce) {
            throw new Exception("Class " + value + " specified by config directive: " + key + " does not exist in runtime");
        }
        Object classInstance = Reflection.instantiateClass(value);
        Config.initClassInstance(classInstance, key, this);
        return classInstance;
    }

    public static Config getOverlayConfig(String configRoot, Config overrideConfig) throws Exception {
        if (configRoot == null) {
            return overrideConfig;
        }
        if (overrideConfig == null || overrideConfig == globalConfig) {
            return globalConfig;
        }
        Config overlayConfig = new Config(new HashMap(), globalConfig);
        Config subTree = globalConfig.getSubtree(configRoot);
        for (String key : subTree.keySet()) {
            overlayConfig.put(configRoot + "." + key, subTree.getUninterpolated(key));
        }
        for (String key : overrideConfig.keySet()) {
            overlayConfig.put(configRoot + "." + key, overrideConfig.getUninterpolated(key));
        }
        return overlayConfig;
    }

    public static Object getClassInstance(String key, Config overrideConfig) throws Exception {
        return Config.getOverlayConfig(key, overrideConfig).getClassInstance(key);
    }

    public static void initClassInstance(Object classInstance, Config overrideConfig) throws Exception {
        Config.initClassInstance(classInstance, null, overrideConfig);
    }

    public static void initClassInstance(Object classInstance, String configRoot, Config overrideConfig) throws Exception {
        Config applyConfig = configRoot == null ? overrideConfig : Config.getOverlayConfig(configRoot, overrideConfig.getSubtree(configRoot));
        Config.setInstanceProperties(classInstance, configRoot, applyConfig);
        if (classInstance instanceof IAutoConfigurable) {
            if (configRoot != null) {
                ((IAutoConfigurable)classInstance).initAutoConfigurable(configRoot);
            } else {
                ((IAutoConfigurable)classInstance).initAutoConfigurable(applyConfig);
            }
        }
    }

    public static void setInstanceProperties(Object classInstance, String configRoot, Config config) throws Exception {
        if (config == null) {
            config = globalConfig;
        }
        if (configRoot != null) {
            config = config.getSubtree(configRoot);
        }
        DataTypeMap setPropertiesOpts = DataTools.buildMap("directAssignToFields", Boolean.TRUE, "invokeNonConfirmingSetters", Boolean.TRUE, "convertJSONStrings", Boolean.TRUE);
        DataTools.setProperties((Map)((Object)new Config((Map)((Object)config), globalConfig)), classInstance, setPropertiesOpts);
    }

    public Object put(Object key, Object value) {
        return this.getMap().put(key, value);
    }

    public Object setProperty(Object key, Object value) {
        return this.put(key, value);
    }

    public void putAll(Map map) {
        this.getMap().putAll(map);
    }

    @Override
    public String getString(Object key, String defaultValue) {
        String s = super.getString(key, defaultValue);
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    public String getPath(String key) {
        return this.getPath(key, null);
    }

    public String getPath(String key, String defaultValue) {
        String value = this.getString(key, defaultValue);
        if (value == null) {
            return value;
        }
        value = ISCFile.canonicalizePath(value);
        this.getCache().put(key, value);
        return value;
    }

    public static String expandPathVariables(String path) {
        return Config.expandPathVariables(path, false);
    }

    public static String expandPathVariables(String path, boolean removeWebroot) {
        return Config.expandPathVariables(path, removeWebroot, false);
    }

    public static String expandPathVariables(String path, boolean removeWebroot, boolean dontAddWebroot) {
        if (path == null) {
            return path;
        }
        String webroot = globalConfig.getPath("webRoot");
        for (PathExpansionVariable variable : Config.getPathExpansionVariables()) {
            path = variable.expand((String)path);
        }
        if (removeWebroot) {
            path = StringUtils.replace((String)path, (String)webroot, (String)"");
        } else if (!dontAddWebroot && !((String)path).startsWith(webroot)) {
            path = webroot + "/" + (String)path;
        }
        return path;
    }

    public static String contractPathVariables(String path) {
        if (path == null) {
            return path;
        }
        for (PathExpansionVariable variable : Config.getPathExpansionVariables()) {
            path = variable.contract(path);
        }
        return path;
    }

    public static synchronized PathExpansionVariable[] getPathExpansionVariables() {
        if (pathExpansionVariables == null) {
            pathExpansionVariables = new PathExpansionVariable[]{new PathExpansionVariable("[WEBROOT]", globalConfig.getPath("webRoot")), new PathExpansionVariable("[SCROOT]", globalConfig.getPath("isomorphicDir")), new PathExpansionVariable("[SHAREDDS]", globalConfig.getPath("project.datasources")), new PathExpansionVariable("[SHAREDAPPS]", globalConfig.getPath("project.apps")), new PathExpansionVariable("[VBWORKSPACE]", globalConfig.getPath("workspaceDir")), new PathExpansionVariable("[TOOLS]", globalConfig.getPath("toolsDir"))};
            Arrays.sort(pathExpansionVariables, new Comparator<PathExpansionVariable>(){

                @Override
                public int compare(PathExpansionVariable o1, PathExpansionVariable o2) {
                    int length2;
                    int length1 = o1.expansion.length();
                    if (length1 > (length2 = o2.expansion.length())) {
                        return -1;
                    }
                    if (length1 == length2) {
                        return 0;
                    }
                    return 1;
                }
            });
        }
        return pathExpansionVariables;
    }

    public static Charset defaultCharset() {
        String charsetName = Config.getGlobal().getString("global.default.charset");
        if (charsetName != null) {
            return Charset.forName(charsetName);
        }
        return UTF_8;
    }

    public boolean isReify() {
        return this.isReifyCloud() || this.isReifyOnSite();
    }

    public boolean isReifyCloud() {
        return "vbTeam".equals(this.getString("project"));
    }

    public boolean isReifyOnSite() {
        return "reifyOnSite".equals(this.getString("project"));
    }

    protected static class PathExpansionVariable {
        protected String variable;
        protected String expansion;

        PathExpansionVariable(String variable, String expansion) {
            if (variable == null) {
                throw new IllegalArgumentException("Must supply a non-null variable to be expanded");
            }
            if (expansion == null) {
                expansion = "";
            }
            this.variable = variable;
            this.expansion = expansion;
        }

        protected String expand(String path) {
            return StringUtils.replace((String)path, (String)this.variable, (String)this.expansion);
        }

        protected String contract(String path) {
            return StringUtils.replace((String)path, (String)this.expansion, (String)this.variable);
        }
    }
}

