/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.criteria;

import com.isomorphic.criteria.Criterion;
import com.isomorphic.criteria.Evaluator;
import com.isomorphic.criteria.LogicalOperator;
import com.isomorphic.criteria.Operator;
import com.isomorphic.criteria.OperatorBase;
import com.isomorphic.criteria.OtherFieldOperator;
import com.isomorphic.criteria.RangeOperator;
import com.isomorphic.criteria.SimpleOperator;
import com.isomorphic.criteria.criterion.AndCriterion;
import com.isomorphic.criteria.criterion.IsBlankCriterion;
import com.isomorphic.criteria.criterion.IsNullCriterion;
import com.isomorphic.criteria.criterion.LogicalCriterion;
import com.isomorphic.criteria.criterion.NotBlankCriterion;
import com.isomorphic.criteria.criterion.NotCriterion;
import com.isomorphic.criteria.criterion.NotNullCriterion;
import com.isomorphic.criteria.criterion.OrCriterion;
import com.isomorphic.criteria.criterion.OtherFieldCriterion;
import com.isomorphic.criteria.criterion.RangeCriterion;
import com.isomorphic.criteria.criterion.SetCriterion;
import com.isomorphic.criteria.criterion.SimpleCriterion;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class DefaultOperators {
    private static Logger log = new Logger(DefaultOperators.class.getName());
    public static OperatorBase Equals = new SimpleOperator(){

        @Override
        public String getID() {
            return "equals";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            SimpleCriterion simpleCriterion;
            try {
                simpleCriterion = (SimpleCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            Object recordValue = Evaluator.getPathValue(record, simpleCriterion.getFieldName());
            String matchingValue = String.valueOf(simpleCriterion.getValue());
            return DefaultOperators.isEqualToConfiguredValue(recordValue, matchingValue);
        }

        @Override
        public boolean isRequiresValue() {
            return false;
        }
    };
    public static OperatorBase NotEqual = new SimpleOperator(){

        @Override
        public String getID() {
            return "notEqual";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            return !Equals.condition(record, criterion, evaluator);
        }

        @Override
        public boolean isRequiresValue() {
            return false;
        }
    };
    public static OperatorBase IEquals = new SimpleOperator(){

        @Override
        public String getID() {
            return "iEquals";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            SimpleCriterion simpleCriterion;
            try {
                simpleCriterion = (SimpleCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            Object recordValue = Evaluator.getPathValue(record, simpleCriterion.getFieldName());
            String matchingValue = String.valueOf(simpleCriterion.getValue());
            if (recordValue != null && recordValue instanceof String) {
                recordValue = ((String)recordValue).toLowerCase();
            }
            if (matchingValue != null) {
                matchingValue = matchingValue.toLowerCase();
            }
            return DefaultOperators.isEqualToConfiguredValue(recordValue, matchingValue);
        }

        @Override
        public boolean isRequiresValue() {
            return false;
        }
    };
    public static OperatorBase INotEqual = new SimpleOperator(){

        @Override
        public String getID() {
            return "iNotEqual";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            return !IEquals.condition(record, criterion, evaluator);
        }

        @Override
        public boolean isRequiresValue() {
            return false;
        }
    };
    public static OperatorBase GreaterThan = new SimpleOperator(){

        @Override
        public String getID() {
            return "greaterThan";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            SimpleCriterion simpleCriterion;
            try {
                simpleCriterion = (SimpleCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            Comparable recordValue = (Comparable)Evaluator.getPathValue(record, simpleCriterion.getFieldName());
            String matchingValue = String.valueOf(simpleCriterion.getValue());
            return DefaultOperators.rangeCheckToConfiguredValues(recordValue, matchingValue, null, false, false);
        }
    };
    public static OperatorBase LessThan = new SimpleOperator(){

        @Override
        public String getID() {
            return "lessThan";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            SimpleCriterion simpleCriterion;
            try {
                simpleCriterion = (SimpleCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            Comparable recordValue = (Comparable)Evaluator.getPathValue(record, simpleCriterion.getFieldName());
            String matchingValue = String.valueOf(simpleCriterion.getValue());
            return DefaultOperators.rangeCheckToConfiguredValues(recordValue, null, matchingValue, false, false);
        }
    };
    public static OperatorBase GreaterOrEqual = new SimpleOperator(){

        @Override
        public String getID() {
            return "greaterOrEqual";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            SimpleCriterion simpleCriterion;
            try {
                simpleCriterion = (SimpleCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            Comparable recordValue = (Comparable)Evaluator.getPathValue(record, simpleCriterion.getFieldName());
            String matchingValue = String.valueOf(simpleCriterion.getValue());
            return DefaultOperators.rangeCheckToConfiguredValues(recordValue, matchingValue, null, true, false);
        }
    };
    public static OperatorBase LessOrEqual = new SimpleOperator(){

        @Override
        public String getID() {
            return "lessOrEqual";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            SimpleCriterion simpleCriterion;
            try {
                simpleCriterion = (SimpleCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            Comparable recordValue = (Comparable)Evaluator.getPathValue(record, simpleCriterion.getFieldName());
            String matchingValue = String.valueOf(simpleCriterion.getValue());
            return DefaultOperators.rangeCheckToConfiguredValues(recordValue, null, matchingValue, true, false);
        }
    };
    public static OperatorBase Between = new RangeOperator(){

        @Override
        public String getID() {
            return "between";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            RangeCriterion rangeCriterion;
            try {
                rangeCriterion = (RangeCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            Comparable recordValue = (Comparable)Evaluator.getPathValue(record, rangeCriterion.getFieldName());
            Comparable minValueObj = rangeCriterion.getMin();
            Comparable maxValueObj = rangeCriterion.getMax();
            String minValue = minValueObj == null ? null : minValueObj.toString();
            String maxValue = maxValueObj == null ? null : maxValueObj.toString();
            return DefaultOperators.rangeCheckToConfiguredValues(recordValue, minValue, maxValue, false, false);
        }
    };
    public static OperatorBase IBetween = new RangeOperator(){

        @Override
        public String getID() {
            return "iBetween";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            RangeCriterion rangeCriterion;
            try {
                rangeCriterion = (RangeCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            Comparable recordValue = (Comparable)Evaluator.getPathValue(record, rangeCriterion.getFieldName());
            Comparable minValueObj = rangeCriterion.getMin();
            Comparable maxValueObj = rangeCriterion.getMax();
            String minValue = minValueObj == null ? null : minValueObj.toString();
            String maxValue = maxValueObj == null ? null : maxValueObj.toString();
            return DefaultOperators.rangeCheckToConfiguredValues(recordValue, minValue, maxValue, false, true);
        }
    };
    public static OperatorBase BetweenInclusive = new RangeOperator(){

        @Override
        public String getID() {
            return "betweenInclusive";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            RangeCriterion rangeCriterion;
            try {
                rangeCriterion = (RangeCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            Comparable recordValue = (Comparable)Evaluator.getPathValue(record, rangeCriterion.getFieldName());
            Comparable minValueObj = rangeCriterion.getMin();
            Comparable maxValueObj = rangeCriterion.getMax();
            String minValue = minValueObj == null ? null : minValueObj.toString();
            String maxValue = maxValueObj == null ? null : maxValueObj.toString();
            return DefaultOperators.rangeCheckToConfiguredValues(recordValue, minValue, maxValue, true, false);
        }
    };
    public static OperatorBase IBetweenInclusive = new RangeOperator(){

        @Override
        public String getID() {
            return "iBetweenInclusive";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            RangeCriterion rangeCriterion;
            try {
                rangeCriterion = (RangeCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            Comparable recordValue = (Comparable)Evaluator.getPathValue(record, rangeCriterion.getFieldName());
            Comparable minValueObj = rangeCriterion.getMin();
            Comparable maxValueObj = rangeCriterion.getMax();
            String minValue = minValueObj == null ? null : minValueObj.toString();
            String maxValue = maxValueObj == null ? null : maxValueObj.toString();
            return DefaultOperators.rangeCheckToConfiguredValues(recordValue, minValue, maxValue, true, true);
        }
    };
    public static OperatorBase IContains = new SimpleOperator(){

        @Override
        public String getID() {
            return "iContains";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            SimpleCriterion simpleCriterion;
            try {
                simpleCriterion = (SimpleCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            String s = Evaluator.getPathValueAsString(record, simpleCriterion.getFieldName());
            String substr = String.valueOf(simpleCriterion.getValue());
            return -1 != s.toLowerCase().indexOf(substr.toLowerCase());
        }
    };
    public static OperatorBase IStartsWith = new SimpleOperator(){

        @Override
        public String getID() {
            return "iStartsWith";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            SimpleCriterion simpleCriterion;
            try {
                simpleCriterion = (SimpleCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            String s = Evaluator.getPathValueAsString(record, simpleCriterion.getFieldName());
            String substr = String.valueOf(simpleCriterion.getValue());
            return s.toLowerCase().startsWith(substr.toLowerCase());
        }
    };
    public static OperatorBase IEndsWith = new SimpleOperator(){

        @Override
        public String getID() {
            return "iEndsWith";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            SimpleCriterion simpleCriterion;
            try {
                simpleCriterion = (SimpleCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            String s = Evaluator.getPathValueAsString(record, simpleCriterion.getFieldName());
            String substr = String.valueOf(simpleCriterion.getValue());
            return s.toLowerCase().endsWith(substr.toLowerCase());
        }
    };
    public static OperatorBase Contains = new SimpleOperator(){

        @Override
        public String getID() {
            return "contains";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            SimpleCriterion simpleCriterion;
            try {
                simpleCriterion = (SimpleCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            String s = Evaluator.getPathValueAsString(record, simpleCriterion.getFieldName());
            String substr = String.valueOf(simpleCriterion.getValue());
            return s.contains(substr);
        }
    };
    public static OperatorBase StartsWith = new SimpleOperator(){

        @Override
        public String getID() {
            return "startsWith";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            SimpleCriterion simpleCriterion;
            try {
                simpleCriterion = (SimpleCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            String s = Evaluator.getPathValueAsString(record, simpleCriterion.getFieldName());
            String substr = String.valueOf(simpleCriterion.getValue());
            return s.startsWith(substr);
        }
    };
    public static OperatorBase EndsWith = new SimpleOperator(){

        @Override
        public String getID() {
            return "endsWith";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            SimpleCriterion simpleCriterion;
            try {
                simpleCriterion = (SimpleCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            String s = Evaluator.getPathValueAsString(record, simpleCriterion.getFieldName());
            String substr = String.valueOf(simpleCriterion.getValue());
            return s.endsWith(substr);
        }
    };
    public static OperatorBase INotContains = new SimpleOperator(){

        @Override
        public String getID() {
            return "iNotContains";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            return !IContains.condition(record, criterion, evaluator);
        }
    };
    public static OperatorBase INotStartsWith = new SimpleOperator(){

        @Override
        public String getID() {
            return "iNotStartsWith";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            return !IStartsWith.condition(record, criterion, evaluator);
        }
    };
    public static OperatorBase INotEndsWith = new SimpleOperator(){

        @Override
        public String getID() {
            return "iNotEndsWith";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            return !IEndsWith.condition(record, criterion, evaluator);
        }
    };
    public static OperatorBase NotContains = new SimpleOperator(){

        @Override
        public String getID() {
            return "notContains";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            return !Contains.condition(record, criterion, evaluator);
        }
    };
    public static OperatorBase NotStartsWith = new SimpleOperator(){

        @Override
        public String getID() {
            return "notStartsWith";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            return !StartsWith.condition(record, criterion, evaluator);
        }
    };
    public static OperatorBase NotEndsWith = new SimpleOperator(){

        @Override
        public String getID() {
            return "notEndsWith";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            return !EndsWith.condition(record, criterion, evaluator);
        }
    };
    public static OperatorBase IsBlank = new OperatorBase(){

        @Override
        public String getID() {
            return "isBlank";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            IsBlankCriterion blankCriterion;
            try {
                blankCriterion = (IsBlankCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            Object o = Evaluator.getPathValue(record, blankCriterion.getFieldName());
            return o == null || ((String)o).trim().equals("");
        }

        @Override
        public boolean isRequiresFieldName() {
            return true;
        }

        @Override
        public boolean isRequiresValue() {
            return false;
        }

        @Override
        public boolean isRequiresCriteria() {
            return false;
        }

        @Override
        public Criterion parseCriterion(String fieldName, Object value, List<Criterion> criteria) {
            return new IsBlankCriterion(fieldName);
        }

        public Map convertToMap(Criterion criterion) {
            IsBlankCriterion c = (IsBlankCriterion)criterion;
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("operator", this.getID());
            result.put("fieldName", c.getFieldName());
            return result;
        }
    };
    public static OperatorBase NotBlank = new OperatorBase(){

        @Override
        public String getID() {
            return "notBlank";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            NotBlankCriterion notBlankCriterion;
            try {
                notBlankCriterion = (NotBlankCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            Object o = Evaluator.getPathValue(record, notBlankCriterion.getFieldName());
            return o != null && !((String)o).trim().equals("");
        }

        @Override
        public boolean isRequiresFieldName() {
            return true;
        }

        @Override
        public boolean isRequiresValue() {
            return false;
        }

        @Override
        public boolean isRequiresCriteria() {
            return false;
        }

        @Override
        public Criterion parseCriterion(String fieldName, Object value, List<Criterion> criteria) {
            return new NotBlankCriterion(fieldName);
        }

        public Map convertToMap(Criterion criterion) {
            NotBlankCriterion c = (NotBlankCriterion)criterion;
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("operator", this.getID());
            result.put("fieldName", c.getFieldName());
            return result;
        }
    };
    public static OperatorBase IsNull = new OperatorBase(){

        @Override
        public String getID() {
            return "isNull";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            IsNullCriterion nullCriterion;
            try {
                nullCriterion = (IsNullCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            Object o = Evaluator.getPathValue(record, nullCriterion.getFieldName());
            return o == null;
        }

        @Override
        public boolean isRequiresFieldName() {
            return true;
        }

        @Override
        public boolean isRequiresValue() {
            return false;
        }

        @Override
        public boolean isRequiresCriteria() {
            return false;
        }

        @Override
        public Criterion parseCriterion(String fieldName, Object value, List<Criterion> criteria) {
            return new IsNullCriterion(fieldName);
        }

        public Map convertToMap(Criterion criterion) {
            IsNullCriterion c = (IsNullCriterion)criterion;
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("operator", this.getID());
            result.put("fieldName", c.getFieldName());
            return result;
        }
    };
    public static OperatorBase NotNull = new OperatorBase(){

        @Override
        public String getID() {
            return "notNull";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            NotNullCriterion notNullCriterion;
            try {
                notNullCriterion = (NotNullCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            Object o = Evaluator.getPathValue(record, notNullCriterion.getFieldName());
            return o != null;
        }

        @Override
        public boolean isRequiresFieldName() {
            return true;
        }

        @Override
        public boolean isRequiresValue() {
            return false;
        }

        @Override
        public boolean isRequiresCriteria() {
            return false;
        }

        @Override
        public Criterion parseCriterion(String fieldName, Object value, List<Criterion> criteria) {
            return new NotNullCriterion(fieldName);
        }

        public Map convertToMap(Criterion criterion) {
            NotNullCriterion c = (NotNullCriterion)criterion;
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("operator", this.getID());
            result.put("fieldName", c.getFieldName());
            return result;
        }
    };
    public static OperatorBase Regexp = new SimpleOperator(){

        @Override
        public String getID() {
            return "regexp";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            SimpleCriterion simpleCriterion;
            try {
                simpleCriterion = (SimpleCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            String s = Evaluator.getPathValueAsString(record, simpleCriterion.getFieldName());
            Pattern re = Pattern.compile((String)simpleCriterion.getValue());
            return re.matcher(s).find();
        }
    };
    public static OperatorBase Iregexp = new SimpleOperator(){

        @Override
        public String getID() {
            return "iregexp";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            SimpleCriterion simpleCriterion;
            try {
                simpleCriterion = (SimpleCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            String s = Evaluator.getPathValueAsString(record, simpleCriterion.getFieldName());
            Pattern re = Pattern.compile((String)simpleCriterion.getValue(), 2);
            return re.matcher(s).find();
        }
    };
    public static OperatorBase StartsWithPattern = new SimpleOperator(){

        @Override
        public String getID() {
            return "startsWithPattern";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            SimpleCriterion simpleCriterion;
            try {
                simpleCriterion = (SimpleCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            String fieldValue = Evaluator.getPathValueAsString(record, simpleCriterion.getFieldName());
            String matchesPattern = (String)simpleCriterion.getValue();
            return DefaultOperators.isStartsWithPattern(fieldValue, matchesPattern, false);
        }
    };
    public static OperatorBase IStartsWithPattern = new SimpleOperator(){

        @Override
        public String getID() {
            return "iStartsWithPattern";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            SimpleCriterion simpleCriterion;
            try {
                simpleCriterion = (SimpleCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            String fieldValue = Evaluator.getPathValueAsString(record, simpleCriterion.getFieldName());
            String matchesPattern = (String)simpleCriterion.getValue();
            return DefaultOperators.isStartsWithPattern(fieldValue, matchesPattern, true);
        }
    };
    public static OperatorBase EndsWithPattern = new SimpleOperator(){

        @Override
        public String getID() {
            return "endsWithPattern";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            SimpleCriterion simpleCriterion;
            try {
                simpleCriterion = (SimpleCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            String fieldValue = Evaluator.getPathValueAsString(record, simpleCriterion.getFieldName());
            String matchesPattern = (String)simpleCriterion.getValue();
            return DefaultOperators.isEndsWithPattern(fieldValue, matchesPattern, false);
        }
    };
    public static OperatorBase IEndsWithPattern = new SimpleOperator(){

        @Override
        public String getID() {
            return "iEndsWithPattern";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            SimpleCriterion simpleCriterion;
            try {
                simpleCriterion = (SimpleCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            String fieldValue = Evaluator.getPathValueAsString(record, simpleCriterion.getFieldName());
            String matchesPattern = (String)simpleCriterion.getValue();
            return DefaultOperators.isEndsWithPattern(fieldValue, matchesPattern, true);
        }
    };
    public static OperatorBase MatchesPattern = new SimpleOperator(){

        @Override
        public String getID() {
            return "matchesPattern";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            SimpleCriterion simpleCriterion;
            try {
                simpleCriterion = (SimpleCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            String fieldValue = Evaluator.getPathValueAsString(record, simpleCriterion.getFieldName());
            String matchesPattern = (String)simpleCriterion.getValue();
            return DefaultOperators.isMatchingPattern(fieldValue, matchesPattern, false);
        }
    };
    public static OperatorBase IMatchesPattern = new SimpleOperator(){

        @Override
        public String getID() {
            return "iMatchesPattern";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            SimpleCriterion simpleCriterion;
            try {
                simpleCriterion = (SimpleCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            String fieldValue = Evaluator.getPathValueAsString(record, simpleCriterion.getFieldName());
            String matchesPattern = (String)simpleCriterion.getValue();
            return DefaultOperators.isMatchingPattern(fieldValue, matchesPattern, true);
        }
    };
    public static OperatorBase ContainsPattern = new SimpleOperator(){

        @Override
        public String getID() {
            return "containsPattern";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            SimpleCriterion simpleCriterion;
            try {
                simpleCriterion = (SimpleCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            String fieldValue = Evaluator.getPathValueAsString(record, simpleCriterion.getFieldName());
            String matchesPattern = (String)simpleCriterion.getValue();
            String containsPattern = "*" + matchesPattern + "*";
            return DefaultOperators.isMatchingPattern(fieldValue, containsPattern, false);
        }
    };
    public static OperatorBase IContainsPattern = new SimpleOperator(){

        @Override
        public String getID() {
            return "iContainsPattern";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            SimpleCriterion simpleCriterion;
            try {
                simpleCriterion = (SimpleCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            String fieldValue = Evaluator.getPathValueAsString(record, simpleCriterion.getFieldName());
            String matchesPattern = (String)simpleCriterion.getValue();
            String containsPattern = "*" + matchesPattern + "*";
            return DefaultOperators.isMatchingPattern(fieldValue, containsPattern, true);
        }
    };
    public static OperatorBase InSet = new OperatorBase(){

        @Override
        public String getID() {
            return "inSet";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            SetCriterion setCriterion;
            try {
                setCriterion = (SetCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            Object o = Evaluator.getPathValue(record, setCriterion.getFieldName());
            return setCriterion.getValues().contains(o);
        }

        @Override
        public boolean isRequiresFieldName() {
            return true;
        }

        @Override
        public boolean isRequiresValue() {
            return true;
        }

        @Override
        public boolean isRequiresCriteria() {
            return false;
        }

        @Override
        public Criterion parseCriterion(String fieldName, Object value, List<Criterion> criteria) {
            if (value instanceof Collection) {
                return new SetCriterion(fieldName, this.getID(), (Collection)value);
            }
            return new SetCriterion(fieldName, this.getID(), DataTools.buildList(value));
        }

        public Map convertToMap(Criterion criterion) {
            SetCriterion lc = (SetCriterion)criterion;
            if (lc.getValues() != null) {
                HashMap<String, Object> res = new HashMap<String, Object>();
                res.put("operator", lc.getOperatorId());
                res.put("fieldName", lc.getFieldName());
                res.put("value", lc.getValues());
                return res;
            }
            return null;
        }
    };
    public static OperatorBase NotInSet = new OperatorBase(){

        @Override
        public String getID() {
            return "notInSet";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            return !InSet.condition(record, criterion, evaluator);
        }

        @Override
        public boolean isRequiresFieldName() {
            return true;
        }

        @Override
        public boolean isRequiresValue() {
            return true;
        }

        @Override
        public boolean isRequiresCriteria() {
            return false;
        }

        @Override
        public Criterion parseCriterion(String fieldName, Object value, List<Criterion> criteria) {
            if (value instanceof Collection) {
                return new SetCriterion(fieldName, this.getID(), (Collection)value);
            }
            return new SetCriterion(fieldName, this.getID(), DataTools.buildList(value));
        }

        public Map convertToMap(Criterion criterion) {
            SetCriterion lc = (SetCriterion)criterion;
            if (lc.getValues() != null) {
                HashMap<String, Object> res = new HashMap<String, Object>();
                res.put("operator", lc.getOperatorId());
                res.put("fieldName", lc.getFieldName());
                res.put("value", lc.getValues());
                return res;
            }
            return null;
        }
    };
    public static OperatorBase EqualsField = new OtherFieldOperator(){

        @Override
        public String getID() {
            return "equalsField";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            OtherFieldCriterion otherFieldCriterion;
            try {
                otherFieldCriterion = (OtherFieldCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            Object value1 = Evaluator.getPathValue(record, otherFieldCriterion.getFieldName());
            Object value2 = Evaluator.getPathValue(record, otherFieldCriterion.getOtherFieldName());
            return value1.equals(value2);
        }
    };
    public static OperatorBase IEqualsField = new OtherFieldOperator(){

        @Override
        public String getID() {
            return "iEqualsField";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            OtherFieldCriterion otherFieldCriterion;
            try {
                otherFieldCriterion = (OtherFieldCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            String value1 = Evaluator.getPathValueAsString(record, otherFieldCriterion.getFieldName());
            String value2 = Evaluator.getPathValueAsString(record, otherFieldCriterion.getOtherFieldName());
            return value1.equalsIgnoreCase(value2);
        }
    };
    public static OperatorBase NotEqualField = new OtherFieldOperator(){

        @Override
        public String getID() {
            return "notEqualField";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            return !EqualsField.condition(record, criterion, evaluator);
        }
    };
    public static OperatorBase INotEqualField = new OtherFieldOperator(){

        @Override
        public String getID() {
            return "iNotEqualField";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            return !IEqualsField.condition(record, criterion, evaluator);
        }
    };
    public static OperatorBase And = new LogicalOperator(){

        @Override
        public String getID() {
            return "and";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            AndCriterion andCriterion;
            try {
                andCriterion = (AndCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            int numCriteria = andCriterion.getCriteria().size();
            for (int i = 0; i < numCriteria; ++i) {
                Criterion c = andCriterion.getCriteria().get(i);
                DefaultOperators.logDumpValue("And", "criterion", c);
                boolean returnCode = evaluator.evaluateCriterion(record, c);
                log.debug("And " + i + "/" + (numCriteria - 1) + ": " + returnCode);
                if (returnCode) continue;
                return false;
            }
            return true;
        }

        @Override
        public Criterion parseCriterion(String fieldName, Object value, List<Criterion> criteria) {
            return new AndCriterion(criteria);
        }
    };
    public static OperatorBase Not = new LogicalOperator(){

        @Override
        public String getID() {
            return "not";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            NotCriterion notCriterion;
            try {
                notCriterion = (NotCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            if (notCriterion.getCriteria().size() != 1) {
                throw new Exception("\"not\" criterion requres exactly one subcriterion");
            }
            boolean returnCode = !evaluator.evaluateCriterion(record, notCriterion.getCriteria().get(0));
            log.debug("Not:" + returnCode);
            return returnCode;
        }

        @Override
        public Criterion parseCriterion(String fieldName, Object value, List<Criterion> criteria) {
            return new NotCriterion(criteria);
        }
    };
    public static OperatorBase Or = new LogicalOperator(){

        @Override
        public String getID() {
            return "or";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            OrCriterion orCriterion;
            try {
                orCriterion = (OrCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            int numCriteria = orCriterion.getCriteria().size();
            for (int i = 0; i < numCriteria; ++i) {
                Criterion c = orCriterion.getCriteria().get(i);
                boolean returnCode = evaluator.evaluateCriterion(record, c);
                log.debug("Or " + i + "/" + (numCriteria - 1) + ": " + returnCode);
                if (!returnCode) continue;
                return true;
            }
            return false;
        }

        @Override
        public Criterion parseCriterion(String fieldName, Object value, List<Criterion> criteria) {
            return new OrCriterion((List)criteria);
        }
    };
    public static OperatorBase GreaterThanField = new OtherFieldOperator(){

        @Override
        public String getID() {
            return "greaterThanField";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            OtherFieldCriterion otherFieldCriterion;
            try {
                otherFieldCriterion = (OtherFieldCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            Comparable v1 = (Comparable)record.get(otherFieldCriterion.getFieldName());
            Comparable v2 = (Comparable)record.get(otherFieldCriterion.getOtherFieldName());
            return v1.compareTo(v2) > 0;
        }
    };
    public static OperatorBase LessThanField = new OtherFieldOperator(){

        @Override
        public String getID() {
            return "lessThanField";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            OtherFieldCriterion otherFieldCriterion;
            try {
                otherFieldCriterion = (OtherFieldCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            Comparable v1 = (Comparable)record.get(otherFieldCriterion.getFieldName());
            Comparable v2 = (Comparable)record.get(otherFieldCriterion.getOtherFieldName());
            return v1.compareTo(v2) < 0;
        }
    };
    public static OperatorBase GreaterOrEqualField = new OtherFieldOperator(){

        @Override
        public String getID() {
            return "greaterOrEqualField";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            OtherFieldCriterion otherFieldCriterion;
            try {
                otherFieldCriterion = (OtherFieldCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            Comparable v1 = (Comparable)record.get(otherFieldCriterion.getFieldName());
            Comparable v2 = (Comparable)record.get(otherFieldCriterion.getOtherFieldName());
            return v1.compareTo(v2) >= 0;
        }
    };
    public static OperatorBase LessOrEqualField = new OtherFieldOperator(){

        @Override
        public String getID() {
            return "lessOrEqualField";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            OtherFieldCriterion otherFieldCriterion;
            try {
                otherFieldCriterion = (OtherFieldCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            Comparable v1 = (Comparable)record.get(otherFieldCriterion.getFieldName());
            Comparable v2 = (Comparable)record.get(otherFieldCriterion.getOtherFieldName());
            return v1.compareTo(v2) <= 0;
        }
    };
    public static OperatorBase ContainsField = new OtherFieldOperator(){

        @Override
        public String getID() {
            return "containsField";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            OtherFieldCriterion otherFieldCriterion;
            try {
                otherFieldCriterion = (OtherFieldCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            String s1 = ObjectUtils.toString(record.get(otherFieldCriterion.getFieldName()));
            String s2 = ObjectUtils.toString(record.get(otherFieldCriterion.getOtherFieldName()));
            return s1.contains(s2);
        }
    };
    public static OperatorBase IContainsField = new OtherFieldOperator(){

        @Override
        public String getID() {
            return "iContainsField";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            OtherFieldCriterion otherFieldCriterion;
            try {
                otherFieldCriterion = (OtherFieldCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            String s1 = ObjectUtils.toString(record.get(otherFieldCriterion.getFieldName())).toLowerCase();
            String s2 = ObjectUtils.toString(record.get(otherFieldCriterion.getOtherFieldName())).toLowerCase();
            return s1.contains(s2);
        }
    };
    public static OperatorBase NotContainsField = new OtherFieldOperator(){

        @Override
        public String getID() {
            return "notContainsField";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            return !ContainsField.condition(record, criterion, evaluator);
        }
    };
    public static OperatorBase INotContainsField = new OtherFieldOperator(){

        @Override
        public String getID() {
            return "iNotContainsField";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            return !IContainsField.condition(record, criterion, evaluator);
        }
    };
    public static OperatorBase StartsWithField = new OtherFieldOperator(){

        @Override
        public String getID() {
            return "startsWithField";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            OtherFieldCriterion otherFieldCriterion;
            try {
                otherFieldCriterion = (OtherFieldCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            String s1 = ObjectUtils.toString(record.get(otherFieldCriterion.getFieldName()));
            String s2 = ObjectUtils.toString(record.get(otherFieldCriterion.getOtherFieldName()));
            return s1.startsWith(s2);
        }
    };
    public static OperatorBase IStartsWithField = new OtherFieldOperator(){

        @Override
        public String getID() {
            return "iStartsWithField";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            OtherFieldCriterion otherFieldCriterion;
            try {
                otherFieldCriterion = (OtherFieldCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            String s1 = ObjectUtils.toString(record.get(otherFieldCriterion.getFieldName())).toLowerCase();
            String s2 = ObjectUtils.toString(record.get(otherFieldCriterion.getOtherFieldName())).toLowerCase();
            return StringUtils.startsWithIgnoreCase((CharSequence)s1, (CharSequence)s2);
        }
    };
    public static OperatorBase NotStartsWithField = new OtherFieldOperator(){

        @Override
        public String getID() {
            return "notStartsWithField";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            return !StartsWithField.condition(record, criterion, evaluator);
        }
    };
    public static OperatorBase INotStartsWithField = new OtherFieldOperator(){

        @Override
        public String getID() {
            return "iNotStartsWithField";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            return !IStartsWithField.condition(record, criterion, evaluator);
        }
    };
    public static OperatorBase EndsWithField = new OtherFieldOperator(){

        @Override
        public String getID() {
            return "endsWithField";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            OtherFieldCriterion otherFieldCriterion;
            try {
                otherFieldCriterion = (OtherFieldCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            String s1 = ObjectUtils.toString(record.get(otherFieldCriterion.getFieldName()));
            String s2 = ObjectUtils.toString(record.get(otherFieldCriterion.getOtherFieldName()));
            return s1.endsWith(s2);
        }
    };
    public static OperatorBase IEndsWithField = new OtherFieldOperator(){

        @Override
        public String getID() {
            return "iEndsWithField";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            OtherFieldCriterion otherFieldCriterion;
            try {
                otherFieldCriterion = (OtherFieldCriterion)criterion;
            }
            catch (ClassCastException e) {
                throw new Exception("invalid Criterion for operator");
            }
            String s1 = ObjectUtils.toString(record.get(otherFieldCriterion.getFieldName()));
            String s2 = ObjectUtils.toString(record.get(otherFieldCriterion.getOtherFieldName()));
            return StringUtils.endsWithIgnoreCase((CharSequence)s1, (CharSequence)s2);
        }
    };
    public static OperatorBase NotEndsWithField = new OtherFieldOperator(){

        @Override
        public String getID() {
            return "notEndsWithField";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            return !EndsWithField.condition(record, criterion, evaluator);
        }
    };
    public static OperatorBase INotEndsWithField = new OtherFieldOperator(){

        @Override
        public String getID() {
            return "iNotEndsWithField";
        }

        @Override
        public boolean condition(Map record, Criterion criterion, Evaluator evaluator) throws Exception {
            return !IEndsWithField.condition(record, criterion, evaluator);
        }
    };
    private static Map<String, Operator> defaultOperatorMap;

    static void logDumpValue(String fn, String name, Object o) {
        if (!log.isDebugEnabled()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(name + " ");
        if (!(o instanceof LogicalCriterion)) {
            if (o == null) {
                sb.append("(null)");
            } else {
                sb.append("(" + o.getClass().toString() + "): " + DataTools.prettyPrint(o));
            }
        }
        log.debug((Object)sb.toString(), fn);
    }

    public static boolean isEqualToConfiguredValue(Object value, String operand) throws Exception {
        DefaultOperators.logDumpValue("isEqualToConfiguredValue", "value", value);
        DefaultOperators.logDumpValue("isEqualToConfiguredValue", "operand", operand);
        Object passedOp = operand;
        if (operand != null && value != null) {
            try {
                passedOp = DataTools.convertType(value.getClass(), operand);
            }
            catch (NumberFormatException e) {
                passedOp = DataTools.convertType(Double.class, operand);
            }
            catch (ArithmeticException e) {
                passedOp = DataTools.convertType(Double.class, operand);
            }
        }
        DefaultOperators.logDumpValue("isEqualToConfiguredValue", "passedOp", passedOp);
        boolean ret = DefaultOperators.isEqual(value, passedOp);
        log.debug("isEqualToConfiguredValue returns" + ret);
        return ret;
    }

    public static boolean isEqual(Object value, Object operand) throws Exception {
        if (value == null) {
            return operand == null;
        }
        if (operand == null) {
            return false;
        }
        if (value instanceof String) {
            return ((String)value).equals((String)operand);
        }
        if (value instanceof Number && operand instanceof Number) {
            if (value instanceof Double || operand instanceof Double) {
                return 0 == DefaultOperators.doubleCompare(value, operand);
            }
            if (value instanceof Float || operand instanceof Float) {
                return 0 == DefaultOperators.floatCompare(value, operand);
            }
            BigDecimal valueBCD = (BigDecimal)DataTools.convertType(BigDecimal.class, value);
            BigDecimal opBCD = (BigDecimal)DataTools.convertType(BigDecimal.class, operand);
            return valueBCD.equals(opBCD);
        }
        if (value instanceof Comparable && value.getClass().isInstance(operand)) {
            return 0 == ((Comparable)value).compareTo((Comparable)operand);
        }
        return value.equals(operand);
    }

    static boolean singleRangeCheck(Object value, Object operand, boolean isGreaterThan, boolean inclusive, boolean caseInsensitive) throws Exception {
        int result;
        DefaultOperators.logDumpValue("singleRangeCheck", "value", value);
        DefaultOperators.logDumpValue("singleRangeCheck", "operand", operand);
        log.debug("singleRangeCheck isGreaterThan:" + isGreaterThan + " inclusive" + inclusive);
        if (operand == null) {
            return true;
        }
        if (value == null) {
            return !isGreaterThan && inclusive;
        }
        if (value instanceof Number || operand instanceof Number) {
            if (value instanceof Double || operand instanceof Double) {
                result = DefaultOperators.doubleCompare(value, operand);
            } else if (value instanceof Float || operand instanceof Float) {
                result = DefaultOperators.floatCompare(value, operand);
            } else {
                BigDecimal valueBCD = (BigDecimal)DataTools.convertType(BigDecimal.class, value);
                BigDecimal operandBCD = (BigDecimal)DataTools.convertType(BigDecimal.class, operand);
                result = valueBCD.compareTo(operandBCD);
            }
        } else if (value instanceof String || operand instanceof String) {
            String left = value.toString();
            String right = operand.toString();
            if (caseInsensitive) {
                left = left.toLowerCase();
                right = right.toLowerCase();
            }
            result = left.compareTo(right);
        } else if (value instanceof Comparable && value.getClass().isInstance(operand)) {
            result = ((Comparable)value).compareTo((Comparable)operand);
        } else {
            return false;
        }
        if (result == 0 && inclusive) {
            return true;
        }
        if (result > 0 && isGreaterThan) {
            return true;
        }
        return result < 0 && !isGreaterThan;
    }

    static int doubleCompare(Object a, Object b) throws Exception {
        Double aDbl = (Double)DataTools.convertType(Double.class, a);
        Double bDbl = (Double)DataTools.convertType(Double.class, b);
        return aDbl.compareTo(bDbl);
    }

    static int floatCompare(Object a, Object b) throws Exception {
        Float aFloat = (Float)DataTools.convertType(Float.class, a);
        Float bFloat = (Float)DataTools.convertType(Float.class, b);
        return aFloat.compareTo(bFloat);
    }

    public static boolean rangeCheckToConfiguredValues(Object value, String lower, String upper, boolean inclusive, boolean caseInsensitive) throws Exception {
        DefaultOperators.logDumpValue("rangeCheckToConfiguredValues", "lower", lower);
        DefaultOperators.logDumpValue("rangeCheckToConfiguredValues", "value", value);
        DefaultOperators.logDumpValue("rangeCheckToConfiguredValues", "upper", upper);
        log.debug("rangeCheckToConfiguredValues inclusive=" + inclusive);
        Object passedLower = lower;
        Object passedUpper = upper;
        if (value != null) {
            Class<?> cls = value.getClass();
            if (lower != null) {
                try {
                    passedLower = DataTools.convertType(cls, lower);
                }
                catch (NumberFormatException e) {
                    passedLower = DataTools.convertType(Double.class, lower);
                }
                catch (ArithmeticException e) {
                    passedLower = DataTools.convertType(Double.class, lower);
                }
            }
            if (upper != null) {
                try {
                    passedUpper = DataTools.convertType(cls, upper);
                }
                catch (NumberFormatException e) {
                    passedUpper = DataTools.convertType(Double.class, upper);
                }
                catch (ArithmeticException e) {
                    passedUpper = DataTools.convertType(Double.class, upper);
                }
            }
        }
        DefaultOperators.logDumpValue("rangeCheckToConfiguredValues", "passedLower", passedLower);
        DefaultOperators.logDumpValue("rangeCheckToConfiguredValues", "passedUpper", passedUpper);
        boolean returnCode = DefaultOperators.rangeCheck(value, passedLower, passedUpper, inclusive, caseInsensitive);
        log.debug("rangeCheckToConfiguredValues returns " + returnCode);
        return returnCode;
    }

    public static boolean rangeCheck(Object value, Object lower, Object upper, boolean inclusive, boolean caseInsensitive) throws Exception {
        boolean lowerResult = DefaultOperators.singleRangeCheck(value, lower, true, inclusive, caseInsensitive);
        boolean upperResult = DefaultOperators.singleRangeCheck(value, upper, false, inclusive, caseInsensitive);
        return lowerResult && upperResult;
    }

    public static boolean isMatchingPattern(String value, String matchesPattern, boolean ignoreCase) throws Exception {
        String state = "NORMAL";
        Object searchExpression = "";
        for (int i = 0; i < matchesPattern.length(); ++i) {
            char thisCharacter = matchesPattern.charAt(i);
            if (thisCharacter == '\\') {
                state = "ESCAPE";
                continue;
            }
            if ("NORMAL".equals(state)) {
                if (thisCharacter == '*') {
                    searchExpression = (String)searchExpression + ".*";
                    continue;
                }
                if (thisCharacter == '?' || thisCharacter == '%') {
                    searchExpression = (String)searchExpression + ".";
                    continue;
                }
                searchExpression = (String)searchExpression + thisCharacter;
                continue;
            }
            if (!"ESCAPE".equals(state)) continue;
            searchExpression = (String)searchExpression + Pattern.quote(String.valueOf(thisCharacter));
            state = "NORMAL";
        }
        searchExpression = "^" + (String)searchExpression + "$";
        Pattern re = Pattern.compile((String)searchExpression, ignoreCase ? 2 : 0);
        return re.matcher(value).find();
    }

    public static boolean isStartsWithPattern(String value, String matchesPattern, boolean ignoreCase) throws Exception {
        String state = "NORMAL";
        Object searchExpression = "";
        for (int i = 0; i < matchesPattern.length(); ++i) {
            char thisCharacter = matchesPattern.charAt(i);
            if (thisCharacter == '\\') {
                state = "ESCAPE";
                continue;
            }
            if ("NORMAL".equals(state)) {
                if (thisCharacter == '*') {
                    searchExpression = (String)searchExpression + ".*";
                    continue;
                }
                if (thisCharacter == '?' || thisCharacter == '%') {
                    searchExpression = (String)searchExpression + ".";
                    continue;
                }
                searchExpression = (String)searchExpression + thisCharacter;
                continue;
            }
            if (!"ESCAPE".equals(state)) continue;
            searchExpression = (String)searchExpression + Pattern.quote(String.valueOf(thisCharacter));
            state = "NORMAL";
        }
        searchExpression = "^" + (String)searchExpression + ".*";
        Pattern re = Pattern.compile((String)searchExpression, ignoreCase ? 2 : 0);
        return re.matcher(value).find();
    }

    public static boolean isEndsWithPattern(String value, String matchesPattern, boolean ignoreCase) throws Exception {
        String state = "NORMAL";
        Object searchExpression = "";
        for (int i = 0; i < matchesPattern.length(); ++i) {
            char thisCharacter = matchesPattern.charAt(i);
            if (thisCharacter == '\\') {
                state = "ESCAPE";
                continue;
            }
            if ("NORMAL".equals(state)) {
                if (thisCharacter == '*') {
                    searchExpression = (String)searchExpression + ".*";
                    continue;
                }
                if (thisCharacter == '?' || thisCharacter == '%') {
                    searchExpression = (String)searchExpression + ".";
                    continue;
                }
                searchExpression = (String)searchExpression + thisCharacter;
                continue;
            }
            if (!"ESCAPE".equals(state)) continue;
            searchExpression = (String)searchExpression + Pattern.quote(String.valueOf(thisCharacter));
            state = "NORMAL";
        }
        searchExpression = ".*" + (String)searchExpression + "$";
        Pattern re = Pattern.compile((String)searchExpression, ignoreCase ? 2 : 0);
        return re.matcher(value).find();
    }

    public static synchronized Map<String, Operator> getDefaultOperatorMap() {
        if (defaultOperatorMap == null) {
            defaultOperatorMap = new HashMap<String, Operator>();
            try {
                Field[] thisFields;
                for (Field field : thisFields = DefaultOperators.class.getDeclaredFields()) {
                    if (!Operator.class.isAssignableFrom(field.getType())) continue;
                    Operator o = (Operator)field.get(null);
                    defaultOperatorMap.put(o.getID(), o);
                }
            }
            catch (Exception e) {
                Logger.global.warn("Exception " + e.toString() + " at DefaultOperators.getDefaultOperatorMap(): " + DataTools.getStackTrace(e));
            }
        }
        return defaultOperatorMap;
    }
}

