package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * Governs whether a {@link com.smartgwt.client.widgets.form.fields.MultiPickerItem} displays selected and unselected
 * option in a drop down pickList, or uses a {@link com.smartgwt.client.widgets.grid.Shuttle shuttle interface}
 */
public enum MultiPickerSelectionStyle implements ValueEnum {
    /**
     * Options will be displayed in a PickList
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "pickList".
     */
    PICKLIST("pickList"),
    /**
     * Options will be displayed in a {@link com.smartgwt.client.widgets.grid.Shuttle}
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "shuttle".
     */
    SHUTTLE("shuttle"),
    /**
     * Options will be displayed in a {@link com.smartgwt.client.widgets.tree.TreeGrid}. Only suitable for hierarchical data.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "pickTree".
     */
    PICKTREE("pickTree");
    private String value;

    MultiPickerSelectionStyle(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
