/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.widgets.calendar.events;

import com.google.gwt.event.shared.EventHandler;

public interface DayBodyClickHandler extends EventHandler {
    /**
     * Called when the body area of a day in the month view is clicked on, outside of any links to a particular event. <P> By
     * default, if the user can add events, shows a dialog for adding a new event for that day.  Call {@link com.smartgwt.client.widgets.calendar.events.DayBodyClickEvent#cancel()} from within {@link com.smartgwt.client.widgets.calendar.events.DayBodyClickHandler#onDayBodyClick} to cancel this
     * action. <P> Note that, when {@link com.smartgwt.client.widgets.calendar.Calendar#getOtherDayClickNavigation
     * otherDayClickNavigation} is true, the calendar will first   navigate the Month view to the selected month, before
     * showing the Event Editor dialog at  the proper location. <p> Not called if the day falls outside the current month and
     * {@link com.smartgwt.client.widgets.calendar.Calendar#getShowOtherDays showOtherDays} is false.
     *
     * @param event the event
     */
    void onDayBodyClick(com.smartgwt.client.widgets.calendar.events.DayBodyClickEvent event);
}
