
/*
 * Isomorphic Smart GWT web presentation layer
 * Copyright 2000 and beyond Isomorphic Software, Inc.
 *
 * OWNERSHIP NOTICE
 * Isomorphic Software owns and reserves all rights not expressly granted in this source code,
 * including all intellectual property rights to the structure, sequence, and format of this code
 * and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.
 *
 *  If you have any questions, please email <sourcecode@isomorphic.com>.
 *
 *  This entire comment must accompany any portion of Isomorphic Software source code that is
 *  copied or moved from this file.
 */
/* sgwtgen */
package com.smartgwt.client.docs.serverds;

import com.smartgwt.client.types.*;
import com.smartgwt.client.data.DSRequest;
import com.smartgwt.client.data.DSResponse;
import com.smartgwt.client.docs.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.widgets.form.fields.FormItem;
import java.util.List;
import java.util.Map;

/**
 * An object representing a criterion to apply to a record.<p>
 * <b>This class is not meant to be created and used, it is actually documentation of settings
 * allowed in a DataSource descriptor (.ds.xml file), for use with Smart GWT Pro Edition and
 * above.
 * See {@link com.smartgwt.client.docs.serverds} for how to use this documentation.</b>
 * <p>
 * <P> A criterion is part of the definition of an {@link
 * com.smartgwt.client.docs.serverds.AdvancedCriteria} object, which is used to filter records
 * according to search criteria.  <P> A criterion consists of an {@link
 * com.smartgwt.client.docs.serverds.Criterion#operator operator} and typically a {@link
 * com.smartgwt.client.docs.serverds.DataSourceField#name fieldName} from a {@link
 * com.smartgwt.client.data.Record} and a {@link com.smartgwt.client.docs.serverds.Criterion#value
 * value} to compare to.  However some operators either don't require a value (eg, isNull) or act
 * on other criteria rather than directly on a {@link com.smartgwt.client.data.Record}'s fields
 * (eg, the "and" and "or" logical operators).   Also, it is possible to  specify a {@link
 * com.smartgwt.client.docs.serverds.Criterion#fieldQuery fieldQuery} instead of a
 * <code>fieldName</code> and/or a  {@link com.smartgwt.client.docs.serverds.Criterion#valueQuery
 * valueQuery} instead of a <code>value</code> <P> A shortcut form is also allowed where only
 * <code>fieldName</code> and <code>value</code> values are provided. In this case the
 * <code>operator</code> is assumed to be "equals".
 */
public class Criterion {

    /**
     * Operator this criterion applies.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.AdvancedFilter Advanced Filtering
     */
    public OperatorId operator;

    /**
     * Name of the field in each {@link com.smartgwt.client.data.Record} that this criterion applies
     * to.  Not applicable for a
     * criterion with {@link com.smartgwt.client.docs.serverds.Criterion#criteria sub-criteria}. Can
     * be specified as a dataPath to 
     *  allow matching nested objects. Use '/' as delimiters for dataPath. See 
     *  {@link com.smartgwt.client.docs.DataPath dataPath} for more information.
     * 
     *  <p>
     *  <h4>{@link com.smartgwt.client.docs.serverds.Criterion#fieldQuery fieldQuery} shortcuts</h4>
     *  <code>fieldName</code> can also be used to express a compact form of related-field filtering.
     *  If you set this property to the qualified name of a field on a related DataSource, it will
     * be transformed into a basic {@link
     * com.smartgwt.client.docs.serverds.AdvancedCriterionSubquery}.  For example, say you 
     *  have an <code>Order</code> dataSource, which has a 
     * {@link com.smartgwt.client.docs.serverds.DataSourceField#foreignKey foreign key relation} to
     * your <code>Customer</code> 
     *  dataSource, and your <code>Customer</code> dataSource has a "region" field.  If you wanted 
     *  to fetch all Orders for Customers in the EMEA region, you could declare criteria like 
     *  this:<pre>
     *     {fieldName: "Customer.region", operator: "equals", value: "EMEA"}
     *  </pre>
     *  This would be transformed into a subquery filter that would select only the records you 
     *  want: <pre>
     *  {
     *       fieldQuery: {
     *           dataSource: "Customer",
     *           queryOutput: "region"
     *       }, operator: "equals", value: "EMEA"
     *  }
     *  </pre>
     *  This transformation takes place before the filtering subsystem even sees the criteria, so
     *  declaring the shortcut form via <code>fieldName</code> leads to <b>exactly</b> the same 
     *  filtering behavior as if you specified the subquery directly as a <code>fieldQuery</code>
     *  <p>
     *  See the <code>AdvancedCriterionSubquery</code> overview linked above for more details of 
     *  the extremely powerful subquery filtering options.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.AdvancedFilter Advanced Filtering
     */
    public String fieldName;

    /**
     * A subquery to use instead of a {@link com.smartgwt.client.docs.serverds.Criterion#value value}.
     * When you use a  <code>valueQuery</code> instead of a <code>value</code>, you are comparing the
     * values  in the record field named in the criterion {@link
     * com.smartgwt.client.docs.serverds.Criterion#fieldName fieldName} to the result of  running a
     * per-record subquery, rather than a literal scalar value.  .  Note, it is also  possible to
     * specify both a <code>valueQuery</code> and a  {@link
     * com.smartgwt.client.docs.serverds.Criterion#fieldQuery fieldQuery}. <p> See the {@link
     * com.smartgwt.client.docs.serverds.AdvancedCriterionSubquery subquery overview} for more details
     * of the  criteria subquery feature, and examples of use. <p> Note, if you specify both
     * <code>valueQuery</code> and <code>value</code> in a criterion, we use the <code>value</code>
     * and the <code>valueQuery</code> is ignored
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.AdvancedFilter Advanced Filtering
     */
    public AdvancedCriterionSubquery valueQuery;

    /**
     * A subquery to use instead of a {@link com.smartgwt.client.docs.serverds.Criterion#fieldName
     * fieldName}.  When you use a  <code>fieldQuery</code> instead of a <code>fieldName</code>, you
     * are comparing the criterion {@link com.smartgwt.client.docs.serverds.Criterion#value value} to
     * the result of running a per-record subquery, rather than a field value found directly on the
     * record.  Note, it is also possible to specify both a  <code>fieldQuery</code> and a {@link
     * com.smartgwt.client.docs.serverds.Criterion#valueQuery valueQuery}. <p> See the {@link
     * com.smartgwt.client.docs.serverds.AdvancedCriterionSubquery subquery overview} for more details
     * of the  criteria subquery feature, and examples of use. <p> Note, if you specify both
     * <code>fieldQuery</code> and <code>fieldName</code> in a criterion, we use the
     * <code>fieldName</code> and the <code>fieldQuery</code> is ignored.   <p> Note also that
     * <code>fieldName</code> supports a special shortcut syntax for declaring a 
     * <code>fieldQuery</code> as a simple qualified reference to a related field.  See the 
     * <code>fieldName</code> doc linked above for details
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.AdvancedFilter Advanced Filtering
     */
    public AdvancedCriterionSubquery fieldQuery;

    /**
     * End value of a criterion with an operator of type <code>"valueRange"</code>.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.AdvancedFilter Advanced Filtering
     */
    public Object end;

    /**
     * Start value of a criterion with an operator of type <code>"valueRange"</code>.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.AdvancedFilter Advanced Filtering
     */
    public Object start;

    /**
     * For a criterion with an operator that acts on other criteria (eg "and", "or"), a list of
     * sub-criteria that are grouped together by the operator.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.AdvancedFilter Advanced Filtering
     */
    public Criterion[] criteria;

    /**
     * Value to be used in the application of this criterion. <P> Value may be required or not
     * required, or may be an Array, according to the {@link
     * com.smartgwt.client.types.OperatorValueType} of the operator.
     *
     * <p>Default value is null
     * @see com.smartgwt.client.docs.AdvancedFilter Advanced Filtering
     */
    public Object value;

}
