package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * For an {@link com.smartgwt.client.ai.AIResponse} of {@link com.smartgwt.client.util.AsyncOperationResult#getType type}
 * ERROR, the type of error, if known.
 */
public enum AIResponseErrorType implements ValueEnum {
    /**
     * the request exceeds a rate limit
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "requestRateLimitExceeded".
     */
    REQUESTRATELIMITEXCEEDED("requestRateLimitExceeded"),
    /**
     * the request's size exceeds a limit
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "requestSizeLimitExceeded".
     */
    REQUESTSIZELIMITEXCEEDED("requestSizeLimitExceeded"),
    /**
     * the request was deemed unsafe
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "requestUnsafe".
     */
    REQUESTUNSAFE("requestUnsafe"),
    /**
     * the response's size exceeded a limit
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "responseSizeLimitExceeded".
     */
    RESPONSESIZELIMITEXCEEDED("responseSizeLimitExceeded"),
    /**
     * the generated response was deemed unsafe
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "responseUnsafe".
     */
    RESPONSEUNSAFE("responseUnsafe");
    private String value;

    AIResponseErrorType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
