package com.smartgwt.client.docs;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * An AutoTestLocator is a string generated by the {@link com.smartgwt.client.util.AutoTest} class to  reliably identify an
 * interactive element in a Smart GWT application.  Locators allow integration with automated testing tools. For an
 * overview of automated testing in Smart GWT, see the documentation topic  {@link
 * com.smartgwt.client.docs.AutomatedTesting here}. <P> AutoTestLocators are designed to work across browsers, Smart GWT
 * versions, and even major changes to your application's UI. They do not rely on the DOM structure, and are intended to be
 * able to identify the target element reliably without requiring pervasive explicitly specified {@link
 * com.smartgwt.client.widgets.Canvas#getID component IDs}. <p> The {@link com.smartgwt.client.util.AutoTest} class is
 * responsible for creating locator strings corresponding to DOM elements, Smart GWT components or other objects, and for
 * resolving  locators back to those objects at runtime. <P> A locator for an element may be retrieved via {@link
 * com.smartgwt.client.util.AutoTest#getLocator AutoTest.getLocator()}, or by using  the {@link
 * com.smartgwt.client.util.AutoTest#installLocatorShortcut locator shortcut tool}, or the  <i>"Show AutoTest Locators"</i>
 * link on the <i>Results</i> tab of the  Smart GWT {@link com.smartgwt.client.docs.Debugging Developer Console}. <P>
 * Stored locators may be resolved to target elements via {@link com.smartgwt.client.util.AutoTest#getElement
 * AutoTest.getElement()} (or resolved to target objects via {@link com.smartgwt.client.util.AutoTest#getObject
 * AutoTest.getObject()}). <P> <b>Best Practices for building applications with reliable locators</b> <P> Developers should
 * be aware of certain considerations that can make generated AutoTestLocators more reliable when designing their
 * application. <P> The {@link com.smartgwt.client.docs.ReliableLocators} overview topic covers general recommendations to
 * ensure that AutoTestLocators are robust and reliable within your app. <P> The {@link
 * com.smartgwt.client.docs.PortableAutoTests} topic discusses considerations around  recording and playing back test
 * scripts over different environments with changes to data or user interface, and the capabilities Smart GWT offers to
 * address these considerations. <P> <h2>Locator Structure</h2> {@link com.smartgwt.client.docs.AutoTestLocator AutoTest
 * locators} consist of a series of segments, delineated by "/" characters. <P> Each segment identifies a step in a
 * hierarchy from a root component to the target element. Individual segments may represent a Canvas, a FormItem, an
 * interior DOM element or some other construction specific to the locator in question. <P> Note that the segments in an
 * AutoTestLocator do not necessarily match parent-child  relationships in the widget hierarchy. <P> <b>Root locator
 * segment</b> The root component of a locator may designated in one of the following ways: <ul>     <li>      <b>Component
 * ID:</b> If a component has an explicitly specified {@link com.smartgwt.client.widgets.Canvas#getID ID} this may be used 
 * along with the class of the widget to reliably identify it, regardless of      where it is in the page's widget
 * hierarchy.<br>      For example a VLayout with ID <code>"leftPane"</code> would be identified as:      <P>     
 * <code>//VLayout[ID="leftPane"]</code>      <P>      Or, if {@link com.smartgwt.client.widgets.Canvas#getLocateByIDOnly
 * Canvas.locateByIDOnly} is true, the class of the widget will not be      recorded - the locator segment to identify the
 * root will be just the      widget ID prefixed by three slash characters - for example:      <P>     
 * <code>///leftPane</code>    </li>    <li>      <b>Locator Test Root:</b> Developers may designate a component within an 
 * application as the explicit {@link com.smartgwt.client.util.AutoTest#setTestRoot testRoot}.       This component can
 * then be referenced by the special root locator segment      <P>      <code>//testRoot[]</code>      <P>      This is
 * useful for cases where a standard      widget hierarchy may be dynamically rendered inside       some component (such as
 * a {@link com.smartgwt.client.rpc.RPCManager#loadScreen screen}) -       see the {@link
 * com.smartgwt.client.docs.PortableAutoTests} topic for more information    </li>    <li>      <b>Base Search Segment:</b>
 * The AutoTest subsystem supports searching for components      by a {@link
 * com.smartgwt.client.widgets.Canvas#getDefiningProperty defining property value}. If a target element      is not a
 * descendant of a component with an explicitly specified ID, and is      also not contained within the specified {@link
 * com.smartgwt.client.util.AutoTest#setTestRoot testRoot}      for the application, but is contained within a component
 * that has a       specified {@link com.smartgwt.client.widgets.Canvas#getDefiningProperty definingProperty value}, this
 * may be      used to identify the root component for the locator.      <P>      Base search segments are prefixed with
 * <code>"//:"</code> and include the      class name for the target component along with the defining property value.     
 * <P>      For example - {@link com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource} is a defining property
 * for      ListGrids. The following locator would identify a ListGrid bound to a      dataSource with the ID
 * <code>"someDS"</code> wherever it appeared in the page's      widget hierarchy:      <P>     
 * <code>//:ListGrid[dataSource="someDS"]</code>      <P>      {@link com.smartgwt.client.util.AutoTest#getLocator
 * AutoTest.getLocator()} will only generate a locator with a base search       segment if the defining property value
 * would unambiguously identify the       base component within the application. The above locator would not be generated  
 * in an app with more than one visible ListGrid bound to <code>"someDS"</code>.      <P>      Note that by default hidden
 * and/or undrawn components are not considered      when generating and resolving locator search segments, but the special
 * <code>"?"</code> character indicates that both hidden and visible components      must be considered when resolving a
 * search segment.      <P>      For example the locator <code>//:?ListGrid[dataSource="someDS"]</code> would      retrieve
 * a ListGrid bound to <code>"someDS"</code> whether visible or hidden.      <P>      {@link
 * com.smartgwt.client.util.AutoTest#getLocator AutoTest.getLocator()} will generate this locator format if      the target
 * element was hidden, or if passed the        searchSegmentsIncludeHidden      attribute of the settings argument.   
 * </li> </ul> <b>Interior locator segments</b> <P> In some cases a single segment may be sufficient to identify a target
 * element or  object on the page, but in most cases, the root component locator will be suffixed with a number of interior
 * locator segments to identify the path from the root component to the target element. <P> The format of individual
 * segments within a locator will be different for different widget hierarchies and target elements. Smart GWT does not
 * exhaustively document every possible locator format for every widget, but the patterns used are consistent and can
 * inform application design: <ul>  <li>      <b>Named AutoChildren:</b> Named {@link autoChildren} will be      
 * identified within their creator by their autoChild name - for example      <P>     
 * <code>//Window[ID="mainWindow"]/body</code>      <P>      This happens regardless of the interim widget hierarchy
 * between the      creator and its auto-child.  </li>  <li>      <b>Explicit locatorChildren:</b> Components with an
 * explicit      {@link com.smartgwt.client.widgets.Canvas#setLocatorParent named locator child} relationship      will be
 * identified within their locator parent by name. For example      marking a member of a Layout with the locator child
 * name <code>"myView"</code>      might produce a locator like:      <P>     
 * <code>//VLayout[ID="mainLayout"]/myView</code>      <P>      Once again, this is regardless of the interim widget
 * hierarchy between      the locator parent and its locator-child.  </li>  <li>      <b>Search Segments:</b> Interior
 * search segments in a locator are prefixed      with <code>"//"</code>. Interior search segments indicate that a
 * component      may be uniquely identified by a       {@link com.smartgwt.client.widgets.Canvas#getDefiningProperty
 * defining property value} within the component      identified by the previous segment in the locator.      <P>      For
 * example the following locator would search for a ListGrid bound to       <code>"someDS"</code> within the body of a
 * window with ID <code>"mainWindow"</code>:      <P>     
 * <code>//Window[ID="mainWindow"]/body//ListGrid[dataSource="someDS"]</code>      <P>      Note that the {@link
 * com.smartgwt.client.util.AutoTest#getLocator AutoTest.getLocator()} method will never return a locator      with a
 * search segment that is ambiguous in the current application.      <P>      If the AutoTest system can uniquely identify
 * a component by defining property across the      app as a whole, it will typically be used as a base search segment. If
 * not      the system will find the highest-level ancestor containing only      one descendant with the specified
 * definingProperty, and ensure the previous      segment in the locator identifies that ancestor. This ensures that the   
 * final locator string is as compact as possible while unambiguously identifying the target.      <P>      As with base
 * search segments, a <code>"?"</code> character is used to indicate      that hidden or undrawn components should be
 * considered when resolving      search locators. For example the following locator:      <P>     
 * <code>//Window[ID="mainWindow"]/body//?ListGrid[dataSource="someDS"]</code>      <P>      would include hidden listGrids
 * when searching for the grid bound to the specified      dataSource.  </li>  <li>      <b>Locator segment fallback
 * attributes:</b> If a target element or component      cannot be identified within its parent by a simple identifier such
 * as autoChildName or       defining property, the AutoTest subsystem will generate a segment containing      one or more
 * attributes to identify the target. When multiple attributes are recorded      it allows the Smart GWT framework to use
 * several strategies to find the target.      These additional locator segment attributes are referred to as "fallback
 * attributes".      <P>      For example a locator segment with a full set of fallback attributes      identifying a
 * member of a Layout might look like this:      <P>     
 * <code>VLayout[ID="mainLayout"]/member[Class=TreeGrid||index=1||length=3||classIndex=0||classLength=1||roleIndex=0||roleLength=1||scRole=tree]/</code>
 * <P>      This specific segment indicates that the target component is a member of a layout.      The target is a
 * TreeGrid, and is the first of 3 members.      It also indicates this is the only member TreeGrid in the members array   
 * [indicated by the <code>classIndex</code> and <code>classLength</code> attributes], and      that it is the only member
 * with {@link com.smartgwt.client.widgets.Canvas#getAriaRole role} set to <code>"tree"</code>.      <P>      The parent
 * layout will use these <i>fallback attributes</i> in the locator as necessary to      find the appropriate member. If the
 * layout has three members, and the first is a TreeGrid,      the target may be resolved to this member with some
 * confidence.      <P>       If this is not the case, but there is exactly      one TreeGrid in the members array, or
 * exactly one element with <code>role</code> set to      tree, it will fallback to those secondary locator strategies. If
 * fallback locator strategies      are used, a warning will be logged so developers are aware of any potentially incorrect
 * locator parsing.      <P>      Developers may influence how recorded locator attributes are resolved via      properties
 * on the locator parent. For Layouts this would include       {@link
 * com.smartgwt.client.widgets.layout.Layout#getLocateMembersBy Layout.locateMembersBy} and {@link
 * com.smartgwt.client.widgets.layout.Layout#getLocateMembersType Layout.locateMembersType}.      <P>      For brevity and
 * readability, when generating locators, developers may       choose whether or not to include multiple fallback
 * attributes in locator segments by setting      {@link com.smartgwt.client.util.AutoTest#useMinimalFallbackAttributes
 * useMinimalFallbackAttributes} to false      globally, or on the <code>settings</code> parameter passed to {@link
 * com.smartgwt.client.util.AutoTest#getLocator AutoTest.getLocator()}.  </li>  <li><b>Component interior locators:</b>
 * Different Smart GWT components have their own patterns      for identifying significant elements in the DOM within their
 * handles. For example, ListGrid cell elements      are located by row and column data. Where appropriate, properties to
 * control how component-interior      locators behave will be documented on the class in question.  </li> </ul>
 */
public interface AutoTestLocator  {
}
