/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.callbacks;

import com.smartgwt.client.data.ResultSet;
import com.smartgwt.client.data.DSResponse;

public interface RowCountCallback {

    /** 
     * Callback fired when ResultSet.fetchRowCount() completes
     *
     * @param resultSet the {@link com.smartgwt.client.data.ResultSet} resultSet that issued the row-count fetch request.
     * @param dsResponse the {@link com.smartgwt.client.data.DSResponse} from the fetch request. May be null if the   row count fetch was
     * invalidated before the server responded
     * @param invalidated boolean indicating whether the rowCountFetch request was invalidated.   This parameter will be true if, after the row
     * count fetch request was issued, the criteria were   changed, the cache was invalidated or the rowCount status has
     * changed since the fetch was    initiated. Calling {@link com.smartgwt.client.data.ResultSet#fetchRowCount
     * ResultSet.fetchRowCount()} before   a row count fetch has completed will also invalidate the previous row count fetch.
     * In any of these   cases the row count will not be updated by this fetch operation.
     */
	public void execute(ResultSet resultSet, DSResponse dsResponse, boolean invalidated);
} 
