/*

  SmartClient Ajax RIA system
  Version v14.1p_2026-01-10/LGPL Deployment (2026-01-10)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
// this is the maximum number of CSS files that can be loaded in Safari.  We document.write()
// this number of empty <link> tags onto the page for dynamically loading CSS.  This number can
// be safely increased, potentially at the cost of slowing down the page load a bit.
//
// This is not used for FF or IE and does not affect the number of CSS files that can be cached
// in Safari.
//
//
if (!window.isc_maxCSSLoaders) window.isc_maxCSSLoaders = 20;
// FileLoader
//--------------------------------------------------------------------------------------------------
isc.defineStandaloneClass("FileLoader", {

_timeStamp: new Date().getTime(),

// css loaders were previously required for Safari/Chrome, but at some point dynamically adding
// <link> elements on the page like we do for IE/FF started working.  Probably earlier than
// Safari 7/Chrome 38 as currently defined here, but the actual boundary is untested.
// Also: if the FL is bootstraped via isc.FileLoader.ensureLoaded() after page load, we can't
// use CSS loaders because we can't document.write().  Modern browsers like Chrome stop us from
// doing so anyway (log a warning), but it's best not to try document.write() after page load...
useCSSLoaders: !isc.SA_Page.isLoaded() && 
               ((isc.Browser.isChrome && isc.Browser.version < 38) ||
               (isc.Browser.isSafari && !isc.Browser.isChrome && 
                !isc.Browser.isIOSChrome && !isc.Browser.isIOSFirefox && 
                isc.Browser.version < 7)),


disableCaching: false,

//> @classAttr FileLoader.versionParamName (String: "isc_version" : RW)
// Name of the query parameter to use for version-specific cache-busting. This will be used by
// +link{classAttr:FileLoader.addVersionToLoadTags}.
// <p>
// Also remember that both +link{FileLoader.load(),load()} and +link{FileLoader.cache(),cache()}
// uses this so if you change it for one remember to change it for the other to not get inconsistencies
// in the url's generated by FileLoader.
//
// @see classAttr:FileLoader.addVersionToLoadTags
// @see classMethod:FileLoader.cache
// @see classMethod:FileLoader.load
//
// @visibility FileLoader
//<
versionParamName: "isc_version",

//> @classAttr FileLoader.addVersionToLoadTags (boolean: true : RW)
//
// By default we add the version to the URL. Using this attribute you can turn this feature off.
// The parameter name used for this can be set via +link{FileLoader.versionParamName,versionParamName}.
// <p>
// Note that if you are using +link{FileLoader.cache(),cache()} to pre-cache the Smartclient
// framework and in your application code use manual script tags to load the framework files
// you will have to call +link{Page.setAddVersionToSkinCSS} before loading the skin in order to get
// the skins stylesheet to have a cache-busting parameter appended to its url.
// <p>
// It is recommended to use +link{FileLoader.load(),load()} if you plan on using
// +link{FileLoader.cache(),cache()} for pre-caching as this will ensure that the loaded
// files and their urls will be consistent provided the FileLoader configuration is the same for
// both pages.
//
// @see classAttr:FileLoader.versionParamName
// @see classMethod:FileLoader.cache
// @see classMethod:FileLoader.load
// @see Page.setAddVersionToSkinCSS
//
// @visibility FileLoader
//<
addVersionToLoadTags: true,

//> @classAttr FileLoader.modulesDir (String: "system/modules/" : IR)
// Path to module files (ISC_Core.js et al) relative to the isomorphicDir (see
// +link{FileLoader,FileLoader overview}).
// <p>
// Does not normally need to be set for SmartClient.  If using Smart GWT, set to "modules/".
// @visibility external
//<
modulesDir: "system/modules/",

// number of milliseconds between calls to pollForCSSLoaded()
cssPollFrequency: 50,

// number of millisecond before we force-fire the onload handler for a css file even though the
// number of cssRules is still at zero for that URL.
cssLoadTimeout: 2000,
// number of milliseconds we wait for a css file to load before warning about a possible 404
cssWarnTimeout: 1000,

nextCSSLoader: 0,

//--------------------------------------------------------------------------------------------------
// FileLoader APIs
//--------------------------------------------------------------------------------------------------

//> @object FileLoader
//
// This class enables background (deferred) loading and caching of JS, CSS and Image files.  It is
// designed to work standalone from the rest of the SmartClient framework to provide a lightweight
// caching and loading mechanism for SmartClient modules as well as user-built application
// modules/fragments.
// <p>
// The most common usage scenarios are:
// <ul>
//   <li> Caching JS, CSS, Image files in the browser in anticipation of a transition to a page
//   that requires these files.  For example, a plain HTML (non-SmartClient) login page or
//   landing page can begin caching SmartClient in the background while allowing the user
//   to login, or giving the user something to read.  Normally, loading SmartClient or other
//   large JavaScript files would block page loading and display.  By loading SmartClient in
//   the background only after a simple HTML landing page has loaded, you can completely
//   eliminate perceived download time associated with loading a rich UI application, making a
//   much larger difference in user experience than any difference in framework/application size.
//   <li> Loading a multi-phase UI.  In this scenario, an initial rendering of a page is done with
//   minimal data transfer to the browser.  Then JS, CSS, and Image files are fetched in the
//   background to provide richer UI components.  During this time the user can continue to normally
//   interact with the initial page.  Once loading is complete, the UI is updated with richer
//   components.
// </ul>
//
// The recommended usage pattern is to use the <code>loadISC</code> custom tag provided as part of
// the SmartClient SDK.  You can specify <code>cacheOnly="true"</code> to loadISC to cache the
// SmartClient framework in the background or alternately <code>defer="true"</code> to load the
// SmartClient framework and make it available in the current page.  You can specify the
// <code>onload</code> attribute of the tag to provide a JavaScript callback to your code that will
// be called when the framework loading is complete.
// <p>
// If you're not working in a JSP environment, you can use the
// +link{classMethod:FileLoader.cache}/+link{classMethod:FileLoader.load} APIs to accomplish
// the same effect as the <code>loadISC</code> JSP tag.
// <p>
// Additional APIs are provided for performing dynamic caching and loading of other JS, CSS, and
// Image files to improve the performance of your application.  See below.
// <p>
// <b>You must set <code>window.isomorphicDir</code> before loading and using this module unless the
// default of '../isomorphic/' is acceptable.  E.g. if your html file is in your toplevel webroot
// directory, then your HTML file should say (note the trailing slash):</b>
// <pre>
// &lt;SCRIPT&gt;window.isomorphicDir='isomorphic/'&lt;/SCRIPT&gt;
// &lt;SCRIPT SRC=isomorphic/system/modules/ISC_FileLoader.js&gt;&lt;/SCRIPT&gt;
// </pre>
// In addition, <b>if you are using Smart GWT</b>, you must set +link{fileLoader.modulesDir, modulesDir} to
// "modules/", as follows:
// <pre>
//   isc.FileLoader.modulesDir = "modules/";
// </pre>
// 
// This module is usable independent of the rest of SmartClient - you can use it on pages that
// don't load any other modules.  In practice, the general pattern is to use this module on
// static HTML pages such as a login page to pre-cache SmartClient modules, application logic,
// skin files, and css so that once the user logs in, there's no latency to load the rich UI.
// <p>
// You can also load the FileLoader itself dynamically - see +link{FileLoader.ensureLoaded}
// <p>
// Note: You can also reference this class via the alias isc.FL
//
// @treeLocation Optional Modules/Network Performance
//
// @requiresModules NetworkPerformance    
// @visibility FileLoader
//<









_obfuscation_global_identifier:null,

// URLs of images we need to fetch
_imageQueue: [],

// URLs of JS/CSS files we need to fetch
_fileQueue: [],

// URL-keyed state for files we're fetching
_fileConfig: {},

//> @classAttr FileLoader.defaultModules (String : "Core,Foundation,Containers,Grids,Forms,Drawing,DataBinding,Calendar" : RW)
//
// Default list of modules for
// +link{classMethod:FileLoader.load}/+link{classMethod:FileLoader.cache} to use if none are
// provided by the user.
// 
// @see classMethod:FileLoader.cache
// @see classMethod:FileLoader.load
//
// @visibility FileLoader
//<

defaultModules: "Core,Foundation,Containers,Grids,Forms,Drawing,DataBinding,Calendar",

//> @classAttr FileLoader.defaultSkin (String: "Tahoe" : RW)
//
// Default skin for  +link{classMethod:FileLoader.load}/+link{classMethod:FileLoader.cache} to
// use if one is not provided by the user.
//
// @see classMethod:FileLoader.cache
// @see classMethod:FileLoader.load
// 
// @visibility FileLoader
//<
defaultSkin: "Tahoe",

getIsomorphicDir : function () {
    return window.isomorphicDir ? window.isomorphicDir : "../isomorphic/";
},

//> @classMethod FileLoader.cache()
//
// Caches the specified SmartClient modules and skin.  Calling this method is equivalent to using
// the <code>loadISC</code> JSP tag with <code>cacheOnly="true"</code>.
//
// @param [onload] (String | Function) Optional code to execute when all specified modules and
//                                      skin have been cached.
// @param [skin] (String) Name of the skin to load.  If not specified, the skin specified by the
//                        default +link{classAttr:FileLoader.defaultSkin} will be used.
//                        Instead of a skin name, you can specify a skinDir - this works just
//                        like +link{Page.setSkinDir} - the skin assumed to be a skinDir if
//                        there's at least one forward slash (/) in the name.
// @param [modules] (String | List) List of modules to load.  If not specified, the list of modules
//                                   specified by the default
//                                   +link{classAttr:FileLoader.defaultModules} will be used.  You
//                                   can specify modules as "Core,Foundation" or as ["Core",
//                                   "Foundation"]
//
// @see classAttr:FileLoader.addVersionToLoadTags
// @see classAttr:FileLoader.versionParamName
// @see Page.setAddVersionToSkinCSS
//
// @visibility FileLoader
//<
cache : function (onload, skin, modules) {
  isc.FileLoader.cacheISC(skin, modules, onload);
},

//> @classMethod FileLoader.cacheISC()
// The same as calling +link{FileLoader.cache}, which has a slightly more convenient signature.
// @param [skin] (String) The <code>skin</code> provided to +link{FileLoader.cache}
// @param [modules] (String | Array) The <code>modules</code> provided to
//        +link{FileLoader.cache}
// @param [onload] (String | Function)  The <code>callback</code> provided to
//        +link{FileLoader.cache}
//
// @visibility FileLoader
//<
cacheISC : function (skin, modules, onload) {
    this.cacheModules(modules ? modules : this.defaultModules);
    this.cacheSkin(skin, onload);
},
cacheSkin : function (skin, onload) {
    var skinDir = this._getSkinDir(skin);
    this._queueFiles(skinDir+"load_skin.js", null, "js", {cacheOnly: true, addVersionToLoadTags: true});
    this._queueFiles(skinDir+"skin_styles.css", onload, "css", {cacheOnly: true, addVersionToLoadTags: true});
},

//> @classMethod FileLoader.cacheLocale()
//
// Caches the specified locale.
//
// @param [locale] (String) Name of the locale to cache..
//
// @param [onload] (String | Function) Optional code to execute when all specified locale
//                                      has been cached..
//
// @visibility FileLoader
//<
cacheLocale : function (locale, onload) {
    var localeFile = window.isomorphicDir+"locales/frameworkMessages"
             +((locale != "en") ? "_"+locale:"")+".properties";
    var config = {cacheOnly: true, addVersionToLoadTags: true,
        loadFailedPrompt: "Attempt to load (cache) a language pack for a non-existent locale (" + locale + ")"
    };
    this._queueFiles(localeFile, onload, "js", config); 
},

//> @groupDef backgroundDownload
// Because all components of the framework are delivered to the browser as
// +link{group:caching, cacheable} resources, users of your application typically need download
// the <smartclient>SmartClient</smartclient><smartgwt>SmartGWT</smartgwt>
// runtime only once (until the cache expires or is purged).
// <p>
// Isomorphic recommends beginning that process as early in the user experience as possible,
// in a registration or login page for example, so that the runtime has already been
// downloaded by the time they reach your application and there is no perceived wait
// while the user loads the rich user interface.
// <p>
// Alternative implementations of this approach include loading the framework
// using &lt;script&gt; tags with the <code>defer</code> attribute, the
// +link{group:loadISCTag, loadISC} JSP tag with its <code>cacheOnly</code> attribute,
// or the +link{FileLoader.cache} JavaScript function.
// <p>
// To use FileLoader, add its script tag to your html and follow it with a request
// to cache framework resources.  So from perhaps a login.html, registration.html, and/or
// index.html:
// <pre>
//     &lt;script&gt;window.isomorphicDir = "./isomorphic/"; &lt;/script&gt;
//     &lt;script src="./isomorphic/system/modules/ISC_FileLoader.js"&gt;&lt;/script&gt;
//     &lt;script&gt;
//       isc.FileLoader.cache();
//     &lt;/script&gt;
// </pre>
// Whenever your application is ready to draw the first component, you can load the
// previously cached framework and draw the component in its callback:
// <pre>
//     isc.FileLoader.load(function() {
//       isc.Label.create({contents: 'Hello World!'});
//     });
// </pre>
// You can even cause the component to be drawn in some existing DOM element, as outlined
// in the +link{group:integrationIntoExistingApps, Integration into Existing Applications}
// documentation topic:
// <pre>
//     isc.FileLoader.load(function() {
//       isc.Label.create({contents: 'Hello World!', htmlElement: 'greeting', matchElement: true});
//     });
// </pre>
// <h3>Loading DataSources</h3>
// When you're loading the framework in the background, you'll also need to load your
// DataSources in the background, using the +link{dataSource.load} function, typically in the
// callback:
// <pre>
//     isc.FileLoader.load(function() {
//         isc.DataSource.load('User', function() {
//             isc.ListGrid.create({dataSource: 'User'});
//         });
//     });
// </pre>
//
// @title Background Download
// @treeLocation Concepts/Deploying SmartClient
//<

//> @classMethod FileLoader.load()
//
// Loads the specified SmartClient modules and skin in defer mode.  Calling this method is
// equivalent to using the <code>loadISC</code> JSP tag with <code>defer="true"</code>.
// <P>
// If SmartClient modules are already loaded they will not be loaded a second time - the
// onload callback will fire regardless.<br>
// Similarly if a skin has already been loaded, a call to load() will not attempt to reload
// the same skin. If a new skin was specified, it will be applied over the top of the
// current skin, but developers should be aware this may lead to unpredictable appearance.
//
// @param [onload] (String | Function) Optional code to execute when all specified modules and
//                        skin have loaded.
// @param [showLoadingIndicator] (Boolean | LoadingIndicatorSettings) This parameter will cause the
//                        +link{classMethod:FileLoader.showLoadingIndicator(),loading indicator}
//                        to be displayed while the load is in progress, then automatically
//                        dismissed when load completes.<br>
//                        May be specified as simple boolean <code>true</code> value or a
//                        +link{object:LoadingIndicatorSettings,configuration block} for
//                        the loading indicator.
// @param [skin] (String) Name of the skin to load.  If not specified, the skin specified by the
//                        default +link{classAttr:FileLoader.defaultSkin} will be used.
//                        Instead of a skin name, you can specify a skinDir - this works just
//                        like +link{Page.setSkinDir} - the skin assumed to be a skinDir if
//                        there's at least one forward slash (/) in the name.<br>
//                        To suppress loading a skin, this parameter may be passed as an
//                        explicit empty string.
// @param [modules] (String | Array) List of modules to load.  If not specified, the list of modules
//                        specified by the default +link{classAttr:FileLoader.defaultModules}
//                        will be used.  You can specify modules as e.g: "Core,Foundation" 
//                        or as ["Core","Foundation"].<br>
//                        Note that FileLoader does not enforce module dependencies or load order.<br>
//                        If you're loading a subset of the default set of modules, ensure you
//                        include them in the order specified by +link{classAttr:FileLoader.defaultModules}.
//                        If you're including additional optional modules, see
//                        +link{group:loadingOptionalModules}, for module dependencies.
//
// @see classAttr:FileLoader.addVersionToLoadTags
// @see classAttr:FileLoader.versionParamName
// @see Page.setAddVersionToSkinCSS
//
// @visibility FileLoader
//<

load : function(onload, showLoadingIndicator, skin, modules) {
    isc.FileLoader.loadISC(skin, modules, onload, showLoadingIndicator);
},

//> @classMethod FileLoader.loadISC()
// The same as calling +link{FileLoader.load}, which has a slightly more convenient signature.
// @param [skin] (String) The <code>skin</code> provided to +link{FileLoader.load}
// @param [modules] (String | Array) The <code>modules</code> provided to
//        +link{FileLoader.load}
// @param [onload] (String | Function)  The <code>onload</code> provided to
//        +link{FileLoader.load}
// @param [showLoadingIndicator] (Boolean | LoadingIndicatorSettings)
//        The <code>showLoadingIndicator</code> provided to +link{FileLoader.load}
//
// @visibility FileLoader
//<
loadISC : function (skin, modules, onload, showLoadingIndicator) {

    var loadSkinPending,
        loadSkin = true;
    // Suppress double-loading the same skin.
    // If a different skin was specified, allow it to load over the top. We already log
    // a warning in this case.
    if (skin == null) skin = this.defaultSkin;
    if (skin == "" || (isc.currentSkin != null && isc.currentSkin.name == skin)) {
        loadSkin = false;
    } else {
        var loadSkinPending = this.loadSkinPending(skin);
        if (loadSkinPending != null) {
            loadSkinPending.cacheOnly = false; // force load rather than cache!
            loadSkinPending.defer = true;
            loadSkin = false;
        }
        // we may need to attach our callback to an existing loadSkin request
    }
    if (modules == null) modules = this.defaultModules;

    modules = this._canonicalizeList(modules);
    var lastLoadingModule;
    for (var i = 0; i < modules.length; i++) {
        if (this.moduleIsLoaded(modules[i])) {
            modules.splice(i,1);
            i--;
        } else {
            lastLoadingModule = this.loadModulePending(modules[i]);
            if (lastLoadingModule != null) {
                lastLoadingModule.cacheOnly = false; // force the module to load (IE - evaluate), not just get cached
                lastLoadingModule.defer = true;
                modules.splice(i,1);
                i--;    
                // If all the requested files are already loading,
                // we may need to attach our callback to an existing loadModule callback
            }
        }

    }

    
    if (modules.length == 0 && !loadSkin) {
        var pendingFileConfig = loadSkinPending || lastLoadingModule;
        if (pendingFileConfig != null) {
            var callbacks = pendingFileConfig.onload;
            if (callbacks == null) callbacks = [];
            else if (typeof callbacks == "string" || typeof callbacks == "function") callbacks = [callbacks];

            callbacks.push(onload);
            pendingFileConfig.onload = callbacks;
        } else {
            // everything is already loaded - just fire the callback
            
            this._fireUserOnloadHandlers(onload);
        }

    } else {

        if (showLoadingIndicator != null) {
            var loadingIndicatorConfig;
            if (typeof showLoadingIndicator == "object") loadingIndicatorConfig = showLoadingIndicator;
            this.showLoadingIndicator(loadingIndicatorConfig);
            if (onload == null) onload = []
            else if (!Array.isArray(onload)) onload = [onload];
            // Hide the loading indicator right before invoking whatever callback(s) were passed in
            onload.unshift("isc.FL.hideLoadingIndicator()");
        }

        if (modules.length > 0) this.loadModules(modules, (!loadSkin ? onload : null));
        if (loadSkin) this.loadSkin(skin, onload);
    }
},
loadSkin : function (skin, onload) {
    var skinDir = this._getSkinDir(skin);

    // typically, load_skin.js calls Page.loadStyleSheet() to load skin_styles.css.  To speed
    // this up, we issue the load ourselves and store the loaded skin in an array that
    // Page.loadStyleSheet() checks before it tries to load the same css.
    this.markSkinCSSLoaded(skin);

    // Note: must load css first because safari uses a different loading mechanism for css
    // files and since loadSkin() directives are issued by the loadISC JSP tag, the onload
    // handler must fire after the last module load.
    this._queueFiles(skinDir+"skin_styles.css", null, "css", {defer: true, addVersionToLoadTags: true});
    this.loadSkinJS(skin, onload);
},

loadSkinPending : function (skin) {
    var skinJS = this.getSkinJSURL(skin);
    for (var loadingFile in this._fileConfig) {
        var fileConfig = this._fileConfig[loadingFile];
        if (fileConfig.skinJS == skinJS) {
            // Return the config rather than a boolean. This allows us to modify the 'onload' and
            // add a callback
            return fileConfig;
        }
    }
    // A return value of null (no pending config) means the skin isn't currently getting loaded
},

getSkinJSURL : function (skin) {

    var skinDir = this._getSkinDir(skin);

    var skinJS = skinDir+"load_skin.js"
    return skinJS;
},

loadSkinJS : function (skin, onload) {
    var skinJS = this.getSkinJSURL(skin);

    // cache a copy for isc.setCurrentSkin autodetect logic
    this._lastSkinJS = skinJS;
    this._queueFiles(skinJS, onload, "js", {defer: true, addVersionToLoadTags: true, skinJS:skinJS});
},
markSkinCSSLoaded : function (skin) {
    var skinDir = this._getSkinDir(skin);

    if (!this._loadedSkins) this._loadedSkins = [];
    this._loadedSkins[this._loadedSkins.length] = skinDir+"skin_styles.css";
},
markSkinCSSUnloaded : function (skin) {
    var skinDir = this._getSkinDir(skin);

    if (!this._loadedSkins) return;
    delete this._loadedSkins[skinDir+"skin_styles.css"];
},
_getSkinDir : function (skin) {
    if (!skin) skin = this.defaultSkin;

    var skinDir;
    if (skin.indexOf("/") != -1) {
        // user is specifying skinDir instead of skin
        skinDir = skin;
    } else {
        skinDir = this.getIsomorphicDir()+"skins/"+skin+"/";
    }
    if (skinDir.charAt(skinDir.length-1) != "/") skinDir += "/";
    return skinDir;
},

//> @classMethod FileLoader.loadLocale()
//
// Loads the specified locale in defer mode.
//
// @param [locale] (String) Name of the locale to load.
//
// @param [onload] (String | Function) Optional code to execute when all specified locale
//                                      has loaded.
//
// @visibility FileLoader
//<
loadLocale : function (locale, onload) {
    if (!locale) locale = "en";
    var localeFile = window.isomorphicDir+"locales/frameworkMessages"
             +((locale == "en") ? "":"_"+locale)+".properties";
    var config = {defer: true, addVersionToLoadTags: true, 
        loadFailedPrompt: "Attempt to load a language pack for a non-existent locale (" + locale + ")"
    };
    this._queueFiles(localeFile, onload, "js", config); 
},

//> @classMethod FileLoader.loadJSFiles()
//
// Loads the specified JS files into the context of the current page.
//
// @param URLs  (String | Array) List of URLs pointing to JS files to load.  This can either be a
//                                string with comma separated URLs or an Array of URLs.
// @param [onload] (String | Function) Optional code to execute when the last of the specified URLs
//                                      has completed loading.
//
// @visibility FileLoader
//<
loadJSFile : function (URLs, onload) {
    this._queueFiles(URLs, onload, "js", {defer: true});
},

//> @classMethod FileLoader.loadModules()
//
// Loads the specified SmartClient modules into the context of the current page.  
// <br>
// This call is idempotent in that duplicate module loads are automatically suppressed (no
// request is issued) and your specified onload callback will still fire.
//
// @param modules (String | Array) List of SmartClient modules to load.  This can either be a
//                                  string with comma separated module names or an Array of module
//                                  names.
// @param [onload] (String | Function) Optional code to execute when the last of the specified
//                                      modules has completed loading.
// 
// @visibility FileLoader
//<

loadModule : function (modules, onload) {
    this._queueFiles(modules, onload, "js", {defer: true, isModule: true});
},

//> @classMethod FileLoader.cacheFiles()
//
// Caches the specified list of files.
//
// @param URLs (String | Array) List of URLs to cache.  These may point to image, js, or css
//                               files.  This can either be a string with comma separated URLs or an
//                               Array of URLs.
// @param [onload] (String | Function) Optional callback to execute when the last of the specified
//                                      files has been cached.
// @param [type] (String) Specifies the type of the files referenced by the URLs.  Valid values are:
//                        "js", "css", and "image".  If not specified, the type is auto-derived from
//                        the file extension.  If a type cannot be derived, the cache directive
//                        for that specific URL will be ignored and an error will be logged to
//                        the Developer Console. You must specify a type if you use a
//                        non-standard extension for your file - for example if you use a JSP
//                        or a servlet with no extension to generate images.
//                 
// @visibility FileLoader
//<
cacheFile : function (URLs, onload, type) {
    this._queueFiles(URLs, onload, type, {cacheOnly: true});
},


//> @classMethod FileLoader.cacheModules()
//
// Caches the specified SmartClient modules.
//
// @param modules (String | Array) List of SmartClient modules to cache.  This can either be a
//                                  string with comma separated module names or an Array of module
//                                  names.
// @param [onload] (String | Function) Optional code to execute when the last of the specified
//                                      modules has been cached.
//
// @visibility FileLoader
//<
cacheModule : function (modules, onload) {
    
    if (isc.Browser.isMoz && isc.Browser.geckoVersion < 20051107) {
        modules = this._canonicalizeList(modules);
        for (var i = 0; i < modules.length; i++) {
            isc["module_"+modules[i]] = 1;
        }
        this.loadModules(modules, onload);
        return;
    }
   this._queueFiles(modules, onload, "js", {cacheOnly: true, isModule: true});
},

//> @classMethod FileLoader.loadCSSFiles()
//
// Loads the specified CSS files into the context of the current page.
//
// @param URLs (String | Array) List of CSS files to load.  This can either be a
//                               string with comma separated URLS or an Array of URLs.
// @param [onload] (String | Function) Optional code to execute when the last of the specified
//                                      CSS files has completed loading.
//
// @visibility internal
//<
loadCSSFile : function (URLs, onload) {
    this._queueFiles(URLs, onload, "css", {defer: true});
},

//> @classMethod FileLoader.loadFiles()
//
// Loads the specified files into the context of the current page.
//
// @param URLs (String | Array) List of URLs to load.  These may point to js, or css files.  This
//                              can either be a string with comma separated URLs or an Array of
//                              URLs.
// @param [onload] (String | Function) Optional code to execute when the last of the specified
//                                      files has completed loading.
// @param [type] (String) Specifies the type of the files referenced by the URLs.  Valid values are:
//                        "js" and "css".  If not specified, the type is auto-derived from
//                        the file extension.  If a type cannot be derived, the load directive
//                        for that specific URL will be ignored and an error will be logged to
//                        the Developer Console. You must specify a type if you use a
//                        non-standard extension for your file - for example if you use a JSP
//                        or a servlet with no extension to generate images.
//
// @visibility internal
//<
loadFile : function (URLs, onload, type) {
    this._queueFiles(URLs, onload, type, {defer: true});
},



//> @classMethod FileLoader.cacheImgStates()
//
// Caches a set of state images derived from a base image.  This is useful for caching a set of
// images for a single component.  For example this code:
// <pre>
// isc.FileLoader.cacheImgStates("/isomorphic/skins/SmartClient/images/TreeGrid/opener.png",
//                               "closed,opening,opened");
// </pre>
// Will cause the following images to be cached:
// <pre>
// /isomorphic/skins/SmartClient/images/TreeGrid/opener_closed.png
// /isomorphic/skins/SmartClient/images/TreeGrid/opener_opening.png
// /isomorphic/skins/SmartClient/images/TreeGrid/opener_opened.png
// </pre>
//
// @param baseURLs  (String | Array) List of base image URLs from which stateful names are to be
//                                    derived.  This can either be a
//                                    string with comma separated baseURLs or an Array of baseURLs.
// @param [states]  (String | Array) List of states to load.  If none specified, The following
//                                    default list will be used:
//                                    "Down,Over,Selected,Selected_Down,Selected_Over".  This can
//                                    either be a string with comma separated states or an Array
//                                    of states.
// @param [onload] (String | Function) Optional code to execute when the last of the specified URLs
//                                      has completed caching.
//
// @see classMethod:FileLoader.cacheStretchImgStates
// @visibility FileLoader
//<

// regexp used to URL into a baseName and extension
_fileExtensionRegexp : /(.*)\.(.*)/,
// default image states - user-overrideable
defaultImageStates:  "Down,Over,Disabled",
cacheImgStates : function (baseURLs, states, onload) {
    var URLs = this.addURLSuffix(baseURLs, states != null ? states : this.defaultImageStates);
    this.cacheFiles(URLs, onload, "image")
},


//> @classMethod FileLoader.cacheStretchImgStates()
//
// Caches a set of state stretch images derived from a base image.  This is useful for caching a set
// of images for a single component.  For example this code:
// <pre>
// isc.FileLoader.cacheStretchImgStates("/isomorphic/skins/SmartClient/images/button/button.png",
//                                      "Down,Over");
// </pre>
// Will cause the following images to be cached:
// <pre>
// /isomorphic/skins/SmartClient/images/button/button_start.png
// /isomorphic/skins/SmartClient/images/button/button_stretch.png
// /isomorphic/skins/SmartClient/images/button/button_end.png
// /isomorphic/skins/SmartClient/images/button/button_Down_start.png
// /isomorphic/skins/SmartClient/images/button/button_Down_stretch.png
// /isomorphic/skins/SmartClient/images/button/button_Down_end.png
// /isomorphic/skins/SmartClient/images/button/button_Over_start.png
// /isomorphic/skins/SmartClient/images/button/button_Over_stretch.png
// /isomorphic/skins/SmartClient/images/button/button_Over_end.png
// </pre>
//
// @param baseURLs  (String | Array) List of base image URLs from which stateful names are to be
//                                    derived.  This can either be a
//                                    string with comma separated baseURLs or an Array of baseURLs.
// @param [states]  (String | Array) List of states to load.  If none specified, The following
//                                    default list will be used:
//                                    "Down,Over,Selected,Selected_Down,Selected_Over".  This can
//                                    either be a string with comma separated states or an Array
//                                    of states
// @param [pieces] (String | Array)  List of StretchImg pieces to cache.  If not specified, the
//                                    following list will be used: "start,stretch,end".  This can
//                                    either be a string with comma separated piece names or an Array
//                                    of piece names.
// @param [onload] (String | Function) Optional code to execute when the last of the specified URLs
//                                      has completed caching.
//
// @see classMethod:FileLoader.cacheImgStates
// @visibility FileLoader
//<
cacheStretchImgStates : function (baseURLs, states, pieces, onload) {
    // add piece suffixes
    if (pieces == null) pieces = "start,stretch,end";

    // include stateless version - e.g. button_start.png
    var URLs = this.addURLSuffix(baseURLs, pieces);

    // add user-specified states - e.g. button_Over_start.png
    var stateURLs = this.addURLSuffix(baseURLs, states != null ? states : this.defaultImageStates);
    URLs = URLs.concat(this.addURLSuffix(stateURLs, pieces));

    this.cacheFiles(URLs, onload, "image");
},

//> @classMethod FileLoader.cacheEdgeImages()
//
// Caches a set of edge images derived from a base image.
// For example this code:
// <pre>
// isc.FileLoader.cacheEdgeImages("/isomorphic/skins/SmartClient/images/edges/rounded/frame/A3B2CC/6.png");
// </pre>
// Will cause the following images to be cached:
// <pre>
// /isomorphic/skins/SmartClient/images/edges/rounded/frame/A3B2CC/6_TL.png
// /isomorphic/skins/SmartClient/images/edges/rounded/frame/A3B2CC/6_T.png
// /isomorphic/skins/SmartClient/images/edges/rounded/frame/A3B2CC/6_TR.png
// /isomorphic/skins/SmartClient/images/edges/rounded/frame/A3B2CC/6_L.png
// /isomorphic/skins/SmartClient/images/edges/rounded/frame/A3B2CC/6_R.png
// /isomorphic/skins/SmartClient/images/edges/rounded/frame/A3B2CC/6_BL.png
// /isomorphic/skins/SmartClient/images/edges/rounded/frame/A3B2CC/6_B.png
// /isomorphic/skins/SmartClient/images/edges/rounded/frame/A3B2CC/6_BR.png
// </pre>
//
// @param baseURLs  (String | Array) List of base image URLs from which position-specific edge
//                                    names are to be derived.  This can either be a
//                                    string with comma separated baseURLs or an Array of baseURLs.
// @param [showCenter] (Boolean)      If true, also causes the center image to be cached.  Default
//                                    is false.
// @param [edges]  (String | Array)  List of edges to load.  If none specified, The following
//                                    default list will be used:
//                                    "TL,T,TR,L,R,BL,B,BR".  The list of valid values is the
//                                    set of extensions specified by
//                                    +link{attr:edgedCanvas.edgeImage}. This can
//                                    either be a string with comma separated edge extension or an
//                                    Array of edge extensions.
// @param [colors] (String | Array)  List of colors to cache.  If not specified, no color is
//                                     specified.  The list of valid colors are those that you have
//                                     specified as +link{attr:edgedCanvas.edgeColor}.
//                                    This can either be a string with comma separated colors or an Array
//                                    of colors.
// @param [onload] (String | Function) Optional code to execute when the last of the specified URLs
//                                      has completed caching.
//
// @visibility FileLoader
//<
defaultEdges: "TL,T,TR,L,R,BL,B,BR",
defaultEdgeColors: "",
cacheEdgeImages : function (baseURLs, showCenter, edges, colors, onload) {
    baseURLs = this._canonicalizeList(baseURLs);    

    // use defaultEdges if none specified
    if (edges == null) edges = this.defaultEdges;
    edges = this._canonicalizeList(edges);

    // add center piece if showCenter is specified
    if (showCenter) edges[edges.length] = "center";

    // use defaultEdgeColors if colors not specified
    if (colors == null) colors = this.defaultEdgeColors;

    var URLs = baseURLs;
    // if colors were specified, add them to the URL
    if (colors.length) URLs = this.addURLSuffix(URLs, colors);
    
    // add edges to the URL
    URLs = this.addURLSuffix(URLs, edges);
    
    this.cacheFiles(URLs, onload, "image");
},

//> @classMethod FileLoader.cacheShadows()
//
// Caches a set of shadow images at various depths.  For example this code:
// <pre>
// isc.FileLoader.cacheShadows("/isomorphic/skins/SmartClient/images/shared/shadows", "5");
// </pre>
// Will cause the following images to be cached:
// <pre>
// /isomorphic/skins/SmartClient/images/shared/shadows/ds5_TL.png
// /isomorphic/skins/SmartClient/images/shared/shadows/ds5_T.png
// /isomorphic/skins/SmartClient/images/shared/shadows/ds5_TR.png
// /isomorphic/skins/SmartClient/images/shared/shadows/ds5_L.png
// /isomorphic/skins/SmartClient/images/shared/shadows/ds5_R.png
// /isomorphic/skins/SmartClient/images/shared/shadows/ds5_BL.png
// /isomorphic/skins/SmartClient/images/shared/shadows/ds5_B.png
// /isomorphic/skins/SmartClient/images/shared/shadows/ds5_BR.png
// </pre>
//
// @param baseDir  (String)           Base directory containing the shadow images.
// @param depths  (String | Array)   List of depths to load. These values corresponds to the Canvas
//                                    attribute +link{attr:Canvas.shadowDepth}.   This can either be
//                                    a string with comma separated depths or an Array of depths.
// @param [baseShadowImage] (String)  Name of the base shadow image from which list of URLs is
//                                    generated.  If not specified, this defaults to "ds.png".
// @param [onload] (String | Function) Optional code to execute when the last of the specified URLs
//                                      has completed caching.
//
// @visibility FileLoader
//<
defaultBaseShadowImage: "ds.png",
cacheShadows : function (baseDir, depths, baseShadowImage, onload) {
    depths = this._canonicalizeList(depths);
    if (baseShadowImage == null) baseShadowImage = this.defaultBaseShadowImage;

    // strip query parameters if any
    
    var regexpResult = this._fileExtensionRegexp.exec(baseShadowImage);
    if (!regexpResult) {
        this.logWarn("Couldn't split baseShadowImage '" + baseShadowImage
                   + "' into basePath and extension - file will not be cached.");
        return;
    }

    var baseName = regexpResult[1];
    var extension = regexpResult[2];

    if (baseDir.charAt(baseDir.length-1) != "/") baseDir = baseDir + "/";

    // the center image is shared - which is important for performance because even though it's a
    // 1x1 pixel image, every additional HTTP turnaround (with HTTP header overhead) can hurt
    // performance
    //
    var underscore = "_";
    this.cacheFile(baseDir+baseName+underscore+"center."+extension, onload, "image");

    for (var i = 0; i < depths.length; i++) 
        this.cacheEdgeImages(baseDir+baseName+depths[i]+"."+extension, false, null, null, onload);
},

// internal helper - adds the provided suffixes onto the provided baseURLs and returns that list.
// If a query string is present on a baseURL, it will be applied to all URLs generated from that URL.
addURLSuffix : function (baseURLs, suffixes) {    
    baseURLs = this._canonicalizeList(baseURLs);
    suffixes = this._canonicalizeList(suffixes);

    var results = [];
    for (var i = 0; i < baseURLs.length; i++) {
        var baseURL = baseURLs[i];
        
        // strip query parameters if any
        var queryIndex = baseURL.indexOf("?");
        var queryPart = "";
        if (queryIndex != -1) {
            baseURL = baseURL.substring(0, queryIndex);
            queryPart = baseURL.substring(queryIndex, baseURL.length);
        }

        
        var regexpResult = this._fileExtensionRegexp.exec(baseURL);
        if (!regexpResult) {
            this.logWarn("Couldn't split baseURL '" + baseURL 
                       + "' into basePath and extension - file will not be cached.");
            continue;
        }
        var baseName = regexpResult[1];
        var extension = regexpResult[2];
        
        // apply all suffixes
        for (var j = 0; j < suffixes.length; j++) {
            results[results.length] = baseName + "_" + suffixes[j] + "." + extension + queryPart;
        }
    }

    return results;
},


// internal helper method - takes "foo,bar" or ["foo", "bar"] and returns ["foo", "bar"] with
// any leading and trailing whitespace stripped
_canonicalizeList : function (list) {
    
    var obfuscation_local_identifier;

    if (!list) return [];

    if (this.isAString(list)) {
        // Typically, we assume commas in the string separate individual URLs - however, 
        // requests for Google Webfont CSS files need to include commas, which is how you 
        // request additional weights and styles - these files typically come from 
        // fonts.googleapis.com but can be self-hosted - however, they'll still have one of two
        // formats, which would include "/css?family" or "/css2?family" - the second, more 
        // modern format is optimized
        if (list.includes("/css?family") || list.includes("/css2?family")) {
            // Google Webfont - don't split the string here
            list = [list];
        } else {
            // otherwise, assume commas separate URLs
            list = list.split(",");
        }
    }

    var result = [];
    for (var i = 0; i < list.length; i++) {
        var item = list[i];
        result[i] = item.replace(/\s+/g, "");
    }

    return result;
},

//> @classMethod FileLoader.moduleIsLoaded
// Checks to see whether a specified module has been loaded.  Note that it isn't usually
// necessary to check before calling +link{fileLoader.load, load}, as load will
// ignore requests to load an already loaded module or skin.
// @param [modules] (String | Array of String) The name of module or modules to check for, with
//        the 'ISC_' prefix or without.  Defaults to +link{FileLoader.defaultModules}.
// @return (boolean) True when the specified modules have been loaded.  False otherwise.
// @visibility external
//<
moduleIsLoaded : function (modules) {
    modules = this._canonicalizeList(modules || this.defaultModules);
    for (var i = 0; i < modules.length; i++) {
        var module = modules[i];
        if (module == null) continue;
        if (module.indexOf("ISC_") == 0) module = module.substring(4);
        if (isc["module_"+module] == null) return false;
    }
    return true;
},

// If a load is pending for a module, this method returns the active file config for the 
// module
loadModulePending : function (module) {
    if (module == null) return;
    var moduleURL = this.normalizeModuleURL(module);
    for (var loadingFile in this._fileConfig) {
        var fileConfig = this._fileConfig[loadingFile];
        if (fileConfig.isModule && fileConfig.rawURL == moduleURL) {
            // May be cacheOnly - assume upstream code is aware of this
            return fileConfig;
        }
    }
},

// Determine whether we are in progress loading any files
loadFilesPending : function () {
    var fileConfig = this._fileConfig;
    return (Object.keys(fileConfig).length > 0);
},


// canonicalizes list of files to load/cache, autodetects file types and queues
_queueFiles : function (URLs, onload, fileType, config) {
    //!OBFUSCATEOK
    URLs = this._canonicalizeList(URLs);
    var queuedFiles = false, lastQueued;

    
    for (var i = 0; i < URLs.length; i++) {
        var URL = URLs[i];

        var type = fileType;
        // auto-derive type from file extension
        if (fileType == null) {
            var file = URL;
            // lop off query params for file extension autodetection
            var queryIndex = file.indexOf("?");
            if (queryIndex != -1) file = file.substring(0, queryIndex);
            if (file.match(/\.js$/i)) type = "js";
            else if (file.match(/\.css$/i)) type = "css";
            // partial list from Tomcat's web.xml
            else if (file.match(/\.(gif|png|tiff|tif|bmp|dib|ief|jpe|jpeg|jpg|pbm|pct|pgm|pic|pict|ico)$/i))
                type = "image";
            if (type == null) {
                this.logWarn("Unable to autodetect file type for URL: " + URL 
                           + " please specify it explicitly in your call to"
                           + " isc.FileLoader.cacheFile()/isc.FileLoader.loadFile()."
                           + " Ignoring this file.");
                continue;
            }
        }

        
        // modules are provided as simple names, must convert to URLs 
        if (config.isModule) {
            // don't load modules more than once
            if (!config.cacheOnly) {
                // XXX this only works for named modules - not full paths
                var module = URL;

                if (isc._optionalModules[module] && isc._optionalModules[module].isFeature) continue;
                
                if (this.moduleIsLoaded(module)) {
                    // note: debug priority because duplicate using loadModule() to make sure
                    // it's loaded is a supported paradigm
                    this.logDebug("Suppressed duplicate load of module: " + module);
                    continue;
                }
                // don't load modules that have no client-side representation, e.g. SCServer
                if (isc._optionalModules[module] && isc._optionalModules[module].serverOnly) continue;
            }
            URL = this.normalizeModuleURL(URL);
        }
        // remember the URL without version query params.
        // This is used by moduleIsLoading() method
        var rawURL = URL;

        // if we want to disable caching, append a unique timestamp onto each URL - but only do
        // this for things that we load rather than cache because the timestamp would force a
        // fetch under a URL that is guaranteed to be different from the ultimate user,
        // therefore not forcing a reload where it matters.
        if (this.disableCaching && !config.cacheOnly) {
            URL += (URL.indexOf("?") != -1 ? "&" : "?") + "ts=" + (new Date().getTime());
        }

        if (this.addVersionToLoadTags && !this.disableCaching &&
            (config.addVersionToLoadTags || config.isModule || URL.indexOf(".css") != -1))
        {
            var version = window.isc_versionNumber || isc.versionNumber;
            // Note: ".js" suffix appended to the query parameter as a workaround to an old IE
            // issue.  See full IDoc in LoadTag.java
            // modern browser technically don't need this, but Chrome at least clearly uses
            // lastIndexOf() style heuristics to try to determine the mime type of the file.
            // For example, foo.css?x=bar.js will yield the following error:
            //
            // Resource interpreted as Stylesheet but transferred with MIME type application/x-javascript
            URL += (URL.indexOf("?") != -1 ? "&" : "?")+this.versionParamName+"="+version;
            if (type == "js" || type == "css") URL += "."+type;
        }

        

        // use a unique ID to identify every file
        var fileID = URL+"_"+this._timeStamp+"_"+new Date().getTime();
        var fileConfig = this._fileConfig[fileID] = {
            fileID : fileID,
            URL: URL,
            rawURL: rawURL,
            type: type
        };
        // copy config onto the fileConfig
        if (config) for (var key in config) fileConfig[key] = config[key];

        // images have a queue separate from files because we load them in parallel
        if (fileConfig.type == "image") {
            queuedFiles = true;
            lastQueued = fileConfig;
            this._imageQueue.push(fileID);
        } else {
            // XXX We can't cache undoctored non-image files in FF < 1.5 without creating history
            // entries because XMLHttpRequest responses (the mechanism we use to achieve
            // caching of js and css files in other browsers) are not cached by the browser in
            // these versions.  See cacheModules() for the module workaround - all other cache
            // directives for .js and .css files in FF < 1.5 are ignored and the onload handler
            // is fired immediately.
            if (isc.Browser.isMoz && isc.Browser.geckoVersion < 20051107
                && fileConfig.cacheOnly && !config.isModule)
            {
                // we're not going to request this file, so clear the config    
                delete this._fileConfig[fileID]; 
                continue;
            } else {
                this.logInfo("queueing ("+(config.cacheOnly ? "cache" : "load")
                    +"URL: " + fileConfig.URL + ", type: " + fileConfig.type);
                this._fileQueue.push(fileID);
                queuedFiles = true;
                lastQueued = fileConfig;
            }
        } 
    }

    // assign the onload handler to the last file we queued
    if (queuedFiles && onload) {
        lastQueued.onload = onload;
        this.logDebug("onload handler present, not assigned to fire after: "+lastQueued.URL);
    }
    // if the user specified an onload handler, fire it even though we haven't
    // loaded anything because the user may have logic waiting for the onload
    // handler to proceed - for example if we have suppressed a duplicate module load
    if (!queuedFiles && onload) {
        this._fireUserOnloadHandlers(onload);
        return;
    }
    // start loading with the queue we've got so far
    this._doLoadFiles();
},

normalizeModuleURL : function (URL) {
    // prepend ISC_ if module name is given without it
    if (URL.indexOf("ISC_") != 0 && URL.indexOf("/") == -1) URL = "ISC_"+URL;

    // if it's a path instead of a module name, don't mess with it
    if (URL.indexOf("/") == -1) URL = this.getIsomorphicDir()+this.modulesDir+URL+".js";

    return URL;
},

// performs image caching
_cacheImages : function () {
    // assembling a bunch of img src links with display:none style and doing an insertAdjacentHTML
    // works cross-browser.
    var html = "";
    while(this._imageQueue.length) {
        var fileID = this._imageQueue.shift();
        var URL = this._fileConfig[fileID].URL;
        var callback = "if(window.isc)isc.FileLoader.fileLoaded(\""+fileID+"\")";
        html += "<IMG SRC='"+URL+"' onload='"+callback+"' onerror='"+callback+"' onabort='"+callback
        // Opera fails to make a request for an image if we set display:none
             + (isc.Browser.isOpera ? "' STYLE=visibility:hidden;position:absolute;top:-1000px'>"
                                    : "' STYLE='display:none'>");
    }
    this._insertHTML(html);    
},

_doLoadFiles : function () {
    // In IE, if all files are cached, they are loaded and evaled synchronously during page load
    // which is not what we want because ISC init delays page render.  Furthermore, we want to make
    // sure the content loading for the initial page gets HTTP connection and bandwidth priority.
    // So we wait until pageLoad to start caching/loading (we install an onload event on the BODY)
    if (!isc.SA_Page.isLoaded()) return;

    this._inDoLoadFiles = true;

    //this.logWarn("_doLoadFiles() proceeding - fileQueue length: " + this._fileQueue.length);
    if (this._fileQueue.length) {
        // only use one HTTP channel at a time
        if (this._loading_file) {
            //this.logWarn("file being loaded, deferring..");
            return;
        }
    
        var fileID = this._fileQueue.shift();
        var fileConfig = this._fileConfig[fileID];
        var URL = fileConfig.URL;

        // set lock to prevent a second fetch until this one completes
        //this.logWarn("setting lock for: " + URL);
        this._loading_file = true;

        

        if (fileConfig.defer) {
            //this.logWarn("calling _loadFile()");
            this._loadFile(fileID);
        } else {
            //this.logWarn("calling _cacheFile()");
            this._cacheFile(fileID);
        }
    } else {
        // images load in parallel
        this._cacheImages();
    }
    this._inDoLoadFiles = false;
},


// After page loading of:
//
// stylesheets:
// IE/Moz: use createElement("link"), body.appendChild() or same as Safari
// Safari: document.write() a link at page load time, then change the href
//
// JS:
// caching with JS file changes: All: use iframe, document.write() script tag use body onload
// loading with JS file changes: All: as caching+eval, JS file must be collapsed to string use body onload
//
// caching with no JS file changes:
//   IE: create a SCRIPT element with type text/html, use body.appendChild() - how to get onload?
//       or use XMLHttp (need to verify how caching works in this case) - explicit onload provided
//   Moz/Safari: set IFRAME src to target JS file (this pops a download dialog in IE), use onload
//               handler on the iframe
//       
// loading with no JS file changes:
//   IE: as caching, but use text/javascript as type
//       or eval result of XMLHttp fetch (see caveat above)
//       possibly eval() script.text after caching
//   Moz: insertAdjacentHTML(<SCRIPT SRC=>), can use extra SCRIPT block to get onload notification.
//        body.appendChild(<SCRIPT SRC=>) works too, but no way to get onload onload?
//   Safari: XMLHttp + eval  
//
// Images:
// All: insertAdjacentHTML()
_linkElementSupportsLoadAndErrorEvents: (isc.Browser.isMoz && isc.Browser.version >= 9) || isc.Browser.isChrome || isc.Browser.isSafari,
_loadFile : function (fileID) {
    var fileConfig = this._fileConfig[fileID];
    var URL = fileConfig.URL;
    var type = fileConfig.type;

    if (type == "js") {
        
        if (isc.Browser.isOpera) {
            
            this._addScriptElement(URL, function () {
                isc.FileLoader.fileLoaded(fileID);
            });
        } else if (isc.Browser.isMoz && isc.Browser.geckoVersion < 20051107) {
            // FF 1.0 doesn't cache XMLHttp responses even when caching headers are correctly set.
            this._insertHTML("<SCRIPT SRC='"+URL+"'></SCRIPT><SCRIPT>if(window.isc)isc.FileLoader.fileLoaded('"
                             +fileID+"')</SCRIPT>");
        } else {
            // IE, Safari, FF 1.5+
            //this.logWarn("issuing XHR GET: " + URL);
            isc.SA_XMLHttp.get(URL, {method: this.fileLoaded, target: this, args: [fileID]});
        }
    }  else if (type == "css") {
        

        // the entry for the stylesheet we're going to load is going to be the next index in
        // the document.styleSheets array
        fileConfig.cssIndex = this.useCSSLoaders ? this.nextCSSLoader : document.styleSheets.length;
        fileConfig.cssLoadStart = new Date().getTime();
        if (this.useCSSLoaders) {
            // in older Safari, dynamically writing a LINK element does not cause a fetch, so we use
            // <link> elements that the FileLoader document.write()s onto the page at load
            // for the purpose of loading CSS files.
            if (this.nextCSSLoader > window.isc_maxCSSLoaders) {
                this.logWarn("maxCSSLoaders ("+window.isc_maxCSSLoaders+") exceeded - can't load "
                             +fileConfig.URL + " set isc_maxCSSLoaders to a larger number.");

                // fire the onload handler anyway. This is probably the best course of action
                // because typically other logic will be waiting to execute onload and if the
                // file is already loaded, that logic will still work.
                this.fileLoaded(fileID);
                return;
            }
            this._getCSSLoader().href = URL;
        } else {
            // IE, Moz
            // dynamically insert a <link> element into the page
            this._addLinkElement(URL, fileID);
        }
        // poll document.styleSheets
        
        if (!this._linkElementSupportsLoadAndErrorEvents || this.useCSSLoaders) {
            this.startCSSPollTimer(fileID, 0);
        }
    }

},


startCSSPollTimer : function (fileID, delay) {
    window.setTimeout(function () {
        isc.FileLoader.pollForCSSLoaded(fileID);
    }, delay)
},

pollForCSSLoaded : function (fileID) {
    var fileConfig = this._fileConfig[fileID];
    var ss = document.styleSheets[fileConfig.cssIndex];
    var loaded = false;
    
        
    if (ss == null) {
//        this.logWarn("Can't find cssRule for URL: " + fileConfig.URL + " at index: " + fileConfig.cssIndex);
    } else {
        // the css is considered loaded when there's at least one rule in the rules/cssRules
        // array for that stylesheet
        if (isc.Browser.isIE) {
            if (ss.rules != null && ss.rules.length > 0) loaded = true;
        } else if (isc.Browser.isOpera) {
            if (ss.cssRules != null && ss.cssRules.length > 0) loaded = true;
        } else {
            // in FF, accessing .cssRules before the stylesheet finishes loading causes an error
            try {
                if (ss.cssRules != null && ss.cssRules.length > 0) loaded = true;
            } catch (e) {
                // if we've set document.domain or are loading a stylesheet cross-domain, FF
                // throws a security exception, but happily applies the stylesheet, so if we
                // get an exception, consider it loaded.
                //
                // Considering a stylesheet loaded before it has actually loaded is dangerous,
                // because Canvas can end up with a bogus style cache.
                if (isc.Browser.isMoz &&
                    (document.domain != location.hostname ||
                     (fileConfig.URL.startsWith("http") && fileConfig.URL.indexOf(location.hostname) == -1)))
                {
                    loaded = true;
                }
            }
        }
    }

    if (!loaded) {
        // it may be possible for a stylesheet to load and not contain any cssRules if, for
        // example all the rules happen to be ignored by this particular browser type.  Of
        // course end-user logic may be waiting for the load notification before proceeding
        // with some logic, so we still need to fire the onload in that case.  So if we've
        // exceeded the cssLoad timeout, fire the onload handler.
        var ts = new Date().getTime();
        if (ts > fileConfig.cssLoadStart+this.cssWarnTimeout && !fileConfig.warnedAboutCSSTimeout) {
            this.logWarn("CSS file " + fileConfig.URL + " taking longer than " + this.cssWarnTimeout
                         + " to load - may indicate a bad URL");
            fileConfig.warnedAboutCSSTimeout = true;
        }
        if (ts > fileConfig.cssLoadStart+this.cssLoadTimeout) {
            this.logWarn("cssLoadTimeout of: " + this.cssLoadTimeout + " exceeded for: "
                         + fileConfig.URL + " - assuming loaded, firing onload handler.");
            loaded = true;
        }
    }

    if (loaded) {
        this.fileLoaded(fileID);
    } else {
        this.startCSSPollTimer(fileID, this.cssPollFrequency);
    }
},

_cacheFile : function (fileID) {
    var fileConfig = this._fileConfig[fileID];
    var URL = fileConfig.URL;
    
    if (isc.Browser.isOpera) {
        // use text/html mimeType to suppress execution
        // Script loading also works for caching .css files.
        this._addScriptElement(URL, function () {
            isc.FileLoader.fileLoaded(fileID);
        }, "text/html");
    } else if (isc.Browser.isIE || isc.Browser.isSafari ||
        (isc.Browser.isMoz && isc.Browser.geckoVersion >= 20051107))
    {
        //this.logWarn("issuing XHR GET (cache): " + URL);
        isc.SA_XMLHttp.get(URL, {method: this.fileLoaded, target: this, args: [fileID]});
    } else if (isc.Browser.isMoz) {
        
        var iframe = this._getIFRAME();
        this._lastFileID = fileID;
        iframe.src = URL;
    }
},

fileLoaded : function (fileID, fileContents, ignoreThisArg, delayed) {
    // see the "Other notes" section for why this is here
    if (!window.isc) return;

    // callback from SA_XMLHttp
    if (fileContents != null && (fileContents.responseText != null || fileContents.status != null)) {
        var xhr = fileContents;

        var status = xhr.status;
        // All HTTP 2xx codes indicate success.  Success codes other than 200 OK are
        // somewhat obscure, but are used by Amazon S3 and possibly other REST APIs
        if (status > 299 || status < 200) { //error        
            // needs to be done here, to prevent js evel errors trying to parse an error response
            var tempConfig = this._fileConfig[fileID];
            if (tempConfig != null && tempConfig.loadFailedPrompt) {
                // if loadFailedPrompt was set by the caller (currently load/cacheLocale),
                // log it as a warning and bail (eval() would fail later anyway otherwise)
                this.logWarn(tempConfig.loadFailedPrompt+" (XHR status: "+xhr.status+")");
            } else {
                this.logDebug("failed to load "+xhr.responseURL+" (XHR status: "+xhr.status+")");
            }
            fileContents = null;
            // fall through to continue processing future files and call the callback, if any
        } else {
            // success
            fileContents = xhr.responseText;
        }

        // Attempt to handle a loginRequired response.  This is a bit of an edge case, but it's straightforward
        // to at least call the user's loginRequired handler if the page has SmartClient loaded and they provided
        // one.  
        // 
        // processLoginStatusText won't actually do anything because we don't provide a transactionNum,
        // but it will return true if it's a relogin situation.  Note that processLoginStatusText handles
        // multiple markers, but the only possibility here is that we get a loginRequired marker./*
        if (fileContents != null && isc.RPCManager && isc.RPCManager.processLoginStatusText(fileContents, null)) {
            if (isc.RPCManager.loginRequired) {
                // pass a special flag indicating that we want a top-level page reload on relogin.  
                // In some use cases maybe there's a way to cleanly restart, but not worth covering for now.
                isc.RPCManager.loginRequired("isc_requestPageReload");
                if (this.stopProcessingOnLoginRequired) return;
            } else {
                var tempConfig = this._fileConfig[fileID];
                this.logWarn("Encountered loginRequired marker attempting to load: "
                    +tempConfig.URL+", but no isc.RPCManager.loginRequired handler is registered"
                    +" to handle relogin.  Proceeding regardless.");
            }
        }
    }
    

    

    if (!fileID) {
        fileID = this._lastFileID;
        delete this._lastFileID;
    }

    // get the fileConfig here, after any delayed call was set up (in Moz) - see comment below 
    var fileConfig = this._fileConfig[fileID];
//    alert("loaded: " + fileConfig.URL);

    // Crazy timing-dependant Moz bug: If you're loading a script file via our insertAdjacentHTML
    // mechanism (two script blocks with the second one firing the callback to this method) and you
    // reload the page, the callback in the second script block can fire into the context of the JS
    // interpreter loaded by the new page.  There's some evidence that this can happen between two
    // pages, but this hasn't been confirmed (also possibly a cross-domain security bug).
    //
    // So we work around this by using unique time-based IDs for the files we load so we can
    // ignore cross-page callbacks.
    if (!fileConfig) {
//        this.logDebug("fileLoaded() ignoring invalid fileID: "+fileID);
        return;
    }
    // fileContents will only be present for XMLHttp-based loading
    if (fileConfig.defer && fileConfig.type == "js" && fileContents) {
        // eval/request pipelining: kick off the next request first and only then eval the
        // contents of the file.  This allows us to hide the eval time in the download time, to
        // the maximum extent possible.
        fileConfig.fileContents = fileContents;
        window.setTimeout("isc.FileLoader.delayedEval('"+fileID+"')", 0);
    } else {
        this._completeLoad(fileID);
    }

    // release lock
    if (fileConfig.type != "image") {
        //this.logWarn("releasing lock for: " + fileConfig.URL);
        this._loading_file = false;
    }

    
    //this._doLoadFiles();
    if (this._inDoLoadFiles) { // detects synchronous firing of xhr.readyStateChanged()
        window.setTimeout(function () {
            isc.FileLoader._doLoadFiles();
        }, 0);
    } else this._doLoadFiles();
},

// Note: the eval logic here duplicates Class.globalEvalWithCapture() - if you change this
// code, be sure to update that method.
delayedEval : function (fileID) {
    //!OBFUSCATEOK
    var fileConfig = this._fileConfig[fileID];

    var fileContents = fileConfig.fileContents;    

    

    // If we simply eval() the script, global function and variable declarations
    // in .js file will only exist for the scope of the eval - meaning that a .js file
    // that contains e.g:
    // 
    //   function foo() {}
    //   var bar = 5;
    //
    // would not export foo() or bar into global scope as would normally happen if you
    // loaded it via <SCRIPT SRC=>
    //
    // Fortunately a workaround exists:
    if (isc.Browser.isSafari) {
        // This is the only mechanism that works for Safari.
        // Previously, we used to set a separate timout also with a zero delay to fire
        // _completeLoad(), but from 3.0.3 to 3.0.4 the webkit guys rolled out an enormous
        // number of changes, which caused two sequential setTimeout()s with a zero delay to
        // sometimes fire out of order on Windows (and possibly Mac), causing us to roll these
        // together here.
        window.setTimeout([fileContents,";isc.FileLoader._completeLoad('",fileID,"')"].join(""),0);
        return;

        
        //window._evalCode = fileContents;
        //var e = document.createElement("script");
        //e.innerHTML = "isc.evalSA(window._evalCode)";
        //document.getElementsByTagName("body")[0].appendChild(e);
    } else if (isc.Browser.isIE) {
        // execScript() - Special IE only function that exports to global scope -
        // can also be used to execute VBScript code. Before IE 9 no other mechanism
        // is known to work to evaluate code in the global scope. Starting with
        // IE 9, an indirect eval executes properly in the global scope:
        // http://msdn.microsoft.com/en-us/library/ie/gg622934.aspx
        // Also, execScript() is unavailable in IE11+:
        // http://msdn.microsoft.com/en-us/library/ie/ms536420.aspx
        if (window.execScript != null) {
            window.execScript(fileContents, "javascript");

        // Indirect eval
        // http://perfectionkills.com/global-eval-what-are-the-options/#windoweval
        } else {
            window.eval(fileContents);
        }
    } else {
        // FF/Moz: Use isc.Class.evaluate and pass in 'global' parameter
        if (isc.Class && isc.Class.evaluate) {
            isc.Class.evaluate(fileContents, null, true);
        } else {
            window.eval(fileContents);
        }
    }

    this._completeLoad(fileID);
},

_completeLoad : function (fileID) {
    //!OBFUSCATEOK
    var fileConfig = this._fileConfig[fileID];

    // load skins, etc.
    this._checkISCInit();

    

    // if the user specified an onload handler, fire that now that we've loaded the file. 
    if (fileConfig.onload) {
        this._fireUserOnloadHandlers(fileConfig.onload);
    }
    delete this._fileConfig[fileID]; // done loading file, can clear metadata
},
_fireUserOnloadHandlers : function (onload) {
    if (!this.isAnArray(onload)) onload = [onload];
    for (var i = 0; i < onload.length; i++) {
        var handler = onload[i];
        // pass the fileConfig to the onload handler - internal use only
        if (this.isAString(handler)) isc.evalSA(handler);
        else handler();
    }
},

// internal helper method to fetch a reference to the window object of the loader IFRAME
_getIFRAME : function () {

    if (!this._iframe) {
        this._insertHTML("<IFRAME STYLE='position:absolute;visibility:hidden;top:-1000px'"
                        +" onload='if(window.isc)isc.FileLoader.fileLoaded()'"
                        +" NAME='isc_fileLoader_iframe' ID='isc_fileLoader_iframe'></IFRAME>");
        this._iframe = document.getElementById("isc_fileLoader_iframe");
    }
    return this._iframe;
},

_insertHTML : function (html) {
    if (!this._anchorElement) this._anchorElement = document.getElementsByTagName("body")[0];

    var anchor = this._anchorElement;
    if (isc.Browser.useInsertAdjacentHTML) {
        anchor.insertAdjacentHTML('beforeEnd', html);
    } else {
        var range = anchor.ownerDocument.createRange();
        range.setStartBefore(anchor);
        var parsedHTML = range.createContextualFragment(html);
        anchor.appendChild(parsedHTML);
    }
},

_addLinkElement : function (href, fileID) {
    var e = document.createElement("link");
    e.rel = "stylesheet";
    e.type = "text/css";
    e.href = href;
    
    if (this._linkElementSupportsLoadAndErrorEvents) {
        e.onload = function () {
            isc.FileLoader.fileLoaded(fileID);
        };
        e.onerror = function () {
            isc.FileLoader.logError("CSS file " + href + " failed to load");
            isc.FileLoader.fileLoaded(fileID);
        };
    }

    document.getElementsByTagName("body")[0].appendChild(e);
},

_addScriptElement : function (src, onload, type) {
    if (!type) type = "text/javascript";

    var e = document.createElement("script");
    e.type = type
    e.src = src;
    if (onload) e.onload = onload;

    document.getElementsByTagName("body")[0].appendChild(e);
},

_waitingOnModules : function () {
    for (var i = 0; i < this._fileQueue.length; i++) {
        var fileID = this._fileQueue[i];
        var fileConfig = this._fileConfig[fileID];
        if (fileConfig.isModule) return true;
    }
    return false;
},

_checkISCInit : function () {

    // kick Page.finishedLoading() if we've loaded the core module - but only do this once
    if (isc.Page && !isc.Page.isLoaded()) {
        isc.Page.finishedLoading();
    }
},

_pageLoad : function () {
    // if we don't do this on a timer, some images don't render until after doLoadFiles() returns
    // which can take ~500ms on IE because the module load/eval is synchronous.
    this.logInfo("FileLoader initialized");
    if (isc.fileLoaderLoaded) isc.fileLoaderLoaded();
    setTimeout(function () {
        isc.FileLoader._doLoadFiles();
    }, 0);
},


//> @classMethod FileLoader.ensureLoaded()
//
// Loads the FileLoader into the page if it has not already been loaded. Whether the FileLoader
// is loaded or not, the callback fires.
// <p>
// The purpose of this method is to enable a canonical way of loading/caching code and assets.
// As follows:
// <pre>
// isc.FileLoader.ensureLoaded(function () {
//     isc.FileLoader.loadModules(["DataBinding", "SomethingElse"]);
//     isc.FileLoader.loadJSFiles("/my/precious.js", function () {
//         isc.Log.logWarn("All necessary assets loaded!");
//     });
// });
// </pre>
//
// @param callback (Callback) Callback to fire when FileLoader has loaded.
//
// @visibility FileLoader
//<
// Note: replaces FileLoaderBootstrap available() method 
ensureLoaded : function (callback) {
    if (this.isAString(callback)) isc.evalSA(callback);
    else callback();
},

_getCSSLoader : function (num) {
    if (num == null) num = this.nextCSSLoader++;
    return document.getElementById("isc_fl_css_loader"+num);
},

//>@classMethod FileLoader.showLoadingIndicator() 
// Show a loading indicator on the page. This consists of an icon and an optional message in a styled,
// absolutely positioned element on the page.
// <P>
// The default configuration is set in +link{FileLoader.loadingIndicatorSettings}.
// The default image is <code>"loading.gif"</code> from the skin <code>images</code> subdirectory. 
// <P>
// The default configuration specifies the following CSS styles:
// <ul>
// <li>"loadingIndicator" (css class applied to element as a whole)</li>
// <li>"loadingIndicatorImage" (css class for the image element)</li>
// <li>"loadingIndicatorText" (css class for the element containing the message)</li>
// </ul>
// <P>
// The following default class declarations
// (also available as "loading.css" under the <code>helpers</code> subdirectory) use the
// default style names to center the image and text vertically and horizontally within the
// indicator's specified rect.
// <pre>
// .loadingIndicator {
//     background-color:#e2e2e2;
//     display:flex;
//     justify-content:center;
//     align-items:center;
// }
// .loadingIndicatorImage {
//     padding:8px;
// }
// .loadingIndicatorText {
//   color: #282828;
//   font-family: calibri, Sans-Serif;
//   font-size: 12px;
//   padding: 8px;
// }
// </pre>
//
// @param [config] (LoadingIndicatorSettings) 
//   Optional configuration for the loading indicator. If specified these attributes will be applied
//   on top of the +link{FileLoader.loadingIndicatorSettings,default settings}.
//
// @see classAttr:FileLoader.loadingIndicatorSettings
// @see classMethod:FileLoader.hideLoadingIndicator
//
// @visibility external
// @group loadingIndicator
//
//<
showLoadingIndicator : function (config) {

    this.hideLoadingIndicator();

    var newConfig = isc.addProperties({}, this.loadingIndicatorSettings);
    if (config != null) isc.addProperties(newConfig, config);
    config = newConfig;


    var image = config.image,
        imageWidth = config.imageWidth,
        imageHeight = config.imageHeight,

        message = config.message,

        elementStyle = config.style,
        textStyle =  config.textStyle,
        imageStyle = config.imageStyle,
        
        loadingIndicatorZIndex = config.zIndex,

        target = config.target
    ;
    
    // create and position the throbber
    // will remain centered when browser is resized
    var indicator = this._loadingIndicator = document.createElement("div");
    indicator.className = elementStyle;
    indicator.style.position = "absolute";

    var rect;
    if (target != null) {
        if (Array.isArray && Array.isArray(target)) {
            rect = target;
        } else if (target instanceof HTMLElement) {
            rect = [];
            var target = target.getBoundingClientRect(target);
            rect[0] = target.left;
            rect[1] = target.top;
            rect[2] = target.width;
            rect[3] = target.height;
        }
    }

    // If a 'rect' was passed in, respect it. This is useful for legacy integration with some
    // existing UI. Devs may float the loading indicator
    // over some placeholder HTML element that will subsequently be filled by a SmartClient
    // component.
    if (rect != null) {
        // Support being passed pixel vals (as doc'd), or css strings like "40%"
        if (typeof rect[0] == "number") rect[0]+= "px"
        if (typeof rect[1] == "number") rect[1]+= "px"
        if (typeof rect[2] == "number") rect[2]+= "px"
        if (typeof rect[3] == "number") rect[3]+= "px"

        indicator.style.left = rect[0];
        indicator.style.top = rect[1];
        indicator.style.width = rect[2];
        indicator.style.height = rect[3];
    } else {

        // We're doing an approximate centering here!
        indicator.style.left = "45%";
        indicator.style.top = "40%";
    }

    // arbitrary z-index picked near the top of the available range (see canvas.setZIndex())
    indicator.style.zIndex = loadingIndicatorZIndex;
    
    // create image
    var img = document.createElement("IMG");
    img.height = imageHeight;
    img.width = imageWidth;

    img.style["vertical-align"] = "top";

    img.className = imageStyle;

    if (image && image.indexOf("[SKIN]") == 0) {
        image = this._getSkinDir() + "images/" + image.substring(6);
    }
    img.src = image;

    indicator.appendChild(img);

    // create message text
    if (message) {
        var text = document.createTextNode(message);
        var messageSpan = document.createElement("SPAN");
        messageSpan.className = textStyle;
        messageSpan.appendChild(text);
        indicator.appendChild(messageSpan);
    }
    
    document.getElementsByTagName("body").item(0).appendChild(indicator);

},


//> @classMethod FileLoader.hideLoadingIndicator()
// Hide the loading indicator displayed by +link{classMethod:FileLoader.showLoadingIndicator()}
// @visibility external
// @group loadingIndicator
//<
hideLoadingIndicator : function () {
    if (this._loadingIndicator) {
        document.getElementsByTagName("body").item(0).removeChild(this._loadingIndicator);
        this._loadingIndicator = null;
    }

},

//> @classAttr FileLoader.loadingIndicatorSettings (LoadingIndicatorSettings : {...} : IRWA)
// Settings to control the default appearance of the
// +link{classMethod:FileLoader.showLoadingIndicator(),loading indicator}.
// <P>
// The default configuration for this object has the following attribute values:
// <ul>
// <li>+link{LoadingIndicatorSettings.image,image} : "[SKIN]loading.gif"</li>
// <li>+link{LoadingIndicatorSettings.imageWidth,imageWidth} : 16</li>
// <li>+link{LoadingIndicatorSettings.imageHeight,imageHeight} : 16</li>
// <li>+link{LoadingIndicatorSettings.message,message} : null</li>
// <li>+link{LoadingIndicatorSettings.style,style} : "loadingIndicator"</li>
// <li>+link{LoadingIndicatorSettings.textStyle,textStyle} : "loadingIndicatorText"</li>
// <li>+link{LoadingIndicatorSettings.imageStyle,imageStyle} : "loadingIndicatorImage"</li>
// <li>+link{LoadingIndicatorSettings.zIndex,zIndex} : 1000000000</li>
// </ul>
// To change or add attributes we recommend using +link{class.changeDefaults()}. Developers 
// may also pass an explicit +link{LoadingIndicatorSettings} configuration object to 
// +link{FileLoader.showLoadingIndicator()} to override these settings at runtime.
// <p>
// Note that the FileLoader is meant to be very tiny, so that it can be inserted into a 
// context like a plain HTML login page and start loading SmartClient resources & your 
// application code in the background.  For this reason, the image used by this attribute does 
// not support SVG symbols via the +link{@group:svgSymbols, SVG spriting system}, because that
// would require additional framework code to be loaded in advance.
// <p>
// However, if you want an animated SVG loadingIndicator, you can do so with a regular .svg 
// file and some CSS to animate it.  For example, you could download FontAwesome's 
// "spinner-solid.svg" and then apply and animate it with code like this below.  Note that AI 
// systems such as ChatGPT can help with generating keyframes for different animation effects.
// <pre>
// // CSS
// .spinner {
//     width: 30px;
//     height: 30px;
// }
//
// .spinner img {
//     width: 100%;
//     height: 100%;
//     animation: spin 2s linear infinite;
// }
//
// &#64;keyframes spin {
//     0% {
//         transform: rotate(0deg);
//     }
//     100% {
//         transform: rotate(360deg);
//     }
// }
// 
// JS
// 
// // apply animated CSS style, spinner-solid.svg icon and sizes for the SVG
// isc.FileLoader.changeDefaults("loadingIndicatorSettings", {
//     style: "spinner",
//     image: "spinner-solid.svg",
//     imageWidth: 30,
//     imageHeight: 30
// });
// 
// // to test
// isc.FileLoader.showLoadingIndicator();
// </pre>
// 
// @visibility external
// @group loadingIndicator
//<
loadingIndicatorSettings:{
    image:"[SKIN]loading.gif",
    imageWidth:16,
    imageHeight:16,
    style:"loadingIndicator",
    textStyle:"loadingIndicatorText",
    imageStyle:"loadingIndicatorImage",
    zIndex:1000000000
},

// limited implementation of changeDefaults() - the real method is on isc.Class and has 
// never been supported on FileLoader - but it's simple and has been long recommended in the 
// docs for modifying loadingIndicatorSettings, so may as well make it work
changeDefaults : function (defaultsName, newDefaults) {
    // get existing defaults
    var defaults = this[defaultsName];
    if (!defaults || typeof defaults !== "object") return;
    // if it's an object, clobber properties
    for (var key in newDefaults) {
        defaults[key] = newDefaults[key];
    }
},

// An explicit configuration object allows devs to configure the loading indicator as part of
// a call to showLoadingIndicator (or load())

//> @object LoadingIndicatorSettings
//
// Set of properties to configure the loading indicator displayed by +link{classMethod:FileLoader.showLoadingIndicator()}
//
// @treeLocation Optional Modules/Network Performance
// @visibility external
//<

//> @attr LoadingIndicatorSettings.image (SCImgURL : null : IRW)
// Loading indiciator image to display.
// @visibility external
//<

//> @attr LoadingIndicatorSettings.imageWidth (Integer : null : IRW)
// Width for the loading indiciator image.
// @visibility external
//<

//> @attr LoadingIndicatorSettings.imageHeight (Integer : null : IRW)
// Height for the loading indiciator image.
// @visibility external
//<

//> @attr LoadingIndicatorSettings.message (HTML String : null : IRW)
// Optional HTML text message to display in the loading indicator.
// @visibility external
//<

//> @attr LoadingIndicatorSettings.style (CSSStyleName : null : IRW)
// CSS class to apply to the loading indicator.
// @visibility external
//<

//> @attr LoadingIndicatorSettings.textStyle (CSSStyleName : null : IRW)
// CSS class to apply to the loading indicator message text.
// @visibility external
//<

//> @attr LoadingIndicatorSettings.imageStyle (CSSStyleName : null : IRW)
// CSS class to apply to the loading indicator.
// @visibility external
//<

//> @attr LoadingIndicatorSettings.target (Array of Integer | DOMElement : null : IRW)
// Target position / sizing for the loading indiciator. May be specified as a four element
// array <code>[left,top,width,height]</code> or as a DOM element, in which case the
// indicator will be sized and positioned to match the client bounding rect of the target element.
// If unspecified, the loading indicator will be sized to fit its content and centered on the page.
// @visibility external
//<

//> @attr LoadingIndicatorSettings.zIndex (Integer : null : IRW)
// Target z-index to apply to the loading indiciator.
//
// @visibility external
//<


// Older name for the showLoadingIndicator API
showThrobber : function (message, style, image, imageWidth, imageHeight) {

    return this.showLoadingIndicator(false, message, null,
             {image:image, imageWidth:imageWidth, imageHeight:imageHeight, textStyle:style})

},

hideThrobber : function () {
    return this.hideLoadingIndicator();
}

}); // end FileLoader class definition.

// FL synonym for FileLoader
isc.addGlobal("FL", isc.FileLoader);

// function aliases
isc.addProperties(isc.FileLoader, {
    loadJSFiles: isc.FileLoader.loadJSFile,
    loadModules: isc.FileLoader.loadModule,
    cacheFiles: isc.FileLoader.cacheFile,
    cacheModules: isc.FileLoader.cacheModule,
    loadCSSFiles: isc.FileLoader.loadCSSFile,
    loadFiles: isc.FileLoader.loadFile
});

// CSS loader for safari  
// XXX need multiple link loaders for multiple css files?
if (isc.FL.useCSSLoaders) {
    var s = "";
    for (var i = 0; i < window.isc_maxCSSLoaders; i++) {        
        s += "<LINK id='isc_fl_css_loader"+i+"' name='isc_fl_css_loader"+i+"' REL='stylesheet' TYPE='text/css'>";
    }
    document.write(s);
}

if (isc.SA_Page.isLoaded()) {
    isc.FileLoader._pageLoad();
} else {
    isc.SA_Page.onLoad(isc.FileLoader._pageLoad, isc.FileLoader);
}



//> @groupDef networkPerformance
//
// This section describes various methods for optimizing delivery of your SmartClient-based
// application to the browser.  The various techniques discussed here should enable you to
// drastically reduce the time to load your SmartClient based application and to cut down on
// bandwidth costs and server-side CPU usage.
// <P>
// <i>Note that in addition to these network performance considerations, you should also be aware
// of the recommended application design practices discussed in +link{group:smartArchitecture}.</i>
// <P>
//
// There are three main ways of improving the performance of your application:
// <p>
// <u><b>Compression</b></u>
// <p>
// You'll want to deliver as much of your application assets compressed as possible.  For a start, the
// SmartClient modules come pre-compressed.  The +link{group:compression} section describes how
// to make sure that SmartClient modules and your application logic are delivered compressed
// and how to enable dynamic compression of your dynamic content.
// <p>
// Compression drastically reduces transfer times to the browser.  Compression ratios for css
// and javascript files can be as high as 8:1.
//
// <p>
// <u><b>Caching</b></u>
// <p>
// The +link{group:caching} section deals with delivering as much content as possible with
// caching headers.  Setting these headers allows the end-user's browser and any intermediary
// proxies to keep a local copy of the file across browser reloads, ensuring the subsequent
// visits require almost no fetches from the server.  Eliminating these fetches is also
// important for the reasons explained under File Assembly below.
// 
// <p>
// <u><b>File Assembly</b></u>
// <p>
// Modern browsers limit the number of HTTP connections they use to fetch the assets required
// to render your pages - typically to just 2 connections.  As a result, connection latency can
// play a much higher role than available bandwidth and the two connection limit effectively
// drastically limits the user's usable bandwidth.  For this reason, it's important to minimize
// the number of HTTP requests made to the server.  The File Assembly services make it easy to
// deliver multiple css and javascript file via one HTTP response.  Assembling files together
// also helps to increase the compression ratio because the compression engine has more
// redundant data to work with.
//
// <p>
// <u><b>FileLoader</b></u>
// <p>
// The FileLoader is a standalone client-side module that allows you to performing caching or
// loading of various resources in the background on any page.  The typical usage pattern is to
// use this module to pre-cache SmartClient modules, skin images, and application logic while
// the user is, for example filling in a login form.  See the +link{FileLoader} documentation
// on usage.
//
// <p>
// <u><b>SSL Considerations</b></u>
// <p>
// Some quirks to be aware of when optimizing for pages serviced via HTTPS:
// <ul>
// <li>If your top-level https page loads an image via http, IE will pop a warning to the user
// asking if it's ok to serve the "unsecure" content.  Firefox does not pop an alert, bug shows
// a different lock icon to indicate that not all content is served from a secure server.
// <li>Firefox will not write images fetched via SSL to disk, even if expires headers are set.
// But it will cache them in memory for the duration of the browser session.  This makes the
// use of the +link{FileLoader} even more important for SSL applications.  IE will cache SSL
// content across browser restarts.
// <li>If your only concern is with actual security and not with perception, it makes a lot of
// sense to serve the top-level page via plain HTTP and then use the SmartClient RPC mechanism
// to fetch sensitive data with no-cache headers via HTTPS.  Unfortunately this almost never
// practical because most users look for the secure lock icon on the top-level page and may
// become worried that the application is not secure if they don't see it.
// </ul>
//
// <p>
// <u><b>Other Tips</b></u>
// <p>
// 1.  Modern applications often use a number of cookies to keep track of session state,
// application state, etc.  If you don't limit the paths these cookies are served for, you can
// easily end up with these cookies being sent to the server with every HTTP request as
// part of the HTTP headers.  This can severely limit bandwidth where a large number of
// requests are made - typically for skin images.  Also note that most technologies used by
// end-users to connect to the internet such as DSL and Cable are half-duplex, meaning that
// downstream must pause for upstream traffic to be sent and these connections also are
// asymmetric, allowing much faster download speeds than upload speeds.  As a result, the
// limited upstream capability of most connections ends up limiting the download bandwidth by
// delaying the download of other assets required to render the page.
// <p>
// 2.  Whenever possible, don't set the "Cache-Control" header to "private" - this tells
// intermediary proxies to not allow caching of the specified content, eliminating that cache
// as a useful intermediary for other users behind it.
// <p>
// 3.  For a good overview of performance considerations, see this post:
// +externalLink{http://www.die.net/musings/page_load_time/}
//
// @title Network Performance
// @treeLocation Optional Modules
// @visibility FileLoader
//<


//> @groupDef compression
//
// Compression helps reduce the sizes of various data fetched from the server.  Most modern web
// browsers can handle compressed responses of certain content types. The time it takes to
// decompress these responses on a client system is negligible compared to the time saved
// by reducing the number of bits on the wire, especially for slow connections.
// <p>
// If you're not using the SmartClient Java back-end, there are several compression solutions
// available, depending on your server of choice.  Microsoft's IIS has built-in compression
// capability, please check the reference manual for details.  If you're using Apache, you can
// use +externalLink{http://sourceforge.net/projects/mod-gzip/, mod_gzip} or 
// use +externalLink{http://httpd.apache.org/docs/2.0/mod/mod_deflate.html, mod_deflate}.  Some
// servlet containers also natively support dynamic compression.
// <p>
// The SmartClient Java back-end supports three types of response compression:
// <ul>
// <li>Pre-compressed static content served via the ISC FileDownload servlet.
// <li>On-the-fly compression of arbitrary content using the CompressionFilter.
// <li>Automatic on-the-fly compression of DSRequest, RPCRequest and DataSourceLoader responses.
// </ul>
// <u>Serving pre-compressed files</u>
// <p>
// To serve pre-compressed static content via FileDownload, register the FileDownload servlet
// in your web.xml as follows:
// <pre>
//     &lt;servlet&gt;
//       &lt;servlet-name&gt;FileDownload&lt;/servlet-name&gt;
//       &lt;servlet-class&gt;com.isomorphic.servlet.FileDownload&lt;/servlet-class&gt;
//     &lt;/servlet&gt;
// </pre>
// Then map any resource that you want to serve compressed to the FileDownload servlet in your
// web.xml.  Typically, you'll want to serve all SmartClient modules compressed.  You can do so
// by adding the following servlet-mapping directive to your web.xml:
// <pre>
//     &lt;servlet-mapping&gt;
//       &lt;servlet-name&gt;FileDownload&lt;/servlet-name&gt;
//       &lt;url-pattern&gt;/isomorphic/system/modules/*&lt;/url-pattern&gt;
//     &lt;/servlet-mapping&gt;
// </pre>
// Finally, you'll need to create pre-compressed versions of your files alongside the
// uncompressed versions.  If you're using the FileAssembler mechanism, it can create
// pre-compressed files for you automatically.  For all other files, you can use any program
// that uses the gzip encoding.  The compressed file must have exactly the same filename as the
// uncompressed version, with a '.gz' extension.  Note that it's important that both the
// compressed and uncompressed versions be present alongside each other because there are cases
// where serving compressed content is not possible (for example HTTP 1.0 requests) - for those
// situations it's important that the uncompressed files be available to be served to the
// client.  The FileDownload filter automatically detects whether or not compression is
// possible.
// <p>
// <u>Dynamic Compression</u>
// <p>
// Dynamic Compression requires the optional Network Performance module.  To use Dynamic
// Compression, register the CompressionFilter filter in your web.xml as follows:
// <pre>
//     &lt;filter&gt;
//         &lt;filter-name&gt;CompressionFilter&lt;/filter-name&gt;
//         &lt;filter-class&gt;com.isomorphic.servlet.CompressionFilter&lt;/filter-class&gt;
//     &lt;/filter&gt;
// </pre>
// Then map any resource that you want dynamically compressed to this filter.  Note that the
// CompressionFilter knows the mime types that are compressible and will automatically ignore
// any stream that sets a content-encoding header, and it automatically figures out if the
// current request is an include or forward (and doesn't compress in that case), so it's safe
// to simply map it to all resources as follows:
// <pre>
//     &lt;filter-mapping&gt;
//         &lt;filter-name&gt;CompressionFilter&lt;/filter-name&gt;
//         &lt;url-pattern&gt;/*&lt;/url-pattern&gt;
//     &lt;/filter-mapping&gt;
// </pre>
// You can register the CompressionFilter anywhere in your filter chain, but be aware that
// if any filters in front wrap and inspect the HttpServletResponse output stream, they will
// be inspecting the compressed response.  Filters are typically applied in the order in which
// they are listed in web.xml and it is advised to keep them that way, otherwise it may result 
// in unexpected behavior. For example, if CompressionFilter would be listed after the 
// JSSyntaxScannerFilter, the last one would stop working, since it relies on uncompressed data.
// <p>
// <u>Automatic Compression of DSRequest, RPCRequest and DataSourceLoader responses</u>
// <p>
// By default, SmartClient Server compresses the responses to all +link{object:DSRequest}s, 
// +link{object:RPCRequest}s and <code>DataSourceLoader</code> requests, whether or not the 
// <code>CompressionFilter</code> is registered.  If you want to switch off this automatic 
// compression, add the following line to your <code>server.properties</code> file:<pre>
//    servlet.compress: false
// </pre>
// <u>Compressible mime types and compatibility</u>
// <p>
// The FileDownload servlet and CompressionFilter filter can serve the following mime-types
// compressed: text/html, text/xml, application/x-javascript, text/javascript, text/ecmascript,
// image/svg+xml, application/javascript, application/json.  If your files are not being compressed, make sure your 
// servlet container has a mime type mapping that identifies it as one of the above file types.
// <p>
// Compression for the mime types listed above is supported on all browsers supported by
// SmartClient.  There is one exception: compression of javascript files for IE versions older
// than IE6 Service Pack 2 requires that the CompressionFilter be registered to dynamically
// compress the page that loads these javascript files.
//
// @title Compression
// @treeLocation Optional Modules/Network Performance
// @visibility FileLoader
//<

//> @groupDef caching
//
// Standard web browsers can cache server responses, associating the locally-cached files with
// the URLs (including query parameters) that were used to fetch the files from the
// server. Each file may be assigned an explicit expiration time. Requests for the associated
// URL will always be served from the local cache, without accessing the server, until the file
// expires.
// <p>
// The recommended approach is to move as much content as possible into cacheable assets
// (these can be images, html, css, and js) and tell the browser to cache those for as long as
// possible (ideally indefinitely).  Clearly, most things can't simply be cached permanently -
// new versions of the application will often require changes to these assets.  To allow for
// this, the pages that direct the loading of the cached assets should be dynamic and should
// create version-specific URLs to these cacheable assets. This can be done by tacking the
// version number as a query parameter or as a path component.  Here's an example of loading a
// javascript file versioned with a query parameter:
// <pre>
// &lt;script src='/foo/bar.js?version=13'&gt;&lt;/script&gt;
// </pre>
// A URL for the same resource including a path component (in this case <code>"v13"</code>)
// might look like this:
// <pre>
// &lt;script src='/v13/foo/bar.js'&gt;&lt;/script&gt;
// </pre>
// The server would of course need to resolve this URL to the appropriate resource.
// <p>
// Note: SmartClient dynamically assembles URLs to retrieve images and CSS from the 
// +link{skinning,current skin}. It's not possible to pervasively apply a version 
// query parameter to these dynamically assembled URLs, so if you want to use
// versioned URLs to ensure that new versions of skin resources are requested when 
// the SmartClient version changes, versioned URLs must be applied with a path component.
// <p>
// For developers using the +link{group:iscServer,SmartClient server}, the 
// +link{group:loadISCTag,loadISC JSP tag} automatically generates version-specific URLs for loading
// SmartClient resources, and can be configured to use either URL-parameters or path segments.
// The SmartClient server can automatically resolve 
// URLs including SmartClient version path segments to the approprirate target resources via
// the FileDownload servlet or the dedicated VersionedURLFilter.
// <p>
// The +link{group:server_properties} configuration can be used to configure default versioning
// behavior for SmartClient JSP tags, and to enable or disable stripping these URL segments when
// processing URLs.
// <P>
// Developers do not need to use the SmartClient server to apply or resolve 
// version-specific URLs of course.
// <p>
// It's trivial to apply a versioned URL to the <code>&lt;script src=...&gt;</code> tags
// used to load SmartClient framework modules and the <code>load_skin.js</code> file for your skin.
// If you included a version-specific path segment in the script tag to retrieve <code>load_skin.js</code>
// the +link{Page.setSkinDir(),skin directory} will automatically pick this up, meaning all requests
// for dynamically loaded skin media will also include the path segment.
// <P>
// For more control you can also specify a custom +link{Page.setIsomorphicDir(),isomorphicDir}
// or +link{Page.setSkinDir(),skinDir}. For example:
// <smartclient>
// <pre>
// isc.Page.setSkinDir('/version/13/isomorphic/skins/SmartClient/');
// </pre>
// </smartclient>
// <smartgwt>
// <pre>
// Page.setSkinDir('/version/13/isomorphic/skins/SmartGWT/');
// </pre>
// </smartgwt>
// You can then either deploy the resources under the versioned directory above or use a URL
// rewriting engine such as mod_rewrite for Apache to map all such versions into a single
// deploy directory.
// <p>
// Generally the version number in a versioned URL wouldn't be hard-coded into a dynamic page, but would
// instead pick up the value of a variable, such that you can simply bump up the value in one
// configuration file and have all versioned URLs change dynamically.
// <p>
// <b>Expires headers</b>
// <p>
// To actually tell the browser to cache files for a longer length of time than the browser
// session, you need to set the HTTP 'Expires' header.
// If you're not using the SmartClient Java back-end there are several caching solutions
// available, depending on your server of choice.  Microsoft's IIS has built-in caching
// capability, please check the reference manual for details.  If you're using Apache, you can
// use +externalLink{http://httpd.apache.org/docs/2.0/mod/mod_expires.html, mod_expires}.  Some servlet
// containers also natively support the setting of caching headers.
// <p>
// The SmartClient Java back-end supports setting caching headers via the FileDownload service
// on a per-mimetype basis.  To use it, first register the FileDownload servlet in your web.xml
// as follows:
// <pre>
//     &lt;servlet&gt;
//       &lt;servlet-name&gt;FileDownload&lt;/servlet-name&gt;
//       &lt;init-param&gt;
//           &lt;param-name&gt;expires&lt;/param-name&gt;
//           &lt;param-value&gt;text/javascript:3600,image/gif:86400&lt;/param-value&gt;
//       &lt;/init-param&gt;
//       &lt;servlet-class&gt;com.isomorphic.servlet.FileDownload&lt;/servlet-class&gt;
//     &lt;/servlet&gt;
// </pre>
// The expires parameter controls the expiration time in seconds.  In the block above,
// javascript files are set to expire in 1 hour and gif images are set to expire in 1 day from
// the time they are served to the browser.  If you don't set explicit expires mappings, all
// images and css files will be set to expire in 1 day and javascript files will expire in 1
// hour, by default.
// <p>
// Next, map any resource that you want to serve with caching headers to the FileDownload
// servlet in your web.xml.  Typically, you'll want to serve the SmartClient modules and all
// skin images with caching headers.  You can do so by adding the following servlet-mapping
// directives to your web.xml:
// <pre>
//     &lt;servlet-mapping&gt;
//       &lt;servlet-name&gt;FileDownload&lt;/servlet-name&gt;
//       &lt;url-pattern&gt;/isomorphic/system/modules/*&lt;/url-pattern&gt;
//     &lt;/servlet-mapping&gt;
// 
//     &lt;servlet-mapping&gt;
//       &lt;servlet-name&gt;FileDownload&lt;/servlet-name&gt;
//       &lt;url-pattern&gt;/isomorphic/skins/*&lt;/url-pattern&gt;
//     &lt;/servlet-mapping&gt;
// </pre>
//
// @title Caching
// @treeLocation Optional Modules/Network Performance
// @visibility FileLoader
//<

//> @groupDef fileAssembly
//
// File assembly concatenates multiple files into a single response, reducing the number
// of HTTP fetches required to load a page. This concatenation also improves the
// compressibility of responses, since the compression algorithm may reduce redundancy across a
// larger data set.
// <p>
// The ISC FileAssembly service provides configuration-driven file assembly, with integrated
// compression and JavaScript stripping services.  Assemblies are specified in an xml format
// and map a URI to a set of files to concatenate together.  There also additional flags to
// enable stripping and compression.  
// <p>
// You can use the FileAssembler to create assemblies of javascript and css.  Since it's
// basically a file concatenator with some specialized services for javascript files, you could
// use it to assembly anything else, but javascript and css are probably the main things to
// consider.
// <p>
// The FileAssembler has a development mode and a production
// packaging mode.  In the development mode, there is a servlet that you can register at
// virtual URLs that are assembled on the fly by the FileAssembler based on its configuration.
// For production packaging, you can use the same configuration file to generate static,
// pre-compressed versions of these files.  The format of the file is as follows:
// <pre>
// &lt;FileAssembly&gt;
//     &lt;assemblies&gt;
//         &lt;FileAssemblyEntry uri="/myAssembly.js"&gt;
//             &lt;compress&gt;true&lt;/compress&gt;
//             &lt;components&gt;
//                 &lt;component&gt;
//                     &lt;type&gt;file&lt;/type&gt;
//                     &lt;fileName&gt;copyright.txt&lt;/fileName&gt;
//                 &lt;/component&gt;
//                 &lt;component&gt;
//                     &lt;type&gt;datasource&lt;/type&gt;
//                     &lt;name&gt;myDatasource1&lt;/name&gt;
//                 &lt;/component&gt;
//                 &lt;component&gt;
//                     &lt;type&gt;ds&lt;/type&gt;
//                     &lt;name&gt;myDatasource2&lt;/name&gt;
//                 &lt;/component&gt;
//                 &lt;component&gt;
//                     &lt;type&gt;file&lt;/type&gt;
//                     &lt;fileName&gt;myPublicCode.js&lt;/fileName&gt;
//                 &lt;/component&gt;
//                 &lt;component&gt;
//                     &lt;type&gt;file&lt;/type&gt;
//                     &lt;fileName&gt;myPrivateCode.js&lt;/fileName&gt;
//                     &lt;jsStripping&gt;full&lt;/jsStripping&gt;
//                 &lt;/component&gt;
//             &lt;/components&gt;
//         &lt;/FileAssemblyEntry&gt;
//     &lt;/assemblies&gt;
// &lt;/FileAssembly&gt;
// </pre>
// You can specify as many FileAssemblyEntry blocks as you want, simply place them alongside
// each other under the &lt;assemblies&gt; element.  The above example states that the
// /myAssembly.js file should be assembled from the various components listed above. Component
// blocks support the following attributes:
// <p>
// <table border='1' class='normal'>
// <tr><td><b>Name</b></td><td><b>Values</b></td><td><b>Description</b></td></tr>
// <tr><td>type</td><td>file<br>xmlFile<br>ds|datasource<br>type<br>ui</td>
//     <td>any file<br>XML file<br>ISC DataSource file<br>ISC SimpleType file<br>ISC UI file<br></td></tr>
// <tr><td>name</td><td>file identifier</td>
//     <td>identifier for a ds or ui file</td></tr>
// <tr><td>fileName</td><td>file path</td><td>path to a file or xmlFile (relative to webRoot)</td></tr>
// <tr><td>jsStripping</td><td>none<br>partial<br>full</td>
//     <td>level of stripping (whitespace, comment, and delimiter removal) applied to file</td></tr>
// </table>
// <p>
// All component types except file are converted from valid ISC XML format to JavaScript format
// by the FileAssembler.  The <code>jsStripping</code> attribute only applies to assembled
// javascript files.
// <p>
// Once you've created the configuration file, you'll probably want to place it somewhere in
// webRoot.  Generally, it can be placed anywhere you like, but the development-time
// FileAssembly servlet requires the file be placed under webRoot. The default location is
// /isomorphicConfig/fileAssembly.xml and can be changed via the <code>configFile</code>
// init-param of the FileAssembly servlet.  To enable development mode support for
// FileAssembly, you'll need to register the FileAssembly servlet in your web.xml as follows:
// <pre>
//     &lt;servlet&gt;
//       &lt;servlet-name&gt;FileAssembly&lt;/servlet-name&gt;
//       &lt;servlet-class&gt;com.isomorphic.servlet.FileAssembly&lt;/servlet-class&gt;
//     &lt;/servlet&gt;
// </pre>
// Now, for every FileAssemblyEntry URI you specified in your fileAssembly.xml, you'll need
// corresponding mappings in web.xml, to tell the servlet container to send requests for that
// file to the FileAssembler.  For example, assuming your fileAssembly.xml contained the
// contents shown above, you'd register /myAssembly.js in your web.xml with the FileAssembler as
// follows:
// <pre>
//     &lt;servlet-mapping&gt;
//       &lt;servlet-name&gt;FileAssembly&lt;/servlet-name&gt;
//       &lt;url-pattern&gt;/myAssembly.js&lt;/url-pattern&gt;
//     &lt;/servlet-mapping&gt;
// </pre>
// You'll need a similar entry for any other entry in your fileAssembly.xml.  Note that this is
// for development only - we'll pregenerate static files for production.  Once you've done the
// above, you can load /myAssembly.js into your page via a standard SCRIPT block, like so:
// <pre>
// &lt;script src="/myAssembly.js"&gt;&lt;/script&gt;
// </pre>
// Now, whenever requests are made for this file, the FileAssembler will check the timestamps
// of all the components of this assembly, rebuild the assembled file if required, and serve it
// to the browser as if it was a static file on disk.
// <p>
// To create static assembled files for production, you can use the fileAssembler command line
// tool provided as part of the SDK.  This is a Java-based command line tool located in
// smartclientSDK/WEB-INF/bin.  There are three versions of the tool in that directory -
// fileAssembler.bat is for Windows platforms, fileAssembler.command is for MacOS platforms, and
// fileAssembler.sh is for *nix platforms.  Running this tool with the --help argument will show
// you the command line switches available.  Typically, you'll need to specify:
// <ul>
// <li>--config &lt;file&gt; - location of the fileAssembly.xml configuration file
// <li>--webRoot &lt;dir&gt; - location of the webRoot that the fileAssembler uses to access the
// component files.
// <li>--outputDir &lt;dir&gt; - location of directory where you want output files to go - typically
// this is the webRoot of your production build.  These are the files you'll deploy to
// production.
// </ul>
// Finally, since the generated files are likely to be compressed and they're static, you'll
// probably want to map the FileDownload servlet to serve them in your production web.xml
//
// @title File Assembly
// @treeLocation Optional Modules/Network Performance
// @requiresModules NetworkPerformance
// @visibility FileLoader
//<
