/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.ErrorHandler;
import org.openqa.selenium.remote.HandshakeResponse;
import org.openqa.selenium.remote.InitialHandshakeResponse;
import org.openqa.selenium.remote.ProtocolHandshake;
import org.openqa.selenium.remote.Response;

class W3CHandshakeResponse
implements HandshakeResponse {
    W3CHandshakeResponse() {
    }

    @Override
    public Function<InitialHandshakeResponse, ProtocolHandshake.Result> errorHandler() {
        return tuple -> {
            Object rawValue = tuple.getData().get("value");
            if (!(rawValue instanceof Map)) {
                return null;
            }
            Map rawMap = (Map)rawValue;
            Object rawMessage = rawMap.get("message");
            Object rawError = rawMap.get("error");
            Object rawStackTrace = rawMap.get("stacktrace");
            String string = rawStackTrace = rawStackTrace == null ? "" : rawStackTrace;
            if (!(rawError instanceof String) || !(rawMessage instanceof String)) {
                return null;
            }
            if (!(rawStackTrace instanceof String)) {
                rawStackTrace = String.valueOf(rawStackTrace);
            }
            Response response = new Response();
            response.setState((String)rawError);
            response.setStatus(new ErrorCodes().toStatus((String)rawError, Optional.of(tuple.getStatusCode())));
            Class<? extends WebDriverException> type = new ErrorCodes().getExceptionType((String)rawError);
            try {
                WebDriverException exception = type.getConstructor(String.class).newInstance((String)rawMessage);
                exception.addInfo("remote stacktrace", (String)rawStackTrace);
                response.setValue(exception);
            }
            catch (ReflectiveOperationException e) {
                response.setValue(rawMessage);
            }
            new ErrorHandler().throwIfResponseFailed(response, tuple.getRequestDuration().toMillis());
            return null;
        };
    }

    @Override
    public Function<InitialHandshakeResponse, ProtocolHandshake.Result> successHandler() {
        return tuple -> {
            if (tuple.getData().containsKey("status")) {
                return null;
            }
            Object rawValue = tuple.getData().get("value");
            if (!(rawValue instanceof Map)) {
                return null;
            }
            Map rawMap = (Map)rawValue;
            Object rawSessionId = rawMap.get("sessionId");
            Object rawCapabilities = rawMap.get("capabilities");
            if (!(rawSessionId instanceof String) || !(rawCapabilities instanceof Map)) {
                return null;
            }
            for (Object key : ((Map)rawCapabilities).keySet()) {
                if (key instanceof String) continue;
                return null;
            }
            Map caps = (Map)rawCapabilities;
            String sessionId = (String)rawSessionId;
            return new ProtocolHandshake.Result(Dialect.W3C, sessionId, caps);
        };
    }
}

