package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * The type of condition field must match in order to be fetched from underlying source of data  and delivered the client.
 */
public enum OutputWhen implements ValueEnum {
    /**
     * Field is never delivered, unless explicitly included in {@link
     * com.smartgwt.client.docs.serverds.OperationBinding#outputs OperationBinding.outputs}.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "never".
     */
    NEVER("never"),
    /**
     * Field is delivered for a {@link com.smartgwt.client.data.OperationBinding#getOperationType fetch} operation by primary
     * key or as cache sync data after {@link com.smartgwt.client.data.OperationBinding#getOperationType update} or  {@link
     * com.smartgwt.client.data.OperationBinding#getOperationType add} operations. In both cases single record  is expected to
     * be returned.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "single".
     */
    SINGLE("single"),
    /**
     * Field is delivered as cache sync data after {@link com.smartgwt.client.data.OperationBinding#getOperationType update} or
     * {@link com.smartgwt.client.data.OperationBinding#getOperationType add} operations only if the client seems to  already
     * have it for that record, i.e. it was present in submitted values.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "whenPresent".
     */
    WHENPRESENT("whenPresent");
    private String value;

    OutputWhen(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
