
package com.smartgwt.client.docs;

/**
 * <h3>Drag and Drop behavior within PortalLayouts</h3>
 * PortalLayouts are a special Layout subclass designed to contain {@link
 * com.smartgwt.client.widgets.layout.Portlet} windows. <P> PortalLayouts support drag and drop
 * behavior to add new Portlets to the layout and to reorganize the Portlets, as well as to
 * reorder existing {@link com.smartgwt.client.widgets.layout.PortalLayout#getColumn columns}. <P>
 * Portlet drop behavior within a PortalLayout is enabled by default, and may be configured per
 * portlet  by setting {@link com.smartgwt.client.widgets.Window#getCanDragReposition
 * Portlet.canDragReposition} and {@link com.smartgwt.client.widgets.layout.Portlet#getCanDrop
 * Portlet.canDrop}. Developers wishing to restrict portlet drop capabilities by type may also set
 * {@link com.smartgwt.client.widgets.layout.Portlet#getDragType Portlet.dragType} and {@link
 * com.smartgwt.client.widgets.layout.PortalLayout#getPortletDropTypes
 * PortalLayout.portletDropTypes}, or override {@link
 * com.smartgwt.client.widgets.layout.PortalLayout#willAcceptPortletDrop
 * PortalLayout.willAcceptPortletDrop()} for custom restrictions. <P> Users may drop existing
 * Portlets or any other droppable component into a portalLayout. If something other than a
 * Portlet is dropped into a portalLayout, a  {@link
 * com.smartgwt.client.widgets.layout.PortalLayout#getPortlet Portlet autoChild} will
 * automatically be created to contain it. Standard {@link com.smartgwt.client.docs.AutoChildUsage
 * autoChild} configuration patterns may be used to customize these automatically created
 * Portlets. <P> Users may add portlets to, or move portlets within a PortalLayout via the
 * following interactions: <ul> <li>If {@link
 * com.smartgwt.client.widgets.layout.PortalLayout#getCanAddColumns PortalLayout.canAddColumns} is
 * true, users may add a new column to the     PortalLayout by dropping a Portlet or other valid
 * component directly onto the     PortalLayout outside of any existing columns, or by dropping
 * within the      {@link com.smartgwt.client.widgets.layout.PortalLayout#getPortletHDropOffset
 * PortalLayout.portletHDropOffset} of a column. The dropped component will be rendered inside    
 * the new column. This behavior can be turned off using {@link
 * com.smartgwt.client.widgets.layout.PortalLayout#getCanAcceptDrop PortalLayout.canAcceptDrop}   
 * or setting {@link com.smartgwt.client.widgets.layout.PortalLayout#getDropTypes
 * PortalLayout.dropTypes} to explicitly disallow portlet drop.</li> <li>The user may add a new
 * row to a column by dropping into the      {@link
 * com.smartgwt.client.widgets.layout.PortalLayout#getRowLayout rowLayout within a column}. This
 * behavior can be turned off by     setting <code>canAcceptDrop</code> to false in the
 * <code>portalLayout.rowLayoutProperties</code>.</li> <li>The user may add a Portlet to an
 * existing row by dropping within {@link
 * com.smartgwt.client.widgets.layout.PortalLayout#getPortletHDropOffset
 * PortalLayout.portletHDropOffset}     of an existing Portlet in a row. This behavior can be
 * turned off by setting     <code>canAcceptDrop</code> to false in the defaults for the {@link
 * com.smartgwt.client.widgets.layout.PortalLayout#getRow row autoChildren}     using
 * <code>portalLayout.rowDefaults</code></li> </ul> The actual component to be added to the
 * PortalLayout on drop is returned by the {@link
 * com.smartgwt.client.widgets.layout.PortalLayout#getDropPortlet PortalLayout.getDropPortlet()}
 * method. This method may be overridden to change what components are added to the  PortalLayout
 * on drop. <P> By default when a user drags all the portlets out of a column, leaving it empty, 
 * the Column will automatically be removed from the Portlet. This behavior may be configured
 * using {@link com.smartgwt.client.widgets.layout.PortalLayout#getRemoveEmptyColumns
 * PortalLayout.removeEmptyColumns}.
 * @see com.smartgwt.client.widgets.layout.PortalLayout#willAcceptPortletDrop
 * @see com.smartgwt.client.widgets.layout.PortalLayout#getCanAcceptDrop
 * @see com.smartgwt.client.widgets.layout.PortalLayout#getDropTypes
 */
public interface PortalLayoutDrop {
}
