package com.smartgwt.client.widgets.grid;

/**
 * Returns additional CSS to apply to a cell, on top of the grid's cell-styling
 */
public interface CellCSSTextCustomizer {

	/**
     * Returns additional CSS to apply to a cell, on top of the grid's cell-styling.
     * @param record Record object for the cell. Note: If this is a new row that has not been
     * saved, in an editable grid, it has no associated record object. In this case the edit
     * values will be passed in as this parameter (see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getEditValues ListGrid.getEditValues()})
     * @param rowNum row number for the cell
     * @param colNum column number for the cell.
     *
     * @return CSS to modify styling in the cell
     */
    String getCellCSSText(ListGridRecord record, int rowNum, int colNum);
}
