/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.widgets.form.fields;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * A simple {@link com.smartgwt.client.widgets.form.fields.DateItem DateItem subclass} for editing  {@link
 * com.smartgwt.client.util.DateUtil#createDatetime regular datetime} values, where date and time elements are relevant.
 * <p> The item edits datetimes directly as text-values, formatted   according to your locale and settings such as {@link
 * com.smartgwt.client.widgets.form.fields.DateItem#getDateFormatter DateItem.dateFormatter}. <p> To edit {@link
 * com.smartgwt.client.util.DateUtil#createLogicalDate logical-Date values}, see {@link
 * com.smartgwt.client.widgets.form.fields.DateItem}, and to edit {@link
 * com.smartgwt.client.util.DateUtil#createLogicalTime logical-time values}, see {@link
 * com.smartgwt.client.widgets.form.fields.TimeItem}. For {@link com.smartgwt.client.docs.RelativeDateString relative-date
 * features}, see {@link com.smartgwt.client.widgets.form.fields.RelativeDateItem}. <P> For detailed information on working
 * with dates, times and datetimes, see the  {@link com.smartgwt.client.docs.DateFormatAndStorage Date and Time Format and
 * Storage overview}.
 */
@BeanFactory.FrameworkClass
public class DateTimeItem extends DateItem {

    public static DateTimeItem getOrCreateRef(JavaScriptObject jsObj) {
        if (jsObj == null) return null;

        final RefDataClass existingObj = RefDataClass.getRef(jsObj);

        if (existingObj instanceof DateTimeItem) {
            existingObj.setJsObj(jsObj);
            return (DateTimeItem)existingObj;
        } else

        {
            return new DateTimeItem(jsObj);
        }
    }
        


    /**
     * Changes the defaults for Canvas AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults Canvas defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.  For usage tips on this
     * param, see {@link com.smartgwt.client.docs.SGWTProperties}.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, Canvas defaults) /*-{
        if (defaults.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(DateTimeItem.@java.lang.Object::getClass()(), "changeAutoChildDefaults", "Canvas");
        }
        defaults.@com.smartgwt.client.widgets.BaseWidget::setConfigOnly(Z)(true);
        var cleanDefaultsJS = @com.smartgwt.client.util.JSOHelper::cleanProperties(Lcom/google/gwt/core/client/JavaScriptObject;Z)(defaults.@com.smartgwt.client.widgets.BaseWidget::getConfig()(), true);
        $wnd.isc.DateTimeItem.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    /**
     * Changes the defaults for FormItem AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults FormItem defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.  For usage tips on this
     * param, see {@link com.smartgwt.client.docs.SGWTProperties}.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, FormItem defaults) /*-{
        if (defaults.@com.smartgwt.client.widgets.form.fields.FormItem::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(DateTimeItem.@java.lang.Object::getClass()(), "changeAutoChildDefaults", "FormItem");
        }
        defaults.@com.smartgwt.client.widgets.form.fields.FormItem::setConfigOnly(Z)(true);
    	var cleanDefaultsJS = defaults.@com.smartgwt.client.widgets.form.fields.FormItem::getEditorTypeConfig()();
        $wnd.isc.DateTimeItem.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    public static native void changePickerIconDefaults(FormItemIcon defaults) /*-{
        $wnd.isc.DateTimeItem.changeDefaults("pickerIconDefaults", defaults.@com.smartgwt.client.core.DataClass::getJsObj()());
    }-*/;

    public DateTimeItem(){
        setType("datetime");
                	setAttribute("editorType", "DateTimeItem");
    }

    public DateTimeItem(JavaScriptObject jsObj){
        super(jsObj);
    }


    public DateTimeItem(String name) {
        setName(name);
                setType("datetime");
                	setAttribute("editorType", "DateTimeItem");
    }


    public DateTimeItem(String name, String title) {
        setName(name);
		setTitle(title);
                setType("datetime");
                	setAttribute("editorType", "DateTimeItem");
    }



    // ********************* Properties / Attributes ***********************

    /**
     * If {@link com.smartgwt.client.widgets.form.fields.DateTimeItem#getUseTextField useTextField} is true and
     * browserInputType is set to "datetime", then a native <a
     * href='http://www.w3.org/TR/html5/forms.html#local-date-and-time-state-(type=datetime-local)' target='_blank'>HTML5 local
     * datetime input</a> is used in place of a text input. <p> The use of a native HTML5 datetime input causes certain
     * features to be disabled. Input masks, the picker icon, and a custom {@link
     * com.smartgwt.client.widgets.form.DynamicForm#getDatetimeFormatter datetimeFormatter} are not supported. In-field hints
     * are currently supported in Chrome/Chromium/Opera 15 and iOS 5.0+, but future browser changes might force this support to
     * be removed. Therefore, it is safest to <em>not</em> use in-field hints (set showHintInField to false) in conjunction
     * with a native HTML5 datetime input. In-field hints are not supported in Opera 12 when using a native HTML5 datetime
     * input. If in-field hints are not supported in the browser, then showHintInField has no effect and any hint will be shown
     * to the side of the input. <p> <b>NOTES:</b> <ul>   <li>This feature requires specific CSS changes. Currently these
     * changes have been made       to the Enterprise, EnterpriseBlue, and Graphite skins only.</li>   <li>In
     * Chrome/Chromium/Opera 15 and Opera 12, native datetime inputs need to be made       wider in order to fit the full
     * datetime value within the native control. However,       on iOS 5.0+, the normal width is fine. Be sure to test the
     * layout of the form in       all browsers that you wish to support.</li> </ul>
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param browserInputType New browserInputType value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.DateTimeItem DateTimeItem} instance, for chaining setter calls
     */
    public DateTimeItem setBrowserInputType(String browserInputType) {
        return (DateTimeItem)setAttribute("browserInputType", browserInputType);
    }

    /**
     * If {@link com.smartgwt.client.widgets.form.fields.DateTimeItem#getUseTextField useTextField} is true and
     * browserInputType is set to "datetime", then a native <a
     * href='http://www.w3.org/TR/html5/forms.html#local-date-and-time-state-(type=datetime-local)' target='_blank'>HTML5 local
     * datetime input</a> is used in place of a text input. <p> The use of a native HTML5 datetime input causes certain
     * features to be disabled. Input masks, the picker icon, and a custom {@link
     * com.smartgwt.client.widgets.form.DynamicForm#getDatetimeFormatter datetimeFormatter} are not supported. In-field hints
     * are currently supported in Chrome/Chromium/Opera 15 and iOS 5.0+, but future browser changes might force this support to
     * be removed. Therefore, it is safest to <em>not</em> use in-field hints (set showHintInField to false) in conjunction
     * with a native HTML5 datetime input. In-field hints are not supported in Opera 12 when using a native HTML5 datetime
     * input. If in-field hints are not supported in the browser, then showHintInField has no effect and any hint will be shown
     * to the side of the input. <p> <b>NOTES:</b> <ul>   <li>This feature requires specific CSS changes. Currently these
     * changes have been made       to the Enterprise, EnterpriseBlue, and Graphite skins only.</li>   <li>In
     * Chrome/Chromium/Opera 15 and Opera 12, native datetime inputs need to be made       wider in order to fit the full
     * datetime value within the native control. However,       on iOS 5.0+, the normal width is fine. Be sure to test the
     * layout of the form in       all browsers that you wish to support.</li> </ul>
     *
     * @return Current browserInputType value. Default value is null
     */
    public String getBrowserInputType()  {
        return getAttributeAsString("browserInputType");
    }
    

    /**
     * This property can be used to customize the format in which datetimes are displayed.<br> Should be set to a standard
     * {@link com.smartgwt.client.types.DateDisplayFormat} or a function which will return a formatted date time string. <P> If
     * unset, the standard shortDateTime format as set up in  {@link
     * com.smartgwt.client.util.DateUtil#setShortDatetimeDisplayFormat DateUtil.setShortDatetimeDisplayFormat()} will be used.
     * <P> <B>NOTE: you may need to update the {@link com.smartgwt.client.widgets.form.fields.DateTimeItem#getInputFormat
     * inputFormat} to ensure the DateItem is able to parse user-entered date strings back into Dates</B>
     *
     * @param displayFormat New displayFormat value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.DateTimeItem DateTimeItem} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.form.fields.DateTimeItem#setInputFormat
     */
    public DateTimeItem setDisplayFormat(DateDisplayFormat displayFormat) {
        return (DateTimeItem)setAttribute("displayFormat", displayFormat == null ? null : displayFormat.getValue());
    }

    /**
     * This property can be used to customize the format in which datetimes are displayed.<br> Should be set to a standard
     * {@link com.smartgwt.client.types.DateDisplayFormat} or a function which will return a formatted date time string. <P> If
     * unset, the standard shortDateTime format as set up in  {@link
     * com.smartgwt.client.util.DateUtil#setShortDatetimeDisplayFormat DateUtil.setShortDatetimeDisplayFormat()} will be used.
     * <P> <B>NOTE: you may need to update the {@link com.smartgwt.client.widgets.form.fields.DateTimeItem#getInputFormat
     * inputFormat} to ensure the DateItem is able to parse user-entered date strings back into Dates</B>
     *
     * @return Current displayFormat value. Default value is null
     * @see com.smartgwt.client.widgets.form.fields.DateTimeItem#getInputFormat
     */
    public DateDisplayFormat getDisplayFormat()  {
        return EnumUtil.getEnum(DateDisplayFormat.values(), getAttribute("displayFormat"));
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.form.fields.DateItem#getUseTextField DateItem.useTextField} is <code>true</code>
     * this property can be used to specify the input format for date strings.  If unset, the input format will be determined
     * based on the specified {@link com.smartgwt.client.widgets.form.fields.DateItem#getDateFormatter DateItem.dateFormatter}
     * if possible (see {@link com.smartgwt.client.widgets.form.fields.DateItem#getInputFormat DateItem.getInputFormat()}),
     * otherwise picked up from the Date class (see {@link com.smartgwt.client.util.DateUtil#setInputFormat
     * DateUtil.setInputFormat()}). <P> Should be set to a standard {@link com.smartgwt.client.docs.DateInputFormat} <P> Note
     * that the {@link com.smartgwt.client.docs.DateInputFormat} property is sufficient to parse date or datetime strings
     * specified in most standard date formats. However should an entirely custom parsing function be required developers can  
     * apply a custom <code>editorValueParser</code> function. <p> This attribute does not have an effect if a native HTML5
     * date input is being used. See {@link com.smartgwt.client.widgets.form.fields.DateItem#getBrowserInputType
     * DateItem.browserInputType}.
     *
     * @param inputFormat New inputFormat value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.DateTimeItem DateTimeItem} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.DateInputFormat DateInputFormat 
     */
    public DateTimeItem setInputFormat(String inputFormat) {
        return (DateTimeItem)setAttribute("inputFormat", inputFormat);
    }

    /**
     * If {@link com.smartgwt.client.widgets.form.fields.DateItem#getUseTextField DateItem.useTextField} is <code>true</code>
     * this property can be used to specify the input format for date strings.  If unset, the input format will be determined
     * based on the specified {@link com.smartgwt.client.widgets.form.fields.DateItem#getDateFormatter DateItem.dateFormatter}
     * if possible (see {@link com.smartgwt.client.widgets.form.fields.DateItem#getInputFormat DateItem.getInputFormat()}),
     * otherwise picked up from the Date class (see {@link com.smartgwt.client.util.DateUtil#setInputFormat
     * DateUtil.setInputFormat()}). <P> Should be set to a standard {@link com.smartgwt.client.docs.DateInputFormat} <P> Note
     * that the {@link com.smartgwt.client.docs.DateInputFormat} property is sufficient to parse date or datetime strings
     * specified in most standard date formats. However should an entirely custom parsing function be required developers can  
     * apply a custom <code>editorValueParser</code> function. <p> This attribute does not have an effect if a native HTML5
     * date input is being used. See {@link com.smartgwt.client.widgets.form.fields.DateItem#getBrowserInputType
     * DateItem.browserInputType}.
     *
     * @return Current inputFormat value. Default value is null
     * @see com.smartgwt.client.docs.DateInputFormat DateInputFormat 
     */
    public String getInputFormat()  {
        return getAttributeAsString("inputFormat");
    }
    

    /**
     * This property defaults to true in DateTimeItems and cannot be altered, since editing is  via {@link
     * com.smartgwt.client.widgets.form.fields.DateTimeItem#getDisplayFormat formatted} text-entry only.
     *
     * @return Current useTextField value. Default value is true
     */
    public Boolean getUseTextField()  {
        Boolean result = getAttributeAsBoolean("useTextField", true);
        return result == null ? true : result;
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    /** 
     * Class level method to set the default properties of this class.  If set, then all
     * existing and subsequently created instances of this class will automatically have
     * default properties corresponding to
     * the properties of the class instance passed to this function.
     * This is a powerful feature that eliminates the need for users to create a separate
     * hierarchy of subclasses that only alter the default properties of this class. Can also
     * be used for skinning / styling purposes.  <P> <b>Note:</b> This method is intended for
     * setting default attributes only and will affect all instances of the underlying class
     * (including those automatically generated in JavaScript).  This method should not be used
     * to apply standard EventHandlers or override methods for a class - use a custom subclass
     * instead.  Calling this method after instances have been created can result in undefined
     * behavior, since it bypasses any setters and a class instance may have already examined 
     * a particular property and not be expecting any changes through this route.
     *
     * @param dateTimeItemProperties properties that should be used as new defaults when instances of this class are created
     * @see com.smartgwt.client.docs.SGWTProperties
     */
    public static native void setDefaultProperties(DateTimeItem dateTimeItemProperties) /*-{
        if (dateTimeItemProperties.@com.smartgwt.client.widgets.form.fields.FormItem::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Class;)(DateTimeItem.@java.lang.Object::getClass()(), "setDefaultProperties", dateTimeItemProperties.@java.lang.Object::getClass()());
        }
        dateTimeItemProperties.@com.smartgwt.client.widgets.form.fields.FormItem::setConfigOnly(Z)(true);
    	var properties = dateTimeItemProperties.@com.smartgwt.client.widgets.form.fields.FormItem::getConfig()();
        $wnd.isc.DateTimeItem.addProperties(properties);
    }-*/;

    // ***********************************************************

}
