
package com.smartgwt.client.docs;

/**
 * <h3>Grid Filtering Overview</h3>
 * This overview discusses various ways that {@link com.smartgwt.client.data.Criteria search
 * criteria} can be  applied to a {@link com.smartgwt.client.widgets.grid.ListGrid grid} to filter
 * the data being displayed.   <p> Typically, there are two types of criteria that affect how a
 * grid matches data: <ul> <li>Implicit criteria - hidden criteria, applied by the developer, to
 * the      {@link com.smartgwt.client.widgets.grid.ListGrid#getImplicitCriteria grid} or its    
 * {@link com.smartgwt.client.data.DataSource#getImplicitCriteria dataSource}, and never made
 * available to      users</li> <li>Explicit criteria - public criteria, which may be applied by
 * the developer or      entered by the user - this     criteria may be displayed to and modified
 * by the user at runtime in various ways</li> </ul> A grid may have both implicit criteria, and
 * explicit criteria that may come from multiple  sources.  When data is fetched, the
 * implicit-criteria and any sources of  {@link
 * com.smartgwt.client.widgets.grid.ListGrid#getCriteria explicit criteria} are   {@link
 * com.smartgwt.client.data.DataSource#combineCriteria combined} and used to match records. <p>
 * Note, however, that attempts to fetch with more restrictive criteria may not result in a 
 * server-trip, because {@link com.smartgwt.client.data.ResultSet}s implement local filtering
 * adaptively and may  not require a server-trip if a filter can be achieved from local caches.
 * <h4>Initial Filter Criteria</h4> You can provide an initial filter for a grid by setting 
 * {@link com.smartgwt.client.widgets.grid.ListGrid#getImplicitCriteria implicit criteria}, which
 * is never shown to the user, or {@link
 * com.smartgwt.client.widgets.grid.ListGrid#getInitialCriteria initial criteria}, which may be
 * shown for editing in the  grid's builtin {@link
 * com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filter-row}.  You can also
 * provide both  types, if only some parts of the criteria should be public.   <h4>Filter Row
 * Criteria</h4> Grids provide a {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterEditor
 * filter-row} that allows users to apply search-values on a per-field basis.  When {@link
 * com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterOperators
 * ListGrid.allowFilterOperators} is true, the default, users can modify the {@link
 * com.smartgwt.client.data.Operator search operator} assigned to a given field via the grid's
 * {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderContextMenu header context-menu},
 * allowing  for more complex matching.  If the selected operator is not the field's {@link
 * com.smartgwt.client.widgets.grid.ListGridField#getFilterOperator default operator}, or if 
 * {@link com.smartgwt.client.widgets.grid.ListGrid#getAlwaysShowOperatorIcon
 * ListGrid.alwaysShowOperatorIcon} is true, the current operator is indicated in a small icon in
 * each filter-field.  <p> Developers can interact with a field's search operator with  {@link
 * com.smartgwt.client.widgets.grid.ListGrid#getFieldSearchOperator
 * ListGrid.getFieldSearchOperator()}, {@link
 * com.smartgwt.client.widgets.grid.ListGrid#setFieldSearchOperator
 * ListGrid.setFieldSearchOperator()} and {@link
 * com.smartgwt.client.widgets.grid.ListGrid#clearFieldSearchOperator
 * ListGrid.clearFieldSearchOperator()}. <p> Criteria in the filter-row reflects current public
 * criteria that  {@link com.smartgwt.client.widgets.form.fields.FormItem#canEditCriterion can be
 * edited}.  Developers can retrieve this criteria with {@link
 * com.smartgwt.client.widgets.grid.ListGrid#getFilterEditorCriteria
 * ListGrid.getFilterEditorCriteria()} and set it with  {@link
 * com.smartgwt.client.widgets.grid.ListGrid#setFilterEditorCriteria
 * ListGrid.setFilterEditorCriteria()}.  When the filter-row is showing, Calls to APIs such  as
 * {@link com.smartgwt.client.widgets.grid.ListGrid#setCriteria ListGrid.setCriteria()} or {@link
 * com.smartgwt.client.widgets.grid.ListGrid#fetchData ListGrid.fetchData()} will apply criteria
 * to the  filter-row, if the editors there allow it.  Any criteria applied by these methods, that
 * cannot be edited by the associated field's filter-editor, are  still applied to fetches and
 * will be  returned by calls to {@link com.smartgwt.client.widgets.grid.ListGrid#getCriteria
 * ListGrid.getCriteria()} or  {@link
 * com.smartgwt.client.widgets.grid.ListGrid#getFilterEditorCriteria
 * ListGrid.getFilterEditorCriteria()}, but are not shown to the user for editing.  <p> Developers
 * may specify a field's {@link com.smartgwt.client.widgets.grid.ListGridField#getFilterEditorType
 * filterEditor-type}, and this can be a custom {@link
 * com.smartgwt.client.widgets.form.fields.FormItem} class that uses  {@link
 * com.smartgwt.client.widgets.form.fields.FormItem#getCriterion getCriterion()},  {@link
 * com.smartgwt.client.widgets.form.fields.FormItem#setCriterion setCriterion()} and  {@link
 * com.smartgwt.client.widgets.form.fields.FormItem#canEditCriterion canEditCriterion()} to manage
 * the criteria it works with. <p> For more complicated cases or more control, developers can
 * implement  {@link com.smartgwt.client.widgets.grid.ListGrid#addFilterEditorSubmitHandler
 * ListGrid.filterEditorSubmit()}. <p> Criteria from the filter-row is combined with other sources
 * of criteria when data is fetched.  <h4>External Criteria</h4> If you have external logic, or a
 * {@link com.smartgwt.client.widgets.form.SearchForm form} outside of the grid, that  produces
 * criteria, you can apply the criteria by passing it to  {@link
 * com.smartgwt.client.widgets.grid.ListGrid#fetchData fetchData} or  {@link
 * com.smartgwt.client.widgets.grid.ListGrid#filterData filterData}.  The  primary difference
 * between these two APIs is that <code>filterData</code> applies a  {@link
 * com.smartgwt.client.data.DSRequest#getTextMatchStyle DSRequest.textMatchStyle} of
 * <i>substring</i>, so that records are matched by  case-insensitive substring comparison. <p> If
 * you have the <code>FilterEditor</code> showing, these external criteria will be appear in the
 * filterEditor, where supported.  Developers can apply additional external criteria  without that
 * effect by passing them to {@link
 * com.smartgwt.client.widgets.DataBoundComponent#setImplicitCriteria
 * DataBoundComponent.setImplicitCriteria()}, or by setting {@link
 * com.smartgwt.client.widgets.grid.ListGrid#getSearchForm ListGrid.searchForm} to  the external
 * criteria form.  <p> If you need more power or variance than the filter-row provides, you can
 * set  {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterWindow
 * ListGrid.allowFilterWindow} to show a full-blown {@link
 * com.smartgwt.client.widgets.form.FilterBuilder}, to  construct more complex criteria that can
 * also include logical operators like <i>or</i>. <p> All sources of criteria are combined to
 * match records when data is fetched.   <h4>Saving Criteria</h4> Grid criteria can be saved and
 * restored with {@link com.smartgwt.client.widgets.grid.ListGrid#getViewState view-state} and 
 * via the {@link com.smartgwt.client.data.SavedSearches} feature, which is turned on by default.
 */
public interface GridFiltering {
}
