/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.TableColElement;
import com.google.gwt.dom.client.TableElement;
import com.google.gwt.dom.client.TableSectionElement;
import com.google.gwt.event.dom.client.ScrollEvent;
import com.google.gwt.event.dom.client.ScrollHandler;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.LoadingStateChangeEvent;
import com.google.gwt.user.client.ui.CustomScrollPanel;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HeaderPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ProvidesKey;

public class DataGrid<T>
extends AbstractCellTable<T>
implements RequiresResize {
    private static final int DEFAULT_PAGESIZE = 50;
    private static Resources DEFAULT_RESOURCES;
    final TableWidget tableData;
    final TableWidget tableFooter;
    final TableWidget tableHeader;
    private final FlexTable emptyTableWidgetContainer;
    private final HeaderPanel headerPanel = (HeaderPanel)this.getWidget();
    private final FlexTable loadingIndicatorContainer;
    private final Style style;
    private final Element tableDataContainer;
    private final ScrollPanel tableDataScroller;
    private final SimplePanel tableFooterContainer;
    private final Element tableFooterScroller;
    private final SimplePanel tableHeaderContainer;
    private final Element tableHeaderScroller;

    private static Widget createDefaultLoadingIndicator(Resources resources) {
        ImageResource loadingImg = resources.dataGridLoading();
        if (loadingImg == null) {
            return null;
        }
        Image image = new Image(loadingImg);
        image.getElement().getStyle().setMarginTop(30.0, Style.Unit.PX);
        return image;
    }

    private static Resources getDefaultResources() {
        if (DEFAULT_RESOURCES == null) {
            DEFAULT_RESOURCES = (Resources)GWT.create(Resources.class);
        }
        return DEFAULT_RESOURCES;
    }

    public DataGrid() {
        this(50);
    }

    public DataGrid(int pageSize) {
        this(pageSize, DataGrid.getDefaultResources());
    }

    public DataGrid(int pageSize, ProvidesKey<T> keyProvider) {
        this(pageSize, DataGrid.getDefaultResources(), keyProvider);
    }

    public DataGrid(int pageSize, Resources resources) {
        this(pageSize, resources, null);
    }

    public DataGrid(int pageSize, Resources resources, ProvidesKey<T> keyProvider) {
        this(pageSize, resources, keyProvider, DataGrid.createDefaultLoadingIndicator(resources));
    }

    public DataGrid(int pageSize, Resources resources, ProvidesKey<T> keyProvider, Widget loadingIndicator) {
        super(new HeaderPanel(), pageSize, (AbstractCellTable.Resources)new ResourcesAdapter(resources), keyProvider);
        this.style = resources.dataGridStyle();
        this.style.ensureInjected();
        this.tableHeader = new TableWidget();
        this.tableHeader.section = this.tableHeader.tableElem.createTHead();
        this.tableFooter = new TableWidget();
        this.tableFooter.section = this.tableFooter.tableElem.createTFoot();
        this.tableHeaderContainer = new SimplePanel(this.tableHeader);
        this.tableFooterContainer = new SimplePanel(this.tableFooter);
        this.headerPanel.setHeaderWidget(this.tableHeaderContainer);
        this.tableHeaderScroller = this.tableHeaderContainer.getElement().getParentElement();
        this.headerPanel.setFooterWidget(this.tableFooterContainer);
        this.tableFooterScroller = this.tableFooterContainer.getElement().getParentElement();
        this.tableHeaderScroller.getStyle().setOverflow(Style.Overflow.HIDDEN);
        this.tableFooterScroller.getStyle().setOverflow(Style.Overflow.HIDDEN);
        this.tableData = new TableWidget();
        if (this.tableData.tableElem.getTBodies().getLength() > 0) {
            this.tableData.section = this.tableData.tableElem.getTBodies().getItem(0);
        } else {
            this.tableData.section = Document.get().createTBodyElement();
            this.tableData.tableElem.appendChild(this.tableData.section);
        }
        this.tableDataScroller = new CustomScrollPanel(this.tableData);
        this.tableDataScroller.setHeight("100%");
        this.headerPanel.setContentWidget(this.tableDataScroller);
        this.tableDataContainer = this.tableData.getElement().getParentElement();
        this.tableDataContainer.getStyle().setDisplay(Style.Display.BLOCK);
        this.emptyTableWidgetContainer = new FlexTable();
        this.emptyTableWidgetContainer.getElement().setAttribute("align", "center");
        this.loadingIndicatorContainer = new FlexTable();
        this.loadingIndicatorContainer.getElement().setAttribute("align", "center");
        this.setLoadingIndicator(loadingIndicator);
        this.tableDataScroller.addScrollHandler(new ScrollHandler(){

            @Override
            public void onScroll(ScrollEvent event) {
                int scrollLeft = DataGrid.this.tableDataScroller.getHorizontalScrollPosition();
                DataGrid.this.tableHeaderScroller.setScrollLeft(scrollLeft);
                DataGrid.this.tableFooterScroller.setScrollLeft(scrollLeft);
            }
        });
    }

    public DataGrid(ProvidesKey<T> keyProvider) {
        this(50, keyProvider);
    }

    @Override
    public void addColumnStyleName(int index, String styleName) {
        this.tableHeader.addColumnStyleName(index, styleName);
        this.tableFooter.addColumnStyleName(index, styleName);
        this.tableData.addColumnStyleName(index, styleName);
    }

    public void clearTableWidth() {
        this.tableHeaderContainer.getElement().getStyle().clearWidth();
        this.tableFooterContainer.getElement().getStyle().clearWidth();
        this.tableDataContainer.getStyle().clearWidth();
    }

    @Override
    public void onResize() {
        this.headerPanel.onResize();
    }

    @Override
    public void removeColumnStyleName(int index, String styleName) {
        this.tableHeader.removeColumnStyleName(index, styleName);
        this.tableFooter.removeColumnStyleName(index, styleName);
        this.tableData.removeColumnStyleName(index, styleName);
    }

    public void setAlwaysShowScrollBars(boolean alwaysShowScrollBars) {
        this.tableDataScroller.setAlwaysShowScrollBars(alwaysShowScrollBars);
    }

    @Override
    public void setEmptyTableWidget(Widget widget) {
        this.emptyTableWidgetContainer.setWidget(0, 0, widget);
        super.setEmptyTableWidget(widget);
    }

    @Override
    public void setLoadingIndicator(Widget widget) {
        this.loadingIndicatorContainer.setWidget(0, 0, widget);
        super.setLoadingIndicator(widget);
    }

    public void setMinimumTableWidth(double value, Style.Unit unit) {
        this.tableHeaderContainer.getElement().getStyle().setProperty("minWidth", value, unit);
        this.tableFooterContainer.getElement().getStyle().setProperty("minWidth", value, unit);
        this.tableDataContainer.getStyle().setProperty("minWidth", value, unit);
    }

    public void setTableWidth(double value, Style.Unit unit) {
        this.tableHeaderContainer.getElement().getStyle().setWidth(value, unit);
        this.tableFooterContainer.getElement().getStyle().setWidth(value, unit);
        this.tableDataContainer.getStyle().setWidth(value, unit);
    }

    @Override
    protected void doSetColumnWidth(int column, String width) {
        if (width == null) {
            this.tableData.ensureTableColElement(column).getStyle().clearWidth();
            this.tableHeader.ensureTableColElement(column).getStyle().clearWidth();
            this.tableFooter.ensureTableColElement(column).getStyle().clearWidth();
        } else {
            this.tableData.ensureTableColElement(column).getStyle().setProperty("width", width);
            this.tableHeader.ensureTableColElement(column).getStyle().setProperty("width", width);
            this.tableFooter.ensureTableColElement(column).getStyle().setProperty("width", width);
        }
    }

    @Override
    protected void doSetHeaderVisible(boolean isFooter, boolean isVisible) {
        if (isFooter) {
            this.headerPanel.setFooterWidget(isVisible ? this.tableFooterContainer : null);
        } else {
            this.headerPanel.setHeaderWidget(isVisible ? this.tableHeaderContainer : null);
        }
    }

    @Override
    protected TableSectionElement getTableBodyElement() {
        return this.tableData.section;
    }

    @Override
    protected TableSectionElement getTableFootElement() {
        return this.tableFooter.section;
    }

    @Override
    protected TableSectionElement getTableHeadElement() {
        return this.tableHeader.section;
    }

    @Override
    protected void onLoadingStateChanged(LoadingStateChangeEvent.LoadingState state) {
        Widget message = this.tableData;
        if (state == LoadingStateChangeEvent.LoadingState.LOADING) {
            message = this.loadingIndicatorContainer;
        } else if (state == LoadingStateChangeEvent.LoadingState.LOADED && this.getPresenter().isEmpty()) {
            message = this.emptyTableWidgetContainer;
        }
        this.tableDataScroller.setWidget(message);
        super.onLoadingStateChanged(state);
    }

    @Override
    protected void refreshColumnWidths() {
        super.refreshColumnWidths();
        int columnCount = this.getRealColumnCount();
        this.tableHeader.hideUnusedColumns(columnCount);
        this.tableData.hideUnusedColumns(columnCount);
        this.tableFooter.hideUnusedColumns(columnCount);
    }

    public static interface Resources
    extends ClientBundle {
        @ClientBundle.Source(value={"cellTableLoading.gif"})
        @ImageResource.ImageOptions(flipRtl=true)
        public ImageResource dataGridLoading();

        @ClientBundle.Source(value={"sortAscending.png"})
        @ImageResource.ImageOptions(flipRtl=true)
        public ImageResource dataGridSortAscending();

        @ClientBundle.Source(value={"sortDescending.png"})
        @ImageResource.ImageOptions(flipRtl=true)
        public ImageResource dataGridSortDescending();

        @ClientBundle.Source(value={"com/google/gwt/user/cellview/client/DataGrid.css"})
        public Style dataGridStyle();
    }

    private static class ResourcesAdapter
    implements AbstractCellTable.Resources {
        private final Resources resources;
        private final StyleAdapter style;

        public ResourcesAdapter(Resources resources) {
            this.resources = resources;
            this.style = new StyleAdapter(resources.dataGridStyle());
        }

        @Override
        public ImageResource sortAscending() {
            return this.resources.dataGridSortAscending();
        }

        @Override
        public ImageResource sortDescending() {
            return this.resources.dataGridSortDescending();
        }

        @Override
        public AbstractCellTable.Style style() {
            return this.style;
        }
    }

    @CssResource.ImportedWithPrefix(value="gwt-CellTable")
    public static interface Style
    extends CssResource {
        public static final String DEFAULT_CSS = "com/google/gwt/user/cellview/client/DataGrid.css";

        public String dataGridCell();

        public String dataGridEvenRow();

        public String dataGridEvenRowCell();

        public String dataGridFirstColumn();

        public String dataGridFirstColumnFooter();

        public String dataGridFirstColumnHeader();

        public String dataGridFooter();

        public String dataGridHeader();

        public String dataGridHoveredRow();

        public String dataGridHoveredRowCell();

        public String dataGridKeyboardSelectedCell();

        public String dataGridKeyboardSelectedRow();

        public String dataGridKeyboardSelectedRowCell();

        public String dataGridLastColumn();

        public String dataGridLastColumnFooter();

        public String dataGridLastColumnHeader();

        public String dataGridOddRow();

        public String dataGridOddRowCell();

        public String dataGridSelectedRow();

        public String dataGridSelectedRowCell();

        public String dataGridSortableHeader();

        public String dataGridSortedHeaderAscending();

        public String dataGridSortedHeaderDescending();

        public String dataGridWidget();
    }

    static class TableWidget
    extends Widget {
        private final TableColElement colgroup;
        private TableSectionElement section;
        private final TableElement tableElem = Document.get().createTableElement();

        public TableWidget() {
            this.tableElem.setCellSpacing(0);
            this.tableElem.getStyle().setTableLayout(Style.TableLayout.FIXED);
            this.tableElem.getStyle().setWidth(100.0, Style.Unit.PCT);
            this.setElement(this.tableElem);
            this.colgroup = Document.get().createColGroupElement();
            this.tableElem.appendChild(this.colgroup);
        }

        public void addColumnStyleName(int index, String styleName) {
            this.ensureTableColElement(index).addClassName(styleName);
        }

        public TableColElement ensureTableColElement(int index) {
            for (int i = this.colgroup.getChildCount(); i <= index; ++i) {
                this.colgroup.appendChild(Document.get().createColElement());
            }
            return (TableColElement)this.colgroup.getChild(index).cast();
        }

        public void removeColumnStyleName(int index, String styleName) {
            if (index >= this.colgroup.getChildCount()) {
                return;
            }
            this.ensureTableColElement(index).removeClassName(styleName);
        }

        void hideUnusedColumns(int start) {
            int colCount = this.colgroup.getChildCount();
            for (int i = start; i < colCount; ++i) {
                this.setColumnWidth(i, "0px");
            }
        }

        void setColumnWidth(int column, String width) {
            if (width == null) {
                this.ensureTableColElement(column).getStyle().clearWidth();
            } else {
                this.ensureTableColElement(column).getStyle().setProperty("width", width);
            }
        }
    }

    private static class StyleAdapter
    implements AbstractCellTable.Style {
        private final Style style;

        public StyleAdapter(Style style) {
            this.style = style;
        }

        @Override
        public String cell() {
            return this.style.dataGridCell();
        }

        @Override
        public String evenRow() {
            return this.style.dataGridEvenRow();
        }

        @Override
        public String evenRowCell() {
            return this.style.dataGridEvenRowCell();
        }

        @Override
        public String firstColumn() {
            return this.style.dataGridFirstColumn();
        }

        @Override
        public String firstColumnFooter() {
            return this.style.dataGridFirstColumnFooter();
        }

        @Override
        public String firstColumnHeader() {
            return this.style.dataGridFirstColumnHeader();
        }

        @Override
        public String footer() {
            return this.style.dataGridFooter();
        }

        @Override
        public String header() {
            return this.style.dataGridHeader();
        }

        @Override
        public String hoveredRow() {
            return this.style.dataGridHoveredRow();
        }

        @Override
        public String hoveredRowCell() {
            return this.style.dataGridHoveredRowCell();
        }

        @Override
        public String keyboardSelectedCell() {
            return this.style.dataGridKeyboardSelectedCell();
        }

        @Override
        public String keyboardSelectedRow() {
            return this.style.dataGridKeyboardSelectedRow();
        }

        @Override
        public String keyboardSelectedRowCell() {
            return this.style.dataGridKeyboardSelectedRowCell();
        }

        @Override
        public String lastColumn() {
            return this.style.dataGridLastColumn();
        }

        @Override
        public String lastColumnFooter() {
            return this.style.dataGridLastColumnFooter();
        }

        @Override
        public String lastColumnHeader() {
            return this.style.dataGridLastColumnHeader();
        }

        @Override
        public String oddRow() {
            return this.style.dataGridOddRow();
        }

        @Override
        public String oddRowCell() {
            return this.style.dataGridOddRowCell();
        }

        @Override
        public String selectedRow() {
            return this.style.dataGridSelectedRow();
        }

        @Override
        public String selectedRowCell() {
            return this.style.dataGridSelectedRowCell();
        }

        @Override
        public String sortableHeader() {
            return this.style.dataGridSortableHeader();
        }

        @Override
        public String sortedHeaderAscending() {
            return this.style.dataGridSortedHeaderAscending();
        }

        @Override
        public String sortedHeaderDescending() {
            return this.style.dataGridSortedHeaderDescending();
        }

        @Override
        public String widget() {
            return this.style.dataGridWidget();
        }
    }
}

