/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import jakarta.persistence.criteria.Expression;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.hibernate.QueryException;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.UnknownPathException;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.type.descriptor.java.JavaType;

public class SqmFieldLiteral<T>
implements SqmExpression<T>,
SqmExpressible<T>,
SqmSelectableNode<T>,
SemanticPathPart {
    private final T value;
    private final JavaType<T> fieldJavaType;
    private final String fieldName;
    private final NodeBuilder nodeBuilder;
    private SqmExpressible<T> expressible;

    public SqmFieldLiteral(Field field, JavaType<T> fieldJavaType, NodeBuilder nodeBuilder) {
        this(SqmFieldLiteral.extractValue(field), fieldJavaType, field.getName(), nodeBuilder);
    }

    public SqmFieldLiteral(T value, JavaType<T> fieldJavaType, String fieldName, NodeBuilder nodeBuilder) {
        this.value = value;
        this.fieldJavaType = fieldJavaType;
        this.fieldName = fieldName;
        this.nodeBuilder = nodeBuilder;
        this.expressible = this;
    }

    private static <T> T extractValue(Field field) {
        try {
            return (T)field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new QueryException("Could not access Field value for SqmFieldLiteral", e);
        }
    }

    @Override
    public SqmFieldLiteral<T> copy(SqmCopyContext context) {
        SqmFieldLiteral existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        return context.registerCopy(this, new SqmFieldLiteral<T>(this.value, this.fieldJavaType, this.fieldName, this.nodeBuilder()));
    }

    public T getValue() {
        return this.value;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public NodeBuilder getNodeBuilder() {
        return this.nodeBuilder;
    }

    @Override
    public SqmExpressible<T> getNodeType() {
        return this.expressible;
    }

    @Override
    public void applyInferableType(SqmExpressible<?> type) {
    }

    @Override
    public JavaType<T> getExpressibleJavaType() {
        if (this.expressible == this) {
            return this.fieldJavaType;
        }
        return this.expressible.getExpressibleJavaType();
    }

    @Override
    public JavaType<T> getJavaTypeDescriptor() {
        return this.getExpressibleJavaType();
    }

    @Override
    public Class<T> getBindableJavaType() {
        return this.getJavaTypeDescriptor().getJavaTypeClass();
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitFieldLiteral(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        SqmLiteral.appendHqlString(sb, this.getJavaTypeDescriptor(), this.getValue());
    }

    @Override
    public NodeBuilder nodeBuilder() {
        return this.nodeBuilder;
    }

    @Override
    public SqmPredicate isNull() {
        return this.nodeBuilder().isNull(this);
    }

    @Override
    public SqmPredicate equalTo(Expression<T> that) {
        return this.nodeBuilder().equal((Expression)this, (Expression)that);
    }

    @Override
    public SqmPredicate equalTo(T that) {
        return this.nodeBuilder().equal((Expression)this, (Object)that);
    }

    @Override
    public SqmPredicate isNotNull() {
        return this.nodeBuilder().isNotNull(this);
    }

    @Override
    public SqmPredicate in(Object ... values) {
        return this.nodeBuilder().in((Expression)this, values);
    }

    @Override
    public SqmPredicate in(Expression<?> ... values) {
        return this.nodeBuilder().in((Expression)this, (Expression[])values);
    }

    @Override
    public SqmPredicate in(Collection<?> values) {
        return this.nodeBuilder().in((Expression)this, new Object[]{values});
    }

    @Override
    public SqmPredicate in(Expression<Collection<?>> values) {
        return this.nodeBuilder().in((Expression)this, new Expression[]{values});
    }

    @Override
    public SqmExpression<Long> asLong() {
        return this;
    }

    @Override
    public SqmExpression<Integer> asInteger() {
        return this;
    }

    @Override
    public SqmExpression<Float> asFloat() {
        return this;
    }

    @Override
    public SqmExpression<Double> asDouble() {
        return this;
    }

    @Override
    public SqmExpression<BigDecimal> asBigDecimal() {
        return this;
    }

    @Override
    public SqmExpression<BigInteger> asBigInteger() {
        return this;
    }

    @Override
    public SqmExpression<String> asString() {
        return this;
    }

    @Override
    public <X> SqmExpression<X> as(Class<X> type) {
        return null;
    }

    @Override
    public SemanticPathPart resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        throw new UnknownPathException(String.format(Locale.ROOT, "Static field reference [%s#%s] cannot be de-referenced", this.fieldJavaType.getTypeName(), this.fieldName));
    }

    @Override
    public SqmPath<?> resolveIndexedAccess(SqmExpression<?> selector, boolean isTerminal, SqmCreationState creationState) {
        throw new UnknownPathException(String.format(Locale.ROOT, "Static field reference [%s#%s] cannot be de-referenced", this.fieldJavaType.getTypeName(), this.fieldName));
    }

    public boolean isCompoundSelection() {
        return false;
    }

    @Override
    public List<? extends JpaSelection<?>> getSelectionItems() {
        throw new IllegalStateException("Not a compound selection");
    }

    @Override
    public JpaSelection<T> alias(String name) {
        return null;
    }

    public String getAlias() {
        return null;
    }

    @Override
    public DomainType<T> getSqmType() {
        return null;
    }
}

