/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import java.util.List;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.LockMode;
import org.hibernate.collection.spi.PersistentBag;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.collection.spi.PersistentIdentifierBag;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.collection.internal.AbstractImmediateCollectionInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class BagInitializer
extends AbstractImmediateCollectionInitializer {
    private static final String CONCRETE_NAME = BagInitializer.class.getSimpleName();
    private final DomainResultAssembler<?> elementAssembler;
    private final DomainResultAssembler<?> collectionIdAssembler;

    public BagInitializer(PluralAttributeMapping bagDescriptor, FetchParentAccess parentAccess, NavigablePath navigablePath, LockMode lockMode, DomainResult<?> collectionKeyResult, DomainResult<?> collectionValueKeyResult, Fetch elementFetch, @Nullable Fetch collectionIdFetch, boolean isResultInitializer, AssemblerCreationState creationState) {
        super(navigablePath, bagDescriptor, parentAccess, lockMode, collectionKeyResult, collectionValueKeyResult, isResultInitializer, creationState);
        this.elementAssembler = elementFetch.createAssembler(this, creationState);
        this.collectionIdAssembler = collectionIdFetch == null ? null : collectionIdFetch.createAssembler(this, creationState);
    }

    @Override
    protected String getSimpleConcreteImplName() {
        return CONCRETE_NAME;
    }

    @Override
    protected void forEachAssembler(Consumer<DomainResultAssembler<?>> consumer) {
        consumer.accept(this.elementAssembler);
    }

    @Override
    protected void readCollectionRow(CollectionKey collectionKey, List<Object> loadingState, RowProcessingState rowProcessingState) {
        if (this.collectionIdAssembler != null) {
            Object collectionId = this.collectionIdAssembler.assemble(rowProcessingState);
            if (collectionId == null) {
                return;
            }
            Object element = this.elementAssembler.assemble(rowProcessingState);
            if (element == null) {
                return;
            }
            loadingState.add(new Object[]{collectionId, element});
        } else {
            Object element = this.elementAssembler.assemble(rowProcessingState);
            if (element != null) {
                loadingState.add(element);
            }
        }
    }

    @Override
    protected void initializeSubInstancesFromParent(RowProcessingState rowProcessingState) {
        block5: {
            Initializer initializer = this.elementAssembler.getInitializer();
            if (initializer == null) break block5;
            PersistentCollection<?> persistentCollection = this.getCollectionInstance();
            assert (persistentCollection != null);
            if (persistentCollection instanceof PersistentBag) {
                for (Object element : (PersistentBag)persistentCollection) {
                    initializer.initializeInstanceFromParent(element, rowProcessingState);
                }
            } else {
                for (Object element : (PersistentIdentifierBag)persistentCollection) {
                    initializer.initializeInstanceFromParent(element, rowProcessingState);
                }
            }
        }
    }

    public String toString() {
        return "BagInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }
}

