/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.view.client;

import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.Range;
import com.google.gwt.view.client.RangeChangeEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractDataProvider<T>
implements ProvidesKey<T> {
    private Set<HasData<T>> displays = new HashSet<HasData<T>>();
    private final ProvidesKey<T> keyProvider;
    private int lastRowCount = -1;
    private boolean lastRowCountExact;
    private Map<HasData<T>, HandlerRegistration> rangeChangeHandlers = new HashMap<HasData<T>, HandlerRegistration>();

    protected AbstractDataProvider() {
        this.keyProvider = null;
    }

    protected AbstractDataProvider(ProvidesKey<T> keyProvider) {
        this.keyProvider = keyProvider;
    }

    public void addDataDisplay(final HasData<T> display) {
        if (display == null) {
            throw new IllegalArgumentException("display cannot be null");
        }
        if (this.displays.contains(display)) {
            throw new IllegalStateException("The specified display has already been added to this adapter.");
        }
        this.displays.add(display);
        HandlerRegistration handler = display.addRangeChangeHandler(new RangeChangeEvent.Handler(){
            final /* synthetic */ AbstractDataProvider this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onRangeChange(RangeChangeEvent event) {
                this.this$0.onRangeChanged(display);
            }
        });
        this.rangeChangeHandlers.put(display, handler);
        if (this.lastRowCount >= 0) {
            display.setRowCount(this.lastRowCount, this.lastRowCountExact);
        }
        this.onRangeChanged(display);
    }

    public Set<HasData<T>> getDataDisplays() {
        return Collections.unmodifiableSet(this.displays);
    }

    @Override
    public Object getKey(T item) {
        return this.keyProvider == null ? item : this.keyProvider.getKey(item);
    }

    public ProvidesKey<T> getKeyProvider() {
        return this.keyProvider;
    }

    public Range[] getRanges() {
        Range[] ranges = new Range[this.displays.size()];
        int i = 0;
        for (HasData<T> display : this.displays) {
            ranges[i++] = display.getVisibleRange();
        }
        return ranges;
    }

    public void removeDataDisplay(HasData<T> display) {
        if (!this.displays.contains(display)) {
            throw new IllegalStateException("HasData not present");
        }
        this.displays.remove(display);
        HandlerRegistration handler = this.rangeChangeHandlers.remove(display);
        handler.removeHandler();
    }

    protected abstract void onRangeChanged(HasData<T> var1);

    protected void updateRowCount(int count, boolean exact) {
        this.lastRowCount = count;
        this.lastRowCountExact = exact;
        for (HasData<T> display : this.displays) {
            display.setRowCount(count, exact);
        }
    }

    protected void updateRowData(int start, List<T> values) {
        for (HasData<T> display : this.displays) {
            this.updateRowData(display, start, values);
        }
    }

    protected void updateRowData(HasData<T> display, int start, List<T> values) {
        int end = start + values.size();
        Range range = display.getVisibleRange();
        int curStart = range.getStart();
        int curLength = range.getLength();
        int curEnd = curStart + curLength;
        if (start == curStart || curStart < end && curEnd > start) {
            int realStart = curStart < start ? start : curStart;
            int realEnd = curEnd > end ? end : curEnd;
            int realLength = realEnd - realStart;
            List<T> realValues = values.subList(realStart - start, realStart - start + realLength);
            display.setRowData(realStart, realValues);
        }
    }
}

