/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Internal;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.ContributableDatabaseObject;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.relational.QualifiedTableName;
import org.hibernate.boot.model.relational.QualifiedTypeName;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.Column;

public class UserDefinedType
implements Serializable,
ContributableDatabaseObject {
    private final String contributor;
    private Identifier catalog;
    private Identifier schema;
    private Identifier name;
    private final Map<String, Column> columns = new LinkedHashMap<String, Column>();
    private int[] orderMapping;
    private String comment;

    public UserDefinedType(String contributor, Namespace namespace, Identifier physicalTypeName) {
        this.contributor = contributor;
        this.catalog = namespace.getPhysicalName().getCatalog();
        this.schema = namespace.getPhysicalName().getSchema();
        this.name = physicalTypeName;
    }

    @Override
    public String getContributor() {
        return this.contributor;
    }

    public String getQualifiedName(SqlStringGenerationContext context) {
        return context.format(new QualifiedTypeName(this.catalog, this.schema, this.name));
    }

    public void setName(String name) {
        this.name = Identifier.toIdentifier(name);
    }

    public String getName() {
        return this.name == null ? null : this.name.getText();
    }

    public Identifier getNameIdentifier() {
        return this.name;
    }

    public String getQuotedName() {
        return this.name == null ? null : this.name.toString();
    }

    public String getQuotedName(Dialect dialect) {
        return this.name == null ? null : this.name.render(dialect);
    }

    public QualifiedTableName getQualifiedTableName() {
        return this.name == null ? null : new QualifiedTableName(this.catalog, this.schema, this.name);
    }

    public boolean isQuoted() {
        return this.name.isQuoted();
    }

    public void setQuoted(boolean quoted) {
        if (quoted == this.name.isQuoted()) {
            return;
        }
        this.name = new Identifier(this.name.getText(), quoted);
    }

    public void setSchema(String schema) {
        this.schema = Identifier.toIdentifier(schema);
    }

    public String getSchema() {
        return this.schema == null ? null : this.schema.getText();
    }

    public String getQuotedSchema() {
        return this.schema == null ? null : this.schema.toString();
    }

    public String getQuotedSchema(Dialect dialect) {
        return this.schema == null ? null : this.schema.render(dialect);
    }

    public boolean isSchemaQuoted() {
        return this.schema != null && this.schema.isQuoted();
    }

    public void setCatalog(String catalog) {
        this.catalog = Identifier.toIdentifier(catalog);
    }

    public String getCatalog() {
        return this.catalog == null ? null : this.catalog.getText();
    }

    public String getQuotedCatalog() {
        return this.catalog == null ? null : this.catalog.render();
    }

    public String getQuotedCatalog(Dialect dialect) {
        return this.catalog == null ? null : this.catalog.render(dialect);
    }

    public boolean isCatalogQuoted() {
        return this.catalog != null && this.catalog.isQuoted();
    }

    public Column getColumn(Column column) {
        if (column == null) {
            return null;
        }
        Column existing = this.columns.get(column.getCanonicalName());
        return column.equals(existing) ? existing : null;
    }

    public Column getColumn(Identifier name) {
        if (name == null) {
            return null;
        }
        return this.columns.get(name.getCanonicalName());
    }

    public Column getColumn(int n) {
        Iterator<Column> iter = this.columns.values().iterator();
        for (int i = 0; i < n - 1; ++i) {
            iter.next();
        }
        return iter.next();
    }

    public void addColumn(Column column) {
        Column old = this.getColumn(column);
        if (old == null) {
            this.columns.put(column.getCanonicalName(), column);
            column.uniqueInteger = this.columns.size();
        } else {
            column.uniqueInteger = old.uniqueInteger;
        }
    }

    public int getColumnSpan() {
        return this.columns.size();
    }

    public Collection<Column> getColumns() {
        return this.columns.values();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.catalog == null ? 0 : this.catalog.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        return object instanceof UserDefinedType && this.equals((UserDefinedType)object);
    }

    public boolean equals(UserDefinedType table) {
        if (null == table) {
            return false;
        }
        if (this == table) {
            return true;
        }
        return Identifier.areEqual(this.name, table.name) && Identifier.areEqual(this.schema, table.schema) && Identifier.areEqual(this.catalog, table.catalog);
    }

    public boolean containsColumn(Column column) {
        return this.columns.containsValue(column);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append(this.getClass().getSimpleName()).append('(');
        if (this.getCatalog() != null) {
            buf.append(this.getCatalog()).append(".");
        }
        if (this.getSchema() != null) {
            buf.append(this.getSchema()).append(".");
        }
        buf.append(this.getName()).append(')');
        return buf.toString();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public String getExportIdentifier() {
        StringBuilder qualifiedName = new StringBuilder();
        if (this.catalog != null) {
            qualifiedName.append(this.catalog.render()).append('.');
        }
        if (this.schema != null) {
            qualifiedName.append(this.schema.render()).append('.');
        }
        return qualifiedName.append(this.name.render()).toString();
    }

    @Internal
    public void reorderColumns(List<Column> columns) {
        if (this.orderMapping != null) {
            return;
        }
        this.orderMapping = new int[columns.size()];
        int i = 0;
        for (Column column : this.columns.values()) {
            this.orderMapping[columns.indexOf((Object)column)] = i++;
        }
        this.columns.clear();
        for (Column column : columns) {
            this.columns.put(column.getCanonicalName(), column);
        }
    }

    @Internal
    public int[] getOrderMapping() {
        return this.orderMapping;
    }
}

