/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.debugging.sourcemap;

import com.google.gwt.thirdparty.debugging.sourcemap.SourceMapSection;
import java.util.List;
import java.util.Map;

public class SourceMapObject {
    private final int version;
    private final int lineCount;
    private final String sourceRoot;
    private final String file;
    private final String mappings;
    private final String[] sources;
    private final String[] sourcesContent;
    private final String[] names;
    private final List<SourceMapSection> sections;
    private final Map<String, Object> extensions;

    private SourceMapObject(int version, int lineCount, String sourceRoot, String file, String mappings, String[] sources, String[] sourcesContent, String[] names, List<SourceMapSection> sections, Map<String, Object> extensions) {
        this.version = version;
        this.lineCount = lineCount;
        this.sourceRoot = sourceRoot;
        this.file = file;
        this.mappings = mappings;
        this.sources = sources;
        this.sourcesContent = sourcesContent;
        this.names = names;
        this.sections = sections;
        this.extensions = extensions;
    }

    public int getVersion() {
        return this.version;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public String getSourceRoot() {
        return this.sourceRoot;
    }

    public String getFile() {
        return this.file;
    }

    public String getMappings() {
        return this.mappings;
    }

    public String[] getSources() {
        return this.sources;
    }

    public String[] getSourcesContent() {
        return this.sourcesContent;
    }

    public String[] getNames() {
        return this.names;
    }

    public List<SourceMapSection> getSections() {
        return this.sections;
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private int version;
        private int lineCount;
        private String sourceRoot;
        private String file;
        private String mappings;
        private String[] sources;
        private String[] sourcesContent;
        private String[] names;
        private List<SourceMapSection> sections;
        private Map<String, Object> extensions;

        Builder() {
        }

        public Builder setVersion(int version) {
            this.version = version;
            return this;
        }

        public Builder setLineCount(int lineCount) {
            this.lineCount = lineCount;
            return this;
        }

        public Builder setSourceRoot(String sourceRoot) {
            this.sourceRoot = sourceRoot;
            return this;
        }

        public Builder setFile(String file) {
            this.file = file;
            return this;
        }

        public Builder setMappings(String mappings) {
            this.mappings = mappings;
            return this;
        }

        public Builder setSources(String[] sources) {
            this.sources = sources;
            return this;
        }

        public Builder setSourcesContent(String[] sourcesContent) {
            this.sourcesContent = sourcesContent;
            return this;
        }

        public Builder setNames(String[] names) {
            this.names = names;
            return this;
        }

        public Builder setSections(List<SourceMapSection> sections) {
            this.sections = sections;
            return this;
        }

        public Builder setExtensions(Map<String, Object> extensions) {
            this.extensions = extensions;
            return this;
        }

        public SourceMapObject build() {
            return new SourceMapObject(this.version, this.lineCount, this.sourceRoot, this.file, this.mappings, this.sources, this.sourcesContent, this.names, this.sections, this.extensions);
        }
    }
}

