/*
 * Isomorphic SmartGWT web presentation layer
 * Copyright 2000 and beyond Isomorphic Software, Inc.
 *
 * OWNERSHIP NOTICE
 * Isomorphic Software owns and reserves all rights not expressly granted in this source code,
 * including all intellectual property rights to the structure, sequence, and format of this code
 * and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.
 *
 *  If you have any questions, please email <sourcecode@isomorphic.com>.
 *
 *  This entire comment must accompany any portion of Isomorphic Software source code that is
 *  copied or moved from this file.
 */
package com.smartgwt.sample.showcase.client.componentXML.applications;

import com.smartgwt.client.rpc.LoadScreenCallback;
import com.smartgwt.client.rpc.RPCManager;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;
import com.smartgwt.sample.showcase.client.SourceEntity;

public class OrderManagmentAppSampleXML extends ShowcasePanel {

    private static final String DESCRIPTION =
        "This application shows you how to use aggregation to produce a simple Dashboard of "+
        "information showing the totals of different order statuses, using workflows, has full order "+
        "management built in (add, remove, update and fetch/fetch related data), how to embed screens "+
        "within grids (using grid expansion features), and much more."+
        "<P>"+
        "To add an order, just click the + icon above the grid, add your order, and hit Save to see your "+
        "new order in the grid. Also, see how the notifications that appear show the details of your newly created order."+
        "<P>"+
        "Click the right arrow next to any row in the grid and see all of the order lines for this order."+
        "<P>"+
        "Double-clicking any record allows you to edit that order. Try double-clicking a shipped order and notice how "+
        "all of the fields are read-only.";

    public static class Factory implements PanelFactory {

        private String id;

        public ShowcasePanel create() {
            OrderManagmentAppSampleXML panel = new OrderManagmentAppSampleXML();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    @Override
    protected boolean isTopIntro() {
        return true;
    }

    public Canvas getViewPanel() {
        final Canvas layout = new Canvas();
        layout.setHeight100();
        layout.setWidth100();
        RPCManager.loadScreen("orderManagementApp", new LoadScreenCallback() {
            @Override
            public void execute() {
                layout.addChild(this.getScreen());
                RPCManager.cacheScreens(new String[] {"orderLinesSubset"}, null);
            }
        });
        return layout;
    }

    @Override
    public String getIntro() {
        return DESCRIPTION;
    }
    
    @Override
    protected boolean isFullscreenMode() {
        return true;
    }

    @Override
    public SourceEntity[] getSourceUrls() {
        return new SourceEntity[]{
            new SourceEntity("orderManagementApp.ui.xml", XML, "source/orderManagementApp.ui.xml.html", true),
            new SourceEntity("orderLinesSubset.ui.xml", XML, "source/orderLinesSubset.ui.xml.html", true),
            new SourceEntity("ord_Product.ds.xml", XML, "source/ord_Product.ds.xml.html", true),
            new SourceEntity("ord_Customer.ds.xml", XML, "source/ord_Customer.ds.xml.html", true),
            new SourceEntity("ord_Order.ds.xml", XML, "source/ord_Order.ds.xml.html", true),
            new SourceEntity("ord_OrderLine.ds.xml", XML, "source/ord_OrderLine.ds.xml.html", true)
        };
    }
}
