/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.widgets.calendar.events;

import com.smartgwt.client.event.*;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.HasHandlers;
public interface HasEventSaveErrorHandlers extends HasHandlers {
    /**
     * Notification method fired when an attempt to save {@link com.smartgwt.client.widgets.calendar.CalendarEvent an event}
     * following edits or drag-movements results in an error from the server.  May be overridden  to handle specific errors and
     * provide feedback to the user or push a server-provided record to client caches with a call to {@link
     * com.smartgwt.client.data.DataSource#updateCaches updateCaches()}, for example. <p> The <code>scenarioCode</code>
     * parameter may be used to determine  {@link com.smartgwt.client.types.CalendarSaveScenario how the save was initiated}.
     * <p> Return <i>false</i> from this method to cancel builtin behavior, which is as follows: <p> If a save happened because
     * an event-canvas was moved or sized with the mouse, and any kind  of error occurs, the event is  restored to it's
     * pre-save position - if this method specifically returns <i>true</i>, the  errors are also sent to {@link
     * com.smartgwt.client.docs.ErrorHandling central error handling},  which will show them to the user in a simple error
     * dialog. <p> If a save happened because an event was edited in the {@link
     * com.smartgwt.client.widgets.calendar.Calendar#getEventDialog eventDialog} or  {@link
     * com.smartgwt.client.widgets.calendar.Calendar#getEventEditor eventEditor} windows and a validation error occurs, the
     * window is re-opened for  editing with the validation errors visible.  If any other kind of error occurs, the window will
     * not be re-opened and, if this method specifically returns <i>true</i>, the error will  be sent to {@link
     * com.smartgwt.client.docs.ErrorHandling central error handling} which will show a  simple error dialog to the end user. 
     * <p> In all cases, if the server returned an updated record despite the save failing (eg, perhaps  the server enforces
     * optimistic locking and the underlying record has been changed by another  user), it is assumed to be a latest-version of
     * the record and is applied instead of the  original record during those builtin UI processes.  So, the {@link
     * com.smartgwt.client.widgets.calendar.Calendar#getEventEditor eventEditor} and  {@link
     * com.smartgwt.client.widgets.calendar.Calendar#getEventDialog eventDialog} will show any changes from the latest-record. 
     * If the  save was caused by dragging an event and the event's {@link
     * com.smartgwt.client.widgets.calendar.Calendar#getStartDateField start} or  {@link
     * com.smartgwt.client.widgets.calendar.Calendar#getEndDateField end} dates are different in the latest-record,  the
     * EventCanvas will be positioned using the latest values, instead of returning to  it's pre-save position on-screen.
     *
     * @param handler the eventSaveError handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    HandlerRegistration addEventSaveErrorHandler(EventSaveErrorHandler handler);
}
